/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.translators;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.BSEProperties;
import org.scidac.cmcs.tools.bse.Matrix;
import org.scidac.cmcs.tools.bse.translators.AbstractBasisSetXmlToText;

public class BasisXmlToDeMon2001Input
extends AbstractBasisSetXmlToText {
    protected String mTitle = "";
    protected int mShellCounter = 0;
    protected int mBufOffset = 0;
    protected int mPrevGlobalShellCounter = 0;

    @Override
    public String convert(String data, Vector elementList, boolean optimize) throws IOException, FormatException {
        this.mBufOffset = 0;
        this.mPrevGlobalShellCounter = 0;
        this.enableSplitSP();
        String outputStr = this.readBasisSet(data, elementList, optimize);
        StringBuffer output = new StringBuffer(outputStr);
        if (this.mGlobalShellCounter != 0 && this.mBufOffset != 0) {
            int startindex = this.mBufOffset;
            int endindex = output.indexOf("\n", startindex);
            output.replace(startindex, endindex, "    " + this.mPrevGlobalShellCounter);
        }
        return output.toString();
    }

    @Override
    protected void addHeader(StringBuffer output, Element root) throws FormatException {
        this.mTitle = root.getChildText("title", BSEProperties.mDcNs);
        String harmonicType = root.getChildText("harmonicType", BSEProperties.mBseNs);
        output.append("\n# This basis set uses " + harmonicType + " components\n");
    }

    @Override
    protected void addFooter(StringBuffer output) throws FormatException {
    }

    @Override
    protected void addElementDescription(StringBuffer output, String element, Element contractions) {
        String elementName = this.mPertable.name(this.mPertable.atomicNumber(element));
        output.append("O-" + elementName.toUpperCase());
        output.append(" " + element);
        String finalTitle = new String();
        String[] titleTokens = this.mTitle.split("[\\(\\)\\s]");
        for (int i = 0; i < titleTokens.length; ++i) {
            if (titleTokens[i] == null || "".equals(titleTokens[i])) continue;
            finalTitle = finalTitle + titleTokens[i];
            if (i == titleTokens.length - 1) continue;
            finalTitle = finalTitle + "-";
        }
        output.append(" (" + finalTitle + ")\n#\n");
        List descriptionList = contractions.getChildren("description", BSEProperties.mDcNs);
        Iterator iterator = descriptionList.iterator();
        boolean first = true;
        while (iterator.hasNext()) {
            Element description = (Element)iterator.next();
            if (first) {
                output.append("# Primary Functions: ");
            } else {
                output.append("# Augmenting Functions: ");
            }
            output.append(description.getValue() + "\n");
            first = false;
        }
    }

    @Override
    protected void readCmlMatrix(StringBuffer output, Vector matrices, String element, String shell) throws FormatException {
        this.mShellCounter = this.mGlobalShellCounter == 0 ? 0 : ++this.mShellCounter;
        if (this.mGlobalShellCounter == 0) {
            if (this.mBufOffset != 0) {
                int startindex = this.mBufOffset;
                int endindex = output.indexOf("\n", startindex);
                output.replace(startindex, endindex, "    " + this.mPrevGlobalShellCounter);
            }
            this.mBufOffset = output.length();
            output.append("    0\n");
        }
        int localShellCount = 1;
        if (shell == "P") {
            localShellCount = 2;
        } else if (shell == "D") {
            localShellCount = 3;
        }
        for (int k = 0; k < matrices.size(); ++k) {
            Matrix matrix = (Matrix)matrices.get(k);
            int rows = matrix.getNumRows();
            int columns = matrix.getNumColumns();
            Matrix[] matricesList = this.splitMatrixNcolumnTo2column(matrix);
            try {
                for (int m = 0; m < matricesList.length; ++m) {
                    int rows2 = matricesList[m].getNumRows();
                    int columns2 = matricesList[m].getNumColumns();
                    this.mPrevGlobalShellCounter = ++this.mGlobalShellCounter;
                    output.append("    " + localShellCount++);
                    output.append("    " + this.mShellCounter);
                    output.append("    " + rows2 + "\n");
                    for (int i = 0; i < rows2; ++i) {
                        for (int j = 0; j < columns2; ++j) {
                            String value = this.formattedValue(matricesList[m].getValue(i, j));
                            output.append(value);
                        }
                        output.append("\n");
                    }
                }
                continue;
            }
            catch (IndexOutOfBoundsException ie) {
                throw new FormatException(ie.getMessage());
            }
        }
    }
}

