/*
 * Copyright (c) 2005, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package sun.net.httpserver;

import java.util.Objects;

abstract sealed class Event {

    final ExchangeImpl exchange;

    protected Event(ExchangeImpl t) {
        this.exchange = t;
    }

    /**
     * Stopping event for the http server.
     * The event applies to the whole server and is not tied to any particular
     * exchange.
     */
    static final class StopRequested extends Event {
        StopRequested() {
            super(null);
        }
    }

    /**
     * Event indicating that the exchange is finished,
     * without having necessarily read the complete
     * request or sent the complete response.
     * Typically, this event is posted when invoking
     * the filter chain throws an exception.
     */
    static final class ExchangeFinished extends Event {
        ExchangeFinished(ExchangeImpl t) {
            super(Objects.requireNonNull(t));
        }
    }
}
