%feature("docstring") OT::WeibullMaxFactory
R"RAW(WeibullMax factory.

See also
--------
DistributionFactory, WeibullMax

Notes
-----
Note that if :math:`X` follows a WeibullMax :math:`(\beta, \alpha, \gamma)` distribution, then  :math:`(-X)` follows a WeibullMin :math:`(\beta, \alpha, -\gamma)` distribution.)RAW"

// ----------------------------------------------------------------------------

%feature("docstring") OT::WeibullMaxFactory::build
R"RAW(Estimate the distribution using the default strategy.


**Available usages**:

    build(*sample*)

    build(*param*)

Parameters
----------
sample : 2-d sequence of float
    Data.
param : Collection of  :class:`~openturns.PointWithDescription`
    A vector of parameters of the distribution.

Returns
-------
distribution : :class:`~openturns.Distribution`
    The estimated distribution

Notes
-----
Note that if :math:`X` follows a WeibullMax :math:`(\beta, \alpha, \gamma)` distribution, then  :math:`(-X)`follows a WeibullMin :math:`(\beta, \alpha, -\gamma)` distribution.
The sample is transformed into its opposite and a WeibullMin :math:`(\beta, \alpha, \gamma)` is fitted on it. We return the WeibullMax :math:`(\beta, \alpha, -\gamma)` distribution.
We use the default strategy of  :class:`~openturns.WeibullMinFactory`.)RAW"
// ----------------------------------------------------------------------------

%feature("docstring") OT::WeibullMaxFactory::buildAsWeibullMax
"Estimate the distribution as native distribution.

**Available usages**:

    buildAsWeibullMax()

    buildAsWeibullMax(*sample*)

    buildAsWeibullMax(*param*)

Parameters
----------
sample : 2-d sequence of float
    Data.
param : sequence of float
    The parameters of the :class:`~openturns.WeibullMax`.

Returns
-------
dist : :class:`~openturns.WeibullMax`
    The estimated distribution as a WeibullMax.
    
    In the first usage, the default WeibullMax distribution is built."
