# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ClientAccessRight(Model):
    """The mapping between a particular client IP and the type of access client
    has on the NFS share.

    All required parameters must be populated in order to send to Azure.

    :param client: Required. IP of the client.
    :type client: str
    :param access_permission: Required. Type of access to be allowed for the
     client. Possible values include: 'NoAccess', 'ReadOnly', 'ReadWrite'
    :type access_permission: str or
     ~azure.mgmt.edgegateway.models.ClientPermissionType
    """

    _validation = {
        'client': {'required': True},
        'access_permission': {'required': True},
    }

    _attribute_map = {
        'client': {'key': 'client', 'type': 'str'},
        'access_permission': {'key': 'accessPermission', 'type': 'str'},
    }

    def __init__(self, *, client: str, access_permission, **kwargs) -> None:
        super(ClientAccessRight, self).__init__(**kwargs)
        self.client = client
        self.access_permission = access_permission
