use strict;
use warnings;

use RT::Test tests => undef;

my $user = RT::Test->load_or_create_user( Name => 'testuser' );
ok $user->id, "Created user: ".$user->id;

my $class = RT::Class->new( RT->SystemUser );
my ($ok, $msg) = $class->Create( Name => 'recipes' );
ok $ok, "Created class: $msg";

ok(
    RT::Test->set_rights(
        Principal   => 'Privileged',
        Right       => [qw/SeeClass/],
        Object      => $class,
    ),
    "Granted SeeClass on the Class"
);

my $article = RT::Article->new( RT::CurrentUser->new($user) );
($ok, $msg) = $article->Create( Class => 'recipes', Name => 'ricotta raspberry buttermilk scones' );
ok !$ok, "Can't create article: $msg";

ok(
    RT::Test->add_rights(
        Principal   => 'Privileged',
        Right       => [qw/CreateArticle/],
        Object      => $class,
    ),
    "Granted CreateArticle on the Class"
);

($ok, $msg) = $article->Create( Class => 'recipes', Name => 'ricotta raspberry buttermilk scones' );
ok $ok, "Created article: $msg";

($ok, $msg) = $article->SetSummary("a tasty morning treat");
ok !$ok, "Can't update Summary: $msg";

ok(
    RT::Test->add_rights(
        Principal   => 'Privileged',
        Right       => [qw/ModifyArticle/],
        Object      => $class,
    ),
    "Granted ModifyArticle on the Class"
);

($ok, $msg) = $article->SetSummary("a tasty morning treat");
ok $ok, "Updated Summary: $msg";

done_testing;
