/*
 * NetHSM
 *
 * All endpoints expect exactly the specified JSON. Additional properties will cause a Bad Request Error (400). All HTTP errors contain a JSON structure with an explanation of type string. All [base64](https://tools.ietf.org/html/rfc4648#section-4) encoded values are Big Endian.
 *
 * The version of the OpenAPI document: v1
 * Contact: Nitrokey <info@nitrokey.com>
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
#[non_exhaustive]
pub enum DecryptMode {
    #[serde(rename = "RAW")]
    Raw,
    #[serde(rename = "PKCS1")]
    Pkcs1,
    #[serde(rename = "OAEP_MD5")]
    OaepMd5,
    #[serde(rename = "OAEP_SHA1")]
    OaepSha1,
    #[serde(rename = "OAEP_SHA224")]
    OaepSha224,
    #[serde(rename = "OAEP_SHA256")]
    OaepSha256,
    #[serde(rename = "OAEP_SHA384")]
    OaepSha384,
    #[serde(rename = "OAEP_SHA512")]
    OaepSha512,
    #[serde(rename = "AES_CBC")]
    AesCbc,
}

impl std::fmt::Display for DecryptMode {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "{}",
            match self {
                Self::Raw => "RAW",
                Self::Pkcs1 => "PKCS1",
                Self::OaepMd5 => "OAEP_MD5",
                Self::OaepSha1 => "OAEP_SHA1",
                Self::OaepSha224 => "OAEP_SHA224",
                Self::OaepSha256 => "OAEP_SHA256",
                Self::OaepSha384 => "OAEP_SHA384",
                Self::OaepSha512 => "OAEP_SHA512",
                Self::AesCbc => "AES_CBC",
            }
        )
    }
}

impl Default for DecryptMode {
    fn default() -> DecryptMode {
        Self::Raw
    }
}
