/*
 * NetHSM
 *
 * All endpoints expect exactly the specified JSON. Additional properties will cause a Bad Request Error (400). All HTTP errors contain a JSON structure with an explanation of type string. All [base64](https://tools.ietf.org/html/rfc4648#section-4) encoded values are Big Endian.
 *
 * The version of the OpenAPI document: v1
 * Contact: Nitrokey <info@nitrokey.com>
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
#[non_exhaustive]
pub enum KeyType {
    #[serde(rename = "RSA")]
    Rsa,
    #[serde(rename = "Curve25519")]
    Curve25519,
    #[serde(rename = "EC_P256")]
    EcP256,
    #[serde(rename = "EC_P384")]
    EcP384,
    #[serde(rename = "EC_P521")]
    EcP521,
    #[serde(rename = "EC_P256K1")]
    EcP256K1,
    #[serde(rename = "BrainpoolP256")]
    BrainpoolP256,
    #[serde(rename = "BrainpoolP384")]
    BrainpoolP384,
    #[serde(rename = "BrainpoolP512")]
    BrainpoolP512,
    #[serde(rename = "Generic")]
    Generic,
}

impl std::fmt::Display for KeyType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "{}",
            match self {
                Self::Rsa => "RSA",
                Self::Curve25519 => "Curve25519",
                Self::EcP256 => "EC_P256",
                Self::EcP384 => "EC_P384",
                Self::EcP521 => "EC_P521",
                Self::EcP256K1 => "EC_P256K1",
                Self::BrainpoolP256 => "BrainpoolP256",
                Self::BrainpoolP384 => "BrainpoolP384",
                Self::BrainpoolP512 => "BrainpoolP512",
                Self::Generic => "Generic",
            }
        )
    }
}

impl Default for KeyType {
    fn default() -> KeyType {
        Self::Rsa
    }
}
