/*
 * NetHSM
 *
 * All endpoints expect exactly the specified JSON. Additional properties will cause a Bad Request Error (400). All HTTP errors contain a JSON structure with an explanation of type string. All [base64](https://tools.ietf.org/html/rfc4648#section-4) encoded values are Big Endian.
 *
 * The version of the OpenAPI document: v1
 * Contact: Nitrokey <info@nitrokey.com>
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
#[non_exhaustive]
pub struct PublicKey {
    #[serde(rename = "mechanisms")]
    pub mechanisms: Vec<crate::models::KeyMechanism>,
    #[serde(rename = "type")]
    pub r#type: crate::models::KeyType,
    #[serde(rename = "restrictions")]
    pub restrictions: Box<crate::models::KeyRestrictions>,
    #[serde(rename = "public", skip_serializing_if = "Option::is_none")]
    pub public: Option<Box<crate::models::KeyPublicData>>,
    #[serde(rename = "operations")]
    pub operations: i32,
}

impl PublicKey {
    pub fn new(
        mechanisms: Vec<crate::models::KeyMechanism>,
        r#type: crate::models::KeyType,
        restrictions: crate::models::KeyRestrictions,
        operations: i32,
    ) -> PublicKey {
        PublicKey {
            mechanisms,
            r#type,
            restrictions: Box::new(restrictions),
            public: None,
            operations,
        }
    }
}
