---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, caractères, points de suspension, symbole
---

# Comment obtenir des points de suspension ?

Pour obtenir un espacement correct des [points de suspension](wpfr:Points%20de%20suspension), 
il est recommandé d'utiliser la commande `\dots{}` 
(les accolades évitant toute problématique d'espace à la suite de la commande). 
L'exemple ci-dessous montre que, sans cette commande, les points sont plus rapprochés.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Ceci est un exemple\dots{} exemplaire. Et voici ce qu'il faut éviter...
\end{document}
```

:::{seealso}
En mode mathématique, d'autres versions de points de suspension existent. 
Elles sont décrites dans la question 
"[](/4_domaines_specialises/mathematiques/structures/points_de_suspension_mathematiques)".
:::