// @HEADER
// *****************************************************************************
//        MueLu: A package for multigrid based preconditioning
//
// Copyright 2012 NTESS and the MueLu contributors.
// SPDX-License-Identifier: BSD-3-Clause
// *****************************************************************************
// @HEADER

#ifndef PACKAGES_MUELU_SRC_REBALANCING_MUELU_CLONEREPARTITIONINTERFACE_DECL_HPP_
#define PACKAGES_MUELU_SRC_REBALANCING_MUELU_CLONEREPARTITIONINTERFACE_DECL_HPP_

#include <Xpetra_Map_fwd.hpp>
#include <Xpetra_Matrix_fwd.hpp>
#include <Xpetra_VectorFactory_fwd.hpp>

#include "MueLu_SingleLevelFactoryBase.hpp"

#include "MueLu_Level_fwd.hpp"
#include "MueLu_FactoryBase_fwd.hpp"

namespace MueLu {

/*!
  @class CloneRepartitionInterface
  @brief Helper class which transforms an "Partition" array generated from a block in a blocked operator to a new "Partition" vector for another compatible block in the blocked operator.

  This class is meant to be used with another {Zoltan,Zoltan2,Isorropia,...}Interface class which generates a "Partition" vector for a specific block to be rebalanced.
  This class reuses the rebalancing and creates a compatible "Partition" array for another block.

  @note This class is used for blocked operators only.

  ## Input/output of CloneRepartitionInterface ##

  ### User parameters of CloneRepartitionInterface ###
  Parameter | type | default | master.xml | validated | requested | description
  ----------|------|---------|:----------:|:---------:|:---------:|------------
  | A                                      | Factory | null  |   | * | * | Generating factory of the matrix A used during the prolongator smoothing process (must be of type SubBlockAFactory representing the corresponding diagonal block in the blocked operator) |
  | number of partitions                   | GO      | - |  | * | * | Short-cut parameter set by RepartitionFactory. Avoid repartitioning algorithms if only one partition is necessary (not used in this factory)
  | Partition | null |  | * | * | Factory generating the Partition array (e.g. ZoltanInterface) associated with the sub block in the blocked operator which partitioning information shall to be cloned

  The * in the @c master.xml column denotes that the parameter is defined in the @c master.xml file.<br>
  The * in the @c validated column means that the parameter is declared in the list of valid input parameters (see CloneRepartitionInterface::GetValidParameters).<br>
  The * in the @c requested column states that the data is requested as input with all dependencies (see CloneRepartitionInterface::DeclareInput).

  ### Variables provided by CloneRepartitionInterface ###

  After CloneRepartitionInterface::Build the following data is available (if requested)

  Parameter | generated by | description
  ----------|--------------|------------
  | Partition       | CloneRepartitionInterface   | GOVector based on the Row map of A (DOF-based) containing the process id the DOF should be living in after rebalancing/repartitioning

*/

template <class Scalar        = DefaultScalar,
          class LocalOrdinal  = DefaultLocalOrdinal,
          class GlobalOrdinal = DefaultGlobalOrdinal,
          class Node          = DefaultNode>
class CloneRepartitionInterface : public SingleLevelFactoryBase {
#undef MUELU_CLONEREPARTITIONINTERFACE_SHORT
#include "MueLu_UseShortNames.hpp"

 public:
  //! @name Constructors/Destructors
  //@{

  //! Constructor
  CloneRepartitionInterface() {}

  //! Destructor
  virtual ~CloneRepartitionInterface() {}
  //@}

  RCP<const ParameterList> GetValidParameterList() const;

  //! @name Input
  //@{
  void DeclareInput(Level &level) const;
  //@}

  //! @name Build methods.
  //@{
  void Build(Level &level) const;

  //@}

 private:
};  // class CloneRepartitionInterface

}  // namespace MueLu

#define MUELU_CLONEREPARTITIONINTERFACE_SHORT

#endif /* PACKAGES_MUELU_SRC_REBALANCING_MUELU_CLONEREPARTITIONINTERFACE_DECL_HPP_ */
