
/*
This file contains tables for Ramachandran evaluation.
This file is generated by the following procedure, don't edit it manually
and keep consistent with the template there:
mmtbx/validation/ramachandran/convert_from_text.py
*/
#include <vector>
#include <scitbx/array_family/shared.h>
#include <scitbx/array_family/versa.h>
#include <scitbx/array_family/accessors/c_grid.h>


namespace mmtbx { namespace validation { namespace ramachandran {

#define RAMA_GENERAL  0
#define RAMA_GLYCINE  1
#define RAMA_CISPRO   2
#define RAMA_TRANSPRO 3
#define RAMA_PREPRO   4
#define RAMA_ILE_VAL  5

#define RAMALYZE_OUTLIER  0
#define RAMALYZE_ALLOWED  1
#define RAMALYZE_FAVORED  2
#define RAMALYZE_ANY      3
#define RAMALYZE_NOT_FAVORED 4

  const std::string res_types[] = {"general", "glycine", "cis-proline",
    "trans-proline", "pre-proline", "isoleucine or valine"};

  const double linear_table_general[] = {0.00556027,0.00457123,0.00366791,0.00271184,0.00196865,0.00141762,0.00099563,0.000746016,0.000536906,
0.000390905,0.000338156,0.000303305,0.000272221,0.00024773,0.000232659,0.000204401,0.000182736,0.000159188,
0.000135639,0.000118684,9.51359e-05,7.62971e-05,6.40519e-05,5.55744e-05,4.80389e-05,4.14454e-05,3.01421e-05,
2.63743e-05,2.16646e-05,1.88388e-05,1.41291e-05,1.31872e-05,1.13033e-05,1.31872e-05,1.41291e-05,1.5071e-05,
1.78969e-05,1.88388e-05,1.97807e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.54324e-05,
2.63743e-05,2.82582e-05,3.67357e-05,4.14454e-05,4.7097e-05,5.18067e-05,5.93422e-05,6.49938e-05,7.34713e-05,
7.72391e-05,8.28907e-05,9.04262e-05,9.60779e-05,0.000101729,0.000105497,0.000105497,0.000105497,0.000105497,
0.000105497,0.000102671,9.89037e-05,9.51359e-05,9.3252e-05,8.85423e-05,8.38326e-05,8.00649e-05,7.8181e-05,
7.62971e-05,6.97035e-05,6.59358e-05,6.12261e-05,5.84003e-05,5.08647e-05,4.99228e-05,4.80389e-05,4.7097e-05,
4.7097e-05,4.80389e-05,4.99228e-05,5.08647e-05,5.55744e-05,5.84003e-05,6.02841e-05,6.2168e-05,6.311e-05,
6.311e-05,6.02841e-05,5.84003e-05,5.08647e-05,4.80389e-05,4.23873e-05,3.57937e-05,2.73163e-05,2.54324e-05,
2.16646e-05,2.07227e-05,1.88388e-05,1.78969e-05,1.78969e-05,1.69549e-05,1.78969e-05,2.07227e-05,2.16646e-05,
2.73163e-05,3.1084e-05,4.05034e-05,4.33292e-05,4.80389e-05,4.80389e-05,4.99228e-05,5.27486e-05,5.93422e-05,
6.87616e-05,8.00649e-05,9.60779e-05,0.000112091,0.000123394,0.000129988,0.000137523,0.000144117,0.000146001,
0.000143175,0.000137523,0.000134697,0.000134697,0.000135639,0.000146001,0.000153536,0.000174259,0.000195923,
0.000224182,0.00024302,0.000271279,0.000295769,0.000312724,0.000325911,0.000339098,0.000356995,0.000385253,
0.000438944,0.000516183,0.000578351,0.00062168,0.000666893,0.000719642,0.000785578,0.000852455,0.000917449,
0.000970198,0.00104273,0.00112468,0.0012038,0.00126691,0.00136487,0.00150145,0.00168419,0.00204307,0.00255642,
0.00329396,0.00413135,0.00490562,0.00595871,0.00721903,0.00828059,0.00963699,0.011162,0.0129752,0.0150343,
0.0161637,0.0158368,0.0142261,0.0121944,0.0102427,0.00846521,0.00701934,0.0086941,0.00717099,0.00555839,
0.00439886,0.00333823,0.00228232,0.00154949,0.00107004,0.000813836,0.000617912,0.000494518,0.00040315,
0.000355111,0.00032026,0.000293885,0.000262801,0.000233601,0.000199691,0.000174259,0.000151652,0.000123394,
0.000106439,8.28907e-05,7.34713e-05,6.311e-05,5.55744e-05,4.80389e-05,4.05034e-05,2.82582e-05,2.54324e-05,
2.16646e-05,2.07227e-05,1.97807e-05,2.07227e-05,2.07227e-05,2.16646e-05,2.35485e-05,2.54324e-05,2.54324e-05,
2.63743e-05,2.63743e-05,2.73163e-05,2.73163e-05,2.73163e-05,3.01421e-05,3.67357e-05,4.05034e-05,4.33292e-05,
4.99228e-05,5.65164e-05,6.311e-05,6.87616e-05,7.62971e-05,8.76004e-05,9.60779e-05,0.000105497,0.000111149,
0.000117742,0.000118684,0.000120568,0.00012151,0.000120568,0.000120568,0.000118684,0.000117742,0.000115859,
0.000112091,0.000111149,0.000109265,0.000105497,0.000105497,9.98456e-05,9.3252e-05,8.57165e-05,7.91229e-05,
7.53552e-05,6.87616e-05,6.40519e-05,6.2168e-05,5.93422e-05,5.84003e-05,5.84003e-05,5.93422e-05,6.311e-05,
6.59358e-05,6.87616e-05,7.53552e-05,7.62971e-05,7.91229e-05,7.91229e-05,7.91229e-05,7.62971e-05,7.53552e-05,
6.87616e-05,6.311e-05,5.93422e-05,5.08647e-05,4.7097e-05,4.14454e-05,3.95615e-05,3.1084e-05,2.82582e-05,
2.73163e-05,2.73163e-05,2.73163e-05,2.82582e-05,3.67357e-05,4.23873e-05,4.80389e-05,5.55744e-05,6.311e-05,
6.78197e-05,7.53552e-05,7.62971e-05,7.8181e-05,8.19488e-05,9.3252e-05,0.000105497,0.000118684,0.000128104,
0.000146001,0.000153536,0.000169549,0.000177085,0.00018462,0.00018933,0.000190272,0.000190272,0.00018933,
0.00018933,0.000192156,0.000199691,0.000226066,0.000254324,0.000297653,0.000336272,0.000377718,0.000417279,
0.000460609,0.000494518,0.000516183,0.000536906,0.000565164,0.00062639,0.000722468,0.000826081,0.000910856,
0.00096643,0.00103802,0.00113033,0.00124242,0.00135734,0.00146566,0.00156268,0.00166064,0.0017473,0.00182925,
0.00199597,0.00221262,0.00262801,0.0032431,0.00393448,0.00460326,0.00541427,0.00672262,0.00796975,0.0095362,
0.0114286,0.0136204,0.0162485,0.0186598,0.0211268,0.0234675,0.0247627,0.0242041,0.0218351,0.0190658,0.0163389,
0.0132917,0.0106938,0.0129846,0.0102125,0.0081751,0.00650598,0.00488207,0.00375551,0.00253288,0.00167383,
0.00120192,0.000924985,0.000769565,0.00062168,0.000527486,0.000428583,0.000373008,0.000333447,0.000296711,
0.00025244,0.000219472,0.000186504,0.000157304,0.00013093,0.000114917,9.3252e-05,7.91229e-05,6.87616e-05,
6.2168e-05,5.27486e-05,4.42712e-05,4.05034e-05,2.82582e-05,2.73163e-05,2.63743e-05,2.63743e-05,2.73163e-05,
2.73163e-05,3.01421e-05,3.48518e-05,3.95615e-05,4.05034e-05,4.14454e-05,4.23873e-05,4.23873e-05,4.33292e-05,
4.7097e-05,4.99228e-05,5.18067e-05,5.84003e-05,6.311e-05,6.87616e-05,7.72391e-05,8.85423e-05,0.000102671,
0.000112091,0.000119626,0.000123394,0.000129988,0.000134697,0.000137523,0.000140349,0.000141291,0.000138465,
0.000135639,0.000133755,0.000129988,0.000129988,0.000127162,0.000125278,0.000123394,0.000123394,0.00012151,
0.000120568,0.000117742,0.000111149,0.000105497,9.60779e-05,8.85423e-05,8.00649e-05,7.62971e-05,7.53552e-05,
7.15874e-05,7.15874e-05,7.53552e-05,7.62971e-05,8.19488e-05,9.04262e-05,9.79617e-05,0.000105497,0.000105497,
0.000106439,0.000105497,0.000104555,9.98456e-05,9.3252e-05,8.47746e-05,7.8181e-05,7.53552e-05,6.87616e-05,
6.49938e-05,6.2168e-05,5.93422e-05,5.84003e-05,5.55744e-05,5.18067e-05,5.08647e-05,5.55744e-05,5.93422e-05,
6.59358e-05,7.62971e-05,8.76004e-05,0.000101729,0.000111149,0.000118684,0.00012151,0.000123394,0.000129988,
0.000137523,0.000149768,0.000157304,0.000171433,0.00018462,0.000195923,0.000217588,0.000232659,0.000237369,
0.000244904,0.000251498,0.000258091,0.000262801,0.000266569,0.000275046,0.000297653,0.000326853,0.000379602,
0.00047097,0.000580235,0.000664068,0.000746016,0.000800649,0.00082043,0.000829849,0.000861875,0.000901436,
0.000964546,0.00108511,0.00124713,0.00139313,0.00154196,0.0016889,0.00187823,0.00213349,0.00234731,0.00259128,
0.00279474,0.0029511,0.00307638,0.00321955,0.00348047,0.00400795,0.00467673,0.00554803,0.00679704,0.00788309,
0.00909631,0.0105996,0.0126738,0.0156946,0.019225,0.0226781,0.0257988,0.0287094,0.0316991,0.0345277,0.0356449,
0.0344307,0.0312611,0.0274142,0.0238584,0.0204015,0.0167628,0.0192062,0.0150286,0.0114389,0.00892394,
0.00699955,0.00513075,0.00392035,0.0026704,0.00180381,0.0013611,0.0010691,0.00090803,0.000773333,0.000628274,
0.00053408,0.000427641,0.000363589,0.000317434,0.000265627,0.000227007,0.000190272,0.000159188,0.000134697,
0.000118684,0.000105497,8.85423e-05,7.62971e-05,6.78197e-05,5.93422e-05,5.08647e-05,4.42712e-05,4.14454e-05,
4.05034e-05,4.05034e-05,4.14454e-05,4.23873e-05,4.7097e-05,4.99228e-05,5.08647e-05,5.55744e-05,5.84003e-05,
5.93422e-05,6.2168e-05,6.311e-05,6.49938e-05,6.68777e-05,7.15874e-05,7.62971e-05,8.00649e-05,9.3252e-05,
0.000106439,0.000118684,0.000125278,0.000134697,0.000146001,0.000151652,0.000153536,0.000159188,0.000161072,
0.000162014,0.000162014,0.000161072,0.000159188,0.000153536,0.000152594,0.000151652,0.000151652,0.000149768,
0.000148826,0.000147885,0.000144117,0.000141291,0.000135639,0.000132814,0.000127162,0.000123394,0.000118684,
0.000114917,0.000106439,0.000102671,9.60779e-05,9.3252e-05,9.60779e-05,0.000103613,0.000110207,0.000117742,
0.000120568,0.000123394,0.000123394,0.000125278,0.000125278,0.000123394,0.000123394,0.00012151,0.000119626,
0.000118684,0.000115859,0.000111149,0.000109265,0.000105497,0.000102671,9.60779e-05,9.3252e-05,8.94843e-05,
8.85423e-05,9.3252e-05,0.000102671,0.000111149,0.00012151,0.000133755,0.000148826,0.000153536,0.000164839,
0.000174259,0.000177085,0.00018462,0.000192156,0.000199691,0.000215704,0.000232659,0.00024302,0.000261859,
0.00027693,0.000299537,0.000314608,0.000331563,0.000350402,0.000366415,0.000385253,0.000398441,0.000420105,
0.000468144,0.000550093,0.000643345,0.000801591,0.000925927,0.00103425,0.00115482,0.00123206,0.00126032,
0.00127068,0.00130364,0.00137806,0.00153725,0.00175295,0.00206285,0.00232282,0.00262613,0.00295487,0.00333352,
0.00373762,0.00408802,0.00435741,0.00459101,0.00477187,0.00493765,0.00522777,0.00579858,0.00689029,0.0079754,
0.00942222,0.0111837,0.0131749,0.0157191,0.0181286,0.0207067,0.0245705,0.0294658,0.0342631,0.038887,0.0433094,
0.0472477,0.0500971,0.0504701,0.0477808,0.0431748,0.0381137,0.0335858,0.0288309,0.0237633,0.0262387,0.020993,
0.0163474,0.012136,0.00921782,0.00708527,0.00511285,0.00392883,0.00276836,0.00201952,0.0015429,0.00124619,
0.000998456,0.000879772,0.000717758,0.000599074,0.00047568,0.000381486,0.00032026,0.000268453,0.00022324,
0.000187446,0.000159188,0.000137523,0.000123394,0.000112091,0.000101729,8.76004e-05,7.62971e-05,6.68777e-05,
6.2168e-05,5.65164e-05,5.18067e-05,5.08647e-05,5.55744e-05,5.84003e-05,6.2168e-05,6.59358e-05,6.87616e-05,
7.53552e-05,7.62971e-05,8.00649e-05,8.28907e-05,8.85423e-05,9.3252e-05,9.60779e-05,0.000102671,0.000108323,
0.000117742,0.000123394,0.000134697,0.000149768,0.000157304,0.000169549,0.000174259,0.00017991,0.00018462,
0.00018933,0.000190272,0.000191214,0.000191214,0.00018933,0.00018462,0.00017991,0.000177085,0.000175201,
0.000174259,0.000174259,0.000171433,0.000170491,0.000168607,0.000165781,0.000162014,0.000161072,0.000159188,
0.000153536,0.000151652,0.000148826,0.000138465,0.00013093,0.000125278,0.000123394,0.000123394,0.000124336,
0.000129988,0.000135639,0.000144117,0.000149768,0.000151652,0.000152594,0.000152594,0.000152594,0.000152594,
0.000152594,0.000153536,0.000153536,0.000153536,0.000156362,0.000156362,0.000153536,0.000152594,0.000151652,
0.000149768,0.000149768,0.000149768,0.000151652,0.000153536,0.000162956,0.000175201,0.000192156,0.000205343,
0.000219472,0.000232659,0.000237369,0.000249614,0.000262801,0.000274104,0.000290117,0.000307072,0.000321201,
0.00034004,0.000356995,0.000376776,0.000395615,0.000436118,0.000491693,0.000553861,0.000617912,0.000671603,
0.000742249,0.000800649,0.000852455,0.000918391,0.00100788,0.00122358,0.00144117,0.001671,0.00190083,
0.00207509,0.0021269,0.0021382,0.00218153,0.00232565,0.00264968,0.00305942,0.00349177,0.00392412,0.00426134,
0.00457312,0.00494801,0.00538884,0.00587017,0.00651351,0.00703817,0.00744792,0.00790099,0.00866585,0.00984421,
0.0114125,0.013449,0.0162682,0.0191525,0.0222995,0.025601,0.0286519,0.0317669,0.0365915,0.0431926,0.0507432,
0.0588675,0.0675748,0.0737944,0.0759392,0.0738198,0.0679035,0.0602587,0.052467,0.0451914,0.0385291,0.0322548,
0.0347029,0.028034,0.0219293,0.0168466,0.0122867,0.00910573,0.00688275,0.00502336,0.00397781,0.00296334,
0.00220414,0.00168419,0.00135357,0.00108511,0.000919333,0.000774274,0.000620738,0.000499228,0.000385253,
0.000317434,0.00025715,0.000214762,0.000181794,0.000157304,0.000143175,0.000128104,0.00012151,0.000112091,
0.000102671,8.85423e-05,7.8181e-05,7.53552e-05,6.87616e-05,6.78197e-05,7.06455e-05,7.62971e-05,7.91229e-05,
8.47746e-05,9.3252e-05,0.000102671,0.000109265,0.000113033,0.000118684,0.000120568,0.000123394,0.000123394,
0.000129988,0.000136581,0.000149768,0.000161072,0.000174259,0.00018933,0.000195923,0.000209111,0.000217588,
0.000222298,0.000226066,0.000229833,0.000230775,0.000229833,0.000226066,0.000222298,0.00021853,0.000214762,
0.000208169,0.000204401,0.000199691,0.000196865,0.000195923,0.000195923,0.000195923,0.000195923,0.000195923,
0.000195923,0.000195923,0.000195923,0.000192156,0.00018933,0.00017991,0.000174259,0.000165781,0.000159188,
0.000153536,0.000153536,0.000159188,0.000164839,0.000171433,0.000174259,0.000178027,0.000182736,0.00018462,
0.00018462,0.000190272,0.00019404,0.000196865,0.000206285,0.000214762,0.00021853,0.000219472,0.000219472,
0.000219472,0.000219472,0.000220414,0.000222298,0.000224182,0.000230775,0.000232659,0.000237369,0.000255266,
0.000275046,0.000303305,0.000318376,0.000334389,0.000350402,0.00036924,0.000389963,0.000417279,0.000450247,
0.000483215,0.000515241,0.000537848,0.000560454,0.00058777,0.000619796,0.000671603,0.000768623,0.00087412,
0.000955127,0.00107664,0.0012217,0.00132343,0.00138277,0.00148732,0.00165876,0.00198278,0.00238311,0.00288328,
0.0033128,0.00360857,0.00372349,0.00374421,0.00380826,0.00401737,0.00430655,0.00467108,0.00503749,0.00550187,
0.00596059,0.0065154,0.00707868,0.00763254,0.00826552,0.00912363,0.00998362,0.0109237,0.0121746,0.0140933,
0.0168654,0.0195396,0.0224219,0.0256876,0.0297229,0.0340182,0.0381241,0.0421104,0.0465073,0.05383,0.0643166,
0.0762821,0.0898224,0.103952,0.113007,0.114816,0.109208,0.0985702,0.0855733,0.07174,0.0600732,0.0510701,
0.0423666,0.0443786,0.0359359,0.0286237,0.0220696,0.0166931,0.0118647,0.00868374,0.00668683,0.00504409,
0.0041257,0.00318093,0.00233601,0.0017699,0.00140349,0.0011275,0.000935346,0.000797823,0.000628274,0.000487925,
0.000368298,0.000303305,0.00024302,0.000205343,0.000178027,0.000161072,0.000151652,0.000141291,0.000129988,
0.000122452,0.000115859,0.000105497,9.60779e-05,9.04262e-05,8.85423e-05,9.3252e-05,9.98456e-05,0.000106439,
0.000115859,0.000120568,0.000123394,0.00013093,0.000137523,0.000147885,0.000149768,0.000152594,0.000156362,
0.000162956,0.000174259,0.000190272,0.000204401,0.000224182,0.000237369,0.000253382,0.000265627,0.000274104,
0.000275046,0.000275046,0.000274104,0.000272221,0.000271279,0.000268453,0.000263743,0.000258091,0.000254324,
0.00024773,0.000240195,0.000237369,0.000236427,0.000235485,0.000236427,0.000237369,0.000237369,0.000240195,
0.00024773,0.00024773,0.00024773,0.00024773,0.000240195,0.000235485,0.000230775,0.000217588,0.000205343,
0.000195923,0.000194982,0.000195923,0.000197807,0.000206285,0.000214762,0.000219472,0.000224182,0.000232659,
0.000233601,0.000238311,0.000251498,0.000265627,0.000278814,0.000293885,0.000303305,0.000308014,0.000314608,
0.00032026,0.000325911,0.000334389,0.000339098,0.000343808,0.000347576,0.000354169,0.000363589,0.000381486,
0.00041257,0.000454015,0.000501112,0.000551035,0.000599074,0.000635809,0.000693268,0.000746958,0.000797823,
0.00082043,0.000835501,0.000850572,0.000863759,0.000886365,0.000913682,0.000964546,0.00108511,0.00128292,
0.00151087,0.00175954,0.00202988,0.00218813,0.00232471,0.00251686,0.00284183,0.00332599,0.00392412,0.00441581,
0.00484816,0.00519197,0.0053587,0.00539637,0.0054576,0.00563563,0.00610377,0.00671886,0.00725105,0.00774557,
0.0082156,0.00874308,0.00933651,0.0101334,0.0113805,0.013011,0.014909,0.0168513,0.0191233,0.0220838,0.0258186,
0.0298783,0.03368,0.0378971,0.0432953,0.0491721,0.0550168,0.0606647,0.0681748,0.0798332,0.0953959,0.11185,
0.128483,0.146508,0.159102,0.160601,0.150088,0.133569,0.115255,0.096562,0.0789807,0.0655486,0.0543631,
0.0546918,0.0441572,0.0352248,0.0275659,0.020929,0.0155872,0.0110669,0.00833617,0.00663597,0.00517219,
0.00421612,0.00325817,0.00238405,0.00179251,0.0014195,0.00114728,0.000940998,0.000792171,0.000616029,
0.000450247,0.00034475,0.00028164,0.000235485,0.000200633,0.00018462,0.000171433,0.000161072,0.000152594,
0.000146001,0.000134697,0.000125278,0.00012151,0.000118684,0.000118684,0.000118684,0.000122452,0.00012622,
0.000134697,0.000146001,0.000151652,0.000157304,0.000165781,0.000174259,0.000177085,0.00018462,0.000192156,
0.000197807,0.00021853,0.000237369,0.000258091,0.000285408,0.000309898,0.000325911,0.00034004,0.000347576,
0.000348518,0.000345692,0.00034004,0.000334389,0.000327795,0.000324027,0.00032026,0.000318376,0.00031084,
0.000305188,0.000296711,0.000287292,0.000282582,0.000285408,0.000289176,0.000294827,0.000302363,0.000305188,
0.00031084,0.000317434,0.00032026,0.00032026,0.000317434,0.000308956,0.000301421,0.00028164,0.000271279,
0.000258091,0.000250556,0.00024773,0.000250556,0.000258091,0.000268453,0.000274104,0.000282582,0.000295769,
0.000307072,0.000319318,0.000335331,0.000355111,0.00037866,0.00040315,0.000428583,0.000460609,0.000487925,
0.000516183,0.000544441,0.000564222,0.000588712,0.000607551,0.000617912,0.000619796,0.000634867,0.00065559,
0.000692326,0.000742249,0.000802533,0.000879772,0.000928753,0.000992805,0.0010757,0.00116047,0.00122358,
0.0012443,0.00124807,0.00124619,0.00124336,0.0012622,0.00132908,0.00143646,0.0016597,0.00204778,0.0024773,
0.00295487,0.00332976,0.00355488,0.00373856,0.0039731,0.00428206,0.00470028,0.00526827,0.00602465,0.00678762,
0.00726801,0.00752704,0.00762312,0.00769,0.00783694,0.00819582,0.00880902,0.00950323,0.0102135,0.0110706,
0.0118223,0.0127181,0.0141178,0.0163841,0.0189264,0.0213453,0.0240298,0.0275207,0.0319544,0.0372518,0.0430655,
0.0489856,0.0556526,0.0627144,0.0708367,0.0794903,0.0875043,0.0998786,0.116145,0.134631,0.15493,0.175251,
0.196063,0.208006,0.204724,0.188814,0.16892,0.145067,0.120346,0.0985966,0.0811491,0.0668052,0.0641904,
0.0519037,0.0412645,0.0325779,0.0249925,0.0190036,0.0138465,0.0103331,0.00809315,0.00662372,0.00512792,
0.00415019,0.0031847,0.0023021,0.00174447,0.00140066,0.0011341,0.000926869,0.000749784,0.000564222,0.000405034,
0.000321201,0.000269395,0.000232659,0.000206285,0.000192156,0.000183678,0.000174259,0.000165781,0.000157304,
0.000151652,0.000147885,0.000141291,0.000138465,0.000143175,0.000148826,0.000152594,0.000161072,0.000170491,
0.000177085,0.00018462,0.000192156,0.000197807,0.000207227,0.00021853,0.000232659,0.00024302,0.000268453,
0.000301421,0.000327795,0.000359821,0.000389963,0.000421047,0.000452131,0.000464376,0.000463434,0.000454957,
0.000435176,0.000417279,0.00040786,0.000395615,0.000389021,0.000385253,0.000376776,0.000363589,0.000356053,
0.000350402,0.000347576,0.00034946,0.000354169,0.000357937,0.000364531,0.00037395,0.000384311,0.000389963,
0.000401266,0.00040786,0.000406918,0.000393731,0.000384311,0.000364531,0.000350402,0.000338156,0.000327795,
0.000324969,0.000325911,0.000333447,0.00034475,0.000356995,0.000373008,0.000393731,0.000417279,0.000444596,
0.000483215,0.000537848,0.000599074,0.000644287,0.000704571,0.000764855,0.000808184,0.000852455,0.000891075,
0.000910856,0.000926869,0.000944766,0.000957011,0.000968314,0.000978675,0.000990921,0.00100505,0.00105497,
0.00114728,0.00126126,0.00137994,0.00152688,0.00166723,0.00179816,0.00190554,0.00194887,0.00193663,0.00189801,
0.00186221,0.00188388,0.00198467,0.00220226,0.00266098,0.00328454,0.00391282,0.00434894,0.00463717,0.00480672,
0.00494895,0.00517219,0.0055452,0.00622151,0.00707397,0.00783694,0.00854528,0.00917638,0.00961721,0.00984421,
0.00993464,0.0101409,0.0106543,0.0115039,0.0125683,0.0138051,0.0153169,0.0166196,0.0180193,0.019939,0.0225661,
0.0256942,0.0292435,0.032869,0.0373696,0.043884,0.0520846,0.0609567,0.0705682,0.080922,0.0910291,0.101602,
0.111554,0.120805,0.136818,0.158949,0.18135,0.203812,0.228968,0.253036,0.262522,0.25403,0.230836,0.202684,
0.171703,0.141767,0.115813,0.0955956,0.0786642,0.0717212,0.0581761,0.0465996,0.0368148,0.0289656,0.0221667,
0.0170501,0.0126587,0.00973966,0.00784918,0.00628368,0.00486983,0.00392035,0.00288987,0.00215987,0.001671,
0.0013611,0.00107664,0.000890133,0.000670661,0.000503938,0.000370182,0.000307072,0.000262801,0.000235485,
0.000219472,0.000206285,0.000195923,0.000191214,0.00018462,0.000174259,0.000171433,0.000169549,0.000168607,
0.000171433,0.000174259,0.00018462,0.000192156,0.000197807,0.000208169,0.000219472,0.000231717,0.000234543,
0.000240195,0.000251498,0.000271279,0.000295769,0.000323085,0.000361705,0.00041257,0.000482273,0.000551035,
0.000599074,0.00062168,0.000634867,0.000633925,0.00062168,0.000611319,0.000580235,0.000556686,0.000536906,
0.000519951,0.00050488,0.000481331,0.00046155,0.000448363,0.000436118,0.000429525,0.000438002,0.000444596,
0.000459667,0.000471912,0.000494518,0.000514299,0.00053408,0.000551035,0.000559512,0.000564222,0.00055857,
0.000539731,0.000514299,0.000483215,0.000460609,0.000447421,0.00044177,0.000448363,0.000464376,0.000494518,
0.000536906,0.000570816,0.000616029,0.000640519,0.000681022,0.000746958,0.000822313,0.000910856,0.00097585,
0.00104838,0.00113315,0.00121981,0.00127821,0.00133473,0.00136675,0.00139595,0.00142515,0.00144023,0.00144682,
0.00145906,0.00146754,0.00149109,0.00154949,0.00165876,0.0018057,0.00206567,0.00227949,0.00256302,0.00280604,
0.00296523,0.00303776,0.00301986,0.00293979,0.00288705,0.00288893,0.0030321,0.0033891,0.00399288,0.00455616,
0.00511379,0.00562526,0.0060529,0.00629216,0.00648337,0.00674052,0.0071465,0.00774745,0.00855941,0.00951736,
0.0104047,0.0113155,0.0120361,0.0125787,0.0128876,0.0133143,0.0141055,0.0153922,0.01697,0.0187672,0.0204589,
0.0221356,0.0241221,0.0269668,0.0304896,0.0344383,0.0386544,0.0435233,0.0498135,0.0582298,0.0692627,0.0821079,
0.0953092,0.109322,0.12243,0.134539,0.146364,0.157521,0.174149,0.198661,0.226173,0.25563,0.288877,0.313578,
0.32014,0.305805,0.27346,0.234156,0.194385,0.158921,0.129472,0.107759,0.0881185,0.0764761,0.0618892,0.0503015,
0.0401954,0.0321211,0.0252195,0.0197845,0.0151803,0.0114681,0.0090511,0.00733959,0.00562903,0.00446197,
0.00345504,0.00256019,0.00198749,0.00157021,0.00126126,0.000973024,0.000796881,0.000604725,0.000438002,
0.000350402,0.000303305,0.000270337,0.00024773,0.000235485,0.000232659,0.000219472,0.000210995,0.000204401,
0.000197807,0.000196865,0.000199691,0.000206285,0.000216646,0.000226066,0.000234543,0.000242079,0.000250556,
0.000258091,0.000268453,0.000274104,0.00028164,0.000296711,0.000317434,0.00034475,0.000387137,0.000460609,
0.000556686,0.000628274,0.000706455,0.00078181,0.00082043,0.000846804,0.000846804,0.000826081,0.000805359,
0.000772391,0.000726236,0.000683848,0.000651822,0.000628274,0.000617912,0.0006019,0.000578351,0.000564222,
0.00056328,0.000564222,0.000575525,0.000598132,0.000615087,0.00062639,0.000644287,0.000671603,0.000701745,
0.000725294,0.000742249,0.000739423,0.0007187,0.00069421,0.000666893,0.000648997,0.000644287,0.000648997,
0.000666893,0.000699861,0.000746016,0.000800649,0.000850572,0.000892017,0.000925927,0.000977733,0.0010757,
0.00123206,0.00137994,0.00153536,0.00166441,0.00179157,0.00190837,0.00198938,0.00204589,0.00209299,0.00211277,
0.00211842,0.00211277,0.00210618,0.00210147,0.00211277,0.00216081,0.0022437,0.00242738,0.00269112,0.00303681,
0.00338062,0.00373102,0.00401078,0.00416526,0.00422837,0.0041954,0.004137,0.00408613,0.00408613,0.00421047,
0.00455145,0.00508365,0.00584945,0.00675465,0.00731228,0.00764573,0.00779738,0.00790005,0.00805924,0.0084087,
0.00913116,0.0100976,0.0112826,0.0124882,0.0137033,0.014991,0.0158981,0.0165659,0.0173939,0.0183895,0.0197054,
0.0216222,0.0238527,0.026088,0.028521,0.0311857,0.034718,0.0390745,0.0443946,0.0505727,0.0572916,0.065462,
0.0760277,0.0889964,0.104341,0.120055,0.136768,0.153062,0.166021,0.178758,0.192165,0.2097,0.234357,0.267068,
0.304126,0.343023,0.365971,0.368249,0.35045,0.304865,0.25288,0.208332,0.17159,0.140872,0.116046,0.0946659,
0.0779229,0.0629122,0.0518462,0.0425389,0.0347613,0.0281188,0.0222025,0.0173383,0.0131109,0.0101795,0.0081572,
0.00651351,0.00491881,0.00392977,0.00296711,0.00225595,0.00176331,0.00139501,0.0010804,0.000886365,0.000674429,
0.000528428,0.000395615,0.00034004,0.000307072,0.000282582,0.000271279,0.000258091,0.000249614,0.000243962,
0.000240195,0.000239253,0.00024302,0.00024773,0.000258091,0.000270337,0.000278814,0.000293885,0.000303305,
0.000309898,0.000316492,0.000319318,0.00032026,0.000326853,0.00034004,0.000363589,0.000405034,0.000487925,
0.000588712,0.000680081,0.000800649,0.000888249,0.000933462,0.00097114,0.00099563,0.00100505,0.000999398,
0.000980559,0.000951359,0.000924043,0.000888249,0.000834559,0.000799707,0.000764855,0.000734713,0.000703629,
0.000691384,0.000690442,0.00069421,0.000706455,0.000732829,0.00075732,0.000791229,0.000818546,0.000856223,
0.000891075,0.000908972,0.000924043,0.000924985,0.000920275,0.000907088,0.000898611,0.000897669,0.000898611,
0.00090803,0.000925927,0.000957953,0.00100222,0.0010691,0.00113692,0.00121793,0.0013206,0.00145153,0.00163332,
0.00191496,0.00220508,0.00247919,0.00271844,0.00292849,0.00306319,0.00313383,0.00314514,0.00315173,0.00313666,
0.00307072,0.00298783,0.00293791,0.00292472,0.00296428,0.00307732,0.00326476,0.0035172,0.00386478,0.00418315,
0.00448458,0.00475491,0.00500735,0.00519668,0.00525885,0.00521929,0.00514111,0.00505068,0.00505822,0.00525602,
0.00567425,0.00651446,0.00737539,0.0081101,0.0087233,0.00910762,0.00927716,0.00936382,0.00944389,0.00978299,
0.0105073,0.0116669,0.0130591,0.014698,0.0164368,0.0179392,0.0191063,0.0201236,0.0212897,0.0225858,0.0243199,
0.0266305,0.0293678,0.0320523,0.0349318,0.0383106,0.0428083,0.048168,0.0550837,0.0631213,0.0722713,0.0831836,
0.0957717,0.110349,0.125919,0.144317,0.162715,0.17883,0.192976,0.208805,0.227789,0.248038,0.273009,0.305247,
0.338964,0.375941,0.395688,0.395806,0.373873,0.317771,0.258203,0.212517,0.176814,0.146792,0.120144,0.0972025,
0.0764149,0.0621887,0.052159,0.0439321,0.0367102,0.0305264,0.0244424,0.0192165,0.0146274,0.0112439,0.00892111,
0.00713614,0.00533891,0.00425851,0.00332787,0.00253664,0.00196771,0.00150993,0.00118213,0.00093252,0.000766739,
0.000606609,0.000468144,0.000385253,0.00034475,0.00032026,0.000308014,0.000303305,0.000293885,0.000289176,
0.000290117,0.000295769,0.000303305,0.000314608,0.000324969,0.000338156,0.000350402,0.000359821,0.00036924,
0.000376776,0.00037866,0.000379602,0.000379602,0.000385253,0.000393731,0.000427641,0.00050017,0.000599074,
0.000702687,0.000826081,0.000924985,0.000996572,0.00109265,0.00117366,0.00123488,0.00126503,0.00127727,
0.00126314,0.00122546,0.00115293,0.0010691,0.000992805,0.000944766,0.000910856,0.000884481,0.000854339,
0.000841152,0.000841152,0.000850572,0.000866585,0.000886365,0.00090332,0.000928753,0.00096643,0.00101164,
0.00107099,0.00112091,0.00115293,0.00116612,0.00116518,0.00115199,0.00115199,0.00115859,0.00117366,0.00121228,
0.00125278,0.00133473,0.00140632,0.00151276,0.00160695,0.00175389,0.0019809,0.00222675,0.00258374,0.00302834,
0.00344844,0.00381768,0.00409932,0.00428771,0.00437437,0.00439509,0.00436966,0.00431126,0.00422837,0.0041257,
0.00401737,0.00392035,0.00389492,0.00397499,0.00413135,0.00436212,0.00466449,0.00496873,0.00530595,0.00561961,
0.00597001,0.00632042,0.00654648,0.00664256,0.00662843,0.00651728,0.00642497,0.00644852,0.00666234,0.00711824,
0.007771,0.0085773,0.00943918,0.0101004,0.0105394,0.01074,0.0107777,0.0108323,0.0111987,0.0119749,0.0131947,
0.014958,0.01697,0.0189829,0.0207462,0.02234,0.0236615,0.0251281,0.0268434,0.0290607,0.0316313,0.0344769,
0.0377586,0.0415603,0.0461937,0.0517181,0.0581827,0.0662975,0.0762802,0.0877822,0.101547,0.115702,0.129726,
0.146297,0.163834,0.183316,0.201157,0.216991,0.235851,0.257807,0.279474,0.30339,0.33393,0.369802,0.400159,
0.414929,0.409298,0.381123,0.318202,0.251086,0.20455,0.171838,0.143799,0.118152,0.0955702,0.0727856,0.0601391,
0.0513621,0.044226,0.0379253,0.0320325,0.0260136,0.0206454,0.0159941,0.0120239,0.00944106,0.00749784,
0.00564599,0.00447516,0.00357184,0.00274293,0.00210147,0.00157587,0.00124336,0.000973024,0.000822313,
0.000652764,0.000544441,0.000442712,0.000387137,0.000363589,0.000350402,0.000340982,0.000339098,0.000339098,
0.00034475,0.000354169,0.000368298,0.000386195,0.00040786,0.000426699,0.000450247,0.000467202,0.000476622,
0.000487925,0.000487925,0.000482273,0.00047568,0.000479447,0.000501112,0.000537848,0.000608493,0.000700803,
0.000828907,0.00093723,0.00104838,0.00119155,0.00129799,0.001379,0.00146566,0.00152217,0.00155232,0.00155703,
0.00152406,0.00146095,0.00136675,0.00127727,0.00117742,0.00107664,0.00100222,0.000973024,0.000964546,
0.000965488,0.000970198,0.000980559,0.00100317,0.00104838,0.00113033,0.00123582,0.00133473,0.00141008,
0.00148638,0.001525,0.00153725,0.00152688,0.00152029,0.001525,0.00154101,0.00157021,0.00160507,0.00169455,
0.00180947,0.00201952,0.00220791,0.00244245,0.00272315,0.00309239,0.00348047,0.00392883,0.00431974,0.00469274,
0.00502996,0.00539355,0.00567048,0.00580988,0.00580423,0.0056799,0.00553955,0.00534174,0.00510531,0.00490185,
0.0047794,0.00474643,0.0048557,0.00515618,0.00559324,0.00616782,0.00666046,0.00699579,0.00718512,0.00736126,
0.0075553,0.00773333,0.00785107,0.00786896,0.00782281,0.00775687,0.00777383,0.00791229,0.00827023,0.00894372,
0.00977074,0.0106543,0.0114559,0.0119137,0.0120634,0.0120841,0.012151,0.0125692,0.0134509,0.0149156,0.0168862,
0.0191694,0.0215092,0.0236521,0.0254305,0.0270054,0.0288158,0.0308372,0.033356,0.0361743,0.0394136,0.0434121,
0.048167,0.0542623,0.0613014,0.0696385,0.0792963,0.0899769,0.103209,0.117989,0.133393,0.147495,0.163047,
0.181475,0.202874,0.222654,0.237291,0.254109,0.277333,0.297847,0.320251,0.360978,0.398947,0.428642,0.43067,
0.406478,0.369366,0.306514,0.239741,0.190309,0.159722,0.134439,0.112582,0.0908341,0.069274,0.0575977,
0.0497146,0.0435685,0.0381599,0.0326712,0.0269065,0.0214612,0.0166752,0.0124515,0.00970763,0.00769,0.00583908,
0.00461645,0.00371313,0.00284277,0.00214668,0.00161354,0.0012801,0.00100788,0.000880714,0.000732829,0.000615087,
0.00052466,0.000459667,0.000420105,0.000406918,0.000395615,0.000393731,0.000401266,0.000416337,0.000438944,
0.000471912,0.000516183,0.000552919,0.000580235,0.000607551,0.000617912,0.000619796,0.000619796,0.000617912,
0.000612261,0.000607551,0.000607551,0.000617912,0.000638635,0.000716816,0.000822313,0.000935346,0.00106816,
0.00123677,0.00136581,0.00149297,0.00159376,0.00170585,0.00179628,0.00186787,0.00191402,0.00189236,0.00180852,
0.0017115,0.0015834,0.00147037,0.0013498,0.00124901,0.00119909,0.00116801,0.00117083,0.00118779,0.00121416,
0.0012622,0.00134415,0.00145059,0.0015834,0.00175766,0.0019517,0.00209299,0.00213444,0.00214103,0.00212219,
0.00211465,0.00212407,0.00215516,0.00219472,0.00226725,0.00239347,0.00261859,0.00292472,0.00328925,0.0036811,
0.00408613,0.00442523,0.00478411,0.00518915,0.00564316,0.00627803,0.00686203,0.00728967,0.00762877,0.007771,
0.00773898,0.00759203,0.00736691,0.00707397,0.00665386,0.00622811,0.00593705,0.00588901,0.00617347,0.0067603,
0.00736691,0.00787838,0.00825139,0.0084605,0.00849441,0.00850195,0.00859426,0.00880902,0.00904451,0.00916884,
0.00917167,0.00911515,0.00908689,0.00917638,0.00948533,0.0100439,0.0108879,0.0117987,0.0125824,0.0130901,
0.0132295,0.0132738,0.0133803,0.0138211,0.0149297,0.0165725,0.018755,0.0213123,0.0240317,0.026493,0.0284795,
0.0301214,0.0319751,0.0342376,0.0370569,0.0409433,0.0452301,0.0499953,0.0554916,0.0622707,0.0713661,0.0817896,
0.0923346,0.104093,0.117451,0.133682,0.151748,0.166532,0.182322,0.199968,0.220483,0.239808,0.252518,0.26599,
0.290538,0.314347,0.3432,0.381441,0.423254,0.448528,0.435735,0.397635,0.350906,0.289766,0.228539,0.179868,
0.148231,0.124957,0.105869,0.0862534,0.066809,0.0556451,0.0478571,0.0425022,0.0377096,0.0325968,0.0270949,
0.0216326,0.0168051,0.0125203,0.00975002,0.00772296,0.00591538,0.00466072,0.00372349,0.00280039,0.00211936,
0.00161543,0.00131212,0.00105026,0.000919333,0.000802533,0.000678197,0.000611319,0.000553861,0.00052466,
0.000510531,0.000505822,0.000508647,0.000520893,0.000537848,0.000565164,0.000612261,0.000645229,0.000701745,
0.00074319,0.000769565,0.00078181,0.00078181,0.000773333,0.000755436,0.000745074,0.000731887,0.000725294,
0.000742249,0.00078181,0.00084963,0.000933462,0.00105968,0.00124619,0.00140255,0.00155797,0.00170114,
0.0018462,0.002028,0.00214668,0.00223522,0.00230304,0.00232565,0.00227478,0.00218436,0.00204778,0.0018349,
0.001671,0.00154196,0.0014666,0.00142704,0.00143175,0.00145059,0.00149486,0.00157021,0.00169926,0.00190083,
0.002174,0.00246035,0.00274293,0.00293979,0.00302268,0.00302268,0.00299066,0.0029737,0.00298689,0.00304529,
0.00314137,0.00324216,0.00342113,0.00371972,0.00408802,0.00448269,0.00492917,0.00542934,0.00595023,0.00650598,
0.00705513,0.00758073,0.00813082,0.00871483,0.0092376,0.00964735,0.00985552,0.00985081,0.00964358,0.00924702,
0.00873743,0.00818922,0.00777571,0.00748842,0.00744886,0.00775593,0.00829472,0.00901625,0.00960873,0.00995065,
0.0100081,0.00987718,0.00972459,0.00969821,0.00988001,0.0101814,0.0104433,0.0105337,0.0104838,0.0103783,
0.0103585,0.0105893,0.0111733,0.0119476,0.0128038,0.0135611,0.0140801,0.0142845,0.0144202,0.0146029,0.015186,
0.0163069,0.0180494,0.0203751,0.0233092,0.0263498,0.0291738,0.0312479,0.0330998,0.0348414,0.0370013,0.0407304,
0.0459846,0.0516061,0.057318,0.0632682,0.0713604,0.0822313,0.0940678,0.106573,0.119296,0.134716,0.152879,
0.171642,0.190478,0.207133,0.220987,0.237889,0.258299,0.271067,0.280469,0.304095,0.337773,0.372848,0.401588,
0.43082,0.446138,0.427984,0.387833,0.329461,0.269751,0.216073,0.170842,0.138241,0.116814,0.099563,0.0820232,
0.0650108,0.0542991,0.0464301,0.0412268,0.0367432,0.0319336,0.0265495,0.0212775,0.0165706,0.0123648,0.00965394,
0.00766268,0.00585321,0.00461739,0.00362741,0.00269018,0.00206285,0.00159753,0.00133473,0.00110584,0.000951359,
0.000876946,0.000780868,0.000698919,0.000645229,0.00062639,0.000619796,0.000619796,0.000627332,0.000637693,
0.000661242,0.000702687,0.000758262,0.000816662,0.000877888,0.00090332,0.000924043,0.000925927,0.000924043,
0.000910856,0.000896727,0.000884481,0.000873178,0.000873178,0.000887307,0.000908972,0.000957011,0.00106816,
0.00124619,0.00142139,0.00159565,0.00178874,0.00199503,0.00216646,0.00232565,0.00250839,0.00266852,0.00279662,
0.00288045,0.00288139,0.00278532,0.00259504,0.00237746,0.00218247,0.00200351,0.00184055,0.00177179,0.00176708,
0.00179251,0.00186881,0.00203553,0.00222204,0.00253664,0.00294733,0.00337214,0.00373479,0.00395426,0.00405317,
0.00406164,0.00404469,0.00403715,0.00405317,0.00410968,0.00422837,0.00436683,0.00455993,0.00484063,0.0052758,
0.00595023,0.00682906,0.00748654,0.00799613,0.0084784,0.00902661,0.0096822,0.0103726,0.0111366,0.0117347,
0.0122226,0.0125457,0.0125146,0.0121181,0.0115227,0.0107504,0.00997514,0.00942222,0.00909631,0.0090511,
0.0094194,0.0100354,0.0107777,0.0113833,0.011697,0.0116367,0.0112948,0.0109331,0.0108078,0.0110169,0.011422,
0.0117677,0.011892,0.0118223,0.0116452,0.0115152,0.0116122,0.0120898,0.0128791,0.0136515,0.0144399,0.0150607,
0.0154196,0.0156918,0.0160167,0.0165555,0.017699,0.0194991,0.0219943,0.0249991,0.0282912,0.0311961,0.0337695,
0.0357146,0.0373912,0.0398035,0.0441035,0.0504851,0.0578681,0.0652971,0.0723749,0.0816878,0.0937136,0.107367,
0.120109,0.136311,0.154733,0.17203,0.191721,0.214411,0.233194,0.244642,0.2596,0.280932,0.295836,0.302494,
0.322677,0.362487,0.395306,0.418987,0.434846,0.440952,0.41692,0.37634,0.311843,0.251071,0.201182,0.159355,
0.128436,0.110115,0.094892,0.0791455,0.063288,0.0531216,0.0451312,0.0396302,0.0355168,0.0308532,0.0255398,
0.0205465,0.0161166,0.012086,0.00942976,0.00749219,0.0057025,0.00450907,0.00348235,0.00256867,0.00199503,
0.00159282,0.00135922,0.00116141,0.00100222,0.000925927,0.00087412,0.000811952,0.00078652,0.000769565,
0.000764855,0.000774274,0.000783694,0.000800649,0.000822313,0.000871294,0.000910856,0.000947591,0.00099563,
0.00104555,0.00107287,0.0010804,0.00106345,0.00103708,0.00100222,0.000980559,0.000973024,0.000978675,
0.000996572,0.00104838,0.00114728,0.00128575,0.00145059,0.00163709,0.00185562,0.00210618,0.00229268,0.00251686,
0.00273068,0.00294733,0.00318187,0.00336272,0.00351249,0.00357937,0.00352662,0.00336743,0.00316209,0.00288705,
0.00263743,0.0024368,0.00230398,0.00226819,0.00230869,0.00240289,0.00259787,0.00292001,0.00333918,0.00384688,
0.00428112,0.00459855,0.00481143,0.00491598,0.00496214,0.00497344,0.00499228,0.00504409,0.00520516,0.00541898,
0.0056733,0.00603124,0.00648902,0.00711259,0.00782658,0.00869693,0.00964735,0.0104084,0.0111479,0.0118223,
0.0126371,0.0134905,0.0143994,0.015186,0.0157765,0.0161072,0.0160469,0.0155194,0.0144333,0.0132003,0.0121039,
0.0114173,0.0110857,0.0110687,0.0114182,0.0120239,0.0126917,0.013254,0.0134989,0.01332,0.0128565,0.012314,
0.0120841,0.0122339,0.0126371,0.0130054,0.0131259,0.0129988,0.0127077,0.0124138,0.0124063,0.0128396,0.0134914,
0.0142977,0.0151379,0.0158076,0.0163248,0.0167929,0.0173138,0.0180476,0.0192391,0.0209855,0.023346,0.0261501,
0.0294639,0.0326222,0.0357419,0.0383492,0.0403508,0.0429298,0.0474926,0.0547681,0.0641612,0.0741457,0.0829312,
0.0934772,0.106986,0.120354,0.135203,0.155167,0.175029,0.192582,0.213238,0.238058,0.257705,0.271678,0.285599,
0.302744,0.313238,0.321509,0.343692,0.378906,0.410294,0.431301,0.442655,0.436349,0.404672,0.35536,0.2943,
0.236968,0.189296,0.150769,0.122589,0.105473,0.0907474,0.076347,0.0610302,0.0512905,0.0434036,0.0378528,
0.0337243,0.0292689,0.0242898,0.0196602,0.0153819,0.01173,0.00921217,0.00733583,0.00555556,0.00438661,
0.00337403,0.00251215,0.0019809,0.00160883,0.00139878,0.00124148,0.00109265,0.000992805,0.000944766,0.000924043,
0.000906146,0.000899552,0.000900494,0.000907088,0.000917449,0.000928753,0.000953243,0.000992805,0.0010578,
0.0011341,0.00121228,0.00126032,0.00129046,0.00129328,0.00126879,0.00123677,0.0012038,0.00116895,0.00116612,
0.00119721,0.00123582,0.00130835,0.00140349,0.00155232,0.00174259,0.00199503,0.00221921,0.00246223,0.00270713,
0.00293697,0.00318658,0.00342207,0.003699,0.00396557,0.00415207,0.0042717,0.0042943,0.0042133,0.00407201,
0.00381015,0.00353133,0.00328078,0.00308674,0.00297465,0.00300008,0.00313383,0.003342,0.00371313,0.00414642,
0.0046042,0.00506858,0.00552165,0.00584945,0.0061179,0.00630252,0.00640707,0.00650598,0.0067198,0.0070297,
0.00733583,0.0076316,0.00790099,0.00828907,0.00897009,0.00986023,0.011081,0.0123846,0.0136431,0.0148666,
0.0159423,0.0168805,0.0177593,0.0184733,0.0190036,0.0193729,0.0195481,0.0195019,0.01903,0.0179553,0.0164896,
0.0150984,0.014099,0.0136591,0.0136544,0.0140274,0.0145643,0.0151869,0.0156202,0.0157257,0.0154205,0.0147611,
0.0140867,0.0137043,0.013773,0.0140161,0.0141913,0.0141658,0.0138946,0.0134594,0.0130807,0.0129978,0.0132729,
0.0138465,0.014649,0.0155194,0.0163031,0.0170519,0.0178093,0.018544,0.0194906,0.0207698,0.0224549,0.0244989,
0.0269979,0.0301684,0.0337469,0.0375212,0.0410695,0.0438661,0.0467796,0.0518849,0.059865,0.0709102,0.0828342,
0.0940734,0.106533,0.120549,0.135599,0.152091,0.173237,0.195953,0.217014,0.242163,0.270093,0.290072,0.304192,
0.312534,0.317395,0.325174,0.34402,0.377162,0.403776,0.425368,0.445759,0.449563,0.430672,0.392873,0.339686,
0.285545,0.230936,0.183836,0.146435,0.11937,0.101755,0.0866038,0.0729655,0.0582759,0.0488801,0.0415075,
0.035983,0.031636,0.0273115,0.0227855,0.0185967,0.0145426,0.0114097,0.00910479,0.00726047,0.00547455,
0.00435365,0.00338156,0.00256019,0.00204778,0.00168419,0.00148167,0.00133473,0.00121604,0.00112091,0.00106251,
0.00103142,0.00101353,0.00100976,0.00101164,0.00102295,0.0010399,0.00107664,0.00113221,0.00121228,0.00127727,
0.00135168,0.00140914,0.00146283,0.00148921,0.00149109,0.00147037,0.00144117,0.00141008,0.00139501,0.00141762,
0.00146001,0.00151935,0.00160224,0.00175389,0.00197996,0.00220226,0.00245752,0.00271844,0.0029803,0.00322238,
0.00340982,0.00363212,0.00391188,0.00418033,0.00445914,0.00470876,0.00490468,0.00502242,0.00502054,0.0048962,
0.00469745,0.00445161,0.00419257,0.00398346,0.00384688,0.00383275,0.00394013,0.00413983,0.00443465,0.00483969,
0.00539637,0.00610565,0.00673204,0.00713425,0.00743002,0.00769471,0.00787838,0.00808279,0.00843319,0.00894089,
0.00941375,0.00982066,0.0101739,0.0106609,0.0114662,0.0125824,0.0142195,0.0161684,0.0177819,0.0190234,
0.0201208,0.0211268,0.0219133,0.0224116,0.022696,0.0228656,0.0229089,0.0229014,0.0224549,0.0213641,0.0199955,
0.0187503,0.0179195,0.0175267,0.0174033,0.017554,0.0178545,0.0180975,0.0181173,0.0178695,0.0173571,0.0167769,
0.0161995,0.0157897,0.0156409,0.0155665,0.0153725,0.0150607,0.014617,0.0140688,0.0135526,0.0133831,0.0135385,
0.0140387,0.0148214,0.0157662,0.0167326,0.0177207,0.0186363,0.0195716,0.0207057,0.0221525,0.0236794,0.0254032,
0.027726,0.0309135,0.0349488,0.0394823,0.0438256,0.0477224,0.0516381,0.0571079,0.0657031,0.0778127,0.0913682,
0.104927,0.118651,0.136445,0.155102,0.171572,0.193578,0.219208,0.245475,0.277444,0.306938,0.326877,0.341123,
0.344145,0.341901,0.353592,0.380083,0.411934,0.43775,0.453586,0.46278,0.45945,0.431489,0.388758,0.341635,
0.287535,0.232442,0.184388,0.146701,0.119003,0.0997458,0.0835303,0.0697968,0.0558297,0.0469303,0.0399976,
0.0345701,0.0299235,0.0254211,0.0213123,0.0175578,0.0139539,0.0112289,0.0090803,0.00728308,0.00554803,
0.00444784,0.00354923,0.00271844,0.00216646,0.00179628,0.00157869,0.00144211,0.00134697,0.00127633,0.00123582,
0.00121604,0.00121228,0.00121133,0.00121228,0.00121416,0.00123582,0.00127727,0.00134038,0.00139878,0.00148261,
0.00155232,0.00160601,0.00166818,0.00170114,0.00170585,0.00169361,0.00167665,0.001671,0.00168701,0.001736,
0.0018057,0.00194887,0.00211277,0.00230116,0.00254983,0.00282488,0.0030971,0.00333352,0.00354923,0.00374233,
0.00391376,0.00408708,0.00431503,0.00461645,0.00494989,0.00534268,0.0056912,0.00600675,0.00609718,0.00595871,
0.00567613,0.0053587,0.00502054,0.00478788,0.00468615,0.00467673,0.00474267,0.0049141,0.00524189,0.00572699,
0.00655119,0.00725105,0.00779549,0.00827871,0.00881561,0.00926869,0.00966995,0.0100599,0.0107004,0.0115124,
0.0122349,0.0128763,0.0133746,0.014034,0.0149712,0.0163078,0.0181512,0.0200793,0.0217701,0.0230851,0.0243152,
0.0254211,0.0261916,0.0265288,0.0265137,0.0263771,0.0262895,0.0263517,0.0261294,0.0253674,0.0241363,0.0229136,
0.022096,0.0215695,0.0213679,0.0213952,0.0214103,0.0212662,0.0207971,0.0200746,0.0192966,0.0186966,0.018106,
0.0176293,0.0172102,0.0167938,0.0162918,0.015785,0.0152462,0.0145897,0.0140236,0.0137005,0.0137561,0.0141526,
0.0149401,0.0159819,0.0170293,0.0181823,0.0192862,0.020425,0.0217711,0.0232226,0.024805,0.0264732,0.028765,
0.0321145,0.0365482,0.0417844,0.0467466,0.05185,0.0569035,0.0632635,0.0725623,0.0857071,0.101698,0.116582,
0.133317,0.156006,0.178539,0.199061,0.223487,0.251149,0.278712,0.311173,0.338198,0.359467,0.377471,0.383382,
0.382965,0.391407,0.415649,0.441818,0.464834,0.480921,0.483267,0.467848,0.431838,0.384396,0.335395,0.282732,
0.230255,0.185856,0.149623,0.120183,0.0992465,0.0820891,0.0675154,0.0544338,0.0456012,0.0389257,0.0332731,
0.0283128,0.0238433,0.020052,0.0167025,0.0135215,0.0111394,0.00910573,0.00742154,0.00576938,0.00467108,
0.00381768,0.00297841,0.00234543,0.0019922,0.00172846,0.00157587,0.00149392,0.00143269,0.00139878,0.00139219,
0.00138842,0.00138465,0.00138371,0.00139125,0.00142045,0.00146754,0.00153065,0.00159659,0.00168796,0.0017699,
0.00184526,0.00191685,0.0019696,0.00198278,0.00198184,0.0019922,0.00203742,0.00210147,0.00218624,0.00231246,
0.00249614,0.0027467,0.00304435,0.00330998,0.00355394,0.00377529,0.00395332,0.00409367,0.00420199,0.00432162,
0.00446479,0.00470876,0.0050488,0.00555273,0.00618101,0.0067603,0.00710976,0.00722185,0.00716251,0.00692797,
0.00657851,0.00615275,0.00582684,0.0056912,0.00572699,0.00590125,0.00617818,0.00660677,0.00713614,0.00775593,
0.00846898,0.00924796,0.0100505,0.0109208,0.0116669,0.0123686,0.0131325,0.0141282,0.015412,0.0165659,
0.0174108,0.0179421,0.0183782,0.0190724,0.0203026,0.0222156,0.0243915,0.0263187,0.0278268,0.0290607,0.030078,
0.0308146,0.0310275,0.0306564,0.0302005,0.0299829,0.0302353,0.0305151,0.0303116,0.0295496,0.0283307,0.0272136,
0.0263056,0.0258515,0.0257583,0.0255548,0.0249652,0.0240308,0.0227733,0.0215224,0.0205654,0.0198382,0.0191044,
0.0184328,0.0177593,0.0170114,0.0163841,0.0158001,0.0151841,0.0144917,0.0141065,0.0140227,0.0142911,0.0150767,
0.0161618,0.0172723,0.0184705,0.0196903,0.0210269,0.0224737,0.0240261,0.0258402,0.0278362,0.0302852,0.0340238,
0.0389106,0.0444002,0.0501442,0.0562084,0.0628246,0.0713491,0.0824866,0.0967137,0.114699,0.132646,0.153153,
0.176732,0.202346,0.227742,0.2591,0.293191,0.32287,0.350741,0.372317,0.389646,0.411156,0.425424,0.425347,
0.435929,0.459963,0.472198,0.48472,0.507843,0.502602,0.477263,0.431836,0.372551,0.317516,0.270286,0.223458,
0.185134,0.151643,0.121712,0.100135,0.0820232,0.0664096,0.0534645,0.0443522,0.0376399,0.0318781,0.0268924,
0.0227036,0.0191393,0.016028,0.0131598,0.0110254,0.0091971,0.00766268,0.00616782,0.00491316,0.00410026,
0.0032836,0.00261859,0.00218624,0.00192909,0.00174541,0.00165876,0.00159659,0.00157587,0.00157587,0.00157587,
0.0015721,0.0015721,0.00157587,0.00160412,0.00166629,0.00173694,0.00181794,0.00194228,0.00204213,0.00211089,
0.00216458,0.00219566,0.00222769,0.0022437,0.00228326,0.00237463,0.00251875,0.00270054,0.00292001,0.00320071,
0.00348518,0.00378283,0.00405317,0.00422083,0.00434988,0.00443654,0.00451472,0.00459101,0.00468803,0.00484063,
0.00515429,0.00561773,0.00637411,0.00707868,0.00760993,0.00796881,0.00816568,0.00813836,0.00793678,0.00768623,
0.00739894,0.00720584,0.00717946,0.0072859,0.00748654,0.00773615,0.00808467,0.0085952,0.00934027,0.0102483,
0.0114493,0.0127699,0.0141574,0.0155825,0.0167345,0.01783,0.0189735,0.0202649,0.0216938,0.0227092,0.0232716,
0.0235532,0.024044,0.0252317,0.0271203,0.0294639,0.0314711,0.032902,0.0341237,0.0351739,0.0360075,0.0361554,
0.0356072,0.03488,0.0345164,0.0347717,0.0354132,0.0359943,0.0357315,0.0345588,0.033014,0.031604,0.0308287,
0.030371,0.0297926,0.0287546,0.0273982,0.0256481,0.0238292,0.0223993,0.0212247,0.0201001,0.0191186,0.0182256,
0.0174881,0.0168136,0.0162927,0.0157587,0.0151021,0.0145219,0.0143457,0.0145982,0.0154563,0.0165612,0.0176614,
0.0187032,0.019922,0.0214056,0.0229749,0.0247683,0.0269677,0.0294432,0.0322737,0.0362477,0.0415546,0.0473702,
0.0540447,0.0616641,0.0707284,0.0815249,0.0944398,0.110457,0.130261,0.152899,0.174235,0.198365,0.226316,
0.257106,0.296511,0.334618,0.366055,0.389995,0.410479,0.425865,0.445178,0.461144,0.465711,0.476745,0.495882,
0.501138,0.504205,0.52243,0.515364,0.4807,0.428941,0.365285,0.308514,0.263553,0.217358,0.180841,0.150444,
0.12213,0.0998004,0.0814872,0.0658746,0.0521759,0.0430702,0.0363608,0.0306997,0.0256782,0.0217258,0.018398,
0.0154742,0.0129244,0.0109557,0.009296,0.00784918,0.00648902,0.00516371,0.00432633,0.00355676,0.00288705,
0.00239912,0.00214009,0.00197148,0.00184997,0.00179251,0.00177556,0.00177461,0.00177085,0.00176614,0.00176708,
0.00178969,0.00181606,0.00189424,0.00199032,0.00209299,0.00217776,0.00223899,0.00230304,0.00237086,0.00244151,
0.00248955,0.00254512,0.00263272,0.00277778,0.00297841,0.00324216,0.00351815,0.00385442,0.0041549,0.00439227,
0.00461362,0.00474738,0.00483686,0.0048736,0.00488961,0.0049254,0.00502713,0.00527957,0.00570062,0.00645417,
0.00719548,0.00784542,0.0084605,0.00897763,0.00923289,0.00924985,0.00912269,0.00890792,0.00864795,0.00849818,
0.00856223,0.00882127,0.00916978,0.00958424,0.0100392,0.0107306,0.0117827,0.0131175,0.0149081,0.0167825,
0.0185091,0.0200793,0.0215158,0.0228402,0.0245291,0.0264478,0.0283505,0.0297606,0.0304727,0.030776,0.0310642,
0.0317933,0.0332976,0.0351607,0.036893,0.0383643,0.0396547,0.0411015,0.0425003,0.0430787,0.0425173,0.0416498,
0.0410121,0.0410789,0.0417477,0.0426736,0.0425559,0.0412485,0.0392469,0.03707,0.0355366,0.0344279,0.033306,
0.0318178,0.0300714,0.0278532,0.0254955,0.0235118,0.0218982,0.0204542,0.0192165,0.0182256,0.0174843,0.0168843,
0.0164566,0.0160356,0.0154638,0.0148808,0.0146302,0.0150032,0.0159772,0.0171414,0.0181804,0.0191412,0.0202668,
0.0217955,0.0235589,0.0256292,0.0282149,0.0310963,0.0346314,0.0389388,0.0443936,0.0506151,0.0582967,0.0682285,
0.079917,0.0924448,0.106419,0.123019,0.146368,0.170911,0.19507,0.221126,0.250418,0.287516,0.331868,0.375901,
0.402103,0.425448,0.452117,0.463687,0.470171,0.480461,0.491431,0.504693,0.522773,0.522605,0.521211,0.519022,
0.49974,0.463027,0.412935,0.355139,0.301988,0.257438,0.210889,0.174569,0.145556,0.118782,0.0975595,0.0799735,
0.0645144,0.050698,0.0418476,0.0353859,0.0297041,0.0246562,0.0208112,0.0177405,0.01499,0.0126992,0.0108775,
0.00931673,0.00791983,0.00666988,0.00533138,0.00447704,0.00377529,0.00313949,0.00264402,0.00233789,0.00218436,
0.00210053,0.00205154,0.00202894,0.00200916,0.00199409,0.0019809,0.00198561,0.00202046,0.00206756,0.00213067,
0.00219095,0.0022729,0.00236333,0.00245281,0.00251969,0.00259504,0.00268641,0.002758,0.00285219,0.00297182,
0.00317151,0.00341171,0.00373102,0.00407766,0.00436777,0.00468992,0.00493576,0.00514958,0.00527015,0.00530783,
0.00528428,0.00524943,0.00527015,0.00543405,0.00582119,0.00653518,0.00726236,0.00796787,0.00874308,0.00947874,
0.0100232,0.0103726,0.0105036,0.010464,0.0103152,0.0101814,0.010156,0.0103312,0.010821,0.0114587,0.0121652,
0.013044,0.0142063,0.0157897,0.0173421,0.0190517,0.0209723,0.0231218,0.0252176,0.0271693,0.0291869,0.0315107,
0.0340784,0.0361601,0.0377934,0.0387778,0.0392101,0.0394249,0.0400927,0.041321,0.0425361,0.0436071,0.0449673,
0.0464216,0.0482772,0.0505125,0.0522136,0.0522569,0.0511191,0.0499285,0.0492098,0.0491222,0.0496204,0.0490977,
0.0475152,0.0451877,0.0423355,0.0398911,0.038093,0.0362129,0.0341255,0.0316294,0.0288026,0.0258939,0.0236615,
0.0217598,0.0200991,0.0187032,0.0176557,0.0168975,0.0164142,0.0160554,0.0156673,0.015218,0.0147461,0.0146142,
0.0151954,0.0163022,0.0175945,0.0187107,0.0196988,0.0207943,0.0222806,0.0242342,0.0267586,0.0297399,0.0330743,
0.0370757,0.0418758,0.0474672,0.0542501,0.0627539,0.0744707,0.0877313,0.102014,0.116424,0.134312,0.158965,
0.185589,0.214179,0.242938,0.278173,0.321598,0.374544,0.415161,0.440686,0.453665,0.472217,0.490198,0.499305,
0.502054,0.503902,0.519059,0.525795,0.528247,0.518817,0.496968,0.475746,0.441667,0.387724,0.329199,0.285343,
0.241413,0.197774,0.164259,0.13723,0.114317,0.0944671,0.0777618,0.0625175,0.0486022,0.0403734,0.0341594,
0.028619,0.023719,0.0200803,0.0171678,0.0145219,0.0124477,0.0107343,0.0092376,0.00791418,0.00673204,0.0054171,
0.00457029,0.00392412,0.00330903,0.00286915,0.00258939,0.0024189,0.00231152,0.00225595,0.00223051,0.00219849,
0.00217871,0.00215516,0.00215987,0.00218436,0.00223334,0.00229739,0.00238311,0.00247448,0.00255454,0.0026299,
0.00271373,0.0028051,0.00292001,0.00302645,0.00315927,0.00329585,0.00351155,0.00381957,0.00414548,0.00446856,
0.00481237,0.00515995,0.00545477,0.0056328,0.00571475,0.00570721,0.00561961,0.00554708,0.00556781,0.00582684,
0.0064683,0.00721149,0.00798577,0.00887684,0.00978487,0.0106213,0.0113118,0.0117554,0.0120182,0.0121143,
0.0121661,0.0121708,0.0123017,0.0127407,0.0135413,0.0146698,0.0160017,0.0173458,0.018754,0.0201735,0.0217296,
0.0233761,0.0255473,0.0283288,0.0310831,0.0337177,0.0365049,0.0398883,0.0433424,0.0462313,0.0479494,0.0487002,
0.0493369,0.050292,0.051493,0.0524821,0.0528278,0.0528278,0.0534428,0.0548463,0.0570712,0.0597633,0.0623461,
0.0631571,0.0620333,0.060254,0.0584634,0.0569459,0.0560106,0.0545939,0.0525461,0.0497768,0.0466128,0.043658,
0.0413135,0.0385197,0.0354923,0.0322539,0.0287169,0.0253231,0.0227695,0.0207971,0.0190554,0.0175851,0.0164821,
0.0158057,0.0153103,0.0149081,0.0145294,0.014228,0.013953,0.0140886,0.0148487,0.0161693,0.0176152,0.0188981,
0.0200322,0.0211616,0.0227271,0.0250151,0.0279869,0.0312658,0.0349582,0.039569,0.0449343,0.0511144,0.0586141,
0.0675597,0.0790466,0.0926247,0.10847,0.125432,0.146272,0.171133,0.202014,0.235088,0.270238,0.312596,
0.364307,0.407471,0.448174,0.473624,0.475878,0.483665,0.510817,0.522796,0.51395,0.507319,0.513625,0.508274,
0.510064,0.501726,0.479965,0.460774,0.429209,0.372932,0.309494,0.263074,0.219836,0.181025,0.152219,0.127772,
0.108266,0.090251,0.0743859,0.0599224,0.0462342,0.038758,0.0329425,0.0277618,0.0231114,0.0195566,0.0166987,
0.0140632,0.012037,0.0103896,0.00901813,0.00779267,0.00665575,0.0054171,0.00459572,0.00400795,0.00345598,
0.00307638,0.00283806,0.00267793,0.00257715,0.00251215,0.00246129,0.002401,0.00233695,0.00229268,0.00228797,
0.00232565,0.00239064,0.0024773,0.00257526,0.00265721,0.00271844,0.00279945,0.00288799,0.00300196,0.00315267,
0.00327607,0.00341359,0.00360386,0.00384688,0.00414454,0.00445443,0.00480672,0.00519103,0.00556781,0.00589183,
0.00610283,0.00614239,0.00606798,0.00589466,0.00574206,0.005808,0.00622811,0.00694963,0.00773898,0.00866867,
0.00975379,0.0108511,0.011892,0.0127379,0.0133567,0.0138277,0.0141705,0.0144041,0.0146773,0.0151031,0.0158905,
0.0169813,0.0182699,0.0197336,0.0213123,0.0229833,0.0248276,0.0265768,0.0283722,0.0306008,0.0336866,0.0369448,
0.0406541,0.0449757,0.0496751,0.0543264,0.0580225,0.0597406,0.0598169,0.0603821,0.0624092,0.0645709,0.065446,
0.065672,0.0653734,0.0649383,0.0658378,0.0678894,0.0703459,0.0726716,0.0738198,0.0729806,0.0711899,0.0689349,
0.0661411,0.0631881,0.0602531,0.05696,0.0535097,0.0499803,0.0466223,0.0435609,0.0399929,0.0361017,0.032107,
0.0278805,0.0239893,0.0211757,0.0191534,0.0173788,0.0159065,0.0148064,0.0141282,0.0135912,0.0132098,0.0129545,
0.0127284,0.012654,0.0129931,0.0138465,0.015412,0.0169738,0.0185044,0.019873,0.0212568,0.0231717,0.0257752,
0.0290626,0.0324715,0.0364267,0.0417505,0.0479363,0.0553569,0.0636525,0.072275,0.0830009,0.0966656,0.114393,
0.135629,0.158955,0.185537,0.216145,0.256007,0.304097,0.360802,0.407193,0.441137,0.472397,0.511277,0.506417,
0.50233,0.53018,0.533473,0.518978,0.514146,0.508688,0.501412,0.500925,0.491706,0.464806,0.43893,0.407245,
0.354319,0.294033,0.246749,0.202631,0.16494,0.13793,0.117135,0.0999276,0.0842113,0.0691308,0.0562837,
0.0436514,0.0370578,0.0317669,0.0269979,0.0226433,0.0190931,0.016094,0.0133755,0.011438,0.00986305,0.00859237,
0.00754871,0.00648997,0.00537188,0.00461174,0.0040786,0.00358314,0.00324687,0.00304623,0.00292284,0.00283901,
0.002758,0.00269489,0.00260635,0.00253193,0.00246129,0.00243868,0.00247448,0.00254889,0.00265062,0.00273445,
0.00281075,0.00288328,0.00296146,0.00306225,0.00319318,0.00333352,0.00349836,0.00367733,0.00387043,0.00410121,
0.00436777,0.00469745,0.00504315,0.0054576,0.00585698,0.00622811,0.00640896,0.00641838,0.00627049,0.00604631,
0.00587959,0.00597849,0.00647866,0.00724634,0.00815626,0.00928753,0.0105441,0.0119127,0.0132484,0.0144023,
0.0153743,0.0160384,0.0164792,0.0168372,0.0173091,0.0180099,0.0188963,0.0199446,0.0212134,0.0228392,0.0248173,
0.0271495,0.0296278,0.0316821,0.033875,0.0361997,0.0393816,0.043301,0.0478364,0.0532394,0.0591199,0.0650042,
0.0693475,0.0713953,0.0715808,0.0720735,0.0743774,0.0766569,0.0782545,0.0797653,0.0802467,0.0796504,0.0795798,
0.0807412,0.0824941,0.0841265,0.0851052,0.0853039,0.0843827,0.0823284,0.0789119,0.0741438,0.0683811,0.0625269,
0.0572973,0.052823,0.048638,0.0449079,0.0407841,0.0361752,0.031457,0.0265005,0.0222138,0.0191289,0.0169596,
0.0152962,0.0138427,0.0130044,0.0123743,0.0118581,0.011503,0.0112392,0.0111243,0.0111733,0.0116292,0.0125834,
0.0140227,0.0158105,0.0175267,0.0191996,0.0210985,0.0234835,0.0263621,0.0298369,0.0334097,0.0376145,0.0434074,
0.0507244,0.0592565,0.0684234,0.0778466,0.088677,0.103746,0.124215,0.14887,0.172195,0.198555,0.230364,
0.274704,0.331511,0.389278,0.431981,0.463202,0.494391,0.534866,0.53167,0.523659,0.542507,0.542118,0.52411,
0.511284,0.500973,0.491525,0.481884,0.461301,0.434795,0.403614,0.372256,0.322998,0.276763,0.232853,0.189308,
0.153357,0.125432,0.105833,0.0896708,0.0762463,0.0629122,0.0522042,0.0411411,0.0354942,0.0306696,0.0261077,
0.0220659,0.0184865,0.0152396,0.0125156,0.0106307,0.00926398,0.00815814,0.00726707,0.00629969,0.00531066,
0.00463152,0.00413135,0.003699,0.00338722,0.0032431,0.00316492,0.00308297,0.00300856,0.00291436,0.00280415,
0.00270337,0.00260635,0.00257809,0.00260541,0.00269677,0.00279662,0.00288328,0.00296146,0.00303776,0.0031263,
0.00321767,0.00333447,0.00350213,0.00369994,0.00389869,0.00408613,0.00428865,0.00454392,0.00484251,0.00521929,
0.0056149,0.00607363,0.00642026,0.00657662,0.00655025,0.00635433,0.00606986,0.00588241,0.00600675,0.00659264,
0.00744415,0.00847181,0.00975944,0.0112901,0.0129696,0.0146858,0.0162061,0.0172535,0.0180391,0.0185939,
0.0191091,0.0197826,0.0206162,0.0215572,0.0225142,0.0236455,0.0254013,0.0277891,0.030808,0.0340521,0.0369401,
0.0398525,0.0428762,0.0463218,0.050683,0.0559927,0.0622264,0.068642,0.0747222,0.0790269,0.0813977,0.082772,
0.0838826,0.0849102,0.0861979,0.0887138,0.0921735,0.0937729,0.0932615,0.0924683,0.0930297,0.0951519,0.0973137,
0.09932,0.100619,0.100758,0.0991015,0.0945255,0.0874996,0.0785992,0.069485,0.0616424,0.0552071,0.0497919,
0.0451933,0.0406051,0.0357494,0.0305264,0.0250942,0.020442,0.0170529,0.0146811,0.0131335,0.0120983,0.0113965,
0.0107824,0.0102483,0.0099271,0.00975944,0.00970763,0.00985175,0.0102832,0.0112223,0.0125203,0.0141347,
0.0161091,0.0182133,0.0206068,0.0235014,0.026736,0.0302852,0.033956,0.0382296,0.0444247,0.0523615,0.0615482,
0.0717249,0.0831884,0.0958725,0.113208,0.13555,0.160751,0.184755,0.211594,0.244753,0.290747,0.350226,
0.398951,0.444127,0.482093,0.509592,0.535189,0.543786,0.542964,0.550747,0.545397,0.52443,0.502231,0.488797,
0.471371,0.448783,0.422779,0.40373,0.377022,0.336483,0.292775,0.25102,0.212703,0.174843,0.141662,0.116146,
0.0957096,0.080922,0.0683688,0.057058,0.0481322,0.038871,0.0338816,0.0295496,0.0250669,0.0210834,0.0175832,
0.0141517,0.0116424,0.00991486,0.00872236,0.00779267,0.00703817,0.00611131,0.00526168,0.00466731,0.00419257,
0.00381674,0.00354546,0.00341453,0.00335613,0.00330715,0.00324216,0.0031376,0.00298501,0.00285879,0.00274104,
0.00269489,0.00271279,0.00280415,0.00292001,0.00301327,0.00309898,0.00318281,0.00324216,0.00332787,0.00346069,
0.00364625,0.00385724,0.00406259,0.00422366,0.00439886,0.00464847,0.00491504,0.00527957,0.00567801,0.00614051,
0.00647866,0.00662937,0.00656249,0.00631853,0.00600675,0.00579387,0.0059427,0.00662372,0.007544,0.00865077,
0.0100345,0.0118223,0.0138258,0.0160017,0.0177009,0.0190055,0.0200115,0.0206878,0.0213396,0.0221525,0.0230351,
0.0238782,0.0246515,0.0256518,0.0274962,0.0302466,0.0340822,0.0382654,0.0426397,0.0467268,0.0504691,0.0543772,
0.0596408,0.066532,0.0736107,0.0794168,0.0834869,0.0865972,0.089781,0.0929111,0.0949993,0.0956596,0.0963011,
0.0991269,0.103516,0.105073,0.104147,0.103167,0.104826,0.109122,0.112781,0.115774,0.117095,0.117056,0.114751,
0.108623,0.0990167,0.0871323,0.0758073,0.0658133,0.0571673,0.0501611,0.0443559,0.039164,0.0342122,0.0290617,
0.0236295,0.0190055,0.0153612,0.0128839,0.0115548,0.0106373,0.00996196,0.00942222,0.00901719,0.00873084,
0.00858861,0.00860085,0.00882315,0.00923289,0.00997043,0.0111545,0.0125749,0.014504,0.0171226,0.02002,
0.0232358,0.0267275,0.0304388,0.0343007,0.038855,0.0452206,0.053246,0.0625052,0.0739037,0.0870522,0.10233,
0.121209,0.14541,0.169382,0.194463,0.223237,0.261489,0.312746,0.370319,0.413336,0.462329,0.513697,0.532239,
0.540246,0.552497,0.553197,0.548553,0.538932,0.511375,0.492711,0.482274,0.460956,0.433346,0.402674,0.379106,
0.35281,0.309194,0.265296,0.223736,0.189545,0.158793,0.130567,0.109071,0.0896388,0.0752676,0.0628076,
0.0528259,0.0451142,0.0368967,0.0322869,0.0282111,0.0240487,0.0201707,0.016532,0.0131325,0.0108587,0.00934593,
0.00823821,0.00746676,0.00675277,0.00589183,0.00520422,0.00469463,0.004283,0.00394296,0.003699,0.00359538,
0.00354169,0.00349648,0.00342207,0.00329962,0.00316115,0.00298689,0.00286632,0.00279097,0.00279474,0.00287197,
0.00298689,0.00310087,0.00320071,0.0032723,0.00333447,0.00342207,0.00356053,0.00375269,0.00396086,0.00414265,
0.0043122,0.00447516,0.00467579,0.00490656,0.00524943,0.00562244,0.00608399,0.00641461,0.00656061,0.00649373,
0.00623753,0.00591444,0.00569591,0.00585227,0.00660206,0.00757414,0.00874968,0.0101899,0.0121265,0.0145012,
0.0169643,0.0189829,0.0205936,0.0219962,0.0229174,0.0235881,0.02427,0.0250999,0.0258478,0.0266739,0.0278607,
0.0297662,0.0328605,0.0373781,0.0429647,0.0486842,0.0538969,0.0583993,0.063498,0.0702508,0.0788074,0.0865191,
0.0912806,0.0933217,0.0944634,0.0972741,0.101324,0.104549,0.105687,0.107149,0.110359,0.11418,0.115221,
0.113476,0.1133,0.117268,0.123489,0.129374,0.133023,0.13366,0.131076,0.125843,0.116439,0.104963,0.0913295,
0.0793264,0.0686288,0.0584059,0.0497966,0.042505,0.0364766,0.0315974,0.0267878,0.0218182,0.0175003,0.0136967,
0.0115096,0.0102163,0.00943635,0.00887401,0.00837761,0.00804417,0.00784353,0.00775876,0.00780303,0.00800837,
0.00838138,0.00908124,0.010042,0.0114549,0.0133595,0.016305,0.0195321,0.0228656,0.026493,0.0303983,0.0344844,
0.0393976,0.0463378,0.0547267,0.0645681,0.0770959,0.0916592,0.110085,0.129935,0.154321,0.177689,0.202834,
0.234126,0.276165,0.330001,0.389014,0.434717,0.483578,0.530491,0.549138,0.559769,0.560973,0.548411,0.538265,
0.5243,0.490602,0.473037,0.461982,0.445608,0.42382,0.389932,0.353729,0.321593,0.286252,0.246687,0.209569,
0.175968,0.146425,0.121692,0.102746,0.0855564,0.071546,0.0597171,0.0502336,0.0428714,0.0356873,0.0309691,
0.0269225,0.023134,0.0194473,0.0156192,0.012281,0.0102012,0.00886271,0.00786802,0.00716251,0.00645417,
0.00569591,0.00516277,0.00471347,0.00434894,0.00405222,0.00382804,0.00373008,0.00368204,0.00364342,0.00355959,
0.00343054,0.00327041,0.0030971,0.00293979,0.00286255,0.00284277,0.00289458,0.00302363,0.00315738,0.0032431,
0.00332599,0.00339852,0.00349177,0.00363212,0.00380638,0.00401078,0.00417185,0.00433198,0.00446856,0.00462398,
0.00483121,0.00512038,0.00549057,0.00587017,0.00622811,0.0063986,0.00636092,0.00613391,0.00582872,0.00565917,
0.00583908,0.00660677,0.00759203,0.00877794,0.0102483,0.0123187,0.015039,0.0177659,0.020085,0.0221158,
0.023816,0.0250396,0.0256942,0.0262594,0.0270299,0.0277458,0.0288846,0.0305631,0.0329133,0.036601,0.0421848,
0.0487218,0.0552985,0.0609972,0.0666884,0.073558,0.0817783,0.0911911,0.099661,0.104686,0.106156,0.106097,
0.10823,0.111786,0.113994,0.114523,0.11626,0.120255,0.125494,0.127714,0.127955,0.130235,0.135517,0.141555,
0.147711,0.151312,0.150465,0.145101,0.135462,0.121919,0.108104,0.0940169,0.0817378,0.0700134,0.058405,
0.0481962,0.0396952,0.0333833,0.028488,0.0238038,0.0195321,0.0155721,0.0122104,0.0102879,0.0091971,0.00844166,
0.00794997,0.00763913,0.00738952,0.00724634,0.00720113,0.00725859,0.0074856,0.00783694,0.00843413,0.00941092,
0.0107409,0.0126719,0.0156569,0.0189961,0.0224455,0.0261087,0.0301675,0.0345588,0.0401605,0.0480191,0.0570957,
0.0677264,0.0812753,0.098185,0.118357,0.140178,0.164493,0.189641,0.2174,0.245803,0.284571,0.339492,0.401197,
0.458321,0.507097,0.537428,0.55737,0.570638,0.565641,0.540269,0.525108,0.511975,0.488054,0.462278,0.439359,
0.426884,0.409788,0.376768,0.334213,0.299285,0.265285,0.231793,0.20082,0.168882,0.138598,0.115288,0.0974653,
0.0820241,0.0689575,0.0578643,0.0486653,0.0414595,0.034994,0.0302316,0.025941,0.0223108,0.0186061,0.0146848,
0.0116622,0.00978487,0.00846898,0.00757131,0.00688275,0.00619891,0.00559041,0.00514582,0.00473984,0.00438002,
0.00410026,0.00391282,0.00380826,0.00377435,0.00373762,0.00364907,0.00350684,0.00333352,0.00315738,0.00297182,
0.00287197,0.00285125,0.00289364,0.00301327,0.00314137,0.00323651,0.00332599,0.00340888,0.00350402,0.00363777,
0.0038092,0.00400513,0.00415301,0.00428771,0.00438002,0.00450718,0.00469745,0.00493953,0.00527392,0.00560925,
0.00594364,0.00614333,0.00616688,0.00602182,0.00579764,0.00568837,0.00592386,0.00666988,0.00765043,0.00882409,
0.0102737,0.012363,0.0152001,0.0181399,0.0207538,0.0231811,0.0252242,0.0266965,0.0274585,0.0280717,0.0288827,
0.0298397,0.0313628,0.0339654,0.0374308,0.042538,0.0488236,0.0556046,0.0620908,0.0681767,0.0751056,0.0832863,
0.0927792,0.102722,0.111021,0.115909,0.118167,0.1192,0.121899,0.124472,0.125576,0.124955,0.126784,0.131903,
0.138559,0.143768,0.148728,0.154299,0.15935,0.163785,0.168747,0.172667,0.170614,0.160885,0.146525,0.129072,
0.112425,0.0970565,0.0832939,0.0697874,0.0566483,0.0452263,0.0362327,0.0299753,0.0249605,0.0206417,0.0168758,
0.0133058,0.0108464,0.00930825,0.00828624,0.00767869,0.00726141,0.00702028,0.00686015,0.00677914,0.0067782,
0.00688746,0.00710882,0.00748654,0.00808467,0.0090624,0.0102945,0.0121416,0.0149665,0.0183245,0.021755,
0.0255812,0.029932,0.034735,0.0411769,0.0499501,0.0597425,0.0713293,0.0860113,0.10481,0.12458,0.147946,
0.174378,0.20458,0.235282,0.261504,0.293657,0.350023,0.417789,0.47963,0.531017,0.554045,0.566175,0.57068,
0.564135,0.547093,0.52508,0.502041,0.485902,0.458675,0.427172,0.406573,0.380991,0.349476,0.314445,0.277739,
0.240451,0.212925,0.189217,0.162196,0.133576,0.111884,0.0941733,0.0792445,0.0670981,0.0569045,0.0481115,
0.0407502,0.035205,0.0302598,0.0256622,0.0216109,0.0178168,0.0139822,0.0112957,0.0095362,0.00823632,0.00736691,
0.00668212,0.00605479,0.00555179,0.00513169,0.00474549,0.00439321,0.0041257,0.00394296,0.00385348,0.00382145,
0.00378,0.00369429,0.00354075,0.00335142,0.00316021,0.00295487,0.00284183,0.00279945,0.00285408,0.00294262,
0.00305283,0.00317151,0.00326665,0.00335236,0.00345315,0.00358408,0.00375269,0.00393542,0.00408519,0.00417374,
0.00426322,0.00434988,0.0044987,0.00473325,0.00501677,0.00534457,0.00562903,0.00585604,0.00595494,0.0059135,
0.00580235,0.00579764,0.00608681,0.00680928,0.00773992,0.00889945,0.0102973,0.0122763,0.0150437,0.0180334,
0.0207971,0.0234929,0.0257573,0.0275037,0.0285266,0.0294771,0.0306441,0.0321041,0.0345343,0.0381994,0.0433311,
0.0492964,0.0555829,0.0618496,0.0682172,0.0749436,0.0822323,0.0917779,0.103033,0.113213,0.120727,0.125548,
0.129288,0.131519,0.134449,0.136347,0.137198,0.138047,0.141,0.145893,0.152122,0.159635,0.170068,0.179723,
0.186396,0.189103,0.193976,0.197552,0.192029,0.176414,0.158559,0.1383,0.117931,0.0998654,0.0832901,0.0673063,
0.053115,0.041046,0.0326316,0.0265165,0.0217296,0.0177857,0.0140848,0.0115227,0.00972176,0.00847652,0.00764761,
0.0070702,0.00668212,0.0064796,0.00638258,0.00635056,0.00638824,0.00654366,0.00683001,0.00726801,0.00791418,
0.00890039,0.0101004,0.0117912,0.0141931,0.017521,0.0208555,0.024871,0.0296419,0.0349648,0.0421104,0.0516475,
0.0624657,0.0752167,0.0905468,0.109487,0.129584,0.153692,0.18117,0.214273,0.248567,0.277003,0.308233,
0.363907,0.433228,0.493148,0.539314,0.561149,0.566513,0.559357,0.551525,0.542553,0.520723,0.490239,0.473429,
0.45054,0.416181,0.380766,0.339121,0.311324,0.287665,0.25585,0.220631,0.195735,0.175449,0.152272,0.127604,
0.108793,0.0923779,0.0780058,0.0659631,0.0562423,0.0477808,0.0408613,0.0361083,0.0309964,0.0260013,0.0214056,
0.0173995,0.013725,0.0112439,0.00952113,0.00820335,0.00731134,0.00663691,0.00601334,0.00552259,0.0050893,
0.0047097,0.00437154,0.00411722,0.00394296,0.00385913,0.00382993,0.00378189,0.003699,0.00354075,0.00334106,
0.00313383,0.00289458,0.002758,0.00271279,0.00273351,0.00281452,0.00291625,0.00302834,0.00314231,0.00323651,
0.00333352,0.00346069,0.00362835,0.00379508,0.00393731,0.00403433,0.00408519,0.00413794,0.00427829,0.00448552,
0.00475209,0.00504503,0.00536623,0.00560172,0.00575996,0.00582778,0.00584191,0.0059361,0.00625919,0.00694869,
0.00780962,0.00893524,0.0102671,0.0120889,0.0145614,0.0175446,0.0202592,0.0229739,0.0254663,0.0274575,
0.0289816,0.0306027,0.0325968,0.0350449,0.0383643,0.0432831,0.0492013,0.0549857,0.0605168,0.0661986,0.0727526,
0.0808137,0.0896359,0.1003,0.112065,0.122198,0.129255,0.133822,0.138485,0.141608,0.143579,0.144247,0.145663,
0.148954,0.157207,0.164893,0.17176,0.183327,0.199801,0.213983,0.221607,0.221437,0.220708,0.219492,0.208888,
0.189128,0.169217,0.146716,0.122381,0.101098,0.0817632,0.0636563,0.0485636,0.0369956,0.0294036,0.0235768,
0.0190658,0.0151577,0.0120323,0.0101805,0.00889945,0.00787838,0.00715309,0.00659546,0.00622811,0.0061,
0.00606327,0.00606327,0.0061179,0.00631853,0.00673299,0.00728119,0.00799142,0.00895596,0.010058,0.0115689,
0.0136148,0.0168372,0.0202734,0.0243049,0.0292086,0.0349252,0.0426247,0.0527618,0.0649486,0.0796052,0.0959234,
0.114279,0.136239,0.162689,0.189226,0.218,0.252222,0.287335,0.321475,0.375971,0.442536,0.493233,0.532715,
0.553855,0.560308,0.554134,0.537378,0.521565,0.491596,0.46713,0.450654,0.423857,0.392204,0.356818,0.313203,
0.2847,0.261795,0.233683,0.204246,0.181472,0.163055,0.142806,0.122298,0.105853,0.0906099,0.0772607,0.0654158,
0.0559239,0.0480154,0.041679,0.0372999,0.0318847,0.0264845,0.0216156,0.0175926,0.0140867,0.0115943,0.00981313,
0.00838515,0.00740741,0.00666799,0.00600204,0.00545477,0.00500735,0.00463811,0.00432727,0.00408519,0.00391941,
0.00382899,0.00379508,0.00376117,0.00367733,0.00351438,0.00330715,0.00305848,0.00283147,0.00266286,0.00257809,
0.00257715,0.0026233,0.00271561,0.00282582,0.00292472,0.00303681,0.0031668,0.00329302,0.00344844,0.00361234,
0.00373102,0.00378942,0.00383369,0.00388173,0.00402868,0.00423025,0.00449211,0.00478788,0.00509495,0.00538601,
0.00559324,0.00574018,0.00585416,0.00602559,0.00638918,0.00701651,0.00779078,0.00881656,0.0100788,0.011778,
0.0139822,0.0167825,0.0194765,0.0220762,0.024595,0.0269743,0.0293169,0.0318988,0.035042,0.0385668,0.0429214,
0.0483498,0.0542934,0.0593846,0.064504,0.070328,0.0780133,0.0879046,0.0989753,0.109385,0.119013,0.128358,
0.135438,0.140148,0.144537,0.147978,0.150141,0.151034,0.15443,0.162284,0.178014,0.192669,0.202933,0.216689,
0.23829,0.256514,0.265192,0.261153,0.249339,0.237107,0.221739,0.200561,0.177758,0.151813,0.123195,0.0995385,
0.0790391,0.0602973,0.044891,0.0340474,0.0267464,0.0212897,0.0169446,0.0131514,0.0107419,0.00937136,0.00834182,
0.00756849,0.00694398,0.00640236,0.00609341,0.00600675,0.00599356,0.00600675,0.0061,0.00641838,0.00692326,
0.00756095,0.00833899,0.0093139,0.0103538,0.0117554,0.0137646,0.0168014,0.0201509,0.0238735,0.0285954,
0.0346153,0.0427989,0.0534513,0.0669908,0.0838534,0.101179,0.119482,0.143295,0.171942,0.199389,0.224212,
0.254966,0.292369,0.330686,0.382597,0.442141,0.484353,0.515999,0.536993,0.554397,0.554904,0.535685,0.508982,
0.476011,0.444668,0.417448,0.388546,0.362532,0.329778,0.298863,0.269239,0.242099,0.213925,0.190831,0.171815,
0.155684,0.136944,0.11911,0.104099,0.0895747,0.0769084,0.0651502,0.0561556,0.0489536,0.0429675,0.0380958,
0.0323594,0.0267096,0.0218794,0.018008,0.0147724,0.012184,0.0102907,0.00876475,0.00760993,0.00676501,
0.00596248,0.0053521,0.00488867,0.0045279,0.00423214,0.00400795,0.00384688,0.00376682,0.00374233,0.00371218,
0.00363212,0.00346916,0.00324687,0.00296523,0.00271561,0.00252628,0.00240195,0.00236333,0.00238876,0.00246882,
0.00256208,0.00267511,0.00279191,0.00292378,0.00308203,0.00323745,0.00336555,0.00347011,0.00351155,0.00353227,
0.0035822,0.00371595,0.00394861,0.00421424,0.00452131,0.00483686,0.00513828,0.00538978,0.00559041,0.00577221,
0.00601994,0.00641555,0.00700521,0.00769659,0.00856223,0.00974531,0.0112844,0.0133171,0.016013,0.0186598,
0.0212059,0.0238725,0.0267436,0.0298943,0.0336706,0.037914,0.0425917,0.0475133,0.0529568,0.0587168,0.0644607,
0.0701058,0.0762029,0.0849102,0.0968653,0.109241,0.118019,0.124783,0.131473,0.137569,0.142993,0.148022,
0.153033,0.1577,0.163588,0.171212,0.184113,0.205532,0.226282,0.240762,0.255305,0.277012,0.296115,0.307306,
0.30242,0.280486,0.257849,0.236154,0.210772,0.182447,0.151132,0.118972,0.0942684,0.0747052,0.0566219,
0.0418334,0.0317302,0.0247146,0.0195594,0.0154186,0.0120474,0.0100712,0.00898328,0.00814684,0.00752233,
0.0070118,0.0065964,0.00636092,0.00626484,0.00622811,0.00625542,0.00646359,0.00688935,0.00744132,0.00816662,
0.00910762,0.0101032,0.0112816,0.0127341,0.0148949,0.0176237,0.0206275,0.0240477,0.0286547,0.0347397,
0.0431578,0.0540711,0.0683048,0.085935,0.104593,0.123121,0.148154,0.178064,0.207829,0.232861,0.262184,
0.294214,0.329007,0.381845,0.435904,0.475578,0.504318,0.530637,0.548602,0.545566,0.523046,0.493088,0.459093,
0.420947,0.388966,0.357241,0.328089,0.304345,0.280036,0.25905,0.232306,0.202702,0.181322,0.166093,0.151205,
0.133444,0.116704,0.101929,0.0881288,0.0760965,0.0651427,0.0564505,0.0498719,0.0439358,0.0381533,0.0323867,
0.026672,0.0220009,0.0183838,0.015444,0.0128744,0.0108728,0.0091971,0.00785295,0.00688275,0.00591632,
0.00523907,0.00474549,0.0043706,0.00409744,0.00387891,0.00374421,0.0036811,0.0036632,0.00363212,0.00354169,
0.0033778,0.00315738,0.00285125,0.0025715,0.0023426,0.00221262,0.00215893,0.00215987,0.00219472,0.00226913,
0.00237651,0.0025065,0.00265156,0.00280604,0.0029624,0.00310275,0.00320071,0.00322991,0.00324404,0.00328266,
0.00338722,0.00361234,0.00392224,0.00424721,0.00455805,0.00484628,0.0051185,0.00537094,0.00559983,0.00590408,
0.00634867,0.00690442,0.00755342,0.0082919,0.00932615,0.0107164,0.012687,0.0152811,0.0180947,0.0208555,
0.0239196,0.0274142,0.0312027,0.035837,0.0412296,0.0465573,0.0516852,0.0571239,0.0639229,0.0711852,0.078084,
0.0847115,0.0941808,0.10731,0.119251,0.127357,0.130235,0.133557,0.139686,0.146511,0.152315,0.159049,0.168473,
0.181706,0.195333,0.213597,0.237788,0.262989,0.282336,0.301371,0.322693,0.338909,0.346213,0.339258,0.316483,
0.284576,0.249158,0.213797,0.17857,0.142945,0.110572,0.0857071,0.0667637,0.0510814,0.0383059,0.0294978,
0.0227215,0.0179769,0.0139859,0.0114286,0.00983762,0.00888061,0.00818451,0.00769659,0.00728685,0.00703629,
0.00689406,0.00683848,0.00686203,0.00698637,0.00725294,0.00773898,0.0084087,0.00930919,0.0102898,0.0115105,
0.0128433,0.0145549,0.016808,0.019274,0.0220631,0.0253834,0.0300931,0.0361959,0.0446592,0.0554991,0.0691921,
0.0862845,0.10586,0.124707,0.148438,0.177429,0.208222,0.236239,0.2634,0.295383,0.328972,0.37945,0.42852,
0.470352,0.505037,0.52671,0.535497,0.53081,0.505224,0.471548,0.434202,0.403408,0.373552,0.337883,0.310361,
0.282715,0.261295,0.244689,0.220303,0.193634,0.175232,0.161628,0.145917,0.128671,0.113747,0.0999097,0.0868365,
0.0754663,0.0648874,0.0563883,0.0497485,0.0439952,0.0382785,0.0324423,0.0268095,0.0221083,0.0187333,0.015916,
0.0133049,0.0112816,0.00956351,0.00810539,0.00700332,0.00584662,0.00509118,0.00458725,0.00419917,0.00393071,
0.0037282,0.00361611,0.00357278,0.00355394,0.00351532,0.00342301,0.00325252,0.00298501,0.0026817,0.00237463,
0.00216364,0.00200727,0.00190366,0.001882,0.00192909,0.00200633,0.00211089,0.00220979,0.00233601,0.00249331,
0.00265344,0.00279003,0.00286821,0.00288893,0.0029219,0.00296711,0.00308203,0.00327512,0.00355865,0.00393166,
0.00426322,0.00454769,0.00482838,0.00509307,0.00537848,0.0056912,0.00619231,0.0067669,0.00739046,0.0080809,
0.00900212,0.0102427,0.0120757,0.0145954,0.0177622,0.0211692,0.0250358,0.0292463,0.0336018,0.038822,0.0449089,
0.0507574,0.0562734,0.0625505,0.070961,0.0797474,0.0871539,0.0944257,0.104295,0.116634,0.128757,0.13611,
0.137243,0.13995,0.147407,0.156375,0.16244,0.170465,0.184825,0.201645,0.217861,0.238561,0.266348,0.300367,
0.329568,0.357356,0.379866,0.391447,0.388612,0.378821,0.353398,0.306217,0.251164,0.203236,0.16488,0.129423,
0.0991269,0.0749982,0.0574263,0.0444002,0.0343054,0.0265599,0.0205757,0.0162579,0.0129281,0.0110329,0.00977733,
0.00896162,0.00840964,0.00802533,0.00775028,0.0075958,0.00757037,0.00767022,0.00783317,0.00809597,0.00861404,
0.00932144,0.010108,0.0110829,0.0121303,0.0134245,0.0151539,0.0170755,0.019257,0.0215704,0.0244019,0.0281141,
0.0330056,0.0393486,0.0479099,0.0584973,0.0717589,0.088645,0.109702,0.130622,0.15233,0.176339,0.2038,
0.231218,0.261075,0.297618,0.336165,0.380645,0.416477,0.457715,0.495717,0.504179,0.496019,0.502916,0.488595,
0.455022,0.417716,0.391301,0.365458,0.331353,0.305415,0.274948,0.249799,0.22991,0.206789,0.186714,0.17283,
0.159018,0.141182,0.124685,0.112743,0.101151,0.0882946,0.0763047,0.0649712,0.0561867,0.0496101,0.0439566,
0.0391809,0.0332382,0.0274886,0.0227045,0.0192165,0.0163954,0.0136836,0.0115868,0.00981595,0.00829472,
0.00708998,0.00580517,0.00494895,0.00439509,0.00401737,0.00371313,0.00352474,0.00343996,0.00341171,0.00339475,
0.00334671,0.00324216,0.00303776,0.00275423,0.00245375,0.00217871,0.00194416,0.00175389,0.00166158,0.00162861,
0.00164934,0.00170303,0.00179251,0.00192344,0.00206567,0.00218436,0.00230398,0.00243303,0.00251121,0.00254135,
0.00257715,0.00262707,0.00273257,0.0029219,0.00322238,0.00355771,0.00393825,0.00425474,0.00453638,0.00482744,
0.00511662,0.00549057,0.00596154,0.00659264,0.00721055,0.00789722,0.00876475,0.00996666,0.0117319,0.0142365,
0.0177339,0.0218266,0.0266701,0.0314627,0.0364436,0.0424815,0.0491222,0.0554821,0.0618195,0.0696103,0.0794667,
0.0881505,0.0952631,0.103546,0.113152,0.124247,0.135247,0.142183,0.146019,0.151582,0.160256,0.169499,
0.176177,0.184347,0.200309,0.218545,0.236871,0.264149,0.302297,0.354699,0.391854,0.411371,0.429335,0.437264,
0.427379,0.404606,0.366382,0.30135,0.234778,0.182186,0.144669,0.113477,0.0853906,0.0637364,0.048574,0.0378179,
0.0298058,0.0232,0.0182934,0.0144512,0.0121407,0.0108003,0.00985363,0.00923101,0.00886554,0.00859237,
0.00843695,0.00842754,0.00861969,0.00901248,0.00944483,0.0099563,0.0107042,0.0117554,0.0128773,0.0138654,
0.015088,0.0163945,0.0179289,0.0197647,0.021935,0.0244659,0.0276158,0.031636,0.0367545,0.043673,0.0527533,
0.0629253,0.0761803,0.0939293,0.116893,0.14124,0.161724,0.183528,0.208554,0.230936,0.255885,0.294476,
0.341762,0.381069,0.410031,0.445184,0.475859,0.477036,0.467694,0.470741,0.461492,0.431488,0.399496,0.373013,
0.345136,0.316708,0.292589,0.266933,0.243843,0.223085,0.199031,0.182269,0.170806,0.155819,0.139019,0.124943,
0.115444,0.105281,0.0924872,0.0790203,0.0667713,0.05748,0.0507225,0.0450615,0.0412004,0.0348668,0.0290843,
0.0239074,0.0200737,0.0170472,0.0142054,0.011844,0.00997043,0.00841152,0.00711918,0.00571286,0.0048265,
0.00422743,0.00376493,0.00345315,0.00329396,0.00322991,0.00320165,0.0031847,0.00310652,0.00295487,0.00273257,
0.00246317,0.00218342,0.00191685,0.00168984,0.0015429,0.00145718,0.00142045,0.0014261,0.00147414,0.00154855,
0.00163709,0.00174353,0.00185845,0.00199503,0.0020977,0.00216175,0.00219284,0.0022324,0.00227761,0.00238688,
0.00257526,0.00285219,0.0032073,0.0035643,0.00394296,0.00426039,0.00455899,0.00486889,0.00524849,0.0057025,
0.00637411,0.00707679,0.00777477,0.00866585,0.00987153,0.0116085,0.014245,0.0181201,0.0227055,0.0282921,
0.0338618,0.0398167,0.0467146,0.0540391,0.061016,0.0685581,0.0776752,0.0875599,0.0954439,0.10194,0.110012,
0.120231,0.131567,0.14058,0.147074,0.154566,0.164506,0.175075,0.185109,0.192327,0.20083,0.219231,0.245369,
0.275336,0.312521,0.359123,0.40873,0.450423,0.46826,0.47349,0.464212,0.444692,0.403026,0.343124,0.271687,
0.207465,0.159019,0.122703,0.0950135,0.0709959,0.0530435,0.0403292,0.0315531,0.0247099,0.0197129,0.0159141,
0.0130845,0.0116292,0.0107287,0.010074,0.00972553,0.00956634,0.00955504,0.00970669,0.00999775,0.0106533,
0.0115303,0.0123526,0.013174,0.0143938,0.0160158,0.01736,0.0183867,0.019225,0.0202187,0.0214922,0.0231218,
0.0253523,0.0282431,0.0315945,0.0358549,0.0412588,0.048167,0.0576966,0.0684319,0.082009,0.0997976,0.122402,
0.149157,0.170944,0.193201,0.218227,0.235254,0.24963,0.279332,0.325275,0.37055,0.403843,0.429978,0.443685,
0.448252,0.452605,0.453723,0.438903,0.410311,0.381592,0.352982,0.323086,0.297747,0.275153,0.254522,0.234322,
0.214045,0.191943,0.176515,0.166303,0.152687,0.138633,0.127621,0.119538,0.110068,0.0973787,0.0831997,
0.0704477,0.0607231,0.0537876,0.0476273,0.0439603,0.0371972,0.0312479,0.0257244,0.0213029,0.0179279,0.0147536,
0.0120521,0.0100298,0.00838044,0.0070589,0.00559324,0.00467485,0.00403244,0.00347953,0.00318752,0.00301703,
0.00293132,0.00288893,0.00285314,0.00275423,0.00259316,0.00236804,0.0021448,0.00186692,0.00163709,0.00147037,
0.00134226,0.00125466,0.00122735,0.00123206,0.00126314,0.00133567,0.00141197,0.00149863,0.00157304,0.0016597,
0.00173505,0.00179251,0.00184243,0.00189989,0.00197336,0.00209393,0.00223522,0.00248295,0.00280698,0.0032026,
0.00358031,0.00396651,0.00429619,0.00462304,0.00499605,0.00550187,0.00618195,0.00696376,0.00773238,0.0086715,
0.00991203,0.0117328,0.0146867,0.0188605,0.0238066,0.0300036,0.0365058,0.0440008,0.0518576,0.0597501,
0.0675531,0.0763065,0.0859341,0.0956427,0.103416,0.109829,0.11713,0.127422,0.139086,0.148145,0.155297,
0.164934,0.176715,0.19066,0.2032,0.212812,0.225915,0.25077,0.290798,0.34088,0.387685,0.423285,0.464203,
0.497046,0.521849,0.512367,0.47606,0.432682,0.376538,0.304767,0.236296,0.179235,0.135014,0.103157,0.0767229,
0.0569205,0.0426124,0.0325525,0.0250989,0.0199098,0.0162381,0.0134339,0.0119165,0.0112223,0.0107617,0.0104584,
0.0103905,0.0105865,0.0110471,0.0117403,0.0128565,0.0145445,0.0162748,0.0175502,0.0187616,0.0202753,0.0219076,
0.023345,0.0244113,0.0252779,0.0261859,0.0271712,0.0283599,0.0302476,0.0329189,0.036406,0.041159,0.0467042,
0.0538196,0.063483,0.0750377,0.0887825,0.105416,0.1249,0.148901,0.170649,0.194425,0.218469,0.234227,0.244989,
0.266577,0.301955,0.346541,0.383993,0.406116,0.411135,0.425341,0.445276,0.442511,0.42251,0.396314,0.367647,
0.336653,0.306908,0.282733,0.263554,0.244415,0.22405,0.201395,0.181705,0.169667,0.161101,0.151564,0.140258,
0.131367,0.12287,0.113345,0.101285,0.0876597,0.0749746,0.0648544,0.0575337,0.0508892,0.0467551,0.0400588,
0.0340568,0.0283778,0.0231811,0.0190611,0.0155524,0.0123064,0.00997891,0.00820901,0.0068366,0.00538224,
0.00445443,0.00373762,0.00318941,0.00286821,0.00270148,0.00259787,0.00253664,0.00246788,0.00234449,0.00219472,
0.00201858,0.00177085,0.00157021,0.0013903,0.00124619,0.00111997,0.00103708,0.00100505,0.00100788,0.00104367,
0.00111055,0.00120003,0.00127162,0.00134226,0.00139407,0.00145906,0.00150428,0.00154196,0.00158057,0.00164463,
0.00174353,0.00191025,0.00214668,0.00242455,0.00279285,0.0032026,0.00361234,0.00401737,0.00436212,0.00476339,
0.00527957,0.00598132,0.00685921,0.00771825,0.00876192,0.0100778,0.0121312,0.015623,0.0199927,0.0255379,
0.0323839,0.0398572,0.0484798,0.0574075,0.0659122,0.0743435,0.0834917,0.0937004,0.103968,0.113364,0.121366,
0.12893,0.138188,0.148491,0.158522,0.166737,0.17569,0.188814,0.205647,0.223118,0.238482,0.256516,0.292379,
0.352189,0.410395,0.4557,0.492147,0.533003,0.551279,0.554208,0.531675,0.474922,0.411028,0.33496,0.264736,
0.199628,0.147547,0.109833,0.0817783,0.0593997,0.04408,0.0334775,0.0253288,0.0195961,0.0156579,0.0129931,
0.0116377,0.011113,0.01095,0.010903,0.0109896,0.0113306,0.0119871,0.0131429,0.0151002,0.0176557,0.0202423,
0.0225557,0.024465,0.0264045,0.0286529,0.0306121,0.032252,0.0335104,0.0344345,0.0350411,0.0354311,0.0358022,
0.0366556,0.0386516,0.0423383,0.04786,0.054316,0.0615624,0.0713199,0.0831789,0.0964688,0.110887,0.127358,
0.148396,0.168817,0.190304,0.210804,0.228409,0.246491,0.268739,0.29405,0.327689,0.361674,0.382311,0.393671,
0.407265,0.422521,0.414373,0.392452,0.370613,0.346329,0.31976,0.291677,0.26825,0.252388,0.238704,0.217235,
0.195457,0.178369,0.169101,0.160811,0.152233,0.143169,0.134993,0.126544,0.116626,0.104289,0.0902416,0.0780124,
0.0680749,0.0603199,0.0537235,0.0497363,0.0435864,0.037396,0.0315088,0.0256368,0.0205446,0.0163756,0.0125448,
0.00989979,0.00797258,0.00644475,0.00503749,0.00416714,0.00337968,0.00283901,0.00252722,0.00233978,0.00223522,
0.00216929,0.00209393,0.00196489,0.00178121,0.00160601,0.00145624,0.00129988,0.00113315,0.000996572,0.000927811,
0.000892017,0.00087412,0.000879772,0.000898611,0.00093252,0.000978675,0.00103802,0.00110678,0.00116141,
0.00121604,0.00125466,0.00129799,0.00134038,0.00138465,0.00147319,0.00158811,0.00178686,0.0020864,0.00237369,
0.00277213,0.0032252,0.00365002,0.00409461,0.00453921,0.00504597,0.00574018,0.00672733,0.00768623,0.0088288,
0.0102935,0.012703,0.0166705,0.0215252,0.0277552,0.0350571,0.0432171,0.0526318,0.0623894,0.0720829,0.0813431,
0.0913032,0.102335,0.113504,0.124288,0.135047,0.143074,0.150423,0.160583,0.172786,0.181657,0.188295,0.200161,
0.22016,0.244248,0.266907,0.292707,0.342512,0.414136,0.470701,0.516172,0.552223,0.570783,0.575253,0.565225,
0.530307,0.459159,0.375698,0.289836,0.220285,0.160124,0.114348,0.0828427,0.061049,0.0449503,0.034005,
0.0256895,0.019387,0.0148393,0.01199,0.0106675,0.0102295,0.0103453,0.0106854,0.0111234,0.0116122,0.0124421,
0.0137909,0.0161194,0.0190507,0.0226847,0.0268594,0.0306309,0.0339277,0.0368101,0.0398017,0.0423666,0.0445858,
0.0462342,0.0474323,0.0476216,0.0470876,0.0460853,0.0456068,0.0464047,0.0498201,0.0559644,0.0634396,0.0716524,
0.0810652,0.0920106,0.104387,0.117103,0.133301,0.15354,0.171674,0.188761,0.20446,0.224754,0.251554,0.277178,
0.295778,0.318006,0.338847,0.35937,0.373751,0.383599,0.390628,0.383817,0.365799,0.345589,0.327517,0.309784,
0.288847,0.266629,0.246943,0.231988,0.215229,0.201526,0.189859,0.178094,0.165358,0.155006,0.146217,0.138231,
0.1307,0.120918,0.107603,0.0922705,0.0795939,0.069486,0.0621106,0.0557449,0.0535078,0.0480078,0.0418937,
0.035238,0.0285078,0.0221412,0.0170387,0.0125937,0.00969727,0.00767022,0.00588901,0.0046692,0.00376117,
0.00295487,0.00244151,0.00217871,0.00200727,0.00185468,0.0017586,0.00166441,0.00155232,0.0014261,0.00130364,
0.00115199,0.00100222,0.000917449,0.000826081,0.000749784,0.000697977,0.000674429,0.000682906,0.000722468,
0.00078181,0.000837384,0.000894843,0.000927811,0.000958895,0.000989037,0.00101918,0.00105309,0.00108982,
0.00114728,0.001233,0.0013498,0.00151087,0.00172375,0.00204307,0.00235108,0.00278249,0.00324216,0.00373573,
0.00426416,0.00480954,0.0055047,0.00652953,0.00756378,0.00879018,0.0105196,0.0132644,0.0176322,0.0228157,
0.0295722,0.0371755,0.0456671,0.0555537,0.0665744,0.0782375,0.0897235,0.102218,0.113449,0.124646,0.137417,
0.149153,0.157114,0.164863,0.176305,0.189366,0.199186,0.2052,0.214958,0.236888,0.270258,0.303626,0.341457,
0.402189,0.475645,0.532114,0.559803,0.576179,0.578773,0.574115,0.558744,0.505781,0.425379,0.324993,0.243179,
0.179185,0.123507,0.0847991,0.0600694,0.044452,0.033777,0.0257131,0.0194586,0.0144041,0.0112204,0.00960402,
0.00903791,0.00917073,0.00974625,0.0104471,0.0112713,0.0121972,0.0135988,0.0158048,0.0186966,0.0225924,
0.0277844,0.0335726,0.0393081,0.0450031,0.0504437,0.0552363,0.0594439,0.0625382,0.0639728,0.0643251,0.0636403,
0.0614898,0.0588599,0.056637,0.0557082,0.0581846,0.0642808,0.0723589,0.0812206,0.0899487,0.0988895,0.109144,
0.121153,0.137654,0.157701,0.175238,0.189118,0.20233,0.222712,0.251466,0.276688,0.292306,0.308286,0.324472,
0.34135,0.356685,0.362467,0.370419,0.368644,0.356466,0.34036,0.326978,0.311775,0.29313,0.271752,0.250692,
0.233795,0.220121,0.212248,0.204679,0.190344,0.17528,0.163739,0.15323,0.14476,0.137703,0.127145,0.112459,
0.0957482,0.0818395,0.0711391,0.063936,0.0585576,0.0583777,0.0535342,0.04687,0.0390086,0.031133,0.0235711,
0.0174344,0.0122772,0.00920558,0.00716534,0.00529841,0.00418598,0.00320919,0.00245564,0.00206285,0.00178309,
0.00161825,0.00151087,0.0014195,0.00133473,0.00122829,0.00110019,0.000980559,0.000906146,0.000808184,
0.000701745,0.000617912,0.00055857,0.000528428,0.000516183,0.000530312,0.000559512,0.000611319,0.000648997,
0.000712106,0.000778042,0.00082043,0.000861875,0.000888249,0.00090332,0.000924043,0.000947591,0.00100222,
0.00112185,0.00129046,0.00147414,0.00170114,0.00203647,0.00234731,0.00279003,0.00329585,0.00389586,0.00449305,
0.00519857,0.00619043,0.00735467,0.00865266,0.0106166,0.0135837,0.0180372,0.0234308,0.0305697,0.0386299,
0.0478882,0.0583598,0.0703318,0.0842989,0.099871,0.114403,0.126105,0.139996,0.155095,0.166312,0.173345,
0.183176,0.198197,0.211668,0.222402,0.227208,0.237119,0.262293,0.303074,0.352217,0.398427,0.454922,0.530021,
0.568163,0.582559,0.588545,0.579008,0.561844,0.531356,0.463302,0.370186,0.267421,0.194955,0.139083,0.0929205,
0.0615548,0.0439556,0.0330009,0.0251818,0.019241,0.0142864,0.0108766,0.00886271,0.00791041,0.00781527,
0.00826929,0.0091208,0.0100571,0.0111639,0.0125118,0.0144249,0.0170472,0.0205211,0.0254776,0.031781,0.0392525,
0.0481331,0.05696,0.0654318,0.073622,0.080355,0.0845787,0.0853831,0.0835011,0.0805585,0.0774576,0.0736889,
0.0691949,0.0657926,0.0661279,0.0705202,0.0779691,0.0865878,0.0945416,0.10147,0.10956,0.120794,0.136542,
0.156438,0.175019,0.187944,0.198904,0.216207,0.240473,0.262394,0.277055,0.291339,0.309216,0.32909,0.34799,
0.356595,0.357206,0.353753,0.344811,0.33785,0.327122,0.30895,0.28857,0.27156,0.257683,0.245138,0.234645,
0.225395,0.2137,0.197585,0.185209,0.178225,0.16832,0.157281,0.148413,0.1353,0.119,0.101795,0.0871078,
0.0758638,0.0676793,0.0625382,0.0641169,0.0594486,0.051882,0.0423986,0.0330734,0.0244283,0.0173355,0.0116669,
0.00846615,0.00634208,0.00468144,0.00352945,0.0025357,0.00197525,0.00163332,0.00144965,0.00132343,0.00121228,
0.00110584,0.00100222,0.000933462,0.000868468,0.000774274,0.000666893,0.00058777,0.000505822,0.000427641,
0.000388079,0.000373008,0.000372066,0.000381486,0.000405034,0.000443654,0.000499228,0.000555744,0.000606609,
0.000632042,0.000671603,0.000704571,0.00074319,0.000778984,0.000817604,0.000886365,0.000947591,0.00107664,
0.00126503,0.0014666,0.00169926,0.00201952,0.00233978,0.00280415,0.00340511,0.00413794,0.00483874,0.00576185,
0.00708904,0.00848311,0.01061,0.0137683,0.0182331,0.0237906,0.0313007,0.0402321,0.0511963,0.0627087,0.0763649,
0.0930853,0.111707,0.126725,0.142254,0.1607,0.17918,0.190506,0.197391,0.208143,0.223097,0.234927,0.244709,
0.251651,0.264195,0.293311,0.340422,0.40027,0.457503,0.517707,0.56644,0.585686,0.592275,0.590518,0.575453,
0.542675,0.477039,0.395696,0.294862,0.209193,0.146621,0.099532,0.0642686,0.0440743,0.0322991,0.0243209,
0.0186598,0.013903,0.0106373,0.0084963,0.00720396,0.00663879,0.00678573,0.00744132,0.00831356,0.00942128,
0.0106053,0.0121887,0.0143721,0.0173468,0.0212652,0.0267709,0.0337883,0.0426369,0.0538648,0.0654752,0.0771213,
0.087736,0.096643,0.102209,0.103261,0.099921,0.0959837,0.0928131,0.0886629,0.0823576,0.0757875,0.0722317,
0.0735636,0.078424,0.0855281,0.0923346,0.0977715,0.104744,0.115761,0.130252,0.149385,0.168409,0.182242,
0.190926,0.204302,0.223836,0.240869,0.254309,0.267455,0.288569,0.316227,0.338025,0.351035,0.350695,0.342144,
0.336181,0.334315,0.32718,0.310192,0.289884,0.275243,0.266615,0.259157,0.250739,0.236565,0.218911,0.203361,
0.195411,0.191327,0.184466,0.173185,0.161665,0.146295,0.128136,0.110744,0.0957548,0.0833843,0.0736135,
0.0676671,0.0696998,0.0645144,0.05576,0.0448806,0.0340662,0.0243746,0.0165725,0.010756,0.00762783,0.00530689,
0.00398535,0.00272692,0.00195264,0.00153442,0.00131024,0.00113033,0.00100222,0.000936288,0.00088354,0.000799707,
0.000701745,0.000618854,0.000550093,0.000468144,0.000395615,0.000354169,0.00032026,0.000303305,0.000292943,
0.000294827,0.000303305,0.000319318,0.00034004,0.000368298,0.000394673,0.000435176,0.000472854,0.000516183,
0.000551035,0.000577409,0.000615087,0.000645229,0.00072341,0.00082043,0.000925927,0.00104838,0.00124619,
0.00144305,0.001671,0.00198843,0.0023426,0.0029332,0.00373573,0.00452037,0.00542557,0.00681588,0.00831921,
0.0105855,0.0140566,0.0187747,0.0246572,0.0327352,0.0428083,0.0557346,0.0699079,0.0867884,0.106728,0.125636,
0.143562,0.162313,0.185639,0.209329,0.222414,0.226455,0.237258,0.253668,0.267307,0.279849,0.288627,0.296468,
0.327009,0.389274,0.45661,0.519685,0.56439,0.584945,0.593233,0.59364,0.586193,0.562998,0.49538,0.40592,
0.311291,0.228563,0.157868,0.103476,0.0652397,0.0431578,0.0307901,0.022631,0.0171216,0.0128038,0.0099563,
0.00797823,0.00662089,0.00554803,0.00527957,0.00558759,0.00642591,0.0074093,0.00844355,0.00966713,0.0112129,
0.0133454,0.016515,0.0205126,0.0258562,0.0329246,0.0419163,0.0535417,0.0659829,0.0786369,0.0901945,0.100529,
0.107642,0.109928,0.107568,0.10442,0.102059,0.0980041,0.0909405,0.0820797,0.075294,0.073314,0.0750151,
0.0796627,0.0848132,0.0894278,0.0956804,0.10717,0.120316,0.13645,0.154373,0.169154,0.178746,0.193133,
0.211082,0.225787,0.237087,0.249088,0.271493,0.300405,0.323482,0.34004,0.348701,0.345246,0.342656,0.342119,
0.333459,0.321081,0.306235,0.292099,0.279305,0.269113,0.258942,0.245028,0.230366,0.217544,0.208838,0.203217,
0.199232,0.191463,0.179272,0.162541,0.144196,0.124452,0.108653,0.0931861,0.080891,0.0737416,0.0732019,
0.0661835,0.0561933,0.0445227,0.0331497,0.0229711,0.0148826,0.0095833,0.00662184,0.00446197,0.0030679,
0.00202517,0.00147131,0.00119344,0.000992805,0.000897669,0.000804417,0.000711165,0.000629216,0.000562338,
0.000486041,0.000416337,0.000370182,0.000335331,0.000303305,0.000269395,0.000240195,0.000232659,0.000226066,
0.000232659,0.000235485,0.00024773,0.000268453,0.000289176,0.00031084,0.000333447,0.000353227,0.000372066,
0.000390905,0.000417279,0.000459667,0.000508647,0.000570816,0.00065088,0.00078181,0.000902378,0.00100976,
0.00121133,0.00139407,0.00163144,0.0019988,0.00252534,0.00333352,0.00423779,0.00515618,0.00660677,0.00823067,
0.0106223,0.0144691,0.0197789,0.0262396,0.0347425,0.0463302,0.0615887,0.0796241,0.100304,0.121937,0.146027,
0.168682,0.19234,0.218686,0.245727,0.26192,0.266455,0.277057,0.292753,0.307041,0.326402,0.334853,0.340176,
0.378409,0.449392,0.529185,0.567935,0.584882,0.595006,0.597142,0.589253,0.567594,0.514497,0.421171,0.32016,
0.236082,0.168741,0.111248,0.0673628,0.0428055,0.0295844,0.0207349,0.0147536,0.0110085,0.00879772,0.00718323,
0.00567801,0.00479542,0.00434988,0.00433952,0.00465695,0.00521458,0.00614051,0.00726047,0.00828436,0.00969633,
0.0116179,0.0144173,0.0183895,0.0230097,0.0293132,0.0368732,0.0467353,0.0576646,0.0685478,0.0790627,0.0890642,
0.0973071,0.101177,0.100672,0.0991533,0.0979514,0.0949202,0.088629,0.0799528,0.0724973,0.0689151,0.0684395,
0.0708084,0.0747175,0.0788451,0.0850685,0.0955475,0.108078,0.121181,0.136311,0.152847,0.167158,0.18452,
0.202764,0.216508,0.225063,0.238945,0.264407,0.290354,0.309406,0.331558,0.349914,0.352028,0.351219,0.350209,
0.343126,0.335354,0.324071,0.309347,0.295752,0.284412,0.272338,0.26019,0.251837,0.241938,0.231157,0.222911,
0.218732,0.212671,0.200188,0.183402,0.164471,0.142866,0.121692,0.103813,0.0882023,0.0789138,0.0714574,
0.0622839,0.0516739,0.040267,0.029803,0.020199,0.0125184,0.00819205,0.00534739,0.00362176,0.00221921,
0.00148732,0.0010983,0.000915565,0.00078652,0.000651822,0.000569874,0.000496402,0.000421989,0.000376776,
0.00034004,0.000312724,0.00028164,0.000251498,0.000231717,0.000199691,0.00018462,0.000174259,0.000174259,
0.000174259,0.00018462,0.000192156,0.000207227,0.000224182,0.000237369,0.000251498,0.000271279,0.000288234,
0.000307072,0.000321201,0.00034475,0.000372066,0.000417279,0.000505822,0.000607551,0.000719642,0.000864701,
0.000970198,0.00114163,0.00136016,0.00164651,0.00217023,0.00294733,0.00394861,0.0048962,0.00637222,0.00816191,
0.0106759,0.0150079,0.0208894,0.0282525,0.0372895,0.0507404,0.0680825,0.0899562,0.11472,0.142071,0.172558,
0.202695,0.234088,0.265828,0.299176,0.325275,0.339874,0.348554,0.352847,0.36039,0.375735,0.389911,0.40586,
0.449277,0.518514,0.574199,0.592718,0.596379,0.59901,0.594585,0.57057,0.502179,0.420827,0.331408,0.245282,
0.176896,0.117617,0.0715714,0.0434762,0.0292793,0.0198975,0.0129554,0.00922442,0.00734054,0.0058372,0.00476339,
0.00405976,0.00341736,0.00315173,0.00323745,0.00363683,0.00419352,0.00480107,0.00558759,0.00674994,0.00791041,
0.009507,0.011665,0.0147677,0.0187926,0.0234119,0.0294968,0.0363391,0.0441421,0.0520356,0.0596898,0.0674627,
0.0749228,0.0795016,0.0805453,0.0798746,0.0794517,0.0776695,0.0737369,0.0681314,0.0633624,0.0602841,0.0590398,
0.0599903,0.0627643,0.0666338,0.0728713,0.0820156,0.0925409,0.10531,0.118825,0.134404,0.151647,0.170809,
0.189145,0.202564,0.21235,0.229554,0.255007,0.279882,0.296158,0.32091,0.343264,0.352804,0.354071,0.357895,
0.360807,0.360387,0.348516,0.328414,0.313884,0.304003,0.294806,0.286572,0.276747,0.266092,0.256372,0.249637,
0.244352,0.235924,0.221108,0.202969,0.180646,0.155352,0.130405,0.110689,0.0933896,0.0806724,0.0639615,
0.0535455,0.0431964,0.0334784,0.02427,0.0163596,0.0100712,0.00675653,0.00435741,0.00264214,0.00159376,
0.00108982,0.000847746,0.000662184,0.000556686,0.000450247,0.000385253,0.000345692,0.000314608,0.00028164,
0.00025715,0.000235485,0.000215704,0.000192156,0.000174259,0.000152594,0.000137523,0.000129988,0.000128104,
0.000132814,0.000140349,0.000149768,0.000159188,0.000172375,0.000181794,0.000192156,0.000203459,0.000217588,
0.000232659,0.000245846,0.000264685,0.000293885,0.000321201,0.000363589,0.000429525,0.000544441,0.000652764,
0.000808184,0.000934404,0.00110678,0.001379,0.00180381,0.00253664,0.00356618,0.00463058,0.0060237,0.0079349,
0.0105299,0.015202,0.0215431,0.0295534,0.0396557,0.0545779,0.0746977,0.101989,0.134184,0.170528,0.211261,
0.252381,0.300145,0.35266,0.403316,0.435489,0.453659,0.446141,0.434558,0.43261,0.433437,0.446873,0.476519,
0.5268,0.561315,0.588614,0.600519,0.59996,0.594064,0.577148,0.528347,0.428831,0.334091,0.253836,0.184794,
0.127562,0.0800121,0.0471799,0.0294064,0.0192033,0.0119636,0.00800272,0.00562526,0.00448834,0.00367922,
0.0029219,0.00236615,0.00211089,0.00202988,0.00213349,0.00242455,0.00293697,0.00357278,0.00422366,0.00488019,
0.00588524,0.0073509,0.00888626,0.010821,0.0133595,0.0169408,0.020798,0.0254983,0.0306413,0.0356534,0.0406164,
0.0458951,0.050828,0.0543057,0.0555066,0.0551082,0.0547785,0.0541785,0.05305,0.0512952,0.0496694,0.0481849,
0.0475378,0.0480135,0.050244,0.0537725,0.0590888,0.0666696,0.0755671,0.0864428,0.100275,0.114358,0.128919,
0.147588,0.167642,0.184064,0.196542,0.215232,0.243878,0.268761,0.288015,0.314215,0.339733,0.361377,0.368485,
0.367676,0.373765,0.382945,0.378554,0.361167,0.341498,0.330417,0.323414,0.318037,0.306308,0.290612,0.281842,
0.278322,0.269333,0.255552,0.239205,0.217321,0.188841,0.158249,0.130204,0.109851,0.0913408,0.07591,0.0524802,
0.0421198,0.0335679,0.0254512,0.0183,0.0118251,0.00779644,0.00493294,0.00314137,0.00178686,0.00114822,
0.000824197,0.000607551,0.00046155,0.000377718,0.000326853,0.000292943,0.000261859,0.000237369,0.000217588,
0.000195923,0.00017991,0.000164839,0.000148826,0.000127162,0.000113033,9.79617e-05,8.85423e-05,8.66585e-05,
9.3252e-05,0.000101729,0.000111149,0.000120568,0.000125278,0.000134697,0.000146001,0.000151652,0.000161072,
0.000174259,0.000187446,0.000198749,0.000224182,0.00024773,0.00028164,0.000325911,0.000382428,0.000483215,
0.000617912,0.000769565,0.000924043,0.00114822,0.00153065,0.00216269,0.00314137,0.00428488,0.00551317,
0.00752704,0.0100279,0.0146302,0.0212605,0.02964,0.0409292,0.058405,0.0837262,0.118699,0.164013,0.219041,
0.288198,0.364011,0.445952,0.519871,0.559719,0.574653,0.576047,0.561586,0.552665,0.545167,0.521801,0.522545,
0.553509,0.578266,0.591455,0.597687,0.600124,0.597407,0.584012,0.54851,0.469755,0.367767,0.265558,0.191058,
0.132508,0.0878349,0.0534683,0.0323773,0.0195961,0.0116169,0.00743002,0.00472194,0.00320919,0.00227949,
0.00180381,0.00154101,0.00139407,0.00133661,0.00134038,0.00141574,0.00155891,0.00179251,0.00218059,0.0026817,
0.00336084,0.00415961,0.00500735,0.00628933,0.00769,0.00910762,0.010724,0.0128292,0.0158877,0.019063,
0.0222797,0.0256989,0.0292614,0.032349,0.0346728,0.0358239,0.0357419,0.0354725,0.0353915,0.0353058,0.0351843,
0.0351965,0.0351617,0.0353661,0.0358757,0.0375325,0.040639,0.0451679,0.0513291,0.0582458,0.0668579,0.0780293,
0.0903396,0.104649,0.120918,0.142285,0.164117,0.181536,0.201268,0.228884,0.257044,0.285958,0.319028,0.355222,
0.382298,0.39276,0.386608,0.387287,0.399447,0.405529,0.396919,0.383083,0.370723,0.359213,0.358079,0.349539,
0.32915,0.314565,0.302608,0.286966,0.271054,0.252362,0.225692,0.191365,0.154977,0.122932,0.0998645,0.0812235,
0.0650607,0.0404054,0.0315936,0.0241702,0.0179534,0.0122122,0.00830885,0.00534833,0.00339098,0.00192815,
0.00122735,0.000847746,0.000574583,0.000409744,0.000340982,0.000296711,0.000251498,0.000225124,0.000197807,
0.00018462,0.000168607,0.000152594,0.000140349,0.000123394,0.000110207,8.76004e-05,7.34713e-05,6.311e-05,
5.84003e-05,5.55744e-05,5.93422e-05,6.311e-05,7.06455e-05,7.62971e-05,8.38326e-05,9.3252e-05,0.000102671,
0.000109265,0.000117742,0.000123394,0.000134697,0.000151652,0.000168607,0.00018933,0.000214762,0.00024773,
0.000300479,0.000355111,0.000450247,0.000600958,0.000769565,0.000953243,0.00129611,0.00178498,0.00263743,
0.00381015,0.00495366,0.00689029,0.00929506,0.0135658,0.0203647,0.0293395,0.0417138,0.0619278,0.0969284,
0.14699,0.213035,0.313167,0.449076,0.564061,0.603573,0.614621,0.619513,0.620183,0.617799,0.613089,0.607585,
0.599706,0.585013,0.581789,0.594,0.602755,0.605976,0.606742,0.60459,0.600062,0.581203,0.523987,0.416157,
0.297916,0.206974,0.140061,0.0912174,0.0565173,0.0353444,0.0213915,0.0120851,0.00736503,0.00443559,0.0024773,
0.00154101,0.00121133,0.00100222,0.000925927,0.000899552,0.000907088,0.000933462,0.000973024,0.00103425,
0.00114728,0.00131777,0.00153913,0.00190837,0.002466,0.00327512,0.004137,0.00488019,0.00578539,0.00691007,
0.00781716,0.00893901,0.0102163,0.0118082,0.0138371,0.0165094,0.0188105,0.0205446,0.0217494,0.0220951,
0.0220009,0.0218775,0.0219472,0.0223682,0.0227469,0.0232687,0.0239215,0.0247768,0.0264873,0.0293358,0.0328285,
0.0373781,0.0432266,0.0501856,0.0580037,0.0677434,0.0809578,0.0976518,0.118062,0.141321,0.163649,0.185843,
0.212996,0.243679,0.279885,0.322127,0.368911,0.403187,0.417685,0.413267,0.412322,0.426059,0.439966,0.437911,
0.428482,0.4116,0.394078,0.388011,0.387049,0.378177,0.356484,0.322997,0.298554,0.280788,0.25958,0.227764,
0.188753,0.148776,0.113096,0.0856073,0.0666253,0.0521656,0.0302174,0.0225312,0.0164453,0.0114173,0.0080809,
0.00536152,0.00346916,0.00189424,0.00120003,0.000841152,0.00056328,0.000379602,0.000317434,0.000271279,
0.000233601,0.000195923,0.000174259,0.00015542,0.000143175,0.000127162,0.000118684,0.000105497,8.38326e-05,
6.97035e-05,5.93422e-05,4.80389e-05,4.05034e-05,3.1084e-05,2.82582e-05,3.1084e-05,4.05034e-05,4.33292e-05,
4.99228e-05,5.55744e-05,5.93422e-05,6.311e-05,6.78197e-05,7.53552e-05,7.8181e-05,9.23101e-05,0.000107381,
0.000122452,0.000138465,0.000161072,0.000190272,0.000232659,0.00028164,0.000350402,0.000459667,0.000618854,
0.000829849,0.00107099,0.00151181,0.0021966,0.00324592,0.00441581,0.00601805,0.00854716,0.0126239,0.0196668,
0.0291201,0.043479,0.0714066,0.122882,0.199076,0.314305,0.489919,0.603778,0.626694,0.647368,0.664064,
0.671384,0.667486,0.655107,0.642086,0.626998,0.61531,0.608258,0.605811,0.609051,0.612931,0.614954,0.615427,
0.611402,0.604041,0.582644,0.492171,0.358668,0.233266,0.153905,0.097309,0.0587243,0.036244,0.0227488,
0.0129752,0.00762123,0.00442994,0.00226819,0.00129611,0.000920275,0.000742249,0.000628274,0.000593422,
0.000588712,0.000613203,0.000642403,0.000697035,0.000746016,0.000794055,0.000868468,0.000947591,0.00113033,
0.00141762,0.00178686,0.0022729,0.00283147,0.00339758,0.00397875,0.00442994,0.00492729,0.00555839,0.00639765,
0.00731039,0.00829095,0.00953243,0.0106128,0.0115246,0.0119391,0.0118873,0.0118006,0.0120305,0.0123809,
0.0127557,0.0132738,0.0140547,0.0152717,0.0170397,0.0193738,0.0222712,0.026218,0.0311076,0.036389,0.0428658,
0.0511445,0.0620748,0.0770836,0.0954392,0.117807,0.141932,0.166411,0.194067,0.226359,0.265898,0.312704,
0.371128,0.416011,0.441098,0.448935,0.451616,0.463522,0.477165,0.477387,0.469954,0.455683,0.436554,0.419616,
0.410975,0.402773,0.38256,0.343529,0.312062,0.288241,0.258629,0.219964,0.178735,0.136734,0.0993671,0.0704835,
0.0523888,0.0396048,0.0211607,0.0151238,0.0103547,0.00745357,0.00498098,0.00322991,0.00173694,0.00104555,
0.000745074,0.000508647,0.000350402,0.000284466,0.000246788,0.000215704,0.00018462,0.000159188,0.000138465,
0.000123394,0.000110207,9.3252e-05,7.8181e-05,6.68777e-05,5.84003e-05,4.7097e-05,3.76776e-05,2.73163e-05,
2.16646e-05,2.07227e-05,1.97807e-05,1.97807e-05,2.07227e-05,2.54324e-05,2.73163e-05,2.92001e-05,3.67357e-05,
4.05034e-05,4.33292e-05,4.80389e-05,5.08647e-05,5.93422e-05,6.68777e-05,7.91229e-05,0.000101729,0.00012151,
0.000148826,0.00017991,0.000230775,0.000288234,0.000365473,0.000510531,0.000699861,0.000936288,0.00132248,
0.00185374,0.00273257,0.00396462,0.00538413,0.00796222,0.0118581,0.0192278,0.0301995,0.0497438,0.0923374,
0.163496,0.280237,0.500186,0.612876,0.647413,0.688807,0.715075,0.726755,0.726703,0.719042,0.699739,0.673999,
0.648333,0.633762,0.624933,0.620965,0.623454,0.625725,0.626565,0.625442,0.618485,0.607261,0.572622,0.432273,
0.278059,0.172275,0.10606,0.0622066,0.0368694,0.022388,0.0130402,0.00775028,0.00448458,0.0022324,0.00116612,
0.0007771,0.000551977,0.000422931,0.000385253,0.000376776,0.00037866,0.000389021,0.000416337,0.000451189,
0.000476622,0.000505822,0.000537848,0.000607551,0.000704571,0.00087883,0.00101447,0.00124713,0.00143646,
0.00158528,0.00176896,0.00200727,0.0022437,0.00261294,0.00302834,0.00343054,0.00397028,0.0046042,0.00530406,
0.00594835,0.00644852,0.00654083,0.00649844,0.00659075,0.00674335,0.00697412,0.00728308,0.00777477,0.00849347,
0.00965771,0.0113297,0.0137043,0.0171603,0.0209167,0.0255398,0.0314928,0.0387495,0.0483903,0.0603181,
0.0759232,0.0962314,0.119395,0.144863,0.173807,0.210458,0.256697,0.310914,0.378701,0.430219,0.460032,
0.47591,0.486972,0.503884,0.509926,0.509429,0.502676,0.490681,0.47073,0.450831,0.429978,0.413489,0.389723,
0.355586,0.318971,0.284555,0.243977,0.20131,0.158474,0.116134,0.0807101,0.0549801,0.0393156,0.0291898,
0.0135875,0.00941751,0.00668212,0.0044582,0.00269018,0.00150145,0.000919333,0.000588712,0.000389021,0.000308014,
0.00024773,0.000217588,0.000192156,0.000169549,0.000148826,0.000123394,0.000111149,9.3252e-05,7.62971e-05,
6.49938e-05,5.55744e-05,4.52131e-05,3.67357e-05,2.73163e-05,2.07227e-05,1.78969e-05,1.41291e-05,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.41291e-05,1.69549e-05,1.97807e-05,2.07227e-05,2.54324e-05,2.63743e-05,
2.73163e-05,3.1084e-05,4.05034e-05,4.7097e-05,5.55744e-05,6.68777e-05,8.66585e-05,0.000118684,0.000148826,
0.000187446,0.000237369,0.000314608,0.000409744,0.000607551,0.000851514,0.00114446,0.00160507,0.00236992,
0.00358031,0.00504409,0.00760522,0.0114333,0.019761,0.0334323,0.0604697,0.122024,0.228928,0.438881,0.616955,
0.66589,0.716746,0.757144,0.783812,0.795932,0.784565,0.761938,0.729589,0.69515,0.671043,0.652983,0.64287,
0.640462,0.641679,0.641245,0.63863,0.633725,0.621981,0.603854,0.501778,0.313235,0.190099,0.112929,0.0639144,
0.0380741,0.0224907,0.0126512,0.00771825,0.00449588,0.0022437,0.00115576,0.000680081,0.000414454,0.000325911,
0.000288234,0.000275046,0.000274104,0.000275046,0.000287292,0.000303305,0.000317434,0.000325911,0.000329679,
0.000339098,0.000356995,0.000391847,0.000473796,0.000606609,0.000722468,0.000824197,0.000890133,0.00091274,
0.000935346,0.000972082,0.00104273,0.00116612,0.00128952,0.00145059,0.00172375,0.00218247,0.00267793,
0.00310652,0.00326759,0.00320165,0.00308674,0.00315079,0.0033307,0.00364813,0.00408613,0.00460138,0.00540391,
0.00678856,0.00819582,0.0101334,0.0129818,0.0172563,0.0225359,0.0295722,0.0374826,0.0472637,0.0599121,
0.0779323,0.101038,0.126136,0.157434,0.198364,0.25279,0.315831,0.386961,0.443679,0.475602,0.50217,0.533372,
0.549837,0.55016,0.544813,0.539522,0.522453,0.492833,0.470537,0.445528,0.411058,0.376528,0.336348,0.298949,
0.256294,0.210652,0.16824,0.125865,0.0877699,0.0585114,0.0397734,0.0282874,0.0199418,0.00842848,0.0057204,
0.0038676,0.00213255,0.00123394,0.000764855,0.000450247,0.00032026,0.000255266,0.00021382,0.00018462,
0.000162014,0.000148826,0.00012622,0.000112091,9.3252e-05,7.62971e-05,6.40519e-05,5.55744e-05,4.52131e-05,
3.95615e-05,2.73163e-05,2.16646e-05,1.78969e-05,1.31872e-05,1.13033e-05,9.4194e-06,6.59358e-06,6.59358e-06,
6.59358e-06,6.59358e-06,8.47746e-06,1.13033e-05,1.13033e-05,1.13033e-05,1.5071e-05,1.88388e-05,2.07227e-05,
2.16646e-05,2.63743e-05,2.82582e-05,4.05034e-05,4.99228e-05,6.49938e-05,8.76004e-05,0.00012151,0.000157304,
0.000204401,0.000270337,0.000354169,0.000520893,0.000751668,0.00100411,0.00145341,0.00216269,0.00334294,
0.00485005,0.00736691,0.0114992,0.0215422,0.038514,0.0770836,0.163217,0.355941,0.604775,0.667077,0.728266,
0.789146,0.840374,0.874658,0.870172,0.834101,0.78975,0.74613,0.712653,0.687112,0.67072,0.660875,0.658825,
0.659715,0.656427,0.647236,0.634483,0.614778,0.55745,0.341535,0.192165,0.110913,0.0605168,0.0355262,0.021513,
0.0120691,0.00732076,0.00434988,0.00217776,0.00112468,0.000659358,0.00036924,0.000271279,0.000230775,
0.000207227,0.000200633,0.000200633,0.000205343,0.000211936,0.000219472,0.000232659,0.000234543,0.000236427,
0.000237369,0.000240195,0.00025715,0.000282582,0.000323085,0.00036924,0.000417279,0.000460609,0.000464376,
0.000449305,0.000442712,0.00046155,0.000512415,0.000565164,0.000627332,0.000719642,0.000879772,0.00099563,
0.00115576,0.00125466,0.00123582,0.00114728,0.00113033,0.00123206,0.00137806,0.00159376,0.00193098,0.00253664,
0.00358314,0.00463717,0.0060482,0.00794338,0.0105855,0.0151379,0.0210034,0.0280293,0.0359331,0.0465168,
0.0623103,0.0845325,0.112369,0.14579,0.189887,0.246048,0.309207,0.384735,0.449619,0.490626,0.530701,0.561738,
0.576564,0.577383,0.570409,0.558663,0.53778,0.512482,0.484721,0.447457,0.397819,0.345314,0.295505,0.25288,
0.208059,0.165098,0.125576,0.0897471,0.059118,0.0393872,0.0270949,0.0186231,0.0121567,0.0049141,0.00317151,
0.00166723,0.000973024,0.000607551,0.000354169,0.000259975,0.000209111,0.000174259,0.000149768,0.000129988,
0.000120568,0.000106439,8.85423e-05,7.62971e-05,6.311e-05,5.18067e-05,4.33292e-05,3.67357e-05,2.73163e-05,
2.16646e-05,1.78969e-05,1.31872e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,6.59358e-06,9.4194e-06,1.13033e-05,1.31872e-05,
1.5071e-05,1.88388e-05,2.07227e-05,2.63743e-05,3.57937e-05,4.80389e-05,6.59358e-05,9.60779e-05,0.000129988,
0.000174259,0.000232659,0.00031084,0.000429525,0.000645229,0.000925927,0.00133473,0.00198373,0.00317151,
0.0047097,0.00728402,0.0121435,0.02419,0.0463896,0.0983602,0.215579,0.530376,0.640912,0.719504,0.790639,
0.874023,0.939875,0.957767,0.928137,0.862166,0.797864,0.750031,0.720256,0.698906,0.685278,0.676742,0.67088,
0.667832,0.657816,0.640615,0.61819,0.567256,0.339281,0.182918,0.0989084,0.0522937,0.0304068,0.0178149,
0.0101861,0.00624977,0.00376776,0.00190083,0.00103142,0.000617912,0.000348518,0.000235485,0.00018462,
0.000161072,0.000152594,0.000151652,0.000152594,0.000153536,0.000157304,0.000162014,0.000167665,0.000170491,
0.000171433,0.000170491,0.000169549,0.000174259,0.00018462,0.000204401,0.000232659,0.000250556,0.000264685,
0.000264685,0.00025715,0.000242079,0.000233601,0.000236427,0.000251498,0.000274104,0.000303305,0.000335331,
0.000385253,0.000450247,0.000479447,0.000454957,0.000408802,0.000401266,0.000459667,0.000578351,0.000719642,
0.000893901,0.00106345,0.00144965,0.00210147,0.00320071,0.00461362,0.00671791,0.00944106,0.0136911,0.0197374,
0.0266541,0.0357749,0.0495441,0.069956,0.0993737,0.136655,0.183226,0.235335,0.297783,0.380963,0.454237,
0.50735,0.551143,0.574504,0.587157,0.589247,0.582456,0.569224,0.542833,0.506169,0.470869,0.419668,0.360527,
0.295003,0.240403,0.195759,0.154937,0.116844,0.0840531,0.0572775,0.0383822,0.0255812,0.0168268,0.0106317,
0.00735938,0.00248672,0.00138088,0.000823255,0.000450247,0.00028164,0.000205343,0.000168607,0.000136581,
0.000118684,0.000102671,8.76004e-05,7.62971e-05,6.87616e-05,5.93422e-05,4.99228e-05,4.14454e-05,3.01421e-05,
2.63743e-05,2.07227e-05,1.78969e-05,1.13033e-05,9.4194e-06,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,
5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,
5.65164e-06,6.59358e-06,6.59358e-06,9.4194e-06,1.13033e-05,1.31872e-05,1.88388e-05,2.54324e-05,3.48518e-05,
4.99228e-05,7.15874e-05,0.000109265,0.000148826,0.000194982,0.000265627,0.000364531,0.000559512,0.000841152,
0.00118684,0.00176049,0.00291059,0.00460232,0.00749407,0.0133049,0.0268688,0.0541135,0.121863,0.294972,
0.608016,0.685245,0.763954,0.850066,0.944697,1,0.994716,0.934473,0.854288,0.787571,0.744851,0.720378,
0.704884,0.691187,0.681846,0.672488,0.658376,0.639285,0.617098,0.548785,0.297248,0.159461,0.0838439,0.0443531,
0.0253928,0.014034,0.00784918,0.00474078,0.00263837,0.00144399,0.000897669,0.000499228,0.000305188,0.000204401,
0.000148826,0.00012151,0.000116801,0.000111149,0.000111149,0.000112091,0.000117742,0.000118684,0.000120568,
0.00012151,0.00012151,0.000120568,0.000118684,0.000117742,0.000116801,0.000118684,0.000123394,0.000143175,
0.000153536,0.000161072,0.000157304,0.000151652,0.000142233,0.000133755,0.000132814,0.000143175,0.000152594,
0.000162956,0.00017991,0.000195923,0.000214762,0.000217588,0.000206285,0.000194982,0.00019404,0.000217588,
0.000258091,0.00032026,0.000393731,0.000551977,0.000746016,0.000980559,0.00142798,0.00234449,0.00411345,
0.0061763,0.00912363,0.0133171,0.0197751,0.0283364,0.040185,0.058258,0.0860688,0.124801,0.174313,0.225321,
0.292039,0.384618,0.471634,0.539094,0.570506,0.581413,0.587282,0.589304,0.58164,0.563833,0.519414,0.46032,
0.409959,0.35241,0.288132,0.230079,0.179736,0.138218,0.104481,0.074093,0.0514497,0.0358003,0.0240581,
0.0150823,0.00939491,0.00625919,0.00417844,0.00115388,0.000692326,0.000370182,0.000237369,0.000162956,
0.000123394,0.000105497,8.00649e-05,6.87616e-05,6.311e-05,5.84003e-05,4.99228e-05,4.33292e-05,3.67357e-05,
2.73163e-05,2.35485e-05,1.97807e-05,1.41291e-05,1.13033e-05,8.47746e-06,5.65164e-06,5.65164e-06,5.65164e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,7.53552e-06,1.13033e-05,
1.78969e-05,2.54324e-05,4.05034e-05,5.74583e-05,8.00649e-05,0.00012151,0.000167665,0.000232659,0.000314608,
0.000450247,0.000711165,0.00100222,0.00152594,0.00255925,0.00444972,0.00762877,0.0144833,0.0289468,0.0606741,
0.144649,0.380331,0.626209,0.71098,0.792161,0.884914,0.966008,0.9953,0.956787,0.880298,0.809663,0.756843,
0.725682,0.70622,0.69443,0.67997,0.665804,0.650608,0.631508,0.607959,0.497074,0.267629,0.133269,0.0669437,
0.036405,0.0214263,0.0117639,0.00673864,0.00361516,0.00170303,0.000957011,0.00062168,0.000361705,0.000240195,
0.000171433,0.000118684,8.00649e-05,7.62971e-05,7.53552e-05,7.53552e-05,7.53552e-05,7.62971e-05,7.8181e-05,
8.00649e-05,8.00649e-05,7.91229e-05,7.62971e-05,7.62971e-05,7.53552e-05,6.87616e-05,6.68777e-05,6.68777e-05,
6.87616e-05,7.53552e-05,7.91229e-05,8.28907e-05,8.10068e-05,7.62971e-05,6.87616e-05,6.59358e-05,6.59358e-05,
6.87616e-05,7.72391e-05,9.3252e-05,0.000111149,0.00012151,0.000125278,0.000127162,0.00012622,0.000123394,
0.000123394,0.000129988,0.000152594,0.000187446,0.000233601,0.000287292,0.000357937,0.00052466,0.000805359,
0.00126973,0.00229268,0.00419728,0.00654271,0.00956822,0.0150381,0.0229918,0.0339607,0.0492955,0.0744726,
0.11327,0.163544,0.221228,0.294092,0.39209,0.492412,0.556582,0.576625,0.58253,0.581571,0.576895,0.561652,
0.522783,0.450407,0.381677,0.317661,0.263626,0.211182,0.16438,0.122571,0.0894174,0.0631015,0.044485,0.0313299,
0.0214649,0.0134396,0.00854528,0.00551129,0.00360669,0.00199503,0.000604725,0.000327795,0.000210053,0.000137523,
9.60779e-05,7.15874e-05,5.93422e-05,4.99228e-05,4.33292e-05,4.05034e-05,3.1084e-05,2.73163e-05,2.54324e-05,
2.07227e-05,1.69549e-05,1.13033e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,3.76776e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,
5.65164e-06,6.59358e-06,1.13033e-05,1.88388e-05,2.73163e-05,4.23873e-05,6.311e-05,9.70198e-05,0.000141291,
0.000192156,0.000262801,0.000364531,0.000583061,0.000888249,0.00127821,0.00214197,0.00413512,0.00736503,
0.0146142,0.0296947,0.0617159,0.150159,0.407984,0.633454,0.719567,0.795636,0.867762,0.917501,0.914337,
0.866121,0.804992,0.758586,0.725056,0.702077,0.684062,0.669127,0.650119,0.632657,0.615403,0.583097,0.394632,
0.209283,0.109635,0.0528494,0.028942,0.0161383,0.00917638,0.0055047,0.00288893,0.00133661,0.000721526,
0.000384311,0.000258091,0.000178969,0.000129988,8.76004e-05,6.311e-05,5.36906e-05,5.08647e-05,5.08647e-05,
5.08647e-05,5.27486e-05,5.55744e-05,5.84003e-05,5.84003e-05,5.84003e-05,5.65164e-05,5.36906e-05,4.99228e-05,
4.80389e-05,4.52131e-05,4.33292e-05,4.23873e-05,4.23873e-05,4.23873e-05,4.14454e-05,4.14454e-05,4.14454e-05,
4.05034e-05,3.95615e-05,3.2026e-05,3.39098e-05,4.05034e-05,4.33292e-05,5.36906e-05,6.311e-05,6.87616e-05,
7.62971e-05,7.62971e-05,7.72391e-05,7.62971e-05,7.62971e-05,8.00649e-05,9.60779e-05,0.000118684,0.000143175,
0.000174259,0.000219472,0.000303305,0.000421989,0.000790287,0.00139125,0.00275423,0.00473419,0.00745545,
0.0114681,0.0187964,0.028488,0.0418099,0.0644287,0.101432,0.151082,0.218,0.300305,0.400465,0.497553,0.557064,
0.57485,0.581204,0.572858,0.551124,0.496619,0.434264,0.361532,0.286332,0.230723,0.185149,0.143043,0.106847,
0.0763047,0.05383,0.0377953,0.0262189,0.0177989,0.0112006,0.00747429,0.00486794,0.00313666,0.00170585,
0.000989037,0.000301421,0.00018933,0.00012151,6.97035e-05,4.99228e-05,4.14454e-05,3.01421e-05,2.73163e-05,
2.54324e-05,2.16646e-05,2.07227e-05,1.78969e-05,1.31872e-05,1.13033e-05,7.53552e-06,5.65164e-06,5.65164e-06,
5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,1.22452e-05,
2.07227e-05,3.01421e-05,4.99228e-05,7.62971e-05,0.000120568,0.000165781,0.000227007,0.000309898,0.000450247,
0.000712106,0.00103425,0.00171716,0.00355394,0.00691855,0.0135357,0.0275423,0.0570825,0.144629,0.403705,
0.630261,0.709932,0.771194,0.818852,0.833261,0.813171,0.776625,0.738633,0.710545,0.6871,0.667009,0.646385,
0.629462,0.612013,0.577693,0.429405,0.271813,0.158522,0.0812235,0.0411778,0.0233441,0.0126361,0.00720019,
0.00408613,0.00202894,0.000972082,0.000540673,0.000309898,0.000197807,0.000136581,9.60779e-05,6.87616e-05,
5.08647e-05,4.23873e-05,3.95615e-05,3.67357e-05,3.2026e-05,3.57937e-05,3.95615e-05,4.05034e-05,4.14454e-05,
4.14454e-05,4.05034e-05,4.05034e-05,3.76776e-05,3.1084e-05,2.82582e-05,2.73163e-05,2.73163e-05,2.73163e-05,
2.63743e-05,2.54324e-05,2.16646e-05,2.07227e-05,2.07227e-05,1.97807e-05,1.88388e-05,1.78969e-05,1.88388e-05,
2.07227e-05,2.54324e-05,2.82582e-05,4.05034e-05,4.33292e-05,4.80389e-05,5.08647e-05,5.27486e-05,5.55744e-05,
5.84003e-05,6.02841e-05,6.49938e-05,7.53552e-05,8.85423e-05,0.000118684,0.000153536,0.00021853,0.000312724,
0.00052466,0.000947591,0.00179251,0.00361234,0.0057091,0.00913682,0.0150258,0.0235428,0.0354716,0.0554426,
0.0893684,0.136373,0.206514,0.297307,0.398087,0.485336,0.545604,0.562768,0.562912,0.535659,0.472041,0.398857,
0.318394,0.252157,0.198752,0.157359,0.12003,0.0871436,0.0615181,0.0445867,0.0322944,0.021853,0.0137749,
0.00883163,0.00567613,0.00387514,0.00232377,0.00141668,0.000892017,0.000498286,0.000173317,0.000105497,
5.55744e-05,3.01421e-05,2.54324e-05,2.07227e-05,1.97807e-05,1.78969e-05,1.5071e-05,1.13033e-05,1.13033e-05,
6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,3.76776e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,9.4194e-06,1.69549e-05,2.54324e-05,4.23873e-05,
6.311e-05,0.000101729,0.000147885,0.000194982,0.000263743,0.000360763,0.000566106,0.000891075,0.0014261,
0.00306319,0.00657662,0.0129112,0.025958,0.053473,0.134694,0.35769,0.61382,0.676112,0.725873,0.752287,
0.750248,0.732018,0.707175,0.685911,0.660291,0.639083,0.622179,0.606859,0.563776,0.408249,0.269618,0.172144,
0.104463,0.0582901,0.0318865,0.0171282,0.00951548,0.00564222,0.00315267,0.00146566,0.00081572,0.000395615,
0.000270337,0.000190272,0.000134697,9.13682e-05,6.59358e-05,4.99228e-05,3.67357e-05,2.73163e-05,2.63743e-05,
2.54324e-05,2.54324e-05,2.54324e-05,2.54324e-05,2.63743e-05,2.63743e-05,2.63743e-05,2.63743e-05,2.54324e-05,
2.54324e-05,2.16646e-05,2.07227e-05,2.07227e-05,2.07227e-05,1.97807e-05,1.78969e-05,1.5071e-05,1.31872e-05,
1.13033e-05,1.13033e-05,8.47746e-06,6.59358e-06,7.53552e-06,9.4194e-06,1.13033e-05,1.5071e-05,1.97807e-05,
2.16646e-05,2.63743e-05,2.73163e-05,3.2026e-05,4.05034e-05,4.14454e-05,4.33292e-05,4.7097e-05,4.99228e-05,
5.84003e-05,6.59358e-05,8.19488e-05,0.00012151,0.000174259,0.000251498,0.000389021,0.000764855,0.00134038,
0.00256302,0.00459572,0.00744132,0.0117554,0.0196639,0.0307327,0.047811,0.0774764,0.121473,0.185826,0.269221,
0.36203,0.438432,0.483207,0.492382,0.471903,0.424777,0.357187,0.279142,0.215002,0.164856,0.124757,0.0944624,
0.0683066,0.0480418,0.034637,0.0255379,0.0179449,0.0111215,0.0071691,0.00438285,0.00253664,0.00151746,
0.000977733,0.000642403,0.000382428,0.000259975,0.000105497,5.27486e-05,2.73163e-05,1.78969e-05,1.41291e-05,
1.31872e-05,1.13033e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,5.65164e-06,6.59358e-06,1.13033e-05,2.07227e-05,3.1084e-05,5.55744e-05,8.10068e-05,0.000125278,
0.000174259,0.000234543,0.000318376,0.00046155,0.00075261,0.00125466,0.00286444,0.0063515,0.0128952,0.0257969,
0.0508374,0.118334,0.26874,0.565726,0.630634,0.670835,0.685993,0.676803,0.661373,0.642137,0.627825,0.610926,
0.588969,0.496285,0.385572,0.266458,0.171573,0.107009,0.0640152,0.0388192,0.0230012,0.012119,0.00665951,
0.00382051,0.00197242,0.00111997,0.000649938,0.000350402,0.000237369,0.00018462,0.000137523,0.000101729,
6.78197e-05,4.99228e-05,3.76776e-05,2.63743e-05,2.16646e-05,2.07227e-05,1.88388e-05,1.78969e-05,1.5071e-05,
1.78969e-05,1.78969e-05,1.88388e-05,1.88388e-05,1.78969e-05,1.78969e-05,1.5071e-05,1.41291e-05,1.31872e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,8.47746e-06,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,8.47746e-06,1.13033e-05,1.5071e-05,1.88388e-05,2.07227e-05,
2.54324e-05,2.73163e-05,2.82582e-05,3.1084e-05,4.05034e-05,4.23873e-05,4.80389e-05,5.84003e-05,7.15874e-05,
0.000105497,0.000149768,0.000217588,0.000331563,0.000612261,0.00104367,0.001882,0.00370842,0.0059135,
0.00956257,0.016305,0.0265467,0.0414595,0.0652265,0.10439,0.157758,0.223776,0.292381,0.355191,0.385327,
0.377254,0.339854,0.290855,0.23413,0.182463,0.137593,0.100082,0.0699079,0.050115,0.0365944,0.0262829,
0.0186598,0.0126455,0.00863288,0.00551317,0.00335519,0.00174918,0.00104273,0.00069421,0.000424815,0.00031084,
0.000233601,0.000164839,5.55744e-05,2.73163e-05,1.5071e-05,1.13033e-05,8.47746e-06,6.59358e-06,5.65164e-06,
5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,0,0,0,
0,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
3.76776e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,1.13033e-05,1.78969e-05,
2.73163e-05,4.80389e-05,7.62971e-05,0.000118684,0.000161072,0.000217588,0.000295769,0.000416337,0.000700803,
0.00122358,0.00287857,0.00631194,0.0126889,0.0249482,0.0462408,0.0972487,0.195293,0.371681,0.574037,0.612729,
0.616743,0.610394,0.607416,0.594794,0.547274,0.42333,0.315751,0.22975,0.166679,0.111836,0.0677848,0.0414397,
0.0258751,0.0154544,0.00892111,0.00510249,0.00254701,0.00125466,0.000799707,0.00047097,0.000305188,0.000219472,
0.000173317,0.000134697,0.000106439,7.62971e-05,5.55744e-05,4.14454e-05,2.73163e-05,2.07227e-05,1.78969e-05,
1.31872e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,
1.13033e-05,1.13033e-05,8.47746e-06,7.53552e-06,6.59358e-06,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,
5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,
6.59358e-06,1.13033e-05,1.31872e-05,1.69549e-05,2.07227e-05,2.16646e-05,2.54324e-05,2.73163e-05,2.92001e-05,
3.76776e-05,4.23873e-05,4.99228e-05,6.311e-05,9.04262e-05,0.000133755,0.000192156,0.000287292,0.00047568,
0.000888249,0.00147037,0.00280415,0.0048444,0.00806677,0.013239,0.0225312,0.0355083,0.0540363,0.0835293,
0.125245,0.17716,0.228873,0.267029,0.276324,0.255386,0.220956,0.183459,0.145253,0.110199,0.0791267,0.0547163,
0.0381071,0.0275922,0.0198015,0.0131203,0.00896915,0.00630252,0.00417091,0.00224653,0.00123582,0.000794997,
0.00047568,0.00032026,0.00024773,0.000196865,0.000153536,0.000105497,2.63743e-05,1.31872e-05,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,1.88388e-06,1.88388e-06,9.4194e-07,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,6.59358e-06,1.5071e-05,2.54324e-05,4.33292e-05,7.15874e-05,
0.000115859,0.000153536,0.000210995,0.000287292,0.00041257,0.000731887,0.00129799,0.00304623,0.00641744,
0.0122688,0.0229692,0.039828,0.0722816,0.132698,0.218175,0.331421,0.430383,0.447626,0.417293,0.398673,
0.329461,0.249834,0.190113,0.142451,0.101833,0.0672837,0.0432614,0.0285568,0.0172705,0.0097585,0.0059135,
0.00346445,0.00154761,0.000822313,0.000493576,0.000335331,0.00024773,0.00018933,0.000149768,0.000123394,
0.000101729,7.53552e-05,5.84003e-05,4.23873e-05,2.73163e-05,2.07227e-05,1.5071e-05,1.13033e-05,8.47746e-06,
6.59358e-06,6.59358e-06,6.59358e-06,6.59358e-06,6.59358e-06,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,
6.59358e-06,1.13033e-05,1.13033e-05,1.5071e-05,1.88388e-05,2.07227e-05,2.54324e-05,2.73163e-05,3.01421e-05,
4.05034e-05,4.7097e-05,5.93422e-05,8.00649e-05,0.000123394,0.000174259,0.000250556,0.000387137,0.000706455,
0.00115859,0.00211936,0.00413794,0.00700521,0.0111648,0.0187672,0.0291474,0.0430109,0.0642196,0.0965149,
0.134855,0.170392,0.189806,0.186711,0.164708,0.135727,0.109065,0.0828624,0.059622,0.0425502,0.030224,
0.0203374,0.0135658,0.00946555,0.00664256,0.00452508,0.00286726,0.00158999,0.000927811,0.000554803,0.000339098,
0.000237369,0.000190272,0.000156362,0.000123394,8.47746e-05,5.08647e-05,8.47746e-06,5.65164e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,6.59358e-06,1.31872e-05,
2.35485e-05,4.23873e-05,6.87616e-05,0.000114917,0.00015542,0.000214762,0.000295769,0.000429525,0.000792171,
0.00142045,0.00318752,0.00632795,0.0114794,0.0207745,0.0340182,0.054559,0.0892497,0.134036,0.182179,0.216213,
0.221231,0.207292,0.189995,0.156097,0.116807,0.0844732,0.0611309,0.0430353,0.0290843,0.0183961,0.0113824,
0.00705042,0.003926,0.00170209,0.000861875,0.000408802,0.000314608,0.000258091,0.000205343,0.000159188,
0.000123394,0.000105497,8.38326e-05,6.59358e-05,5.18067e-05,4.14454e-05,2.73163e-05,2.07227e-05,1.31872e-05,
8.47746e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,3.76776e-06,3.76776e-06,3.76776e-06,3.76776e-06,4.7097e-06,
4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.13033e-05,1.5071e-05,1.88388e-05,
2.07227e-05,2.54324e-05,2.73163e-05,3.2026e-05,4.33292e-05,5.84003e-05,7.62971e-05,0.000118684,0.000162014,
0.000232659,0.00034475,0.000591538,0.000944766,0.00163803,0.00343149,0.00587582,0.00948722,0.0152538,
0.0230964,0.0335905,0.0480342,0.0695594,0.0971319,0.118358,0.124269,0.116335,0.0990845,0.0788394,0.0598716,
0.044046,0.0318781,0.0224276,0.0148045,0.00954279,0.00681682,0.00462304,0.00298595,0.00174636,0.0011275,
0.000745074,0.000406918,0.000275046,0.000194982,0.000148826,0.000118684,8.28907e-05,6.02841e-05,3.95615e-05,
2.07227e-05,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,
1.13033e-05,2.16646e-05,4.23873e-05,6.87616e-05,0.000115859,0.000159188,0.000219472,0.000307072,0.000468144,
0.000848688,0.00150051,0.00322991,0.00589183,0.0101908,0.0179374,0.0280519,0.0411392,0.0593158,0.0823839,
0.103438,0.115068,0.115064,0.103767,0.0879254,0.0697205,0.0517737,0.0370908,0.0268575,0.0185411,0.0113824,
0.00752045,0.0048962,0.00266663,0.00109265,0.000451189,0.000237369,0.000200633,0.000192156,0.000170491,
0.000138465,0.000112091,8.47746e-05,7.15874e-05,5.93422e-05,4.7097e-05,3.67357e-05,2.63743e-05,2.07227e-05,
1.13033e-05,6.59358e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
3.76776e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.13033e-05,
1.5071e-05,1.88388e-05,2.07227e-05,2.54324e-05,2.82582e-05,4.23873e-05,5.55744e-05,7.62971e-05,0.000115859,
0.000153536,0.000217588,0.000314608,0.000498286,0.000830791,0.00135734,0.00271561,0.00497156,0.00807808,
0.012054,0.0182699,0.0258478,0.0357193,0.0483761,0.0630346,0.0741815,0.0748852,0.0663079,0.055549,0.0440583,
0.0335453,0.02401,0.0163022,0.0105441,0.00724634,0.0048849,0.00339852,0.00201763,0.00118873,0.000794055,
0.000520893,0.000330621,0.000234543,0.000167665,0.000118684,7.8181e-05,5.27486e-05,2.92001e-05,1.97807e-05,
8.47746e-06,5.65164e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,
4.7097e-06,5.65164e-06,5.65164e-06,1.13033e-05,2.16646e-05,4.23873e-05,6.87616e-05,0.000115859,0.000161072,
0.000227007,0.000318376,0.000505822,0.000888249,0.00150522,0.00309239,0.0053116,0.00875439,0.0141112,
0.0218116,0.0305556,0.0398262,0.0500019,0.0583042,0.060708,0.0569082,0.0492277,0.0400014,0.0323679,0.0245733,
0.0174297,0.0109425,0.00722656,0.00464,0.00301421,0.00162579,0.00082043,0.000317434,0.000186504,0.000147885,
0.000134697,0.000125278,0.000117742,9.3252e-05,7.62971e-05,6.311e-05,5.18067e-05,4.23873e-05,2.92001e-05,
2.54324e-05,1.78969e-05,1.13033e-05,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,3.76776e-06,3.76776e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,5.65164e-06,
5.65164e-06,6.59358e-06,8.47746e-06,1.13033e-05,1.22452e-05,1.5071e-05,1.97807e-05,2.16646e-05,2.73163e-05,
4.14454e-05,5.55744e-05,7.62971e-05,0.000112091,0.000152594,0.000205343,0.000289176,0.000421989,0.000730003,
0.00115293,0.00216269,0.00423779,0.00678856,0.00978487,0.0138606,0.0195679,0.0262293,0.0338901,0.0406042,
0.0445198,0.0433434,0.0385074,0.0324319,0.0254832,0.0187201,0.0122386,0.0081101,0.00526262,0.00352003,
0.00219001,0.00144399,0.000936288,0.000599074,0.00036924,0.000270337,0.000193098,0.000137523,9.3252e-05,
5.84003e-05,2.73163e-05,1.41291e-05,5.65164e-06,4.7097e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,1.13033e-05,2.16646e-05,
4.14454e-05,6.78197e-05,0.000115859,0.000161072,0.000232659,0.000324027,0.000526544,0.000895785,0.00146566,
0.00275235,0.00470122,0.00729061,0.0105441,0.0157191,0.0212897,0.0265005,0.0306545,0.033193,0.03295,0.0297248,
0.0250038,0.0202771,0.0155043,0.0107504,0.00739988,0.0047097,0.00270713,0.00148732,0.000924043,0.000498286,
0.00024302,0.000157304,0.000123394,0.000109265,9.60779e-05,8.19488e-05,7.53552e-05,6.40519e-05,5.84003e-05,
4.80389e-05,4.05034e-05,2.73163e-05,2.07227e-05,1.41291e-05,8.47746e-06,5.65164e-06,4.7097e-06,3.76776e-06,
2.82582e-06,2.82582e-06,3.76776e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,3.76776e-06,3.76776e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
1.88388e-06,1.88388e-06,0,0,0,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,4.7097e-06,
4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,9.4194e-06,1.13033e-05,1.31872e-05,1.78969e-05,
2.16646e-05,2.73163e-05,4.14454e-05,5.84003e-05,7.62971e-05,0.000112091,0.000151652,0.000195923,0.000272221,
0.000386195,0.000642403,0.00100505,0.00177085,0.00343902,0.0053521,0.00794432,0.0107193,0.0143731,0.0187926,
0.0229833,0.0263913,0.0275725,0.0259796,0.022778,0.0185911,0.0133953,0.00954562,0.00666234,0.00421047,
0.00227855,0.00136016,0.000944766,0.000671603,0.000421989,0.000307072,0.000232659,0.000165781,0.000118684,
7.62971e-05,4.7097e-05,2.35485e-05,9.4194e-06,4.7097e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,1.13033e-05,2.07227e-05,4.05034e-05,
6.59358e-05,0.000111149,0.000159188,0.000232659,0.000326853,0.00052466,0.000876004,0.00136581,0.00234543,
0.00404469,0.00567236,0.00795657,0.0103011,0.0132248,0.0162984,0.0179939,0.0181022,0.0167957,0.0141357,
0.0115049,0.00928941,0.00723033,0.00495366,0.00325158,0.00179157,0.00100788,0.000551035,0.000282582,0.000177085,
0.000123394,0.000102671,8.47746e-05,7.62971e-05,6.59358e-05,6.02841e-05,5.46325e-05,4.80389e-05,4.23873e-05,
3.1084e-05,2.54324e-05,1.88388e-05,1.13033e-05,6.59358e-06,5.65164e-06,4.7097e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,
1.88388e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,
7.53552e-06,1.13033e-05,1.13033e-05,1.69549e-05,2.07227e-05,2.73163e-05,4.23873e-05,5.84003e-05,7.62971e-05,
0.000113033,0.000149768,0.000195923,0.000262801,0.000363589,0.000588712,0.000926869,0.00153913,0.00273822,
0.00438756,0.00629969,0.00832581,0.0104235,0.0126248,0.0149015,0.0163022,0.0162551,0.0145709,0.0120691,
0.00949287,0.00723504,0.00504032,0.00330715,0.00175389,0.00101353,0.000652764,0.000415395,0.000307072,
0.000236427,0.000188388,0.000143175,9.98456e-05,6.59358e-05,4.33292e-05,2.54324e-05,1.13033e-05,4.7097e-06,
2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,
5.65164e-06,1.13033e-05,2.07227e-05,4.05034e-05,6.40519e-05,0.000107381,0.000153536,0.000224182,0.000321201,
0.000505822,0.000811952,0.00123582,0.00197242,0.00322049,0.00451378,0.00585698,0.00742437,0.00854528,
0.00942222,0.00970669,0.00914906,0.00803192,0.00685732,0.00543405,0.00436589,0.00318847,0.00206285,0.00133944,
0.00086941,0.00044177,0.000240195,0.000149768,0.000105497,7.62971e-05,6.87616e-05,6.2168e-05,5.46325e-05,
4.80389e-05,4.23873e-05,4.05034e-05,3.01421e-05,2.63743e-05,2.07227e-05,1.41291e-05,8.47746e-06,5.65164e-06,
4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,4.7097e-06,
5.65164e-06,5.65164e-06,6.59358e-06,9.4194e-06,1.13033e-05,1.6013e-05,2.16646e-05,2.73163e-05,4.23873e-05,
5.93422e-05,7.8181e-05,0.000113975,0.000149768,0.000193098,0.00025715,0.000347576,0.00053408,0.00084963,
0.0013319,0.00218436,0.00352474,0.00483027,0.00635904,0.00768623,0.00858013,0.00913022,0.00924796,0.00879018,
0.00781622,0.0064683,0.00486135,0.00363495,0.00227007,0.00138088,0.000906146,0.000562338,0.00034475,0.00024773,
0.00018933,0.000148826,0.000118684,7.72391e-05,5.55744e-05,4.05034e-05,2.54324e-05,1.13033e-05,5.65164e-06,
2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,
1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,
6.59358e-06,1.13033e-05,2.07227e-05,3.95615e-05,6.311e-05,0.000105497,0.000152594,0.000217588,0.00031084,
0.000463434,0.000735655,0.00104555,0.00157398,0.00237651,0.00346822,0.00438002,0.00509213,0.00564881,
0.00592103,0.0056799,0.00509118,0.00434328,0.00340794,0.00248672,0.00176237,0.00127727,0.000907088,0.000590596,
0.000347576,0.000219472,0.000134697,9.3252e-05,6.87616e-05,5.84003e-05,4.99228e-05,4.33292e-05,4.05034e-05,
3.01421e-05,2.73163e-05,2.16646e-05,1.97807e-05,1.41291e-05,9.4194e-06,5.65164e-06,5.65164e-06,4.7097e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,
5.65164e-06,7.53552e-06,1.13033e-05,1.5071e-05,2.16646e-05,2.73163e-05,4.33292e-05,5.93422e-05,7.91229e-05,
0.000116801,0.000149768,0.000192156,0.00024773,0.000327795,0.000467202,0.000734713,0.00107852,0.00167477,
0.00258845,0.00370842,0.00459196,0.00527957,0.0057091,0.00569308,0.0053116,0.00474643,0.00409744,0.00314325,
0.00213444,0.00144117,0.000980559,0.000704571,0.000450247,0.00030613,0.000219472,0.000164839,0.000123394,
9.3252e-05,6.40519e-05,4.23873e-05,2.73163e-05,2.07227e-05,1.13033e-05,5.65164e-06,4.7097e-06,2.82582e-06,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,
2.82582e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,8.47746e-06,
1.22452e-05,2.07227e-05,3.67357e-05,6.2168e-05,0.000101729,0.000149768,0.000207227,0.000293885,0.000409744,
0.000635809,0.000917449,0.00127256,0.001736,0.00235014,0.00306601,0.00360669,0.0038676,0.003845,0.00352756,
0.00296523,0.00223334,0.00162108,0.00121981,0.000901436,0.000611319,0.000368298,0.000259975,0.000183678,
0.000123394,8.76004e-05,6.40519e-05,4.99228e-05,4.23873e-05,3.67357e-05,2.73163e-05,2.54324e-05,2.07227e-05,
1.5071e-05,1.13033e-05,8.47746e-06,5.65164e-06,5.65164e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,
1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,
1.13033e-05,1.69549e-05,2.16646e-05,2.82582e-05,4.33292e-05,6.12261e-05,8.10068e-05,0.000118684,0.000149768,
0.000190272,0.000238311,0.000314608,0.000409744,0.000619796,0.000907088,0.00129611,0.00180193,0.00247448,
0.00317151,0.003634,0.00381391,0.00364625,0.00315927,0.0024547,0.00181983,0.00136864,0.00100788,0.00078181,
0.000536906,0.000354169,0.000254324,0.000187446,0.000143175,0.000110207,7.62971e-05,5.55744e-05,3.95615e-05,
2.54324e-05,1.97807e-05,1.13033e-05,5.65164e-06,4.7097e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,4.7097e-06,
4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.41291e-05,2.07227e-05,3.67357e-05,
5.93422e-05,9.60779e-05,0.000141291,0.000195923,0.000271279,0.000363589,0.000547267,0.000778984,0.000981501,
0.00130364,0.00159753,0.00194416,0.00218342,0.00226442,0.00218247,0.00191025,0.00155891,0.00123206,0.000925927,
0.000669719,0.000438944,0.000307072,0.00021853,0.000153536,0.000113033,7.8181e-05,6.2168e-05,4.80389e-05,
3.67357e-05,2.73163e-05,2.54324e-05,2.07227e-05,1.5071e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,
4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,1.88388e-06,1.88388e-06,0,0,1.88388e-06,1.88388e-06,1.88388e-06,
1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,
1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,
5.65164e-06,6.59358e-06,1.13033e-05,1.78969e-05,2.16646e-05,3.01421e-05,4.7097e-05,6.311e-05,8.47746e-05,
0.000118684,0.000149768,0.00018462,0.000232659,0.000293885,0.000368298,0.000519951,0.000734713,0.000968314,
0.00130364,0.00161072,0.00194887,0.00214668,0.00216269,0.00198843,0.00166158,0.00133944,0.000996572,0.000800649,
0.000573641,0.000386195,0.00028635,0.000207227,0.000152594,0.000118684,8.10068e-05,6.02841e-05,4.33292e-05,
2.73163e-05,2.16646e-05,1.78969e-05,1.13033e-05,6.59358e-06,5.65164e-06,4.7097e-06,2.82582e-06,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,
2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.13033e-05,1.69549e-05,
2.16646e-05,3.67357e-05,5.84003e-05,8.85423e-05,0.00013093,0.000182736,0.000243962,0.000325911,0.000429525,
0.000617912,0.000808184,0.000955127,0.00113033,0.00129423,0.00136675,0.00136487,0.00127727,0.00109265,
0.000917449,0.000711165,0.000519951,0.000356053,0.000262801,0.00019404,0.000147885,0.000106439,7.62971e-05,
5.93422e-05,4.42712e-05,2.92001e-05,2.16646e-05,1.88388e-05,1.41291e-05,1.13033e-05,6.59358e-06,5.65164e-06,
5.65164e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,1.88388e-06,
1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,
6.59358e-06,1.13033e-05,1.78969e-05,2.54324e-05,3.39098e-05,4.99228e-05,6.59358e-05,8.94843e-05,0.000120568,
0.000149768,0.00017991,0.00021853,0.000265627,0.000327795,0.000414454,0.00056799,0.000753552,0.00093252,
0.00110961,0.00126314,0.00133284,0.00129799,0.00116612,0.000976792,0.000810068,0.000607551,0.000414454,
0.000314608,0.000236427,0.000177085,0.000129988,9.60779e-05,6.68777e-05,4.80389e-05,3.1084e-05,2.54324e-05,
2.07227e-05,1.69549e-05,1.13033e-05,6.59358e-06,5.65164e-06,4.7097e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,3.76776e-06,
4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,8.47746e-06,1.13033e-05,1.41291e-05,1.88388e-05,2.35485e-05,
3.67357e-05,5.74583e-05,8.10068e-05,0.000123394,0.000165781,0.000219472,0.000282582,0.000359821,0.000470028,
0.000612261,0.000734713,0.00084021,0.000898611,0.000915565,0.000891075,0.000801591,0.000647113,0.000505822,
0.000363589,0.00028164,0.000217588,0.000169549,0.000125278,9.51359e-05,6.97035e-05,5.65164e-05,4.23873e-05,
2.73163e-05,2.07227e-05,1.31872e-05,9.4194e-06,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,
2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,
1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,
2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.88388e-05,2.63743e-05,4.05034e-05,
5.18067e-05,6.87616e-05,9.60779e-05,0.000123394,0.000149768,0.000175201,0.000206285,0.000242079,0.000292943,
0.000348518,0.000422931,0.000555744,0.000664068,0.000793113,0.00087412,0.000891075,0.000852455,0.000750726,
0.000617912,0.000460609,0.000348518,0.000272221,0.000214762,0.000165781,0.000123394,8.85423e-05,6.40519e-05,
4.7097e-05,2.92001e-05,2.54324e-05,2.07227e-05,1.5071e-05,1.13033e-05,6.59358e-06,5.65164e-06,4.7097e-06,
2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,1.88388e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,1.13033e-05,
1.31872e-05,1.69549e-05,2.07227e-05,2.54324e-05,3.67357e-05,5.18067e-05,7.62971e-05,0.000114917,0.000149768,
0.000192156,0.000238311,0.000303305,0.000359821,0.000429525,0.00052466,0.000581177,0.000611319,0.000599074,
0.000544441,0.000448363,0.000360763,0.000295769,0.000232659,0.000178969,0.000141291,0.000111149,7.91229e-05,
6.311e-05,4.99228e-05,4.05034e-05,2.63743e-05,1.78969e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,
4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,1.88388e-06,0,0,0,0,
0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,9.4194e-07,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,6.59358e-06,1.31872e-05,
2.07227e-05,2.73163e-05,4.14454e-05,5.74583e-05,7.53552e-05,0.000102671,0.000123394,0.000149768,0.000174259,
0.000195923,0.000232659,0.000258091,0.000303305,0.000343808,0.000393731,0.000460609,0.000528428,0.000562338,
0.000564222,0.000531254,0.000450247,0.000370182,0.00031084,0.00024773,0.000197807,0.00016013,0.000123394,
8.76004e-05,6.311e-05,4.7097e-05,2.82582e-05,2.16646e-05,1.88388e-05,1.41291e-05,1.13033e-05,5.65164e-06,
5.65164e-06,4.7097e-06,2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,
8.47746e-06,1.13033e-05,1.41291e-05,1.88388e-05,2.07227e-05,2.54324e-05,3.2026e-05,4.99228e-05,6.87616e-05,
9.98456e-05,0.000129988,0.000162956,0.000197807,0.000242079,0.000289176,0.000327795,0.000359821,0.000379602,
0.000381486,0.000364531,0.000335331,0.000293885,0.000237369,0.000192156,0.000151652,0.000118684,8.19488e-05,
6.311e-05,4.99228e-05,4.05034e-05,2.73163e-05,2.07227e-05,1.41291e-05,8.47746e-06,5.65164e-06,5.65164e-06,
4.7097e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,1.88388e-06,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,2.82582e-06,3.76776e-06,4.7097e-06,5.65164e-06,8.47746e-06,1.41291e-05,2.16646e-05,
2.82582e-05,4.33292e-05,5.93422e-05,7.62971e-05,0.000105497,0.000125278,0.000149768,0.000173317,0.000192156,
0.000216646,0.000237369,0.000262801,0.000288234,0.000317434,0.00034004,0.000359821,0.000364531,0.000359821,
0.000339098,0.000308956,0.000268453,0.000228891,0.000186504,0.000151652,0.000118684,8.00649e-05,5.93422e-05,
4.33292e-05,2.73163e-05,2.16646e-05,1.78969e-05,1.31872e-05,1.13033e-05,5.65164e-06,5.65164e-06,4.7097e-06,
3.76776e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,1.13033e-05,
1.22452e-05,1.5071e-05,1.97807e-05,2.16646e-05,2.63743e-05,3.01421e-05,4.52131e-05,6.2168e-05,8.00649e-05,
0.000115859,0.000138465,0.000168607,0.000194982,0.000227007,0.00024773,0.000271279,0.000275046,0.000274104,
0.00025715,0.000232659,0.000194982,0.000159188,0.000123394,8.76004e-05,6.2168e-05,4.52131e-05,3.1084e-05,
2.54324e-05,1.97807e-05,1.31872e-05,1.03613e-05,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,9.4194e-07,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,3.76776e-06,4.7097e-06,
5.65164e-06,1.13033e-05,1.69549e-05,2.54324e-05,3.1084e-05,4.7097e-05,6.2168e-05,7.91229e-05,0.000106439,
0.000125278,0.000149768,0.000170491,0.00018933,0.000204401,0.000224182,0.000237369,0.000250556,0.000262801,
0.000274104,0.000278814,0.000275046,0.000268453,0.00024773,0.000225124,0.000194982,0.000167665,0.000136581,
0.000110207,7.62971e-05,5.55744e-05,4.05034e-05,2.73163e-05,2.07227e-05,1.78969e-05,1.13033e-05,9.4194e-06,
5.65164e-06,5.65164e-06,4.7097e-06,3.76776e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,
5.65164e-06,5.65164e-06,7.53552e-06,1.13033e-05,1.31872e-05,1.78969e-05,2.07227e-05,2.16646e-05,2.63743e-05,
2.82582e-05,4.23873e-05,5.55744e-05,6.87616e-05,9.3252e-05,0.000118684,0.000135639,0.000156362,0.000174259,
0.000191214,0.000195923,0.000199691,0.000194982,0.000182736,0.000159188,0.00013093,0.000104555,6.87616e-05,
4.80389e-05,2.73163e-05,2.07227e-05,1.41291e-05,1.03613e-05,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,
4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,1.88388e-06,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,4.7097e-06,
4.7097e-06,5.65164e-06,1.13033e-05,1.88388e-05,2.54324e-05,3.76776e-05,4.99228e-05,6.311e-05,8.00649e-05,
0.000106439,0.000123394,0.000148826,0.000164839,0.000181794,0.000195923,0.000208169,0.000220414,0.000232659,
0.000233601,0.000234543,0.000232659,0.000224182,0.000209111,0.000192156,0.000174259,0.000149768,0.000123394,
9.60779e-05,6.87616e-05,4.99228e-05,3.2026e-05,2.54324e-05,2.07227e-05,1.5071e-05,1.13033e-05,8.47746e-06,
5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,4.7097e-06,
4.7097e-06,5.65164e-06,5.65164e-06,9.4194e-06,1.13033e-05,1.41291e-05,1.78969e-05,2.07227e-05,2.16646e-05,
2.54324e-05,2.73163e-05,3.95615e-05,4.80389e-05,5.93422e-05,7.53552e-05,9.3252e-05,0.000112091,0.000123394,
0.000134697,0.000146001,0.000149768,0.000148826,0.000136581,0.000123394,0.000105497,7.62971e-05,5.55744e-05,
3.67357e-05,2.07227e-05,1.13033e-05,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,4.7097e-06,5.65164e-06,6.59358e-06,
1.13033e-05,2.07227e-05,2.73163e-05,4.05034e-05,4.99228e-05,6.49938e-05,8.00649e-05,0.000105497,0.000123394,
0.000143175,0.000157304,0.000174259,0.000188388,0.000195923,0.000204401,0.000209111,0.000210053,0.000206285,
0.000196865,0.000191214,0.000175201,0.000159188,0.000138465,0.000118684,8.85423e-05,6.59358e-05,4.7097e-05,
2.82582e-05,2.16646e-05,1.88388e-05,1.41291e-05,1.13033e-05,8.47746e-06,5.65164e-06,5.65164e-06,4.7097e-06,
3.76776e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,3.76776e-06,4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,
1.13033e-05,1.13033e-05,1.5071e-05,1.88388e-05,2.07227e-05,2.16646e-05,2.54324e-05,2.73163e-05,3.1084e-05,
4.14454e-05,4.99228e-05,6.02841e-05,6.97035e-05,8.00649e-05,9.3252e-05,0.000105497,0.000109265,0.000106439,
0.000102671,8.85423e-05,7.53552e-05,5.93422e-05,4.23873e-05,2.63743e-05,1.41291e-05,5.65164e-06,4.7097e-06,
3.76776e-06,2.82582e-06,2.82582e-06,1.88388e-06,1.88388e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,4.7097e-06,
5.65164e-06,6.59358e-06,1.41291e-05,2.07227e-05,2.73163e-05,4.14454e-05,5.08647e-05,6.49938e-05,7.91229e-05,
0.000102671,0.000120568,0.000134697,0.000151652,0.000162956,0.000174259,0.00018462,0.000190272,0.000192156,
0.000192156,0.000186504,0.000177085,0.000165781,0.000151652,0.00013093,0.000115859,8.47746e-05,6.40519e-05,
4.52131e-05,2.73163e-05,2.07227e-05,1.5071e-05,1.22452e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,
4.7097e-06,3.76776e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,3.76776e-06,4.7097e-06,5.65164e-06,5.65164e-06,
6.59358e-06,1.13033e-05,1.22452e-05,1.5071e-05,1.88388e-05,2.07227e-05,2.16646e-05,2.54324e-05,2.63743e-05,
2.73163e-05,3.2026e-05,4.14454e-05,4.80389e-05,5.55744e-05,6.2168e-05,6.68777e-05,7.15874e-05,7.34713e-05,
6.87616e-05,6.311e-05,5.55744e-05,4.33292e-05,2.73163e-05,2.07227e-05,1.03613e-05,5.65164e-06,2.82582e-06,
1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,3.76776e-06,4.7097e-06,5.65164e-06,9.4194e-06,1.5071e-05,2.16646e-05,
2.82582e-05,4.23873e-05,5.08647e-05,6.40519e-05,7.62971e-05,9.60779e-05,0.000115859,0.00012622,0.000143175,
0.000152594,0.000162014,0.000171433,0.000174259,0.000174259,0.000171433,0.000164839,0.000153536,0.000144117,
0.000125278,0.000111149,8.28907e-05,6.311e-05,4.7097e-05,2.73163e-05,2.07227e-05,1.41291e-05,1.13033e-05,
8.47746e-06,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,3.76776e-06,2.82582e-06,9.4194e-07,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,
4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.31872e-05,1.5071e-05,1.88388e-05,
2.07227e-05,2.16646e-05,2.54324e-05,2.54324e-05,2.63743e-05,2.73163e-05,3.01421e-05,3.95615e-05,4.23873e-05,
4.7097e-05,4.99228e-05,4.99228e-05,4.99228e-05,4.7097e-05,4.14454e-05,2.92001e-05,2.16646e-05,1.41291e-05,
6.59358e-06,4.7097e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,4.7097e-06,5.65164e-06,5.65164e-06,
1.13033e-05,1.78969e-05,2.54324e-05,3.01421e-05,4.23873e-05,5.08647e-05,6.311e-05,7.62971e-05,8.85423e-05,
0.000107381,0.000120568,0.000129988,0.000143175,0.00015071,0.000153536,0.00015542,0.000153536,0.000152594,
0.000147885,0.000133755,0.00012151,0.000105497,8.00649e-05,6.40519e-05,4.80389e-05,2.82582e-05,2.07227e-05,
1.31872e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,
1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.31872e-05,
1.5071e-05,1.88388e-05,2.07227e-05,2.07227e-05,2.16646e-05,2.54324e-05,2.54324e-05,2.63743e-05,2.73163e-05,
2.73163e-05,2.82582e-05,3.01421e-05,3.1084e-05,3.1084e-05,2.82582e-05,2.73163e-05,2.35485e-05,1.88388e-05,
1.13033e-05,5.65164e-06,4.7097e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,
6.59358e-06,1.22452e-05,1.97807e-05,2.54324e-05,3.1084e-05,4.23873e-05,5.08647e-05,6.2168e-05,7.15874e-05,
8.19488e-05,9.98456e-05,0.000111149,0.00012151,0.000127162,0.000134697,0.000138465,0.000141291,0.000137523,
0.000133755,0.000123394,0.000118684,0.000102671,8.00649e-05,6.59358e-05,4.99228e-05,3.29679e-05,2.16646e-05,
1.41291e-05,8.47746e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,
1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.13033e-05,
1.5071e-05,1.78969e-05,2.07227e-05,2.07227e-05,2.16646e-05,2.16646e-05,2.35485e-05,2.54324e-05,2.54324e-05,
2.54324e-05,2.54324e-05,2.54324e-05,2.16646e-05,2.16646e-05,2.07227e-05,1.78969e-05,1.22452e-05,7.53552e-06,
5.65164e-06,4.7097e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,4.7097e-06,4.7097e-06,
5.65164e-06,6.59358e-06,1.13033e-05,1.5071e-05,2.07227e-05,2.73163e-05,3.57937e-05,4.33292e-05,4.99228e-05,
5.93422e-05,6.68777e-05,7.62971e-05,8.85423e-05,0.000101729,0.000111149,0.000118684,0.00012151,0.000123394,
0.000123394,0.00012151,0.000118684,0.000110207,9.60779e-05,7.91229e-05,6.59358e-05,5.08647e-05,3.95615e-05,
2.54324e-05,1.5071e-05,8.47746e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,2.82582e-06,
2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,
1.13033e-05,1.13033e-05,1.41291e-05,1.78969e-05,1.97807e-05,2.07227e-05,2.07227e-05,2.16646e-05,2.16646e-05,
2.16646e-05,2.07227e-05,2.07227e-05,2.07227e-05,1.97807e-05,1.78969e-05,1.5071e-05,1.13033e-05,1.13033e-05,
5.65164e-06,5.65164e-06,4.7097e-06,2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,4.7097e-06,
4.7097e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.31872e-05,1.88388e-05,2.16646e-05,2.73163e-05,3.76776e-05,
4.33292e-05,4.99228e-05,5.84003e-05,6.40519e-05,7.15874e-05,7.8181e-05,8.76004e-05,9.60779e-05,0.000103613,
0.000106439,0.000109265,0.000108323,0.000105497,9.60779e-05,8.47746e-05,7.62971e-05,6.311e-05,5.08647e-05,
4.05034e-05,2.54324e-05,1.69549e-05,8.47746e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,3.76776e-06,
2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,
6.59358e-06,1.03613e-05,1.13033e-05,1.31872e-05,1.5071e-05,1.78969e-05,1.97807e-05,2.07227e-05,2.07227e-05,
2.07227e-05,2.07227e-05,2.07227e-05,1.97807e-05,1.78969e-05,1.5071e-05,1.31872e-05,1.13033e-05,7.53552e-06,
5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,
4.7097e-06,4.7097e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.41291e-05,1.88388e-05,2.16646e-05,2.63743e-05,
2.82582e-05,4.05034e-05,4.33292e-05,4.99228e-05,5.55744e-05,6.12261e-05,6.59358e-05,7.15874e-05,7.62971e-05,
8.00649e-05,8.38326e-05,8.76004e-05,8.85423e-05,8.47746e-05,8.00649e-05,7.62971e-05,6.78197e-05,5.93422e-05,
4.89809e-05,4.05034e-05,2.54324e-05,1.78969e-05,9.4194e-06,5.65164e-06,4.7097e-06,4.7097e-06,3.76776e-06,
2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,5.65164e-06,
5.65164e-06,6.59358e-06,9.4194e-06,1.13033e-05,1.22452e-05,1.41291e-05,1.69549e-05,1.78969e-05,1.88388e-05,
1.97807e-05,1.97807e-05,1.97807e-05,1.88388e-05,1.78969e-05,1.5071e-05,1.31872e-05,1.13033e-05,8.47746e-06,
5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,
4.7097e-06,4.7097e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.5071e-05,2.07227e-05,2.16646e-05,2.63743e-05,
2.73163e-05,3.57937e-05,4.14454e-05,4.42712e-05,4.99228e-05,5.46325e-05,5.84003e-05,6.2168e-05,6.49938e-05,
6.78197e-05,7.06455e-05,7.44132e-05,7.53552e-05,7.34713e-05,6.87616e-05,6.59358e-05,6.02841e-05,5.27486e-05,
4.33292e-05,3.2026e-05,2.54324e-05,1.78969e-05,9.4194e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,
2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,
5.65164e-06,6.59358e-06,8.47746e-06,1.13033e-05,1.13033e-05,1.31872e-05,1.41291e-05,1.5071e-05,1.78969e-05,
1.78969e-05,1.78969e-05,1.78969e-05,1.5071e-05,1.41291e-05,1.22452e-05,1.13033e-05,9.4194e-06,6.59358e-06,
5.65164e-06,5.65164e-06,4.7097e-06,3.76776e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,
2.82582e-06,4.7097e-06,5.65164e-06,5.65164e-06,9.4194e-06,1.31872e-05,1.88388e-05,2.16646e-05,2.63743e-05,
2.73163e-05,3.01421e-05,3.95615e-05,4.14454e-05,4.33292e-05,4.7097e-05,4.99228e-05,5.08647e-05,5.55744e-05,
5.84003e-05,5.93422e-05,6.02841e-05,6.2168e-05,6.2168e-05,6.12261e-05,5.93422e-05,5.74583e-05,5.08647e-05,
4.52131e-05,4.05034e-05,2.73163e-05,2.16646e-05,1.5071e-05,8.47746e-06,5.65164e-06,4.7097e-06,3.76776e-06,
2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,
5.65164e-06,5.65164e-06,6.59358e-06,8.47746e-06,1.13033e-05,1.13033e-05,1.13033e-05,1.31872e-05,1.31872e-05,
1.41291e-05,1.41291e-05,1.41291e-05,1.41291e-05,1.31872e-05,1.13033e-05,1.13033e-05,9.4194e-06,6.59358e-06,
5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,
3.76776e-06,4.7097e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.5071e-05,2.07227e-05,2.54324e-05,2.73163e-05,
3.2026e-05,4.05034e-05,4.23873e-05,4.33292e-05,4.42712e-05,4.80389e-05,4.80389e-05,4.99228e-05,5.08647e-05,
5.08647e-05,5.18067e-05,5.27486e-05,5.27486e-05,5.18067e-05,5.08647e-05,4.99228e-05,4.80389e-05,4.33292e-05,
4.05034e-05,2.92001e-05,2.63743e-05,2.07227e-05,1.31872e-05,6.59358e-06,5.65164e-06,4.7097e-06,2.82582e-06,
2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,
5.65164e-06,5.65164e-06,6.59358e-06,6.59358e-06,8.47746e-06,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,8.47746e-06,6.59358e-06,
5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,
3.76776e-06,4.7097e-06,4.7097e-06,5.65164e-06,7.53552e-06,1.31872e-05,1.97807e-05,2.35485e-05,2.73163e-05,
3.2026e-05,4.05034e-05,4.33292e-05,4.80389e-05,4.99228e-05,5.08647e-05,5.08647e-05,5.08647e-05,5.08647e-05,
5.08647e-05,4.99228e-05,4.99228e-05,4.99228e-05,4.80389e-05,4.80389e-05,4.42712e-05,4.23873e-05,4.14454e-05,
3.67357e-05,2.82582e-05,2.63743e-05,2.16646e-05,1.78969e-05,1.13033e-05,6.59358e-06,5.65164e-06,4.7097e-06,
2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,
6.59358e-06,6.59358e-06,7.53552e-06,8.47746e-06,8.47746e-06,8.47746e-06,9.4194e-06,1.13033e-05,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,8.47746e-06,6.59358e-06,
6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,1.88388e-06,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,
2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.78969e-05,2.16646e-05,
2.73163e-05,3.1084e-05,4.14454e-05,4.42712e-05,4.99228e-05,5.27486e-05,5.84003e-05,5.93422e-05,5.93422e-05,
5.93422e-05,5.84003e-05,5.84003e-05,5.55744e-05,5.08647e-05,4.99228e-05,4.7097e-05,4.33292e-05,4.23873e-05,
4.05034e-05,3.57937e-05,2.82582e-05,2.73163e-05,2.35485e-05,2.07227e-05,1.5071e-05,1.13033e-05,6.59358e-06,
5.65164e-06,4.7097e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,
5.65164e-06,7.53552e-06,1.13033e-05,1.13033e-05,1.22452e-05,1.31872e-05,1.31872e-05,1.22452e-05,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,9.4194e-06,9.4194e-06,8.47746e-06,
6.59358e-06,6.59358e-06,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,
2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,9.4194e-07,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,
1.13033e-05,1.5071e-05,2.07227e-05,2.63743e-05,3.1084e-05,4.23873e-05,4.80389e-05,5.08647e-05,5.84003e-05,
6.12261e-05,6.311e-05,6.49938e-05,6.59358e-05,6.59358e-05,6.59358e-05,6.311e-05,6.12261e-05,5.84003e-05,
5.27486e-05,4.99228e-05,4.42712e-05,4.14454e-05,3.76776e-05,2.92001e-05,2.73163e-05,2.54324e-05,2.07227e-05,
1.88388e-05,1.31872e-05,1.13033e-05,5.65164e-06,5.65164e-06,4.7097e-06,2.82582e-06,2.82582e-06,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,
2.82582e-06,3.76776e-06,4.7097e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.31872e-05,1.69549e-05,1.88388e-05,
2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,1.97807e-05,1.78969e-05,1.5071e-05,1.31872e-05,1.13033e-05,
1.13033e-05,1.13033e-05,9.4194e-06,8.47746e-06,6.59358e-06,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,
5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,
4.7097e-06,5.65164e-06,5.65164e-06,8.47746e-06,1.31872e-05,1.97807e-05,2.54324e-05,3.1084e-05,4.23873e-05,
4.99228e-05,5.84003e-05,6.2168e-05,6.59358e-05,6.87616e-05,7.34713e-05,7.53552e-05,7.62971e-05,7.62971e-05,
7.53552e-05,7.44132e-05,6.87616e-05,6.59358e-05,6.2168e-05,5.55744e-05,4.99228e-05,4.33292e-05,4.05034e-05,
3.01421e-05,2.73163e-05,2.35485e-05,2.07227e-05,1.78969e-05,1.13033e-05,9.4194e-06,5.65164e-06,5.65164e-06,
4.7097e-06,2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,4.7097e-06,5.65164e-06,5.65164e-06,1.13033e-05,
1.41291e-05,1.97807e-05,2.16646e-05,2.54324e-05,2.73163e-05,2.73163e-05,2.73163e-05,2.73163e-05,2.63743e-05,
2.54324e-05,2.16646e-05,2.07227e-05,1.88388e-05,1.5071e-05,1.13033e-05,1.13033e-05,1.13033e-05,7.53552e-06,
6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,
2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,4.7097e-06,5.65164e-06,5.65164e-06,1.13033e-05,
1.5071e-05,2.16646e-05,2.73163e-05,4.23873e-05,5.08647e-05,6.2168e-05,6.87616e-05,7.62971e-05,8.00649e-05,
8.28907e-05,8.47746e-05,8.76004e-05,8.66585e-05,8.47746e-05,8.28907e-05,8.00649e-05,7.8181e-05,7.62971e-05,
6.97035e-05,6.40519e-05,5.93422e-05,5.08647e-05,4.33292e-05,3.95615e-05,2.73163e-05,2.54324e-05,2.07227e-05,
1.69549e-05,1.13033e-05,8.47746e-06,5.65164e-06,5.65164e-06,4.7097e-06,3.76776e-06,2.82582e-06,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,
2.82582e-06,2.82582e-06,4.7097e-06,5.65164e-06,6.59358e-06,1.22452e-05,1.97807e-05,2.54324e-05,2.73163e-05,
3.39098e-05,4.05034e-05,4.23873e-05,4.23873e-05,4.23873e-05,4.14454e-05,4.05034e-05,3.29679e-05,2.82582e-05,
2.63743e-05,2.16646e-05,2.07227e-05,1.5071e-05,1.31872e-05,1.13033e-05,8.47746e-06,6.59358e-06,5.65164e-06,
5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,1.88388e-06,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1.88388e-06,2.82582e-06,4.7097e-06,5.65164e-06,5.65164e-06,1.13033e-05,1.78969e-05,2.54324e-05,3.2026e-05,
4.80389e-05,6.12261e-05,7.53552e-05,8.85423e-05,0.000105497,0.000111149,0.000115859,0.000116801,0.000113033,
0.000110207,0.000105497,0.000101729,9.60779e-05,9.3252e-05,8.76004e-05,8.00649e-05,7.62971e-05,6.78197e-05,
6.2168e-05,5.27486e-05,4.33292e-05,3.67357e-05,2.73163e-05,2.16646e-05,1.78969e-05,1.22452e-05,9.4194e-06,
5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,
4.7097e-06,5.65164e-06,9.4194e-06,1.5071e-05,2.16646e-05,2.73163e-05,4.05034e-05,4.33292e-05,4.99228e-05,
5.55744e-05,5.84003e-05,5.93422e-05,5.84003e-05,5.55744e-05,5.08647e-05,4.80389e-05,4.23873e-05,3.76776e-05,
2.73163e-05,2.54324e-05,2.07227e-05,1.69549e-05,1.22452e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,
5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,4.7097e-06,
4.7097e-06,5.65164e-06,9.4194e-06,1.5071e-05,2.54324e-05,3.67357e-05,4.99228e-05,6.68777e-05,8.85423e-05,
0.000115859,0.000127162,0.000143175,0.000149768,0.000151652,0.000149768,0.000141291,0.000129988,0.000123394,
0.000117742,0.000109265,0.000103613,9.60779e-05,8.85423e-05,7.91229e-05,7.34713e-05,6.311e-05,5.55744e-05,
4.42712e-05,3.67357e-05,2.63743e-05,2.07227e-05,1.5071e-05,1.13033e-05,6.59358e-06,5.65164e-06,4.7097e-06,
4.7097e-06,2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,
1.13033e-05,1.88388e-05,2.54324e-05,3.67357e-05,4.7097e-05,5.55744e-05,6.311e-05,6.87616e-05,7.53552e-05,
7.62971e-05,7.62971e-05,7.62971e-05,7.53552e-05,6.68777e-05,6.2168e-05,5.55744e-05,4.80389e-05,4.14454e-05,
3.01421e-05,2.54324e-05,2.07227e-05,1.5071e-05,1.13033e-05,8.47746e-06,5.65164e-06,5.65164e-06,5.65164e-06,
4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,4.7097e-06,
5.65164e-06,6.59358e-06,1.31872e-05,2.16646e-05,3.1084e-05,4.99228e-05,7.34713e-05,0.000105497,0.000129988,
0.000153536,0.000175201,0.000192156,0.000195923,0.000195923,0.000192156,0.000178969,0.000162014,0.000148826,
0.000129988,0.000120568,0.000111149,0.000105497,9.3252e-05,8.28907e-05,7.62971e-05,6.59358e-05,5.84003e-05,
4.7097e-05,3.76776e-05,2.63743e-05,2.07227e-05,1.31872e-05,9.4194e-06,5.65164e-06,5.65164e-06,4.7097e-06,
4.7097e-06,2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,
1.13033e-05,2.07227e-05,2.73163e-05,4.33292e-05,5.84003e-05,6.87616e-05,7.91229e-05,9.23101e-05,0.000100788,
0.000105497,0.000106439,0.000106439,0.000105497,9.98456e-05,8.85423e-05,7.91229e-05,7.15874e-05,6.2168e-05,
5.27486e-05,4.33292e-05,3.2026e-05,2.54324e-05,2.07227e-05,1.5071e-05,1.13033e-05,6.59358e-06,5.65164e-06,
5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,4.7097e-06,
5.65164e-06,6.59358e-06,1.13033e-05,2.07227e-05,2.73163e-05,4.80389e-05,7.53552e-05,0.000115859,0.000149768,
0.000182736,0.000214762,0.000237369,0.000255266,0.000262801,0.000258091,0.00024773,0.000232659,0.000201575,
0.000177085,0.000153536,0.000133755,0.000120568,0.000111149,0.000101729,8.85423e-05,7.62971e-05,6.68777e-05,
5.84003e-05,4.7097e-05,3.67357e-05,2.63743e-05,1.97807e-05,1.13033e-05,7.53552e-06,5.65164e-06,5.65164e-06,
4.7097e-06,3.76776e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,
5.65164e-06,5.65164e-06,1.13033e-05,2.16646e-05,3.29679e-05,5.08647e-05,6.87616e-05,8.85423e-05,0.000109265,
0.000120568,0.00012622,0.000133755,0.000134697,0.000134697,0.000133755,0.000129988,0.000123394,0.000118684,
0.000106439,9.3252e-05,7.62971e-05,6.59358e-05,5.84003e-05,4.42712e-05,3.2026e-05,2.54324e-05,1.97807e-05,
1.31872e-05,1.13033e-05,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,1.88388e-06,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,
2.82582e-06,4.7097e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.78969e-05,2.63743e-05,4.42712e-05,7.53552e-05,
0.000118684,0.000161072,0.000208169,0.000258091,0.00030613,0.000335331,0.000350402,0.000350402,0.000339098,
0.000318376,0.00028635,0.000249614,0.000217588,0.000182736,0.000152594,0.000129988,0.000118684,0.000105497,
9.3252e-05,7.91229e-05,6.87616e-05,5.84003e-05,4.7097e-05,3.67357e-05,2.54324e-05,1.88388e-05,1.13033e-05,
6.59358e-06,5.65164e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,
3.76776e-06,4.7097e-06,4.7097e-06,5.65164e-06,6.59358e-06,1.41291e-05,2.54324e-05,4.14454e-05,6.12261e-05,
8.28907e-05,0.000114917,0.00013093,0.000149768,0.000161072,0.000171433,0.000175201,0.000177085,0.000175201,
0.000173317,0.000162956,0.000153536,0.000147885,0.000129988,0.000118684,0.000102671,8.00649e-05,6.87616e-05,
5.84003e-05,4.33292e-05,3.01421e-05,2.54324e-05,1.88388e-05,1.13033e-05,7.53552e-06,5.65164e-06,5.65164e-06,
4.7097e-06,3.76776e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,5.65164e-06,
7.53552e-06,1.13033e-05,1.88388e-05,2.54324e-05,4.23873e-05,7.06455e-05,0.00012151,0.000174259,0.000237369,
0.000317434,0.000389021,0.000486041,0.000547267,0.000556686,0.00052937,0.00047097,0.00040786,0.000355111,
0.000308014,0.000258091,0.000214762,0.000174259,0.000148826,0.000123394,0.000111149,9.70198e-05,8.00649e-05,
6.87616e-05,5.93422e-05,4.7097e-05,3.39098e-05,2.54324e-05,1.78969e-05,1.13033e-05,5.65164e-06,5.65164e-06,
4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,5.65164e-06,
5.65164e-06,1.13033e-05,1.88388e-05,2.73163e-05,4.7097e-05,7.15874e-05,0.000106439,0.000133755,0.000159188,
0.00018462,0.000200633,0.000219472,0.000232659,0.000234543,0.000234543,0.000232659,0.000219472,0.000204401,
0.000192156,0.000175201,0.000159188,0.000141291,0.00012151,0.000105497,8.19488e-05,6.78197e-05,5.55744e-05,
4.23873e-05,2.82582e-05,2.16646e-05,1.5071e-05,1.13033e-05,6.59358e-06,5.65164e-06,4.7097e-06,4.7097e-06,
2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,1.88388e-06,
1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,
1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,
3.76776e-06,4.7097e-06,4.7097e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.41291e-05,2.07227e-05,2.63743e-05,
4.05034e-05,6.59358e-05,0.000123394,0.000191214,0.000275046,0.000382428,0.000559512,0.000717758,0.000836443,
0.000891075,0.000879772,0.000802533,0.000680081,0.000580235,0.000463434,0.00036924,0.000308956,0.00024773,
0.000196865,0.000162014,0.000133755,0.000118684,0.000102671,8.28907e-05,6.97035e-05,5.93422e-05,4.7097e-05,
3.2026e-05,2.54324e-05,1.69549e-05,1.13033e-05,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,
2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,1.88388e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.69549e-05,
2.35485e-05,3.67357e-05,5.55744e-05,8.19488e-05,0.000122452,0.000153536,0.000190272,0.000226066,0.00025715,
0.00028635,0.000307072,0.000317434,0.000318376,0.00031084,0.000301421,0.000275988,0.000256208,0.000234543,
0.000210995,0.000190272,0.000167665,0.000146001,0.00012151,0.000103613,7.91229e-05,6.49938e-05,5.08647e-05,
4.05034e-05,2.73163e-05,2.07227e-05,1.31872e-05,9.4194e-06,5.65164e-06,5.65164e-06,4.7097e-06,2.82582e-06,
2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,1.88388e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
3.76776e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,1.03613e-05,1.31872e-05,1.78969e-05,2.07227e-05,
2.63743e-05,3.67357e-05,4.7097e-05,6.87616e-05,0.000132814,0.000219472,0.000338156,0.000555744,0.000817604,
0.00100693,0.00123582,0.00136016,0.00136675,0.00129611,0.00112562,0.000944766,0.000790287,0.000617912,
0.000467202,0.000359821,0.000288234,0.000232659,0.00017991,0.000148826,0.000123394,0.000106439,8.66585e-05,
7.15874e-05,5.93422e-05,4.42712e-05,3.1084e-05,2.44904e-05,1.5071e-05,1.13033e-05,5.65164e-06,5.65164e-06,
4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,5.65164e-06,
5.65164e-06,1.13033e-05,1.78969e-05,2.54324e-05,3.1084e-05,4.80389e-05,6.68777e-05,0.000102671,0.000137523,
0.000175201,0.000219472,0.000271279,0.000322143,0.000372066,0.000417279,0.000459667,0.00047097,0.000459667,
0.000420105,0.000387137,0.000354169,0.00032026,0.000283524,0.000248672,0.000222298,0.000192156,0.000165781,
0.000139407,0.000118684,9.60779e-05,7.62971e-05,6.02841e-05,4.7097e-05,3.1084e-05,2.54324e-05,1.78969e-05,
1.13033e-05,6.59358e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
3.76776e-06,3.76776e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,
6.59358e-06,1.13033e-05,1.5071e-05,2.07227e-05,2.73163e-05,3.1084e-05,4.23873e-05,5.08647e-05,6.78197e-05,
9.60779e-05,0.000151652,0.00024773,0.00041257,0.000779926,0.00113504,0.00157398,0.00206285,0.00235673,
0.00247071,0.00232942,0.00205343,0.00165593,0.0013319,0.000992805,0.000792171,0.00058777,0.000417279,
0.000325911,0.000251498,0.000195923,0.000159188,0.000129988,0.000113033,9.23101e-05,7.53552e-05,5.93422e-05,
4.52131e-05,3.1084e-05,2.54324e-05,1.78969e-05,1.13033e-05,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,
3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,
5.65164e-06,8.47746e-06,1.5071e-05,2.54324e-05,3.1084e-05,4.42712e-05,6.02841e-05,8.00649e-05,0.000118684,
0.000152594,0.000194982,0.000244904,0.000316492,0.000393731,0.00052466,0.000619796,0.000701745,0.000746016,
0.00075261,0.000716816,0.000645229,0.000574583,0.000486041,0.000393731,0.00034475,0.000303305,0.00025715,
0.000222298,0.00018933,0.000159188,0.000132814,0.000112091,8.76004e-05,6.78197e-05,5.36906e-05,4.14454e-05,
2.73163e-05,2.07227e-05,1.41291e-05,1.13033e-05,5.65164e-06,5.65164e-06,4.7097e-06,2.82582e-06,1.88388e-06,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,3.76776e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,
7.53552e-06,1.13033e-05,1.69549e-05,2.16646e-05,2.73163e-05,4.23873e-05,5.55744e-05,6.87616e-05,8.85423e-05,
0.000123394,0.000158246,0.000214762,0.000325911,0.000585887,0.000963604,0.00154949,0.00246977,0.00355488,
0.00428112,0.00453638,0.00445632,0.00409461,0.00341171,0.00257715,0.00183584,0.00134226,0.000957011,0.000712106,
0.000511473,0.000361705,0.00027693,0.000217588,0.000174259,0.000142233,0.000118684,9.60779e-05,7.62971e-05,
6.12261e-05,4.7097e-05,3.2026e-05,2.54324e-05,1.78969e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,
4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,9.4194e-07,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,1.13033e-05,2.07227e-05,2.82582e-05,4.42712e-05,
5.84003e-05,7.53552e-05,0.000101729,0.000129988,0.000169549,0.000214762,0.000272221,0.000355111,0.000512415,
0.000702687,0.000891075,0.000986211,0.00107758,0.00112091,0.00110395,0.00102766,0.000936288,0.000834559,
0.000682906,0.000556686,0.000426699,0.000354169,0.000303305,0.000250556,0.00021382,0.000177085,0.000151652,
0.000123394,0.000105497,7.62971e-05,6.2168e-05,4.7097e-05,3.1084e-05,2.54324e-05,1.78969e-05,1.13033e-05,
6.59358e-06,5.65164e-06,4.7097e-06,2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,
1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,7.53552e-06,1.13033e-05,1.41291e-05,1.97807e-05,2.54324e-05,
3.76776e-05,5.27486e-05,7.53552e-05,0.000105497,0.00013093,0.000173317,0.000232659,0.000335331,0.000573641,
0.000920275,0.0014261,0.00232848,0.00377058,0.00501677,0.00647584,0.00742154,0.0077013,0.007333,0.00635621,
0.00502713,0.00396274,0.00269018,0.00175389,0.00121604,0.00087883,0.000606609,0.000405034,0.000305188,
0.000233601,0.00018462,0.000151652,0.000123394,0.000105497,7.91229e-05,6.311e-05,4.80389e-05,3.86195e-05,
2.63743e-05,2.07227e-05,1.31872e-05,9.4194e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,3.76776e-06,
2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1.88388e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,6.59358e-06,
1.13033e-05,1.13033e-05,1.78969e-05,2.63743e-05,4.14454e-05,5.84003e-05,7.53552e-05,9.3252e-05,0.000120568,
0.000151652,0.000192156,0.000240195,0.00031555,0.000421989,0.000645229,0.000920275,0.00120474,0.00147414,
0.00168419,0.00181418,0.00183113,0.001736,0.0015655,0.00136016,0.00112468,0.00093252,0.000764855,0.000586828,
0.000433292,0.000350402,0.000290117,0.000237369,0.000195923,0.000168607,0.000138465,0.000118684,9.13682e-05,
6.87616e-05,5.27486e-05,4.05034e-05,2.73163e-05,2.07227e-05,1.41291e-05,8.47746e-06,5.65164e-06,4.7097e-06,
3.76776e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,6.59358e-06,8.47746e-06,1.13033e-05,
1.13033e-05,1.31872e-05,1.78969e-05,2.07227e-05,2.54324e-05,4.05034e-05,5.93422e-05,9.3252e-05,0.000137523,
0.000181794,0.000243962,0.000353227,0.000606609,0.00101541,0.00164086,0.00267888,0.004137,0.00553201,
0.00754682,0.00942222,0.0111884,0.0122725,0.0122669,0.011162,0.00934781,0.00740741,0.00528428,0.00378471,
0.00232282,0.00149768,0.000992805,0.000693268,0.000460609,0.000326853,0.00024773,0.00019404,0.000158246,
0.000129988,0.000111149,8.38326e-05,6.59358e-05,5.08647e-05,4.14454e-05,2.73163e-05,2.16646e-05,1.78969e-05,
1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,2.82582e-06,
5.65164e-06,6.59358e-06,1.13033e-05,1.13033e-05,1.31872e-05,1.5071e-05,1.88388e-05,2.07227e-05,2.16646e-05,
2.73163e-05,4.14454e-05,5.55744e-05,7.53552e-05,0.000101729,0.000122452,0.000148826,0.000178969,0.000230775,
0.000293885,0.000385253,0.000581177,0.000859049,0.00118779,0.00162579,0.00218247,0.00270431,0.0031263,
0.00329302,0.00322426,0.00290683,0.00247542,0.00203553,0.00157021,0.00124619,0.000965488,0.0007771,0.000571757,
0.000416337,0.000330621,0.000270337,0.000219472,0.00018462,0.000153536,0.000128104,0.000106439,7.8181e-05,
6.02841e-05,4.33292e-05,2.82582e-05,2.16646e-05,1.69549e-05,1.13033e-05,5.65164e-06,5.65164e-06,4.7097e-06,
2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,7.53552e-06,1.13033e-05,1.13033e-05,1.31872e-05,1.5071e-05,
1.78969e-05,1.88388e-05,2.07227e-05,2.16646e-05,2.63743e-05,3.86195e-05,5.84003e-05,0.000105497,0.000171433,
0.000251498,0.000389963,0.000704571,0.00105497,0.00180099,0.00334954,0.00502336,0.00729909,0.00935629,
0.0117837,0.0151756,0.0184432,0.0204684,0.0209271,0.0198071,0.0172121,0.0133501,0.00985646,0.00715309,
0.00473042,0.00303776,0.00179251,0.00118684,0.000808184,0.000530312,0.000353227,0.000264685,0.000206285,
0.000168607,0.000136581,0.000117742,9.23101e-05,7.15874e-05,5.84003e-05,4.42712e-05,3.39098e-05,2.63743e-05,
2.07227e-05,1.41291e-05,1.13033e-05,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,
2.82582e-06,3.76776e-06,4.7097e-06,5.65164e-06,1.31872e-05,1.78969e-05,2.07227e-05,2.35485e-05,2.63743e-05,
2.82582e-05,3.67357e-05,4.23873e-05,4.80389e-05,6.12261e-05,7.62971e-05,0.000105497,0.00012622,0.000153536,
0.00018462,0.000224182,0.00028164,0.000371124,0.000555744,0.000805359,0.00108606,0.00157021,0.00227761,
0.00322143,0.00404092,0.00457218,0.00493011,0.00503373,0.00484911,0.00443371,0.00386572,0.0030792,0.00226442,
0.00164745,0.00126126,0.000947591,0.000735655,0.000537848,0.000381486,0.000305188,0.000242079,0.000197807,
0.000170491,0.000146001,0.000119626,9.3252e-05,6.68777e-05,4.99228e-05,3.95615e-05,2.63743e-05,1.97807e-05,
1.13033e-05,6.59358e-06,5.65164e-06,4.7097e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,
1.13033e-05,1.31872e-05,1.78969e-05,2.07227e-05,2.07227e-05,2.16646e-05,2.35485e-05,2.54324e-05,2.73163e-05,
3.95615e-05,4.99228e-05,6.87616e-05,0.000115859,0.00018933,0.000324027,0.000638635,0.0011341,0.00188859,
0.00318658,0.00479824,0.00756378,0.0113815,0.0168202,0.0214404,0.0256085,0.0294356,0.0322567,0.0335679,
0.0321173,0.0287018,0.0237303,0.0184997,0.0128292,0.008712,0.00568084,0.0037282,0.00215893,0.00135734,
0.000907088,0.000604725,0.000384311,0.000289176,0.000224182,0.000177085,0.000148826,0.00012151,0.000101729,
7.62971e-05,6.311e-05,5.08647e-05,4.23873e-05,2.82582e-05,2.54324e-05,1.88388e-05,1.13033e-05,7.53552e-06,
5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,
1.88388e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,4.7097e-06,
5.65164e-06,5.65164e-06,9.4194e-06,2.54324e-05,2.73163e-05,3.95615e-05,4.23873e-05,4.99228e-05,5.84003e-05,
6.59358e-05,7.62971e-05,9.3252e-05,0.000118684,0.000135639,0.000162014,0.000192156,0.000233601,0.000284466,
0.000368298,0.000551977,0.0008063,0.00105874,0.00148732,0.00216458,0.00322991,0.00432539,0.00526639,0.00640331,
0.00725105,0.00767587,0.00766927,0.00722656,0.00635621,0.0052174,0.00434705,0.00335331,0.00231811,0.00162108,
0.00121604,0.000919333,0.000676313,0.000486983,0.000353227,0.000275046,0.000225124,0.00018462,0.00015542,
0.000129988,0.000105497,7.62971e-05,5.84003e-05,4.23873e-05,2.73163e-05,2.07227e-05,1.5071e-05,9.4194e-06,
5.65164e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,1.88388e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,
5.65164e-06,7.53552e-06,1.13033e-05,1.69549e-05,2.07227e-05,2.54324e-05,2.63743e-05,2.73163e-05,2.73163e-05,
2.82582e-05,4.05034e-05,5.74583e-05,8.00649e-05,0.000123394,0.000174259,0.00024773,0.000417279,0.000891075,
0.00155891,0.00293979,0.00465695,0.00686486,0.00988001,0.0160808,0.0244113,0.0341114,0.0428498,0.048978,
0.0524726,0.0537979,0.0522315,0.0464103,0.0383417,0.0305433,0.0228486,0.0161618,0.0102898,0.00684413,
0.00428583,0.00249426,0.00151841,0.000991863,0.000673487,0.000433292,0.00032026,0.00024773,0.000195923,
0.000161072,0.000133755,0.000112091,8.57165e-05,6.87616e-05,5.93422e-05,4.80389e-05,4.05034e-05,2.73163e-05,
2.16646e-05,1.69549e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,8.47746e-06,
1.31872e-05,1.97807e-05,4.33292e-05,5.18067e-05,6.2168e-05,6.97035e-05,8.00649e-05,0.000101729,0.000117742,
0.000129988,0.000152594,0.000178969,0.000210995,0.00024773,0.000303305,0.000368298,0.000528428,0.000760145,
0.00103142,0.00146095,0.00206756,0.00296146,0.0041257,0.00525602,0.00686203,0.00818922,0.00952866,0.0105865,
0.0111234,0.0108389,0.00992616,0.00863382,0.00725105,0.00565823,0.00451754,0.00338156,0.00226819,0.00157492,
0.00115576,0.000886365,0.000630158,0.00044177,0.000326853,0.00025715,0.000206285,0.000174259,0.000146001,
0.000118684,8.57165e-05,6.40519e-05,4.80389e-05,3.67357e-05,2.54324e-05,1.97807e-05,1.13033e-05,6.59358e-06,
5.65164e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,9.4194e-06,1.13033e-05,1.78969e-05,2.16646e-05,2.63743e-05,
2.82582e-05,3.29679e-05,4.05034e-05,4.33292e-05,6.02841e-05,9.3252e-05,0.000137523,0.000192156,0.000272221,
0.000408802,0.000745074,0.00131777,0.00242455,0.00420388,0.00635056,0.00932144,0.0138211,0.0217098,0.0335293,
0.0494716,0.0688596,0.0858277,0.0943673,0.0946386,0.0897622,0.0797785,0.0649581,0.0495781,0.0367234,0.0269395,
0.0188294,0.0119071,0.00773333,0.0047681,0.00292284,0.00170585,0.0011341,0.000800649,0.000528428,0.000360763,
0.00028164,0.000224182,0.00018462,0.000152594,0.000125278,0.000105497,7.8181e-05,6.49938e-05,5.55744e-05,
4.42712e-05,3.67357e-05,2.63743e-05,2.07227e-05,1.5071e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,
5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
1.88388e-06,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,
4.7097e-06,4.7097e-06,5.65164e-06,7.53552e-06,1.31872e-05,2.07227e-05,2.63743e-05,3.57937e-05,7.15874e-05,
8.19488e-05,0.000102671,0.000118684,0.000132814,0.000151652,0.000172375,0.000195923,0.000233601,0.000275046,
0.000327795,0.000395615,0.000537848,0.000716816,0.000944766,0.00131212,0.00182925,0.00266946,0.00373102,
0.00474267,0.00617347,0.0078294,0.00959271,0.0115887,0.0136534,0.0155034,0.016158,0.0155222,0.0136346,
0.0114351,0.00925738,0.00747147,0.00575148,0.00449023,0.00330338,0.00221262,0.00153065,0.00109453,0.000832675,
0.000606609,0.000405034,0.000309898,0.000237369,0.000192156,0.000157304,0.00012622,0.000101729,7.53552e-05,
5.74583e-05,4.23873e-05,2.92001e-05,2.54324e-05,2.07227e-05,1.41291e-05,1.13033e-05,6.59358e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,6.59358e-06,9.4194e-06,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,9.4194e-06,
6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,
8.47746e-06,1.13033e-05,1.5071e-05,2.07227e-05,2.54324e-05,2.73163e-05,3.1084e-05,4.05034e-05,4.33292e-05,
5.93422e-05,9.60779e-05,0.000148826,0.000215704,0.00031084,0.000505822,0.000829849,0.00131495,0.0023021,
0.00425851,0.00670567,0.00955504,0.0138333,0.0206982,0.030175,0.0449786,0.0697167,0.103336,0.133439,0.1545,
0.16028,0.152162,0.133656,0.111216,0.085287,0.0608371,0.0428046,0.0306243,0.0210957,0.0134057,0.00860179,
0.00539543,0.00346445,0.00202988,0.00133284,0.000924043,0.000630158,0.000428583,0.000326853,0.000258091,
0.00021382,0.000177085,0.000149768,0.000122452,9.79617e-05,7.62971e-05,6.311e-05,5.27486e-05,4.33292e-05,
3.39098e-05,2.63743e-05,2.07227e-05,1.5071e-05,1.13033e-05,8.47746e-06,6.59358e-06,5.65164e-06,5.65164e-06,
5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,
4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.5071e-05,2.07227e-05,2.73163e-05,4.05034e-05,
4.99228e-05,6.02841e-05,0.000115859,0.000127162,0.000148826,0.000167665,0.00018933,0.000214762,0.00024302,
0.000291059,0.000348518,0.00043706,0.000581177,0.000741307,0.000917449,0.0011567,0.00154196,0.00216175,
0.00309239,0.00414642,0.00512792,0.00668871,0.00824009,0.0101569,0.0125542,0.015558,0.0182755,0.0201274,
0.0207556,0.0199597,0.0178441,0.0146029,0.0114474,0.0090332,0.00726141,0.0055452,0.0043235,0.00312253,
0.0020864,0.00143457,0.00100599,0.000780868,0.000551977,0.000375834,0.000287292,0.000224182,0.000177085,
0.000144117,0.000115859,8.38326e-05,6.59358e-05,5.27486e-05,4.33292e-05,3.95615e-05,2.82582e-05,2.73163e-05,
2.54324e-05,2.16646e-05,2.07227e-05,1.78969e-05,1.78969e-05,1.78969e-05,1.88388e-05,2.07227e-05,2.16646e-05,
2.63743e-05,2.73163e-05,2.82582e-05,3.01421e-05,3.2026e-05,3.67357e-05,3.67357e-05,3.76776e-05,3.67357e-05,
3.2026e-05,2.82582e-05,2.73163e-05,2.16646e-05,1.88388e-05,1.13033e-05,8.47746e-06,5.65164e-06,5.65164e-06,
6.59358e-06,1.13033e-05,1.5071e-05,2.07227e-05,2.16646e-05,2.63743e-05,2.73163e-05,3.2026e-05,4.05034e-05,
4.33292e-05,5.36906e-05,7.62971e-05,0.000133755,0.000207227,0.000312724,0.000513357,0.000879772,0.0013611,
0.0023718,0.00420388,0.00644004,0.00965677,0.0150993,0.022096,0.0304614,0.0420284,0.0609303,0.0941676,
0.137373,0.182981,0.217464,0.229265,0.222464,0.201472,0.16975,0.133185,0.099579,0.0692684,0.047567,0.0334539,
0.0230917,0.0149495,0.00942882,0.00621774,0.00409461,0.00247259,0.00157869,0.001087,0.000802533,0.000562338,
0.000387137,0.00031084,0.000250556,0.000209111,0.000174259,0.000148826,0.000120568,9.51359e-05,7.62971e-05,
6.40519e-05,5.55744e-05,4.42712e-05,3.86195e-05,2.73163e-05,2.16646e-05,1.88388e-05,1.41291e-05,1.13033e-05,
8.47746e-06,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,3.76776e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,
5.65164e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.31872e-05,1.97807e-05,2.54324e-05,3.67357e-05,4.7097e-05,
5.93422e-05,6.87616e-05,8.00649e-05,9.98456e-05,0.000161072,0.000178969,0.000199691,0.000232659,0.000261859,
0.000305188,0.000356995,0.000452131,0.000607551,0.0007771,0.000925927,0.00111526,0.00138088,0.00176896,
0.00237746,0.00326947,0.0042538,0.00520233,0.00664162,0.0080809,0.00986305,0.0120945,0.0150965,0.0182765,
0.0211315,0.0232518,0.0239234,0.0229513,0.0205079,0.0171904,0.0133171,0.0103585,0.00829095,0.00672074,
0.00506952,0.00396086,0.00270431,0.00179534,0.00127633,0.000925927,0.000677255,0.000471912,0.00034004,
0.000258091,0.000200633,0.000161072,0.00012622,0.000105497,7.91229e-05,6.68777e-05,6.12261e-05,5.74583e-05,
5.18067e-05,4.99228e-05,4.80389e-05,4.52131e-05,4.33292e-05,4.33292e-05,4.33292e-05,4.42712e-05,4.80389e-05,
5.08647e-05,5.84003e-05,5.93422e-05,6.311e-05,6.87616e-05,7.53552e-05,7.62971e-05,7.91229e-05,8.00649e-05,
7.91229e-05,7.62971e-05,7.53552e-05,6.68777e-05,6.2168e-05,5.27486e-05,4.33292e-05,3.67357e-05,2.73163e-05,
2.54324e-05,2.16646e-05,2.54324e-05,2.73163e-05,3.39098e-05,4.23873e-05,4.42712e-05,4.99228e-05,5.55744e-05,
6.12261e-05,6.87616e-05,8.38326e-05,0.000118684,0.000174259,0.000271279,0.000444596,0.000808184,0.00127633,
0.00217871,0.00390811,0.00594176,0.00890981,0.0132955,0.0204749,0.0298341,0.0417053,0.0579171,0.0819648,
0.116652,0.165361,0.219893,0.267818,0.291059,0.283514,0.256522,0.220888,0.179846,0.138362,0.102403,0.0714047,
0.0493916,0.0347369,0.0242182,0.0161015,0.010091,0.00696659,0.00464376,0.00316115,0.00204495,0.00138277,
0.000969256,0.000733771,0.000521835,0.000376776,0.000307072,0.00024773,0.000206285,0.000173317,0.000143175,
0.000118684,9.60779e-05,7.8181e-05,6.78197e-05,5.93422e-05,4.80389e-05,4.14454e-05,2.82582e-05,2.54324e-05,
2.07227e-05,1.88388e-05,1.41291e-05,1.13033e-05,9.4194e-06,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,
5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,
6.59358e-06,7.53552e-06,1.13033e-05,1.31872e-05,1.78969e-05,2.16646e-05,2.82582e-05,4.33292e-05,5.93422e-05,
7.53552e-05,9.23101e-05,0.000111149,0.000122452,0.000134697,0.000149768,0.000230775,0.00024773,0.000282582,
0.000323085,0.00037395,0.00046155,0.000607551,0.0007771,0.000935346,0.00113598,0.00136675,0.00162108,
0.0020393,0.00257809,0.00332599,0.00414642,0.00494518,0.00610471,0.00747429,0.00889756,0.0106411,0.0129244,
0.0158981,0.018949,0.0217776,0.0238848,0.0246619,0.0237152,0.0213293,0.018106,0.014276,0.0111799,0.00902096,
0.00737256,0.00568178,0.00445349,0.00327041,0.00218436,0.00149392,0.00104838,0.00081101,0.000582119,0.000393731,
0.000303305,0.000232659,0.000181794,0.000148826,0.00012151,0.000105497,9.3252e-05,8.19488e-05,8.00649e-05,
7.8181e-05,7.8181e-05,7.8181e-05,7.8181e-05,7.91229e-05,8.00649e-05,8.38326e-05,8.85423e-05,9.51359e-05,
0.000102671,0.000106439,0.000113033,0.000120568,0.000125278,0.000134697,0.000147885,0.000149768,0.000151652,
0.000149768,0.000143175,0.00013093,0.000123394,0.000116801,0.000105497,8.76004e-05,7.53552e-05,6.40519e-05,
5.84003e-05,5.46325e-05,5.55744e-05,6.2168e-05,6.78197e-05,7.53552e-05,8.00649e-05,9.60779e-05,0.000111149,
0.000125278,0.000151652,0.00018462,0.000237369,0.000348518,0.000643345,0.00108606,0.00180381,0.00323651,
0.00510437,0.00805735,0.0121614,0.0187079,0.0267784,0.0372085,0.0515599,0.0727978,0.102604,0.137907,0.182582,
0.235379,0.287099,0.321347,0.323004,0.297352,0.256307,0.211437,0.166982,0.127245,0.0954232,0.0677886,
0.0475868,0.0339739,0.0240411,0.0164821,0.0106543,0.00747523,0.00518915,0.00383558,0.00261671,0.00176614,
0.00125466,0.000924043,0.000678197,0.000505822,0.000372066,0.000305188,0.00024302,0.000197807,0.000169549,
0.000141291,0.000120568,0.000105497,8.85423e-05,7.62971e-05,6.311e-05,5.55744e-05,4.7097e-05,4.05034e-05,
3.1084e-05,2.73163e-05,2.54324e-05,2.07227e-05,1.78969e-05,1.41291e-05,1.13033e-05,1.13033e-05,8.47746e-06,
6.59358e-06,6.59358e-06,6.59358e-06,6.59358e-06,7.53552e-06,1.13033e-05,1.13033e-05,1.41291e-05,1.78969e-05,
2.07227e-05,2.54324e-05,2.73163e-05,3.1084e-05,4.14454e-05,5.27486e-05,6.87616e-05,9.3252e-05,0.000118684,
0.000134697,0.000152594,0.000170491,0.00018462,0.00019404,0.000206285,0.00032026,0.000356995,0.000409744,
0.000508647,0.000617912,0.000763913,0.000919333,0.00109736,0.00136016,0.00160507,0.00192815,0.00225783,
0.00272126,0.00332976,0.00399853,0.00460703,0.00537377,0.00651917,0.00767022,0.00891075,0.0103453,0.0121962,
0.0145737,0.017375,0.0199305,0.0218568,0.0226131,0.0219472,0.0200087,0.0171584,0.0137467,0.0110979,0.00912457,
0.00756754,0.00599356,0.00468144,0.00356618,0.00242549,0.00162579,0.00116801,0.000893901,0.000645229,
0.000459667,0.000333447,0.00025715,0.000200633,0.000165781,0.000143175,0.00012622,0.00012151,0.000118684,
0.000119626,0.00012151,0.000123394,0.000123394,0.000127162,0.000131872,0.000137523,0.000147885,0.000152594,
0.000157304,0.000161072,0.000168607,0.000174259,0.00018462,0.000194982,0.000210995,0.000228891,0.000233601,
0.000234543,0.000232659,0.000220414,0.000205343,0.000190272,0.000174259,0.000159188,0.000147885,0.000129988,
0.000118684,0.000109265,0.000104555,0.000106439,0.000115859,0.000123394,0.000133755,0.000149768,0.000168607,
0.000192156,0.000232659,0.000279756,0.000350402,0.000508647,0.000856223,0.00146566,0.00269301,0.00440828,
0.00684413,0.0103453,0.0168287,0.0248917,0.0346973,0.0474399,0.0641687,0.0863759,0.115114,0.15184,0.192905,
0.23677,0.281997,0.314534,0.322574,0.305587,0.273129,0.231107,0.186027,0.142445,0.109177,0.0820411,0.0597086,
0.042959,0.0313704,0.0227055,0.0161637,0.0108559,0.00778513,0.00565917,0.00436683,0.00329208,0.0022729,
0.00157587,0.00115199,0.000893901,0.000652764,0.000494518,0.000366415,0.000302363,0.000237369,0.000195923,
0.000171433,0.000149768,0.000129988,0.000118684,0.000106439,8.85423e-05,7.62971e-05,6.59358e-05,6.02841e-05,
5.46325e-05,4.80389e-05,4.23873e-05,3.76776e-05,2.73163e-05,2.54324e-05,2.16646e-05,2.07227e-05,1.88388e-05,
1.88388e-05,1.88388e-05,1.97807e-05,2.07227e-05,2.16646e-05,2.54324e-05,2.73163e-05,3.1084e-05,4.14454e-05,
4.80389e-05,5.55744e-05,6.311e-05,7.15874e-05,8.85423e-05,0.000116801,0.000137523,0.000162956,0.000191214,
0.000217588,0.000237369,0.000254324,0.000271279,0.000277872,0.000296711,0.000498286,0.000570816,0.000652764,
0.00078652,0.000906146,0.00103331,0.00126314,0.00151652,0.00181041,0.00217965,0.00251215,0.00288139,0.00329962,
0.00378848,0.004283,0.00475303,0.00538507,0.00627426,0.00723221,0.00816097,0.00920652,0.0103698,0.0118732,
0.0137749,0.0161072,0.0178422,0.0186325,0.0182859,0.0168457,0.0144842,0.0120691,0.0101193,0.00858672,
0.00726612,0.00577786,0.0046221,0.00357184,0.00246035,0.0016597,0.00121228,0.000919333,0.000691384,0.00050488,
0.000356995,0.000279756,0.000226066,0.000186504,0.000162014,0.000152594,0.000149768,0.000151652,0.000153536,
0.000161072,0.000170491,0.000175201,0.00018933,0.000195923,0.000214762,0.000232659,0.000240195,0.000250556,
0.000259975,0.000270337,0.000275046,0.000291059,0.00031084,0.000331563,0.000350402,0.000363589,0.00036924,
0.000361705,0.000345692,0.00032026,0.000288234,0.000255266,0.000232659,0.000207227,0.000190272,0.000174259,
0.000159188,0.000153536,0.000159188,0.000171433,0.000187446,0.000207227,0.000237369,0.000275046,0.000328737,
0.000414454,0.000581177,0.000817604,0.00116235,0.00195547,0.00372631,0.00563657,0.00863288,0.0135479,
0.0213039,0.0311462,0.0429261,0.0582919,0.0783656,0.10158,0.125716,0.1567,0.191305,0.226478,0.258458,
0.285429,0.296692,0.283196,0.252763,0.21906,0.184081,0.146386,0.111548,0.0846267,0.0642893,0.0488754,
0.0365774,0.0274528,0.0204062,0.0148723,0.0104725,0.00784071,0.00602559,0.00476433,0.00385913,0.00283147,
0.00199503,0.0014374,0.00107004,0.000861875,0.000638635,0.00047568,0.000359821,0.000296711,0.000237369,
0.000205343,0.000181794,0.000162956,0.000151652,0.000137523,0.000123394,0.000117742,0.000104555,8.85423e-05,
7.8181e-05,7.34713e-05,6.40519e-05,5.84003e-05,4.99228e-05,4.33292e-05,4.05034e-05,3.67357e-05,3.1084e-05,
3.1084e-05,3.39098e-05,4.05034e-05,4.23873e-05,4.7097e-05,5.08647e-05,5.84003e-05,6.59358e-05,7.62971e-05,
8.85423e-05,0.000105497,0.000120568,0.000138465,0.000162014,0.000192156,0.000232659,0.000270337,0.000308956,
0.00034475,0.000371124,0.000392789,0.000409744,0.000417279,0.000444596,0.000793113,0.000859049,0.000925927,
0.00102295,0.00119815,0.00137806,0.00160507,0.00194887,0.00228326,0.00266757,0.00299348,0.00329208,0.00359162,
0.00394296,0.00428206,0.00462398,0.00500829,0.00551883,0.00618949,0.00694681,0.00757225,0.00818075,0.00898611,
0.00997703,0.0112844,0.0125156,0.0132955,0.0132889,0.0124769,0.0112157,0.00987153,0.00867056,0.007625,
0.00648243,0.0052353,0.00430466,0.00327512,0.0022437,0.00156456,0.00115859,0.000907088,0.000692326,0.000516183,
0.00036924,0.000301421,0.000237369,0.000204401,0.000187446,0.000178027,0.00017991,0.00018933,0.000195923,
0.000211936,0.000232659,0.00024773,0.000275046,0.00031084,0.00034475,0.000379602,0.000409744,0.000447421,
0.000484157,0.000512415,0.000536906,0.00056328,0.000607551,0.0006311,0.000661242,0.000681022,0.000685732,
0.000652764,0.000619796,0.000556686,0.000463434,0.000385253,0.000335331,0.000303305,0.000265627,0.000238311,
0.000231717,0.000224182,0.000232659,0.00024773,0.000279756,0.000321201,0.000379602,0.000492635,0.000649938,
0.000893901,0.00121228,0.0017699,0.00288328,0.0046513,0.00733112,0.0109246,0.017587,0.0261643,0.036763,
0.0505049,0.0675606,0.0880393,0.110683,0.132914,0.157727,0.184399,0.209772,0.227841,0.23891,0.246322,
0.2403,0.216372,0.183406,0.154902,0.127136,0.100807,0.0758638,0.0585058,0.0467683,0.0372396,0.0294045,
0.0224276,0.0172648,0.0127887,0.00966336,0.00758073,0.00609341,0.00499228,0.00417844,0.00326476,0.00234543,
0.00172092,0.0013319,0.00100222,0.000822313,0.00062168,0.00046155,0.000356995,0.000296711,0.00024773,
0.000225124,0.000204401,0.000191214,0.000177085,0.000168607,0.000153536,0.000144117,0.000129988,0.000120568,
0.000111149,9.79617e-05,8.28907e-05,7.62971e-05,6.78197e-05,6.311e-05,5.93422e-05,5.84003e-05,5.84003e-05,
6.02841e-05,6.40519e-05,6.97035e-05,7.62971e-05,8.76004e-05,0.000102671,0.000117742,0.000128104,0.000148826,
0.000165781,0.000191214,0.000225124,0.000264685,0.000319318,0.000372066,0.000450247,0.000544441,0.000613203,
0.000652764,0.000697035,0.000716816,0.000727178,0.000749784,0.00107287,0.00112468,0.00121981,0.00133944,
0.00148638,0.00167477,0.00196865,0.00226819,0.00263272,0.00296617,0.00324216,0.00343054,0.00360669,0.00378471,
0.00401455,0.00421424,0.00441016,0.00464753,0.00488019,0.00518538,0.00551129,0.00586734,0.00638918,0.0070589,
0.00774934,0.00846427,0.00904451,0.00918203,0.00889568,0.00832675,0.00771825,0.00707397,0.0061942,0.00527204,
0.00450153,0.00367262,0.00269018,0.00188294,0.001379,0.00104367,0.000861875,0.000648055,0.000494518,0.00036924,
0.000305188,0.000251498,0.000226066,0.000209111,0.000207227,0.000217588,0.000232659,0.00024773,0.000275046,
0.000316492,0.000357937,0.000420105,0.000537848,0.000629216,0.000730945,0.000816662,0.000892959,0.000926869,
0.000959837,0.00100128,0.00105026,0.00110961,0.00114728,0.00117083,0.00116518,0.00112373,0.00104555,0.00096643,
0.000897669,0.000790287,0.000644287,0.000542557,0.000436118,0.000376776,0.000340982,0.000324027,0.000322143,
0.000337214,0.000368298,0.000420105,0.000550093,0.000699861,0.000904262,0.00118402,0.00168136,0.00270996,
0.00422366,0.00603595,0.00896821,0.0135771,0.0211946,0.0309521,0.0425917,0.05748,0.0751291,0.0946923,
0.113811,0.131964,0.150698,0.169203,0.187578,0.19931,0.198919,0.191324,0.18385,0.169651,0.145875,0.119324,
0.0977319,0.0779314,0.0603199,0.0470772,0.0383539,0.0321418,0.0265759,0.021382,0.0169879,0.0132361,0.0104932,
0.00839645,0.00700521,0.00579858,0.00497156,0.004283,0.00347011,0.0026299,0.00199503,0.00152406,0.00121322,
0.000955127,0.000790287,0.000607551,0.000448363,0.000356995,0.000307072,0.000274104,0.000251498,0.000237369,
0.000232659,0.000216646,0.000197807,0.00018933,0.000174259,0.000161072,0.000149768,0.000133755,0.000123394,
0.000115859,0.000105497,9.60779e-05,9.04262e-05,8.85423e-05,9.04262e-05,9.70198e-05,0.000106439,0.000117742,
0.000123394,0.000134697,0.000151652,0.000169549,0.00018933,0.000214762,0.000243962,0.000295769,0.000352285,
0.000433292,0.00055857,0.000666893,0.000799707,0.000893901,0.000946649,0.00099563,0.00103613,0.00104838,
0.00104744,0.00105309,0.00144682,0.00145812,0.00150428,0.0015834,0.00172375,0.00192909,0.00217776,0.00245187,
0.00275235,0.00302174,0.0032139,0.00330998,0.00335236,0.00337685,0.00342772,0.00348235,0.00354169,0.00361234,
0.00367922,0.00376776,0.00389115,0.00404846,0.00422083,0.00449305,0.0048849,0.00537753,0.00582778,0.00611413,
0.00610565,0.00585416,0.00555085,0.00516842,0.00471252,0.00421235,0.00353322,0.00271844,0.00201387,0.00148732,
0.00114446,0.000925927,0.000759203,0.000599074,0.000450247,0.000356995,0.000305188,0.000261859,0.000237369,
0.000233601,0.000237369,0.000250556,0.000275046,0.000312724,0.000356995,0.000429525,0.000562338,0.000716816,
0.000891075,0.00100505,0.00120003,0.00135828,0.00148921,0.00158623,0.00170114,0.00180381,0.00193192,0.00201952,
0.00206567,0.00205908,0.00198184,0.001817,0.00165122,0.00147037,0.00129234,0.00109736,0.000940056,0.00082043,
0.000681022,0.000604725,0.000537848,0.000510531,0.000511473,0.000550093,0.000617912,0.000741307,0.000915565,
0.00115388,0.00153913,0.00222204,0.00361234,0.00527957,0.00781622,0.0111629,0.0167929,0.0245234,0.0349008,
0.0479202,0.0633144,0.0804652,0.0975049,0.113622,0.126552,0.137866,0.148458,0.157631,0.164452,0.163281,
0.151759,0.134979,0.120761,0.105914,0.0871699,0.0691657,0.0555537,0.044549,0.0360537,0.0295929,0.024352,
0.0204655,0.0171198,0.0138738,0.0115227,0.00972835,0.00821183,0.00705513,0.00600675,0.00527675,0.00470876,
0.00414736,0.00345033,0.00273068,0.0021448,0.001671,0.0013611,0.00109171,0.00090803,0.000731887,0.000567048,
0.000438944,0.000368298,0.000333447,0.000314608,0.000303305,0.000287292,0.000274104,0.000258091,0.000240195,
0.000228891,0.000207227,0.000192156,0.000174259,0.000159188,0.000149768,0.000140349,0.000133755,0.000129046,
0.000129046,0.000133755,0.000142233,0.000151652,0.000161072,0.000174259,0.000190272,0.000207227,0.000233601,
0.000262801,0.000307072,0.000360763,0.000460609,0.000604725,0.000745074,0.000891075,0.000986211,0.0011341,
0.00127633,0.001379,0.00146848,0.00150993,0.00151276,0.00149392,0.0014666,0.00179251,0.00174918,0.00174541,
0.00179063,0.0018933,0.00205343,0.00220979,0.00241231,0.0026299,0.00280415,0.00289458,0.00292378,0.00287197,
0.00277213,0.00265721,0.00254041,0.00244151,0.00233789,0.00226819,0.00223051,0.00222204,0.00226442,0.00234637,
0.00253664,0.00286444,0.00326571,0.00365378,0.0039731,0.00412193,0.00413417,0.00403904,0.00377718,0.00338533,
0.00288799,0.00232,0.00180193,0.00142045,0.00112373,0.000927811,0.000790287,0.000628274,0.000508647,0.000393731,
0.000339098,0.000299537,0.000264685,0.000251498,0.000251498,0.000268453,0.000292943,0.000324027,0.000376776,
0.000471912,0.000619796,0.00082043,0.000996572,0.00127727,0.00156268,0.00190272,0.00223993,0.00254889,
0.00282394,0.00305094,0.00325158,0.00338722,0.00347293,0.00348329,0.00340888,0.00323274,0.00292001,0.00253193,
0.00215516,0.00178592,0.00151276,0.00127821,0.00106439,0.000936288,0.000873178,0.00081101,0.000800649,
0.000816662,0.000886365,0.00096643,0.00118402,0.00150993,0.00207227,0.00297559,0.00432821,0.00635621,
0.00918109,0.0133953,0.0195339,0.0271269,0.0372283,0.0508855,0.0672828,0.0836056,0.0973523,0.108968,0.117516,
0.12245,0.125069,0.12666,0.126946,0.124206,0.11546,0.100623,0.0842754,0.0708207,0.0593592,0.0487068,0.0393213,
0.0323792,0.0264864,0.0215469,0.0178168,0.0144164,0.0118355,0.00997891,0.00879207,0.00782375,0.00702216,
0.00611131,0.00539166,0.00494895,0.00460797,0.00425474,0.00378189,0.00322991,0.00264968,0.00216269,0.00174259,
0.00145153,0.00121416,0.000980559,0.000838326,0.000664068,0.000551977,0.000454957,0.000395615,0.000377718,
0.000364531,0.000355111,0.000341924,0.000325911,0.000309898,0.000287292,0.000262801,0.000238311,0.000219472,
0.000197807,0.00018933,0.000178027,0.000174259,0.000171433,0.000174259,0.000178027,0.000190272,0.000197807,
0.000217588,0.000234543,0.000251498,0.000278814,0.000317434,0.000359821,0.000433292,0.000566106,0.000719642,
0.000891075,0.00100788,0.00121416,0.00139219,0.00157021,0.00173694,0.00189612,0.00202611,0.0020685,0.00204778,
0.00197242,0.00186692,0.00211842,0.00199974,0.00192438,0.00189612,0.0019338,0.00200633,0.00210241,0.00219472,
0.00229551,0.00236898,0.00238311,0.00232848,0.00222675,0.0020977,0.00191402,0.00173882,0.00159659,0.0014958,
0.00140537,0.00134038,0.00129705,0.00127727,0.0013027,0.00135168,0.0014666,0.00165876,0.00192815,0.00218624,
0.00239347,0.00249426,0.00246035,0.00227478,0.00205625,0.00172658,0.00146566,0.0012217,0.000989037,0.000879772,
0.000735655,0.000617912,0.000506764,0.000408802,0.000355111,0.000317434,0.000282582,0.000265627,0.000262801,
0.000272221,0.000294827,0.000321201,0.000368298,0.000460609,0.000617912,0.000817604,0.00101918,0.00136016,
0.00175012,0.00227667,0.00288987,0.00346822,0.00393166,0.00425474,0.00447139,0.00464,0.0047389,0.00476151,
0.0047097,0.00457123,0.00433857,0.00399477,0.00347953,0.00292096,0.0023718,0.00197148,0.00160507,0.00137617,
0.00121604,0.00110961,0.00106722,0.00108794,0.00117742,0.00133944,0.00157587,0.00206285,0.00281452,0.00392412,
0.00511285,0.00722185,0.0101428,0.0151803,0.0215855,0.0292406,0.0381731,0.0505511,0.0655581,0.0813205,
0.0931447,0.100611,0.104681,0.106174,0.103858,0.0989658,0.0939632,0.0891461,0.0827466,0.0722505,0.0598019,
0.04854,0.0397706,0.0334313,0.0278927,0.0226876,0.0185091,0.0145539,0.0117008,0.00986588,0.00842,0.00728214,
0.00632795,0.00555933,0.00506293,0.00471723,0.0044177,0.0041841,0.00401172,0.00378283,0.0035172,0.00320165,
0.0028051,0.00239912,0.00206662,0.00172375,0.00148167,0.00126314,0.00104084,0.000901436,0.000754494,0.000628274,
0.000555744,0.000501112,0.00047097,0.000459667,0.000443654,0.000421989,0.000405034,0.000380544,0.000355111,
0.000326853,0.000303305,0.000272221,0.00024773,0.000233601,0.000224182,0.000217588,0.000216646,0.000221356,
0.000233601,0.000243962,0.000262801,0.000282582,0.000307072,0.000332505,0.000363589,0.000417279,0.000520893,
0.000632042,0.0008063,0.000947591,0.00113692,0.0013611,0.00157304,0.00180852,0.00209299,0.00226819,0.00244904,
0.00254701,0.00257715,0.00251404,0.00238499,0.00223899,0.00224653,0.00209676,0.0019517,0.00184526,0.00180193,
0.00179628,0.00180476,0.0018349,0.00185751,0.00184903,0.0017991,0.00171433,0.00159376,0.00147508,0.00134038,
0.00121228,0.00107946,0.000989037,0.000928753,0.000888249,0.000822313,0.000791229,0.00078181,0.0008063,
0.000879772,0.000952301,0.00110113,0.00127162,0.00138371,0.00145247,0.00144305,0.00136487,0.00124242,
0.00108511,0.000947591,0.000850572,0.000720584,0.000619796,0.000537848,0.000450247,0.000385253,0.000347576,
0.000317434,0.000289176,0.000271279,0.000262801,0.000270337,0.000282582,0.00031084,0.000346634,0.00040786,
0.000544441,0.00072341,0.000940998,0.00126126,0.001671,0.00227573,0.00306319,0.00382899,0.00438756,0.00484722,
0.0052645,0.00558664,0.00580235,0.00592103,0.00588712,0.00569591,0.0054284,0.00503749,0.00461833,0.00413135,
0.00351626,0.00288799,0.00233884,0.00195547,0.00164086,0.00148167,0.00140537,0.00141856,0.00151558,0.00170114,
0.0020977,0.00271467,0.00365473,0.00468615,0.00615275,0.00815814,0.0109896,0.0159367,0.0222194,0.0299283,
0.0381928,0.0480625,0.0596775,0.0719124,0.0821654,0.0877012,0.0887081,0.0868148,0.08295,0.0759618,0.0675154,
0.0604151,0.0552033,0.0496421,0.042943,0.0358455,0.0293584,0.0231161,0.01864,0.0150465,0.0118684,0.00956351,
0.00780774,0.00666611,0.00559041,0.00486889,0.00434894,0.00393825,0.00355017,0.00327889,0.00306319,0.00288799,
0.00280227,0.00274199,0.00270713,0.0026299,0.00249331,0.00229833,0.00210147,0.0018349,0.00161637,0.00143552,
0.00124995,0.00105309,0.000924985,0.000808184,0.00069421,0.000622622,0.000590596,0.00056799,0.000564222,
0.00055857,0.000548209,0.000523719,0.000486041,0.000438944,0.000393731,0.000359821,0.000327795,0.000305188,
0.00028164,0.000269395,0.000261859,0.000263743,0.000274104,0.000293885,0.00031084,0.000331563,0.000355111,
0.000384311,0.000419163,0.000493576,0.000581177,0.000681022,0.000841152,0.000976792,0.00120003,0.00142233,
0.00166818,0.00197525,0.00224182,0.00251875,0.00274293,0.00289929,0.00297465,0.00296146,0.00286444,0.00268359,
0.00246788,0.00223146,0.00201952,0.00180099,0.00167665,0.00158811,0.00154101,0.00150051,0.0014666,0.00142515,
0.00136864,0.00131212,0.00121604,0.0010983,0.000989037,0.000917449,0.000834559,0.000755436,0.000677255,
0.000619796,0.000556686,0.000494518,0.000440828,0.000417279,0.000438944,0.000498286,0.000588712,0.000679139,
0.000798765,0.000879772,0.000905204,0.000907088,0.000879772,0.000810068,0.000726236,0.000630158,0.000556686,
0.000479447,0.000417279,0.000379602,0.000347576,0.00032026,0.000303305,0.000275046,0.000262801,0.000254324,
0.00025715,0.000268453,0.000288234,0.000319318,0.000356995,0.000430466,0.00058777,0.000801591,0.00102295,
0.00140255,0.00194416,0.00269866,0.00359162,0.00434988,0.00494142,0.0055452,0.00612543,0.00657945,0.00680363,
0.00686768,0.00676972,0.00649844,0.00604725,0.00549528,0.00492635,0.00437814,0.00380073,0.00316492,0.00257809,
0.00215893,0.00184526,0.00169643,0.001671,0.00176896,0.00204684,0.00245564,0.00322426,0.00419257,0.00526262,
0.00702028,0.00893336,0.0116876,0.0161015,0.0214338,0.0283882,0.0361695,0.0446894,0.0531923,0.0607834,
0.0668749,0.0701142,0.0700982,0.0675427,0.0632852,0.0578492,0.0508139,0.0434978,0.0382277,0.0344336,0.0305867,
0.0263018,0.0218756,0.0174541,0.0131476,0.0103604,0.00844543,0.00702781,0.00537377,0.00434894,0.00358879,
0.00298501,0.00259975,0.00232,0.00209676,0.00188953,0.00175389,0.0016823,0.00167289,0.00169926,0.00175201,
0.00182171,0.00188953,0.00188294,0.00181512,0.00171904,0.00158999,0.00147037,0.00133567,0.00118402,0.00101447,
0.000919333,0.00082043,0.000735655,0.000674429,0.000644287,0.000634867,0.000636751,0.000634867,0.000629216,
0.000617912,0.000588712,0.000550093,0.000491693,0.000426699,0.000385253,0.000353227,0.000327795,0.000317434,
0.00031084,0.000319318,0.000332505,0.000350402,0.000373008,0.00040315,0.000442712,0.000494518,0.000555744,
0.000619796,0.0007187,0.000851514,0.000968314,0.00117083,0.00139878,0.00165405,0.0019696,0.00224935,0.00255925,
0.00283806,0.00303399,0.00316209,0.00318752,0.00313007,0.00296146,0.00274104,0.00248201,0.00205343,0.0017699,
0.00157304,0.00143457,0.00133473,0.00124336,0.00115859,0.00108606,0.00101353,0.000957011,0.000907088,
0.000832675,0.000749784,0.00065559,0.000594364,0.000528428,0.000468144,0.000417279,0.000381486,0.000350402,
0.000319318,0.000296711,0.000282582,0.000289176,0.000314608,0.000348518,0.000389963,0.000450247,0.000510531,
0.00053879,0.000551035,0.000535022,0.000496402,0.000445538,0.000393731,0.000363589,0.00034004,0.000319318,
0.000303305,0.00028164,0.000268453,0.000254324,0.000245846,0.000237369,0.000237369,0.000243962,0.000258091,
0.000282582,0.000316492,0.000356053,0.000431408,0.000593422,0.000811952,0.00104555,0.00144965,0.0020393,
0.0028456,0.00377529,0.00452037,0.00518444,0.00582778,0.00649373,0.00689877,0.00707962,0.00709375,0.00695434,
0.00664162,0.00611131,0.00549716,0.00489714,0.00434894,0.00373762,0.00311499,0.00256396,0.00218247,0.00195735,
0.00184243,0.00191308,0.00215893,0.00258374,0.00333447,0.00432539,0.00548586,0.00726895,0.00920652,0.01181,
0.015736,0.0202056,0.025454,0.0318705,0.0387919,0.0457641,0.0511275,0.0539873,0.0542868,0.0526912,0.0497636,
0.0463943,0.0426124,0.0381542,0.0332232,0.0282761,0.0242493,0.0212662,0.0185929,0.0156117,0.0124788,0.0100618,
0.00813836,0.00662089,0.00522588,0.00430184,0.00313007,0.00210618,0.0015834,0.00139125,0.0013319,0.00125466,
0.00116612,0.00107664,0.00102389,0.00100788,0.00103425,0.00108794,0.00119155,0.00129611,0.00136581,0.00141479,
0.00142139,0.00139219,0.00134509,0.00126691,0.00116801,0.00104555,0.000951359,0.000888249,0.000802533,
0.00074319,0.000703629,0.000687616,0.000688558,0.000701745,0.000704571,0.000702687,0.000687616,0.000652764,
0.000619796,0.000566106,0.000514299,0.000450247,0.000399382,0.000373008,0.000356995,0.000355111,0.000363589,
0.000385253,0.00041257,0.000454957,0.000505822,0.000551977,0.000604725,0.000644287,0.000734713,0.000834559,
0.00093723,0.00109171,0.00132248,0.00154384,0.00180381,0.00213349,0.00240195,0.00269018,0.00292001,0.00307638,
0.00315738,0.00313383,0.0030095,0.00282488,0.00257526,0.00228703,0.00169926,0.00148826,0.00130741,0.00113786,
0.00100788,0.000933462,0.000876946,0.000799707,0.000711165,0.000633925,0.000573641,0.000512415,0.000442712,
0.000389963,0.000359821,0.000337214,0.000319318,0.000303305,0.000275046,0.00025715,0.000237369,0.000224182,
0.00021382,0.000215704,0.000231717,0.00024302,0.000271279,0.000299537,0.000319318,0.000333447,0.000339098,
0.000336272,0.000327795,0.000317434,0.000303305,0.000279756,0.000264685,0.000251498,0.000240195,0.000234543,
0.000232659,0.000224182,0.000219472,0.000219472,0.000224182,0.000232659,0.000243962,0.000271279,0.000303305,
0.00034004,0.00040786,0.000556686,0.000770507,0.000994688,0.00136864,0.00190083,0.00267511,0.00359915,
0.00436401,0.00499416,0.00558947,0.0061763,0.00657568,0.00673204,0.0067019,0.00649373,0.00609058,0.00557063,
0.00503278,0.00452131,0.00397593,0.00332693,0.00275329,0.00231058,0.00205625,0.00188765,0.00188953,0.00206756,
0.00242455,0.00311499,0.00408708,0.00517502,0.0069713,0.00881373,0.0112439,0.0144315,0.0184733,0.0225274,
0.027093,0.0319845,0.0367696,0.0410394,0.0432077,0.0428159,0.040283,0.0368195,0.033745,0.0307572,0.0278927,
0.0243896,0.020572,0.0172177,0.0142591,0.0119108,0.0100722,0.00865925,0.00758073,0.00635904,0.00503278,
0.00414642,0.00327041,0.00229927,0.0015655,0.00112468,0.000907088,0.000805359,0.00075261,0.000716816,
0.000673487,0.000640519,0.000629216,0.000638635,0.000678197,0.000758262,0.000846804,0.000918391,0.000969256,
0.00102106,0.00105874,0.00107004,0.00105591,0.00102389,0.000977733,0.000926869,0.000879772,0.0008063,
0.000746958,0.000710223,0.00069421,0.000697035,0.000706455,0.000731887,0.000746016,0.000749784,0.00074319,
0.000711165,0.000667835,0.000619796,0.000565164,0.000512415,0.000454957,0.000414454,0.000393731,0.000393731,
0.000410686,0.00044177,0.000487925,0.000536906,0.000580235,0.000619796,0.000664068,0.000731887,0.000809126,
0.000899552,0.000992805,0.00117554,0.00137429,0.00159659,0.00186127,0.00214762,0.00237557,0.00260164,
0.00277213,0.00286915,0.00288328,0.00280604,0.00266757,0.00245752,0.00221262,0.00197148,0.0013611,0.00116518,
0.000981501,0.000889191,0.000774274,0.000648055,0.000564222,0.000487925,0.000416337,0.000371124,0.00034004,
0.000318376,0.000297653,0.000275046,0.000258091,0.000245846,0.000235485,0.000225124,0.000211936,0.000196865,
0.00018933,0.000177085,0.000173317,0.000171433,0.000174259,0.00018462,0.000195923,0.00021382,0.000232659,
0.000237369,0.000243962,0.00024773,0.00024773,0.000237369,0.000233601,0.000226066,0.000217588,0.000207227,
0.000199691,0.000195923,0.000194982,0.000192156,0.00019404,0.000195923,0.000199691,0.00021382,0.000232659,
0.00024773,0.000275046,0.000316492,0.000366415,0.000471912,0.000652764,0.000906146,0.00120568,0.00160601,
0.00223522,0.00305848,0.00387231,0.00447327,0.00494047,0.00533138,0.00558288,0.00567142,0.00560454,0.00541521,
0.00509778,0.00472477,0.00430561,0.00378189,0.00318752,0.00261012,0.00220414,0.00192815,0.00174636,0.00170962,
0.00179534,0.00208828,0.00257809,0.00345033,0.00450812,0.0058843,0.00779644,0.00988001,0.0125476,0.0159565,
0.0193013,0.0225858,0.0257837,0.0288902,0.031473,0.0331855,0.033291,0.0314391,0.028343,0.0247627,0.021804,
0.0193258,0.0169803,0.0142629,0.0116669,0.00979146,0.00833899,0.00721432,0.00614522,0.00529276,0.00462681,
0.00387797,0.00293979,0.00221262,0.00167477,0.0012509,0.000924985,0.000690442,0.000536906,0.000434234,
0.000389021,0.00036924,0.000357937,0.000354169,0.000359821,0.000380544,0.000418221,0.000486041,0.00055857,
0.000619796,0.000688558,0.000755436,0.0008063,0.000836443,0.000853397,0.000852455,0.000822313,0.000791229,
0.000742249,0.000691384,0.000657474,0.000647113,0.000651822,0.000669719,0.00069421,0.00072341,0.000746958,
0.000763913,0.000758262,0.000735655,0.00069421,0.000642403,0.000604725,0.000545383,0.000492635,0.000450247,
0.000423873,0.000427641,0.000454957,0.000494518,0.00053879,0.000586828,0.00062168,0.000664068,0.000716816,
0.000778984,0.000846804,0.000922159,0.00100788,0.00118779,0.00136675,0.00157021,0.00178969,0.00204213,
0.00220414,0.00233601,0.0024368,0.00246223,0.00241984,0.00230869,0.00217965,0.0019922,0.00175389,0.00155232,
0.000996572,0.000891075,0.000742249,0.000612261,0.000499228,0.000399382,0.000348518,0.000309898,0.000275046,
0.000251498,0.000236427,0.000226066,0.000215704,0.000204401,0.000195923,0.000191214,0.00018462,0.000174259,
0.000169549,0.000159188,0.000152594,0.000148826,0.000143175,0.000141291,0.000143175,0.000148826,0.000152594,
0.000162014,0.000174259,0.00017991,0.000190272,0.000192156,0.000194982,0.000192156,0.000191214,0.00018462,
0.000178027,0.000174259,0.000171433,0.000170491,0.000168607,0.000170491,0.000173317,0.000175201,0.000183678,
0.000192156,0.000204401,0.000226066,0.00024773,0.000278814,0.00032026,0.000381486,0.00052937,0.000734713,
0.000952301,0.00128386,0.00168796,0.00225218,0.00293697,0.00357937,0.00407672,0.00434423,0.00448269,0.00451754,
0.00444972,0.00428771,0.00402679,0.00361516,0.00314796,0.00260917,0.00218153,0.00183113,0.00160507,0.00148732,
0.00143834,0.00148544,0.00162579,0.00197902,0.00258091,0.00357278,0.00469463,0.00622905,0.00807148,0.0101626,
0.0126766,0.0156673,0.0183339,0.0205004,0.0223174,0.0235221,0.0241928,0.02427,0.0233497,0.0212643,0.0184309,
0.0153207,0.01259,0.0107899,0.00942222,0.00814307,0.00701274,0.005808,0.00491975,0.00433198,0.00379413,
0.0031781,0.0025065,0.0019517,0.00151276,0.00121416,0.000944766,0.000746958,0.000552919,0.000389963,0.000325911,
0.00028164,0.000253382,0.000238311,0.000236427,0.000237369,0.000250556,0.000271279,0.000297653,0.00032026,
0.000350402,0.000382428,0.000421047,0.000478505,0.000537848,0.000580235,0.000615087,0.00062168,0.000619796,
0.000612261,0.000593422,0.000573641,0.000569874,0.000580235,0.000604725,0.000619796,0.000644287,0.000678197,
0.000716816,0.000735655,0.000742249,0.000722468,0.000686674,0.000638635,0.000604725,0.000551977,0.000503938,
0.000460609,0.00044177,0.000450247,0.000471912,0.000519951,0.000562338,0.000611319,0.000640519,0.000683848,
0.000732829,0.000782752,0.000841152,0.00090803,0.000981501,0.00112468,0.00129611,0.00146095,0.00161825,
0.00178498,0.00192438,0.00200633,0.00203553,0.00199409,0.00189801,0.00177085,0.00163427,0.00149863,0.00134509,
0.00118308,0.000735655,0.000604725,0.000471912,0.000379602,0.000324969,0.000279756,0.00024302,0.000219472,
0.000197807,0.000190272,0.00017991,0.000174259,0.000168607,0.000161072,0.000153536,0.000151652,0.000148826,
0.000141291,0.000134697,0.000128104,0.000123394,0.000120568,0.000118684,0.000118684,0.000118684,0.000120568,
0.000123394,0.000127162,0.000134697,0.000146001,0.000151652,0.00015542,0.000159188,0.000159188,0.00015542,
0.000152594,0.000149768,0.000148826,0.000145059,0.000143175,0.000143175,0.000147885,0.000149768,0.000153536,
0.000161072,0.000171433,0.000182736,0.000195923,0.00021853,0.000237369,0.000271279,0.000314608,0.000377718,
0.000525602,0.000716816,0.00093252,0.00120851,0.00151935,0.0019046,0.00231058,0.00270054,0.00296146,0.0030971,
0.00309239,0.00297465,0.00277778,0.00248672,0.00218624,0.00185939,0.0015834,0.00138842,0.00124619,0.00113786,
0.00108794,0.00111714,0.00122735,0.00142045,0.00176708,0.00242455,0.00343525,0.0045816,0.00598791,0.00777006,
0.00962945,0.0116443,0.0137156,0.0157879,0.0170463,0.0177622,0.0178479,0.017327,0.01637,0.0148459,0.0127765,
0.0107099,0.00888532,0.00741966,0.00622622,0.00530218,0.00465601,0.00406259,0.00333352,0.00268359,0.00219095,
0.00179063,0.00149392,0.0012509,0.00101918,0.000888249,0.000702687,0.000547267,0.000395615,0.000321201,
0.000265627,0.000232659,0.000197807,0.00018462,0.000174259,0.000170491,0.000174259,0.000186504,0.000195923,
0.000215704,0.000232659,0.00024773,0.000265627,0.000292001,0.000318376,0.00034475,0.000372066,0.000395615,
0.000417279,0.000429525,0.000438002,0.000438002,0.00044177,0.000456841,0.00047568,0.000512415,0.000551977,
0.00058777,0.000619796,0.000648997,0.000673487,0.000681964,0.000673487,0.000645229,0.000617912,0.000571757,
0.000531254,0.000483215,0.000450247,0.00043235,0.00044177,0.00047097,0.000515241,0.00055857,0.000607551,
0.0006311,0.000669719,0.000704571,0.000746958,0.000801591,0.000871294,0.000928753,0.00100788,0.00114728,
0.0012914,0.00141197,0.00152029,0.00157587,0.00159753,0.00157587,0.00152406,0.00143552,0.00133944,0.00122075,
0.00108511,0.000965488,0.000879772,0.00046155,0.00036924,0.000314608,0.000264685,0.000232659,0.000199691,
0.000183678,0.000170491,0.000159188,0.000152594,0.000149768,0.000142233,0.000134697,0.000128104,0.000123394,
0.00012151,0.000118684,0.000112091,0.000109265,0.000105497,0.000102671,9.89037e-05,9.3252e-05,9.3252e-05,
9.3252e-05,9.3252e-05,9.98456e-05,0.000105497,0.000112091,0.000118684,0.000123394,0.00012622,0.000129988,
0.000129988,0.000128104,0.000123394,0.000123394,0.00012151,0.000119626,0.000118684,0.000120568,0.000123394,
0.000125278,0.00013093,0.000138465,0.000149768,0.000157304,0.000171433,0.000185562,0.000200633,0.000224182,
0.00024773,0.000282582,0.00034475,0.000442712,0.000616029,0.000804417,0.000957011,0.00116047,0.00136581,
0.00154101,0.00166629,0.00172469,0.00170585,0.00163332,0.00153065,0.00139125,0.00124713,0.00108606,0.000959837,
0.000894843,0.000828907,0.000801591,0.000808184,0.00087412,0.000958895,0.00119532,0.00154101,0.00215516,
0.00308203,0.00421424,0.00534174,0.0069647,0.00837761,0.00986964,0.0112147,0.0122198,0.0127369,0.0127002,
0.0122292,0.0114323,0.0102436,0.00902096,0.00779267,0.00657286,0.00524566,0.00437154,0.00363212,0.00296617,
0.00242549,0.00198749,0.00160507,0.00136675,0.00113315,0.000944766,0.00082043,0.000681964,0.000574583,
0.000454957,0.000363589,0.000308956,0.000258091,0.000219472,0.000192156,0.000171433,0.000152594,0.000143175,
0.000129988,0.000127162,0.00013093,0.000143175,0.000151652,0.000161072,0.000170491,0.000177085,0.000191214,
0.000204401,0.000224182,0.000240195,0.000264685,0.000288234,0.000307072,0.000319318,0.000327795,0.000337214,
0.000347576,0.000359821,0.000379602,0.00040786,0.000447421,0.000494518,0.000545383,0.000581177,0.000611319,
0.000617912,0.000617912,0.000600016,0.000562338,0.000525602,0.000477563,0.00044177,0.000416337,0.000408802,
0.000416337,0.000438944,0.000478505,0.00052937,0.000564222,0.000610377,0.000628274,0.000651822,0.000678197,
0.000719642,0.000780868,0.000846804,0.000911798,0.000973024,0.00106345,0.00116801,0.00124619,0.00128669,
0.00128292,0.00124242,0.00115859,0.00105497,0.000968314,0.000900494,0.000808184,0.000693268,0.000586828,
0.000309898,0.000258091,0.000224182,0.000192156,0.000171433,0.000152594,0.000140349,0.00013093,0.000127162,
0.000123394,0.00012151,0.000118684,0.000112091,0.000106439,0.000102671,9.3252e-05,8.85423e-05,8.28907e-05,
8.00649e-05,7.91229e-05,7.72391e-05,7.62971e-05,7.53552e-05,7.15874e-05,7.15874e-05,7.34713e-05,7.62971e-05,
7.8181e-05,8.38326e-05,9.3252e-05,9.98456e-05,0.000105497,0.000106439,0.000106439,0.000106439,0.000105497,
0.000101729,9.70198e-05,9.60779e-05,9.60779e-05,9.98456e-05,0.000105497,0.000107381,0.000113033,0.000118684,
0.000123394,0.000133755,0.000146001,0.000153536,0.000169549,0.00017991,0.000194982,0.000214762,0.000237369,
0.00028635,0.00034475,0.000426699,0.00055857,0.000664068,0.000793113,0.000891075,0.000934404,0.000955127,
0.000947591,0.000924985,0.000879772,0.000801591,0.000706455,0.00062639,0.000564222,0.000523719,0.000498286,
0.000505822,0.000544441,0.000619796,0.000778984,0.000957011,0.00129611,0.0017699,0.00254889,0.00359162,
0.00457877,0.00559512,0.00692232,0.00789722,0.00867621,0.0091971,0.00932144,0.00908407,0.00853397,0.0078068,
0.00689877,0.00563374,0.00470781,0.00392695,0.00305283,0.00229268,0.00178969,0.00147696,0.00124148,0.00103708,
0.000925927,0.00082043,0.000674429,0.000559512,0.000448363,0.000372066,0.00032026,0.000272221,0.000235485,
0.000204401,0.000178969,0.000157304,0.000142233,0.000127162,0.000120568,0.000112091,0.000105497,0.000103613,
0.000105497,0.000111149,0.000117742,0.000120568,0.000123394,0.00012622,0.000133755,0.000147885,0.000157304,
0.000174259,0.000192156,0.000207227,0.000226066,0.000237369,0.000249614,0.000262801,0.000275046,0.000295769,
0.00031555,0.000338156,0.000363589,0.000393731,0.000438944,0.000476622,0.000512415,0.00052937,0.00052937,
0.000513357,0.000483215,0.000450247,0.000416337,0.000389021,0.00037866,0.000373008,0.000379602,0.000393731,
0.000422931,0.000467202,0.000510531,0.000545383,0.000565164,0.000588712,0.000611319,0.00062168,0.000648055,
0.000702687,0.000773333,0.000834559,0.000897669,0.000936288,0.000970198,0.000985269,0.000978675,0.000946649,
0.00090332,0.000826081,0.000735655,0.0006311,0.000550093,0.000438944,0.000363589,0.000224182,0.000192156,
0.000167665,0.000148826,0.000127162,0.000118684,0.000109265,0.000105497,0.000102671,9.98456e-05,9.60779e-05,
9.3252e-05,8.76004e-05,8.00649e-05,7.62971e-05,7.53552e-05,7.06455e-05,6.78197e-05,6.59358e-05,6.49938e-05,
6.311e-05,6.2168e-05,6.02841e-05,5.93422e-05,5.84003e-05,5.84003e-05,6.02841e-05,6.311e-05,6.68777e-05,
7.15874e-05,7.62971e-05,7.62971e-05,7.91229e-05,8.00649e-05,7.91229e-05,7.8181e-05,7.62971e-05,7.62971e-05,
7.62971e-05,7.62971e-05,7.62971e-05,7.91229e-05,8.10068e-05,8.85423e-05,9.3252e-05,0.000104555,0.000111149,
0.000118684,0.000123394,0.000134697,0.000147885,0.000152594,0.000161072,0.000174259,0.000192156,0.000219472,
0.000253382,0.000303305,0.000338156,0.000376776,0.000416337,0.000460609,0.000492635,0.000494518,0.000463434,
0.000417279,0.000384311,0.000356053,0.000335331,0.000321201,0.000319318,0.00032026,0.000335331,0.000362647,
0.000422931,0.000571757,0.00078652,0.00101353,0.0014261,0.00201387,0.00279097,0.00370559,0.0044761,0.00515618,
0.00582684,0.006457,0.00673016,0.00668777,0.00633172,0.00568649,0.00501583,0.00431974,0.00346069,0.00257715,
0.00191025,0.00147225,0.00119155,0.000983385,0.000889191,0.000762029,0.000638635,0.000564222,0.00047568,
0.000389963,0.000339098,0.000296711,0.000251498,0.000219472,0.000190272,0.000168607,0.000149768,0.000127162,
0.000118684,0.000106439,9.60779e-05,8.66585e-05,8.00649e-05,7.72391e-05,7.62971e-05,7.62971e-05,7.72391e-05,
7.91229e-05,8.00649e-05,8.28907e-05,8.47746e-05,8.85423e-05,9.98456e-05,0.000111149,0.000123394,0.000137523,
0.000152594,0.000169549,0.00017991,0.000192156,0.000206285,0.000219472,0.000235485,0.000251498,0.000275046,
0.000307072,0.000333447,0.000357937,0.000381486,0.00040315,0.000416337,0.000417279,0.000411628,0.000393731,
0.000379602,0.000359821,0.000347576,0.000339098,0.000335331,0.00034004,0.000355111,0.000376776,0.000395615,
0.000422931,0.000456841,0.00047568,0.000494518,0.000508647,0.000520893,0.000537848,0.00056328,0.000607551,
0.000638635,0.00069421,0.000745074,0.00078181,0.000797823,0.00078652,0.00074319,0.000671603,0.000607551,
0.000520893,0.000420105,0.000356995,0.000308014,0.000258091,0.000170491,0.000149768,0.00012622,0.000113033,
9.60779e-05,8.19488e-05,7.62971e-05,7.62971e-05,7.62971e-05,7.53552e-05,7.53552e-05,7.34713e-05,6.87616e-05,
6.59358e-05,6.311e-05,6.02841e-05,5.84003e-05,5.84003e-05,5.55744e-05,5.27486e-05,5.08647e-05,4.99228e-05,
4.99228e-05,4.80389e-05,4.80389e-05,4.80389e-05,4.89809e-05,5.08647e-05,5.46325e-05,5.84003e-05,5.93422e-05,
6.2168e-05,6.311e-05,6.49938e-05,6.49938e-05,6.40519e-05,6.311e-05,6.311e-05,6.311e-05,6.311e-05,6.311e-05,
6.49938e-05,6.59358e-05,6.87616e-05,7.53552e-05,7.62971e-05,8.00649e-05,8.76004e-05,9.60779e-05,0.000105497,
0.000112091,0.000118684,0.00012151,0.000123394,0.000133755,0.000148826,0.000162014,0.000182736,0.000200633,
0.000224182,0.000237369,0.000253382,0.000262801,0.000263743,0.000258091,0.00024773,0.000236427,0.000232659,
0.000225124,0.000226066,0.000232659,0.000237369,0.00025244,0.000282582,0.000331563,0.000410686,0.000598132,
0.000837384,0.00110113,0.00150334,0.00204213,0.00265721,0.00332693,0.00388833,0.00425663,0.00445443,0.00450341,
0.00439321,0.00415961,0.00370371,0.00304435,0.00229551,0.00170585,0.00131777,0.00099563,0.000847746,0.000700803,
0.000607551,0.00052466,0.000442712,0.000387137,0.000347576,0.000307072,0.000271279,0.000236427,0.000207227,
0.00018462,0.00016013,0.000143175,0.000123394,0.000111149,9.3252e-05,7.8181e-05,7.15874e-05,6.59358e-05,
6.311e-05,6.2168e-05,6.2168e-05,6.12261e-05,6.02841e-05,5.93422e-05,5.93422e-05,5.93422e-05,5.93422e-05,
5.93422e-05,6.02841e-05,6.311e-05,6.87616e-05,7.91229e-05,9.60779e-05,0.000113975,0.000123394,0.000137523,
0.000151652,0.000162014,0.000176143,0.000192156,0.000207227,0.000232659,0.000249614,0.000275046,0.000303305,
0.000319318,0.000333447,0.000340982,0.000346634,0.00034475,0.000335331,0.000324027,0.000314608,0.000303305,
0.000299537,0.000297653,0.000303305,0.000314608,0.000326853,0.00034475,0.000359821,0.000374892,0.000385253,
0.000389963,0.000393731,0.000399382,0.000408802,0.000417279,0.00044177,0.000474738,0.000519951,0.000551977,
0.00056799,0.000580235,0.000565164,0.000537848,0.000479447,0.00041257,0.000359821,0.000314608,0.000270337,
0.000232659,0.000194982,0.000129988,0.000118684,0.000100788,8.00649e-05,7.44132e-05,6.49938e-05,6.2168e-05,
6.02841e-05,5.93422e-05,5.93422e-05,5.93422e-05,5.84003e-05,5.55744e-05,5.27486e-05,4.99228e-05,4.80389e-05,
4.80389e-05,4.52131e-05,4.33292e-05,4.33292e-05,4.23873e-05,4.23873e-05,4.14454e-05,4.05034e-05,4.05034e-05,
4.05034e-05,4.14454e-05,4.23873e-05,4.33292e-05,4.42712e-05,4.80389e-05,4.99228e-05,4.99228e-05,5.08647e-05,
5.18067e-05,5.27486e-05,5.27486e-05,5.27486e-05,5.27486e-05,5.27486e-05,5.18067e-05,5.18067e-05,5.27486e-05,
5.55744e-05,5.84003e-05,5.93422e-05,6.12261e-05,6.311e-05,6.68777e-05,7.34713e-05,7.62971e-05,8.00649e-05,
8.38326e-05,8.76004e-05,8.85423e-05,9.4194e-05,0.000106439,0.000118684,0.000129988,0.000148826,0.000153536,
0.000162014,0.000167665,0.000167665,0.000167665,0.000165781,0.000166723,0.000165781,0.000168607,0.000174259,
0.000181794,0.000192156,0.000207227,0.000234543,0.000274104,0.000333447,0.000433292,0.000628274,0.000879772,
0.00111431,0.00144117,0.00178969,0.00218247,0.00248672,0.00271561,0.00280415,0.00273634,0.00254324,0.00226537,
0.00193663,0.00154196,0.00121604,0.000933462,0.000724352,0.000564222,0.000463434,0.000393731,0.000356995,
0.000324027,0.000299537,0.000266569,0.000237369,0.000214762,0.000191214,0.000170491,0.000151652,0.000133755,
0.000120568,0.000106439,8.85423e-05,7.62971e-05,6.311e-05,5.84003e-05,5.08647e-05,4.80389e-05,4.80389e-05,
4.7097e-05,4.7097e-05,4.42712e-05,4.33292e-05,4.23873e-05,4.23873e-05,4.23873e-05,4.14454e-05,4.14454e-05,
4.14454e-05,4.23873e-05,4.7097e-05,5.55744e-05,6.311e-05,7.62971e-05,8.85423e-05,0.000106439,0.000119626,
0.000129988,0.000147885,0.000157304,0.000174259,0.000192156,0.000209111,0.000232659,0.000243962,0.000261859,
0.000274104,0.00028164,0.000287292,0.00028635,0.000279756,0.000272221,0.000262801,0.000255266,0.000250556,
0.000251498,0.00025715,0.000268453,0.000278814,0.000295769,0.000307072,0.000317434,0.00032026,0.000325911,
0.000326853,0.000326853,0.000327795,0.000334389,0.00034004,0.000354169,0.00036924,0.000385253,0.000393731,
0.000399382,0.000389021,0.000370182,0.00034475,0.00031084,0.000272221,0.000236427,0.000201575,0.000174259,
0.000151652,0.000105497,8.76004e-05,7.53552e-05,6.49938e-05,5.84003e-05,5.08647e-05,4.99228e-05,4.80389e-05,
4.80389e-05,4.7097e-05,4.42712e-05,4.33292e-05,4.23873e-05,4.23873e-05,4.14454e-05,4.05034e-05,4.05034e-05,
3.86195e-05,3.67357e-05,3.2026e-05,3.1084e-05,3.01421e-05,2.82582e-05,2.82582e-05,2.82582e-05,2.82582e-05,
3.01421e-05,3.1084e-05,3.57937e-05,3.95615e-05,4.05034e-05,4.14454e-05,4.23873e-05,4.23873e-05,4.33292e-05,
4.33292e-05,4.33292e-05,4.33292e-05,4.33292e-05,4.23873e-05,4.23873e-05,4.23873e-05,4.23873e-05,4.23873e-05,
4.23873e-05,4.33292e-05,4.33292e-05,4.42712e-05,4.80389e-05,4.99228e-05,5.55744e-05,5.84003e-05,6.02841e-05,
6.2168e-05,6.2168e-05,6.2168e-05,6.311e-05,6.87616e-05,7.62971e-05,8.76004e-05,9.89037e-05,0.000105497,
0.000111149,0.000115859,0.000118684,0.000122452,0.000123394,0.000129046,0.000134697,0.000146001,0.000152594,
0.000167665,0.000182736,0.000199691,0.000234543,0.000278814,0.000348518,0.000469086,0.000643345,0.000860933,
0.00101353,0.00124619,0.00143363,0.00156456,0.00161543,0.00160507,0.00154572,0.00142515,0.00126691,0.0010578,
0.000898611,0.00069421,0.000519951,0.000385253,0.000333447,0.000303305,0.000271279,0.000243962,0.000231717,
0.000204401,0.000187446,0.000170491,0.000152594,0.000134697,0.00012151,0.000111149,9.79617e-05,8.28907e-05,
7.53552e-05,6.311e-05,5.55744e-05,4.7097e-05,4.14454e-05,4.05034e-05,3.67357e-05,3.2026e-05,3.1084e-05,
3.01421e-05,2.82582e-05,2.73163e-05,2.73163e-05,2.73163e-05,2.73163e-05,2.73163e-05,2.73163e-05,2.73163e-05,
2.73163e-05,2.82582e-05,3.86195e-05,4.33292e-05,5.55744e-05,6.49938e-05,7.62971e-05,9.13682e-05,0.000108323,
0.00012151,0.000133755,0.000149768,0.000162014,0.000177085,0.000192156,0.000205343,0.000219472,0.000232659,
0.000233601,0.000235485,0.000235485,0.000233601,0.000232659,0.000220414,0.000217588,0.000216646,0.000217588,
0.000219472,0.000232659,0.000235485,0.000242079,0.000249614,0.000258091,0.000262801,0.000264685,0.000266569,
0.000265627,0.000265627,0.000270337,0.000272221,0.00028164,0.000292943,0.000303305,0.000307072,0.000307072,
0.000303305,0.00028164,0.000258091,0.000234543,0.000206285,0.000181794,0.000157304,0.000136581,0.000120568,
7.62971e-05,6.78197e-05,5.93422e-05,5.08647e-05,4.7097e-05,4.23873e-05,4.05034e-05,3.76776e-05,3.48518e-05,
3.1084e-05,3.01421e-05,3.01421e-05,2.82582e-05,2.82582e-05,2.73163e-05,2.73163e-05,2.73163e-05,2.73163e-05,
2.73163e-05,2.63743e-05,2.63743e-05,2.63743e-05,2.54324e-05,2.54324e-05,2.54324e-05,2.54324e-05,2.63743e-05,
2.63743e-05,2.73163e-05,2.73163e-05,2.82582e-05,2.92001e-05,3.01421e-05,3.1084e-05,3.29679e-05,3.57937e-05,
3.57937e-05,3.39098e-05,3.1084e-05,3.01421e-05,2.92001e-05,2.82582e-05,2.73163e-05,2.73163e-05,2.73163e-05,
2.73163e-05,2.73163e-05,2.73163e-05,2.73163e-05,3.01421e-05,3.57937e-05,4.05034e-05,4.14454e-05,4.14454e-05,
4.23873e-05,4.14454e-05,4.23873e-05,4.23873e-05,4.80389e-05,5.18067e-05,5.93422e-05,6.49938e-05,7.15874e-05,
7.62971e-05,8.19488e-05,8.85423e-05,9.79617e-05,0.000105497,0.000115859,0.00012151,0.000129988,0.000147885,
0.000159188,0.000177085,0.000197807,0.000236427,0.000288234,0.000356995,0.000470028,0.000617912,0.000770507,
0.000896727,0.000970198,0.00103331,0.00105497,0.00103331,0.000978675,0.000919333,0.00081101,0.000652764,
0.000520893,0.000385253,0.000319318,0.000274104,0.000237369,0.00021382,0.000191214,0.000173317,0.000153536,
0.000143175,0.000129046,0.000118684,0.000105497,9.13682e-05,7.91229e-05,7.53552e-05,6.59358e-05,6.02841e-05,
5.18067e-05,4.42712e-05,4.05034e-05,3.01421e-05,2.73163e-05,2.63743e-05,2.54324e-05,2.54324e-05,2.35485e-05,
2.16646e-05,2.16646e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,
2.16646e-05,2.16646e-05,2.63743e-05,3.01421e-05,4.14454e-05,4.99228e-05,6.12261e-05,7.15874e-05,8.19488e-05,
0.000101729,0.000116801,0.000125278,0.000140349,0.000152594,0.000162956,0.000174259,0.000183678,0.000190272,
0.000192156,0.00019404,0.000192156,0.000192156,0.000190272,0.000185562,0.00018462,0.000182736,0.00018462,
0.000187446,0.000192156,0.000194982,0.000197807,0.000206285,0.000210995,0.000215704,0.000217588,0.000219472,
0.000219472,0.000219472,0.000219472,0.000224182,0.000230775,0.000232659,0.000234543,0.000236427,0.000234543,
0.000230775,0.000214762,0.000195923,0.000178027,0.000159188,0.000141291,0.000123394,0.000109265,9.13682e-05,
6.311e-05,5.65164e-05,4.80389e-05,4.23873e-05,3.86195e-05,2.92001e-05,2.73163e-05,2.63743e-05,2.54324e-05,
2.54324e-05,2.54324e-05,2.35485e-05,2.35485e-05,2.35485e-05,2.35485e-05,2.35485e-05,2.16646e-05,2.16646e-05,
2.16646e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,
2.16646e-05,2.16646e-05,2.35485e-05,2.54324e-05,2.54324e-05,2.63743e-05,2.63743e-05,2.63743e-05,2.63743e-05,
2.63743e-05,2.63743e-05,2.63743e-05,2.54324e-05,2.54324e-05,2.16646e-05,2.07227e-05,2.07227e-05,2.07227e-05,
1.97807e-05,1.97807e-05,1.97807e-05,1.97807e-05,2.07227e-05,2.07227e-05,2.16646e-05,2.16646e-05,2.54324e-05,
2.54324e-05,2.54324e-05,2.54324e-05,2.63743e-05,2.73163e-05,3.01421e-05,4.05034e-05,4.33292e-05,4.99228e-05,
5.84003e-05,6.311e-05,6.68777e-05,7.53552e-05,7.91229e-05,8.85423e-05,0.000101729,0.000113033,0.000123394,
0.000137523,0.000153536,0.000174259,0.000197807,0.000237369,0.000287292,0.000347576,0.000418221,0.00053408,
0.000618854,0.000683848,0.00074319,0.00075261,0.000731887,0.000668777,0.000604725,0.000503938,0.000391847,
0.000327795,0.000275046,0.000236427,0.000204401,0.000177085,0.000153536,0.000131872,0.000118684,0.000105497,
9.3252e-05,8.00649e-05,7.53552e-05,6.59358e-05,6.2168e-05,5.84003e-05,5.08647e-05,4.80389e-05,4.23873e-05,
3.67357e-05,2.73163e-05,2.63743e-05,2.44904e-05,2.07227e-05,2.07227e-05,2.07227e-05,1.88388e-05,1.78969e-05,
1.5071e-05,1.41291e-05,1.41291e-05,1.41291e-05,1.41291e-05,1.5071e-05,1.5071e-05,1.5071e-05,1.78969e-05,
1.78969e-05,1.97807e-05,2.16646e-05,2.63743e-05,2.92001e-05,4.14454e-05,4.99228e-05,5.93422e-05,6.87616e-05,
7.91229e-05,9.3252e-05,0.000109265,0.000120568,0.000128104,0.000137523,0.000148826,0.000152594,0.000157304,
0.00016013,0.000161072,0.000161072,0.000159188,0.000157304,0.000153536,0.000153536,0.000153536,0.000153536,
0.00015542,0.000159188,0.000162014,0.000167665,0.000171433,0.000174259,0.000175201,0.000177085,0.000178969,
0.00017991,0.000183678,0.00018462,0.00018462,0.000186504,0.000188388,0.000188388,0.00018462,0.00017991,
0.000174259,0.000162014,0.000151652,0.000134697,0.00012151,0.000109265,9.23101e-05,7.72391e-05,6.87616e-05,
5.08647e-05,4.52131e-05,4.14454e-05,3.1084e-05,2.73163e-05,2.54324e-05,2.16646e-05,2.07227e-05,1.97807e-05,
1.88388e-05,1.78969e-05,1.78969e-05,1.78969e-05,1.78969e-05,1.78969e-05,1.78969e-05,1.78969e-05,1.78969e-05,
1.78969e-05,1.78969e-05,1.78969e-05,1.6013e-05,1.5071e-05,1.5071e-05,1.5071e-05,1.5071e-05,1.5071e-05,
1.78969e-05,1.78969e-05,1.88388e-05,1.97807e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,
2.07227e-05,2.07227e-05,2.07227e-05,1.97807e-05,1.88388e-05,1.78969e-05,1.41291e-05,1.22452e-05,1.13033e-05,
1.13033e-05,1.13033e-05,9.4194e-06,1.03613e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,
1.31872e-05,1.31872e-05,1.41291e-05,1.5071e-05,1.78969e-05,2.07227e-05,2.54324e-05,2.73163e-05,3.57937e-05,
4.14454e-05,4.7097e-05,5.08647e-05,5.93422e-05,6.49938e-05,7.44132e-05,8.00649e-05,9.3252e-05,0.000106439,
0.000120568,0.000134697,0.000152594,0.000174259,0.000195923,0.000232659,0.000271279,0.000317434,0.000357937,
0.000395615,0.00044177,0.00047097,0.00047568,0.000459667,0.000416337,0.00036924,0.000325911,0.00028164,
0.000239253,0.000207227,0.00017991,0.000153536,0.00013093,0.000115859,9.3252e-05,7.62971e-05,6.59358e-05,
5.93422e-05,5.46325e-05,4.99228e-05,4.7097e-05,4.33292e-05,4.14454e-05,3.76776e-05,2.82582e-05,2.73163e-05,
2.54324e-05,2.07227e-05,1.97807e-05,1.78969e-05,1.69549e-05,1.5071e-05,1.31872e-05,1.13033e-05,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.22452e-05,
1.41291e-05,1.69549e-05,1.97807e-05,2.16646e-05,2.63743e-05,3.1084e-05,4.23873e-05,4.99228e-05,5.93422e-05,
6.68777e-05,7.62971e-05,8.66585e-05,9.98456e-05,0.000111149,0.000118684,0.000123394,0.000125278,0.000129988,
0.00013093,0.000133755,0.000133755,0.000131872,0.000129988,0.000129988,0.000128104,0.000127162,0.000128104,
0.000129988,0.000129988,0.000133755,0.000135639,0.000138465,0.000143175,0.000147885,0.000149768,0.00015071,
0.000151652,0.000152594,0.000152594,0.000153536,0.000153536,0.000153536,0.000152594,0.000149768,0.000144117,
0.000133755,0.000123394,0.000116801,0.000102671,8.47746e-05,7.62971e-05,6.68777e-05,6.2168e-05,5.84003e-05,
4.23873e-05,3.95615e-05,2.82582e-05,2.63743e-05,2.35485e-05,2.07227e-05,1.78969e-05,1.5071e-05,1.31872e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.31872e-05,1.41291e-05,1.41291e-05,1.5071e-05,1.5071e-05,1.5071e-05,
1.5071e-05,1.41291e-05,1.41291e-05,1.31872e-05,1.13033e-05,1.13033e-05,9.4194e-06,6.59358e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,8.47746e-06,1.13033e-05,1.5071e-05,1.97807e-05,2.16646e-05,
2.63743e-05,2.82582e-05,4.05034e-05,4.33292e-05,5.08647e-05,6.02841e-05,6.78197e-05,7.62971e-05,8.85423e-05,
0.000105497,0.000118684,0.00013093,0.000149768,0.000168607,0.00018933,0.000214762,0.000238311,0.000271279,
0.000296711,0.00031084,0.000319318,0.000318376,0.000307072,0.000289176,0.000263743,0.000237369,0.000209111,
0.00018462,0.000162014,0.000142233,0.00012151,0.000102671,7.72391e-05,6.311e-05,5.27486e-05,4.33292e-05,
4.05034e-05,3.67357e-05,3.01421e-05,2.73163e-05,2.73163e-05,2.63743e-05,2.54324e-05,2.07227e-05,1.97807e-05,
1.78969e-05,1.41291e-05,1.22452e-05,1.13033e-05,1.13033e-05,1.13033e-05,9.4194e-06,7.53552e-06,6.59358e-06,
6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,6.59358e-06,6.59358e-06,8.47746e-06,1.13033e-05,
1.13033e-05,1.31872e-05,1.78969e-05,2.07227e-05,2.54324e-05,2.73163e-05,3.67357e-05,4.23873e-05,4.99228e-05,
5.84003e-05,6.311e-05,7.06455e-05,7.62971e-05,8.47746e-05,9.3252e-05,0.000102671,0.000105497,0.000109265,
0.000111149,0.000111149,0.000111149,0.000111149,0.000111149,0.000111149,0.000110207,0.000109265,0.000109265,
0.000109265,0.000109265,0.000111149,0.000113033,0.000115859,0.000118684,0.000118684,0.00012151,0.000123394,
0.000123394,0.000123394,0.000123394,0.000124336,0.000123394,0.000123394,0.00012151,0.000118684,0.000111149,
0.000102671,8.85423e-05,7.62971e-05,6.87616e-05,6.311e-05,5.84003e-05,5.36906e-05,4.99228e-05,4.7097e-05,
3.01421e-05,2.73163e-05,2.54324e-05,2.16646e-05,1.97807e-05,1.5071e-05,1.31872e-05,1.13033e-05,9.4194e-06,
7.53552e-06,6.59358e-06,6.59358e-06,6.59358e-06,6.59358e-06,6.59358e-06,7.53552e-06,8.47746e-06,8.47746e-06,
9.4194e-06,8.47746e-06,8.47746e-06,7.53552e-06,6.59358e-06,6.59358e-06,6.59358e-06,6.59358e-06,6.59358e-06,
6.59358e-06,6.59358e-06,6.59358e-06,6.59358e-06,8.47746e-06,9.4194e-06,1.03613e-05,1.13033e-05,1.13033e-05,
1.03613e-05,9.4194e-06,8.47746e-06,6.59358e-06,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,3.76776e-06,3.76776e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.41291e-05,
1.88388e-05,2.07227e-05,2.63743e-05,3.01421e-05,4.23873e-05,4.99228e-05,5.93422e-05,6.59358e-05,7.62971e-05,
8.85423e-05,0.000105497,0.000118684,0.000127162,0.000143175,0.000153536,0.000171433,0.00018933,0.000200633,
0.00021853,0.000232659,0.000232659,0.000232659,0.000224182,0.000210995,0.000194982,0.000178969,0.000162014,
0.000147885,0.00012622,0.000112091,9.04262e-05,7.53552e-05,5.93422e-05,4.80389e-05,3.95615e-05,2.73163e-05,
2.54324e-05,2.16646e-05,2.07227e-05,2.07227e-05,1.88388e-05,1.69549e-05,1.41291e-05,1.13033e-05,1.13033e-05,
1.13033e-05,8.47746e-06,7.53552e-06,6.59358e-06,6.59358e-06,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,
9.4194e-06,1.13033e-05,1.41291e-05,1.88388e-05,2.07227e-05,2.54324e-05,2.73163e-05,3.86195e-05,4.23873e-05,
4.80389e-05,5.46325e-05,5.93422e-05,6.311e-05,6.87616e-05,7.53552e-05,7.62971e-05,7.91229e-05,8.00649e-05,
8.28907e-05,8.38326e-05,8.47746e-05,8.47746e-05,8.47746e-05,8.47746e-05,8.47746e-05,8.28907e-05,8.19488e-05,
8.00649e-05,8.00649e-05,8.00649e-05,8.28907e-05,8.47746e-05,8.85423e-05,9.04262e-05,9.3252e-05,9.60779e-05,
9.98456e-05,0.000101729,0.000102671,0.000101729,9.98456e-05,9.60779e-05,9.13682e-05,8.28907e-05,7.62971e-05,
7.15874e-05,6.40519e-05,5.84003e-05,5.18067e-05,4.80389e-05,4.42712e-05,4.23873e-05,4.14454e-05,3.95615e-05,
2.63743e-05,2.54324e-05,2.07227e-05,1.88388e-05,1.41291e-05,1.13033e-05,1.03613e-05,6.59358e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,
3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,
1.13033e-05,1.41291e-05,2.07227e-05,2.54324e-05,3.01421e-05,4.23873e-05,5.08647e-05,6.2168e-05,6.87616e-05,
7.72391e-05,8.85423e-05,0.000102671,0.000112091,0.00012151,0.000128104,0.000138465,0.000149768,0.000153536,
0.000162014,0.000169549,0.000171433,0.000170491,0.000164839,0.000157304,0.000149768,0.000136581,0.000123394,
0.000117742,0.000101729,8.00649e-05,6.78197e-05,5.74583e-05,4.33292e-05,3.01421e-05,2.54324e-05,2.07227e-05,
1.78969e-05,1.5071e-05,1.13033e-05,1.13033e-05,9.4194e-06,6.59358e-06,6.59358e-06,5.65164e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,
6.59358e-06,1.13033e-05,1.13033e-05,1.5071e-05,1.97807e-05,2.16646e-05,2.63743e-05,2.82582e-05,3.76776e-05,
4.23873e-05,4.42712e-05,4.99228e-05,5.27486e-05,5.84003e-05,5.93422e-05,6.311e-05,6.49938e-05,6.59358e-05,
6.68777e-05,6.87616e-05,6.87616e-05,6.87616e-05,6.87616e-05,6.87616e-05,6.87616e-05,6.78197e-05,6.68777e-05,
6.59358e-05,6.49938e-05,6.49938e-05,6.59358e-05,6.59358e-05,6.68777e-05,6.87616e-05,6.87616e-05,7.06455e-05,
7.34713e-05,7.53552e-05,7.53552e-05,7.53552e-05,7.15874e-05,6.87616e-05,6.59358e-05,6.311e-05,5.84003e-05,
5.18067e-05,4.80389e-05,4.33292e-05,4.14454e-05,3.95615e-05,3.67357e-05,3.1084e-05,2.82582e-05,2.73163e-05,
2.16646e-05,2.07227e-05,1.78969e-05,1.31872e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,1.88388e-06,1.88388e-06,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,1.13033e-05,1.5071e-05,2.07227e-05,2.73163e-05,
4.05034e-05,4.80389e-05,5.84003e-05,6.59358e-05,7.53552e-05,7.91229e-05,8.76004e-05,9.60779e-05,0.000105497,
0.000111149,0.000118684,0.000120568,0.000123394,0.000123394,0.000125278,0.000125278,0.000123394,0.000123394,
0.000118684,0.000113033,0.000105497,9.51359e-05,8.19488e-05,7.53552e-05,6.311e-05,5.27486e-05,4.23873e-05,
2.82582e-05,2.54324e-05,1.97807e-05,1.41291e-05,1.13033e-05,8.47746e-06,6.59358e-06,5.65164e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.31872e-05,1.69549e-05,2.07227e-05,
2.16646e-05,2.63743e-05,2.73163e-05,3.39098e-05,4.05034e-05,4.23873e-05,4.33292e-05,4.80389e-05,4.99228e-05,
5.08647e-05,5.46325e-05,5.55744e-05,5.84003e-05,5.84003e-05,5.84003e-05,5.84003e-05,5.84003e-05,5.84003e-05,
5.84003e-05,5.65164e-05,5.55744e-05,5.27486e-05,5.08647e-05,5.08647e-05,5.08647e-05,5.08647e-05,5.08647e-05,
5.18067e-05,5.27486e-05,5.36906e-05,5.55744e-05,5.55744e-05,5.55744e-05,5.55744e-05,5.27486e-05,5.08647e-05,
4.99228e-05,4.6155e-05,4.23873e-05,4.05034e-05,3.67357e-05,3.01421e-05,2.82582e-05,2.73163e-05,2.73163e-05,
2.73163e-05,2.63743e-05,2.54324e-05,1.78969e-05,1.5071e-05,1.13033e-05,1.13033e-05,6.59358e-06,5.65164e-06,
5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,3.76776e-06,
3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,3.76776e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,
4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,8.47746e-06,1.41291e-05,2.07227e-05,2.73163e-05,4.05034e-05,
4.80389e-05,5.74583e-05,6.311e-05,6.97035e-05,7.62971e-05,8.00649e-05,8.47746e-05,8.85423e-05,9.3252e-05,
9.60779e-05,0.000100788,0.000102671,0.000102671,0.000102671,9.89037e-05,9.3252e-05,8.85423e-05,8.28907e-05,
7.8181e-05,7.62971e-05,6.87616e-05,6.311e-05,5.55744e-05,4.80389e-05,4.05034e-05,2.73163e-05,2.35485e-05,
1.88388e-05,1.31872e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,3.76776e-06,3.76776e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,8.47746e-06,1.13033e-05,1.31872e-05,1.78969e-05,2.07227e-05,
2.16646e-05,2.54324e-05,2.73163e-05,2.82582e-05,3.39098e-05,3.95615e-05,4.05034e-05,4.23873e-05,4.23873e-05,
4.33292e-05,4.52131e-05,4.7097e-05,4.80389e-05,4.80389e-05,4.7097e-05,4.7097e-05,4.52131e-05,4.42712e-05,
4.33292e-05,4.33292e-05,4.23873e-05,4.14454e-05,4.05034e-05,4.05034e-05,4.05034e-05,4.05034e-05,4.05034e-05,
4.05034e-05,4.14454e-05,4.14454e-05,4.14454e-05,4.14454e-05,4.05034e-05,4.05034e-05,3.95615e-05,3.29679e-05,
2.92001e-05,2.73163e-05,2.73163e-05,2.63743e-05,2.54324e-05,2.54324e-05,2.54324e-05,2.35485e-05,2.16646e-05,
2.07227e-05,2.07227e-05,1.31872e-05,1.13033e-05,8.47746e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,
4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,
3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,3.76776e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,1.88388e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,1.88388e-06,
0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,
5.65164e-06,9.4194e-06,1.5071e-05,2.16646e-05,2.73163e-05,4.05034e-05,4.80389e-05,5.84003e-05,6.311e-05,
6.87616e-05,7.62971e-05,7.8181e-05,8.00649e-05,8.28907e-05,8.38326e-05,8.38326e-05,8.28907e-05,8.19488e-05,
8.00649e-05,7.8181e-05,7.62971e-05,7.53552e-05,6.87616e-05,6.49938e-05,6.2168e-05,5.84003e-05,5.08647e-05,
4.7097e-05,4.14454e-05,3.1084e-05,2.73163e-05,2.16646e-05,1.78969e-05,1.13033e-05,9.4194e-06,5.65164e-06,
5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,
5.65164e-06,5.65164e-06,6.59358e-06,8.47746e-06,1.13033e-05,1.31872e-05,1.69549e-05,1.97807e-05,2.07227e-05,
2.44904e-05,2.63743e-05,2.73163e-05,2.73163e-05,2.82582e-05,3.01421e-05,3.29679e-05,3.67357e-05,3.95615e-05,
4.05034e-05,4.05034e-05,4.05034e-05,4.05034e-05,3.95615e-05,3.67357e-05,3.57937e-05,3.1084e-05,3.01421e-05,
2.82582e-05,2.73163e-05,2.73163e-05,2.73163e-05,2.63743e-05,2.63743e-05,2.73163e-05,2.73163e-05,2.73163e-05,
2.73163e-05,2.73163e-05,2.73163e-05,2.73163e-05,2.73163e-05,2.63743e-05,2.54324e-05,2.35485e-05,2.16646e-05,
2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,1.88388e-05,1.78969e-05,1.5071e-05,
1.03613e-05,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,4.7097e-06,
4.7097e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.97807e-05,2.63743e-05,3.67357e-05,4.33292e-05,5.27486e-05,
6.12261e-05,6.59358e-05,7.44132e-05,7.62971e-05,7.91229e-05,8.00649e-05,8.10068e-05,8.00649e-05,8.00649e-05,
7.8181e-05,7.62971e-05,7.53552e-05,6.87616e-05,6.59358e-05,6.2168e-05,5.84003e-05,5.18067e-05,4.80389e-05,
4.33292e-05,4.05034e-05,3.01421e-05,2.73163e-05,2.35485e-05,2.07227e-05,1.5071e-05,1.13033e-05,8.47746e-06,
5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,
4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,7.53552e-06,1.13033e-05,1.13033e-05,
1.5071e-05,1.78969e-05,2.07227e-05,2.07227e-05,2.16646e-05,2.54324e-05,2.54324e-05,2.63743e-05,2.73163e-05,
2.73163e-05,2.73163e-05,2.73163e-05,2.73163e-05,2.73163e-05,2.73163e-05,2.73163e-05,2.73163e-05,2.63743e-05,
2.63743e-05,2.54324e-05,2.54324e-05,2.16646e-05,2.16646e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,
2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,1.97807e-05,
1.88388e-05,1.78969e-05,1.78969e-05,1.78969e-05,1.69549e-05,1.5071e-05,1.5071e-05,1.5071e-05,1.41291e-05,
1.22452e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,
2.82582e-06,2.82582e-06,1.88388e-06,1.88388e-06,0,0,0,0,0,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,2.82582e-06,
4.7097e-06,4.7097e-06,5.65164e-06,1.13033e-05,1.69549e-05,2.54324e-05,3.01421e-05,4.33292e-05,5.08647e-05,
6.02841e-05,6.59358e-05,7.53552e-05,7.62971e-05,7.91229e-05,8.00649e-05,8.19488e-05,8.10068e-05,8.00649e-05,
7.8181e-05,7.62971e-05,7.44132e-05,6.68777e-05,6.311e-05,5.93422e-05,5.46325e-05,4.80389e-05,4.23873e-05,
4.05034e-05,2.92001e-05,2.73163e-05,2.35485e-05,2.07227e-05,1.78969e-05,1.31872e-05,1.13033e-05,7.53552e-06,
5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,
1.13033e-05,1.13033e-05,1.31872e-05,1.5071e-05,1.78969e-05,1.97807e-05,2.07227e-05,2.07227e-05,2.07227e-05,
2.16646e-05,2.16646e-05,2.16646e-05,2.35485e-05,2.35485e-05,2.35485e-05,2.16646e-05,2.16646e-05,2.16646e-05,
2.07227e-05,2.07227e-05,2.07227e-05,1.97807e-05,1.88388e-05,1.78969e-05,1.78969e-05,1.69549e-05,1.69549e-05,
1.69549e-05,1.78969e-05,1.78969e-05,1.78969e-05,1.78969e-05,1.78969e-05,1.6013e-05,1.5071e-05,1.5071e-05,
1.41291e-05,1.41291e-05,1.31872e-05,1.31872e-05,1.31872e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,
1.13033e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,
2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,3.76776e-06,4.7097e-06,5.65164e-06,6.59358e-06,
1.41291e-05,2.16646e-05,2.82582e-05,4.23873e-05,5.18067e-05,6.2168e-05,6.87616e-05,7.62971e-05,8.00649e-05,
8.28907e-05,8.76004e-05,8.76004e-05,8.66585e-05,8.28907e-05,8.00649e-05,7.72391e-05,7.53552e-05,6.87616e-05,
6.40519e-05,5.93422e-05,5.27486e-05,4.80389e-05,4.23873e-05,3.67357e-05,2.73163e-05,2.54324e-05,2.07227e-05,
1.78969e-05,1.41291e-05,1.13033e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,
4.7097e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,1.88388e-06,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,
1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,
6.59358e-06,7.53552e-06,1.13033e-05,1.13033e-05,1.31872e-05,1.41291e-05,1.5071e-05,1.78969e-05,1.78969e-05,
1.88388e-05,1.88388e-05,1.97807e-05,1.97807e-05,1.97807e-05,1.97807e-05,1.97807e-05,1.97807e-05,1.88388e-05,
1.88388e-05,1.78969e-05,1.78969e-05,1.5071e-05,1.5071e-05,1.41291e-05,1.41291e-05,1.41291e-05,1.41291e-05,
1.41291e-05,1.41291e-05,1.41291e-05,1.31872e-05,1.31872e-05,1.31872e-05,1.13033e-05,1.13033e-05,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.03613e-05,8.47746e-06,
6.59358e-06,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,
2.82582e-06,9.4194e-07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,4.7097e-06,5.65164e-06,6.59358e-06,1.31872e-05,2.07227e-05,
2.73163e-05,4.23873e-05,5.27486e-05,6.311e-05,7.34713e-05,7.91229e-05,8.66585e-05,9.3252e-05,9.60779e-05,
9.60779e-05,9.51359e-05,9.3252e-05,8.76004e-05,8.00649e-05,7.62971e-05,7.53552e-05,6.78197e-05,6.311e-05,
5.84003e-05,4.99228e-05,4.33292e-05,3.76776e-05,2.73163e-05,2.54324e-05,2.07227e-05,1.5071e-05,1.22452e-05,
1.13033e-05,8.47746e-06,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,
2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,1.88388e-06,
1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,
7.53552e-06,1.13033e-05,1.13033e-05,1.13033e-05,1.31872e-05,1.31872e-05,1.41291e-05,1.41291e-05,1.5071e-05,
1.5071e-05,1.5071e-05,1.5071e-05,1.5071e-05,1.5071e-05,1.5071e-05,1.5071e-05,1.41291e-05,1.41291e-05,
1.41291e-05,1.31872e-05,1.31872e-05,1.31872e-05,1.31872e-05,1.31872e-05,1.22452e-05,1.22452e-05,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,9.4194e-06,8.47746e-06,
8.47746e-06,7.53552e-06,6.59358e-06,6.59358e-06,6.59358e-06,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,
4.7097e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,
4.7097e-06,5.65164e-06,1.13033e-05,2.07227e-05,2.73163e-05,4.23873e-05,5.18067e-05,6.311e-05,7.53552e-05,
8.19488e-05,9.3252e-05,0.000102671,0.000105497,0.000106439,0.000106439,0.000105497,9.98456e-05,9.3252e-05,
8.28907e-05,7.62971e-05,7.53552e-05,6.59358e-05,6.2168e-05,5.55744e-05,4.80389e-05,4.14454e-05,3.01421e-05,
2.63743e-05,2.07227e-05,1.78969e-05,1.31872e-05,1.13033e-05,8.47746e-06,6.59358e-06,5.65164e-06,5.65164e-06,
5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,
0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,
1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,
4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,7.53552e-06,9.4194e-06,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.22452e-05,1.31872e-05,1.31872e-05,
1.31872e-05,1.31872e-05,1.31872e-05,1.31872e-05,1.31872e-05,1.31872e-05,1.22452e-05,1.13033e-05,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,
9.4194e-06,8.47746e-06,7.53552e-06,6.59358e-06,6.59358e-06,6.59358e-06,6.59358e-06,5.65164e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,2.82582e-06,
1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,2.82582e-06,4.7097e-06,5.65164e-06,7.53552e-06,1.78969e-05,2.63743e-05,4.05034e-05,5.08647e-05,
6.311e-05,7.62971e-05,8.66585e-05,9.98456e-05,0.000107381,0.000113033,0.000117742,0.000117742,0.000115859,
0.000111149,0.000105497,9.60779e-05,8.76004e-05,7.8181e-05,7.25294e-05,6.59358e-05,5.93422e-05,5.18067e-05,
4.42712e-05,4.05034e-05,2.73163e-05,2.54324e-05,2.07227e-05,1.5071e-05,1.13033e-05,1.03613e-05,6.59358e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,9.4194e-07,0,0,0,0,0,1.88388e-06,1.88388e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,
4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,6.59358e-06,8.47746e-06,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,
1.22452e-05,1.22452e-05,1.22452e-05,1.22452e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,9.4194e-06,8.47746e-06,
6.59358e-06,6.59358e-06,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,
5.65164e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,
4.7097e-06,5.65164e-06,1.22452e-05,2.16646e-05,3.67357e-05,4.99228e-05,6.311e-05,7.62971e-05,8.85423e-05,
0.000102671,0.000112091,0.000118684,0.00012151,0.000123394,0.000123394,0.000120568,0.000118684,0.000111149,
0.000102671,8.85423e-05,7.91229e-05,7.15874e-05,6.311e-05,5.84003e-05,4.99228e-05,4.33292e-05,3.67357e-05,
2.73163e-05,2.16646e-05,1.88388e-05,1.41291e-05,1.13033e-05,8.47746e-06,6.59358e-06,5.65164e-06,5.65164e-06,
5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,
5.65164e-06,5.65164e-06,6.59358e-06,6.59358e-06,8.47746e-06,9.4194e-06,1.13033e-05,1.13033e-05,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.22452e-05,1.22452e-05,1.22452e-05,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.03613e-05,8.47746e-06,6.59358e-06,6.59358e-06,6.59358e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,
2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,5.65164e-06,8.47746e-06,1.88388e-05,2.73163e-05,
4.33292e-05,5.93422e-05,7.34713e-05,8.47746e-05,0.000102671,0.000115859,0.00012151,0.000123394,0.000128104,
0.000129988,0.000127162,0.000123394,0.00012151,0.000115859,0.000105497,9.3252e-05,7.91229e-05,7.06455e-05,
6.311e-05,5.55744e-05,4.80389e-05,4.14454e-05,3.1084e-05,2.63743e-05,2.16646e-05,1.78969e-05,1.31872e-05,
1.13033e-05,8.47746e-06,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,
4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,6.59358e-06,8.47746e-06,
9.4194e-06,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.22452e-05,
1.22452e-05,1.22452e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,9.4194e-06,
6.59358e-06,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,4.7097e-06,5.65164e-06,
1.13033e-05,2.16646e-05,3.76776e-05,5.08647e-05,6.59358e-05,8.00649e-05,9.98456e-05,0.000113033,0.00012151,
0.000127162,0.000133755,0.000134697,0.000134697,0.000133755,0.000129988,0.000123394,0.000118684,0.000107381,
9.3252e-05,7.91229e-05,6.87616e-05,6.12261e-05,5.18067e-05,4.52131e-05,4.05034e-05,2.82582e-05,2.54324e-05,
2.07227e-05,1.78969e-05,1.31872e-05,1.13033e-05,8.47746e-06,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,
4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,
4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,6.59358e-06,
8.47746e-06,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,
1.22452e-05,1.22452e-05,1.22452e-05,1.22452e-05,1.22452e-05,1.31872e-05,1.31872e-05,1.31872e-05,1.31872e-05,
1.31872e-05,1.31872e-05,1.31872e-05,1.31872e-05,1.31872e-05,1.22452e-05,1.13033e-05,1.13033e-05,1.13033e-05,
1.03613e-05,7.53552e-06,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,4.7097e-06,6.59358e-06,
1.5071e-05,2.63743e-05,4.23873e-05,5.84003e-05,7.53552e-05,8.85423e-05,0.000107381,0.000119626,0.00012622,
0.000133755,0.000138465,0.000143175,0.000142233,0.000137523,0.000133755,0.000124336,0.000118684,0.000109265,
9.3252e-05,7.91229e-05,6.87616e-05,5.93422e-05,4.99228e-05,4.33292e-05,3.67357e-05,2.73163e-05,2.54324e-05,
2.07227e-05,1.78969e-05,1.31872e-05,1.13033e-05,8.47746e-06,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,
4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,1.88388e-06,9.4194e-07,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,
4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,6.59358e-06,7.53552e-06,9.4194e-06,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.22452e-05,
1.31872e-05,1.31872e-05,1.31872e-05,1.31872e-05,1.31872e-05,1.41291e-05,1.41291e-05,1.5071e-05,1.5071e-05,
1.5071e-05,1.5071e-05,1.5071e-05,1.41291e-05,1.41291e-05,1.31872e-05,1.13033e-05,1.13033e-05,1.13033e-05,
9.4194e-06,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,3.76776e-06,5.65164e-06,8.47746e-06,
1.97807e-05,2.82582e-05,4.7097e-05,6.311e-05,7.62971e-05,9.60779e-05,0.000113033,0.000123394,0.000129988,
0.000137523,0.000144117,0.000147885,0.000146001,0.000141291,0.000134697,0.00012622,0.000119626,0.000109265,
9.3252e-05,7.72391e-05,6.59358e-05,5.84003e-05,4.80389e-05,4.14454e-05,3.1084e-05,2.73163e-05,2.35485e-05,
2.07227e-05,1.69549e-05,1.31872e-05,1.13033e-05,9.4194e-06,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,
4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,6.59358e-06,8.47746e-06,1.13033e-05,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.22452e-05,1.31872e-05,1.31872e-05,
1.31872e-05,1.41291e-05,1.41291e-05,1.5071e-05,1.5071e-05,1.69549e-05,1.78969e-05,1.78969e-05,1.78969e-05,
1.78969e-05,1.78969e-05,1.78969e-05,1.5071e-05,1.5071e-05,1.31872e-05,1.13033e-05,1.13033e-05,1.13033e-05,
8.47746e-06,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,3.76776e-06,
2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,4.7097e-06,5.65164e-06,1.13033e-05,2.07227e-05,3.1084e-05,4.99228e-05,
6.49938e-05,8.00649e-05,0.000101729,0.000117742,0.000123394,0.000133755,0.000142233,0.000147885,0.000148826,
0.000147885,0.000141291,0.000134697,0.000125278,0.000118684,0.000106439,8.94843e-05,7.62971e-05,6.40519e-05,
5.55744e-05,4.7097e-05,4.05034e-05,2.92001e-05,2.63743e-05,2.16646e-05,2.07227e-05,1.69549e-05,1.31872e-05,
1.13033e-05,1.03613e-05,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,
2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,
2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,
6.59358e-06,6.59358e-06,8.47746e-06,9.4194e-06,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.31872e-05,1.31872e-05,1.41291e-05,1.5071e-05,1.5071e-05,1.69549e-05,
1.78969e-05,1.78969e-05,1.88388e-05,1.97807e-05,1.97807e-05,1.97807e-05,1.97807e-05,1.97807e-05,1.88388e-05,
1.88388e-05,1.78969e-05,1.5071e-05,1.41291e-05,1.13033e-05,1.13033e-05,9.4194e-06,6.59358e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,2.82582e-06,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,
4.7097e-06,5.65164e-06,1.13033e-05,2.16646e-05,3.57937e-05,4.99228e-05,6.59358e-05,8.00649e-05,0.000102671,
0.000117742,0.000123394,0.000133755,0.000141291,0.000146001,0.000147885,0.000146001,0.000138465,0.00013093,
0.000123394,0.000117742,0.000105497,8.47746e-05,7.53552e-05,6.2168e-05,5.08647e-05,4.33292e-05,3.86195e-05,
2.73163e-05,2.54324e-05,2.16646e-05,1.97807e-05,1.69549e-05,1.31872e-05,1.13033e-05,1.13033e-05,6.59358e-06,
5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,2.82582e-06,4.7097e-06,
4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,6.59358e-06,7.53552e-06,
9.4194e-06,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,
1.31872e-05,1.31872e-05,1.41291e-05,1.5071e-05,1.69549e-05,1.78969e-05,1.88388e-05,1.97807e-05,2.07227e-05,
2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,2.07227e-05,1.97807e-05,
1.78969e-05,1.5071e-05,1.41291e-05,1.13033e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,
4.7097e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,3.76776e-06,4.7097e-06,
5.65164e-06,1.13033e-05,2.16646e-05,3.67357e-05,4.99228e-05,6.49938e-05,7.91229e-05,9.98456e-05,0.000115859,
0.000123394,0.000129988,0.000136581,0.000141291,0.000143175,0.000139407,0.000134697,0.000127162,0.00012151,
0.000111149,9.79617e-05,8.00649e-05,6.87616e-05,5.93422e-05,4.89809e-05,4.23873e-05,3.2026e-05,2.73163e-05,
2.54324e-05,2.07227e-05,1.97807e-05,1.69549e-05,1.31872e-05,1.13033e-05,1.13033e-05,8.47746e-06,6.59358e-06,
5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,4.7097e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,6.59358e-06,6.59358e-06,8.47746e-06,9.4194e-06,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.31872e-05,1.41291e-05,
1.5071e-05,1.5071e-05,1.78969e-05,1.88388e-05,1.97807e-05,2.07227e-05,2.07227e-05,2.16646e-05,2.16646e-05,
2.16646e-05,2.35485e-05,2.54324e-05,2.54324e-05,2.35485e-05,2.16646e-05,2.16646e-05,2.07227e-05,1.97807e-05,
1.78969e-05,1.5071e-05,1.22452e-05,1.13033e-05,6.59358e-06,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,
4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,4.7097e-06,5.65164e-06,5.65164e-06,
1.22452e-05,2.16646e-05,3.2026e-05,4.80389e-05,6.311e-05,7.62971e-05,9.3252e-05,0.000110207,0.000120568,
0.000125278,0.000129988,0.000134697,0.000134697,0.000133755,0.000128104,0.000123394,0.000117742,0.000105497,
8.85423e-05,7.62971e-05,6.49938e-05,5.55744e-05,4.42712e-05,4.05034e-05,2.92001e-05,2.73163e-05,2.54324e-05,
2.07227e-05,1.97807e-05,1.69549e-05,1.41291e-05,1.13033e-05,1.13033e-05,8.47746e-06,6.59358e-06,5.65164e-06,
5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,6.59358e-06,6.59358e-06,8.47746e-06,9.4194e-06,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.31872e-05,1.41291e-05,1.5071e-05,
1.78969e-05,1.78969e-05,1.97807e-05,2.07227e-05,2.07227e-05,2.16646e-05,2.35485e-05,2.54324e-05,2.54324e-05,
2.63743e-05,2.63743e-05,2.63743e-05,2.63743e-05,2.63743e-05,2.54324e-05,2.54324e-05,2.16646e-05,2.07227e-05,
1.97807e-05,1.5071e-05,1.31872e-05,1.13033e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,
4.7097e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,
1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,5.65164e-06,6.59358e-06,
1.13033e-05,2.07227e-05,2.82582e-05,4.42712e-05,5.93422e-05,7.34713e-05,8.47746e-05,0.000102671,0.000113975,
0.000120568,0.000123394,0.00012622,0.000127162,0.000123394,0.000122452,0.000118684,0.000109265,9.60779e-05,
8.00649e-05,6.87616e-05,5.93422e-05,4.99228e-05,4.23873e-05,3.67357e-05,2.73163e-05,2.63743e-05,2.16646e-05,
2.07227e-05,1.88388e-05,1.69549e-05,1.41291e-05,1.13033e-05,1.13033e-05,8.47746e-06,6.59358e-06,5.65164e-06,
5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,6.59358e-06,7.53552e-06,8.47746e-06,9.4194e-06,1.03613e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.31872e-05,1.41291e-05,1.5071e-05,
1.78969e-05,1.88388e-05,1.97807e-05,2.07227e-05,2.16646e-05,2.35485e-05,2.54324e-05,2.63743e-05,2.73163e-05,
2.73163e-05,2.73163e-05,2.73163e-05,2.73163e-05,2.73163e-05,2.73163e-05,2.73163e-05,2.63743e-05,2.54324e-05,
2.16646e-05,1.97807e-05,1.69549e-05,1.31872e-05,1.13033e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,
4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,5.65164e-06,
6.59358e-06,1.13033e-05,2.07227e-05,2.73163e-05,4.23873e-05,5.55744e-05,6.59358e-05,7.62971e-05,9.23101e-05,
0.000105497,0.000112091,0.000118684,0.000120568,0.000120568,0.000118684,0.000115859,0.000107381,9.60779e-05,
8.28907e-05,7.53552e-05,6.311e-05,5.46325e-05,4.42712e-05,4.05034e-05,2.92001e-05,2.73163e-05,2.54324e-05,
2.16646e-05,2.07227e-05,1.88388e-05,1.69549e-05,1.41291e-05,1.22452e-05,1.13033e-05,8.47746e-06,6.59358e-06,
5.65164e-06,5.65164e-06,4.7097e-06,3.76776e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,4.7097e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,6.59358e-06,8.47746e-06,9.4194e-06,9.4194e-06,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.22452e-05,1.31872e-05,
1.5071e-05,1.78969e-05,1.88388e-05,2.07227e-05,2.07227e-05,2.16646e-05,2.54324e-05,2.63743e-05,2.73163e-05,
2.73163e-05,2.82582e-05,3.01421e-05,3.1084e-05,3.1084e-05,3.1084e-05,3.01421e-05,2.82582e-05,2.73163e-05,
2.73163e-05,2.54324e-05,2.16646e-05,2.07227e-05,1.69549e-05,1.5071e-05,1.13033e-05,8.47746e-06,5.65164e-06,
5.65164e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,
5.65164e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.88388e-05,2.54324e-05,3.95615e-05,4.80389e-05,5.93422e-05,
6.87616e-05,7.91229e-05,9.04262e-05,0.000101729,0.000106439,0.000110207,0.000110207,0.000106439,0.000102671,
9.3252e-05,8.19488e-05,7.62971e-05,6.59358e-05,5.84003e-05,4.80389e-05,4.14454e-05,3.2026e-05,2.73163e-05,
2.54324e-05,2.35485e-05,2.07227e-05,2.07227e-05,1.88388e-05,1.69549e-05,1.41291e-05,1.13033e-05,1.13033e-05,
8.47746e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,3.76776e-06,2.82582e-06,1.88388e-06,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,
4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,6.59358e-06,7.53552e-06,8.47746e-06,
9.4194e-06,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,
1.13033e-05,1.31872e-05,1.5071e-05,1.78969e-05,1.88388e-05,2.07227e-05,2.07227e-05,2.35485e-05,2.54324e-05,
2.73163e-05,2.73163e-05,3.01421e-05,3.39098e-05,3.76776e-05,4.05034e-05,4.05034e-05,4.05034e-05,4.05034e-05,
3.67357e-05,3.1084e-05,2.82582e-05,2.73163e-05,2.54324e-05,2.16646e-05,1.97807e-05,1.88388e-05,1.41291e-05,
1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,1.88388e-06,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,1.88388e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,7.53552e-06,1.13033e-05,1.78969e-05,
2.35485e-05,2.82582e-05,4.23873e-05,5.18067e-05,6.2168e-05,7.06455e-05,7.72391e-05,8.38326e-05,9.04262e-05,
9.3252e-05,9.3252e-05,9.3252e-05,8.66585e-05,7.91229e-05,7.53552e-05,6.59358e-05,5.84003e-05,4.99228e-05,
4.23873e-05,3.76776e-05,2.82582e-05,2.63743e-05,2.54324e-05,2.16646e-05,2.07227e-05,1.97807e-05,1.78969e-05,
1.5071e-05,1.41291e-05,1.13033e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,
2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,
2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,
6.59358e-06,7.53552e-06,9.4194e-06,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.31872e-05,1.41291e-05,1.78969e-05,1.88388e-05,
2.07227e-05,2.16646e-05,2.54324e-05,2.73163e-05,2.73163e-05,3.01421e-05,3.67357e-05,4.05034e-05,4.14454e-05,
4.23873e-05,4.33292e-05,4.33292e-05,4.23873e-05,4.23873e-05,4.05034e-05,3.76776e-05,3.01421e-05,2.73163e-05,
2.54324e-05,2.07227e-05,2.07227e-05,1.78969e-05,1.31872e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,
4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,
5.65164e-06,6.59358e-06,1.13033e-05,1.22452e-05,1.78969e-05,2.16646e-05,2.73163e-05,3.95615e-05,4.52131e-05,
5.55744e-05,6.2168e-05,6.78197e-05,7.53552e-05,7.62971e-05,7.8181e-05,7.8181e-05,7.62971e-05,7.53552e-05,
6.87616e-05,6.311e-05,5.84003e-05,4.99228e-05,4.33292e-05,4.05034e-05,2.92001e-05,2.73163e-05,2.54324e-05,
2.16646e-05,2.07227e-05,2.07227e-05,1.88388e-05,1.78969e-05,1.5071e-05,1.31872e-05,1.13033e-05,1.13033e-05,
6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,
4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,8.47746e-06,1.03613e-05,1.13033e-05,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,
1.13033e-05,1.31872e-05,1.5071e-05,1.78969e-05,1.97807e-05,2.07227e-05,2.54324e-05,2.63743e-05,2.73163e-05,
3.1084e-05,4.05034e-05,4.23873e-05,4.33292e-05,4.7097e-05,4.80389e-05,4.99228e-05,4.99228e-05,4.99228e-05,
4.80389e-05,4.52131e-05,4.23873e-05,4.05034e-05,3.1084e-05,2.73163e-05,2.54324e-05,2.54324e-05,2.07227e-05,
1.78969e-05,1.41291e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,
2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,9.4194e-06,1.13033e-05,
1.41291e-05,1.88388e-05,2.07227e-05,2.63743e-05,3.01421e-05,4.14454e-05,4.80389e-05,5.36906e-05,5.93422e-05,
6.311e-05,6.59358e-05,6.68777e-05,6.68777e-05,6.59358e-05,6.311e-05,5.93422e-05,5.55744e-05,4.99228e-05,
4.33292e-05,4.05034e-05,3.1084e-05,2.73163e-05,2.63743e-05,2.54324e-05,2.16646e-05,2.07227e-05,2.07227e-05,
1.88388e-05,1.78969e-05,1.41291e-05,1.22452e-05,1.13033e-05,8.47746e-06,6.59358e-06,5.65164e-06,5.65164e-06,
4.7097e-06,3.76776e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,
6.59358e-06,8.47746e-06,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.22452e-05,1.13033e-05,1.13033e-05,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.31872e-05,1.41291e-05,1.78969e-05,
1.97807e-05,2.07227e-05,2.54324e-05,2.63743e-05,2.73163e-05,3.57937e-05,4.14454e-05,4.33292e-05,4.80389e-05,
5.08647e-05,5.55744e-05,5.84003e-05,5.93422e-05,5.93422e-05,5.93422e-05,5.84003e-05,5.36906e-05,4.99228e-05,
4.42712e-05,4.14454e-05,3.48518e-05,2.73163e-05,3.1084e-05,2.73163e-05,2.35485e-05,2.07227e-05,1.5071e-05,
1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,
2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,
4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.13033e-05,1.41291e-05,1.78969e-05,
2.07227e-05,2.16646e-05,2.63743e-05,2.73163e-05,3.67357e-05,4.23873e-05,4.7097e-05,4.99228e-05,5.55744e-05,
5.84003e-05,5.93422e-05,5.93422e-05,5.84003e-05,5.55744e-05,5.08647e-05,4.80389e-05,4.33292e-05,4.05034e-05,
3.2026e-05,2.73163e-05,2.73163e-05,2.54324e-05,2.16646e-05,2.07227e-05,2.07227e-05,1.97807e-05,1.78969e-05,
1.5071e-05,1.31872e-05,1.13033e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,
2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,
2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,8.47746e-06,
1.13033e-05,1.13033e-05,1.31872e-05,1.41291e-05,1.5071e-05,1.5071e-05,1.5071e-05,1.5071e-05,1.41291e-05,
1.41291e-05,1.31872e-05,1.31872e-05,1.31872e-05,1.41291e-05,1.5071e-05,1.78969e-05,2.07227e-05,2.16646e-05,
2.54324e-05,2.73163e-05,3.01421e-05,4.05034e-05,4.33292e-05,4.80389e-05,5.27486e-05,5.93422e-05,6.311e-05,
6.59358e-05,6.87616e-05,7.15874e-05,7.15874e-05,6.87616e-05,6.68777e-05,6.40519e-05,6.12261e-05,5.65164e-05,
4.99228e-05,4.33292e-05,4.05034e-05,4.80389e-05,4.14454e-05,3.1084e-05,2.73163e-05,2.16646e-05,1.88388e-05,
1.31872e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,2.82582e-06,
2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,
4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,9.4194e-06,1.13033e-05,1.31872e-05,1.69549e-05,1.97807e-05,
2.07227e-05,2.16646e-05,2.54324e-05,2.73163e-05,2.82582e-05,3.2026e-05,4.05034e-05,4.23873e-05,4.42712e-05,
4.80389e-05,4.99228e-05,4.99228e-05,4.99228e-05,4.99228e-05,4.80389e-05,4.42712e-05,4.23873e-05,4.05034e-05,
3.57937e-05,2.82582e-05,2.73163e-05,2.63743e-05,2.54324e-05,2.16646e-05,2.07227e-05,2.07227e-05,1.88388e-05,
1.69549e-05,1.41291e-05,1.22452e-05,1.13033e-05,9.4194e-06,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,
4.7097e-06,2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,8.47746e-06,
1.13033e-05,1.31872e-05,1.5071e-05,1.78969e-05,1.88388e-05,1.97807e-05,2.07227e-05,2.07227e-05,1.97807e-05,
1.97807e-05,1.88388e-05,1.78969e-05,1.78969e-05,1.78969e-05,1.97807e-05,2.07227e-05,2.16646e-05,2.54324e-05,
2.73163e-05,3.01421e-05,3.95615e-05,4.23873e-05,4.80389e-05,5.46325e-05,6.02841e-05,6.59358e-05,7.15874e-05,
7.62971e-05,8.00649e-05,8.66585e-05,8.85423e-05,8.85423e-05,8.76004e-05,8.28907e-05,8.00649e-05,7.62971e-05,
7.34713e-05,6.59358e-05,6.02841e-05,5.27486e-05,6.68777e-05,6.02841e-05,5.18067e-05,4.33292e-05,3.76776e-05,
2.73163e-05,2.16646e-05,1.88388e-05,1.31872e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,
4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.31872e-05,
1.5071e-05,1.88388e-05,2.07227e-05,2.16646e-05,2.54324e-05,2.63743e-05,2.73163e-05,2.82582e-05,3.1084e-05,
3.67357e-05,4.05034e-05,4.05034e-05,4.23873e-05,4.33292e-05,4.33292e-05,4.42712e-05,4.42712e-05,4.33292e-05,
4.33292e-05,4.23873e-05,4.05034e-05,3.67357e-05,3.01421e-05,2.73163e-05,2.73163e-05,2.54324e-05,2.44904e-05,
2.16646e-05,2.07227e-05,1.97807e-05,1.78969e-05,1.5071e-05,1.31872e-05,1.13033e-05,1.13033e-05,7.53552e-06,
5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,3.76776e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,4.7097e-06,4.7097e-06,
5.65164e-06,5.65164e-06,5.65164e-06,8.47746e-06,1.13033e-05,1.31872e-05,1.78969e-05,1.97807e-05,2.07227e-05,
2.16646e-05,2.54324e-05,2.54324e-05,2.54324e-05,2.54324e-05,2.54324e-05,2.16646e-05,2.16646e-05,2.35485e-05,
2.54324e-05,2.63743e-05,2.73163e-05,2.92001e-05,3.67357e-05,4.14454e-05,4.33292e-05,4.80389e-05,5.55744e-05,
6.12261e-05,6.68777e-05,7.53552e-05,8.00649e-05,9.23101e-05,0.000102671,0.000109265,0.000113033,0.000115859,
0.000115859,0.000113033,0.000111149,0.000109265,0.000105497,9.98456e-05,8.94843e-05,8.00649e-05,7.62971e-05,
0.000101729,8.85423e-05,7.62971e-05,6.68777e-05,5.84003e-05,4.80389e-05,4.14454e-05,2.82582e-05,2.54324e-05,
1.97807e-05,1.41291e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,
2.82582e-06,2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,
5.65164e-06,5.65164e-06,5.65164e-06,9.4194e-06,1.13033e-05,1.5071e-05,1.88388e-05,2.07227e-05,2.16646e-05,
2.54324e-05,2.73163e-05,2.73163e-05,2.82582e-05,3.1084e-05,3.67357e-05,3.95615e-05,4.05034e-05,4.05034e-05,
4.14454e-05,4.14454e-05,4.23873e-05,4.23873e-05,4.23873e-05,4.23873e-05,4.23873e-05,4.14454e-05,4.05034e-05,
3.86195e-05,3.1084e-05,2.82582e-05,2.73163e-05,2.63743e-05,2.54324e-05,2.16646e-05,2.07227e-05,2.07227e-05,
1.88388e-05,1.78969e-05,1.41291e-05,1.31872e-05,1.13033e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,
4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,5.65164e-06,
5.65164e-06,6.59358e-06,1.13033e-05,1.41291e-05,1.88388e-05,2.07227e-05,2.54324e-05,2.63743e-05,2.73163e-05,
2.82582e-05,2.82582e-05,2.92001e-05,2.82582e-05,2.82582e-05,2.82582e-05,2.82582e-05,3.1084e-05,3.76776e-05,
4.14454e-05,4.33292e-05,4.80389e-05,5.08647e-05,5.74583e-05,6.2168e-05,6.59358e-05,7.53552e-05,7.8181e-05,
8.76004e-05,9.98456e-05,0.000111149,0.000120568,0.000125278,0.000133755,0.000136581,0.000138465,0.000137523,
0.000135639,0.000134697,0.000133755,0.000129988,0.00012622,0.000123394,0.000118684,0.000111149,0.000133755,
0.000123394,0.000117742,0.000105497,8.47746e-05,7.53552e-05,6.2168e-05,5.08647e-05,4.23873e-05,3.01421e-05,
2.54324e-05,2.07227e-05,1.5071e-05,1.13033e-05,8.47746e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,
4.7097e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.13033e-05,1.69549e-05,2.07227e-05,
2.16646e-05,2.54324e-05,2.73163e-05,2.73163e-05,3.01421e-05,3.57937e-05,3.95615e-05,4.05034e-05,4.14454e-05,
4.23873e-05,4.23873e-05,4.23873e-05,4.23873e-05,4.23873e-05,4.23873e-05,4.23873e-05,4.23873e-05,4.23873e-05,
4.23873e-05,4.14454e-05,4.05034e-05,3.67357e-05,3.01421e-05,2.73163e-05,2.73163e-05,2.63743e-05,2.54324e-05,
2.16646e-05,2.07227e-05,2.07227e-05,1.88388e-05,1.5071e-05,1.41291e-05,1.13033e-05,1.13033e-05,8.47746e-06,
6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,
4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.41291e-05,1.97807e-05,2.16646e-05,
2.63743e-05,2.82582e-05,3.29679e-05,4.05034e-05,4.14454e-05,4.23873e-05,4.23873e-05,4.23873e-05,4.23873e-05,
4.33292e-05,4.42712e-05,4.80389e-05,5.18067e-05,5.84003e-05,6.311e-05,6.59358e-05,7.34713e-05,7.62971e-05,
8.47746e-05,9.60779e-05,0.000105497,0.000113033,0.000120568,0.000128104,0.000143175,0.000153536,0.000162956,
0.000171433,0.000174259,0.000174259,0.000174259,0.000174259,0.000170491,0.000168607,0.000165781,0.000162014,
0.000159188,0.000152594,0.000147885,0.000174259,0.000162014,0.000151652,0.000137523,0.000123394,0.000111149,
9.3252e-05,7.62971e-05,6.311e-05,5.18067e-05,4.23873e-05,3.1084e-05,2.63743e-05,2.07227e-05,1.78969e-05,
1.13033e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,1.88388e-06,1.88388e-06,0,0,0,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.31872e-05,1.78969e-05,2.07227e-05,2.54324e-05,
2.73163e-05,2.82582e-05,3.1084e-05,3.95615e-05,4.05034e-05,4.23873e-05,4.23873e-05,4.33292e-05,4.42712e-05,
4.52131e-05,4.7097e-05,4.6155e-05,4.42712e-05,4.33292e-05,4.33292e-05,4.33292e-05,4.33292e-05,4.23873e-05,
4.23873e-05,4.05034e-05,4.05034e-05,3.57937e-05,3.01421e-05,2.73163e-05,2.73163e-05,2.54324e-05,2.35485e-05,
2.16646e-05,2.07227e-05,1.97807e-05,1.78969e-05,1.5071e-05,1.41291e-05,1.13033e-05,1.13033e-05,8.47746e-06,
6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,1.88388e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,
4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,1.13033e-05,1.41291e-05,2.07227e-05,2.54324e-05,2.73163e-05,
3.67357e-05,4.14454e-05,4.33292e-05,4.80389e-05,5.08647e-05,5.27486e-05,5.55744e-05,5.65164e-05,5.84003e-05,
5.93422e-05,6.311e-05,6.59358e-05,7.53552e-05,7.8181e-05,8.66585e-05,9.60779e-05,0.000105497,0.000115859,
0.000122452,0.000129988,0.000136581,0.000148826,0.000153536,0.000170491,0.00018462,0.000197807,0.000217588,
0.000227007,0.000232659,0.000232659,0.000227007,0.000219472,0.000217588,0.000214762,0.00021382,0.000210995,
0.000206285,0.000195923,0.00018933,0.000234543,0.000215704,0.000195923,0.000178969,0.000162014,0.000147885,
0.000125278,0.000112091,9.3252e-05,7.62971e-05,6.311e-05,5.08647e-05,4.23873e-05,3.1084e-05,2.63743e-05,
2.07227e-05,1.78969e-05,1.31872e-05,1.03613e-05,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,
3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,6.59358e-06,1.13033e-05,1.31872e-05,1.78969e-05,2.07227e-05,
2.54324e-05,2.73163e-05,3.01421e-05,3.95615e-05,4.14454e-05,4.23873e-05,4.42712e-05,4.80389e-05,4.80389e-05,
4.99228e-05,4.99228e-05,4.99228e-05,4.99228e-05,4.99228e-05,4.99228e-05,4.80389e-05,4.7097e-05,4.42712e-05,
4.33292e-05,4.33292e-05,4.23873e-05,4.14454e-05,4.05034e-05,3.57937e-05,2.92001e-05,2.73163e-05,2.63743e-05,
2.54324e-05,2.16646e-05,2.07227e-05,2.07227e-05,1.97807e-05,1.78969e-05,1.5071e-05,1.41291e-05,1.22452e-05,
1.13033e-05,9.4194e-06,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,
2.82582e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,
2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,3.76776e-06,
3.76776e-06,3.76776e-06,3.76776e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,
1.13033e-05,1.41291e-05,2.07227e-05,2.63743e-05,3.1084e-05,4.14454e-05,4.80389e-05,5.18067e-05,5.84003e-05,
6.2168e-05,6.40519e-05,6.59358e-05,6.87616e-05,7.15874e-05,7.62971e-05,7.8181e-05,8.38326e-05,9.3252e-05,
0.000105497,0.000115859,0.00012151,0.000128104,0.000138465,0.000151652,0.000159188,0.000170491,0.000177085,
0.00018933,0.000196865,0.000219472,0.000240195,0.000268453,0.000289176,0.000305188,0.000312724,0.000312724,
0.000307072,0.000303305,0.000293885,0.000287292,0.000284466,0.000282582,0.000275046,0.000268453,0.000250556,
0.000321201,0.000292943,0.000260917,0.000235485,0.000207227,0.00018462,0.000162014,0.000143175,0.000123394,
0.000106439,8.47746e-05,7.06455e-05,5.93422e-05,4.99228e-05,4.14454e-05,2.82582e-05,2.54324e-05,2.07227e-05,
1.78969e-05,1.13033e-05,7.53552e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,
3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,
6.59358e-06,1.13033e-05,1.31872e-05,1.78969e-05,2.07227e-05,2.54324e-05,2.73163e-05,3.29679e-05,4.05034e-05,
4.23873e-05,4.7097e-05,4.80389e-05,4.99228e-05,5.18067e-05,5.55744e-05,5.55744e-05,5.55744e-05,5.65164e-05,
5.55744e-05,5.55744e-05,5.27486e-05,5.08647e-05,4.99228e-05,4.80389e-05,4.7097e-05,4.33292e-05,4.23873e-05,
4.14454e-05,4.05034e-05,3.57937e-05,3.01421e-05,2.73163e-05,2.63743e-05,2.54324e-05,2.16646e-05,2.07227e-05,
2.07227e-05,1.97807e-05,1.88388e-05,1.78969e-05,1.5071e-05,1.41291e-05,1.13033e-05,1.13033e-05,9.4194e-06,
6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,1.88388e-06,
0,0,0,0,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,
5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,1.13033e-05,
1.5071e-05,2.07227e-05,2.73163e-05,3.95615e-05,4.52131e-05,5.27486e-05,6.12261e-05,6.59358e-05,7.53552e-05,
7.72391e-05,8.10068e-05,8.76004e-05,9.23101e-05,9.60779e-05,0.000102671,0.000110207,0.000118684,0.000123394,
0.000133755,0.000147885,0.000153536,0.000168607,0.000178969,0.000192156,0.000205343,0.000217588,0.000230775,
0.000237369,0.00025715,0.000287292,0.00032026,0.000359821,0.000398441,0.000447421,0.000478505,0.000487925,
0.00047097,0.000442712,0.000418221,0.000410686,0.000409744,0.000408802,0.000395615,0.000379602,0.000354169,
0.000492635,0.00040786,0.000354169,0.000314608,0.000272221,0.000235485,0.000200633,0.000177085,0.000153536,
0.000133755,0.000118684,9.98456e-05,7.91229e-05,6.68777e-05,5.84003e-05,4.7097e-05,4.05034e-05,2.73163e-05,
2.54324e-05,1.97807e-05,1.41291e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,3.76776e-06,3.76776e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,
9.4194e-06,1.13033e-05,1.78969e-05,2.07227e-05,2.54324e-05,2.73163e-05,3.48518e-05,4.14454e-05,4.33292e-05,
4.80389e-05,5.08647e-05,5.55744e-05,5.84003e-05,5.93422e-05,5.93422e-05,6.12261e-05,6.2168e-05,6.2168e-05,
6.02841e-05,5.93422e-05,5.84003e-05,5.55744e-05,5.27486e-05,4.99228e-05,4.80389e-05,4.7097e-05,4.33292e-05,
4.23873e-05,4.05034e-05,3.67357e-05,3.01421e-05,2.73163e-05,2.73163e-05,2.54324e-05,2.35485e-05,2.16646e-05,
2.07227e-05,2.07227e-05,2.07227e-05,1.97807e-05,1.88388e-05,1.78969e-05,1.5071e-05,1.41291e-05,1.13033e-05,
1.13033e-05,8.47746e-06,6.59358e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,2.82582e-06,2.82582e-06,
2.82582e-06,1.88388e-06,0,0,0,0,0,0,0,1.88388e-06,2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,9.4194e-06,
1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,7.53552e-06,6.59358e-06,6.59358e-06,6.59358e-06,
8.47746e-06,1.13033e-05,1.69549e-05,2.16646e-05,2.73163e-05,4.14454e-05,4.99228e-05,6.02841e-05,6.87616e-05,
7.72391e-05,8.85423e-05,9.98456e-05,0.000106439,0.000113033,0.000118684,0.000120568,0.000123394,0.000128104,
0.000135639,0.000148826,0.000157304,0.000171433,0.00018462,0.000195923,0.000215704,0.000233601,0.00024773,
0.000262801,0.000274104,0.000287292,0.000307072,0.000335331,0.000381486,0.000459667,0.000557628,0.000638635,
0.000732829,0.000792171,0.000809126,0.000804417,0.000780868,0.000746958,0.00074319,0.000742249,0.000725294,
0.000681022,0.000625448,0.000564222,0.000774274,0.000648997,0.000551977,0.00043235,0.000359821,0.000307072,
0.000255266,0.00021853,0.00018933,0.000164839,0.000146001,0.000123394,0.000111149,9.3252e-05,7.62971e-05,
6.311e-05,5.18067e-05,4.33292e-05,3.67357e-05,2.73163e-05,2.16646e-05,1.78969e-05,1.31872e-05,1.13033e-05,
6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,
4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,
5.65164e-06,6.59358e-06,8.47746e-06,1.13033e-05,1.5071e-05,2.07227e-05,2.54324e-05,2.73163e-05,3.2026e-05,
4.05034e-05,4.33292e-05,4.80389e-05,5.18067e-05,5.84003e-05,5.93422e-05,6.2168e-05,6.311e-05,6.49938e-05,
6.59358e-05,6.59358e-05,6.59358e-05,6.49938e-05,6.311e-05,6.311e-05,6.02841e-05,5.84003e-05,5.55744e-05,
5.08647e-05,4.99228e-05,4.80389e-05,4.33292e-05,4.23873e-05,4.05034e-05,3.29679e-05,2.82582e-05,2.73163e-05,
2.63743e-05,2.54324e-05,2.54324e-05,2.16646e-05,2.16646e-05,2.16646e-05,2.07227e-05,2.07227e-05,2.07227e-05,
2.07227e-05,1.97807e-05,1.78969e-05,1.5071e-05,1.31872e-05,1.13033e-05,9.4194e-06,6.59358e-06,5.65164e-06,
5.65164e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,1.88388e-06,0,0,1.88388e-06,
2.82582e-06,2.82582e-06,3.76776e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,
5.65164e-06,6.59358e-06,9.4194e-06,1.13033e-05,1.5071e-05,1.97807e-05,2.16646e-05,2.54324e-05,2.54324e-05,
2.54324e-05,2.54324e-05,2.16646e-05,2.07227e-05,1.88388e-05,1.78969e-05,1.78969e-05,1.88388e-05,2.07227e-05,
2.63743e-05,3.2026e-05,4.42712e-05,5.84003e-05,6.68777e-05,7.91229e-05,9.3252e-05,0.000109265,0.000118684,
0.000125278,0.000134697,0.000144117,0.000149768,0.000152594,0.000157304,0.000165781,0.000174259,0.000187446,
0.000196865,0.000217588,0.000233601,0.000250556,0.000275046,0.000303305,0.00032026,0.000338156,0.000350402,
0.000363589,0.000393731,0.000471912,0.000591538,0.000709281,0.000846804,0.000944766,0.00104555,0.00115859,
0.00123677,0.00127727,0.00130364,0.00131401,0.00131683,0.00128386,0.00121604,0.00108606,0.000965488,0.000882598,
0.00110584,0.000954185,0.000846804,0.000676313,0.000544441,0.000405034,0.000326853,0.000271279,0.000232659,
0.000195923,0.000174259,0.000153536,0.000135639,0.000122452,0.000106439,8.47746e-05,7.15874e-05,6.2168e-05,
4.99228e-05,4.23873e-05,3.1084e-05,2.63743e-05,2.07227e-05,1.78969e-05,1.31872e-05,1.13033e-05,7.53552e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,6.59358e-06,6.59358e-06,9.4194e-06,1.13033e-05,
1.41291e-05,1.88388e-05,2.16646e-05,2.63743e-05,3.01421e-05,4.05034e-05,4.33292e-05,4.80389e-05,5.27486e-05,
5.84003e-05,6.2168e-05,6.311e-05,6.59358e-05,6.87616e-05,6.87616e-05,7.15874e-05,7.34713e-05,7.34713e-05,
7.15874e-05,6.87616e-05,6.68777e-05,6.59358e-05,6.311e-05,6.02841e-05,5.84003e-05,5.55744e-05,5.08647e-05,
4.80389e-05,4.42712e-05,4.23873e-05,4.05034e-05,3.1084e-05,2.82582e-05,2.73163e-05,2.73163e-05,2.63743e-05,
2.63743e-05,2.54324e-05,2.54324e-05,2.54324e-05,2.54324e-05,2.54324e-05,2.54324e-05,2.54324e-05,2.54324e-05,
2.16646e-05,2.07227e-05,1.97807e-05,1.5071e-05,1.22452e-05,1.13033e-05,6.59358e-06,5.65164e-06,5.65164e-06,
4.7097e-06,4.7097e-06,4.7097e-06,3.76776e-06,2.82582e-06,2.82582e-06,2.82582e-06,2.82582e-06,3.76776e-06,
4.7097e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,7.53552e-06,1.03613e-05,1.13033e-05,1.13033e-05,
1.5071e-05,2.07227e-05,2.54324e-05,2.73163e-05,3.67357e-05,4.23873e-05,4.33292e-05,4.7097e-05,4.7097e-05,
4.33292e-05,4.23873e-05,3.95615e-05,3.01421e-05,2.82582e-05,2.82582e-05,3.1084e-05,4.05034e-05,4.52131e-05,
5.74583e-05,6.68777e-05,8.00649e-05,9.98456e-05,0.000115859,0.000123394,0.000137523,0.000151652,0.000161072,
0.000174259,0.00018462,0.000191214,0.000195923,0.000204401,0.000217588,0.000232659,0.000237369,0.000258091,
0.000275988,0.000305188,0.000333447,0.000361705,0.000389963,0.000422931,0.00046155,0.000494518,0.00053408,
0.000612261,0.000734713,0.000891075,0.00101353,0.00123677,0.00144117,0.00164086,0.00185939,0.00212031,
0.00237369,0.00264591,0.00283806,0.00284843,0.00268924,0.00236615,0.00199126,0.00159282,0.0013319,0.00177744,
0.00146754,0.00123206,0.00099563,0.000832675,0.000622622,0.000451189,0.00034475,0.000279756,0.000237369,
0.000211936,0.000190272,0.000171433,0.000153536,0.000137523,0.00012151,0.000105497,8.28907e-05,7.15874e-05,
6.02841e-05,4.99228e-05,4.14454e-05,3.01421e-05,2.63743e-05,2.07227e-05,1.88388e-05,1.41291e-05,1.13033e-05,
8.47746e-06,6.59358e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,5.65164e-06,6.59358e-06,
6.59358e-06,8.47746e-06,9.4194e-06,1.13033e-05,1.13033e-05,1.13033e-05,1.13033e-05,1.41291e-05,1.88388e-05,
2.07227e-05,2.54324e-05,2.73163e-05,3.76776e-05,4.23873e-05,4.80389e-05,5.08647e-05,5.84003e-05,6.2168e-05,
6.59358e-05,6.87616e-05,7.53552e-05,7.62971e-05,7.62971e-05,7.62971e-05,7.8181e-05,7.8181e-05,7.62971e-05,
7.62971e-05,7.62971e-05,7.44132e-05,6.87616e-05,6.59358e-05,6.311e-05,6.2168e-05,5.84003e-05,5.55744e-05,
4.99228e-05,4.7097e-05,4.23873e-05,4.05034e-05,3.67357e-05,3.1084e-05,2.82582e-05,2.82582e-05,2.73163e-05,
2.73163e-05,2.73163e-05,2.82582e-05,2.92001e-05,3.01421e-05,3.1084e-05,3.2026e-05,3.2026e-05,3.01421e-05,
2.82582e-05,2.73163e-05,2.54324e-05,2.07227e-05,1.78969e-05,1.41291e-05,1.13033e-05,7.53552e-06,5.65164e-06,
5.65164e-06,5.65164e-06,5.65164e-06,4.7097e-06,4.7097e-06,4.7097e-06,4.7097e-06,5.65164e-06,5.65164e-06,
6.59358e-06,1.13033e-05,1.13033e-05,1.41291e-05,1.69549e-05,1.78969e-05,2.07227e-05,2.16646e-05,2.73163e-05,
3.57937e-05,4.33292e-05,5.08647e-05,5.93422e-05,6.59358e-05,6.87616e-05,7.34713e-05,7.15874e-05,6.87616e-05,
6.49938e-05,6.12261e-05,5.84003e-05,5.55744e-05,5.55744e-05,5.93422e-05,6.59358e-05,7.62971e-05,9.3252e-05,
0.000112091,0.000123394,0.000138465,0.000152594,0.000168607,0.000178969,0.000192156,0.000207227,0.000224182,
0.000237369,0.000250556,0.000266569,0.000279756,0.000295769,0.000307072,0.00032026,0.00034475,0.00037866,
0.000421989,0.000493576,0.000556686,0.000610377,0.000638635,0.000680081,0.000734713,0.0008063,0.000917449,
0.0010691,0.00134038,0.00164651,0.00208828,0.00250933,0.00300196,0.00352474,0.00411345,0.00464847,0.0051185,
0.00542557,0.00544159,0.0051185,0.00460797,0.00394861,0.00309616,0.00231152,0.00342301,0.00259693,0.00200727,
0.00155608,0.00123206,0.00093252,0.000690442,0.000488867,0.000356995,0.000303305,0.000260917,0.000235485,
0.000215704,0.000194982,0.000177085,0.000159188,0.000138465,0.00012151,0.000105497,8.00649e-05,6.68777e-05,
5.84003e-05,4.80389e-05,4.14454e-05,3.01421e-05,2.63743e-05,2.16646e-05,1.88388e-05,1.41291e-05,1.13033e-05,
9.4194e-06,6.59358e-06,6.59358e-06,7.53552e-06,9.4194e-06,1.13033e-05,1.13033e-05,1.13033e-05,1.31872e-05,
1.31872e-05,1.41291e-05,1.41291e-05,1.5071e-05,1.78969e-05,1.97807e-05,2.16646e-05,2.54324e-05,2.73163e-05,
3.39098e-05,4.14454e-05,4.7097e-05,5.08647e-05,5.84003e-05,6.311e-05,6.78197e-05,7.53552e-05,7.62971e-05,
8.00649e-05,8.28907e-05,8.66585e-05,8.85423e-05,8.85423e-05,8.85423e-05,8.85423e-05,8.47746e-05,8.19488e-05,
8.00649e-05,7.62971e-05,7.62971e-05,7.53552e-05,6.87616e-05,6.59358e-05,6.311e-05,5.93422e-05,5.55744e-05,
4.99228e-05,4.7097e-05,4.23873e-05,4.14454e-05,4.05034e-05,3.95615e-05,4.05034e-05,4.05034e-05,4.05034e-05,
4.14454e-05,4.23873e-05,4.33292e-05,4.52131e-05,4.80389e-05,4.80389e-05,4.80389e-05,4.33292e-05,4.23873e-05,
3.95615e-05,2.82582e-05,2.63743e-05,2.16646e-05,1.97807e-05,1.5071e-05,1.22452e-05,1.13033e-05,1.13033e-05,
8.47746e-06,6.59358e-06,6.59358e-06,6.59358e-06,7.53552e-06,1.13033e-05,1.41291e-05,1.88388e-05,2.07227e-05,
2.54324e-05,2.63743e-05,2.73163e-05,2.73163e-05,2.82582e-05,4.05034e-05,4.7097e-05,5.84003e-05,6.59358e-05,
7.62971e-05,8.85423e-05,9.98456e-05,0.000105497,0.000109265,0.000109265,0.000105497,9.98456e-05,9.3252e-05,
8.85423e-05,8.94843e-05,9.3252e-05,0.000105497,0.000118684,0.000129988,0.000149768,0.000167665,0.00018462,
0.000195923,0.000216646,0.000232659,0.000239253,0.00025715,0.000275046,0.000305188,0.000326853,0.000354169,
0.000377718,0.000398441,0.000421989,0.000454957,0.000499228,0.000562338,0.000622622,0.000701745,0.000780868,
0.000837384,0.000894843,0.00093252,0.000973024,0.0010399,0.00120003,0.00142045,0.00176425,0.00227196,
0.00303399,0.00378189,0.00442994,0.00503561,0.00583908,0.0069939,0.00794055,0.00889568,0.0094486,0.00939302,
0.00876287,0.0078002,0.00662937,0.00521081,0.00430655,};
  const double linear_table_glycine[] = {0.486238,0.472763,0.456741,0.43921,0.417158,0.389891,0.358799,0.326403,0.293432,0.258532,0.224824,0.186733,
0.136891,0.110122,0.0926588,0.0797331,0.0691918,0.0596712,0.0514543,0.0422081,0.0339826,0.027524,0.0224978,
0.0184065,0.0151644,0.0124369,0.0104984,0.00905746,0.0079167,0.00689602,0.00589249,0.00524921,0.00443438,
0.00356809,0.00290765,0.00246164,0.00208424,0.00187839,0.00165539,0.00143238,0.00117507,0.00104641,0.000969217,
0.000857714,0.00078052,0.000746211,0.00066044,0.000634708,0.000591823,0.000574668,0.000574668,0.000574668,
0.000591823,0.000626131,0.000626131,0.000643285,0.00066044,0.000694748,0.00072048,0.000746211,0.000746211,
0.000754788,0.000763365,0.000763365,0.000763365,0.000763365,0.000746211,0.000746211,0.00072048,0.000711902,
0.00066044,0.000643285,0.000608977,0.000557514,0.00054036,0.000497474,0.000454588,0.000377394,0.000343086,
0.000317354,0.0003002,0.000274468,0.000248737,0.00024016,0.00024016,0.00024016,0.00024016,0.000248737,
0.000248737,0.000248737,0.000248737,0.000248737,0.000248737,0.000248737,0.000248737,0.000274468,0.000274468,
0.0003002,0.000308777,0.000334508,0.000368817,0.000446011,0.00048032,0.00054036,0.000574668,0.000634708,
0.000677594,0.000746211,0.000763365,0.00078052,0.000797674,0.000814828,0.000849137,0.000874868,0.0009006,
0.000909177,0.000909177,0.000892022,0.000857714,0.00084056,0.000806251,0.00078052,0.000771942,0.000763365,
0.000746211,0.00072048,0.000677594,0.00066044,0.000643285,0.000634708,0.000626131,0.000634708,0.000651863,
0.000711902,0.000746211,0.00078052,0.000866291,0.000977794,0.00104641,0.0012008,0.00147527,0.00173258,
0.00190412,0.00216144,0.00255599,0.00303631,0.00385971,0.00469169,0.00547221,0.00628704,0.00726484,0.00829409,
0.00945201,0.0109702,0.0130887,0.0162194,0.0198561,0.0244963,0.030243,0.0376708,0.0467454,0.0559573,0.0647831,
0.0752215,0.0853768,0.0987057,0.117241,0.150066,0.200422,0.235949,0.269571,0.303356,0.336644,0.36964,
0.401745,0.430238,0.452633,0.470216,0.483399,0.489849,0.471828,0.456004,0.439364,0.421644,0.40135,0.37706,
0.348386,0.317045,0.284469,0.249183,0.215518,0.170651,0.126264,0.103234,0.0867663,0.0747069,0.0636424,
0.0553054,0.0464967,0.0380825,0.0310407,0.0255513,0.0208682,0.0173944,0.0142724,0.0118965,0.0100696,0.00868006,
0.00756504,0.00653578,0.00560945,0.00494043,0.00411703,0.0033022,0.0028133,0.00235871,0.00205851,0.00184408,
0.00162966,0.00140665,0.00114934,0.00104641,0.00096064,0.000857714,0.00078052,0.000737634,0.00066044,
0.000617554,0.000566091,0.000548937,0.00054036,0.00054036,0.00054036,0.000548937,0.000557514,0.000574668,
0.000574668,0.000608977,0.000626131,0.000626131,0.000643285,0.000643285,0.000643285,0.000643285,0.000643285,
0.000643285,0.000634708,0.000626131,0.0006004,0.000574668,0.000557514,0.00054036,0.000506051,0.000471743,
0.000454588,0.000377394,0.000343086,0.000317354,0.0003002,0.000274468,0.00024016,0.00024016,0.00024016,
0.00024016,0.00024016,0.00024016,0.00024016,0.00024016,0.000248737,0.000248737,0.000274468,0.000274468,
0.000274468,0.000274468,0.000291623,0.0003002,0.000308777,0.000334508,0.00036024,0.000377394,0.000463165,
0.000514628,0.000557514,0.000634708,0.000711902,0.000763365,0.00078052,0.00084056,0.000917754,0.000943485,
0.000994948,0.00100353,0.00102926,0.00102926,0.00104641,0.00104641,0.00104641,0.00102926,0.00102068,0.000994948,
0.000977794,0.000943485,0.000909177,0.00084056,0.000806251,0.00078052,0.000763365,0.000746211,0.00072048,
0.000703325,0.000669017,0.00066044,0.000711902,0.000737634,0.000763365,0.000806251,0.0009006,0.000994948,
0.00105499,0.00124369,0.00150958,0.00174116,0.00194701,0.00226436,0.00266749,0.00316496,0.00407414,0.00496616,
0.00569522,0.00667301,0.00765938,0.00867149,0.00986371,0.0115534,0.0139636,0.0173773,0.0214428,0.0266492,
0.0334165,0.0420194,0.051926,0.0606918,0.0708043,0.0810625,0.0923672,0.106648,0.128263,0.171912,0.21689,
0.251456,0.284564,0.315416,0.347691,0.380559,0.412089,0.438849,0.459675,0.475079,0.482884,0.481486,0.452933,
0.437597,0.420983,0.404335,0.386906,0.363696,0.336687,0.306375,0.274065,0.239397,0.204488,0.152707,0.117129,
0.0968445,0.0816372,0.0697922,0.0597912,0.0518488,0.04298,0.0349947,0.0289564,0.0238101,0.0198561,0.0165196,
0.0136462,0.0114591,0.00977794,0.00831982,0.00719622,0.00615839,0.00539502,0.00464023,0.00388544,0.00308777,
0.00265034,0.0022901,0.0019899,0.00181835,0.00162108,0.00140665,0.00114934,0.00104641,0.00096064,0.000857714,
0.00078052,0.000737634,0.000651863,0.000591823,0.000548937,0.00054036,0.000514628,0.000506051,0.000506051,
0.000506051,0.000514628,0.000531783,0.00054036,0.00054036,0.00054036,0.00054036,0.00054036,0.000548937,
0.000548937,0.00054036,0.00054036,0.00054036,0.00054036,0.00054036,0.000514628,0.000497474,0.000463165,
0.000454588,0.000394548,0.000368817,0.000343086,0.000317354,0.0003002,0.000274468,0.00024016,0.00024016,
0.000231583,0.000223006,0.000223006,0.000223006,0.00024016,0.00024016,0.00024016,0.000248737,0.000265891,
0.000274468,0.000274468,0.000291623,0.0003002,0.000308777,0.000317354,0.000334508,0.000343086,0.000377394,
0.000446011,0.00048032,0.00054036,0.0006004,0.00066044,0.000754788,0.000797674,0.0009006,0.000969217,
0.00102926,0.00104641,0.00112361,0.00114934,0.00123511,0.0013123,0.00132088,0.00132088,0.00132088,0.0013123,
0.00126942,0.00119222,0.00114934,0.00111503,0.00105499,0.00102926,0.000994948,0.000943485,0.0009006,0.000831982,
0.000789097,0.000771942,0.000763365,0.000746211,0.000746211,0.000746211,0.000763365,0.00078052,0.000823405,
0.000934908,0.000994948,0.0010893,0.0013123,0.00153531,0.00177547,0.0019899,0.00229867,0.00279615,0.00335366,
0.00429715,0.00524921,0.00598684,0.00698179,0.00803678,0.00908319,0.0104727,0.0122825,0.0149242,0.0185609,
0.0232526,0.0291708,0.03647,0.0459134,0.0557686,0.0654521,0.0765338,0.0872123,0.0996406,0.116049,0.145082,
0.19772,0.236583,0.271775,0.302233,0.329963,0.358988,0.389522,0.418333,0.442151,0.459846,0.470516,0.471786,
0.465704,0.434038,0.419534,0.405107,0.391109,0.373123,0.35023,0.323161,0.293175,0.260393,0.226479,0.18814,
0.136359,0.109136,0.0910892,0.0773143,0.0656065,0.0566263,0.048538,0.0402354,0.0331678,0.0273268,0.0227637,
0.0190069,0.0159792,0.0131659,0.0110474,0.00940054,0.00807966,0.00692175,0.00584103,0.00513771,0.00433145,
0.00356809,0.00293338,0.00253883,0.00219575,0.00198132,0.00180978,0.0016125,0.00140665,0.00114934,0.00104641,
0.000969217,0.000857714,0.00078052,0.000737634,0.000643285,0.000574668,0.00054036,0.000506051,0.00048032,
0.000463165,0.000463165,0.000463165,0.000463165,0.000463165,0.000463165,0.000471743,0.000471743,0.000471743,
0.000471743,0.000471743,0.000471743,0.000471743,0.000463165,0.000463165,0.000454588,0.000454588,0.000411703,
0.000385971,0.000368817,0.000343086,0.000334508,0.000308777,0.000291623,0.000248737,0.00024016,0.00024016,
0.000214428,0.000214428,0.000205851,0.000205851,0.000214428,0.000223006,0.00024016,0.00024016,0.000248737,
0.000265891,0.000274468,0.0003002,0.000308777,0.000308777,0.000317354,0.000334508,0.000343086,0.000368817,
0.000394548,0.000454588,0.000506051,0.000548937,0.000626131,0.00072048,0.00078052,0.000874868,0.000977794,
0.00104641,0.00114076,0.00126942,0.00138092,0.00149242,0.00156104,0.00162108,0.00164681,0.00164681,0.00164681,
0.00162966,0.00162108,0.00159535,0.00154388,0.00149242,0.0014238,0.00133803,0.00121795,0.00114076,0.00104641,
0.0010121,0.000977794,0.000917754,0.000857714,0.000806251,0.00078052,0.00078052,0.00078052,0.00078052,
0.000806251,0.000874868,0.000943485,0.00102926,0.00112361,0.00133803,0.00157819,0.00180978,0.00204994,
0.00237587,0.00289907,0.00359382,0.00453731,0.00542075,0.0063042,0.00737634,0.00837986,0.00958924,0.0110474,
0.0130287,0.016125,0.019959,0.0249595,0.0313151,0.0394548,0.0496531,0.0592938,0.0702296,0.0814828,0.0936967,
0.108535,0.129506,0.173404,0.219798,0.257906,0.292326,0.320348,0.346027,0.371682,0.397216,0.421575,0.441474,
0.454931,0.460189,0.456844,0.447186,0.419122,0.405827,0.392473,0.377797,0.358379,0.335023,0.307182,0.276707,
0.243042,0.209316,0.159595,0.121392,0.10109,0.0855055,0.0732402,0.062493,0.0544391,0.0459563,0.0381768,
0.0317869,0.0264176,0.0220089,0.018458,0.015516,0.0128228,0.0107643,0.00910034,0.00785666,0.00668159,
0.00561803,0.00488897,0.00408272,0.0033022,0.00284761,0.00244448,0.00216144,0.00194701,0.00179262,0.00162108,
0.00140665,0.00115791,0.00104641,0.000977794,0.000857714,0.00078052,0.000737634,0.000643285,0.000574668,
0.00054036,0.000497474,0.000454588,0.000446011,0.000394548,0.000394548,0.000394548,0.000394548,0.000394548,
0.000394548,0.000394548,0.000394548,0.000394548,0.000394548,0.000377394,0.000377394,0.000377394,0.000368817,
0.000368817,0.000351663,0.000343086,0.000334508,0.000308777,0.0003002,0.000274468,0.00024016,0.00024016,
0.000214428,0.000205851,0.000205851,0.000205851,0.000205851,0.000205851,0.000205851,0.000214428,0.000223006,
0.00024016,0.00024016,0.000274468,0.000291623,0.0003002,0.000308777,0.000325931,0.000334508,0.00036024,
0.000377394,0.000394548,0.000454588,0.00048032,0.00054036,0.000574668,0.000643285,0.000746211,0.000806251,
0.000943485,0.00102926,0.00114076,0.00132088,0.00148384,0.00162108,0.00173258,0.00180978,0.00186124,0.00188697,
0.0019127,0.0019127,0.00190412,0.00188697,0.00187839,0.00185266,0.00183551,0.00177547,0.00173258,0.00163823,
0.00156104,0.00144954,0.00132088,0.00114934,0.00107214,0.00102926,0.000977794,0.000934908,0.000874868,
0.00084056,0.000814828,0.00084056,0.000857714,0.000934908,0.000994948,0.00104641,0.00114934,0.00138092,
0.00162108,0.00185266,0.00208424,0.00247879,0.00299342,0.00385971,0.00478604,0.00560945,0.00666444,0.00776231,
0.00876584,0.0100524,0.0116392,0.0138092,0.0170256,0.0209111,0.0262546,0.0330048,0.0418221,0.0522691,
0.0622443,0.0741665,0.086226,0.100387,0.117404,0.147029,0.198544,0.238144,0.276235,0.308768,0.336541,
0.359888,0.381726,0.401882,0.421249,0.436782,0.446329,0.448155,0.442049,0.431387,0.407937,0.394986,0.380439,
0.36331,0.34306,0.318443,0.289959,0.256619,0.22292,0.184571,0.136025,0.110671,0.093851,0.0807366,0.0698179,
0.0599971,0.0523806,0.044258,0.0368388,0.0308177,0.0259973,0.0215543,0.0181492,0.0151043,0.012514,0.0104727,
0.00886018,0.00762508,0.00649289,0.00553225,0.00469169,0.00388544,0.00312208,0.00275326,0.00235871,0.00212713,
0.00193843,0.0018012,0.00162108,0.00143238,0.00121795,0.00105499,0.000994948,0.000874868,0.00078052,0.000737634,
0.000643285,0.000557514,0.000531783,0.000463165,0.00042028,0.000377394,0.000368817,0.00036024,0.000343086,
0.000343086,0.000343086,0.000343086,0.000343086,0.000334508,0.000334508,0.000334508,0.000334508,0.000334508,
0.000317354,0.000317354,0.000308777,0.0003002,0.000291623,0.000274468,0.000248737,0.00024016,0.000223006,
0.000214428,0.000205851,0.000205851,0.000205851,0.000205851,0.000205851,0.000205851,0.000205851,0.000205851,
0.000214428,0.00024016,0.00024016,0.000265891,0.000291623,0.000308777,0.000317354,0.000334508,0.000368817,
0.000377394,0.000403126,0.000454588,0.00048032,0.000523205,0.000557514,0.000617554,0.00066044,0.000763365,
0.000831982,0.000977794,0.00105499,0.00124369,0.00147527,0.00164681,0.0018012,0.00188697,0.0019899,0.00208424,
0.00216144,0.00216144,0.00219575,0.00219575,0.00217859,0.00216144,0.00210998,0.00208424,0.00204994,0.0019899,
0.00193843,0.00187839,0.00180978,0.00173258,0.00160392,0.00146669,0.00132088,0.00114934,0.00105499,0.00100353,
0.000969217,0.000943485,0.000917754,0.000917754,0.000943485,0.000969217,0.0010121,0.00107214,0.00120938,
0.00144954,0.00167254,0.00188697,0.00216144,0.00259887,0.00312208,0.00405699,0.0050262,0.00579815,0.00692175,
0.00806251,0.00913465,0.010507,0.0121795,0.0144439,0.0177976,0.0218031,0.0270523,0.0340598,0.0431687,
0.0540789,0.0644829,0.0773658,0.0910978,0.107214,0.128623,0.167649,0.214111,0.25065,0.2879,0.319172,0.346559,
0.368011,0.385894,0.40141,0.416,0.427948,0.434895,0.435401,0.429826,0.419937,0.397902,0.384316,0.367273,
0.348832,0.326,0.300354,0.270377,0.236618,0.200533,0.15082,0.118656,0.101167,0.0874353,0.0766625,0.0665929,
0.0581444,0.0508453,0.0431173,0.036084,0.0302687,0.0256199,0.0213142,0.0178404,0.014624,0.0121281,0.0102239,
0.00868006,0.00747069,0.0063042,0.0054036,0.00458877,0.00381683,0.00307062,0.00269322,0.00235871,0.00212713,
0.00194701,0.00180978,0.00164681,0.00147527,0.00130373,0.00109787,0.000994948,0.000909177,0.00078052,
0.000737634,0.000643285,0.000557514,0.000506051,0.000454588,0.000377394,0.000343086,0.000334508,0.000317354,
0.000308777,0.000308777,0.000308777,0.0003002,0.0003002,0.000291623,0.000291623,0.000291623,0.000274468,
0.000274468,0.000274468,0.000248737,0.000248737,0.00024016,0.00024016,0.000223006,0.000214428,0.000205851,
0.000205851,0.000205851,0.000197274,0.000197274,0.000197274,0.000197274,0.000205851,0.000205851,0.000205851,
0.000214428,0.00024016,0.00024016,0.000257314,0.000291623,0.000308777,0.000334508,0.000343086,0.000377394,
0.000403126,0.000463165,0.000497474,0.00054036,0.000557514,0.000626131,0.00066044,0.000746211,0.00078052,
0.0009006,0.000994948,0.00112361,0.00134661,0.00160392,0.00178404,0.00192128,0.00208424,0.00220432,0.00233298,
0.00241875,0.00249595,0.00253883,0.00255599,0.00253883,0.00250452,0.00247022,0.0024016,0.00235871,0.00229867,
0.00227294,0.00216144,0.00208424,0.0019899,0.0019127,0.00183551,0.00173258,0.00156104,0.00140665,0.00121795,
0.00110645,0.00104641,0.000994948,0.000986371,0.000977794,0.000986371,0.000994948,0.00104641,0.00114076,
0.0013123,0.00151815,0.00174116,0.00194701,0.0022901,0.00271895,0.00327647,0.00425426,0.00523205,0.00603831,
0.00709329,0.00824263,0.00946916,0.0109444,0.0127113,0.0151386,0.0183036,0.0223606,0.0276355,0.0346431,
0.0439921,0.0549023,0.0661812,0.0796559,0.0947602,0.113278,0.140013,0.185892,0.223194,0.258163,0.292618,
0.32256,0.348558,0.367873,0.382772,0.395269,0.406608,0.416909,0.422613,0.423153,0.41859,0.41003,0.387189,
0.371965,0.353189,0.331515,0.307113,0.28037,0.248917,0.215758,0.172589,0.130081,0.108475,0.0937138,0.0824177,
0.0730086,0.0639511,0.056652,0.0497646,0.0424568,0.0357238,0.0300629,0.025354,0.0209883,0.0174888,0.0142724,
0.0118965,0.0100181,0.00855998,0.00737634,0.00628704,0.0054036,0.00460592,0.00384256,0.00308777,0.00275326,
0.00239302,0.00216144,0.0019899,0.00184408,0.0016897,0.00151815,0.00132088,0.00111503,0.00100353,0.000917754,
0.00078052,0.000729057,0.000634708,0.000548937,0.000497474,0.000411703,0.000368817,0.000325931,0.000308777,
0.000274468,0.000265891,0.000248737,0.00024016,0.00024016,0.00024016,0.00024016,0.00024016,0.00024016,
0.000231583,0.000223006,0.000223006,0.000214428,0.000205851,0.000205851,0.000205851,0.000205851,0.000205851,
0.000197274,0.000197274,0.000188697,0.00018012,0.000197274,0.000197274,0.000205851,0.000205851,0.000205851,
0.000214428,0.00024016,0.00024016,0.000274468,0.0003002,0.000308777,0.000334508,0.000368817,0.000394548,
0.000454588,0.000497474,0.00054036,0.000574668,0.000643285,0.00072048,0.000763365,0.000789097,0.0009006,
0.000986371,0.00104641,0.00123511,0.00149242,0.00173258,0.00188697,0.00208424,0.0022901,0.00247879,0.00265034,
0.0028133,0.00289907,0.00291623,0.0029248,0.00291623,0.00289907,0.00286476,0.0028133,0.00275326,0.00266749,
0.00260745,0.00253026,0.00244448,0.00234156,0.00226436,0.00212713,0.0019899,0.00188697,0.00176689,0.00162108,
0.00145811,0.00130373,0.00114076,0.00104641,0.00102926,0.00102068,0.00102926,0.00103783,0.00107214,0.00114934,
0.00136377,0.00159535,0.00180978,0.00201563,0.00235871,0.00284761,0.00342228,0.00443438,0.00530067,0.00620127,
0.00729057,0.00841417,0.00973505,0.0112189,0.0130544,0.0156704,0.0187582,0.0228581,0.0282874,0.035192,
0.0446354,0.055597,0.0675107,0.0813284,0.0978823,0.118287,0.150692,0.196622,0.229224,0.261457,0.293047,
0.320313,0.343815,0.361638,0.374315,0.384796,0.39448,0.402714,0.408246,0.409807,0.406659,0.398562,0.372754,
0.356329,0.335821,0.311899,0.286965,0.257872,0.227474,0.193646,0.146009,0.117327,0.100773,0.0883102,0.0787467,
0.070324,0.0622271,0.0555455,0.0489497,0.0420022,0.0355008,0.0300286,0.0253111,0.0208939,0.0173516,0.0140065,
0.0116821,0.00985513,0.00848279,0.00737634,0.0063042,0.00548079,0.00471743,0.00399695,0.00321643,0.00286476,
0.0025131,0.00228152,0.00205851,0.00188697,0.00174974,0.00156104,0.00134661,0.00114076,0.00102926,0.000917754,
0.00078052,0.00072048,0.000626131,0.00054036,0.000463165,0.000377394,0.000334508,0.0003002,0.000248737,
0.00024016,0.000223006,0.000214428,0.000205851,0.000205851,0.000205851,0.000205851,0.000197274,0.000197274,
0.000197274,0.000197274,0.000197274,0.000197274,0.000188697,0.00018012,0.00018012,0.000162966,0.000162966,
0.000171543,0.00018012,0.00018012,0.000197274,0.000197274,0.000205851,0.000205851,0.000214428,0.000223006,
0.00024016,0.000248737,0.000274468,0.000308777,0.000317354,0.000343086,0.000377394,0.000446011,0.000471743,
0.00054036,0.000574668,0.00066044,0.000746211,0.00078052,0.000857714,0.000952062,0.00102926,0.00111503,
0.0013123,0.00150958,0.00170685,0.00186982,0.00201563,0.00227294,0.00250452,0.00279615,0.00298484,0.00315639,
0.00331935,0.0034137,0.00342228,0.00340512,0.00334508,0.00325074,0.00316496,0.00307919,0.003002,0.00293338,
0.00289907,0.0028133,0.00269322,0.00260745,0.00247879,0.00234156,0.00219575,0.00207567,0.0019127,0.00180978,
0.00162966,0.00146669,0.0013123,0.00114076,0.00108072,0.00104641,0.00104641,0.00105499,0.00113218,0.00124369,
0.00144954,0.00164681,0.00186124,0.00208424,0.00245306,0.00290765,0.00362813,0.00453731,0.0054036,0.00629562,
0.00740207,0.00849137,0.00983798,0.0114419,0.0133975,0.0161851,0.0194787,0.0236129,0.0291537,0.0362127,
0.0456304,0.0563518,0.0684198,0.0828552,0.100773,0.123965,0.162254,0.205371,0.233727,0.261723,0.289736,
0.314335,0.3354,0.351345,0.362513,0.371845,0.380353,0.386735,0.391503,0.393862,0.392112,0.385122,0.354682,
0.337279,0.315484,0.290799,0.263807,0.236583,0.208476,0.168901,0.132337,0.111306,0.0964928,0.0848879,
0.0763451,0.0681368,0.060709,0.0546621,0.0480406,0.0415734,0.035355,0.0301143,0.0255256,0.0210655,0.0174116,
0.0140494,0.0116906,0.00986371,0.00855998,0.00747926,0.00651863,0.00561803,0.00501763,0.00426284,0.00354236,
0.00299342,0.00267607,0.00236729,0.00216144,0.00197274,0.00180978,0.00162108,0.00140665,0.00114934,0.00102926,
0.000917754,0.00078052,0.00072048,0.000608977,0.00054036,0.000454588,0.000368817,0.000308777,0.000248737,
0.000231583,0.000205851,0.000197274,0.000162966,0.000162966,0.000154388,0.000154388,0.000154388,0.000154388,
0.000154388,0.000154388,0.000154388,0.000154388,0.000154388,0.000154388,0.000154388,0.000162966,0.000162966,
0.000162966,0.000162966,0.000197274,0.000197274,0.000205851,0.000205851,0.000205851,0.000223006,0.00024016,
0.00024016,0.000274468,0.0003002,0.000317354,0.000334508,0.000368817,0.000394548,0.000454588,0.000506051,
0.000557514,0.000643285,0.000737634,0.00078052,0.000917754,0.0010121,0.00112361,0.00132088,0.00150958,
0.0016897,0.00184408,0.00198132,0.00216144,0.00234156,0.00256456,0.00284761,0.00307919,0.00339655,0.0038254,
0.00404841,0.00417707,0.00423711,0.00421995,0.00409987,0.0040141,0.00385971,0.00368817,0.00348232,0.00333651,
0.00321643,0.00310492,0.00301915,0.0029248,0.00284761,0.00271895,0.00256456,0.00239302,0.00226436,0.00208424,
0.0019127,0.00178404,0.00162108,0.00143238,0.00130373,0.00114934,0.00110645,0.00109787,0.00110645,0.00114934,
0.00132946,0.00150958,0.00173258,0.00190412,0.00216144,0.0025131,0.00297627,0.00377394,0.00463165,0.00547221,
0.00632993,0.00746211,0.00855998,0.00987229,0.0116478,0.0138263,0.0167769,0.0202935,0.0248308,0.0303802,
0.0377051,0.0470799,0.0576469,0.0702382,0.0851109,0.104126,0.131136,0.176715,0.212902,0.237587,0.260925,
0.284847,0.306564,0.325485,0.340332,0.350882,0.358447,0.365103,0.369597,0.373929,0.376905,0.375541,0.367367,
0.335263,0.316762,0.29441,0.268344,0.242227,0.21822,0.191056,0.15179,0.124506,0.107549,0.0937824,0.0827865,
0.0744753,0.0663356,0.0596712,0.0538387,0.0471828,0.0411445,0.035355,0.0302945,0.0258858,0.0215029,0.017849,
0.0144439,0.0119994,0.0102411,0.00886018,0.00783093,0.00688744,0.00596111,0.00536071,0.00470885,0.00403983,
0.00331078,0.00289907,0.00256456,0.00229867,0.00205851,0.00187839,0.00169827,0.00147527,0.00118365,0.00103783,
0.000934908,0.00078052,0.00072048,0.000591823,0.000514628,0.000446011,0.000343086,0.000291623,0.00024016,
0.000205851,0.000162966,0.000154388,0.000145811,0.000137234,0.00012008,0.00012008,0.00012008,0.00012008,
0.00012008,0.00012008,0.000128657,0.000137234,0.000137234,0.000145811,0.000154388,0.000154388,0.000162966,
0.000162966,0.000197274,0.000205851,0.000205851,0.000214428,0.000231583,0.00024016,0.000248737,0.000274468,
0.0003002,0.000308777,0.000334508,0.000368817,0.000377394,0.000454588,0.000497474,0.00054036,0.000608977,
0.000694748,0.000771942,0.000909177,0.00102926,0.00114934,0.00148384,0.00173258,0.00188697,0.00208424,
0.00229867,0.00250452,0.00275326,0.0029248,0.00310492,0.00337939,0.00384256,0.00410845,0.00446869,0.00470885,
0.0049147,0.00500047,0.00499189,0.0049147,0.00474316,0.00453731,0.0043143,0.00409987,0.00395406,0.00381683,
0.00359382,0.00337939,0.00326789,0.00313923,0.00302773,0.00290765,0.00279615,0.00260745,0.0024016,0.00226436,
0.00205851,0.00188697,0.00174116,0.00156104,0.00137234,0.00121795,0.00114934,0.00114076,0.00114076,0.00121795,
0.00136377,0.00156104,0.00176689,0.00194701,0.00220432,0.00256456,0.003002,0.0038254,0.00464881,0.00548079,
0.00636424,0.00747069,0.00862002,0.010061,0.0119222,0.0143324,0.0176174,0.0214085,0.0262546,0.0322672,
0.0399266,0.0495759,0.0595168,0.0724168,0.0878299,0.108647,0.138735,0.187959,0.218829,0.241249,0.260694,
0.280644,0.299677,0.316445,0.330306,0.340349,0.34746,0.35174,0.354965,0.358293,0.360197,0.357504,0.349415,
0.31605,0.297009,0.27422,0.248703,0.225665,0.204024,0.175025,0.142115,0.119462,0.104607,0.0920327,0.0813542,
0.0727084,0.0649289,0.0585304,0.0527408,0.0463594,0.0408272,0.0354064,0.0306633,0.0262889,0.0221547,0.0185095,
0.0154646,0.0128657,0.0109444,0.00951205,0.00836271,0.00746211,0.0066044,0.00578957,0.00526636,0.00454588,
0.00388544,0.00318212,0.00283903,0.00247879,0.00217859,0.00195559,0.00176689,0.00153531,0.00124369,0.00104641,
0.000943485,0.00078052,0.000703325,0.000574668,0.000506051,0.000394548,0.000334508,0.000248737,0.000205851,
0.000162966,0.000154388,0.000128657,0.00012008,0.00012008,0.000111503,0.000111503,0.000111503,0.000111503,
0.00012008,0.00012008,0.00012008,0.00012008,0.000128657,0.000137234,0.000154388,0.000162966,0.00018012,
0.000205851,0.000205851,0.000214428,0.00024016,0.00024016,0.000248737,0.000274468,0.0003002,0.000308777,
0.000334508,0.000368817,0.000377394,0.000454588,0.00048032,0.00054036,0.000574668,0.000643285,0.000746211,
0.00084056,0.000994948,0.00114934,0.00150958,0.00180978,0.00204994,0.00233298,0.00265034,0.00296769,0.0033022,
0.00378252,0.00407414,0.00434861,0.00460592,0.00482035,0.00505193,0.00528352,0.00544648,0.00556656,0.00563518,
0.00563518,0.00560945,0.00548079,0.00528352,0.00505193,0.00479462,0.00452015,0.00427141,0.0040913,0.00392833,
0.0037911,0.00357667,0.00336224,0.00321643,0.00307062,0.0029248,0.0028133,0.00257314,0.00235871,0.00216144,
0.0019899,0.00184408,0.00165539,0.00149242,0.00132946,0.00119222,0.00114934,0.00114934,0.00130373,0.0014238,
0.00160392,0.00180978,0.00198132,0.00226436,0.00261603,0.00304488,0.00385971,0.00464881,0.00548079,0.00636424,
0.00747926,0.0087058,0.0102668,0.0123253,0.0151043,0.0185266,0.0228066,0.0280301,0.0341799,0.0422853,
0.0519689,0.0617554,0.0753244,0.0913379,0.113132,0.146772,0.195619,0.223735,0.243273,0.260067,0.276681,
0.292944,0.308168,0.320931,0.330451,0.337013,0.340847,0.343875,0.346208,0.346062,0.341036,0.331189,0.298433,
0.278517,0.255659,0.232672,0.21267,0.190936,0.160255,0.135382,0.116392,0.102445,0.0902229,0.0799046,0.0711216,
0.0633507,0.057038,0.0516601,0.045699,0.0405527,0.0356209,0.0313151,0.0269494,0.0230811,0.0196931,0.0166482,
0.0140494,0.0119737,0.0104984,0.00925473,0.00827694,0.00741065,0.00657867,0.00577241,0.00524921,0.00451157,
0.0038254,0.00309635,0.00274468,0.00235871,0.00208424,0.00186124,0.00162108,0.00132946,0.00104641,0.000943485,
0.00078052,0.000694748,0.000574668,0.000497474,0.000377394,0.000308777,0.00024016,0.000197274,0.000154388,
0.00012008,0.00012008,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,
0.00012008,0.00012008,0.00012008,0.000137234,0.000154388,0.000162966,0.000197274,0.000205851,0.000214428,
0.00024016,0.00024016,0.000274468,0.000291623,0.000308777,0.000325931,0.000343086,0.000368817,0.000394548,
0.000454588,0.00048032,0.00054036,0.000557514,0.000626131,0.00072048,0.00078052,0.000943485,0.00107214,
0.00140665,0.00176689,0.00208424,0.00247879,0.0029248,0.00342228,0.0040913,0.00460592,0.00504336,0.00535213,
0.00557514,0.00577241,0.00596969,0.00616696,0.00631277,0.00649289,0.00656151,0.00665586,0.00667301,0.00657009,
0.00637281,0.00610692,0.00573811,0.00549795,0.00524921,0.0049147,0.0046145,0.00439149,0.00419422,0.00404841,
0.00386829,0.00374821,0.00343943,0.00325074,0.00307919,0.00291623,0.00275326,0.0025131,0.00229867,0.00208424,
0.00190412,0.00175831,0.00156104,0.00140665,0.00130373,0.0012008,0.00121795,0.00132946,0.00146669,0.00163823,
0.00184408,0.00199847,0.0022901,0.0026246,0.00306204,0.00386829,0.00468312,0.00548079,0.00638139,0.00757361,
0.00889449,0.0106013,0.0128657,0.0160478,0.019796,0.0243505,0.0298399,0.0363242,0.044481,0.0542332,0.0638911,
0.0777432,0.0944343,0.117087,0.154534,0.201383,0.22672,0.244774,0.259227,0.273053,0.287497,0.301058,0.312002,
0.320588,0.326798,0.330563,0.33257,0.333608,0.331712,0.324971,0.313692,0.281768,0.261303,0.239722,0.218794,
0.199127,0.176921,0.14998,0.129626,0.113578,0.100087,0.0880443,0.0782407,0.0693204,0.0617039,0.0556313,
0.0502963,0.0449442,0.0404069,0.0358524,0.0319327,0.0280129,0.0243848,0.0210054,0.018235,0.0158248,0.0135776,
0.0119136,0.0105241,0.00940054,0.0084056,0.007505,0.00669017,0.00578957,0.00518917,0.00443438,0.00374821,
0.00303631,0.00261603,0.00228152,0.00198132,0.00173258,0.0014238,0.00110645,0.000952062,0.00078052,0.000703325,
0.000574668,0.000497474,0.000377394,0.000308777,0.00024016,0.000171543,0.000137234,0.00012008,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.00012008,0.00012008,
0.000128657,0.000154388,0.000162966,0.000205851,0.000205851,0.00024016,0.000248737,0.000274468,0.000308777,
0.000317354,0.000343086,0.000368817,0.000377394,0.000454588,0.000463165,0.000497474,0.00054036,0.000574668,
0.000634708,0.000711902,0.000771942,0.000857714,0.00100353,0.00121795,0.00162108,0.00198132,0.0024016,
0.00298484,0.00384256,0.00457161,0.00526636,0.0057038,0.00623558,0.00679309,0.00705041,0.00740207,0.00767654,
0.00789954,0.00803678,0.00807966,0.00809682,0.00807109,0.00797674,0.00786524,0.00763365,0.00733345,0.00693033,
0.00648432,0.0059268,0.00555799,0.00526636,0.00494043,0.00464881,0.00444296,0.00425426,0.00408272,0.0039026,
0.00377394,0.00347374,0.003225,0.00304488,0.00288192,0.00263318,0.00239302,0.00217859,0.0019899,0.00184408,
0.00164681,0.00148384,0.00133803,0.00130373,0.0013123,0.00134661,0.00150958,0.00168112,0.00186124,0.00205851,
0.00229867,0.00267607,0.00310492,0.00391118,0.00471743,0.00553225,0.0065272,0.00776231,0.00914323,0.0110645,
0.0135948,0.0169913,0.0208939,0.0260488,0.0317869,0.0385199,0.0467711,0.0559916,0.0663956,0.0800933,0.0975821,
0.120637,0.160272,0.205139,0.228606,0.245692,0.258669,0.27048,0.282428,0.29393,0.303528,0.310389,0.316428,
0.319353,0.32033,0.31979,0.316702,0.308949,0.29785,0.263644,0.244294,0.224738,0.205731,0.186896,0.162271,
0.142329,0.124274,0.110431,0.0973848,0.0857542,0.0762593,0.0672705,0.0599885,0.0545249,0.0492928,0.0444467,
0.0403211,0.0362899,0.0327304,0.0292566,0.0259802,0.0227123,0.0199676,0.0176003,0.0154989,0.0136119,0.0120251,
0.0108072,0.00967501,0.00858572,0.00765938,0.00674163,0.00575526,0.0051034,0.0043143,0.00354236,0.00293338,
0.00250452,0.00212713,0.00186124,0.00156104,0.00114934,0.000994948,0.000806251,0.00072048,0.000574668,
0.000497474,0.000377394,0.000308777,0.00024016,0.00018012,0.000137234,0.00012008,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.00012008,0.00012008,0.000137234,0.000154388,
0.00018012,0.000205851,0.000223006,0.00024016,0.000274468,0.000308777,0.000334508,0.000368817,0.000377394,
0.000454588,0.000471743,0.000506051,0.00054036,0.000557514,0.000626131,0.00066044,0.000737634,0.00078052,
0.000857714,0.000977794,0.00110645,0.00144954,0.00183551,0.00218717,0.0028133,0.00365386,0.00464881,0.00553225,
0.00629562,0.00707614,0.00787381,0.00837129,0.00883445,0.00918612,0.00956351,0.0098294,0.00997521,0.0101039,
0.0101382,0.0100438,0.00984655,0.00956351,0.00918612,0.00879157,0.00831982,0.00784808,0.00716191,0.00656151,
0.00594396,0.00554083,0.00525779,0.00494043,0.00469169,0.004503,0.00428857,0.00409987,0.00396264,0.00378252,
0.00342228,0.0031907,0.00298484,0.0028133,0.00253883,0.00229867,0.00208424,0.00188697,0.00174116,0.00156104,
0.0014238,0.00133803,0.00133803,0.00140665,0.00154388,0.00173258,0.00188697,0.00208424,0.00235871,0.00277899,
0.00321643,0.00405699,0.00486324,0.00560945,0.00675879,0.00801105,0.00956351,0.0116306,0.0144096,0.0180635,
0.0223434,0.0274726,0.0335967,0.0408358,0.0493957,0.0581873,0.0692089,0.0826322,0.100438,0.124386,0.165033,
0.20749,0.230596,0.247202,0.259098,0.269648,0.279589,0.28899,0.29622,0.301615,0.305483,0.307285,0.307422,
0.305981,0.301495,0.292832,0.280695,0.24528,0.227895,0.210715,0.193157,0.172838,0.151781,0.134996,0.119128,
0.106519,0.094237,0.0831982,0.0740036,0.0652634,0.0586333,0.0535814,0.048641,0.0442752,0.0405184,0.0369675,
0.0337853,0.0305518,0.0273868,0.0244963,0.021743,0.0194272,0.0174202,0.0155761,0.0138607,0.0124111,0.0110474,
0.00983798,0.00866291,0.00764223,0.00663013,0.00568664,0.00501763,0.00419422,0.00335366,0.00285619,0.00235871,
0.0019899,0.00173258,0.00136377,0.00104641,0.0009006,0.000754788,0.000626131,0.000531783,0.000403126,
0.000325931,0.00024016,0.000205851,0.000154388,0.00012008,0.00012008,0.000111503,0.000111503,0.000111503,
0.000111503,0.00012008,0.00012008,0.000128657,0.000154388,0.000162966,0.000205851,0.000214428,0.00024016,
0.000274468,0.000308777,0.000334508,0.000368817,0.000403126,0.000463165,0.000506051,0.00054036,0.000574668,
0.000643285,0.000677594,0.000746211,0.000771942,0.000814828,0.000943485,0.0010121,0.00111503,0.00134661,
0.00168112,0.0019899,0.00247879,0.00315639,0.0043143,0.0054036,0.00649289,0.0076165,0.00862002,0.0096064,
0.0104041,0.0110474,0.0115534,0.011948,0.0122138,0.012514,0.0127027,0.0128228,0.0127799,0.0125398,0.0120337,
0.0115363,0.0109444,0.0102239,0.00955493,0.00872295,0.00801105,0.00719622,0.0065272,0.00586676,0.00553225,
0.00524921,0.00495759,0.004726,0.00453731,0.00435719,0.00415134,0.00400552,0.00378252,0.00339655,0.00312208,
0.00291623,0.00267607,0.0024016,0.00217859,0.00198132,0.00181835,0.00164681,0.00150958,0.0014238,0.00140665,
0.00146669,0.00159535,0.00175831,0.0019127,0.00216144,0.00247022,0.00289907,0.00340512,0.00426284,0.00507767,
0.00584103,0.00698179,0.00831125,0.0100438,0.0124025,0.0155504,0.0192643,0.0237673,0.0292995,0.0354665,
0.0431173,0.0520718,0.060709,0.0721595,0.0856685,0.103715,0.128365,0.170342,0.209334,0.232235,0.249372,
0.261431,0.270883,0.27874,0.286056,0.290636,0.292652,0.29423,0.294513,0.293364,0.290362,0.284521,0.275215,
0.26174,0.227491,0.212224,0.195619,0.17843,0.157674,0.142157,0.127216,0.11441,0.102497,0.0911578,0.0807109,
0.0717135,0.0636338,0.0577756,0.0531182,0.0486753,0.044584,0.0411703,0.0378766,0.0349261,0.0322072,0.0292566,
0.0263318,0.0236643,0.0213142,0.0192471,0.0174888,0.0158763,0.0140665,0.0125741,0.0111074,0.00982082,
0.00854283,0.00747069,0.00645001,0.00553225,0.00481177,0.00404841,0.00320785,0.00269322,0.00226436,0.00189555,
0.00159535,0.00114934,0.000986371,0.000789097,0.00066044,0.000557514,0.000463165,0.000368817,0.000291623,
0.000223006,0.000197274,0.000154388,0.000128657,0.00012008,0.00012008,0.00012008,0.00012008,0.000137234,
0.000154388,0.000162966,0.000205851,0.000214428,0.00024016,0.000274468,0.000308777,0.000334508,0.000368817,
0.000403126,0.000463165,0.000514628,0.000557514,0.000626131,0.000694748,0.000754788,0.00078052,0.000857714,
0.000943485,0.0010121,0.00110645,0.0013123,0.00151815,0.00173258,0.00193843,0.00229867,0.00284761,0.00381683,
0.00499189,0.00608977,0.00747926,0.00889449,0.0103698,0.0117507,0.0129515,0.0139722,0.014624,0.0152244,
0.0155589,0.0158506,0.0159706,0.0160307,0.0160307,0.0159535,0.0154989,0.0147098,0.0139121,0.0129086,0.0118879,
0.0108672,0.00983798,0.00879157,0.00790812,0.00703325,0.00636424,0.00578957,0.00548079,0.00525779,0.00503478,
0.00481177,0.0046145,0.00443438,0.00422853,0.00402268,0.00377394,0.00335366,0.00306204,0.00285619,0.00256456,
0.00229867,0.00208424,0.00188697,0.00174974,0.0016125,0.00150958,0.00147527,0.00152673,0.00164681,0.00180978,
0.00198132,0.00226436,0.00260745,0.00304488,0.00381683,0.00459735,0.0054036,0.00628704,0.00747926,0.00886876,
0.0107643,0.0133203,0.0168369,0.0207738,0.02568,0.0313066,0.0378166,0.0458191,0.0548594,0.064097,0.0763365,
0.0900428,0.108312,0.132894,0.174828,0.210929,0.233461,0.250847,0.263387,0.272779,0.279126,0.283938,0.286451,
0.28567,0.283689,0.281347,0.278199,0.273345,0.266071,0.255796,0.242664,0.210311,0.194778,0.177881,0.158471,
0.144156,0.13165,0.119385,0.109419,0.0984827,0.0881129,0.0787381,0.0704269,0.0629476,0.0574154,0.0532726,
0.04937,0.0454846,0.042311,0.0392404,0.0364185,0.0337167,0.0308777,0.0281845,0.02568,0.0231497,0.0210226,
0.0192557,0.0176174,0.0159706,0.0140751,0.0124454,0.0109444,0.00954636,0.00827694,0.00714476,0.0061155,
0.00536071,0.00463165,0.00386829,0.00306204,0.00256456,0.00212713,0.00183551,0.00147527,0.00109787,0.000934908,
0.000763365,0.000634708,0.00054036,0.000454588,0.000343086,0.000291623,0.00024016,0.000205851,0.000197274,
0.000162966,0.000162966,0.000162966,0.000162966,0.000197274,0.000205851,0.000214428,0.00024016,0.000274468,
0.000308777,0.000334508,0.000368817,0.000403126,0.000463165,0.000514628,0.000557514,0.000634708,0.00072048,
0.000771942,0.000849137,0.000952062,0.00102926,0.00113218,0.00132088,0.00152673,0.00173258,0.00189555,
0.00208424,0.00235871,0.0028133,0.00335366,0.00446011,0.00553225,0.00689602,0.00842275,0.0102497,0.0122138,
0.014238,0.0161851,0.0175831,0.018458,0.0190327,0.0193071,0.0194958,0.0195473,0.0195216,0.0193758,0.0191956,
0.0189297,0.018398,0.0176346,0.0165024,0.0151644,0.0136377,0.0122138,0.0109444,0.00975221,0.00857714,
0.00771085,0.00689602,0.00623558,0.00572953,0.00553225,0.00528352,0.00508624,0.00493185,0.00470885,0.00451157,
0.00427141,0.00404841,0.00375679,0.0033022,0.00299342,0.00277042,0.00245306,0.00218717,0.0019899,0.00184408,
0.00173258,0.0016125,0.00156104,0.00162108,0.00173258,0.00186982,0.00207567,0.00235871,0.0028133,0.0033022,
0.00413418,0.00501763,0.00572953,0.00687029,0.00813113,0.00967501,0.0117335,0.0145983,0.0183808,0.0225922,
0.027524,0.0334937,0.0407929,0.0494043,0.0582302,0.0687629,0.0809939,0.0953692,0.113458,0.138795,0.179099,
0.210989,0.232252,0.249766,0.262726,0.271964,0.278054,0.28121,0.281116,0.278054,0.273722,0.268396,0.263001,
0.256302,0.248454,0.237321,0.224224,0.193577,0.1759,0.156636,0.143375,0.132062,0.121521,0.11345,0.104504,
0.0954464,0.0860973,0.0775888,0.0697321,0.0627246,0.057707,0.054036,0.0503907,0.0467025,0.0436834,0.0407929,
0.0378166,0.0350548,0.0325159,0.0297455,0.0271724,0.0249938,0.0228581,0.0209368,0.0192643,0.0175917,0.0158162,
0.0138006,0.0119994,0.0104813,0.00908319,0.0079167,0.00687029,0.00584103,0.00524921,0.00446869,0.00373963,
0.00296769,0.00247879,0.00208424,0.00177547,0.00140665,0.00104641,0.000892022,0.000746211,0.000617554,
0.000523205,0.000454588,0.000368817,0.000317354,0.000291623,0.00024016,0.00024016,0.00024016,0.00024016,
0.00024016,0.00024016,0.000248737,0.000291623,0.000308777,0.000334508,0.000368817,0.000403126,0.000463165,
0.000506051,0.000548937,0.000626131,0.000711902,0.000771942,0.000857714,0.000994948,0.00108072,0.00130373,
0.001501,0.00173258,0.00187839,0.00208424,0.00234156,0.00266749,0.003002,0.00354236,0.0043143,0.00526636,
0.00623558,0.00777089,0.00949489,0.0116735,0.0142037,0.0168712,0.0190927,0.0208939,0.0224121,0.0232869,
0.0236557,0.0236815,0.02357,0.023407,0.0230811,0.0228066,0.0224035,0.0218202,0.021014,0.0200448,0.0186553,
0.0172915,0.0154989,0.0136462,0.0119737,0.0105756,0.00928046,0.00823405,0.00741065,0.00679309,0.00619269,
0.00579815,0.00557514,0.00539502,0.00524921,0.00504336,0.00481177,0.00458877,0.00430572,0.00402268,0.00365386,
0.0031907,0.00290765,0.00261603,0.00234156,0.0021014,0.00193843,0.00181835,0.00173258,0.0016897,0.00173258,
0.00180978,0.00194701,0.00217859,0.00255599,0.00299342,0.00378252,0.00455446,0.0054036,0.00629562,0.00747926,
0.00886018,0.0106271,0.0129858,0.0163652,0.0201649,0.0247279,0.0298742,0.0360154,0.0437949,0.0530153,
0.0622271,0.0739692,0.0864404,0.101691,0.119454,0.14582,0.182642,0.209265,0.228315,0.244466,0.257391,
0.267281,0.273671,0.275849,0.274546,0.270643,0.264853,0.258395,0.250804,0.243128,0.233839,0.222174,0.208999,
0.179159,0.157802,0.144002,0.132954,0.123528,0.116066,0.109256,0.101442,0.093405,0.0851195,0.0774344,
0.0701353,0.0633851,0.0585819,0.054868,0.0518745,0.0485294,0.0451329,0.0422253,0.0392147,0.0363413,0.0337425,
0.0312465,0.0288449,0.0265377,0.0246078,0.022738,0.0208768,0.0191013,0.0173172,0.0152502,0.0132688,0.0115019,
0.00988086,0.00864576,0.00755646,0.00656151,0.00569522,0.00506909,0.00438292,0.00359382,0.00293338,0.00247879,
0.00208424,0.0018012,0.00144954,0.00106357,0.000909177,0.000746211,0.000626131,0.00054036,0.000471743,
0.000411703,0.000368817,0.000343086,0.000334508,0.000317354,0.000317354,0.000317354,0.000334508,0.000334508,
0.00036024,0.000377394,0.000411703,0.000463165,0.000506051,0.00054036,0.0006004,0.00066044,0.000754788,
0.000814828,0.000977794,0.00108072,0.00133803,0.00159535,0.00180978,0.0019899,0.00226436,0.00255599,0.00291623,
0.00335366,0.00404841,0.00464881,0.00528352,0.00605546,0.00718764,0.00862002,0.010567,0.0130115,0.0161336,
0.0190584,0.021906,0.0243677,0.0262804,0.0275412,0.0283903,0.0285276,0.0282788,0.0276956,0.0271724,0.0265977,
0.0261174,0.0255256,0.0245907,0.0235271,0.0222148,0.0206537,0.018844,0.0169827,0.0148899,0.0129858,0.0113819,
0.00991517,0.00879157,0.00793385,0.00719622,0.00669017,0.00623558,0.00589249,0.00566091,0.0055151,0.00530067,
0.00512913,0.00490612,0.00462308,0.00427141,0.00394548,0.00344801,0.00307919,0.00283046,0.00253026,0.0022901,
0.00208424,0.00192128,0.00184408,0.00180978,0.00184408,0.0019127,0.00208424,0.00234156,0.00279615,0.00326789,
0.00410845,0.00501763,0.00573811,0.00691317,0.00815686,0.00981225,0.0118279,0.0145211,0.0181492,0.0221633,
0.0268464,0.0325674,0.0391203,0.04714,0.0563346,0.0666015,0.0789097,0.092513,0.108475,0.127336,0.153745,
0.186055,0.206761,0.222011,0.235683,0.247931,0.258078,0.264999,0.267933,0.267204,0.263567,0.258138,0.251259,
0.243239,0.234482,0.224395,0.212516,0.197214,0.168987,0.14998,0.13732,0.127954,0.119951,0.114265,0.107995,
0.10091,0.093405,0.0856342,0.0785752,0.0717049,0.0653235,0.0601686,0.0564204,0.0536071,0.0504679,0.0468054,
0.0436147,0.0404412,0.0374649,0.0346688,0.0323444,0.0300114,0.0280129,0.0261517,0.0242733,0.0225493,0.0206452,
0.0185952,0.0165968,0.0144439,0.0125741,0.010893,0.00946916,0.00829409,0.00728199,0.00638139,0.00563518,
0.00506909,0.00440865,0.00368817,0.00299342,0.00256456,0.00216144,0.00186982,0.00152673,0.00113218,0.000943485,
0.000771942,0.00066044,0.000574668,0.00054036,0.000497474,0.000463165,0.000454588,0.000446011,0.000411703,
0.000411703,0.000446011,0.000454588,0.000454588,0.000471743,0.000506051,0.00054036,0.000574668,0.000643285,
0.000737634,0.00078052,0.000917754,0.00102926,0.00123511,0.00156104,0.00181835,0.00201563,0.00229867,
0.00266749,0.00305346,0.00365386,0.00430572,0.00499189,0.00554941,0.00623558,0.00711902,0.00827694,0.00977794,
0.0117335,0.0144267,0.0178319,0.0210569,0.0244534,0.0273782,0.0299599,0.0319413,0.0331163,0.0335109,0.0334851,
0.0330134,0.0321643,0.0311865,0.0300886,0.0292223,0.0281673,0.0269322,0.0258343,0.0241189,0.0222577,0.0202678,
0.0182093,0.0160564,0.0138692,0.0119994,0.010567,0.0093405,0.00839702,0.00773658,0.00706756,0.00672448,
0.0063042,0.00602115,0.00572953,0.00557514,0.0054036,0.00518917,0.0049147,0.00454588,0.00417707,0.00381683,
0.0033022,0.00297627,0.0027018,0.00245306,0.00225579,0.00208424,0.00198132,0.00193843,0.00198132,0.00208424,
0.0022901,0.00256456,0.00299342,0.00375679,0.00453731,0.00536929,0.00629562,0.007505,0.0089288,0.0107643,
0.0131745,0.0164338,0.0201477,0.0244963,0.0296254,0.0354064,0.0426026,0.0509053,0.0596368,0.0707099,0.0832754,
0.0978995,0.114282,0.135176,0.161173,0.188954,0.20417,0.215303,0.225176,0.236009,0.246636,0.254304,0.258987,
0.259707,0.257503,0.252785,0.246215,0.238196,0.228752,0.21828,0.205766,0.190301,0.162828,0.146763,0.135442,
0.127096,0.120492,0.115465,0.109787,0.102977,0.0957466,0.0881644,0.0813284,0.0751186,0.0684799,0.0630334,
0.0587706,0.0554169,0.0523291,0.0489755,0.0450557,0.0418221,0.0384084,0.0356809,0.0333565,0.0312122,0.0292566,
0.0273096,0.0257829,0.0238016,0.0219317,0.0199676,0.0179005,0.0158506,0.0136205,0.0118536,0.0103526,0.00910034,
0.00811397,0.00718764,0.00645001,0.0057038,0.00524921,0.00454588,0.00389402,0.0031907,0.00279615,0.00229867,
0.00194701,0.00162108,0.00118365,0.000994948,0.000806251,0.000746211,0.00066044,0.000608977,0.000557514,
0.000548937,0.00054036,0.00054036,0.00054036,0.00054036,0.00054036,0.00054036,0.000557514,0.000574668,
0.000643285,0.000711902,0.000763365,0.00084056,0.000977794,0.00109787,0.00140665,0.00173258,0.00198132,
0.0022901,0.00261603,0.00303631,0.00373963,0.00439149,0.00504336,0.00560945,0.00639855,0.00728199,0.00827694,
0.0094177,0.0109702,0.0130544,0.016125,0.0194615,0.0231583,0.0268379,0.0304317,0.0335538,0.0359039,0.0377308,
0.0387772,0.0390774,0.0386915,0.0377909,0.0365386,0.0349947,0.0336738,0.0322758,0.0308091,0.029471,0.0276784,
0.0259887,0.0236729,0.0214,0.0190584,0.0168198,0.0144439,0.0125912,0.0110216,0.00982082,0.00879157,0.00812255,
0.007505,0.00703325,0.00675879,0.00637281,0.00608977,0.0058153,0.00560945,0.0054036,0.00513771,0.00481177,
0.00443438,0.00402268,0.00354236,0.00312208,0.00289907,0.0026246,0.0024016,0.0022901,0.00216144,0.00210998,
0.00216144,0.0022901,0.00248737,0.00286476,0.00331078,0.00409987,0.00494043,0.00569522,0.00687029,0.00813113,
0.00981225,0.0119136,0.0147098,0.0183465,0.0223434,0.0269665,0.032576,0.0387772,0.0459134,0.054096,0.0624073,
0.0739778,0.0868092,0.102197,0.118913,0.14172,0.167674,0.189984,0.200594,0.20827,0.215681,0.225021,0.235751,
0.244886,0.250924,0.2533,0.252228,0.247896,0.241215,0.232629,0.223889,0.213888,0.20098,0.184743,0.160753,
0.146386,0.136351,0.129206,0.123193,0.117884,0.112746,0.106614,0.0997092,0.092513,0.0853082,0.0788067,
0.0725111,0.0666272,0.0617811,0.0577842,0.0545163,0.0509911,0.0468998,0.0432116,0.0398494,0.0367702,0.0343686,
0.0322586,0.0301744,0.028519,0.0266063,0.0249681,0.0229181,0.0208939,0.0189297,0.0168369,0.0146669,0.0128657,
0.0113561,0.010061,0.009006,0.00813113,0.00734203,0.00663013,0.00591823,0.0054036,0.00487181,0.00423711,
0.00353378,0.0029248,0.00246164,0.00204994,0.00173258,0.00132946,0.00104641,0.000917754,0.000789097,0.000754788,
0.00072048,0.000686171,0.00066044,0.000651863,0.000643285,0.000643285,0.000643285,0.000643285,0.00066044,
0.000703325,0.000746211,0.00078052,0.000917754,0.00102068,0.00114934,0.00150958,0.00183551,0.00208424,
0.00247879,0.00290765,0.0034137,0.00418564,0.00493185,0.00554941,0.00628704,0.00717049,0.00815686,0.00928904,
0.0106271,0.0122567,0.0144868,0.0175917,0.0209368,0.0251567,0.0294796,0.0336481,0.0374735,0.0406642,0.0429028,
0.0442752,0.0448842,0.0449185,0.0442923,0.0431687,0.0416077,0.0395406,0.0374907,0.0355008,0.0338969,0.0321042,
0.0299599,0.0276012,0.0251482,0.0224635,0.0198904,0.0173944,0.0149156,0.0129086,0.0113561,0.010061,0.0091175,
0.00841417,0.00789954,0.00739349,0.00698179,0.0067159,0.00637281,0.00609835,0.00578957,0.00556656,0.00530067,
0.00499189,0.00457161,0.00417707,0.00381683,0.00331935,0.00303631,0.00284761,0.00261603,0.00247879,0.00236729,
0.00234156,0.00236729,0.00253026,0.0028133,0.00310492,0.0038254,0.00452015,0.00528352,0.0061155,0.00737634,
0.00875726,0.0106785,0.0132688,0.0165968,0.0203879,0.0248737,0.0298656,0.0356981,0.0424225,0.0496445,
0.056592,0.0650319,0.0764309,0.0890135,0.104538,0.122138,0.145297,0.171388,0.189958,0.197857,0.203072,
0.209394,0.217885,0.228152,0.238127,0.245092,0.248257,0.247382,0.24227,0.234696,0.226299,0.217885,0.208802,
0.196579,0.18096,0.159054,0.146506,0.137749,0.131565,0.126101,0.12086,0.116032,0.110516,0.103981,0.0970503,
0.0900342,0.0829924,0.0767654,0.0707014,0.0651348,0.0606232,0.0567292,0.0532898,0.0494129,0.0450643,0.0415562,
0.0382626,0.0356037,0.033408,0.0313323,0.0294367,0.0274726,0.0258686,0.0237673,0.0217945,0.0198303,0.0178233,
0.0159192,0.0139722,0.0124454,0.0112017,0.0100696,0.00913465,0.00830267,0.00762508,0.00693033,0.00628704,
0.00566091,0.00524921,0.00458877,0.00388544,0.00307919,0.00256456,0.00209282,0.00179262,0.00143238,0.00110645,
0.000994948,0.000917754,0.00084056,0.000806251,0.00078052,0.00078052,0.000771942,0.000771942,0.000763365,
0.000763365,0.000771942,0.00078052,0.000849137,0.000952062,0.00104641,0.00128657,0.00158677,0.00187839,
0.00217859,0.00261603,0.00309635,0.00386829,0.00456304,0.00528352,0.00593538,0.00689602,0.00789954,0.00898884,
0.0103011,0.0118708,0.0137234,0.0161164,0.018844,0.0225236,0.0267607,0.0318726,0.0366673,0.041642,0.0454674,
0.048478,0.050365,0.0513084,0.0515743,0.0512141,0.050262,0.0486667,0.0464795,0.0443095,0.0420537,0.0396006,
0.0374221,0.0350977,0.0327561,0.0298141,0.0266835,0.0236729,0.0206623,0.0179176,0.0153273,0.0131488,0.0115191,
0.0102668,0.0093405,0.00862002,0.00807966,0.00762508,0.00719622,0.00689602,0.00659582,0.00629562,0.00595253,
0.00566091,0.0054036,0.00506909,0.00469169,0.00427141,0.00389402,0.0034909,0.00317354,0.00299342,0.00286476,
0.00274468,0.0026246,0.00261603,0.00266749,0.00284761,0.00306204,0.00357667,0.00423711,0.00496616,0.00560945,
0.00668159,0.00795101,0.00956351,0.0117678,0.0148384,0.0185352,0.0227637,0.0276012,0.0332879,0.0393691,
0.0459735,0.0530239,0.0595253,0.0679738,0.0782921,0.0904888,0.10567,0.123262,0.145991,0.170668,0.188182,
0.195053,0.198955,0.205182,0.214171,0.224472,0.233839,0.240735,0.242947,0.240958,0.235056,0.22726,0.219309,
0.211967,0.203089,0.192411,0.177392,0.157639,0.14642,0.138366,0.132422,0.128048,0.123494,0.118673,0.113913,
0.108252,0.101313,0.094237,0.0872552,0.0806165,0.0747926,0.0691317,0.0638225,0.059654,0.0556227,0.0519603,
0.0473715,0.0435547,0.040201,0.0371219,0.0345316,0.0323701,0.0302087,0.0283989,0.0264004,0.0244963,0.0225407,
0.0205508,0.0185609,0.0168712,0.0151987,0.0137063,0.0124454,0.0113819,0.0103526,0.00945201,0.00866291,
0.00801962,0.00735061,0.00679309,0.00606404,0.00548079,0.00485466,0.0040913,0.00321643,0.00266749,0.00216144,
0.00185266,0.00154388,0.00125226,0.00108072,0.00102926,0.000994948,0.000969217,0.000943485,0.000943485,
0.000934908,0.000917754,0.000917754,0.000917754,0.000952062,0.00100353,0.00110645,0.00133803,0.00162108,
0.00188697,0.00223863,0.00269322,0.00321643,0.00407414,0.00482035,0.00553225,0.0063042,0.00733345,0.00839702,
0.00970074,0.011176,0.0129343,0.0151644,0.0175831,0.0202678,0.0237415,0.0285361,0.033974,0.0399952,0.0455618,
0.0505708,0.0541046,0.0559229,0.0570637,0.0575783,0.0572267,0.0564719,0.0554255,0.0541389,0.0521576,0.0499018,
0.0470113,0.0443781,0.0419079,0.0390517,0.0358782,0.0325931,0.0289736,0.0252768,0.0216144,0.0184151,0.0156962,
0.0133203,0.0116134,0.0103955,0.0094177,0.00869722,0.00814828,0.00776231,0.00733345,0.00696464,0.0067159,
0.00636424,0.00603831,0.00569522,0.00542933,0.00508624,0.00471743,0.0043143,0.00400552,0.00366244,0.00333651,
0.00313923,0.00302773,0.00293338,0.00289907,0.00289907,0.00296769,0.00312208,0.00353378,0.0040913,0.00473458,
0.00536929,0.00609835,0.00717049,0.00855998,0.010447,0.0130458,0.0167769,0.0207824,0.0256028,0.0307748,
0.0367102,0.0434604,0.0502363,0.056206,0.062596,0.0706327,0.0799389,0.0915095,0.105756,0.122473,0.143899,
0.165367,0.182873,0.19073,0.195044,0.20128,0.210526,0.220287,0.229027,0.234799,0.235683,0.2316,0.224995,
0.217679,0.211238,0.204556,0.196837,0.187573,0.173335,0.156593,0.146506,0.138864,0.132886,0.128734,0.12496,
0.120603,0.116435,0.111288,0.104761,0.0978652,0.0910892,0.0841675,0.0783693,0.072777,0.0677079,0.0626646,
0.0584532,0.0545763,0.0503135,0.0459134,0.042311,0.0387772,0.0357752,0.0333822,0.0311607,0.0291108,0.0269665,
0.0251825,0.0231583,0.0213142,0.0195559,0.0179691,0.0165024,0.015173,0.0139207,0.0128228,0.0117593,0.0108072,
0.00986371,0.00910892,0.00841417,0.0078395,0.00709329,0.00642428,0.00564376,0.00504336,0.00423711,0.00331935,
0.00276184,0.00226436,0.00190412,0.00168112,0.00147527,0.00132946,0.00119222,0.00114934,0.00112361,0.00109787,
0.00106357,0.00104641,0.00104641,0.00104641,0.00110645,0.0012008,0.00143238,0.00168112,0.00190412,0.00223863,
0.00269322,0.00321643,0.00409987,0.00494043,0.00560945,0.00653578,0.00759077,0.00872295,0.0101725,0.0119222,
0.0139722,0.0163995,0.018844,0.0215629,0.0250452,0.0295654,0.035415,0.0425683,0.0494901,0.0548937,0.0589421,
0.0620299,0.0635652,0.06438,0.0642256,0.0634537,0.0622786,0.0607176,0.0591565,0.0572953,0.0553054,0.0531182,
0.0503221,0.0469856,0.0437949,0.0401839,0.0358267,0.0315724,0.0270609,0.022901,0.0192299,0.0161336,0.0135433,
0.0117164,0.0104298,0.00942628,0.00869722,0.00813113,0.00773658,0.00729057,0.00693891,0.00663871,0.00629562,
0.00593538,0.00563518,0.00536071,0.00504336,0.00464881,0.00429715,0.0040141,0.00377394,0.00347374,0.00331935,
0.0031907,0.00313923,0.00312208,0.00316496,0.00331935,0.00368817,0.0040913,0.00464881,0.00526636,0.00577241,
0.0067159,0.00788239,0.0093405,0.0115191,0.014624,0.0186982,0.0233727,0.0285104,0.0341799,0.0409215,0.047646,
0.0543533,0.0598942,0.0662412,0.0739692,0.0823148,0.0930877,0.106374,0.121332,0.140828,0.158694,0.174811,
0.183774,0.189649,0.195936,0.205036,0.214566,0.221753,0.225656,0.224687,0.219309,0.212541,0.20532,0.199727,
0.195173,0.189984,0.181458,0.169476,0.155581,0.146738,0.13949,0.133846,0.129712,0.126376,0.122696,0.118347,
0.113561,0.107317,0.100224,0.093405,0.0871952,0.0815,0.0764823,0.0711902,0.0660869,0.0614209,0.0571066,
0.0531354,0.0488125,0.0444467,0.0408014,0.0373449,0.0344201,0.0320528,0.0297712,0.0277042,0.0259973,0.0239903,
0.0222405,0.0205937,0.0191013,0.0179176,0.0168112,0.0157047,0.0144868,0.0133975,0.0124111,0.0114162,0.0104984,
0.00976078,0.00896311,0.00823405,0.00749642,0.00675879,0.00582388,0.00519775,0.00435719,0.0034137,0.00283046,
0.00233298,0.00201563,0.00184408,0.00173258,0.00162108,0.00154388,0.00149242,0.00144954,0.00140665,0.00134661,
0.00133803,0.00137234,0.00146669,0.00159535,0.00176689,0.00193843,0.00223863,0.0026246,0.00313923,0.00404841,
0.00488897,0.00560945,0.00656151,0.00770227,0.00893738,0.0105241,0.0125312,0.0148642,0.0176689,0.0202849,
0.0231154,0.0263575,0.0305003,0.0363242,0.0439407,0.0521747,0.0586076,0.0643457,0.0693719,0.0722538,0.0736948,
0.0737548,0.0727599,0.0713018,0.0695692,0.0677165,0.065658,0.063548,0.0614466,0.058985,0.0561888,0.0532469,
0.0494644,0.0447555,0.0400038,0.0346688,0.0296597,0.0248222,0.0203707,0.0167168,0.0138521,0.011845,0.0104298,
0.00940054,0.00862002,0.00805393,0.00754788,0.00711045,0.0068274,0.00647574,0.00610692,0.00573811,0.00553225,
0.00525779,0.00488897,0.00451157,0.00419422,0.00394548,0.00377394,0.00356809,0.0034137,0.00336224,0.00335366,
0.0034137,0.0036024,0.00386829,0.00419422,0.00464881,0.00523205,0.00566091,0.00637281,0.00733345,0.00855998,
0.0103097,0.0128743,0.0165367,0.020851,0.0260917,0.0316153,0.0377994,0.0448155,0.0520804,0.0579643,0.0638825,
0.0709415,0.0782321,0.0861488,0.0965357,0.109101,0.122876,0.139704,0.154732,0.167014,0.175737,0.181312,
0.188165,0.19597,0.205011,0.211324,0.213133,0.210389,0.203861,0.195799,0.189984,0.186733,0.184563,0.18169,
0.175746,0.16577,0.155366,0.147287,0.141111,0.135965,0.132028,0.128777,0.125063,0.120131,0.115345,0.109178,
0.102119,0.0954292,0.0894338,0.0841417,0.0793385,0.074664,0.0696121,0.0644829,0.0599027,0.0556313,0.0514714,
0.0467711,0.0428342,0.0390346,0.0357066,0.0331678,0.0307748,0.0288449,0.0267178,0.0251139,0.0234156,0.0218717,
0.0205508,0.0194444,0.0184408,0.0175574,0.016511,0.0154903,0.0142724,0.0132002,0.0121281,0.0112532,0.0103355,
0.00950347,0.0086286,0.00784808,0.00693033,0.00599542,0.00528352,0.00443438,0.0035252,0.00289907,0.00247879,
0.00217859,0.00201563,0.00193843,0.00187839,0.00183551,0.00177547,0.00174116,0.00173258,0.00169827,0.00173258,
0.00178404,0.00187839,0.00201563,0.00228152,0.00261603,0.00306204,0.00388544,0.00474316,0.00553225,0.00649289,
0.0076165,0.0089288,0.0106271,0.0128743,0.0157905,0.0185952,0.0217173,0.0250109,0.0283474,0.0322329,0.0374992,
0.0448584,0.0537701,0.061601,0.0700152,0.0767911,0.0814828,0.0839959,0.0847679,0.0837986,0.0821175,0.0799904,
0.0780348,0.0761478,0.0743038,0.0720051,0.0695692,0.0662241,0.0626303,0.0588563,0.0548251,0.0500905,0.044258,
0.0382197,0.0324645,0.0267521,0.0217859,0.0177204,0.0143152,0.0119908,0.010447,0.00928046,0.00841417,
0.00783093,0.00728199,0.00688744,0.00651005,0.0061155,0.00577241,0.00553225,0.00528352,0.00496616,0.00460592,
0.00427141,0.0040141,0.0038254,0.00366244,0.00356809,0.00353378,0.00355094,0.00365386,0.00384256,0.00404841,
0.00430572,0.00471743,0.00524921,0.00563518,0.00628704,0.00703325,0.00811397,0.00946916,0.0115191,0.0144267,
0.0184408,0.0231926,0.0287677,0.0346431,0.0415134,0.0488125,0.0554169,0.0616868,0.0685313,0.0759248,0.083061,
0.0917325,0.101673,0.113639,0.127628,0.142758,0.155083,0.163575,0.169038,0.172778,0.177693,0.184443,0.191528,
0.196245,0.196279,0.191699,0.183414,0.174639,0.169519,0.169596,0.171774,0.172915,0.170359,0.163206,0.156636,
0.150229,0.144293,0.139816,0.136033,0.132165,0.127928,0.122447,0.116778,0.110637,0.103861,0.0974534,0.0918869,
0.0865862,0.0819974,0.0775888,0.0727084,0.0678623,0.0626303,0.058093,0.0539845,0.0494987,0.0449185,0.041033,
0.037362,0.0344544,0.0321385,0.0299342,0.0280472,0.0263575,0.024848,0.0233984,0.022129,0.0210569,0.0202678,
0.0194101,0.0184752,0.0176003,0.0165024,0.0153617,0.0141609,0.0130458,0.0119651,0.0109959,0.00994948,
0.009006,0.00807966,0.00704183,0.00608977,0.00530067,0.00448584,0.00365386,0.00299342,0.00266749,0.00244448,
0.00229867,0.00218717,0.00209282,0.00205851,0.0019899,0.00197274,0.00194701,0.00198132,0.00204994,0.00216144,
0.00235871,0.00266749,0.00306204,0.0038254,0.00460592,0.0054036,0.00629562,0.00746211,0.00872295,0.0104727,
0.0128571,0.0160478,0.0194272,0.0229953,0.0266492,0.0304488,0.0345058,0.0396006,0.0462651,0.0548079,0.0635051,
0.0741065,0.0831639,0.0913379,0.0967072,0.0987829,0.0985856,0.0968102,0.0938082,0.0907375,0.0876584,0.0854798,
0.0834727,0.0814828,0.0786095,0.0752129,0.0704955,0.065212,0.0600142,0.0547908,0.048761,0.0420537,0.0352006,
0.029188,0.0234585,0.0187153,0.0150271,0.0123682,0.0104984,0.00914323,0.00815686,0.00749642,0.00693891,
0.00649289,0.00606404,0.00569522,0.00547221,0.0052149,0.00488897,0.00454588,0.00423711,0.00395406,0.00377394,
0.00354236,0.00347374,0.00347374,0.00355094,0.00374821,0.00386829,0.00408272,0.00440007,0.00476031,0.00524921,
0.0056266,0.00623558,0.00695606,0.00788239,0.00898884,0.0105928,0.0129,0.0163223,0.0204222,0.0256285,
0.0312551,0.0374992,0.044421,0.0519946,0.0583074,0.0650319,0.0727084,0.0803421,0.0885761,0.0978995,0.108801,
0.120183,0.135407,0.149337,0.160332,0.166671,0.168223,0.168112,0.169218,0.17162,0.174802,0.176869,0.174313,
0.165685,0.157073,0.152527,0.15209,0.155401,0.160761,0.165324,0.166165,0.16258,0.160538,0.155504,0.150829,
0.146206,0.141977,0.136728,0.131711,0.125484,0.118708,0.112523,0.105979,0.099632,0.0941255,0.0893824,
0.0849566,0.0808224,0.0764823,0.0713275,0.0659067,0.0607862,0.0562317,0.0520804,0.0473201,0.0431687,0.0393691,
0.036247,0.033751,0.0315553,0.0295997,0.0277985,0.0263147,0.025071,0.0238187,0.0228924,0.0221033,0.0213742,
0.0205508,0.0196931,0.0185524,0.0176089,0.0164338,0.0152502,0.0139979,0.01284,0.0116306,0.0104727,0.00931477,
0.00818259,0.00711902,0.0061155,0.00530067,0.00453731,0.00385971,0.0031907,0.00291623,0.00277042,0.00261603,
0.00249595,0.00238444,0.00231583,0.0022901,0.00228152,0.00229867,0.00235871,0.00255599,0.00283903,0.00315639,
0.00386829,0.00457161,0.00530067,0.00613265,0.00728199,0.00852568,0.0101039,0.0124369,0.0157905,0.019573,
0.0237072,0.028133,0.0326017,0.0371905,0.0423882,0.0488811,0.056206,0.065212,0.0766625,0.0880186,0.0997435,
0.109916,0.116032,0.117961,0.116572,0.113347,0.109136,0.104435,0.100584,0.0977279,0.0953778,0.0929076,
0.0890736,0.0842532,0.0787467,0.0726055,0.0658467,0.0591908,0.0530067,0.045536,0.038194,0.0313409,0.0251396,
0.0199676,0.0159535,0.0127456,0.0105756,0.00905746,0.00800247,0.00711045,0.00653578,0.00599542,0.00560945,
0.00530067,0.00504336,0.00469169,0.00439149,0.00407414,0.00381683,0.00347374,0.00331935,0.003225,0.00326789,
0.00335366,0.00350805,0.0037911,0.00403126,0.00430572,0.00470885,0.00514628,0.00557514,0.00614123,0.00689602,
0.00773658,0.00867149,0.00997521,0.0118879,0.0144696,0.0181321,0.0224292,0.027524,0.033408,0.0398751,
0.0466082,0.054096,0.0603573,0.0680767,0.0762936,0.0847078,0.0942971,0.104727,0.116066,0.130218,0.145528,
0.1595,0.171208,0.175677,0.174691,0.171174,0.166748,0.16336,0.160521,0.156687,0.15167,0.145545,0.141283,
0.139584,0.141703,0.146738,0.153548,0.159878,0.163703,0.163875,0.167812,0.165041,0.160753,0.154869,0.148376,
0.142543,0.136471,0.130072,0.122284,0.115543,0.108955,0.102402,0.0970846,0.0928733,0.088679,0.0847764,
0.080445,0.075719,0.0700838,0.0641484,0.0592852,0.0548422,0.050485,0.0458705,0.0421223,0.0387172,0.0358782,
0.0335195,0.0314609,0.0296254,0.0280472,0.0266577,0.0258686,0.0249166,0.0241189,0.0233984,0.0225665,0.021623,
0.0207052,0.0197103,0.0185524,0.0174716,0.0162623,0.0148642,0.0135176,0.0121023,0.0108158,0.00954636,
0.00829409,0.00711902,0.00609835,0.00530067,0.00464023,0.00404841,0.00354236,0.00321643,0.00306204,0.0029248,
0.00283903,0.00271895,0.00264176,0.00261603,0.00268464,0.00283046,0.00299342,0.00336224,0.00404841,0.00470885,
0.00536929,0.0061155,0.00716191,0.00837986,0.00985513,0.0119308,0.0149585,0.0190069,0.0236043,0.0287677,
0.0339054,0.0392747,0.0448756,0.0514371,0.0580844,0.067099,0.0785237,0.0916381,0.106219,0.120852,0.136437,
0.146472,0.149011,0.145151,0.138221,0.130647,0.123476,0.117996,0.114265,0.111194,0.108115,0.103029,0.0965957,
0.0886361,0.0807023,0.0726312,0.0639426,0.0565405,0.0491727,0.041033,0.0333908,0.0265977,0.0209883,0.0165968,
0.0130544,0.0106614,0.00895453,0.00777089,0.00684456,0.00608977,0.00558372,0.00524921,0.00482035,0.00446869,
0.0040913,0.0038254,0.0034137,0.0031907,0.00306204,0.00299342,0.003002,0.00307062,0.00321643,0.0034137,
0.0038254,0.00409987,0.00452015,0.00500905,0.00546364,0.00596111,0.00680167,0.00754788,0.00841417,0.00965786,
0.0112189,0.0133203,0.0163823,0.0199676,0.0243848,0.0295311,0.0350977,0.0417449,0.0485123,0.0552368,0.0620728,
0.070324,0.0789954,0.0885504,0.0994519,0.111288,0.123897,0.140116,0.155649,0.171723,0.181244,0.184417,
0.182659,0.178199,0.170899,0.162177,0.154611,0.146309,0.138967,0.13316,0.13033,0.130853,0.134181,0.140322,
0.147741,0.155581,0.162751,0.167546,0.178001,0.178044,0.17379,0.164552,0.155598,0.149251,0.143513,0.136745,
0.129155,0.120414,0.113527,0.106785,0.10133,0.0972047,0.0934908,0.0896911,0.0852396,0.0801276,0.0746554,
0.0685828,0.0629734,0.0581015,0.0540617,0.0496359,0.0452273,0.0419422,0.0387772,0.0360326,0.0337425,0.0317869,
0.0300972,0.0289564,0.0277299,0.026795,0.0262117,0.025517,0.0245649,0.0236129,0.0226951,0.0216144,0.0206023,
0.0195301,0.0183036,0.0170428,0.0156361,0.0140065,0.0124883,0.0109444,0.00952062,0.00815686,0.00703325,
0.00608119,0.00536929,0.0048032,0.00429715,0.00399695,0.00374821,0.00340512,0.00321643,0.00308777,0.00303631,
0.00303631,0.00307919,0.00328504,0.00378252,0.00427141,0.00493185,0.00553225,0.00626131,0.00726484,0.00838844,
0.0098294,0.0116821,0.0142895,0.0182007,0.0228066,0.0283646,0.0341542,0.0405098,0.0467883,0.0535642,0.0599199,
0.0688401,0.0801276,0.0939111,0.111031,0.132268,0.157708,0.183191,0.193818,0.196193,0.19326,0.184469,
0.171809,0.159603,0.150795,0.143676,0.13696,0.130312,0.121778,0.112832,0.102042,0.0908319,0.0801962,0.0702382,
0.0604345,0.0524063,0.043529,0.0349947,0.0280129,0.0220175,0.0173172,0.0133718,0.0107729,0.00886018,0.00753073,
0.00651005,0.00569522,0.00525779,0.00473458,0.00427141,0.00386829,0.0034137,0.00312208,0.00295054,0.00284761,
0.00277899,0.00277042,0.00282188,0.00290765,0.00306204,0.00331935,0.00381683,0.00421995,0.00470885,0.00526636,
0.00572095,0.00649289,0.00727341,0.00814828,0.00920327,0.0106271,0.0125569,0.0151043,0.018235,0.0219317,
0.0263318,0.0314095,0.0369417,0.0431859,0.0500562,0.0564719,0.0635051,0.0721166,0.0814571,0.0921442,0.10374,
0.116203,0.13129,0.147432,0.163678,0.178705,0.186381,0.189212,0.18838,0.184048,0.176106,0.164244,0.153008,
0.141883,0.132139,0.125724,0.123382,0.124857,0.1293,0.136085,0.144851,0.154792,0.164878,0.174013,0.187522,
0.188234,0.184314,0.176123,0.165762,0.158454,0.153008,0.146823,0.139524,0.130896,0.121135,0.114007,0.108183,
0.103483,0.0997864,0.0961068,0.0916381,0.0856513,0.0796559,0.0736605,0.0677765,0.0622014,0.0576469,0.0537358,
0.0495844,0.0455703,0.0423882,0.0393262,0.0365472,0.0344201,0.0327475,0.0313923,0.0301572,0.0292566,0.0283131,
0.0272667,0.026409,0.0255856,0.0244277,0.023407,0.0223606,0.021297,0.0201649,0.0188697,0.0175488,0.0160049,
0.0141694,0.0124454,0.0108072,0.00928046,0.00807109,0.00695606,0.00606404,0.00547221,0.00503478,0.00464023,
0.00430572,0.00407414,0.00386829,0.00374821,0.00357667,0.00359382,0.00380825,0.00407414,0.00453731,0.00514628,
0.00569522,0.0065272,0.00747926,0.00855998,0.00988086,0.0117078,0.0140322,0.017403,0.0216144,0.0270008,
0.0334165,0.0403554,0.0474916,0.0546535,0.0610864,0.0701267,0.0810197,0.0951719,0.11393,0.141609,0.180523,
0.205783,0.219103,0.225982,0.228409,0.227277,0.222834,0.217053,0.211692,0.205508,0.198363,0.190395,0.177958,
0.158102,0.138461,0.118759,0.103252,0.0889707,0.0767139,0.0648174,0.0552539,0.0458362,0.0366758,0.0292137,
0.0227809,0.0177804,0.0137063,0.0108501,0.00880872,0.00739349,0.00623558,0.00547221,0.00485466,0.00426284,
0.00380825,0.00323358,0.00296769,0.00278757,0.00257314,0.00247879,0.00244448,0.00247879,0.00256456,0.00275326,
0.00293338,0.00321643,0.00380825,0.00427999,0.00488897,0.00547221,0.00608977,0.00693891,0.00789954,0.00886876,
0.0101811,0.0119222,0.0141866,0.0170685,0.0202849,0.024076,0.0284933,0.0334165,0.038863,0.044867,0.0517459,
0.0580844,0.0655551,0.0745782,0.0837386,0.0949403,0.107291,0.119823,0.136068,0.152441,0.167752,0.1797,
0.186193,0.189092,0.189426,0.186416,0.179168,0.166345,0.152785,0.139704,0.129095,0.122327,0.120329,0.122138,
0.126899,0.134627,0.144928,0.156739,0.171122,0.181698,0.195336,0.196245,0.193097,0.18681,0.179442,0.173121,
0.168078,0.162365,0.155306,0.1463,0.135965,0.125689,0.11785,0.113072,0.109067,0.104392,0.0989716,0.0927532,
0.0855655,0.0792442,0.0730343,0.0672962,0.0620985,0.057707,0.0540789,0.0501505,0.0462222,0.043083,0.040201,
0.0375507,0.0356209,0.0341113,0.0329019,0.031581,0.0302945,0.0292909,0.0281673,0.0269579,0.0260316,0.024908,
0.0237673,0.0227809,0.0216401,0.0204565,0.0190927,0.0176346,0.0159363,0.0139207,0.0119994,0.0104298,0.00898884,
0.00789954,0.00691317,0.0061155,0.00557514,0.00526636,0.00493185,0.00464023,0.00443438,0.00423711,0.00415134,
0.00423711,0.00446869,0.00482893,0.00530067,0.00588392,0.00681883,0.00776231,0.00880872,0.0101811,0.0119565,
0.014238,0.0172829,0.0207824,0.0258172,0.031804,0.0387687,0.0464109,0.0544048,0.061155,0.0701353,0.0807109,
0.0948889,0.114273,0.14612,0.194083,0.221427,0.239071,0.249723,0.254681,0.256482,0.256414,0.256062,0.254681,
0.252562,0.248754,0.243453,0.236583,0.226574,0.21237,0.189555,0.14956,0.119342,0.0997607,0.0834127,0.0702382,
0.0581787,0.0480062,0.0380911,0.0299857,0.0233727,0.0180463,0.0138435,0.010893,0.00879157,0.00728199,
0.00606404,0.00528352,0.00453731,0.00389402,0.0033022,0.00293338,0.00267607,0.00245306,0.00229867,0.0022129,
0.00218717,0.00227294,0.00235871,0.00256456,0.00284761,0.00314781,0.00378252,0.00440007,0.00505193,0.00563518,
0.00651005,0.00746211,0.00845706,0.00982082,0.0114162,0.013449,0.0162194,0.019067,0.0224635,0.0263575,
0.0306633,0.0356466,0.0414104,0.0472429,0.0540188,0.0603487,0.0683512,0.0772629,0.0867406,0.0979938,0.110336,
0.123065,0.139027,0.154028,0.166928,0.176629,0.181913,0.18488,0.185678,0.184014,0.178104,0.165942,0.152279,
0.139061,0.128151,0.121761,0.119883,0.12195,0.127551,0.136299,0.148153,0.162743,0.179657,0.190189,0.204059,
0.205268,0.20236,0.197703,0.193423,0.190464,0.18904,0.186381,0.181321,0.172298,0.157939,0.145597,0.135716,
0.127791,0.121255,0.11562,0.108827,0.10061,0.0927618,0.085231,0.0788239,0.0727513,0.0671847,0.06221,0.0580243,
0.0544134,0.0506051,0.0467626,0.0437263,0.0410931,0.038803,0.0370275,0.0353378,0.0339226,0.0324559,0.0310407,
0.0296597,0.0284332,0.0270094,0.0260659,0.0249766,0.023853,0.0228238,0.0216659,0.0203964,0.0189383,0.0173087,
0.0153531,0.0133203,0.0115191,0.00988086,0.00868006,0.00774516,0.00689602,0.00620985,0.0057038,0.00542075,
0.00518059,0.00494043,0.00481177,0.00476031,0.00488039,0.00514628,0.00553225,0.00608977,0.00692175,0.00790812,
0.00901457,0.0104555,0.0122138,0.0145297,0.0174202,0.0205851,0.0247107,0.0300543,0.0366501,0.044421,0.0527494,
0.0600142,0.0687629,0.0790984,0.0925387,0.111777,0.143899,0.198089,0.232209,0.256911,0.273928,0.282737,
0.285636,0.285301,0.285765,0.288535,0.291846,0.294264,0.29423,0.291846,0.286434,0.275215,0.257537,0.233641,
0.202395,0.150134,0.11393,0.0920756,0.0757018,0.061215,0.050202,0.0391889,0.0304746,0.0235614,0.0181578,
0.0138435,0.0108844,0.00877441,0.00726484,0.00596111,0.00518917,0.00439149,0.0037139,0.00308777,0.0028133,
0.0025131,0.00229867,0.00216144,0.00208424,0.00207567,0.00209282,0.00226436,0.00247022,0.00279615,0.00309635,
0.00381683,0.00451157,0.00525779,0.00591823,0.00693891,0.00807109,0.00928904,0.0109015,0.0128657,0.0154131,
0.0182093,0.0212456,0.0248394,0.0288449,0.0333565,0.0384427,0.0443095,0.0507509,0.0567292,0.0634622,0.071722,
0.0803249,0.0900428,0.100979,0.112678,0.125329,0.14021,0.153291,0.163043,0.170514,0.174682,0.177221,0.178396,
0.178079,0.173867,0.163557,0.152279,0.14015,0.129463,0.123039,0.121006,0.123605,0.130673,0.141428,0.155392,
0.174768,0.190147,0.198775,0.214634,0.215646,0.21442,0.211298,0.208313,0.206812,0.20634,0.205294,0.202686,
0.197712,0.190327,0.179605,0.164956,0.152956,0.142655,0.131728,0.119711,0.110105,0.10031,0.0922042,0.084785,
0.0784637,0.072494,0.0670132,0.0621242,0.05787,0.0543447,0.050588,0.0469255,0.044258,0.0419679,0.0397722,
0.0376879,0.0358181,0.0341284,0.0325245,0.0308177,0.0294539,0.0280129,0.0266406,0.0257571,0.0246164,0.0235871,
0.0225665,0.0213828,0.0200019,0.0183379,0.0165196,0.0144439,0.0125741,0.0109101,0.00956351,0.00842275,
0.0076165,0.00689602,0.0063042,0.00584961,0.00558372,0.0054036,0.00530067,0.00530067,0.00546364,0.0057038,
0.00626131,0.00699037,0.00799389,0.00908319,0.0105156,0.0123768,0.0146669,0.0176089,0.0206795,0.0243333,
0.0289736,0.0346859,0.0421395,0.0503221,0.0579043,0.0661383,0.0764309,0.0882073,0.105996,0.13515,0.192334,
0.233984,0.269211,0.295671,0.311282,0.318178,0.317783,0.315544,0.31605,0.320142,0.328462,0.337939,0.34366,
0.344303,0.339054,0.326377,0.30707,0.280644,0.244517,0.200894,0.136128,0.101999,0.0807109,0.0642428,0.0520118,
0.0401496,0.0306461,0.0234671,0.0180291,0.0137835,0.0108672,0.00882588,0.00733345,0.00608119,0.00524921,
0.00441723,0.00368817,0.00307919,0.0028133,0.00247879,0.0022901,0.00208424,0.00203278,0.00201563,0.00208424,
0.00219575,0.00241875,0.00277042,0.00312208,0.00386829,0.00464023,0.0054036,0.00629562,0.00747069,0.0087058,
0.010284,0.0121452,0.0144868,0.0173859,0.0202678,0.0234928,0.0269837,0.0313237,0.036024,0.0418907,0.0480234,
0.0544391,0.0602372,0.0675535,0.075719,0.0834127,0.0929419,0.103149,0.114007,0.125835,0.139336,0.150717,
0.158377,0.162545,0.164895,0.166954,0.170076,0.171534,0.169596,0.162777,0.15378,0.14305,0.1328,0.12635,
0.124463,0.127902,0.136153,0.149628,0.169175,0.189315,0.201563,0.2102,0.227217,0.228744,0.228246,0.226179,
0.224224,0.222963,0.222963,0.222457,0.220861,0.217834,0.21406,0.208802,0.20128,0.191699,0.176406,0.154569,
0.135819,0.119651,0.108844,0.0990145,0.0912264,0.08367,0.0775974,0.0715591,0.0659239,0.0609749,0.0568493,
0.0533755,0.0499361,0.0466425,0.0442666,0.0419079,0.039472,0.0373449,0.0352006,0.0334594,0.0316411,0.0298913,
0.0284847,0.0268979,0.0259973,0.024908,0.023853,0.022901,0.0219146,0.0206537,0.019127,0.0174545,0.0155504,
0.0135261,0.011785,0.0103097,0.00913465,0.00823405,0.00749642,0.00691317,0.00644143,0.00608119,0.00582388,
0.00573811,0.00582388,0.00608977,0.00653578,0.00711902,0.00803678,0.00904888,0.010447,0.0121967,0.0145039,
0.0174287,0.0205851,0.0242133,0.0284246,0.0334594,0.0400038,0.0476117,0.0555027,0.0631964,0.0727084,0.0834984,
0.0987915,0.122078,0.174751,0.227371,0.270926,0.308374,0.338445,0.357418,0.363868,0.360429,0.355737,0.354562,
0.360823,0.375927,0.394334,0.407997,0.412029,0.404961,0.387266,0.359305,0.325039,0.285919,0.236858,0.174202,
0.113416,0.0858743,0.0671418,0.0531354,0.0404412,0.0304488,0.0230382,0.0177804,0.0136205,0.0109015,0.00898884,
0.00756504,0.00631277,0.00542933,0.00464881,0.00395406,0.00327647,0.00291623,0.00261603,0.00235871,0.0022129,
0.0021014,0.00208424,0.00216144,0.00229867,0.00250452,0.00284761,0.00323358,0.00404841,0.00485466,0.00561803,
0.00681883,0.00807966,0.00964928,0.0114591,0.0137234,0.0164938,0.0193157,0.0224121,0.0258515,0.0295139,
0.0338969,0.0390774,0.04503,0.0518402,0.0576041,0.0638053,0.0713875,0.0789011,0.0865262,0.0949661,0.104289,
0.114222,0.124857,0.137123,0.147544,0.154903,0.157734,0.15914,0.161293,0.16493,0.168472,0.168995,0.165333,
0.157794,0.148685,0.139481,0.13304,0.13165,0.135699,0.145897,0.163197,0.187376,0.203596,0.215492,0.222928,
0.243496,0.245349,0.245143,0.243822,0.242193,0.241627,0.241146,0.24022,0.239336,0.236892,0.234079,0.230794,
0.226179,0.218494,0.206186,0.186801,0.155332,0.132654,0.116658,0.105885,0.0969731,0.0889535,0.0819117,
0.0757619,0.0694577,0.063548,0.0588563,0.054928,0.0516515,0.0484094,0.0454931,0.0429286,0.0403211,0.037808,
0.0356637,0.0336738,0.0317611,0.0298399,0.0282874,0.0266577,0.0257228,0.0246078,0.0237072,0.022901,0.0220776,
0.0208853,0.0196931,0.0180978,0.0163652,0.0143324,0.0125998,0.0110817,0.00984655,0.00885161,0.00807966,
0.00746211,0.00693891,0.00663871,0.00647574,0.00645859,0.00658724,0.00689602,0.00740207,0.00813113,0.00904888,
0.010284,0.0119565,0.014238,0.0170428,0.0202249,0.0238444,0.0280558,0.0329791,0.0386829,0.0457933,0.0538215,
0.0608548,0.069715,0.0796044,0.0927618,0.112258,0.150134,0.214171,0.263189,0.310338,0.353953,0.39128,
0.415331,0.423145,0.419311,0.411591,0.409919,0.419482,0.43933,0.463397,0.486375,0.494798,0.485046,0.456338,
0.418736,0.370232,0.319884,0.266526,0.20544,0.124497,0.090506,0.0690288,0.0536157,0.0402782,0.0300114,
0.0226608,0.0175231,0.0135948,0.0110388,0.00928904,0.00801962,0.00688744,0.00583245,0.00519775,0.00451157,
0.00389402,0.00331935,0.00297627,0.00274468,0.0025131,0.00236729,0.00234156,0.00235871,0.0025131,0.00277042,
0.00303631,0.00361098,0.00438292,0.00523205,0.00608977,0.00737634,0.00883445,0.0106185,0.01284,0.0155332,
0.0183894,0.0213142,0.0244706,0.02785,0.0318812,0.0363156,0.0420194,0.0481435,0.0546192,0.0604946,0.0674849,
0.0748956,0.0816715,0.0888248,0.0965614,0.10453,0.113536,0.123039,0.134421,0.144782,0.152261,0.155821,
0.158411,0.161636,0.166868,0.171826,0.173593,0.172289,0.166971,0.158814,0.150297,0.144147,0.142921,0.14793,
0.161636,0.184923,0.203896,0.219077,0.230948,0.239242,0.265102,0.266895,0.265986,0.264193,0.2624,0.261182,
0.259759,0.258472,0.25758,0.255427,0.2539,0.252159,0.248445,0.241078,0.227946,0.209531,0.182015,0.147055,
0.125389,0.111854,0.101965,0.0932764,0.0853768,0.0784637,0.0716277,0.0652291,0.059877,0.0555112,0.0520375,
0.0485809,0.0454674,0.0427141,0.0400381,0.0374221,0.0349776,0.0330992,0.0310407,0.0292052,0.0273096,0.0260488,
0.0248308,0.0238016,0.0230296,0.0224635,0.0217345,0.0208424,0.0198303,0.018398,0.0168369,0.0150271,0.0133031,
0.011785,0.010507,0.00943485,0.00862002,0.00800247,0.00749642,0.00716191,0.00703325,0.00710187,0.00738492,
0.00782235,0.00831125,0.00913465,0.0103011,0.0118536,0.0139035,0.0166482,0.0198218,0.0234671,0.0276184,
0.032576,0.0381768,0.0447126,0.052432,0.0594481,0.0678537,0.0772114,0.0884217,0.105018,0.134447,0.198458,
0.251387,0.303571,0.355317,0.40768,0.449339,0.477172,0.489214,0.485303,0.477695,0.479899,0.496668,0.520941,
0.547419,0.558046,0.561142,0.557428,0.536431,0.479942,0.415648,0.34981,0.288338,0.220947,0.133932,0.092513,
0.0694234,0.0530582,0.0393348,0.0293767,0.0223177,0.017566,0.0138521,0.0114762,0.00985513,0.00866291,
0.00765938,0.00677594,0.00584961,0.00535213,0.00485466,0.00438292,0.00388544,0.00337939,0.00308777,0.0029248,
0.00287334,0.00289907,0.00296769,0.00313923,0.00356809,0.00415134,0.00488897,0.00560945,0.00681883,0.00813113,
0.00984655,0.0119136,0.0143496,0.0173601,0.0201992,0.023244,0.0264176,0.0298828,0.0339226,0.0385285,0.0441808,
0.0504679,0.0563518,0.0626303,0.0699637,0.0768855,0.0833612,0.0904545,0.0972991,0.104452,0.112369,0.120586,
0.131728,0.142492,0.150829,0.156696,0.16149,0.16752,0.17457,0.179382,0.18169,0.182093,0.180514,0.175085,
0.166319,0.160015,0.159183,0.167254,0.185429,0.20339,0.220981,0.237304,0.250778,0.260042,0.290876,0.292626,
0.29146,0.289221,0.286245,0.283286,0.280695,0.278217,0.277144,0.275378,0.274305,0.273276,0.269863,0.261937,
0.247476,0.226737,0.200791,0.16246,0.133718,0.116143,0.105079,0.0958667,0.0873839,0.0797159,0.072494,
0.0654521,0.0596197,0.0548508,0.0509396,0.0471571,0.0440436,0.0411445,0.0382798,0.0357838,0.0335538,0.0314609,
0.0295054,0.027524,0.0260145,0.0244963,0.023407,0.0226351,0.0220004,0.0215543,0.0210226,0.0204307,0.019573,
0.0184065,0.0170942,0.0155332,0.0138607,0.0124283,0.011176,0.010061,0.00916896,0.00849137,0.00807966,
0.00783093,0.00778804,0.00790812,0.00815686,0.00868006,0.00940054,0.0104727,0.0119308,0.0139121,0.0165196,
0.019573,0.0231068,0.0272238,0.0320699,0.0374821,0.0438635,0.0512141,0.0581702,0.0662584,0.0760278,0.0864404,
0.101279,0.124111,0.183259,0.241421,0.296743,0.351174,0.411179,0.466082,0.512132,0.539716,0.549812,0.549391,
0.550215,0.555284,0.561297,0.569522,0.57906,0.5878,0.590759,0.584035,0.568621,0.538884,0.453242,0.371785,
0.299462,0.226196,0.134618,0.0915695,0.067991,0.0517116,0.0380139,0.0288363,0.0223606,0.0180463,0.014624,
0.0124283,0.0109444,0.00982082,0.00879157,0.00800247,0.0072048,0.0066044,0.00604688,0.00560945,0.00526636,
0.00481177,0.00443438,0.00408272,0.00388544,0.00385971,0.00393691,0.00409987,0.00451157,0.00501763,0.00556656,
0.00645001,0.00766796,0.00910892,0.0110474,0.0133203,0.0161851,0.0189898,0.0219661,0.0251224,0.0283732,
0.0318555,0.0355351,0.0402868,0.0455618,0.0517201,0.0573553,0.0636081,0.0709158,0.0779662,0.0843218,0.0910892,
0.0975392,0.104135,0.111426,0.119119,0.130081,0.141772,0.151541,0.160118,0.168369,0.176861,0.183465,0.188114,
0.190867,0.192162,0.192059,0.189958,0.185481,0.182453,0.185026,0.193106,0.2058,0.22159,0.239963,0.258532,
0.274631,0.285619,0.317997,0.320185,0.318881,0.31563,0.311342,0.307456,0.30412,0.300689,0.298081,0.295611,
0.293776,0.291992,0.288749,0.280009,0.263764,0.240958,0.213699,0.178164,0.139284,0.117979,0.106056,0.0959953,
0.0871695,0.0790726,0.0712846,0.0637367,0.0578185,0.0528266,0.0482979,0.0444296,0.0412646,0.0382369,0.035638,
0.0333822,0.0311693,0.029128,0.0270523,0.0255513,0.0237673,0.0225579,0.0215543,0.0208682,0.0205594,0.0203278,
0.0200619,0.0197017,0.0190069,0.0181921,0.0170428,0.0157133,0.014238,0.0129086,0.0117335,0.0106614,0.0098294,
0.00910034,0.00863718,0.00841417,0.00841417,0.0086286,0.00906604,0.00981225,0.0107472,0.012068,0.0140494,
0.0165968,0.0196073,0.023021,0.0269751,0.0316239,0.0366244,0.0427141,0.0496445,0.056489,0.0642942,0.0744924,
0.085171,0.0992718,0.119574,0.167263,0.230699,0.289024,0.346731,0.41148,0.475611,0.533061,0.557677,0.565516,
0.569951,0.572104,0.576169,0.58334,0.592337,0.603162,0.614123,0.622434,0.623078,0.611198,0.587714,0.560207,
0.480526,0.382197,0.299634,0.220312,0.126213,0.0872552,0.0645944,0.0494472,0.0368045,0.0287077,0.022901,
0.0190927,0.0162623,0.0140322,0.0126684,0.0116735,0.0107643,0.00988086,0.00921185,0.00862002,0.00807966,
0.00752215,0.00698179,0.00647574,0.00589249,0.00554083,0.00530067,0.00523205,0.00524921,0.00530067,0.00556656,
0.0059268,0.00663871,0.00753073,0.00872295,0.0103783,0.0124883,0.0149757,0.017849,0.0206623,0.0236815,
0.0266577,0.0298828,0.0333393,0.0368474,0.0412646,0.0460764,0.0519432,0.0573553,0.0634622,0.070547,0.0775802,
0.0841417,0.0910978,0.0975135,0.104066,0.111271,0.118948,0.129918,0.142012,0.153248,0.163583,0.175179,
0.183551,0.189855,0.194169,0.19742,0.199762,0.20104,0.201288,0.200808,0.202052,0.206941,0.21484,0.225982,
0.242244,0.261628,0.282308,0.299256,0.310612,0.346053,0.349656,0.348601,0.343935,0.338857,0.334689,0.3307,
0.326068,0.321934,0.318006,0.313314,0.308726,0.302987,0.292575,0.275215,0.249783,0.220132,0.184117,0.140159,
0.116838,0.10374,0.0931735,0.0839873,0.0762165,0.0680767,0.0606232,0.0546793,0.0491298,0.044258,0.0404498,
0.0372334,0.0344887,0.03219,0.0298828,0.0278843,0.0260917,0.0242647,0.0227123,0.0213142,0.0201906,0.0194272,
0.0189812,0.0187325,0.0186896,0.0186381,0.018518,0.0182178,0.0175917,0.0166482,0.0156533,0.0143839,0.0133031,
0.0121967,0.0112532,0.0104298,0.00977794,0.00928904,0.00910034,0.00914323,0.00951205,0.0100696,0.0110045,
0.0123253,0.014238,0.0168198,0.0197617,0.0232183,0.0270523,0.0315467,0.036247,0.0418307,0.0478776,0.0547307,
0.0619612,0.0715591,0.0828552,0.0977451,0.117678,0.159372,0.220904,0.27687,0.336987,0.40593,0.477738,
0.544417,0.565045,0.577027,0.585424,0.592097,0.598393,0.607776,0.619775,0.632538,0.644563,0.655293,0.660457,
0.654453,0.632856,0.60028,0.565516,0.486075,0.376493,0.287574,0.202395,0.113561,0.0809939,0.0606146,0.0466939,
0.0359554,0.0289736,0.0241189,0.0207824,0.018398,0.0166654,0.0156447,0.0147098,0.0140065,0.0133203,0.0126084,
0.0118708,0.0111245,0.0103698,0.00967501,0.00889449,0.00818259,0.0076165,0.00709329,0.00687029,0.00681883,
0.0068274,0.00698179,0.0074278,0.00801962,0.00880872,0.0100696,0.0118021,0.0140065,0.0166654,0.0194101,
0.0222491,0.0253454,0.0283217,0.0313323,0.0343086,0.0375679,0.0415562,0.0458705,0.051257,0.0564118,0.0622014,
0.0689773,0.0762936,0.0831811,0.0905317,0.0974363,0.104435,0.112086,0.119857,0.13069,0.142363,0.153771,
0.164964,0.176801,0.185412,0.191819,0.197214,0.20218,0.206469,0.210183,0.213459,0.216427,0.220981,0.228015,
0.237312,0.249826,0.266963,0.287386,0.306564,0.323701,0.337167,0.374821,0.379547,0.379393,0.374847,0.36862,
0.364065,0.358962,0.353695,0.348103,0.34083,0.332467,0.323187,0.312645,0.299582,0.279143,0.251233,0.219283,
0.178773,0.134095,0.112035,0.0982168,0.0874697,0.0787467,0.0705813,0.0626045,0.0559144,0.049756,0.0437263,
0.0390346,0.035252,0.0324216,0.0299514,0.0278157,0.0260488,0.0241189,0.0224721,0.0209196,0.0197274,0.0184923,
0.0177032,0.0170771,0.0168369,0.0168369,0.0169742,0.0171543,0.0172915,0.0170942,0.0166654,0.0161336,0.0153188,
0.0143753,0.0135004,0.012617,0.0117421,0.0109959,0.0104126,0.00998379,0.00985513,0.00998379,0.0104727,
0.0113132,0.0125398,0.0142724,0.0168283,0.0198732,0.023407,0.0273525,0.0318812,0.03641,0.0416677,0.0469169,
0.0531954,0.0594053,0.0680939,0.079227,0.0938854,0.114796,0.154011,0.215912,0.266517,0.322981,0.391829,
0.468878,0.546304,0.570062,0.586771,0.600168,0.611739,0.621834,0.633276,0.647514,0.666795,0.684001,0.696807,
0.7042,0.699551,0.678735,0.643423,0.601678,0.562549,0.463594,0.351937,0.260385,0.161079,0.0989544,0.0733002,
0.0565748,0.0445068,0.0354236,0.0295911,0.0258172,0.0230296,0.0213142,0.0202163,0.0196931,0.0193157,0.0190155,
0.0185524,0.0180463,0.0173172,0.016288,0.0150615,0.0138263,0.0126684,0.0115363,0.0105756,0.00982082,0.00919469,
0.00886018,0.00869722,0.00872295,0.009006,0.00955493,0.0103183,0.011562,0.0133203,0.0156962,0.0182178,
0.020791,0.0236043,0.0265034,0.029411,0.0322072,0.0348146,0.0376708,0.041136,0.0449185,0.0499275,0.0548594,
0.0600314,0.0664128,0.0742437,0.0817744,0.0895196,0.0973076,0.105173,0.113596,0.121873,0.132165,0.142724,
0.153239,0.163472,0.175197,0.184391,0.191896,0.19893,0.206855,0.213665,0.219841,0.226428,0.233247,0.241987,
0.252074,0.263232,0.277891,0.295525,0.313786,0.333042,0.350402,0.36434,0.402954,0.408752,0.410202,0.406977,
0.401118,0.394737,0.387335,0.379701,0.370541,0.359571,0.347022,0.332295,0.316719,0.298716,0.274228,0.243514,
0.209539,0.158068,0.121289,0.10296,0.0900085,0.079896,0.0712246,0.0631449,0.0562489,0.0498332,0.043083,
0.0374821,0.0333136,0.0298141,0.027018,0.0250796,0.023124,0.0214857,0.0200448,0.0186639,0.0176603,0.0165196,
0.0156275,0.014847,0.0144782,0.0144267,0.0145811,0.0149156,0.0153617,0.0156533,0.0157905,0.0156275,0.0152673,
0.0147098,0.0142209,0.0135519,0.0128657,0.0121452,0.0115534,0.0111074,0.0108329,0.0108072,0.0110045,0.0116049,
0.0126684,0.0142724,0.0166482,0.0197274,0.023407,0.0274897,0.0322072,0.0369417,0.0422596,0.0473544,0.0529381,
0.0581702,0.0650919,0.0755131,0.0882588,0.108878,0.145983,0.212396,0.263001,0.316539,0.378758,0.453971,
0.539219,0.570869,0.592749,0.612382,0.628867,0.644812,0.660157,0.677096,0.699534,0.728542,0.755912,0.767028,
0.759283,0.730223,0.687629,0.638971,0.591325,0.549108,0.422132,0.31286,0.220304,0.120054,0.0848794,0.0653063,
0.0529209,0.0425855,0.0349433,0.0303459,0.027464,0.0259201,0.024848,0.0244963,0.0247365,0.0251825,0.0255684,
0.0255513,0.0250796,0.0241618,0.022901,0.02146,0.0199075,0.018235,0.0165367,0.0148642,0.0134575,0.0124025,
0.0115791,0.0110902,0.0108501,0.010893,0.0112361,0.0119222,0.0130887,0.0148127,0.0170599,0.0194101,0.0219403,
0.0246936,0.0272496,0.0299342,0.0325417,0.0348146,0.0373106,0.0402182,0.0436576,0.0477918,0.0527837,0.0576641,
0.0636252,0.0716277,0.0799304,0.0881129,0.0968187,0.105808,0.115114,0.124334,0.134318,0.144002,0.153316,
0.162194,0.173713,0.183842,0.192831,0.20212,0.212662,0.221925,0.23184,0.242373,0.253386,0.265299,0.277728,
0.290062,0.305055,0.323461,0.342708,0.36241,0.380439,0.393862,0.431859,0.437631,0.439913,0.438,0.431833,
0.422561,0.410905,0.398597,0.38604,0.370618,0.352761,0.333016,0.311719,0.288758,0.259012,0.225665,0.184872,
0.132877,0.107257,0.0912436,0.0797674,0.0704097,0.0620556,0.0552368,0.0485809,0.0418736,0.0357838,0.0311093,
0.0271724,0.0241361,0.0216659,0.0198818,0.0183036,0.0170428,0.0159621,0.014847,0.0139979,0.0132603,0.0126513,
0.0122567,0.0121367,0.0122739,0.0125912,0.0129429,0.0133803,0.0138092,0.0140494,0.0142209,0.0141866,0.0140065,
0.0137663,0.013346,0.0129343,0.0125569,0.0120852,0.0118365,0.0116906,0.011785,0.0120852,0.0129086,0.0142638,
0.0163995,0.0192299,0.0228838,0.0270609,0.0320699,0.0373106,0.0429028,0.048538,0.0540102,0.0586934,0.0645859,
0.0731716,0.0847764,0.102523,0.134815,0.203827,0.2577,0.311539,0.37272,0.446003,0.532006,0.570165,0.596043,
0.620221,0.642908,0.663888,0.684584,0.707245,0.735267,0.770073,0.804244,0.819082,0.817127,0.790418,0.734941,
0.673734,0.619278,0.572713,0.487576,0.362453,0.261071,0.153213,0.0957294,0.0727513,0.0584704,0.0486152,
0.0402611,0.0345659,0.0312551,0.0292995,0.0284504,0.0284161,0.0291108,0.0301486,0.031521,0.0325502,0.0331163,
0.0329105,0.032027,0.0304231,0.0287248,0.0264862,0.0242218,0.0219317,0.0198732,0.0179691,0.0162623,0.0147269,
0.0138006,0.013123,0.0128228,0.0129,0.0133975,0.0144267,0.0161508,0.0180635,0.0202678,0.022678,0.0251825,
0.0274897,0.0299428,0.0322843,0.0343171,0.03641,0.0389059,0.0421223,0.0457161,0.050365,0.0552282,0.0611035,
0.069269,0.0780348,0.0864576,0.095738,0.105593,0.115688,0.126024,0.136471,0.14606,0.155109,0.163686,0.175505,
0.186639,0.196545,0.208587,0.220381,0.233744,0.247828,0.262358,0.277059,0.290362,0.302215,0.314386,0.331163,
0.351766,0.374384,0.395415,0.412312,0.424397,0.45892,0.464238,0.467643,0.464546,0.455755,0.443404,0.426876,
0.408701,0.390569,0.370815,0.348609,0.323221,0.297215,0.267289,0.233127,0.194667,0.139773,0.109796,0.0914752,
0.0783865,0.068214,0.0596712,0.0529467,0.0458362,0.0393691,0.0336824,0.0289307,0.0248222,0.0213828,0.0185867,
0.0165367,0.0148642,0.0136205,0.0126599,0.0119222,0.0113819,0.0109015,0.0104813,0.0101896,0.0100696,0.0100953,
0.0103097,0.0106271,0.0110902,0.0115448,0.0119994,0.0124454,0.0127799,0.0129429,0.0130544,0.0130887,0.0130287,
0.0129086,0.0127714,0.0126084,0.0125569,0.0126084,0.0128486,0.0133375,0.0143839,0.0162451,0.0185524,0.0219317,
0.0262289,0.0311693,0.0366501,0.04298,0.0493957,0.0548937,0.0601257,0.066164,0.0740636,0.0842532,0.100155,
0.126804,0.192402,0.24866,0.304523,0.365052,0.43939,0.529261,0.570877,0.598633,0.62885,0.657403,0.683169,
0.710093,0.741125,0.770699,0.8033,0.827462,0.845397,0.848854,0.832257,0.785228,0.706568,0.643251,0.590424,
0.540711,0.407706,0.296838,0.195799,0.105885,0.0775631,0.0615753,0.0521318,0.0438549,0.0375507,0.033691,
0.031521,0.0303974,0.0304488,0.031521,0.033305,0.0352177,0.0374992,0.0392833,0.0403726,0.0404498,0.0395406,
0.0377308,0.0353721,0.0328847,0.0299514,0.0270008,0.024402,0.0218889,0.0197274,0.0179176,0.0164595,0.0154045,
0.014564,0.0143324,0.0145726,0.0155332,0.0168712,0.0185095,0.0205508,0.022738,0.025071,0.0271038,0.0294196,
0.0314695,0.0334165,0.035192,0.0375336,0.0404069,0.0437263,0.0478175,0.0530925,0.0587277,0.0663013,0.0756847,
0.0844848,0.0942542,0.104615,0.115551,0.127371,0.139507,0.150426,0.160607,0.172169,0.183671,0.194255,
0.205483,0.21828,0.232904,0.249955,0.267727,0.286056,0.301855,0.315639,0.327621,0.341567,0.360626,0.384582,
0.408529,0.429251,0.444021,0.453182,0.48882,0.491582,0.492268,0.486667,0.473184,0.454863,0.432794,0.407834,
0.383201,0.358173,0.331361,0.302516,0.270737,0.234636,0.194409,0.138975,0.108792,0.0895539,0.0761907,
0.0647745,0.0564719,0.0493357,0.0422081,0.0358524,0.0307405,0.0262718,0.0222834,0.018844,0.0160821,0.0136634,
0.011948,0.0108072,0.00988086,0.00937481,0.00893738,0.0086286,0.00841417,0.00829409,0.00818259,0.00822548,
0.00833698,0.00855998,0.00887734,0.00929762,0.00983798,0.0103269,0.0108243,0.0112532,0.0116821,0.0119651,
0.0123082,0.0125569,0.0127285,0.0128571,0.0129601,0.0132088,0.013449,0.0139293,0.0146669,0.0161936,0.0181921,
0.0208596,0.0247279,0.029471,0.0349776,0.041865,0.0490012,0.0552539,0.0611207,0.0683169,0.0764309,0.0862689,
0.101596,0.127482,0.188191,0.242459,0.298081,0.356303,0.429886,0.518925,0.569839,0.601326,0.635943,0.672465,
0.708326,0.747026,0.78395,0.813945,0.833501,0.851444,0.865879,0.872578,0.860167,0.822428,0.741065,0.661349,
0.604491,0.558732,0.441766,0.325425,0.222697,0.115946,0.0804793,0.0624587,0.0526293,0.0448155,0.0388201,
0.0346259,0.0322672,0.0310492,0.0307919,0.0318812,0.0336824,0.0362641,0.0393691,0.0424054,0.0446011,0.0460592,
0.046308,0.0456046,0.0438206,0.0412046,0.0379281,0.0346173,0.0313323,0.0280558,0.0251396,0.0224378,0.0201992,
0.018398,0.0169827,0.0160135,0.0154474,0.0154646,0.0160307,0.0170685,0.018458,0.0202678,0.0221805,0.0242218,
0.0262375,0.0282016,0.0300543,0.032027,0.0339397,0.036024,0.0386915,0.0419508,0.0456904,0.0508453,0.0564461,
0.0634966,0.0725797,0.0820318,0.0922986,0.103123,0.114977,0.128777,0.144096,0.15884,0.174056,0.18681,
0.1967,0.207318,0.218597,0.233401,0.25155,0.271235,0.290979,0.309566,0.327475,0.343609,0.35795,0.375627,
0.397053,0.421772,0.444459,0.463165,0.476915,0.484703,0.510417,0.509353,0.505802,0.496848,0.478887,0.454588,
0.426301,0.394428,0.363405,0.333942,0.303468,0.26994,0.231986,0.188911,0.132097,0.104118,0.0857971,0.0721938,
0.0610692,0.0529724,0.0447812,0.0377308,0.0320356,0.0270266,0.0229696,0.0195559,0.0163909,0.0135004,0.0113904,
0.00983798,0.00867149,0.0079167,0.00735918,0.00694748,0.00675879,0.00655293,0.00647574,0.0064157,0.00647574,
0.00653578,0.00675879,0.00693891,0.00728199,0.00776231,0.00816544,0.0087058,0.00921185,0.0098294,0.0103183,
0.0108758,0.0113819,0.0118965,0.0123768,0.0128142,0.0132603,0.013732,0.0142466,0.01501,0.0162451,0.0178833,
0.0201649,0.0233384,0.0273268,0.0327304,0.0391975,0.0466082,0.0545163,0.060992,0.0687972,0.0776059,0.0880272,
0.104229,0.132114,0.194461,0.244088,0.29688,0.353181,0.423899,0.51052,0.567035,0.600348,0.639469,0.682063,
0.72807,0.77485,0.815025,0.84387,0.865442,0.88125,0.889655,0.891225,0.879989,0.844874,0.770158,0.675527,
0.612528,0.565302,0.461381,0.343866,0.24239,0.125972,0.0833097,0.0625874,0.0512999,0.0434518,0.0377737,
0.0339226,0.0314009,0.0299771,0.0296254,0.0301744,0.0319756,0.0344801,0.0377566,0.041642,0.0449185,0.0477318,
0.0496788,0.0502363,0.0494987,0.0473715,0.0446183,0.041419,0.0375679,0.0339226,0.0302601,0.0269665,0.0241018,
0.02152,0.0194787,0.0178233,0.0165024,0.0157905,0.015516,0.0159192,0.0166482,0.0179005,0.0193329,0.0209968,
0.0228238,0.0246936,0.026409,0.0283732,0.0301744,0.032353,0.0345659,0.0372419,0.0403554,0.0440007,0.0489497,
0.0546021,0.0609577,0.0699208,0.0795358,0.0899056,0.101425,0.114453,0.130819,0.150392,0.173181,0.190361,
0.20224,0.213005,0.223314,0.236986,0.255281,0.276381,0.296803,0.316848,0.337425,0.357366,0.375927,0.39339,
0.413598,0.437125,0.460395,0.484102,0.499867,0.508461,0.510717,0.525607,0.518368,0.508067,0.493297,0.46856,
0.439973,0.40521,0.367899,0.333488,0.300183,0.264382,0.225639,0.176286,0.123176,0.0982511,0.0809853,0.0674592,
0.0567549,0.0481177,0.0401925,0.0334851,0.0279958,0.0233298,0.0194444,0.016348,0.0133975,0.0112017,0.0094177,
0.00807966,0.00698179,0.00619269,0.00560945,0.00530067,0.00506909,0.00497474,0.00488897,0.00485466,0.00488039,
0.00494043,0.00504336,0.00524921,0.00542933,0.00569522,0.0061155,0.00669017,0.00719622,0.00783093,0.00836271,
0.00898884,0.00970074,0.0103783,0.0111074,0.011845,0.0125569,0.0132946,0.0140408,0.01495,0.0162279,0.0177204,
0.0197017,0.0223949,0.0260488,0.0303545,0.0362298,0.0436319,0.0521919,0.0598942,0.0684027,0.0779748,0.0888163,
0.104984,0.134429,0.198732,0.249174,0.299908,0.355514,0.425109,0.509225,0.56646,0.599053,0.638748,0.683718,
0.73651,0.785846,0.821047,0.849566,0.877896,0.897323,0.906818,0.906501,0.894638,0.85864,0.783976,0.681111,
0.613952,0.565842,0.4676,0.349132,0.248591,0.132036,0.084176,0.0623043,0.0494215,0.0404326,0.034969,0.031521,
0.0292137,0.0276012,0.0268722,0.0272067,0.0284933,0.0304917,0.0336052,0.0373449,0.0414876,0.0450814,0.048255,
0.050262,0.050871,0.0502963,0.0484523,0.0455703,0.0422939,0.0383312,0.034583,0.0309206,0.0274897,0.024462,
0.0217087,0.0195387,0.0177118,0.0162623,0.0152502,0.0147956,0.01495,0.0156962,0.0166482,0.0179863,0.0194272,
0.0208939,0.0226436,0.0243333,0.0262375,0.0283046,0.0305175,0.033245,0.0359983,0.0393776,0.0431173,0.047423,
0.0531268,0.0591994,0.0676393,0.0775116,0.0879586,0.10049,0.114934,0.133923,0.158891,0.1882,0.205328,
0.218708,0.231085,0.244457,0.261354,0.282677,0.304394,0.325828,0.348832,0.371562,0.393553,0.412612,0.430804,
0.451947,0.477566,0.502826,0.520426,0.529964,0.532932,0.530676,0.528566,0.513359,0.49533,0.469864,0.44156,
0.408246,0.369357,0.331018,0.294385,0.254878,0.214634,0.156112,0.114693,0.0921614,0.0757962,0.0619012,
0.0518316,0.042311,0.0347203,0.029025,0.0239045,0.0195816,0.0160221,0.0129086,0.0106957,0.00898884,0.00764223,
0.00649289,0.00554941,0.00488897,0.00423711,0.00380825,0.00336224,0.00321643,0.00315639,0.00313923,0.00313923,
0.00315639,0.00321643,0.00335366,0.00362813,0.00396264,0.0043143,0.00481177,0.00528352,0.0057038,0.00631277,
0.00698179,0.00776231,0.00843133,0.00928904,0.0101811,0.0111331,0.0119994,0.0130716,0.014238,0.015739,
0.0173601,0.0192814,0.0218117,0.0251396,0.0292137,0.0341113,0.0408272,0.0492757,0.0579986,0.0678366,0.0784208,
0.0907118,0.10802,0.137466,0.202764,0.254973,0.30713,0.363636,0.433248,0.517236,0.568364,0.601112,0.639503,
0.683195,0.733929,0.784199,0.819511,0.842798,0.867989,0.890839,0.904554,0.907461,0.897091,0.863598,0.787227,
0.676213,0.607956,0.559307,0.446251,0.337022,0.23998,0.126204,0.081946,0.0600571,0.0465481,0.0367187,
0.0313151,0.02785,0.0258515,0.0243248,0.0234928,0.0233984,0.0239645,0.0256113,0.0277299,0.0310578,0.0347288,
0.0388201,0.0427485,0.0457161,0.0477232,0.0485466,0.0479891,0.0462222,0.0437263,0.0405012,0.036753,0.0333393,
0.0297026,0.0264262,0.0234156,0.0207481,0.0184237,0.0165196,0.01495,0.0139979,0.0135519,0.0135776,0.0140065,
0.0148556,0.0161079,0.0173944,0.0187582,0.0203364,0.0219746,0.0238616,0.0262546,0.0290851,0.0321814,0.0354665,
0.0393004,0.0432459,0.0474402,0.0528094,0.0585819,0.0665071,0.076611,0.0874439,0.100841,0.116435,0.13895,
0.172272,0.201357,0.220595,0.237775,0.253943,0.271544,0.291048,0.312628,0.336807,0.360935,0.386958,0.41184,
0.433163,0.450626,0.4682,0.492311,0.514946,0.53499,0.5456,0.548911,0.545455,0.53843,0.514937,0.492079,
0.461158,0.431327,0.397319,0.360574,0.322972,0.285001,0.242845,0.198252,0.13732,0.105199,0.0850595,0.0697579,
0.0565834,0.0453731,0.0359211,0.0292566,0.024016,0.0198561,0.0160821,0.012617,0.0101639,0.00837129,0.00699895,
0.00584961,0.00506909,0.00421995,0.00335366,0.00289907,0.00254741,0.00231583,0.00219575,0.00216144,0.00216144,
0.00216144,0.00216144,0.00216144,0.0022129,0.00229867,0.00239302,0.00261603,0.00289907,0.00321643,0.00386829,
0.00447727,0.00509482,0.00564376,0.00647574,0.00730772,0.00818259,0.00918612,0.0102668,0.0114591,0.0127799,
0.0143238,0.0163995,0.0185867,0.0213142,0.0245049,0.0285104,0.0332536,0.0391461,0.0467197,0.0558029,0.0661297,
0.0790641,0.0933364,0.11309,0.149911,0.214265,0.265857,0.319944,0.379341,0.447435,0.531079,0.572198,0.606318,
0.64651,0.689971,0.736527,0.77937,0.813619,0.835362,0.856539,0.875263,0.887099,0.890444,0.879242,0.844488,
0.767182,0.667147,0.599053,0.546244,0.409044,0.306007,0.215235,0.112789,0.0764309,0.0559487,0.0424054,
0.032799,0.0267607,0.0235014,0.0215115,0.020345,0.019573,0.0190841,0.0192299,0.0200533,0.0215286,0.0238359,
0.0268464,0.0304488,0.0341971,0.0377308,0.0407929,0.0427056,0.0434003,0.0429715,0.0415734,0.0391461,0.0362298,
0.0332278,0.0298828,0.0267178,0.0238187,0.0210054,0.0185438,0.0164252,0.0144182,0.0130458,0.0121367,0.0117335,
0.0117249,0.0119994,0.0127456,0.0136805,0.014847,0.0163823,0.0179091,0.0196245,0.0216744,0.024462,0.027687,
0.0315639,0.0356809,0.040201,0.0444639,0.0493614,0.0543362,0.0597912,0.0678881,0.0776231,0.0888763,0.102977,
0.119685,0.146369,0.186784,0.215012,0.237587,0.259467,0.280301,0.300243,0.322192,0.347185,0.373629,0.400338,
0.427562,0.45072,0.470893,0.490175,0.505305,0.522982,0.538739,0.550249,0.553852,0.552831,0.54488,0.532426,
0.479676,0.447941,0.413324,0.376734,0.340512,0.304926,0.265994,0.223383,0.167812,0.118553,0.0949403,0.0779576,
0.0631363,0.0515314,0.039695,0.0304488,0.0237329,0.0189383,0.0153874,0.0123253,0.00985513,0.00803678,
0.00651005,0.0054036,0.00451157,0.00357667,0.00289907,0.00237587,0.00205851,0.00184408,0.0016897,0.00156104,
0.001501,0.00146669,0.00144954,0.00144954,0.00147527,0.00150958,0.00156104,0.00162108,0.00173258,0.00184408,
0.0019899,0.00226436,0.00259887,0.00301915,0.00378252,0.00453731,0.00530067,0.00610692,0.00706756,0.00815686,
0.00935766,0.0107043,0.0123082,0.0144096,0.0172829,0.0201992,0.0236214,0.0276184,0.0326703,0.0384942,
0.0458019,0.0546192,0.0645859,0.0791155,0.0971447,0.123348,0.183456,0.237226,0.288921,0.340727,0.402371,
0.470902,0.548611,0.577053,0.610486,0.652343,0.701233,0.750534,0.781249,0.802846,0.820583,0.841417,0.859798,
0.869808,0.865553,0.843827,0.801705,0.716148,0.646219,0.588889,0.520778,0.379144,0.274091,0.167306,0.0964499,
0.0679309,0.0499704,0.0363756,0.0276698,0.022129,0.018844,0.0170428,0.0160478,0.0154388,0.0148127,0.014564,
0.0147784,0.0156962,0.0170942,0.0191099,0.0217945,0.0249938,0.0281416,0.0312122,0.0336138,0.0350891,0.0357838,
0.0354493,0.0343429,0.0325417,0.0301744,0.0276527,0.0251567,0.0225665,0.0200619,0.0177547,0.0154989,0.0133975,
0.0118965,0.0107729,0.0100524,0.00976078,0.00973505,0.00990659,0.0104984,0.0112704,0.0122825,0.0136119,
0.015293,0.0173516,0.0197617,0.022901,0.0268464,0.0315553,0.0365386,0.0420794,0.04726,0.0527751,0.0577585,
0.0636853,0.072048,0.0818173,0.0937739,0.108698,0.127105,0.157854,0.19971,0.228555,0.255899,0.282574,
0.305132,0.328333,0.354502,0.382909,0.41202,0.439012,0.4641,0.489094,0.50624,0.520735,0.532906,0.542487,
0.549512,0.552093,0.550515,0.542453,0.527889,0.506043,0.426207,0.389342,0.35029,0.312705,0.276141,0.2363,
0.191982,0.132268,0.102848,0.083833,0.0693719,0.056489,0.0446955,0.0339569,0.0253883,0.0187582,0.0140236,
0.0110474,0.00909177,0.00754788,0.00608977,0.00501763,0.00394548,0.00301915,0.00248737,0.00208424,0.00178404,
0.00147527,0.00114934,0.00104641,0.000994948,0.00096064,0.000943485,0.000917754,0.000917754,0.000917754,
0.000943485,0.000943485,0.000977794,0.00100353,0.00104641,0.00114076,0.00133803,0.00160392,0.00186124,
0.00216144,0.00261603,0.00317354,0.00413418,0.00508624,0.00595253,0.00711902,0.00841417,0.00985513,0.0118279,
0.0145039,0.0181235,0.0219746,0.0263747,0.0316754,0.0380739,0.0456904,0.0546535,0.0645944,0.0799732,0.102042,
0.143873,0.221445,0.281802,0.336387,0.390569,0.448207,0.512861,0.559958,0.583666,0.613977,0.652875,0.702073,
0.758279,0.791438,0.801722,0.802923,0.813001,0.830456,0.841769,0.837686,0.810239,0.741442,0.670569,0.616962,
0.571666,0.483665,0.350805,0.242913,0.126684,0.081946,0.0586848,0.0426713,0.0305603,0.0226351,0.0174287,
0.014015,0.0123597,0.0114676,0.011116,0.0109101,0.0106271,0.0105585,0.0107043,0.0112532,0.0123082,0.0139722,
0.0162451,0.0185609,0.021074,0.0235014,0.0255856,0.0266063,0.027078,0.026795,0.0261088,0.0247279,0.0229353,
0.0211169,0.0192557,0.017403,0.0154646,0.0133889,0.0117335,0.0103097,0.00920327,0.00841417,0.00793385,
0.00771085,0.007728,0.00795101,0.00841417,0.00907461,0.00992375,0.0112017,0.0127885,0.0149928,0.0180549,
0.0218631,0.0265891,0.03219,0.0383312,0.0451586,0.0521662,0.0579815,0.0640712,0.0717392,0.0802563,0.0908233,
0.103535,0.118811,0.142698,0.181158,0.215132,0.244285,0.275275,0.303674,0.330031,0.357572,0.387738,0.417895,
0.447126,0.473278,0.49822,0.516447,0.531294,0.540977,0.546887,0.549735,0.547539,0.541338,0.530213,0.511223,
0.48785,0.456904,0.35807,0.320013,0.280927,0.238916,0.195413,0.136651,0.105962,0.0864404,0.0719965,0.0593881,
0.0487868,0.0375336,0.0282874,0.0205337,0.014238,0.0101382,0.00789954,0.00637281,0.00536071,0.00438292,
0.00326789,0.00261603,0.00216144,0.00184408,0.00150958,0.00114076,0.000986371,0.000831982,0.000763365,
0.00072048,0.00066044,0.000651863,0.000643285,0.000626131,0.000626131,0.000626131,0.000643285,0.00066044,
0.000694748,0.000737634,0.000763365,0.000789097,0.000909177,0.0010121,0.00117507,0.00158677,0.0019127,
0.00234156,0.00296769,0.00397979,0.00505193,0.0061155,0.00749642,0.00908319,0.0113561,0.0146669,0.0190412,
0.0238616,0.0295654,0.0363499,0.0448155,0.0547307,0.0660011,0.0826579,0.10935,0.181467,0.263052,0.341259,
0.424182,0.500536,0.553714,0.567086,0.581839,0.600494,0.624047,0.655285,0.69552,0.748656,0.787073,0.80204,
0.79426,0.783736,0.785254,0.794174,0.786944,0.752936,0.695006,0.640626,0.592646,0.552436,0.426447,0.312551,
0.206735,0.104392,0.07089,0.0503564,0.0348146,0.0251739,0.0180806,0.0131059,0.0103097,0.00882588,0.00813113,
0.00783093,0.00777089,0.00768512,0.00754788,0.00747069,0.0075393,0.00790812,0.00853425,0.00954636,0.0107815,
0.0123082,0.014015,0.0158849,0.0171886,0.0179948,0.018235,0.0180463,0.0174202,0.0165196,0.0154989,0.014238,
0.0129772,0.0118193,0.0106013,0.00943485,0.00841417,0.00752215,0.00681883,0.00613265,0.00572953,0.00560945,
0.00566949,0.0059268,0.00650147,0.00711045,0.00803678,0.00910034,0.0106614,0.0129772,0.0165367,0.0209196,
0.0265634,0.0333822,0.0414362,0.050202,0.0579643,0.0660011,0.07511,0.0835242,0.0942542,0.107291,0.122979,
0.14606,0.179974,0.20857,0.234096,0.263953,0.296314,0.326798,0.357675,0.389788,0.421506,0.450549,0.479659,
0.503898,0.521499,0.533833,0.54307,0.549614,0.549426,0.543773,0.533129,0.513659,0.488734,0.458174,0.428831,
0.394934,0.286331,0.242484,0.195885,0.134773,0.10441,0.0853511,0.0713789,0.0595168,0.0495587,0.0389917,
0.0300886,0.0224292,0.0159792,0.0106442,0.00747926,0.00553225,0.00419422,0.00312208,0.00254741,0.00208424,
0.00177547,0.00145811,0.00114076,0.000977794,0.000806251,0.000737634,0.000626131,0.000548937,0.000506051,
0.000471743,0.000454588,0.000454588,0.00042028,0.000403126,0.000403126,0.000411703,0.000454588,0.000463165,
0.00048032,0.000514628,0.00054036,0.000583245,0.00066044,0.000746211,0.000857714,0.00102926,0.00133803,
0.0018012,0.00222148,0.00289907,0.00400552,0.00526636,0.00656151,0.00830267,0.0108501,0.0147784,0.0200105,
0.0259973,0.0330306,0.0420623,0.0531525,0.0655551,0.084056,0.11514,0.206392,0.29881,0.406702,0.538481,
0.584866,0.618249,0.638508,0.644358,0.647737,0.656297,0.67147,0.695546,0.728971,0.76587,0.785271,0.782535,
0.768031,0.752026,0.739101,0.722144,0.694174,0.656528,0.614286,0.573853,0.502938,0.377051,0.269871,0.145854,
0.0859687,0.0596797,0.0415562,0.0279958,0.0195044,0.0137663,0.00986371,0.00781377,0.00637281,0.00560945,
0.00530067,0.00526636,0.00526636,0.00524063,0.0051034,0.00505193,0.00508624,0.00530067,0.00563518,0.00620985,
0.00693891,0.00777946,0.00853425,0.00928904,0.00987229,0.0102926,0.0103698,0.0101725,0.00984655,0.00949489,
0.00903173,0.00855998,0.00808824,0.00749642,0.00688744,0.00615839,0.00557514,0.00506909,0.00453731,0.0040913,
0.00385971,0.00378252,0.00388544,0.00426284,0.00482893,0.00547221,0.00623558,0.00740207,0.00892022,0.0113561,
0.0151301,0.020242,0.0266492,0.0348661,0.0449614,0.0556227,0.0661212,0.0779919,0.0895024,0.103123,0.118828,
0.142724,0.176423,0.202875,0.221402,0.238899,0.260642,0.289753,0.3216,0.354913,0.389462,0.423265,0.454125,
0.48472,0.508581,0.525839,0.534802,0.538516,0.541329,0.540892,0.534536,0.519354,0.496239,0.462951,0.429234,
0.394514,0.359725,0.323907,0.201125,0.136522,0.103663,0.0834641,0.0692261,0.0575869,0.0477232,0.0380911,
0.0298141,0.0228066,0.0168198,0.0115191,0.00800247,0.00553225,0.00368817,0.00247879,0.00192986,0.00156104,
0.00114934,0.000994948,0.00084056,0.000763365,0.00066044,0.000574668,0.000523205,0.000454588,0.000368817,
0.000334508,0.000308777,0.0003002,0.000274468,0.000257314,0.000248737,0.00024016,0.00024016,0.000248737,
0.000274468,0.000291623,0.000308777,0.000343086,0.000377394,0.000454588,0.000497474,0.000557514,0.000651863,
0.000771942,0.000952062,0.00119222,0.00173258,0.00217859,0.0029248,0.00423711,0.0056266,0.00760792,0.0103698,
0.0148041,0.0207738,0.0276698,0.0365386,0.0486152,0.0620728,0.0816372,0.11393,0.209728,0.308726,0.441139,
0.572198,0.643654,0.752567,0.836863,0.852653,0.826433,0.777303,0.736888,0.7209,0.725008,0.743123,0.757121,
0.761221,0.752121,0.733182,0.712537,0.689319,0.660646,0.627152,0.591256,0.557119,0.450257,0.339123,0.234885,
0.114848,0.0733174,0.0510511,0.0338368,0.0219832,0.0142466,0.00984655,0.00735918,0.00557514,0.00458877,
0.00377394,0.00317354,0.00304488,0.003002,0.00299342,0.00297627,0.0029248,0.0029248,0.00293338,0.00304488,
0.00326789,0.00375679,0.00409987,0.00460592,0.00503478,0.00529209,0.00548079,0.00554941,0.00553225,0.0054036,
0.00528352,0.00508624,0.00494043,0.00476031,0.00452015,0.00421138,0.00385971,0.00333651,0.00299342,0.00272753,
0.00244448,0.00228152,0.00216144,0.00219575,0.00234156,0.00265034,0.00307919,0.00389402,0.00485466,0.00582388,
0.00747926,0.00983798,0.0135948,0.0193414,0.0268207,0.0365901,0.0493014,0.0618412,0.0766024,0.0924358,
0.111709,0.139233,0.183122,0.214265,0.235425,0.251662,0.26445,0.276433,0.293355,0.319361,0.352649,0.389128,
0.424508,0.456072,0.487276,0.510211,0.527443,0.535865,0.535822,0.530127,0.522528,0.510683,0.494035,0.466957,
0.435864,0.398545,0.359605,0.323718,0.28911,0.247699,0.10664,0.0844505,0.0687372,0.0563518,0.0456304,
0.0358524,0.0281502,0.0215115,0.0160821,0.0114247,0.00814828,0.00566091,0.00381683,0.00234156,0.00164681,
0.00106357,0.000857714,0.000737634,0.000617554,0.00054036,0.000471743,0.000403126,0.00036024,0.000308777,
0.000265891,0.000223006,0.000205851,0.00018012,0.000162966,0.000154388,0.000154388,0.000154388,0.000145811,
0.000145811,0.000145811,0.000154388,0.000154388,0.000162966,0.000205851,0.000214428,0.000248737,0.000308777,
0.000343086,0.000403126,0.000506051,0.000591823,0.000746211,0.000917754,0.00114934,0.00174116,0.00229867,
0.00321643,0.00497474,0.00692175,0.00985513,0.0147012,0.0213914,0.0295997,0.0406985,0.0553569,0.0737891,
0.102094,0.183757,0.290293,0.424766,0.573742,0.676685,0.872509,0.922977,0.934471,0.93134,0.918063,0.887537,
0.824469,0.76762,0.740096,0.732728,0.732925,0.726938,0.712983,0.694765,0.672139,0.64368,0.610992,0.576924,
0.525736,0.409696,0.307036,0.206906,0.101133,0.065049,0.0436491,0.0283131,0.017849,0.0105928,0.00700752,
0.00514628,0.00362813,0.00277042,0.0022901,0.00201563,0.0019127,0.00189555,0.00190412,0.00188697,0.00187839,
0.00186124,0.00186124,0.00187839,0.00190412,0.00197274,0.00204994,0.00216144,0.00228152,0.00234156,0.00236729,
0.00235871,0.00234156,0.0022901,0.00216144,0.00208424,0.00199847,0.00198132,0.00195559,0.0019127,0.00186124,
0.00179262,0.0016897,0.00156104,0.00140665,0.00126942,0.00114934,0.00114934,0.0013123,0.00151815,0.00180978,
0.00208424,0.00261603,0.00331935,0.00464881,0.00608977,0.00841417,0.0119994,0.0183036,0.0266492,0.0379967,
0.052818,0.0682226,0.0865004,0.110431,0.149817,0.208364,0.243136,0.271415,0.292317,0.305741,0.312945,
0.319824,0.331927,0.355239,0.389282,0.425932,0.458431,0.489669,0.509739,0.523523,0.529355,0.527734,0.516876,
0.499876,0.478579,0.454348,0.428908,0.39713,0.360823,0.323813,0.286708,0.247562,0.207035,0.144782,0.070384,
0.0569522,0.0457419,0.035192,0.0267178,0.0200105,0.0144182,0.0103526,0.00770227,0.00556656,0.00384256,
0.00235871,0.00162108,0.000994948,0.00072048,0.000557514,0.000454588,0.000334508,0.000291623,0.00024016,
0.000205851,0.000162966,0.000154388,0.00012008,0.00012008,0.000111503,0.000111503,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,
0.00012008,0.000137234,0.000154388,0.000205851,0.00024016,0.0003002,0.000368817,0.000463165,0.000557514,
0.000737634,0.000943485,0.00130373,0.00187839,0.00266749,0.00423711,0.00628704,0.0094177,0.0145125,0.0219232,
0.0315038,0.0447126,0.0618326,0.0852396,0.129215,0.244457,0.364854,0.552085,0.646939,0.874808,0.936581,
0.964988,0.975143,0.961377,0.93731,0.913791,0.860733,0.795006,0.742394,0.716954,0.705804,0.692098,0.674163,
0.652986,0.627306,0.598015,0.567206,0.49762,0.38152,0.282179,0.171954,0.0919555,0.0598255,0.038194,0.0237072,
0.0139464,0.00807109,0.00499189,0.00299342,0.00216144,0.00174974,0.0014238,0.00114934,0.00109787,0.00106357,
0.00108072,0.00109787,0.00107214,0.00104641,0.00104641,0.00104641,0.00104641,0.00105499,0.00109787,0.00112361,
0.00114076,0.00114076,0.00111503,0.00105499,0.00102926,0.000977794,0.000917754,0.000814828,0.00078052,
0.000763365,0.000746211,0.000746211,0.000746211,0.000746211,0.000746211,0.000737634,0.000711902,0.000669017,
0.00066044,0.000669017,0.00072048,0.000771942,0.0009006,0.00104641,0.00146669,0.00187839,0.00237587,0.003225,
0.00500047,0.00704183,0.0105156,0.0168283,0.0260488,0.0383827,0.0547136,0.0727513,0.0957123,0.132594,
0.205645,0.254261,0.294685,0.325134,0.348704,0.362556,0.368474,0.372737,0.380928,0.399163,0.427853,0.458045,
0.489154,0.508281,0.517493,0.516678,0.507921,0.492962,0.468715,0.443009,0.415391,0.384153,0.350788,0.316316,
0.279958,0.239602,0.19682,0.140416,0.10796,0.0867063,0.0447555,0.0349433,0.026795,0.0198732,0.0140494,
0.00994948,0.00726484,0.00528352,0.00357667,0.00235871,0.00165539,0.00100353,0.000711902,0.000497474,
0.000343086,0.00024016,0.000162966,0.00012008,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,
0.00012008,0.000154388,0.000205851,0.000248737,0.000334508,0.000454588,0.000574668,0.000763365,0.0010121,
0.00159535,0.0022901,0.00362813,0.00572953,0.00898884,0.0142895,0.0225493,0.0335538,0.0492928,0.0683426,
0.0970932,0.175179,0.291314,0.437202,0.587139,0.758596,0.923561,0.9654,0.99542,1,0.975444,0.942405,0.914958,
0.860579,0.792056,0.729923,0.696824,0.675089,0.65411,0.631397,0.607725,0.581787,0.555395,0.461725,0.357975,
0.260634,0.142681,0.083061,0.0551596,0.034077,0.0202249,0.0112189,0.00620127,0.00307919,0.00184408,0.00114934,
0.000943485,0.00078052,0.000754788,0.000737634,0.00072048,0.000746211,0.000746211,0.000746211,0.000746211,
0.000746211,0.00072048,0.00072048,0.000711902,0.00072048,0.00072048,0.000737634,0.00072048,0.000711902,
0.00066044,0.000608977,0.00054036,0.000497474,0.000446011,0.000368817,0.000317354,0.0003002,0.000248737,
0.00024016,0.000248737,0.000274468,0.000274468,0.0003002,0.000308777,0.000317354,0.000343086,0.000368817,
0.000454588,0.000506051,0.000591823,0.000746211,0.000943485,0.0012008,0.00176689,0.00235871,0.00375679,
0.00572953,0.00893738,0.0147012,0.0241618,0.0372419,0.0545763,0.0745525,0.101416,0.155778,0.235442,0.291528,
0.33757,0.377943,0.407963,0.426001,0.432802,0.433935,0.435504,0.443627,0.460472,0.482962,0.49979,0.505862,
0.500519,0.483433,0.457908,0.431576,0.400878,0.368937,0.337956,0.305809,0.26988,0.229027,0.180437,0.125835,
0.10103,0.0831725,0.068943,0.0562489,0.024908,0.0186381,0.013346,0.00965786,0.00706756,0.00525779,0.00343943,
0.00235871,0.00169827,0.00103783,0.000746211,0.000514628,0.000334508,0.000205851,0.00012008,0.000111503,
0.000111503,0.000111503,0.000111503,9.43485e-05,9.43485e-05,9.43485e-05,8.57714e-05,9.43485e-05,9.43485e-05,
9.43485e-05,9.43485e-05,9.43485e-05,9.43485e-05,9.43485e-05,0.000102926,0.000111503,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,
0.000128657,0.000197274,0.00024016,0.000343086,0.000497474,0.000651863,0.000866291,0.00132946,0.00204136,
0.00312208,0.00544648,0.00862002,0.0141437,0.0232526,0.0357838,0.0531354,0.0744667,0.108604,0.209154,
0.321677,0.487688,0.612974,0.834753,0.934539,0.975006,0.999974,0.992821,0.964482,0.931477,0.900565,0.822711,
0.749273,0.697201,0.664068,0.636098,0.610358,0.585261,0.561888,0.503718,0.411094,0.321488,0.231128,0.119085,
0.0762679,0.0501848,0.0303888,0.0173516,0.00910892,0.00499189,0.00217859,0.00104641,0.000711902,0.00054036,
0.000471743,0.000454588,0.000454588,0.000454588,0.000463165,0.000471743,0.000488897,0.000497474,0.000488897,
0.000471743,0.000463165,0.000463165,0.000454588,0.000454588,0.000454588,0.000454588,0.000446011,0.000377394,
0.000368817,0.000317354,0.000274468,0.000205851,0.000154388,0.00012008,0.000111503,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.00012008,0.000154388,0.000205851,
0.00024016,0.000308777,0.000377394,0.000523205,0.00066044,0.000831982,0.00111503,0.00178404,0.00265034,
0.00464023,0.00746211,0.012454,0.02146,0.0341284,0.0519003,0.0722881,0.101665,0.169647,0.251876,0.314455,
0.370232,0.421129,0.458045,0.483476,0.492962,0.490835,0.483888,0.47899,0.481358,0.486521,0.485535,0.474316,
0.453774,0.425649,0.391152,0.355085,0.321291,0.28911,0.253686,0.21641,0.162854,0.117884,0.0943228,0.0779405,
0.0639426,0.0537358,0.0428257,0.0328333,0.0115363,0.00848279,0.00629562,0.00478604,0.00321643,0.0022901,
0.00164681,0.00104641,0.000746211,0.000531783,0.000334508,0.000205851,0.00012008,0.000111503,0.000111503,
9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,
9.43485e-05,9.43485e-05,9.43485e-05,9.43485e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.000111503,
0.000111503,0.000111503,0.00012008,0.000197274,0.000274468,0.000394548,0.000557514,0.00078052,0.00111503,
0.00187839,0.00290765,0.00518917,0.00830267,0.0140665,0.0240074,0.0377994,0.0558886,0.0785323,0.115774,
0.222019,0.333445,0.501136,0.61818,0.831777,0.928861,0.95859,0.971936,0.961849,0.936984,0.909434,0.816698,
0.720625,0.675604,0.644812,0.616722,0.590047,0.565328,0.51763,0.429972,0.347734,0.269073,0.174896,0.097565,
0.0658896,0.0436147,0.0264176,0.0145726,0.00773658,0.00386829,0.00173258,0.000763365,0.000403126,0.000248737,
0.000205851,0.000205851,0.000205851,0.000205851,0.000214428,0.00024016,0.00024016,0.000248737,0.000265891,
0.000265891,0.000265891,0.000265891,0.000248737,0.000248737,0.00024016,0.00024016,0.00024016,0.000214428,
0.000205851,0.000162966,0.000137234,0.000111503,0.000111503,0.000111503,0.000111503,9.43485e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.000111503,
0.000111503,0.00012008,0.000162966,0.00024016,0.000334508,0.000454588,0.000591823,0.00078052,0.00114076,
0.00194701,0.00321643,0.00591823,0.0101811,0.0181921,0.0298141,0.0462737,0.0667387,0.0959267,0.159595,
0.252502,0.321505,0.385148,0.442675,0.490432,0.518299,0.528326,0.523248,0.508427,0.491676,0.474813,0.460524,
0.443421,0.420245,0.389316,0.352495,0.313349,0.274571,0.234816,0.194967,0.140305,0.109058,0.0890907,0.0738663,
0.0604688,0.0500476,0.0394034,0.0304574,0.0229181,0.0165024,0.00524921,0.00374821,0.00266749,0.00200705,
0.00151815,0.0010121,0.000763365,0.00054036,0.000343086,0.000205851,0.00012008,0.000111503,0.000111503,
9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,
6.004e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,8.57714e-05,9.43485e-05,9.43485e-05,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000128657,0.000205851,0.000334508,0.000506051,
0.000737634,0.00102926,0.00177547,0.00273611,0.00493185,0.00807966,0.0140665,0.0244963,0.0389488,0.0572953,
0.0801276,0.116701,0.220304,0.326223,0.478536,0.599576,0.748501,0.908628,0.927746,0.932421,0.921768,0.888463,
0.765432,0.66797,0.631783,0.610092,0.588126,0.566143,0.528103,0.445239,0.363002,0.288089,0.209154,0.114608,
0.0778976,0.0546535,0.0349004,0.0211255,0.0116906,0.00636424,0.00296769,0.00136377,0.000643285,0.000291623,
0.00012008,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,
0.000111503,0.00012008,0.00012008,0.00012008,0.000128657,0.000128657,0.000137234,0.000128657,0.00012008,
0.00012008,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,9.43485e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,8.57714e-05,
9.43485e-05,0.000111503,0.000111503,0.000111503,0.000111503,0.00012008,0.000197274,0.000274468,0.000377394,
0.000557514,0.000789097,0.00133803,0.00234156,0.00464881,0.00813113,0.014341,0.024848,0.0396006,0.0592509,
0.0858228,0.135184,0.236086,0.309806,0.376099,0.437305,0.487816,0.518299,0.528446,0.520744,0.498701,0.467445,
0.439064,0.411737,0.381683,0.349141,0.31352,0.274005,0.227612,0.172238,0.120972,0.0985856,0.0823405,0.0687972,
0.0570637,0.0465396,0.0364271,0.0281502,0.021237,0.0152673,0.010344,0.00709329,0.0019127,0.00150958,0.00105499,
0.00084056,0.00066044,0.000514628,0.000343086,0.000214428,0.00012008,0.000111503,0.000111503,9.43485e-05,
9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,5.14628e-05,5.14628e-05,2.57314e-05,1.71543e-05,
1.71543e-05,4.28857e-05,5.14628e-05,5.14628e-05,6.004e-05,6.004e-05,6.86171e-05,6.86171e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
8.57714e-05,9.43485e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.000111503,0.000162966,0.000291623,
0.000454588,0.00066044,0.000969217,0.00165539,0.00257314,0.00464881,0.00789954,0.013955,0.024299,0.0385542,
0.056652,0.078498,0.111031,0.203098,0.302198,0.429157,0.567987,0.64217,0.753442,0.831571,0.828431,0.757687,
0.670226,0.615839,0.585047,0.568741,0.555438,0.506617,0.436679,0.367213,0.300423,0.225656,0.130433,0.0871952,
0.0614466,0.0424568,0.0272496,0.0163823,0.00908319,0.00518917,0.00237587,0.00106357,0.000574668,0.00024016,
0.000111503,0.000111503,0.000111503,9.43485e-05,9.43485e-05,9.43485e-05,9.43485e-05,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,9.43485e-05,9.43485e-05,7.71942e-05,7.71942e-05,
7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.000111503,0.000137234,
0.00024016,0.000368817,0.000574668,0.000917754,0.00173258,0.00310492,0.00626131,0.0109702,0.019573,0.0322243,
0.0509139,0.0743552,0.110208,0.20212,0.280241,0.343797,0.402285,0.449253,0.478733,0.488357,0.476134,0.449468,
0.415391,0.377849,0.341567,0.307456,0.271046,0.228418,0.172967,0.117327,0.0919212,0.0748441,0.0619441,
0.0524492,0.0425769,0.0334937,0.0258772,0.0190155,0.0134833,0.00946916,0.00659582,0.00427999,0.00261603,
0.000746211,0.000617554,0.000506051,0.000377394,0.0003002,0.000205851,0.00012008,0.000111503,0.000111503,
9.43485e-05,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,3.43086e-05,
1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,3.43086e-05,5.14628e-05,5.14628e-05,
5.14628e-05,6.004e-05,6.004e-05,6.86171e-05,6.86171e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,9.43485e-05,0.000111503,0.000111503,
0.000111503,0.000128657,0.00024016,0.000377394,0.000608977,0.000909177,0.00156104,0.00247022,0.00443438,
0.00755646,0.0133375,0.0233813,0.0366072,0.0540789,0.0731544,0.0999151,0.160092,0.260531,0.360223,0.488502,
0.572232,0.60721,0.623369,0.614346,0.590622,0.565388,0.530376,0.474779,0.433343,0.390603,0.341585,0.28911,
0.227406,0.139867,0.0919984,0.0656065,0.0466339,0.0307834,0.0201563,0.0121967,0.00715333,0.0040141,0.0019899,
0.000977794,0.00054036,0.00024016,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,9.43485e-05,9.43485e-05,
0.000102926,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,9.43485e-05,9.43485e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,4.28857e-05,1.71543e-05,1.71543e-05,
1.71543e-05,4.28857e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
9.43485e-05,0.000111503,0.000111503,0.000111503,0.00012008,0.000223006,0.000377394,0.00066044,0.00107214,
0.00219575,0.00476031,0.00837986,0.0147012,0.0251396,0.0406985,0.0612236,0.0891165,0.138624,0.231531,
0.295585,0.345882,0.386434,0.410227,0.414353,0.401033,0.374967,0.339912,0.302464,0.262881,0.22256,0.168987,
0.117704,0.0923243,0.0734375,0.0583589,0.0463423,0.0367187,0.0293081,0.0228066,0.0172915,0.0120337,0.00841417,
0.00578099,0.0038254,0.00218717,0.0013895,0.000943485,0.000291623,0.000214428,0.000154388,0.00012008,
0.000111503,0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
6.004e-05,5.14628e-05,5.14628e-05,1.71543e-05,8.57714e-06,0,0,0,0,8.57714e-06,8.57714e-06,1.71543e-05,
1.71543e-05,3.43086e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.004e-05,6.004e-05,
6.86171e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,
0.000111503,0.000111503,0.000111503,0.00012008,0.000205851,0.000343086,0.000548937,0.000806251,0.00144096,
0.00234156,0.00418564,0.00707614,0.0123768,0.0214428,0.0334594,0.0489755,0.0650319,0.0858572,0.118064,
0.204513,0.287197,0.365772,0.442683,0.498649,0.511721,0.490638,0.445025,0.397911,0.354613,0.318915,0.284607,
0.243771,0.192874,0.123537,0.0915095,0.0677251,0.048701,0.032353,0.0206023,0.0127456,0.00813113,0.00504336,
0.00256456,0.00147527,0.000771942,0.000454588,0.000205851,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.86171e-05,6.86171e-05,6.86171e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,4.28857e-05,1.71543e-05,
8.57714e-06,0,0,0,8.57714e-06,1.71543e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,
7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.000137234,0.000274468,0.000497474,0.00078052,
0.00162108,0.00315639,0.00636424,0.0110216,0.0190927,0.0314438,0.0497302,0.0711902,0.10031,0.155504,0.230948,
0.278577,0.310295,0.327372,0.327973,0.314043,0.289504,0.254029,0.214,0.155032,0.114488,0.0919298,0.0745439,
0.059268,0.046145,0.0344029,0.025963,0.0197017,0.0145983,0.01073,0.00789954,0.00553225,0.00347374,0.00212713,
0.00122653,0.000763365,0.00054036,0.000368817,0.000111503,0.000111503,0.000111503,0.000111503,9.43485e-05,
9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,
4.28857e-05,1.71543e-05,8.57714e-06,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,3.43086e-05,
4.28857e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,6.86171e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,
0.000162966,0.000308777,0.000514628,0.000771942,0.0013123,0.00217859,0.00388544,0.00658724,0.0109959,
0.0188526,0.0292223,0.0420623,0.0564204,0.0720222,0.0921871,0.123708,0.201811,0.261637,0.305012,0.327063,
0.327509,0.311273,0.286193,0.253635,0.218365,0.17343,0.125604,0.0999322,0.0798532,0.0631878,0.0489326,
0.0336395,0.0216659,0.0126942,0.00781377,0.00499189,0.00269322,0.00157819,0.000849137,0.00054036,0.000291623,
0.00012008,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,
6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.004e-05,6.86171e-05,6.86171e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,
6.004e-05,5.14628e-05,5.14628e-05,2.57314e-05,1.71543e-05,8.57714e-06,0,0,0,0,0,0,8.57714e-06,2.57314e-05,
5.14628e-05,5.14628e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,0.000111503,
0.000111503,0.000205851,0.000368817,0.000626131,0.00105499,0.00229867,0.00486324,0.00841417,0.0142209,
0.0237673,0.0376108,0.0556828,0.0762593,0.101227,0.138229,0.196477,0.226728,0.240417,0.23865,0.222362,
0.19121,0.138915,0.10784,0.0874525,0.0723825,0.0589078,0.0470542,0.0352778,0.0258343,0.0181492,0.0125569,
0.00905746,0.00675879,0.00494043,0.00312208,0.00208424,0.0013123,0.00078052,0.000523205,0.0003002,0.000162966,
0.000111503,9.43485e-05,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
6.86171e-05,6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,3.43086e-05,1.71543e-05,8.57714e-06,0,0,0,0,
0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,2.57314e-05,3.43086e-05,5.14628e-05,
5.14628e-05,5.14628e-05,6.004e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.000145811,0.000274468,0.000463165,0.000746211,
0.00114076,0.00201563,0.00340512,0.00589249,0.00961497,0.0159792,0.0243848,0.034583,0.0467025,0.0587877,
0.0723482,0.0883188,0.109882,0.143092,0.18723,0.20194,0.194881,0.166113,0.133675,0.11007,0.0921442,0.0779748,
0.0653492,0.0545935,0.0429457,0.0321385,0.0223606,0.0138263,0.00813113,0.00481177,0.00250452,0.00146669,
0.000789097,0.000514628,0.0003002,0.000137234,0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,
7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,4.28857e-05,4.28857e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.004e-05,6.004e-05,6.004e-05,6.004e-05,
6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,2.57314e-05,1.71543e-05,8.57714e-06,0,0,0,0,0,
0,0,0,0,8.57714e-06,1.71543e-05,5.14628e-05,5.14628e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,
9.43485e-05,0.000111503,0.000111503,0.000145811,0.0003002,0.000514628,0.000831982,0.00176689,0.00327647,
0.00637281,0.010567,0.0177461,0.0277985,0.041805,0.0572181,0.0735833,0.0902143,0.107034,0.120963,0.129909,
0.125852,0.113338,0.0975478,0.082169,0.0681025,0.0558286,0.0446354,0.0345316,0.0260659,0.018518,0.0124283,
0.00843133,0.00586676,0.0040913,0.00261603,0.00184408,0.00114076,0.00078052,0.000548937,0.000343086,0.000197274,
0.000111503,0.000111503,0.000111503,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.86171e-05,6.86171e-05,
6.004e-05,6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,3.43086e-05,1.71543e-05,8.57714e-06,
8.57714e-06,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,
3.43086e-05,4.28857e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,6.86171e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,9.43485e-05,9.43485e-05,0.000111503,0.000111503,0.00012008,0.00024016,0.000403126,
0.00066044,0.00102926,0.00186124,0.00299342,0.00528352,0.00815686,0.0128228,0.0196931,0.0275669,0.0366072,
0.0467626,0.0565748,0.0661555,0.0770656,0.0866977,0.0943142,0.0963127,0.0919383,0.0830095,0.0729057,0.0622271,
0.0532898,0.0436576,0.0347203,0.0266492,0.0197617,0.013509,0.0087058,0.0054036,0.00273611,0.00147527,
0.00078052,0.000514628,0.000291623,0.000128657,0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,3.43086e-05,1.71543e-05,1.71543e-05,
1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,2.57314e-05,3.43086e-05,4.28857e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,3.43086e-05,1.71543e-05,8.57714e-06,8.57714e-06,
0,0,0,0,0,0,0,0,0,0,0,0,1.71543e-05,2.57314e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,
7.71942e-05,0.000111503,0.000111503,0.00012008,0.00024016,0.000454588,0.00072048,0.00121795,0.00235871,
0.00478604,0.00793385,0.0127456,0.0201477,0.0298056,0.0417707,0.0542075,0.0638997,0.0731544,0.0792185,
0.0811912,0.0786781,0.0718764,0.0624673,0.0529381,0.0418136,0.0317097,0.0238101,0.0176946,0.0122138,0.00849137,
0.00582388,0.0039026,0.00245306,0.00173258,0.00102926,0.000746211,0.000514628,0.000343086,0.000214428,
0.00012008,0.000111503,0.000111503,9.43485e-05,7.71942e-05,6.86171e-05,6.004e-05,6.004e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,3.43086e-05,1.71543e-05,
1.71543e-05,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,
1.71543e-05,3.43086e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.000205851,0.000368817,
0.0006004,0.000943485,0.00162966,0.00256456,0.00451157,0.00687029,0.0101811,0.0152673,0.0213828,0.0280301,
0.0349433,0.0428514,0.0503221,0.056043,0.060709,0.0634622,0.0631449,0.0593452,0.0532383,0.0444639,0.0357838,
0.0282188,0.0215458,0.0160821,0.011176,0.00790812,0.00539502,0.00304488,0.00180978,0.000943485,0.000557514,
0.000334508,0.000162966,0.000111503,0.000111503,8.57714e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,
6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,4.28857e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,
8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,
1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
8.57714e-06,1.71543e-05,5.14628e-05,5.14628e-05,6.004e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,
0.000111503,0.000111503,0.000205851,0.000351663,0.000574668,0.00096064,0.00184408,0.00312208,0.0057038,
0.00908319,0.0139807,0.0207567,0.0287248,0.0370189,0.0448241,0.0509139,0.054036,0.0543276,0.0518059,0.0459134,
0.0382112,0.0298399,0.0220947,0.0158162,0.0109702,0.00801962,0.00563518,0.0038254,0.00234156,0.00162108,
0.000994948,0.000711902,0.000497474,0.000317354,0.000205851,0.00012008,0.000111503,0.000111503,9.43485e-05,
7.71942e-05,7.71942e-05,7.71942e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,3.43086e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,
8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,3.43086e-05,
5.14628e-05,5.14628e-05,6.004e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
9.43485e-05,0.000111503,0.000111503,0.000111503,0.000162966,0.000317354,0.00054036,0.000789097,0.00133803,
0.00216144,0.00343943,0.00553225,0.00805393,0.0113819,0.0160307,0.0207824,0.0258429,0.0305603,0.0353207,
0.0395149,0.0423196,0.043083,0.0414876,0.0372934,0.0314867,0.0250624,0.0185609,0.0128486,0.00890307,0.00613265,
0.00423711,0.00261603,0.00173258,0.000994948,0.000643285,0.000377394,0.000205851,0.000111503,0.000111503,
9.43485e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.86171e-05,6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,
4.28857e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,8.57714e-06,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,1.71543e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,
7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.000154388,0.0003002,0.000497474,0.000763365,
0.00130373,0.00223863,0.0040141,0.00636424,0.00943485,0.0136634,0.0189812,0.024239,0.029128,0.0324559,
0.0338969,0.0332278,0.0303716,0.0262375,0.0208939,0.0155589,0.0106271,0.00746211,0.00530067,0.00335366,
0.00216144,0.0014238,0.000874868,0.000626131,0.000411703,0.000274468,0.000162966,0.000111503,0.000111503,
0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,3.43086e-05,1.71543e-05,
1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,
1.71543e-05,1.71543e-05,3.43086e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,9.43485e-05,0.000111503,0.000111503,0.000128657,0.000248737,
0.000463165,0.00072048,0.00104641,0.00180978,0.00269322,0.00433145,0.0061155,0.00838844,0.0112189,0.014564,
0.0180806,0.0210054,0.0237673,0.0260316,0.0267435,0.0263661,0.024462,0.0210054,0.0168712,0.0121281,0.00834556,
0.00560087,0.0033022,0.00201563,0.00121795,0.00078052,0.00054036,0.000334508,0.000197274,0.000111503,
0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,
5.14628e-05,3.43086e-05,1.71543e-05,1.71543e-05,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,1.71543e-05,4.28857e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,
7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.00012008,0.00024016,0.000377394,0.000591823,0.000926331,
0.00162108,0.0025131,0.00429715,0.00629562,0.0087058,0.0116821,0.01495,0.0179691,0.0198303,0.0202849,
0.0193414,0.0173087,0.0140579,0.0108329,0.0079167,0.00553225,0.00359382,0.00227294,0.00147527,0.000892022,
0.000583245,0.000368817,0.000205851,0.00012008,0.000111503,0.000111503,0.000111503,9.43485e-05,7.71942e-05,
7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,3.43086e-05,2.57314e-05,1.71543e-05,1.71543e-05,
1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,
1.71543e-05,1.71543e-05,3.43086e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,6.86171e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.000205851,0.000368817,
0.000583245,0.000857714,0.00136377,0.00208424,0.00299342,0.00464023,0.00608977,0.00789954,0.00979509,
0.0116906,0.013346,0.014624,0.0155332,0.0155332,0.0145125,0.0127885,0.010567,0.00815686,0.00577241,0.00367102,
0.00208424,0.00114076,0.000729057,0.000454588,0.000223006,0.000111503,0.000111503,0.000111503,8.57714e-05,
7.71942e-05,7.71942e-05,6.004e-05,5.14628e-05,5.14628e-05,4.28857e-05,3.43086e-05,3.43086e-05,2.57314e-05,
1.71543e-05,1.71543e-05,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,8.57714e-06,1.71543e-05,4.28857e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,
7.71942e-05,0.000111503,0.000111503,0.000111503,0.000188697,0.000308777,0.000471743,0.000703325,0.00102068,
0.00174116,0.00255599,0.00405699,0.00560087,0.00726484,0.00888592,0.010344,0.0112532,0.0113819,0.0106185,
0.0093405,0.00775373,0.00584103,0.00419422,0.00261603,0.00176689,0.00102926,0.000703325,0.000454588,0.00024016,
0.000111503,0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,
6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,4.28857e-05,3.43086e-05,3.43086e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,
8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,1.71543e-05,
1.71543e-05,3.43086e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.000154388,0.0003002,0.000497474,
0.00072048,0.000994948,0.00159535,0.00216144,0.00299342,0.00426284,0.0054036,0.00649289,0.00749642,0.00827694,
0.00868006,0.00869722,0.00831982,0.00771942,0.00677594,0.00548079,0.00395406,0.0024016,0.00152673,0.000849137,
0.00054036,0.0003002,0.00012008,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,6.86171e-05,5.14628e-05,
4.28857e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,1.71543e-05,
4.28857e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,
0.000111503,0.000137234,0.00024016,0.000368817,0.00054036,0.000746211,0.00102926,0.00165539,0.00229867,
0.00313923,0.00441723,0.00535213,0.00595253,0.00647574,0.00648432,0.00595253,0.00528352,0.00409987,0.00284761,
0.00198132,0.00126942,0.000806251,0.00054036,0.000317354,0.000154388,0.000111503,9.43485e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.86171e-05,6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,
3.43086e-05,3.43086e-05,2.57314e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,
8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,2.57314e-05,
4.28857e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.00012008,0.000214428,0.000368817,0.000557514,0.000771942,
0.00104641,0.00159535,0.00204994,0.00261603,0.003225,0.0040913,0.00470885,0.00507767,0.00525779,0.0051034,
0.00474316,0.0040913,0.00313923,0.00235871,0.00173258,0.00102068,0.000694748,0.000454588,0.00024016,0.000111503,
0.000111503,7.71942e-05,7.71942e-05,6.86171e-05,5.14628e-05,3.43086e-05,8.57714e-06,8.57714e-06,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.71543e-05,
3.43086e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,
0.000111503,0.000111503,0.000162966,0.000274468,0.000377394,0.00054036,0.000746211,0.000977794,0.00134661,
0.00186124,0.0022901,0.00275326,0.00306204,0.003225,0.0031907,0.0029248,0.00247879,0.00198132,0.00143238,
0.000943485,0.00066044,0.000454588,0.000231583,0.000111503,0.000111503,7.71942e-05,7.71942e-05,6.86171e-05,
6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,4.28857e-05,3.43086e-05,
3.43086e-05,3.43086e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,
3.43086e-05,5.14628e-05,5.14628e-05,6.004e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.000154388,0.000274468,0.000446011,0.000583245,
0.00078052,0.0010121,0.00137234,0.00177547,0.00205851,0.00234156,0.00256456,0.00269322,0.00269322,0.00255599,
0.0022901,0.00192986,0.00152673,0.00102926,0.000754788,0.00054036,0.000343086,0.000197274,0.000111503,
0.000111503,7.71942e-05,7.71942e-05,6.004e-05,5.14628e-05,1.71543e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.71543e-05,3.43086e-05,5.14628e-05,
6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,
0.00012008,0.000205851,0.000291623,0.000377394,0.000523205,0.000651863,0.000789097,0.000994948,0.0012008,
0.00152673,0.001724,0.00176689,0.00173258,0.00152673,0.00114934,0.000943485,0.000746211,0.00054036,0.000334508,
0.000162966,0.000111503,0.000111503,7.71942e-05,7.71942e-05,6.004e-05,5.14628e-05,3.43086e-05,3.43086e-05,
3.43086e-05,3.43086e-05,4.28857e-05,4.28857e-05,4.28857e-05,4.28857e-05,4.28857e-05,4.28857e-05,4.28857e-05,
5.14628e-05,4.28857e-05,4.28857e-05,4.28857e-05,4.28857e-05,3.43086e-05,3.43086e-05,3.43086e-05,2.57314e-05,
1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,3.43086e-05,5.14628e-05,
5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
9.43485e-05,0.000111503,0.000111503,0.000111503,0.000162966,0.0003002,0.000454588,0.000574668,0.000746211,
0.000917754,0.00104641,0.00130373,0.00148384,0.00160392,0.00162108,0.00156104,0.00136377,0.00110645,0.000943485,
0.000746211,0.000548937,0.000377394,0.000248737,0.000137234,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,
6.004e-05,5.14628e-05,1.71543e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,2.57314e-05,5.14628e-05,5.14628e-05,6.004e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.000128657,0.000205851,
0.000274468,0.000343086,0.000454588,0.00054036,0.000643285,0.000746211,0.000789097,0.000849137,0.000857714,
0.000814828,0.000763365,0.00066044,0.00054036,0.000377394,0.00024016,0.00012008,0.000111503,9.43485e-05,
7.71942e-05,6.86171e-05,5.14628e-05,3.43086e-05,1.71543e-05,8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,
1.71543e-05,1.71543e-05,2.57314e-05,3.43086e-05,3.43086e-05,3.43086e-05,4.28857e-05,4.28857e-05,3.43086e-05,
3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,2.57314e-05,1.71543e-05,1.71543e-05,1.71543e-05,
1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,
8.57714e-06,1.71543e-05,1.71543e-05,3.43086e-05,4.28857e-05,5.14628e-05,5.14628e-05,6.004e-05,6.004e-05,
6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,8.57714e-05,9.43485e-05,0.000111503,0.000111503,
0.000111503,0.00018012,0.000291623,0.000394548,0.00054036,0.000643285,0.000746211,0.000806251,0.000874868,
0.000917754,0.000917754,0.000831982,0.000763365,0.00066044,0.00054036,0.000394548,0.000291623,0.00018012,
0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,6.004e-05,5.14628e-05,1.71543e-05,8.57714e-06,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,8.57714e-06,1.71543e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,
9.43485e-05,0.000111503,0.000111503,0.000111503,0.000111503,0.000128657,0.000197274,0.00024016,0.000308777,
0.000343086,0.000403126,0.000471743,0.000506051,0.00054036,0.000531783,0.000497474,0.000454588,0.000343086,
0.000248737,0.000162966,0.000111503,0.000111503,9.43485e-05,7.71942e-05,6.86171e-05,5.14628e-05,4.28857e-05,
1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,
2.57314e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,
2.57314e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,
8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,
2.57314e-05,3.43086e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.000162966,
0.00024016,0.000334508,0.000446011,0.000506051,0.000548937,0.000574668,0.000591823,0.000574668,0.00054036,
0.000471743,0.000368817,0.000291623,0.000205851,0.00012008,0.000111503,0.000111503,9.43485e-05,7.71942e-05,
7.71942e-05,6.86171e-05,5.14628e-05,3.43086e-05,1.71543e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,1.71543e-05,4.28857e-05,5.14628e-05,
6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,0.000111503,
0.000111503,0.000111503,0.00012008,0.000154388,0.000205851,0.00024016,0.000248737,0.0003002,0.000308777,
0.000308777,0.0003002,0.000248737,0.000205851,0.000154388,0.000111503,0.000111503,0.000111503,9.43485e-05,
7.71942e-05,7.71942e-05,6.004e-05,5.14628e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,2.57314e-05,2.57314e-05,
3.43086e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,
1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,3.43086e-05,5.14628e-05,5.14628e-05,
5.14628e-05,6.004e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
9.43485e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.00012008,0.000188697,0.00024016,0.0003002,
0.000334508,0.000343086,0.000343086,0.000334508,0.000308777,0.00024016,0.000197274,0.00012008,0.000111503,
0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,6.86171e-05,5.14628e-05,5.14628e-05,1.71543e-05,
8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,8.57714e-06,1.71543e-05,3.43086e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,8.57714e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,
0.00012008,0.000137234,0.000154388,0.000162966,0.000162966,0.000154388,0.000145811,0.00012008,0.000111503,
0.000111503,0.000111503,0.000111503,7.71942e-05,7.71942e-05,7.71942e-05,6.004e-05,5.14628e-05,3.43086e-05,
1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,
1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,
1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,
1.71543e-05,3.43086e-05,4.28857e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,6.86171e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,8.57714e-05,9.43485e-05,0.000111503,0.000111503,
0.000111503,0.000111503,0.00012008,0.000137234,0.000154388,0.000162966,0.000162966,0.000154388,0.000128657,
0.00012008,0.000111503,0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,
5.14628e-05,5.14628e-05,1.71543e-05,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,1.71543e-05,3.43086e-05,5.14628e-05,
5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,9.43485e-05,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,
6.86171e-05,5.14628e-05,5.14628e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,
1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,
8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,
8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,2.57314e-05,3.43086e-05,5.14628e-05,5.14628e-05,
5.14628e-05,6.004e-05,6.004e-05,6.86171e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,9.43485e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,9.43485e-05,7.71942e-05,
7.71942e-05,7.71942e-05,6.86171e-05,5.14628e-05,5.14628e-05,2.57314e-05,8.57714e-06,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,
1.71543e-05,2.57314e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,9.43485e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,9.43485e-05,9.43485e-05,7.71942e-05,
7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,2.57314e-05,1.71543e-05,8.57714e-06,8.57714e-06,
0,0,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,
1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,
8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,3.43086e-05,4.28857e-05,5.14628e-05,
5.14628e-05,5.14628e-05,6.004e-05,6.004e-05,6.86171e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,9.43485e-05,0.000102926,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,9.43485e-05,9.43485e-05,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,6.004e-05,5.14628e-05,5.14628e-05,1.71543e-05,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,1.71543e-05,
1.71543e-05,4.28857e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,9.43485e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,9.43485e-05,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
6.86171e-05,6.004e-05,5.14628e-05,3.43086e-05,1.71543e-05,8.57714e-06,8.57714e-06,0,0,0,0,0,8.57714e-06,
8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,
1.71543e-05,1.71543e-05,1.71543e-05,3.43086e-05,3.43086e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
6.004e-05,6.004e-05,6.86171e-05,6.86171e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,3.43086e-05,
1.71543e-05,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,1.71543e-05,3.43086e-05,5.14628e-05,5.14628e-05,
6.004e-05,6.86171e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,9.43485e-05,9.43485e-05,9.43485e-05,9.43485e-05,9.43485e-05,9.43485e-05,8.57714e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,4.28857e-05,1.71543e-05,
8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,2.57314e-05,3.43086e-05,4.28857e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.004e-05,6.004e-05,6.86171e-05,6.86171e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,
1.71543e-05,1.71543e-05,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,1.71543e-05,3.43086e-05,5.14628e-05,
5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,2.57314e-05,
1.71543e-05,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,
1.71543e-05,1.71543e-05,1.71543e-05,2.57314e-05,3.43086e-05,3.43086e-05,4.28857e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.004e-05,6.004e-05,6.86171e-05,6.86171e-05,6.86171e-05,
6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,
6.86171e-05,6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,3.43086e-05,1.71543e-05,8.57714e-06,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,8.57714e-06,8.57714e-06,1.71543e-05,3.43086e-05,4.28857e-05,5.14628e-05,5.14628e-05,6.004e-05,
6.004e-05,6.86171e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,
6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,3.43086e-05,1.71543e-05,8.57714e-06,8.57714e-06,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,
8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,
1.71543e-05,1.71543e-05,1.71543e-05,2.57314e-05,3.43086e-05,3.43086e-05,3.43086e-05,4.28857e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.004e-05,6.004e-05,6.004e-05,6.004e-05,
6.86171e-05,6.86171e-05,6.86171e-05,6.86171e-05,6.86171e-05,6.004e-05,6.004e-05,6.004e-05,5.14628e-05,
5.14628e-05,5.14628e-05,3.43086e-05,1.71543e-05,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,
8.57714e-06,8.57714e-06,1.71543e-05,2.57314e-05,3.43086e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,
6.004e-05,6.86171e-05,6.86171e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.86171e-05,6.004e-05,6.004e-05,
5.14628e-05,5.14628e-05,3.43086e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,
2.57314e-05,2.57314e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,4.28857e-05,4.28857e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
3.43086e-05,1.71543e-05,1.71543e-05,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,3.43086e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
6.004e-05,6.004e-05,6.004e-05,6.86171e-05,6.86171e-05,6.86171e-05,6.86171e-05,6.86171e-05,7.71942e-05,
6.86171e-05,6.86171e-05,6.86171e-05,6.86171e-05,6.86171e-05,6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,
5.14628e-05,4.28857e-05,2.57314e-05,1.71543e-05,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,
1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,2.57314e-05,2.57314e-05,3.43086e-05,3.43086e-05,3.43086e-05,
3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,4.28857e-05,
4.28857e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,3.43086e-05,1.71543e-05,
1.71543e-05,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,3.43086e-05,4.28857e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.004e-05,6.004e-05,6.004e-05,6.004e-05,6.86171e-05,
6.86171e-05,6.86171e-05,6.004e-05,6.004e-05,6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
4.28857e-05,2.57314e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,
1.71543e-05,1.71543e-05,1.71543e-05,2.57314e-05,3.43086e-05,3.43086e-05,4.28857e-05,4.28857e-05,4.28857e-05,
4.28857e-05,4.28857e-05,4.28857e-05,4.28857e-05,4.28857e-05,4.28857e-05,4.28857e-05,3.43086e-05,3.43086e-05,
3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,4.28857e-05,4.28857e-05,5.14628e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,3.43086e-05,3.43086e-05,2.57314e-05,1.71543e-05,
1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,
1.71543e-05,3.43086e-05,3.43086e-05,4.28857e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,6.004e-05,6.004e-05,6.004e-05,6.004e-05,6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,3.43086e-05,2.57314e-05,1.71543e-05,1.71543e-05,8.57714e-06,
8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,
8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,2.57314e-05,3.43086e-05,3.43086e-05,4.28857e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,4.28857e-05,4.28857e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,
3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,2.57314e-05,2.57314e-05,
1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,
8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,
1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,2.57314e-05,3.43086e-05,3.43086e-05,4.28857e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,
3.43086e-05,1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,
1.71543e-05,1.71543e-05,3.43086e-05,4.28857e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,3.43086e-05,3.43086e-05,2.57314e-05,1.71543e-05,1.71543e-05,
1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,
1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,
1.71543e-05,1.71543e-05,1.71543e-05,2.57314e-05,2.57314e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,
3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,4.28857e-05,
4.28857e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,3.43086e-05,3.43086e-05,2.57314e-05,1.71543e-05,
1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,2.57314e-05,3.43086e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.004e-05,6.004e-05,
6.004e-05,6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
5.14628e-05,4.28857e-05,3.43086e-05,3.43086e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,
1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,2.57314e-05,3.43086e-05,3.43086e-05,
4.28857e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,
4.28857e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,4.28857e-05,4.28857e-05,
4.28857e-05,4.28857e-05,4.28857e-05,4.28857e-05,4.28857e-05,4.28857e-05,4.28857e-05,4.28857e-05,3.43086e-05,
3.43086e-05,2.57314e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,
1.71543e-05,1.71543e-05,2.57314e-05,4.28857e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,
6.004e-05,6.004e-05,6.004e-05,6.86171e-05,6.86171e-05,6.86171e-05,6.004e-05,6.004e-05,6.004e-05,6.004e-05,
6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,3.43086e-05,1.71543e-05,
1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,3.43086e-05,4.28857e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,4.28857e-05,3.43086e-05,3.43086e-05,3.43086e-05,
3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,2.57314e-05,
2.57314e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,
8.57714e-06,1.71543e-05,2.57314e-05,4.28857e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.004e-05,
6.86171e-05,6.86171e-05,6.86171e-05,6.86171e-05,6.86171e-05,7.71942e-05,6.86171e-05,6.86171e-05,6.86171e-05,
6.86171e-05,6.86171e-05,6.004e-05,6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
3.43086e-05,1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,8.57714e-06,1.71543e-05,1.71543e-05,3.43086e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,4.28857e-05,3.43086e-05,
3.43086e-05,3.43086e-05,3.43086e-05,2.57314e-05,2.57314e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,
1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,
1.71543e-05,1.71543e-05,3.43086e-05,5.14628e-05,5.14628e-05,6.004e-05,6.004e-05,6.86171e-05,6.86171e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,6.86171e-05,6.86171e-05,6.86171e-05,6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,
3.43086e-05,2.57314e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,
8.57714e-06,1.71543e-05,3.43086e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.004e-05,6.004e-05,
6.86171e-05,6.86171e-05,6.86171e-05,6.86171e-05,6.86171e-05,6.004e-05,6.004e-05,6.004e-05,6.004e-05,6.004e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,3.43086e-05,3.43086e-05,
3.43086e-05,2.57314e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,
1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,1.71543e-05,
3.43086e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,6.86171e-05,6.86171e-05,6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,4.28857e-05,
3.43086e-05,1.71543e-05,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,1.71543e-05,3.43086e-05,
5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,6.86171e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.86171e-05,6.86171e-05,6.86171e-05,6.004e-05,
6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,3.43086e-05,
3.43086e-05,2.57314e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,
8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,
8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,1.71543e-05,2.57314e-05,5.14628e-05,5.14628e-05,6.004e-05,
6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
6.86171e-05,6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,3.43086e-05,1.71543e-05,8.57714e-06,
8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,1.71543e-05,1.71543e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.86171e-05,6.004e-05,
6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,3.43086e-05,2.57314e-05,
1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,1.71543e-05,4.28857e-05,5.14628e-05,6.004e-05,
6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,8.57714e-05,9.43485e-05,9.43485e-05,
9.43485e-05,9.43485e-05,9.43485e-05,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,6.86171e-05,6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,3.43086e-05,1.71543e-05,
8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,1.71543e-05,3.43086e-05,5.14628e-05,6.004e-05,6.86171e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
6.86171e-05,6.86171e-05,6.86171e-05,6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
3.43086e-05,3.43086e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,0,0,8.57714e-06,8.57714e-06,
1.71543e-05,3.43086e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
9.43485e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,9.43485e-05,
9.43485e-05,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,
6.004e-05,5.14628e-05,5.14628e-05,4.28857e-05,1.71543e-05,1.71543e-05,8.57714e-06,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,
1.71543e-05,5.14628e-05,5.14628e-05,6.004e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,
9.43485e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000102926,9.43485e-05,
9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,
6.86171e-05,6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,3.43086e-05,1.71543e-05,
1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,
8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,0,0,8.57714e-06,8.57714e-06,1.71543e-05,
2.57314e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,9.43485e-05,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,
0.000111503,0.000111503,9.43485e-05,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,2.57314e-05,1.71543e-05,8.57714e-06,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,
2.57314e-05,5.14628e-05,5.14628e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,
0.000111503,0.000111503,9.43485e-05,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,6.86171e-05,6.86171e-05,6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,3.43086e-05,
2.57314e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,
1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,
1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,5.14628e-05,5.14628e-05,6.86171e-05,7.71942e-05,7.71942e-05,
7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,9.43485e-05,9.43485e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,3.43086e-05,
1.71543e-05,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,1.71543e-05,5.14628e-05,5.14628e-05,6.86171e-05,7.71942e-05,
7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.00012008,0.000128657,0.000154388,
0.000162966,0.000162966,0.000154388,0.000137234,0.00012008,0.000111503,0.000111503,0.000111503,0.000111503,
9.43485e-05,8.57714e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.86171e-05,
6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,3.43086e-05,1.71543e-05,1.71543e-05,8.57714e-06,
8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,
1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,
8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,3.43086e-05,5.14628e-05,
6.004e-05,7.71942e-05,7.71942e-05,7.71942e-05,0.000111503,0.000111503,0.000111503,0.000111503,0.00012008,
0.000145811,0.000154388,0.000162966,0.000162966,0.000154388,0.000137234,0.00012008,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,9.43485e-05,8.57714e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
6.86171e-05,6.004e-05,5.14628e-05,3.43086e-05,1.71543e-05,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,1.71543e-05,5.14628e-05,
5.14628e-05,6.86171e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.00012008,
0.000197274,0.00024016,0.000308777,0.000334508,0.000343086,0.000343086,0.000334508,0.0003002,0.00024016,
0.000188697,0.00012008,0.000111503,0.000111503,0.000111503,9.43485e-05,9.43485e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,
3.43086e-05,1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,
1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,3.43086e-05,2.57314e-05,2.57314e-05,
1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,
8.57714e-06,8.57714e-06,1.71543e-05,5.14628e-05,6.004e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,
0.000111503,0.000111503,0.000154388,0.000205851,0.000248737,0.0003002,0.000308777,0.000308777,0.0003002,
0.000248737,0.00024016,0.000205851,0.000154388,0.00012008,0.000111503,0.000111503,0.000111503,0.000111503,
9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,4.28857e-05,
1.71543e-05,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.71543e-05,3.43086e-05,5.14628e-05,6.86171e-05,7.71942e-05,7.71942e-05,9.43485e-05,
0.000111503,0.000111503,0.00012008,0.000205851,0.000291623,0.000368817,0.000471743,0.00054036,0.000574668,
0.000591823,0.000574668,0.000548937,0.000506051,0.000446011,0.000334508,0.00024016,0.000162966,0.000111503,
0.000111503,0.000111503,9.43485e-05,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,3.43086e-05,2.57314e-05,1.71543e-05,1.71543e-05,
8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,2.57314e-05,3.43086e-05,3.43086e-05,
3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,2.57314e-05,1.71543e-05,1.71543e-05,
1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,4.28857e-05,5.14628e-05,
6.86171e-05,7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.000162966,0.000248737,0.000343086,0.000454588,
0.000497474,0.000531783,0.00054036,0.000506051,0.000471743,0.000403126,0.000343086,0.000308777,0.00024016,
0.000197274,0.000128657,0.000111503,0.000111503,0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,
7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,1.71543e-05,8.57714e-06,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,1.71543e-05,
5.14628e-05,6.004e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.00018012,0.000291623,
0.000394548,0.00054036,0.00066044,0.000763365,0.000831982,0.000917754,0.000917754,0.000874868,0.000806251,
0.000746211,0.000643285,0.00054036,0.000394548,0.000291623,0.00018012,0.000111503,0.000111503,0.000111503,
9.43485e-05,8.57714e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,6.004e-05,
5.14628e-05,5.14628e-05,4.28857e-05,3.43086e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,
1.71543e-05,2.57314e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,3.43086e-05,4.28857e-05,
4.28857e-05,3.43086e-05,3.43086e-05,3.43086e-05,2.57314e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,
1.71543e-05,8.57714e-06,1.71543e-05,3.43086e-05,5.14628e-05,6.86171e-05,7.71942e-05,9.43485e-05,0.000111503,
0.00012008,0.00024016,0.000377394,0.00054036,0.00066044,0.000763365,0.000814828,0.000857714,0.000849137,
0.000789097,0.000746211,0.000643285,0.00054036,0.000454588,0.000343086,0.000274468,0.000205851,0.000128657,
0.000111503,0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.004e-05,
5.14628e-05,5.14628e-05,2.57314e-05,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.71543e-05,5.14628e-05,6.004e-05,7.71942e-05,7.71942e-05,
9.43485e-05,0.000111503,0.000137234,0.000248737,0.000377394,0.000548937,0.000746211,0.000943485,0.00110645,
0.00136377,0.00156104,0.00162108,0.00160392,0.00148384,0.00130373,0.00104641,0.000917754,0.000746211,
0.000574668,0.000454588,0.0003002,0.000162966,0.000111503,0.000111503,0.000111503,9.43485e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,
3.43086e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,2.57314e-05,
3.43086e-05,3.43086e-05,3.43086e-05,4.28857e-05,4.28857e-05,4.28857e-05,4.28857e-05,5.14628e-05,4.28857e-05,
4.28857e-05,4.28857e-05,4.28857e-05,4.28857e-05,4.28857e-05,4.28857e-05,3.43086e-05,3.43086e-05,3.43086e-05,
3.43086e-05,5.14628e-05,6.004e-05,7.71942e-05,7.71942e-05,0.000111503,0.000111503,0.000162966,0.000334508,
0.00054036,0.000746211,0.000943485,0.00114934,0.00152673,0.00173258,0.00176689,0.001724,0.00152673,0.0012008,
0.000994948,0.000789097,0.000651863,0.000523205,0.000377394,0.000291623,0.000205851,0.00012008,0.000111503,
0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,
3.43086e-05,1.71543e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,1.71543e-05,5.14628e-05,6.004e-05,7.71942e-05,7.71942e-05,0.000111503,0.000111503,
0.000197274,0.000343086,0.00054036,0.000754788,0.00102926,0.00152673,0.00192986,0.0022901,0.00255599,
0.00269322,0.00269322,0.00256456,0.00234156,0.00205851,0.00177547,0.00137234,0.0010121,0.00078052,0.000583245,
0.000446011,0.000274468,0.000154388,0.000111503,0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,3.43086e-05,1.71543e-05,
1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,
8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,3.43086e-05,3.43086e-05,3.43086e-05,
4.28857e-05,4.28857e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,
7.71942e-05,7.71942e-05,0.000111503,0.000111503,0.000231583,0.000454588,0.00066044,0.000943485,0.00143238,
0.00198132,0.00247879,0.0029248,0.0031907,0.003225,0.00306204,0.00275326,0.0022901,0.00186124,0.00134661,
0.000977794,0.000746211,0.00054036,0.000377394,0.000274468,0.000162966,0.000111503,0.000111503,0.000111503,
9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,3.43086e-05,1.71543e-05,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,
8.57714e-06,3.43086e-05,5.14628e-05,6.86171e-05,7.71942e-05,7.71942e-05,0.000111503,0.000111503,0.00024016,
0.000454588,0.000694748,0.00102068,0.00173258,0.00235871,0.00313923,0.0040913,0.00474316,0.0051034,0.00525779,
0.00507767,0.00470885,0.0040913,0.003225,0.00261603,0.00204994,0.00159535,0.00104641,0.000771942,0.000557514,
0.000368817,0.000214428,0.00012008,0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,4.28857e-05,2.57314e-05,1.71543e-05,
1.71543e-05,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,
1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,2.57314e-05,3.43086e-05,3.43086e-05,4.28857e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
6.004e-05,6.004e-05,6.86171e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,
0.000111503,0.000154388,0.000317354,0.00054036,0.000806251,0.00126942,0.00198132,0.00284761,0.00409987,
0.00528352,0.00595253,0.00648432,0.00647574,0.00595253,0.00535213,0.00441723,0.00313923,0.00229867,0.00165539,
0.00102926,0.000746211,0.00054036,0.000368817,0.00024016,0.000137234,0.000111503,0.000111503,9.43485e-05,
7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,4.28857e-05,1.71543e-05,8.57714e-06,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,
8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,4.28857e-05,5.14628e-05,6.86171e-05,
7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,0.00012008,0.0003002,0.00054036,0.000849137,0.00152673,
0.0024016,0.00395406,0.00548079,0.00677594,0.00771942,0.00831982,0.00869722,0.00868006,0.00827694,0.00749642,
0.00649289,0.0054036,0.00426284,0.00299342,0.00216144,0.00159535,0.000994948,0.00072048,0.000497474,0.0003002,
0.000154388,0.000111503,0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,3.43086e-05,1.71543e-05,1.71543e-05,8.57714e-06,
8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,
1.71543e-05,1.71543e-05,3.43086e-05,3.43086e-05,4.28857e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,6.86171e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.00024016,0.000454588,
0.000703325,0.00102926,0.00176689,0.00261603,0.00419422,0.00584103,0.00775373,0.0093405,0.0106185,0.0113819,
0.0112532,0.010344,0.00888592,0.00726484,0.00560087,0.00405699,0.00255599,0.00174116,0.00102068,0.000703325,
0.000471743,0.000308777,0.000188697,0.000111503,0.000111503,0.000111503,7.71942e-05,7.71942e-05,7.71942e-05,
6.86171e-05,6.004e-05,5.14628e-05,4.28857e-05,1.71543e-05,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,1.71543e-05,1.71543e-05,2.57314e-05,3.43086e-05,
3.43086e-05,4.28857e-05,5.14628e-05,5.14628e-05,6.004e-05,7.71942e-05,7.71942e-05,8.57714e-05,0.000111503,
0.000111503,0.000111503,0.000223006,0.000454588,0.000729057,0.00114076,0.00208424,0.00367102,0.00577241,
0.00815686,0.010567,0.0127885,0.0145125,0.0155332,0.0155332,0.014624,0.013346,0.0116906,0.00979509,0.00789954,
0.00608977,0.00464023,0.00299342,0.00208424,0.00136377,0.000857714,0.000583245,0.000368817,0.000205851,
0.000111503,0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,
6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,3.43086e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,
8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,
2.57314e-05,3.43086e-05,4.28857e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,
0.000111503,0.000111503,0.000111503,0.00012008,0.000205851,0.000368817,0.000583245,0.000892022,0.00147527,
0.00227294,0.00359382,0.00553225,0.0079167,0.0108329,0.0140579,0.0173087,0.0193414,0.0202849,0.0198303,
0.0179691,0.01495,0.0116821,0.0087058,0.00629562,0.00429715,0.0025131,0.00162108,0.000926331,0.000591823,
0.000377394,0.00024016,0.00012008,0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,6.86171e-05,
6.004e-05,5.14628e-05,4.28857e-05,1.71543e-05,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,1.71543e-05,1.71543e-05,3.43086e-05,5.14628e-05,5.14628e-05,5.14628e-05,
5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.000197274,
0.000334508,0.00054036,0.00078052,0.00121795,0.00201563,0.0033022,0.00560087,0.00834556,0.0121281,0.0168712,
0.0210054,0.024462,0.0263661,0.0267435,0.0260316,0.0237673,0.0210054,0.0180806,0.014564,0.0112189,0.00838844,
0.0061155,0.00433145,0.00269322,0.00180978,0.00104641,0.00072048,0.000463165,0.000248737,0.000128657,
0.000111503,0.000111503,9.43485e-05,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,
6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,3.43086e-05,1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,3.43086e-05,
4.28857e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,
0.000162966,0.000274468,0.000411703,0.000626131,0.000874868,0.0014238,0.00216144,0.00335366,0.00530067,
0.00746211,0.0106271,0.0155589,0.0208939,0.0262375,0.0303716,0.0332278,0.0338969,0.0324559,0.029128,0.024239,
0.0189812,0.0136634,0.00943485,0.00636424,0.0040141,0.00223863,0.00130373,0.000763365,0.000497474,0.0003002,
0.000154388,0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,
5.14628e-05,1.71543e-05,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,0,0,0,0,0,0,
0,0,0,0,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,4.28857e-05,5.14628e-05,5.14628e-05,6.004e-05,
6.004e-05,6.86171e-05,6.86171e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.000205851,
0.000377394,0.000643285,0.000994948,0.00173258,0.00261603,0.00423711,0.00613265,0.00890307,0.0128486,
0.0185609,0.0250624,0.0314867,0.0372934,0.0414876,0.043083,0.0423196,0.0395149,0.0353207,0.0305603,0.0258429,
0.0207824,0.0160307,0.0113819,0.00805393,0.00553225,0.00343943,0.00216144,0.00133803,0.000789097,0.00054036,
0.000317354,0.000162966,0.000111503,0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,6.86171e-05,6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,3.43086e-05,1.71543e-05,1.71543e-05,
8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,
1.71543e-05,3.43086e-05,4.28857e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,
5.14628e-05,5.14628e-05,5.14628e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,0.000111503,
0.00012008,0.000205851,0.000317354,0.000497474,0.000711902,0.000994948,0.00162108,0.00234156,0.0038254,
0.00563518,0.00801962,0.0109702,0.0158162,0.0220947,0.0298399,0.0382112,0.0459134,0.0518059,0.0543276,
0.054036,0.0509139,0.0448241,0.0370189,0.0287248,0.0207567,0.0139807,0.00908319,0.0057038,0.00312208,
0.00184408,0.00096064,0.000574668,0.000351663,0.000205851,0.000111503,0.000111503,9.43485e-05,7.71942e-05,
7.71942e-05,7.71942e-05,6.004e-05,5.14628e-05,5.14628e-05,1.71543e-05,8.57714e-06,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,
1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,
1.71543e-05,1.71543e-05,4.28857e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,6.86171e-05,7.71942e-05,
7.71942e-05,7.71942e-05,8.57714e-05,0.000111503,0.000111503,0.000162966,0.000334508,0.000557514,0.000943485,
0.00180978,0.00304488,0.00539502,0.00790812,0.011176,0.0160821,0.0215458,0.0282188,0.0357838,0.0444639,
0.0532383,0.0593452,0.0631449,0.0634622,0.060709,0.056043,0.0503221,0.0428514,0.0349433,0.0280301,0.0213828,
0.0152673,0.0101811,0.00687029,0.00451157,0.00256456,0.00162966,0.000943485,0.0006004,0.000368817,0.000205851,
0.000111503,0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,3.43086e-05,1.71543e-05,1.71543e-05,8.57714e-06,
8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,1.71543e-05,1.71543e-05,3.43086e-05,
4.28857e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,
6.004e-05,6.86171e-05,7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.00012008,0.000214428,0.000343086,
0.000514628,0.000746211,0.00102926,0.00173258,0.00245306,0.0039026,0.00582388,0.00849137,0.0122138,0.0176946,
0.0238101,0.0317097,0.0418136,0.0529381,0.0624673,0.0718764,0.0786781,0.0811912,0.0792185,0.0731544,0.0638997,
0.0542075,0.0417707,0.0298056,0.0201477,0.0127456,0.00793385,0.00478604,0.00235871,0.00121795,0.00072048,
0.000454588,0.00024016,0.00012008,0.000111503,0.000111503,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,
6.004e-05,5.14628e-05,2.57314e-05,1.71543e-05,0,0,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,1.71543e-05,
3.43086e-05,4.28857e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,
3.43086e-05,2.57314e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,1.71543e-05,3.43086e-05,
5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,
0.000111503,0.000111503,0.000128657,0.000291623,0.000514628,0.00078052,0.00147527,0.00273611,0.0054036,
0.0087058,0.013509,0.0197617,0.0266492,0.0347203,0.0436576,0.0532898,0.0622271,0.0729057,0.0830095,0.0919383,
0.0963127,0.0943142,0.0866977,0.0770656,0.0661555,0.0565748,0.0467626,0.0366072,0.0275669,0.0196931,0.0128228,
0.00815686,0.00528352,0.00299342,0.00186124,0.00102926,0.00066044,0.000403126,0.00024016,0.00012008,0.000111503,
0.000111503,9.43485e-05,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.86171e-05,
6.004e-05,5.14628e-05,5.14628e-05,4.28857e-05,3.43086e-05,1.71543e-05,1.71543e-05,1.71543e-05,8.57714e-06,
8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,0,8.57714e-06,8.57714e-06,1.71543e-05,3.43086e-05,5.14628e-05,
5.14628e-05,5.14628e-05,6.004e-05,6.004e-05,6.004e-05,6.86171e-05,6.86171e-05,6.86171e-05,7.71942e-05,
7.71942e-05,7.71942e-05,0.000111503,0.000111503,0.000111503,0.000197274,0.000343086,0.000548937,0.00078052,
0.00114076,0.00184408,0.00261603,0.0040913,0.00586676,0.00843133,0.0124283,0.018518,0.0260659,0.0345316,
0.0446354,0.0558286,0.0681025,0.082169,0.0975478,0.113338,0.125852,0.129909,0.120963,0.107034,0.0902143,
0.0735833,0.0572181,0.041805,0.0277985,0.0177461,0.010567,0.00637281,0.00327647,0.00176689,0.000831982,
0.000514628,0.0003002,0.000145811,0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,
6.86171e-05,5.14628e-05,5.14628e-05,1.71543e-05,8.57714e-06,0,0,0,0,0,0,0,0,0,8.57714e-06,1.71543e-05,
2.57314e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.004e-05,6.004e-05,6.004e-05,6.004e-05,6.004e-05,
6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,4.28857e-05,4.28857e-05,
5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,
0.000111503,0.000111503,0.000137234,0.0003002,0.000514628,0.000789097,0.00146669,0.00250452,0.00481177,
0.00813113,0.0138263,0.0223606,0.0321385,0.0429457,0.0545935,0.0653492,0.0779748,0.0921442,0.11007,0.133675,
0.166113,0.194881,0.20194,0.18723,0.143092,0.109882,0.0883188,0.0723482,0.0587877,0.0467025,0.034583,
0.0243848,0.0159792,0.00961497,0.00589249,0.00340512,0.00201563,0.00114076,0.000746211,0.000463165,0.000274468,
0.000145811,0.000111503,0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,6.86171e-05,6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,3.43086e-05,2.57314e-05,
1.71543e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,0,0,8.57714e-06,1.71543e-05,
3.43086e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,9.43485e-05,0.000111503,0.000162966,0.0003002,0.000523205,
0.00078052,0.0013123,0.00208424,0.00312208,0.00494043,0.00675879,0.00905746,0.0125569,0.0181492,0.0258343,
0.0352778,0.0470542,0.0589078,0.0723825,0.0874525,0.10784,0.138915,0.19121,0.222362,0.23865,0.240417,
0.226728,0.196477,0.138229,0.101227,0.0762593,0.0556828,0.0376108,0.0237673,0.0142209,0.00841417,0.00486324,
0.00229867,0.00105499,0.000626131,0.000368817,0.000205851,0.000111503,0.000111503,0.000111503,9.43485e-05,
7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,5.14628e-05,5.14628e-05,2.57314e-05,8.57714e-06,0,0,0,
0,0,0,8.57714e-06,1.71543e-05,2.57314e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.86171e-05,6.004e-05,
6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.004e-05,6.86171e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,0.00012008,0.000291623,0.00054036,0.000849137,
0.00157819,0.00269322,0.00499189,0.00781377,0.0126942,0.0216659,0.0336395,0.0489326,0.0631878,0.0798532,
0.0999322,0.125604,0.17343,0.218365,0.253635,0.286193,0.311273,0.327509,0.327063,0.305012,0.261637,0.201811,
0.123708,0.0921871,0.0720222,0.0564204,0.0420623,0.0292223,0.0188526,0.0109959,0.00658724,0.00388544,
0.00217859,0.0013123,0.000771942,0.000514628,0.000308777,0.000162966,0.000111503,0.000111503,0.000111503,
9.43485e-05,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.86171e-05,
6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,4.28857e-05,3.43086e-05,1.71543e-05,1.71543e-05,
8.57714e-06,8.57714e-06,0,0,0,0,0,0,0,8.57714e-06,1.71543e-05,4.28857e-05,5.14628e-05,6.004e-05,6.86171e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,9.43485e-05,0.000111503,0.000111503,
0.000111503,0.000111503,0.000368817,0.00054036,0.000763365,0.00122653,0.00212713,0.00347374,0.00553225,
0.00789954,0.01073,0.0145983,0.0197017,0.025963,0.0344029,0.046145,0.059268,0.0745439,0.0919298,0.114488,
0.155032,0.214,0.254029,0.289504,0.314043,0.327973,0.327372,0.310295,0.278577,0.230948,0.155504,0.10031,
0.0711902,0.0497302,0.0314438,0.0190927,0.0110216,0.00636424,0.00315639,0.00162108,0.00078052,0.000497474,
0.000274468,0.000137234,0.000111503,0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,
6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,1.71543e-05,8.57714e-06,0,0,0,8.57714e-06,1.71543e-05,4.28857e-05,
5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
6.86171e-05,6.86171e-05,6.86171e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
9.43485e-05,0.000111503,0.000205851,0.000454588,0.000771942,0.00147527,0.00256456,0.00504336,0.00813113,
0.0127456,0.0206023,0.032353,0.048701,0.0677251,0.0915095,0.123537,0.192874,0.243771,0.284607,0.318915,
0.354613,0.397911,0.445025,0.490638,0.511721,0.498649,0.442683,0.365772,0.287197,0.204513,0.118064,0.0858572,
0.0650319,0.0489755,0.0334594,0.0214428,0.0123768,0.00707614,0.00418564,0.00234156,0.00144096,0.000806251,
0.000548937,0.000343086,0.000205851,0.00012008,0.000111503,0.000111503,0.000111503,9.43485e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.86171e-05,6.004e-05,6.004e-05,
6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,5.14628e-05,3.43086e-05,1.71543e-05,1.71543e-05,8.57714e-06,
8.57714e-06,0,0,0,0,8.57714e-06,1.71543e-05,5.14628e-05,5.14628e-05,6.004e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.00012008,0.000154388,
0.000214428,0.000291623,0.000943485,0.0013895,0.00218717,0.0038254,0.00578099,0.00841417,0.0120337,0.0172915,
0.0228066,0.0293081,0.0367187,0.0463423,0.0583589,0.0734375,0.0923243,0.117704,0.168987,0.22256,0.262881,
0.302464,0.339912,0.374967,0.401033,0.414353,0.410227,0.386434,0.345882,0.295585,0.231531,0.138624,0.0891165,
0.0612236,0.0406985,0.0251396,0.0147012,0.00837986,0.00476031,0.00219575,0.00107214,0.00066044,0.000377394,
0.000223006,0.00012008,0.000111503,0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,6.86171e-05,6.004e-05,5.14628e-05,4.28857e-05,1.71543e-05,1.71543e-05,1.71543e-05,4.28857e-05,
5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,9.43485e-05,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000102926,9.43485e-05,9.43485e-05,9.43485e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,9.43485e-05,0.000111503,0.00024016,0.00054036,0.000977794,0.0019899,0.0040141,0.00715333,
0.0121967,0.0201563,0.0307834,0.0466339,0.0656065,0.0919984,0.139867,0.227406,0.28911,0.341585,0.390603,
0.433343,0.474779,0.530376,0.565388,0.590622,0.614346,0.623369,0.60721,0.572232,0.488502,0.360223,0.260531,
0.160092,0.0999151,0.0731544,0.0540789,0.0366072,0.0233813,0.0133375,0.00755646,0.00443438,0.00247022,
0.00156104,0.000909177,0.000608977,0.000377394,0.00024016,0.000128657,0.000111503,0.000111503,0.000111503,
9.43485e-05,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,6.86171e-05,6.86171e-05,6.86171e-05,6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,
3.43086e-05,1.71543e-05,8.57714e-06,8.57714e-06,8.57714e-06,8.57714e-06,1.71543e-05,3.43086e-05,5.14628e-05,
6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,9.43485e-05,0.000111503,0.000111503,
0.00012008,0.000205851,0.0003002,0.000377394,0.000506051,0.000617554,0.000746211,0.00261603,0.00427999,
0.00659582,0.00946916,0.0134833,0.0190155,0.0258772,0.0334937,0.0425769,0.0524492,0.0619441,0.0748441,
0.0919212,0.117327,0.172967,0.228418,0.271046,0.307456,0.341567,0.377849,0.415391,0.449468,0.476134,0.488357,
0.478733,0.449253,0.402285,0.343797,0.280241,0.20212,0.110208,0.0743552,0.0509139,0.0322243,0.019573,
0.0109702,0.00626131,0.00310492,0.00173258,0.000917754,0.000574668,0.000368817,0.00024016,0.000137234,
0.000111503,0.000111503,0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
6.86171e-05,6.004e-05,5.14628e-05,5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,
7.71942e-05,9.43485e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,
0.000111503,9.43485e-05,9.43485e-05,9.43485e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.00024016,
0.000574668,0.00106357,0.00237587,0.00518917,0.00908319,0.0163823,0.0272496,0.0424568,0.0614466,0.0871952,
0.130433,0.225656,0.300423,0.367213,0.436679,0.506617,0.555438,0.568741,0.585047,0.615839,0.670226,0.757687,
0.828431,0.831571,0.753442,0.64217,0.567987,0.429157,0.302198,0.203098,0.111031,0.078498,0.056652,0.0385542,
0.024299,0.013955,0.00789954,0.00464881,0.00257314,0.00165539,0.000969217,0.00066044,0.000454588,0.000291623,
0.000162966,0.000111503,0.000111503,0.000111503,0.000111503,9.43485e-05,9.43485e-05,8.57714e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
6.86171e-05,6.86171e-05,6.004e-05,6.004e-05,5.14628e-05,5.14628e-05,4.28857e-05,1.71543e-05,1.71543e-05,
2.57314e-05,5.14628e-05,5.14628e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,9.43485e-05,
0.000111503,0.000111503,0.00012008,0.000214428,0.000343086,0.000514628,0.00066044,0.00084056,0.00105499,
0.00150958,0.0019127,0.00709329,0.010344,0.0152673,0.021237,0.0281502,0.0364271,0.0465396,0.0570637,0.0687972,
0.0823405,0.0985856,0.120972,0.172238,0.227612,0.274005,0.31352,0.349141,0.381683,0.411737,0.439064,0.467445,
0.498701,0.520744,0.528446,0.518299,0.487816,0.437305,0.376099,0.309806,0.236086,0.135184,0.0858228,0.0592509,
0.0396006,0.024848,0.014341,0.00813113,0.00464881,0.00234156,0.00133803,0.000789097,0.000557514,0.000377394,
0.000274468,0.000197274,0.00012008,0.000111503,0.000111503,0.000111503,0.000111503,9.43485e-05,8.57714e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
9.43485e-05,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.00012008,0.00012008,
0.000128657,0.000137234,0.000128657,0.000128657,0.00012008,0.00012008,0.00012008,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.00012008,0.000291623,
0.000643285,0.00136377,0.00296769,0.00636424,0.0116906,0.0211255,0.0349004,0.0546535,0.0778976,0.114608,
0.209154,0.288089,0.363002,0.445239,0.528103,0.566143,0.588126,0.610092,0.631783,0.66797,0.765432,0.888463,
0.921768,0.932421,0.927746,0.908628,0.748501,0.599576,0.478536,0.326223,0.220304,0.116701,0.0801276,0.0572953,
0.0389488,0.0244963,0.0140665,0.00807966,0.00493185,0.00273611,0.00177547,0.00102926,0.000737634,0.000506051,
0.000334508,0.000205851,0.000128657,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,9.43485e-05,
9.43485e-05,8.57714e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,6.86171e-05,6.004e-05,6.004e-05,5.14628e-05,
5.14628e-05,5.14628e-05,6.004e-05,6.86171e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,
0.000111503,0.00012008,0.000205851,0.000343086,0.00054036,0.000763365,0.0010121,0.00151815,0.00200705,
0.00266749,0.00374821,0.00524921,0.0165024,0.0229181,0.0304574,0.0394034,0.0500476,0.0604688,0.0738663,
0.0890907,0.109058,0.140305,0.194967,0.234816,0.274571,0.313349,0.352495,0.389316,0.420245,0.443421,0.460524,
0.474813,0.491676,0.508427,0.523248,0.528326,0.518299,0.490432,0.442675,0.385148,0.321505,0.252502,0.159595,
0.0959267,0.0667387,0.0462737,0.0298141,0.0181921,0.0101811,0.00591823,0.00321643,0.00194701,0.00114076,
0.00078052,0.000591823,0.000454588,0.000334508,0.00024016,0.000162966,0.00012008,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,9.43485e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
9.43485e-05,0.000111503,0.000111503,0.000111503,0.000111503,0.000137234,0.000162966,0.000205851,0.000214428,
0.00024016,0.00024016,0.00024016,0.000248737,0.000248737,0.000265891,0.000265891,0.000265891,0.000265891,
0.000248737,0.00024016,0.00024016,0.000214428,0.000205851,0.000205851,0.000205851,0.000205851,0.000248737,
0.000403126,0.000763365,0.00173258,0.00386829,0.00773658,0.0145726,0.0264176,0.0436147,0.0658896,0.097565,
0.174896,0.269073,0.347734,0.429972,0.51763,0.565328,0.590047,0.616722,0.644812,0.675604,0.720625,0.816698,
0.909434,0.936984,0.961849,0.971936,0.95859,0.928861,0.831777,0.61818,0.501136,0.333445,0.222019,0.115774,
0.0785323,0.0558886,0.0377994,0.0240074,0.0140665,0.00830267,0.00518917,0.00290765,0.00187839,0.00111503,
0.00078052,0.000557514,0.000394548,0.000274468,0.000197274,0.00012008,0.000111503,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,9.43485e-05,9.43485e-05,9.43485e-05,9.43485e-05,9.43485e-05,9.43485e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,
7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,7.71942e-05,9.43485e-05,0.000111503,
0.000111503,0.00012008,0.000205851,0.000334508,0.000531783,0.000746211,0.00104641,0.00164681,0.0022901,
0.00321643,0.00478604,0.00629562,0.00848279,0.0115363,0.0328333,0.0428257,0.0537358,0.0639426,0.0779405,
0.0943228,0.117884,0.162854,0.21641,0.253686,0.28911,0.321291,0.355085,0.391152,0.425649,0.453774,0.474316,
0.485535,0.486521,0.481358,0.47899,0.483888,0.490835,0.492962,0.483476,0.458045,0.421129,0.370232,0.314455,
0.251876,0.169647,0.101665,0.0722881,0.0519003,0.0341284,0.02146,0.012454,0.00746211,0.00464023,0.00265034,
0.00178404,0.00111503,0.000831982,0.00066044,0.000523205,0.000377394,0.000308777,0.00024016,0.000205851,
0.000154388,0.00012008,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,
0.000111503,0.000111503,0.00012008,0.000154388,0.000205851,0.000274468,0.000317354,0.000368817,0.000377394,
0.000446011,0.000454588,0.000454588,0.000454588,0.000454588,0.000463165,0.000463165,0.000471743,0.000488897,
0.000497474,0.000488897,0.000471743,0.000463165,0.000454588,0.000454588,0.000454588,0.000471743,0.00054036,
0.000711902,0.00104641,0.00217859,0.00499189,0.00910892,0.0173516,0.0303888,0.0501848,0.0762679,0.119085,
0.231128,0.321488,0.411094,0.503718,0.561888,0.585261,0.610358,0.636098,0.664068,0.697201,0.749273,0.822711,
0.900565,0.931477,0.964482,0.992821,0.999974,0.975006,0.934539,0.834753,0.612974,0.487688,0.321677,0.209154,
0.108604,0.0744667,0.0531354,0.0357838,0.0232526,0.0141437,0.00862002,0.00544648,0.00312208,0.00204136,
0.00132946,0.000866291,0.000651863,0.000497474,0.000343086,0.00024016,0.000197274,0.000128657,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,
0.000111503,0.000111503,0.000102926,9.43485e-05,9.43485e-05,9.43485e-05,9.43485e-05,9.43485e-05,9.43485e-05,
9.43485e-05,8.57714e-05,9.43485e-05,9.43485e-05,9.43485e-05,0.000111503,0.000111503,0.000111503,0.000111503,
0.00012008,0.000205851,0.000334508,0.000514628,0.000746211,0.00103783,0.00169827,0.00235871,0.00343943,
0.00525779,0.00706756,0.00965786,0.013346,0.0186381,0.024908,0.0562489,0.068943,0.0831725,0.10103,0.125835,
0.180437,0.229027,0.26988,0.305809,0.337956,0.368937,0.400878,0.431576,0.457908,0.483433,0.500519,0.505862,
0.49979,0.482962,0.460472,0.443627,0.435504,0.433935,0.432802,0.426001,0.407963,0.377943,0.33757,0.291528,
0.235442,0.155778,0.101416,0.0745525,0.0545763,0.0372419,0.0241618,0.0147012,0.00893738,0.00572953,0.00375679,
0.00235871,0.00176689,0.0012008,0.000943485,0.000746211,0.000591823,0.000506051,0.000454588,0.000368817,
0.000343086,0.000317354,0.000308777,0.0003002,0.000274468,0.000274468,0.000248737,0.00024016,0.000248737,
0.0003002,0.000317354,0.000368817,0.000446011,0.000497474,0.00054036,0.000608977,0.00066044,0.000711902,
0.00072048,0.000737634,0.00072048,0.00072048,0.000711902,0.00072048,0.00072048,0.000746211,0.000746211,
0.000746211,0.000746211,0.000746211,0.00072048,0.000737634,0.000754788,0.00078052,0.000943485,0.00114934,
0.00184408,0.00307919,0.00620127,0.0112189,0.0202249,0.034077,0.0551596,0.083061,0.142681,0.260634,0.357975,
0.461725,0.555395,0.581787,0.607725,0.631397,0.65411,0.675089,0.696824,0.729923,0.792056,0.860579,0.914958,
0.942405,0.975444,1,0.99542,0.9654,0.923561,0.758596,0.587139,0.437202,0.291314,0.175179,0.0970932,0.0683426,
0.0492928,0.0335538,0.0225493,0.0142895,0.00898884,0.00572953,0.00362813,0.0022901,0.00159535,0.0010121,
0.000763365,0.000574668,0.000454588,0.000334508,0.000248737,0.000205851,0.000154388,0.00012008,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.00012008,0.000162966,0.00024016,0.000343086,0.000497474,
0.000711902,0.00100353,0.00165539,0.00235871,0.00357667,0.00528352,0.00726484,0.00994948,0.0140494,0.0198732,
0.026795,0.0349433,0.0447555,0.0867063,0.10796,0.140416,0.19682,0.239602,0.279958,0.316316,0.350788,0.384153,
0.415391,0.443009,0.468715,0.492962,0.507921,0.516678,0.517493,0.508281,0.489154,0.458045,0.427853,0.399163,
0.380928,0.372737,0.368474,0.362556,0.348704,0.325134,0.294685,0.254261,0.205645,0.132594,0.0957123,0.0727513,
0.0547136,0.0383827,0.0260488,0.0168283,0.0105156,0.00704183,0.00500047,0.003225,0.00237587,0.00187839,
0.00146669,0.00104641,0.0009006,0.000771942,0.00072048,0.000669017,0.00066044,0.000669017,0.000711902,
0.000737634,0.000746211,0.000746211,0.000746211,0.000746211,0.000746211,0.000763365,0.00078052,0.000814828,
0.000917754,0.000977794,0.00102926,0.00105499,0.00111503,0.00114076,0.00114076,0.00112361,0.00109787,
0.00105499,0.00104641,0.00104641,0.00104641,0.00104641,0.00107214,0.00109787,0.00108072,0.00106357,0.00109787,
0.00114934,0.0014238,0.00174974,0.00216144,0.00299342,0.00499189,0.00807109,0.0139464,0.0237072,0.038194,
0.0598255,0.0919555,0.171954,0.282179,0.38152,0.49762,0.567206,0.598015,0.627306,0.652986,0.674163,0.692098,
0.705804,0.716954,0.742394,0.795006,0.860733,0.913791,0.93731,0.961377,0.975143,0.964988,0.936581,0.874808,
0.646939,0.552085,0.364854,0.244457,0.129215,0.0852396,0.0618326,0.0447126,0.0315038,0.0219232,0.0145125,
0.0094177,0.00628704,0.00423711,0.00266749,0.00187839,0.00130373,0.000943485,0.000737634,0.000557514,
0.000463165,0.000368817,0.0003002,0.00024016,0.000205851,0.000154388,0.000137234,0.00012008,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,0.00012008,0.00012008,0.000154388,0.000162966,0.000205851,0.00024016,
0.000291623,0.000334508,0.000454588,0.000557514,0.00072048,0.000994948,0.00162108,0.00235871,0.00384256,
0.00556656,0.00770227,0.0103526,0.0144182,0.0200105,0.0267178,0.035192,0.0457419,0.0569522,0.070384,0.144782,
0.207035,0.247562,0.286708,0.323813,0.360823,0.39713,0.428908,0.454348,0.478579,0.499876,0.516876,0.527734,
0.529355,0.523523,0.509739,0.489669,0.458431,0.425932,0.389282,0.355239,0.331927,0.319824,0.312945,0.305741,
0.292317,0.271415,0.243136,0.208364,0.149817,0.110431,0.0865004,0.0682226,0.052818,0.0379967,0.0266492,
0.0183036,0.0119994,0.00841417,0.00608977,0.00464881,0.00331935,0.00261603,0.00208424,0.00180978,0.00151815,
0.0013123,0.00114934,0.00114934,0.00126942,0.00140665,0.00156104,0.0016897,0.00179262,0.00186124,0.0019127,
0.00195559,0.00198132,0.00199847,0.00208424,0.00216144,0.0022901,0.00234156,0.00235871,0.00236729,0.00234156,
0.00228152,0.00216144,0.00204994,0.00197274,0.00190412,0.00187839,0.00186124,0.00186124,0.00187839,0.00188697,
0.00190412,0.00189555,0.0019127,0.00201563,0.0022901,0.00277042,0.00362813,0.00514628,0.00700752,0.0105928,
0.017849,0.0283131,0.0436491,0.065049,0.101133,0.206906,0.307036,0.409696,0.525736,0.576924,0.610992,
0.64368,0.672139,0.694765,0.712983,0.726938,0.732925,0.732728,0.740096,0.76762,0.824469,0.887537,0.918063,
0.93134,0.934471,0.922977,0.872509,0.676685,0.573742,0.424766,0.290293,0.183757,0.102094,0.0737891,0.0553569,
0.0406985,0.0295997,0.0213914,0.0147012,0.00985513,0.00692175,0.00497474,0.00321643,0.00229867,0.00174116,
0.00114934,0.000917754,0.000746211,0.000591823,0.000506051,0.000403126,0.000343086,0.000308777,0.000248737,
0.000214428,0.000205851,0.000162966,0.000154388,0.000154388,0.000145811,0.000145811,0.000145811,0.000154388,
0.000154388,0.000154388,0.000162966,0.00018012,0.000205851,0.000223006,0.000265891,0.000308777,0.00036024,
0.000403126,0.000471743,0.00054036,0.000617554,0.000737634,0.000857714,0.00106357,0.00164681,0.00234156,
0.00381683,0.00566091,0.00814828,0.0114247,0.0160821,0.0215115,0.0281502,0.0358524,0.0456304,0.0563518,
0.0687372,0.0844505,0.10664,0.247699,0.28911,0.323718,0.359605,0.398545,0.435864,0.466957,0.494035,0.510683,
0.522528,0.530127,0.535822,0.535865,0.527443,0.510211,0.487276,0.456072,0.424508,0.389128,0.352649,0.319361,
0.293355,0.276433,0.26445,0.251662,0.235425,0.214265,0.183122,0.139233,0.111709,0.0924358,0.0766024,0.0618412,
0.0493014,0.0365901,0.0268207,0.0193414,0.0135948,0.00983798,0.00747926,0.00582388,0.00485466,0.00389402,
0.00307919,0.00265034,0.00234156,0.00219575,0.00216144,0.00228152,0.00244448,0.00272753,0.00299342,0.00333651,
0.00385971,0.00421138,0.00452015,0.00476031,0.00494043,0.00508624,0.00528352,0.0054036,0.00553225,0.00554941,
0.00548079,0.00529209,0.00503478,0.00460592,0.00409987,0.00375679,0.00326789,0.00304488,0.00293338,0.0029248,
0.0029248,0.00297627,0.00299342,0.003002,0.00304488,0.00317354,0.00377394,0.00458877,0.00557514,0.00735918,
0.00984655,0.0142466,0.0219832,0.0338368,0.0510511,0.0733174,0.114848,0.234885,0.339123,0.450257,0.557119,
0.591256,0.627152,0.660646,0.689319,0.712537,0.733182,0.752121,0.761221,0.757121,0.743123,0.725008,0.7209,
0.736888,0.777303,0.826433,0.852653,0.836863,0.752567,0.643654,0.572198,0.441139,0.308726,0.209728,0.11393,
0.0816372,0.0620728,0.0486152,0.0365386,0.0276698,0.0207738,0.0148041,0.0103698,0.00760792,0.0056266,
0.00423711,0.0029248,0.00217859,0.00173258,0.00119222,0.000952062,0.000771942,0.000651863,0.000557514,
0.000497474,0.000454588,0.000377394,0.000343086,0.000308777,0.000291623,0.000274468,0.000248737,0.00024016,
0.00024016,0.000248737,0.000257314,0.000274468,0.0003002,0.000308777,0.000334508,0.000368817,0.000454588,
0.000523205,0.000574668,0.00066044,0.000763365,0.00084056,0.000994948,0.00114934,0.00156104,0.00192986,
0.00247879,0.00368817,0.00553225,0.00800247,0.0115191,0.0168198,0.0228066,0.0298141,0.0380911,0.0477232,
0.0575869,0.0692261,0.0834641,0.103663,0.136522,0.201125,0.323907,0.359725,0.394514,0.429234,0.462951,
0.496239,0.519354,0.534536,0.540892,0.541329,0.538516,0.534802,0.525839,0.508581,0.48472,0.454125,0.423265,
0.389462,0.354913,0.3216,0.289753,0.260642,0.238899,0.221402,0.202875,0.176423,0.142724,0.118828,0.103123,
0.0895024,0.0779919,0.0661212,0.0556227,0.0449614,0.0348661,0.0266492,0.020242,0.0151301,0.0113561,0.00892022,
0.00740207,0.00623558,0.00547221,0.00482893,0.00426284,0.00388544,0.00378252,0.00385971,0.0040913,0.00453731,
0.00506909,0.00557514,0.00615839,0.00688744,0.00749642,0.00808824,0.00855998,0.00903173,0.00949489,0.00984655,
0.0101725,0.0103698,0.0102926,0.00987229,0.00928904,0.00853425,0.00777946,0.00693891,0.00620985,0.00563518,
0.00530067,0.00508624,0.00505193,0.0051034,0.00524063,0.00526636,0.00526636,0.00530067,0.00560945,0.00637281,
0.00781377,0.00986371,0.0137663,0.0195044,0.0279958,0.0415562,0.0596797,0.0859687,0.145854,0.269871,0.377051,
0.502938,0.573853,0.614286,0.656528,0.694174,0.722144,0.739101,0.752026,0.768031,0.782535,0.785271,0.76587,
0.728971,0.695546,0.67147,0.656297,0.647737,0.644358,0.638508,0.618249,0.584866,0.538481,0.406702,0.29881,
0.206392,0.11514,0.084056,0.0655551,0.0531525,0.0420623,0.0330306,0.0259973,0.0200105,0.0147784,0.0108501,
0.00830267,0.00656151,0.00526636,0.00400552,0.00289907,0.00222148,0.0018012,0.00133803,0.00102926,0.000857714,
0.000746211,0.00066044,0.000583245,0.00054036,0.000514628,0.00048032,0.000463165,0.000454588,0.000411703,
0.000403126,0.000403126,0.00042028,0.000454588,0.000454588,0.000471743,0.000506051,0.000548937,0.000626131,
0.000737634,0.000806251,0.000977794,0.00114076,0.00145811,0.00177547,0.00208424,0.00254741,0.00312208,
0.00419422,0.00553225,0.00747926,0.0106442,0.0159792,0.0224292,0.0300886,0.0389917,0.0495587,0.0595168,
0.0713789,0.0853511,0.10441,0.134773,0.195885,0.242484,0.286331,0.394934,0.428831,0.458174,0.488734,0.513659,
0.533129,0.543773,0.549426,0.549614,0.54307,0.533833,0.521499,0.503898,0.479659,0.450549,0.421506,0.389788,
0.357675,0.326798,0.296314,0.263953,0.234096,0.20857,0.179974,0.14606,0.122979,0.107291,0.0942542,0.0835242,
0.07511,0.0660011,0.0579643,0.050202,0.0414362,0.0333822,0.0265634,0.0209196,0.0165367,0.0129772,0.0106614,
0.00910034,0.00803678,0.00711045,0.00650147,0.0059268,0.00566949,0.00560945,0.00572953,0.00613265,0.00681883,
0.00752215,0.00841417,0.00943485,0.0106013,0.0118193,0.0129772,0.014238,0.0154989,0.0165196,0.0174202,
0.0180463,0.018235,0.0179948,0.0171886,0.0158849,0.014015,0.0123082,0.0107815,0.00954636,0.00853425,0.00790812,
0.0075393,0.00747069,0.00754788,0.00768512,0.00777089,0.00783093,0.00813113,0.00882588,0.0103097,0.0131059,
0.0180806,0.0251739,0.0348146,0.0503564,0.07089,0.104392,0.206735,0.312551,0.426447,0.552436,0.592646,
0.640626,0.695006,0.752936,0.786944,0.794174,0.785254,0.783736,0.79426,0.80204,0.787073,0.748656,0.69552,
0.655285,0.624047,0.600494,0.581839,0.567086,0.553714,0.500536,0.424182,0.341259,0.263052,0.181467,0.10935,
0.0826579,0.0660011,0.0547307,0.0448155,0.0363499,0.0295654,0.0238616,0.0190412,0.0146669,0.0113561,0.00908319,
0.00749642,0.0061155,0.00505193,0.00397979,0.00296769,0.00234156,0.0019127,0.00158677,0.00117507,0.0010121,
0.000909177,0.000789097,0.000763365,0.000737634,0.000694748,0.00066044,0.000643285,0.000626131,0.000626131,
0.000626131,0.000643285,0.000651863,0.00066044,0.00072048,0.000763365,0.000831982,0.000986371,0.00114076,
0.00150958,0.00184408,0.00216144,0.00261603,0.00326789,0.00438292,0.00536071,0.00637281,0.00789954,0.0101382,
0.014238,0.0205337,0.0282874,0.0375336,0.0487868,0.0593881,0.0719965,0.0864404,0.105962,0.136651,0.195413,
0.238916,0.280927,0.320013,0.35807,0.456904,0.48785,0.511223,0.530213,0.541338,0.547539,0.549735,0.546887,
0.540977,0.531294,0.516447,0.49822,0.473278,0.447126,0.417895,0.387738,0.357572,0.330031,0.303674,0.275275,
0.244285,0.215132,0.181158,0.142698,0.118811,0.103535,0.0908233,0.0802563,0.0717392,0.0640712,0.0579815,
0.0521662,0.0451586,0.0383312,0.03219,0.0265891,0.0218631,0.0180549,0.0149928,0.0127885,0.0112017,0.00992375,
0.00907461,0.00841417,0.00795101,0.007728,0.00771085,0.00793385,0.00841417,0.00920327,0.0103097,0.0117335,
0.0133889,0.0154646,0.017403,0.0192557,0.0211169,0.0229353,0.0247279,0.0261088,0.026795,0.027078,0.0266063,
0.0255856,0.0235014,0.021074,0.0185609,0.0162451,0.0139722,0.0123082,0.0112532,0.0107043,0.0105585,0.0106271,
0.0109101,0.011116,0.0114676,0.0123597,0.014015,0.0174287,0.0226351,0.0305603,0.0426713,0.0586848,0.081946,
0.126684,0.242913,0.350805,0.483665,0.571666,0.616962,0.670569,0.741442,0.810239,0.837686,0.841769,0.830456,
0.813001,0.802923,0.801722,0.791438,0.758279,0.702073,0.652875,0.613977,0.583666,0.559958,0.512861,0.448207,
0.390569,0.336387,0.281802,0.221445,0.143873,0.102042,0.0799732,0.0645944,0.0546535,0.0456904,0.0380739,
0.0316754,0.0263747,0.0219746,0.0181235,0.0145039,0.0118279,0.00985513,0.00841417,0.00711902,0.00595253,
0.00508624,0.00413418,0.00317354,0.00261603,0.00216144,0.00186124,0.00160392,0.00133803,0.00114076,0.00104641,
0.00100353,0.000977794,0.000943485,0.000943485,0.000917754,0.000917754,0.000917754,0.000943485,0.00096064,
0.000994948,0.00104641,0.00114934,0.00147527,0.00178404,0.00208424,0.00248737,0.00301915,0.00394548,0.00501763,
0.00608977,0.00754788,0.00909177,0.0110474,0.0140236,0.0187582,0.0253883,0.0339569,0.0446955,0.056489,
0.0693719,0.083833,0.102848,0.132268,0.191982,0.2363,0.276141,0.312705,0.35029,0.389342,0.426207,0.506043,
0.527889,0.542453,0.550515,0.552093,0.549512,0.542487,0.532906,0.520735,0.50624,0.489094,0.4641,0.439012,
0.41202,0.382909,0.354502,0.328333,0.305132,0.282574,0.255899,0.228555,0.19971,0.157854,0.127105,0.108698,
0.0937739,0.0818173,0.072048,0.0636853,0.0577585,0.0527751,0.04726,0.0420794,0.0365386,0.0315553,0.0268464,
0.022901,0.0197617,0.0173516,0.015293,0.0136119,0.0122825,0.0112704,0.0104984,0.00990659,0.00973505,0.00976078,
0.0100524,0.0107729,0.0118965,0.0133975,0.0154989,0.0177547,0.0200619,0.0225665,0.0251567,0.0276527,0.0301744,
0.0325417,0.0343429,0.0354493,0.0357838,0.0350891,0.0336138,0.0312122,0.0281416,0.0249938,0.0217945,0.0191099,
0.0170942,0.0156962,0.0147784,0.014564,0.0148127,0.0154388,0.0160478,0.0170428,0.018844,0.022129,0.0276698,
0.0363756,0.0499704,0.0679309,0.0964499,0.167306,0.274091,0.379144,0.520778,0.588889,0.646219,0.716148,
0.801705,0.843827,0.865553,0.869808,0.859798,0.841417,0.820583,0.802846,0.781249,0.750534,0.701233,0.652343,
0.610486,0.577053,0.548611,0.470902,0.402371,0.340727,0.288921,0.237226,0.183456,0.123348,0.0971447,0.0791155,
0.0645859,0.0546192,0.0458019,0.0384942,0.0326703,0.0276184,0.0236214,0.0201992,0.0172829,0.0144096,0.0123082,
0.0107043,0.00935766,0.00815686,0.00706756,0.00610692,0.00530067,0.00453731,0.00378252,0.00301915,0.00259887,
0.00226436,0.0019899,0.00184408,0.00173258,0.00162108,0.00156104,0.00150958,0.00147527,0.00144954,0.00144954,
0.00146669,0.001501,0.00156104,0.0016897,0.00184408,0.00205851,0.00237587,0.00289907,0.00357667,0.00451157,
0.0054036,0.00651005,0.00803678,0.00985513,0.0123253,0.0153874,0.0189383,0.0237329,0.0304488,0.039695,
0.0515314,0.0631363,0.0779576,0.0949403,0.118553,0.167812,0.223383,0.265994,0.304926,0.340512,0.376734,
0.413324,0.447941,0.479676,0.532426,0.54488,0.552831,0.553852,0.550249,0.538739,0.522982,0.505305,0.490175,
0.470893,0.45072,0.427562,0.400338,0.373629,0.347185,0.322192,0.300243,0.280301,0.259467,0.237587,0.215012,
0.186784,0.146369,0.119685,0.102977,0.0888763,0.0776231,0.0678881,0.0597912,0.0543362,0.0493614,0.0444639,
0.040201,0.0356809,0.0315639,0.027687,0.024462,0.0216744,0.0196245,0.0179091,0.0163823,0.014847,0.0136805,
0.0127456,0.0119994,0.0117249,0.0117335,0.0121367,0.0130458,0.0144182,0.0164252,0.0185438,0.0210054,0.0238187,
0.0267178,0.0298828,0.0332278,0.0362298,0.0391461,0.0415734,0.0429715,0.0434003,0.0427056,0.0407929,0.0377308,
0.0341971,0.0304488,0.0268464,0.0238359,0.0215286,0.0200533,0.0192299,0.0190841,0.019573,0.020345,0.0215115,
0.0235014,0.0267607,0.032799,0.0424054,0.0559487,0.0764309,0.112789,0.215235,0.306007,0.409044,0.546244,
0.599053,0.667147,0.767182,0.844488,0.879242,0.890444,0.887099,0.875263,0.856539,0.835362,0.813619,0.77937,
0.736527,0.689971,0.64651,0.606318,0.572198,0.531079,0.447435,0.379341,0.319944,0.265857,0.214265,0.149911,
0.11309,0.0933364,0.0790641,0.0661297,0.0558029,0.0467197,0.0391461,0.0332536,0.0285104,0.0245049,0.0213142,
0.0185867,0.0163995,0.0143238,0.0127799,0.0114591,0.0102668,0.00918612,0.00818259,0.00730772,0.00647574,
0.00564376,0.00509482,0.00447727,0.00386829,0.00321643,0.00289907,0.00261603,0.00239302,0.00229867,0.0022129,
0.00216144,0.00216144,0.00216144,0.00216144,0.00216144,0.00219575,0.00231583,0.00254741,0.00289907,0.00335366,
0.00421995,0.00506909,0.00584961,0.00699895,0.00837129,0.0101639,0.012617,0.0160821,0.0198561,0.024016,
0.0292566,0.0359211,0.0453731,0.0565834,0.0697579,0.0850595,0.105199,0.13732,0.198252,0.242845,0.285001,
0.322972,0.360574,0.397319,0.431327,0.461158,0.492079,0.514937,0.53843,0.545455,0.548911,0.5456,0.53499,
0.514946,0.492311,0.4682,0.450626,0.433163,0.41184,0.386958,0.360935,0.336807,0.312628,0.291048,0.271544,
0.253943,0.237775,0.220595,0.201357,0.172272,0.13895,0.116435,0.100841,0.0874439,0.076611,0.0665071,0.0585819,
0.0528094,0.0474402,0.0432459,0.0393004,0.0354665,0.0321814,0.0290851,0.0262546,0.0238616,0.0219746,0.0203364,
0.0187582,0.0173944,0.0161079,0.0148556,0.0140065,0.0135776,0.0135519,0.0139979,0.01495,0.0165196,0.0184237,
0.0207481,0.0234156,0.0264262,0.0297026,0.0333393,0.036753,0.0405012,0.0437263,0.0462222,0.0479891,0.0485466,
0.0477232,0.0457161,0.0427485,0.0388201,0.0347288,0.0310578,0.0277299,0.0256113,0.0239645,0.0233984,0.0234928,
0.0243248,0.0258515,0.02785,0.0313151,0.0367187,0.0465481,0.0600571,0.081946,0.126204,0.23998,0.337022,
0.446251,0.559307,0.607956,0.676213,0.787227,0.863598,0.897091,0.907461,0.904554,0.890839,0.867989,0.842798,
0.819511,0.784199,0.733929,0.683195,0.639503,0.601112,0.568364,0.517236,0.433248,0.363636,0.30713,0.254973,
0.202764,0.137466,0.10802,0.0907118,0.0784208,0.0678366,0.0579986,0.0492757,0.0408272,0.0341113,0.0292137,
0.0251396,0.0218117,0.0192814,0.0173601,0.015739,0.014238,0.0130716,0.0119994,0.0111331,0.0101811,0.00928904,
0.00843133,0.00776231,0.00698179,0.00631277,0.0057038,0.00528352,0.00481177,0.0043143,0.00396264,0.00362813,
0.00335366,0.00321643,0.00315639,0.00313923,0.00313923,0.00315639,0.00321643,0.00336224,0.00380825,0.00423711,
0.00488897,0.00554941,0.00649289,0.00764223,0.00898884,0.0106957,0.0129086,0.0160221,0.0195816,0.0239045,
0.029025,0.0347203,0.042311,0.0518316,0.0619012,0.0757962,0.0921614,0.114693,0.156112,0.214634,0.254878,
0.294385,0.331018,0.369357,0.408246,0.44156,0.469864,0.49533,0.513359,0.528566,0.530676,0.532932,0.529964,
0.520426,0.502826,0.477566,0.451947,0.430804,0.412612,0.393553,0.371562,0.348832,0.325828,0.304394,0.282677,
0.261354,0.244457,0.231085,0.218708,0.205328,0.1882,0.158891,0.133923,0.114934,0.10049,0.0879586,0.0775116,
0.0676393,0.0591994,0.0531268,0.047423,0.0431173,0.0393776,0.0359983,0.033245,0.0305175,0.0283046,0.0262375,
0.0243333,0.0226436,0.0208939,0.0194272,0.0179863,0.0166482,0.0156962,0.01495,0.0147956,0.0152502,0.0162623,
0.0177118,0.0195387,0.0217087,0.024462,0.0274897,0.0309206,0.034583,0.0383312,0.0422939,0.0455703,0.0484523,
0.0502963,0.050871,0.050262,0.048255,0.0450814,0.0414876,0.0373449,0.0336052,0.0304917,0.0284933,0.0272067,
0.0268722,0.0276012,0.0292137,0.031521,0.034969,0.0404326,0.0494215,0.0623043,0.084176,0.132036,0.248591,
0.349132,0.4676,0.565842,0.613952,0.681111,0.783976,0.85864,0.894638,0.906501,0.906818,0.897323,0.877896,
0.849566,0.821047,0.785846,0.73651,0.683718,0.638748,0.599053,0.56646,0.509225,0.425109,0.355514,0.299908,
0.249174,0.198732,0.134429,0.104984,0.0888163,0.0779748,0.0684027,0.0598942,0.0521919,0.0436319,0.0362298,
0.0303545,0.0260488,0.0223949,0.0197017,0.0177204,0.0162279,0.01495,0.0140408,0.0132946,0.0125569,0.011845,
0.0111074,0.0103783,0.00970074,0.00898884,0.00836271,0.00783093,0.00719622,0.00669017,0.0061155,0.00569522,
0.00542933,0.00524921,0.00504336,0.00494043,0.00488039,0.00485466,0.00488897,0.00497474,0.00506909,0.00530067,
0.00560945,0.00619269,0.00698179,0.00807966,0.0094177,0.0112017,0.0133975,0.016348,0.0194444,0.0233298,
0.0279958,0.0334851,0.0401925,0.0481177,0.0567549,0.0674592,0.0809853,0.0982511,0.123176,0.176286,0.225639,
0.264382,0.300183,0.333488,0.367899,0.40521,0.439973,0.46856,0.493297,0.508067,0.518368,0.525607,0.510717,
0.508461,0.499867,0.484102,0.460395,0.437125,0.413598,0.39339,0.375927,0.357366,0.337425,0.316848,0.296803,
0.276381,0.255281,0.236986,0.223314,0.213005,0.20224,0.190361,0.173181,0.150392,0.130819,0.114453,0.101425,
0.0899056,0.0795358,0.0699208,0.0609577,0.0546021,0.0489497,0.0440007,0.0403554,0.0372419,0.0345659,0.032353,
0.0301744,0.0283732,0.026409,0.0246936,0.0228238,0.0209968,0.0193329,0.0179005,0.0166482,0.0159192,0.015516,
0.0157905,0.0165024,0.0178233,0.0194787,0.02152,0.0241018,0.0269665,0.0302601,0.0339226,0.0375679,0.041419,
0.0446183,0.0473715,0.0494987,0.0502363,0.0496788,0.0477318,0.0449185,0.041642,0.0377566,0.0344801,0.0319756,
0.0301744,0.0296254,0.0299771,0.0314009,0.0339226,0.0377737,0.0434518,0.0512999,0.0625874,0.0833097,0.125972,
0.24239,0.343866,0.461381,0.565302,0.612528,0.675527,0.770158,0.844874,0.879989,0.891225,0.889655,0.88125,
0.865442,0.84387,0.815025,0.77485,0.72807,0.682063,0.639469,0.600348,0.567035,0.51052,0.423899,0.353181,
0.29688,0.244088,0.194461,0.132114,0.104229,0.0880272,0.0776059,0.0687972,0.060992,0.0545163,0.0466082,
0.0391975,0.0327304,0.0273268,0.0233384,0.0201649,0.0178833,0.0162451,0.01501,0.0142466,0.013732,0.0132603,
0.0128142,0.0123768,0.0118965,0.0113819,0.0108758,0.0103183,0.0098294,0.00921185,0.0087058,0.00816544,
0.00776231,0.00728199,0.00693891,0.00675879,0.00653578,0.00647574,0.0064157,0.00647574,0.00655293,0.00675879,
0.00694748,0.00735918,0.0079167,0.00867149,0.00983798,0.0113904,0.0135004,0.0163909,0.0195559,0.0229696,
0.0270266,0.0320356,0.0377308,0.0447812,0.0529724,0.0610692,0.0721938,0.0857971,0.104118,0.132097,0.188911,
0.231986,0.26994,0.303468,0.333942,0.363405,0.394428,0.426301,0.454588,0.478887,0.496848,0.505802,0.509353,
0.510417,0.484703,0.476915,0.463165,0.444459,0.421772,0.397053,0.375627,0.35795,0.343609,0.327475,0.309566,
0.290979,0.271235,0.25155,0.233401,0.218597,0.207318,0.1967,0.18681,0.174056,0.15884,0.144096,0.128777,
0.114977,0.103123,0.0922986,0.0820318,0.0725797,0.0634966,0.0564461,0.0508453,0.0456904,0.0419508,0.0386915,
0.036024,0.0339397,0.032027,0.0300543,0.0282016,0.0262375,0.0242218,0.0221805,0.0202678,0.018458,0.0170685,
0.0160307,0.0154646,0.0154474,0.0160135,0.0169827,0.018398,0.0201992,0.0224378,0.0251396,0.0280558,0.0313323,
0.0346173,0.0379281,0.0412046,0.0438206,0.0456046,0.046308,0.0460592,0.0446011,0.0424054,0.0393691,0.0362641,
0.0336824,0.0318812,0.0307919,0.0310492,0.0322672,0.0346259,0.0388201,0.0448155,0.0526293,0.0624587,0.0804793,
0.115946,0.222697,0.325425,0.441766,0.558732,0.604491,0.661349,0.741065,0.822428,0.860167,0.872578,0.865879,
0.851444,0.833501,0.813945,0.78395,0.747026,0.708326,0.672465,0.635943,0.601326,0.569839,0.518925,0.429886,
0.356303,0.298081,0.242459,0.188191,0.127482,0.101596,0.0862689,0.0764309,0.0683169,0.0611207,0.0552539,
0.0490012,0.041865,0.0349776,0.029471,0.0247279,0.0208596,0.0181921,0.0161936,0.0146669,0.0139293,0.013449,
0.0132088,0.0129601,0.0128571,0.0127285,0.0125569,0.0123082,0.0119651,0.0116821,0.0112532,0.0108243,0.0103269,
0.00983798,0.00929762,0.00887734,0.00855998,0.00833698,0.00822548,0.00818259,0.00829409,0.00841417,0.0086286,
0.00893738,0.00937481,0.00988086,0.0108072,0.011948,0.0136634,0.0160821,0.018844,0.0222834,0.0262718,
0.0307405,0.0358524,0.0422081,0.0493357,0.0564719,0.0647745,0.0761907,0.0895539,0.108792,0.138975,0.194409,
0.234636,0.270737,0.302516,0.331361,0.358173,0.383201,0.407834,0.432794,0.454863,0.473184,0.486667,0.492268,
0.491582,0.48882,0.453182,0.444021,0.429251,0.408529,0.384582,0.360626,0.341567,0.327621,0.315639,0.301855,
0.286056,0.267727,0.249955,0.232904,0.21828,0.205483,0.194255,0.183671,0.172169,0.160607,0.150426,0.139507,
0.127371,0.115551,0.104615,0.0942542,0.0844848,0.0756847,0.0663013,0.0587277,0.0530925,0.0478175,0.0437263,
0.0404069,0.0375336,0.035192,0.0334165,0.0314695,0.0294196,0.0271038,0.025071,0.022738,0.0205508,0.0185095,
0.0168712,0.0155332,0.0145726,0.0143324,0.014564,0.0154045,0.0164595,0.0179176,0.0197274,0.0218889,0.024402,
0.0270008,0.0299514,0.0328847,0.0353721,0.0377308,0.0395406,0.0404498,0.0403726,0.0392833,0.0374992,0.0352177,
0.033305,0.031521,0.0304488,0.0303974,0.031521,0.033691,0.0375507,0.0438549,0.0521318,0.0615753,0.0775631,
0.105885,0.195799,0.296838,0.407706,0.540711,0.590424,0.643251,0.706568,0.785228,0.832257,0.848854,0.845397,
0.827462,0.8033,0.770699,0.741125,0.710093,0.683169,0.657403,0.62885,0.598633,0.570877,0.529261,0.43939,
0.365052,0.304523,0.24866,0.192402,0.126804,0.100155,0.0842532,0.0740636,0.066164,0.0601257,0.0548937,
0.0493957,0.04298,0.0366501,0.0311693,0.0262289,0.0219317,0.0185524,0.0162451,0.0143839,0.0133375,0.0128486,
0.0126084,0.0125569,0.0126084,0.0127714,0.0129086,0.0130287,0.0130887,0.0130544,0.0129429,0.0127799,0.0124454,
0.0119994,0.0115448,0.0110902,0.0106271,0.0103097,0.0100953,0.0100696,0.0101896,0.0104813,0.0109015,0.0113819,
0.0119222,0.0126599,0.0136205,0.0148642,0.0165367,0.0185867,0.0213828,0.0248222,0.0289307,0.0336824,0.0393691,
0.0458362,0.0529467,0.0596712,0.068214,0.0783865,0.0914752,0.109796,0.139773,0.194667,0.233127,0.267289,
0.297215,0.323221,0.348609,0.370815,0.390569,0.408701,0.426876,0.443404,0.455755,0.464546,0.467643,0.464238,
0.45892,0.424397,0.412312,0.395415,0.374384,0.351766,0.331163,0.314386,0.302215,0.290362,0.277059,0.262358,
0.247828,0.233744,0.220381,0.208587,0.196545,0.186639,0.175505,0.163686,0.155109,0.14606,0.136471,0.126024,
0.115688,0.105593,0.095738,0.0864576,0.0780348,0.069269,0.0611035,0.0552282,0.050365,0.0457161,0.0421223,
0.0389059,0.03641,0.0343171,0.0322843,0.0299428,0.0274897,0.0251825,0.022678,0.0202678,0.0180635,0.0161508,
0.0144267,0.0133975,0.0129,0.0128228,0.013123,0.0138006,0.0147269,0.0162623,0.0179691,0.0198732,0.0219317,
0.0242218,0.0264862,0.0287248,0.0304231,0.032027,0.0329105,0.0331163,0.0325502,0.031521,0.0301486,0.0291108,
0.0284161,0.0284504,0.0292995,0.0312551,0.0345659,0.0402611,0.0486152,0.0584704,0.0727513,0.0957294,0.153213,
0.261071,0.362453,0.487576,0.572713,0.619278,0.673734,0.734941,0.790418,0.817127,0.819082,0.804244,0.770073,
0.735267,0.707245,0.684584,0.663888,0.642908,0.620221,0.596043,0.570165,0.532006,0.446003,0.37272,0.311539,
0.2577,0.203827,0.134815,0.102523,0.0847764,0.0731716,0.0645859,0.0586934,0.0540102,0.048538,0.0429028,
0.0373106,0.0320699,0.0270609,0.0228838,0.0192299,0.0163995,0.0142638,0.0129086,0.0120852,0.011785,0.0116906,
0.0118365,0.0120852,0.0125569,0.0129343,0.013346,0.0137663,0.0140065,0.0141866,0.0142209,0.0140494,0.0138092,
0.0133803,0.0129429,0.0125912,0.0122739,0.0121367,0.0122567,0.0126513,0.0132603,0.0139979,0.014847,0.0159621,
0.0170428,0.0183036,0.0198818,0.0216659,0.0241361,0.0271724,0.0311093,0.0357838,0.0418736,0.0485809,0.0552368,
0.0620556,0.0704097,0.0797674,0.0912436,0.107257,0.132877,0.184872,0.225665,0.259012,0.288758,0.311719,
0.333016,0.352761,0.370618,0.38604,0.398597,0.410905,0.422561,0.431833,0.438,0.439913,0.437631,0.431859,
0.393862,0.380439,0.36241,0.342708,0.323461,0.305055,0.290062,0.277728,0.265299,0.253386,0.242373,0.23184,
0.221925,0.212662,0.20212,0.192831,0.183842,0.173713,0.162194,0.153316,0.144002,0.134318,0.124334,0.115114,
0.105808,0.0968187,0.0881129,0.0799304,0.0716277,0.0636252,0.0576641,0.0527837,0.0477918,0.0436576,0.0402182,
0.0373106,0.0348146,0.0325417,0.0299342,0.0272496,0.0246936,0.0219403,0.0194101,0.0170599,0.0148127,0.0130887,
0.0119222,0.0112361,0.010893,0.0108501,0.0110902,0.0115791,0.0124025,0.0134575,0.0148642,0.0165367,0.018235,
0.0199075,0.02146,0.022901,0.0241618,0.0250796,0.0255513,0.0255684,0.0251825,0.0247365,0.0244963,0.024848,
0.0259201,0.027464,0.0303459,0.0349433,0.0425855,0.0529209,0.0653063,0.0848794,0.120054,0.220304,0.31286,
0.422132,0.549108,0.591325,0.638971,0.687629,0.730223,0.759283,0.767028,0.755912,0.728542,0.699534,0.677096,
0.660157,0.644812,0.628867,0.612382,0.592749,0.570869,0.539219,0.453971,0.378758,0.316539,0.263001,0.212396,
0.145983,0.108878,0.0882588,0.0755131,0.0650919,0.0581702,0.0529381,0.0473544,0.0422596,0.0369417,0.0322072,
0.0274897,0.023407,0.0197274,0.0166482,0.0142724,0.0126684,0.0116049,0.0110045,0.0108072,0.0108329,0.0111074,
0.0115534,0.0121452,0.0128657,0.0135519,0.0142209,0.0147098,0.0152673,0.0156275,0.0157905,0.0156533,0.0153617,
0.0149156,0.0145811,0.0144267,0.0144782,0.014847,0.0156275,0.0165196,0.0176603,0.0186639,0.0200448,0.0214857,
0.023124,0.0250796,0.027018,0.0298141,0.0333136,0.0374821,0.043083,0.0498332,0.0562489,0.0631449,0.0712246,
0.079896,0.0900085,0.10296,0.121289,0.158068,0.209539,0.243514,0.274228,0.298716,0.316719,0.332295,0.347022,
0.359571,0.370541,0.379701,0.387335,0.394737,0.401118,0.406977,0.410202,0.408752,0.402954,0.36434,0.350402,
0.333042,0.313786,0.295525,0.277891,0.263232,0.252074,0.241987,0.233247,0.226428,0.219841,0.213665,0.206855,
0.19893,0.191896,0.184391,0.175197,0.163472,0.153239,0.142724,0.132165,0.121873,0.113596,0.105173,0.0973076,
0.0895196,0.0817744,0.0742437,0.0664128,0.0600314,0.0548594,0.0499275,0.0449185,0.041136,0.0376708,0.0348146,
0.0322072,0.029411,0.0265034,0.0236043,0.020791,0.0182178,0.0156962,0.0133203,0.011562,0.0103183,0.00955493,
0.009006,0.00872295,0.00869722,0.00886018,0.00919469,0.00982082,0.0105756,0.0115363,0.0126684,0.0138263,
0.0150615,0.016288,0.0173172,0.0180463,0.0185524,0.0190155,0.0193157,0.0196931,0.0202163,0.0213142,0.0230296,
0.0258172,0.0295911,0.0354236,0.0445068,0.0565748,0.0733002,0.0989544,0.161079,0.260385,0.351937,0.463594,
0.562549,0.601678,0.643423,0.678735,0.699551,0.7042,0.696807,0.684001,0.666795,0.647514,0.633276,0.621834,
0.611739,0.600168,0.586771,0.570062,0.546304,0.468878,0.391829,0.322981,0.266517,0.215912,0.154011,0.114796,
0.0938854,0.079227,0.0680939,0.0594053,0.0531954,0.0469169,0.0416677,0.03641,0.0318812,0.0273525,0.023407,
0.0198732,0.0168283,0.0142724,0.0125398,0.0113132,0.0104727,0.00998379,0.00985513,0.00998379,0.0104126,
0.0109959,0.0117421,0.012617,0.0135004,0.0143753,0.0153188,0.0161336,0.0166654,0.0170942,0.0172915,0.0171543,
0.0169742,0.0168369,0.0168369,0.0170771,0.0177032,0.0184923,0.0197274,0.0209196,0.0224721,0.0241189,0.0260488,
0.0278157,0.0299514,0.0324216,0.035252,0.0390346,0.0437263,0.049756,0.0559144,0.0626045,0.0705813,0.0787467,
0.0874697,0.0982168,0.112035,0.134095,0.178773,0.219283,0.251233,0.279143,0.299582,0.312645,0.323187,
0.332467,0.34083,0.348103,0.353695,0.358962,0.364065,0.36862,0.374847,0.379393,0.379547,0.374821,0.337167,
0.323701,0.306564,0.287386,0.266963,0.249826,0.237312,0.228015,0.220981,0.216427,0.213459,0.210183,0.206469,
0.20218,0.197214,0.191819,0.185412,0.176801,0.164964,0.153771,0.142363,0.13069,0.119857,0.112086,0.104435,
0.0974363,0.0905317,0.0831811,0.0762936,0.0689773,0.0622014,0.0564118,0.051257,0.0458705,0.0415562,0.0375679,
0.0343086,0.0313323,0.0283217,0.0253454,0.0222491,0.0194101,0.0166654,0.0140065,0.0118021,0.0100696,0.00880872,
0.00801962,0.0074278,0.00698179,0.0068274,0.00681883,0.00687029,0.00709329,0.0076165,0.00818259,0.00889449,
0.00967501,0.0103698,0.0111245,0.0118708,0.0126084,0.0133203,0.0140065,0.0147098,0.0156447,0.0166654,
0.018398,0.0207824,0.0241189,0.0289736,0.0359554,0.0466939,0.0606146,0.0809939,0.113561,0.202395,0.287574,
0.376493,0.486075,0.565516,0.60028,0.632856,0.654453,0.660457,0.655293,0.644563,0.632538,0.619775,0.607776,
0.598393,0.592097,0.585424,0.577027,0.565045,0.544417,0.477738,0.40593,0.336987,0.27687,0.220904,0.159372,
0.117678,0.0977451,0.0828552,0.0715591,0.0619612,0.0547307,0.0478776,0.0418307,0.036247,0.0315467,0.0270523,
0.0232183,0.0197617,0.0168198,0.014238,0.0123253,0.0110045,0.0100696,0.00951205,0.00914323,0.00910034,
0.00928904,0.00977794,0.0104298,0.0112532,0.0121967,0.0133031,0.0143839,0.0156533,0.0166482,0.0175917,
0.0182178,0.018518,0.0186381,0.0186896,0.0187325,0.0189812,0.0194272,0.0201906,0.0213142,0.0227123,0.0242647,
0.0260917,0.0278843,0.0298828,0.03219,0.0344887,0.0372334,0.0404498,0.044258,0.0491298,0.0546793,0.0606232,
0.0680767,0.0762165,0.0839873,0.0931735,0.10374,0.116838,0.140159,0.184117,0.220132,0.249783,0.275215,
0.292575,0.302987,0.308726,0.313314,0.318006,0.321934,0.326068,0.3307,0.334689,0.338857,0.343935,0.348601,
0.349656,0.346053,0.310612,0.299256,0.282308,0.261628,0.242244,0.225982,0.21484,0.206941,0.202052,0.200808,
0.201288,0.20104,0.199762,0.19742,0.194169,0.189855,0.183551,0.175179,0.163583,0.153248,0.142012,0.129918,
0.118948,0.111271,0.104066,0.0975135,0.0910978,0.0841417,0.0775802,0.070547,0.0634622,0.0573553,0.0519432,
0.0460764,0.0412646,0.0368474,0.0333393,0.0298828,0.0266577,0.0236815,0.0206623,0.017849,0.0149757,0.0124883,
0.0103783,0.00872295,0.00753073,0.00663871,0.0059268,0.00556656,0.00530067,0.00524921,0.00523205,0.00530067,
0.00554083,0.00589249,0.00647574,0.00698179,0.00752215,0.00807966,0.00862002,0.00921185,0.00988086,0.0107643,
0.0116735,0.0126684,0.0140322,0.0162623,0.0190927,0.022901,0.0287077,0.0368045,0.0494472,0.0645944,0.0872552,
0.126213,0.220312,0.299634,0.382197,0.480526,0.560207,0.587714,0.611198,0.623078,0.622434,0.614123,0.603162,
0.592337,0.58334,0.576169,0.572104,0.569951,0.565516,0.557677,0.533061,0.475611,0.41148,0.346731,0.289024,
0.230699,0.167263,0.119574,0.0992718,0.085171,0.0744924,0.0642942,0.056489,0.0496445,0.0427141,0.0366244,
0.0316239,0.0269751,0.023021,0.0196073,0.0165968,0.0140494,0.012068,0.0107472,0.00981225,0.00906604,0.0086286,
0.00841417,0.00841417,0.00863718,0.00910034,0.0098294,0.0106614,0.0117335,0.0129086,0.014238,0.0157133,
0.0170428,0.0181921,0.0190069,0.0197017,0.0200619,0.0203278,0.0205594,0.0208682,0.0215543,0.0225579,0.0237673,
0.0255513,0.0270523,0.029128,0.0311693,0.0333822,0.035638,0.0382369,0.0412646,0.0444296,0.0482979,0.0528266,
0.0578185,0.0637367,0.0712846,0.0790726,0.0871695,0.0959953,0.106056,0.117979,0.139284,0.178164,0.213699,
0.240958,0.263764,0.280009,0.288749,0.291992,0.293776,0.295611,0.298081,0.300689,0.30412,0.307456,0.311342,
0.31563,0.318881,0.320185,0.317997,0.285619,0.274631,0.258532,0.239963,0.22159,0.2058,0.193106,0.185026,
0.182453,0.185481,0.189958,0.192059,0.192162,0.190867,0.188114,0.183465,0.176861,0.168369,0.160118,0.151541,
0.141772,0.130081,0.119119,0.111426,0.104135,0.0975392,0.0910892,0.0843218,0.0779662,0.0709158,0.0636081,
0.0573553,0.0517201,0.0455618,0.0402868,0.0355351,0.0318555,0.0283732,0.0251224,0.0219661,0.0189898,0.0161851,
0.0133203,0.0110474,0.00910892,0.00766796,0.00645001,0.00556656,0.00501763,0.00451157,0.00409987,0.00393691,
0.00385971,0.00388544,0.00408272,0.00443438,0.00481177,0.00526636,0.00560945,0.00604688,0.0066044,0.0072048,
0.00800247,0.00879157,0.00982082,0.0109444,0.0124283,0.014624,0.0180463,0.0223606,0.0288363,0.0380139,
0.0517116,0.067991,0.0915695,0.134618,0.226196,0.299462,0.371785,0.453242,0.538884,0.568621,0.584035,
0.590759,0.5878,0.57906,0.569522,0.561297,0.555284,0.550215,0.549391,0.549812,0.539716,0.512132,0.466082,
0.411179,0.351174,0.296743,0.241421,0.183259,0.124111,0.101279,0.0864404,0.0760278,0.0662584,0.0581702,
0.0512141,0.0438635,0.0374821,0.0320699,0.0272238,0.0231068,0.019573,0.0165196,0.0139121,0.0119308,0.0104727,
0.00940054,0.00868006,0.00815686,0.00790812,0.00778804,0.00783093,0.00807966,0.00849137,0.00916896,0.010061,
0.011176,0.0124283,0.0138607,0.0155332,0.0170942,0.0184065,0.019573,0.0204307,0.0210226,0.0215543,0.0220004,
0.0226351,0.023407,0.0244963,0.0260145,0.027524,0.0295054,0.0314609,0.0335538,0.0357838,0.0382798,0.0411445,
0.0440436,0.0471571,0.0509396,0.0548508,0.0596197,0.0654521,0.072494,0.0797159,0.0873839,0.0958667,0.105079,
0.116143,0.133718,0.16246,0.200791,0.226737,0.247476,0.261937,0.269863,0.273276,0.274305,0.275378,0.277144,
0.278217,0.280695,0.283286,0.286245,0.289221,0.29146,0.292626,0.290876,0.260042,0.250778,0.237304,0.220981,
0.20339,0.185429,0.167254,0.159183,0.160015,0.166319,0.175085,0.180514,0.182093,0.18169,0.179382,0.17457,
0.16752,0.16149,0.156696,0.150829,0.142492,0.131728,0.120586,0.112369,0.104452,0.0972991,0.0904545,0.0833612,
0.0768855,0.0699637,0.0626303,0.0563518,0.0504679,0.0441808,0.0385285,0.0339226,0.0298828,0.0264176,0.023244,
0.0201992,0.0173601,0.0143496,0.0119136,0.00984655,0.00813113,0.00681883,0.00560945,0.00488897,0.00415134,
0.00356809,0.00313923,0.00296769,0.00289907,0.00287334,0.0029248,0.00308777,0.00337939,0.00388544,0.00438292,
0.00485466,0.00535213,0.00584961,0.00677594,0.00765938,0.00866291,0.00985513,0.0114762,0.0138521,0.017566,
0.0223177,0.0293767,0.0393348,0.0530582,0.0694234,0.092513,0.133932,0.220947,0.288338,0.34981,0.415648,
0.479942,0.536431,0.557428,0.561142,0.558046,0.547419,0.520941,0.496668,0.479899,0.477695,0.485303,0.489214,
0.477172,0.449339,0.40768,0.355317,0.303571,0.251387,0.198458,0.134447,0.105018,0.0884217,0.0772114,0.0678537,
0.0594481,0.052432,0.0447126,0.0381768,0.032576,0.0276184,0.0234671,0.0198218,0.0166482,0.0139035,0.0118536,
0.0103011,0.00913465,0.00831125,0.00782235,0.00738492,0.00710187,0.00703325,0.00716191,0.00749642,0.00800247,
0.00862002,0.00943485,0.010507,0.011785,0.0133031,0.0150271,0.0168369,0.018398,0.0198303,0.0208424,0.0217345,
0.0224635,0.0230296,0.0238016,0.0248308,0.0260488,0.0273096,0.0292052,0.0310407,0.0330992,0.0349776,0.0374221,
0.0400381,0.0427141,0.0454674,0.0485809,0.0520375,0.0555112,0.059877,0.0652291,0.0716277,0.0784637,0.0853768,
0.0932764,0.101965,0.111854,0.125389,0.147055,0.182015,0.209531,0.227946,0.241078,0.248445,0.252159,0.2539,
0.255427,0.25758,0.258472,0.259759,0.261182,0.2624,0.264193,0.265986,0.266895,0.265102,0.239242,0.230948,
0.219077,0.203896,0.184923,0.161636,0.14793,0.142921,0.144147,0.150297,0.158814,0.166971,0.172289,0.173593,
0.171826,0.166868,0.161636,0.158411,0.155821,0.152261,0.144782,0.134421,0.123039,0.113536,0.10453,0.0965614,
0.0888248,0.0816715,0.0748956,0.0674849,0.0604946,0.0546192,0.0481435,0.0420194,0.0363156,0.0318812,0.02785,
0.0244706,0.0213142,0.0183894,0.0155332,0.01284,0.0106185,0.00883445,0.00737634,0.00608977,0.00523205,
0.00438292,0.00361098,0.00303631,0.00277042,0.0025131,0.00235871,0.00234156,0.00236729,0.0025131,0.00274468,
0.00297627,0.00331935,0.00389402,0.00451157,0.00519775,0.00583245,0.00688744,0.00801962,0.00928904,0.0110388,
0.0135948,0.0175231,0.0226608,0.0300114,0.0402782,0.0536157,0.0690288,0.090506,0.124497,0.20544,0.266526,
0.319884,0.370232,0.418736,0.456338,0.485046,0.494798,0.486375,0.463397,0.43933,0.419482,0.409919,0.411591,
0.419311,0.423145,0.415331,0.39128,0.353953,0.310338,0.263189,0.214171,0.150134,0.112258,0.0927618,0.0796044,
0.069715,0.0608548,0.0538215,0.0457933,0.0386829,0.0329791,0.0280558,0.0238444,0.0202249,0.0170428,0.014238,
0.0119565,0.010284,0.00904888,0.00813113,0.00740207,0.00689602,0.00658724,0.00645859,0.00647574,0.00663871,
0.00693891,0.00746211,0.00807966,0.00885161,0.00984655,0.0110817,0.0125998,0.0143324,0.0163652,0.0180978,
0.0196931,0.0208853,0.0220776,0.022901,0.0237072,0.0246078,0.0257228,0.0266577,0.0282874,0.0298399,0.0317611,
0.0336738,0.0356637,0.037808,0.0403211,0.0429286,0.0454931,0.0484094,0.0516515,0.054928,0.0588563,0.063548,
0.0694577,0.0757619,0.0819117,0.0889535,0.0969731,0.105885,0.116658,0.132654,0.155332,0.186801,0.206186,
0.218494,0.226179,0.230794,0.234079,0.236892,0.239336,0.24022,0.241146,0.241627,0.242193,0.243822,0.245143,
0.245349,0.243496,0.222928,0.215492,0.203596,0.187376,0.163197,0.145897,0.135699,0.13165,0.13304,0.139481,
0.148685,0.157794,0.165333,0.168995,0.168472,0.16493,0.161293,0.15914,0.157734,0.154903,0.147544,0.137123,
0.124857,0.114222,0.104289,0.0949661,0.0865262,0.0789011,0.0713875,0.0638053,0.0576041,0.0518402,0.04503,
0.0390774,0.0338969,0.0295139,0.0258515,0.0224121,0.0193157,0.0164938,0.0137234,0.0114591,0.00964928,
0.00807966,0.00681883,0.00561803,0.00485466,0.00404841,0.00323358,0.00284761,0.00250452,0.00229867,0.00216144,
0.00208424,0.0021014,0.0022129,0.00235871,0.00261603,0.00291623,0.00327647,0.00395406,0.00464881,0.00542933,
0.00631277,0.00756504,0.00898884,0.0109015,0.0136205,0.0177804,0.0230382,0.0304488,0.0404412,0.0531354,
0.0671418,0.0858743,0.113416,0.174202,0.236858,0.285919,0.325039,0.359305,0.387266,0.404961,0.412029,
0.407997,0.394334,0.375927,0.360823,0.354562,0.355737,0.360429,0.363868,0.357418,0.338445,0.308374,0.270926,
0.227371,0.174751,0.122078,0.0987915,0.0834984,0.0727084,0.0631964,0.0555027,0.0476117,0.0400038,0.0334594,
0.0284246,0.0242133,0.0205851,0.0174287,0.0145039,0.0121967,0.010447,0.00904888,0.00803678,0.00711902,
0.00653578,0.00608977,0.00582388,0.00573811,0.00582388,0.00608119,0.00644143,0.00691317,0.00749642,0.00823405,
0.00913465,0.0103097,0.011785,0.0135261,0.0155504,0.0174545,0.019127,0.0206537,0.0219146,0.022901,0.023853,
0.024908,0.0259973,0.0268979,0.0284847,0.0298913,0.0316411,0.0334594,0.0352006,0.0373449,0.039472,0.0419079,
0.0442666,0.0466425,0.0499361,0.0533755,0.0568493,0.0609749,0.0659239,0.0715591,0.0775974,0.08367,0.0912264,
0.0990145,0.108844,0.119651,0.135819,0.154569,0.176406,0.191699,0.20128,0.208802,0.21406,0.217834,0.220861,
0.222457,0.222963,0.222963,0.224224,0.226179,0.228246,0.228744,0.227217,0.2102,0.201563,0.189315,0.169175,
0.149628,0.136153,0.127902,0.124463,0.12635,0.1328,0.14305,0.15378,0.162777,0.169596,0.171534,0.170076,
0.166954,0.164895,0.162545,0.158377,0.150717,0.139336,0.125835,0.114007,0.103149,0.0929419,0.0834127,
0.075719,0.0675535,0.0602372,0.0544391,0.0480234,0.0418907,0.036024,0.0313237,0.0269837,0.0234928,0.0202678,
0.0173859,0.0144868,0.0121452,0.010284,0.0087058,0.00747069,0.00629562,0.0054036,0.00464023,0.00386829,
0.00312208,0.00277042,0.00241875,0.00219575,0.00208424,0.00201563,0.00203278,0.00208424,0.0022901,0.00247879,
0.0028133,0.00307919,0.00368817,0.00441723,0.00524921,0.00608119,0.00733345,0.00882588,0.0108672,0.0137835,
0.0180291,0.0234671,0.0306461,0.0401496,0.0520118,0.0642428,0.0807109,0.101999,0.136128,0.200894,0.244517,
0.280644,0.30707,0.326377,0.339054,0.344303,0.34366,0.337939,0.328462,0.320142,0.31605,0.315544,0.317783,
0.318178,0.311282,0.295671,0.269211,0.233984,0.192334,0.13515,0.105996,0.0882073,0.0764309,0.0661383,
0.0579043,0.0503221,0.0421395,0.0346859,0.0289736,0.0243333,0.0206795,0.0176089,0.0146669,0.0123768,0.0105156,
0.00908319,0.00799389,0.00699037,0.00626131,0.0057038,0.00546364,0.00530067,0.00530067,0.0054036,0.00558372,
0.00584961,0.0063042,0.00689602,0.0076165,0.00842275,0.00956351,0.0109101,0.0125741,0.0144439,0.0165196,
0.0183379,0.0200019,0.0213828,0.0225665,0.0235871,0.0246164,0.0257571,0.0266406,0.0280129,0.0294539,0.0308177,
0.0325245,0.0341284,0.0358181,0.0376879,0.0397722,0.0419679,0.044258,0.0469255,0.050588,0.0543447,0.05787,
0.0621242,0.0670132,0.072494,0.0784637,0.084785,0.0922042,0.10031,0.110105,0.119711,0.131728,0.142655,
0.152956,0.164956,0.179605,0.190327,0.197712,0.202686,0.205294,0.20634,0.206812,0.208313,0.211298,0.21442,
0.215646,0.214634,0.198775,0.190147,0.174768,0.155392,0.141428,0.130673,0.123605,0.121006,0.123039,0.129463,
0.14015,0.152279,0.163557,0.173867,0.178079,0.178396,0.177221,0.174682,0.170514,0.163043,0.153291,0.14021,
0.125329,0.112678,0.100979,0.0900428,0.0803249,0.071722,0.0634622,0.0567292,0.0507509,0.0443095,0.0384427,
0.0333565,0.0288449,0.0248394,0.0212456,0.0182093,0.0154131,0.0128657,0.0109015,0.00928904,0.00807109,
0.00693891,0.00591823,0.00525779,0.00451157,0.00381683,0.00309635,0.00279615,0.00247022,0.00226436,0.00209282,
0.00207567,0.00208424,0.00216144,0.00229867,0.0025131,0.0028133,0.00308777,0.0037139,0.00439149,0.00518917,
0.00596111,0.00726484,0.00877441,0.0108844,0.0138435,0.0181578,0.0235614,0.0304746,0.0391889,0.050202,
0.061215,0.0757018,0.0920756,0.11393,0.150134,0.202395,0.233641,0.257537,0.275215,0.286434,0.291846,0.29423,
0.294264,0.291846,0.288535,0.285765,0.285301,0.285636,0.282737,0.273928,0.256911,0.232209,0.198089,0.143899,
0.111777,0.0925387,0.0790984,0.0687629,0.0600142,0.0527494,0.044421,0.0366501,0.0300543,0.0247107,0.0205851,
0.0174202,0.0145297,0.0122138,0.0104555,0.00901457,0.00790812,0.00692175,0.00608977,0.00553225,0.00514628,
0.00488039,0.00476031,0.00481177,0.00494043,0.00518059,0.00542075,0.0057038,0.00620985,0.00689602,0.00774516,
0.00868006,0.00988086,0.0115191,0.0133203,0.0153531,0.0173087,0.0189383,0.0203964,0.0216659,0.0228238,
0.023853,0.0249766,0.0260659,0.0270094,0.0284332,0.0296597,0.0310407,0.0324559,0.0339226,0.0353378,0.0370275,
0.038803,0.0410931,0.0437263,0.0467626,0.0506051,0.0544134,0.0580243,0.06221,0.0671847,0.0727513,0.0788239,
0.085231,0.0927618,0.10061,0.108827,0.11562,0.121255,0.127791,0.135716,0.145597,0.157939,0.172298,0.181321,
0.186381,0.18904,0.190464,0.193423,0.197703,0.20236,0.205268,0.204059,0.190189,0.179657,0.162743,0.148153,
0.136299,0.127551,0.12195,0.119883,0.121761,0.128151,0.139061,0.152279,0.165942,0.178104,0.184014,0.185678,
0.18488,0.181913,0.176629,0.166928,0.154028,0.139027,0.123065,0.110336,0.0979938,0.0867406,0.0772629,
0.0683512,0.0603487,0.0540188,0.0472429,0.0414104,0.0356466,0.0306633,0.0263575,0.0224635,0.019067,0.0162194,
0.013449,0.0114162,0.00982082,0.00845706,0.00746211,0.00651005,0.00563518,0.00505193,0.00440007,0.00378252,
0.00314781,0.00284761,0.00256456,0.00235871,0.00227294,0.00218717,0.0022129,0.00229867,0.00245306,0.00267607,
0.00293338,0.0033022,0.00389402,0.00453731,0.00528352,0.00606404,0.00728199,0.00879157,0.010893,0.0138435,
0.0180463,0.0233727,0.0299857,0.0380911,0.0480062,0.0581787,0.0702382,0.0834127,0.0997607,0.119342,0.14956,
0.189555,0.21237,0.226574,0.236583,0.243453,0.248754,0.252562,0.254681,0.256062,0.256414,0.256482,0.254681,
0.249723,0.239071,0.221427,0.194083,0.14612,0.114273,0.0948889,0.0807109,0.0701353,0.061155,0.0544048,
0.0464109,0.0387687,0.031804,0.0258172,0.0207824,0.0172829,0.014238,0.0119565,0.0101811,0.00880872,0.00776231,
0.00681883,0.00588392,0.00530067,0.00482893,0.00446869,0.00423711,0.00415134,0.00423711,0.00443438,0.00464023,
0.00493185,0.00526636,0.00557514,0.0061155,0.00691317,0.00789954,0.00898884,0.0104298,0.0119994,0.0139207,
0.0159363,0.0176346,0.0190927,0.0204565,0.0216401,0.0227809,0.0237673,0.024908,0.0260316,0.0269579,0.0281673,
0.0292909,0.0302945,0.031581,0.0329019,0.0341113,0.0356209,0.0375507,0.040201,0.043083,0.0462222,0.0501505,
0.0540789,0.057707,0.0620985,0.0672962,0.0730343,0.0792442,0.0855655,0.0927532,0.0989716,0.104392,0.109067,
0.113072,0.11785,0.125689,0.135965,0.1463,0.155306,0.162365,0.168078,0.173121,0.179442,0.18681,0.193097,
0.196245,0.195336,0.181698,0.171122,0.156739,0.144928,0.134627,0.126899,0.122138,0.120329,0.122327,0.129095,
0.139704,0.152785,0.166345,0.179168,0.186416,0.189426,0.189092,0.186193,0.1797,0.167752,0.152441,0.136068,
0.119823,0.107291,0.0949403,0.0837386,0.0745782,0.0655551,0.0580844,0.0517459,0.044867,0.038863,0.0334165,
0.0284933,0.024076,0.0202849,0.0170685,0.0141866,0.0119222,0.0101811,0.00886876,0.00789954,0.00693891,
0.00608977,0.00547221,0.00488897,0.00427999,0.00380825,0.00321643,0.00293338,0.00275326,0.00256456,0.00247879,
0.00244448,0.00247879,0.00257314,0.00278757,0.00296769,0.00323358,0.00380825,0.00426284,0.00485466,0.00547221,
0.00623558,0.00739349,0.00880872,0.0108501,0.0137063,0.0177804,0.0227809,0.0292137,0.0366758,0.0458362,
0.0552539,0.0648174,0.0767139,0.0889707,0.103252,0.118759,0.138461,0.158102,0.177958,0.190395,0.198363,
0.205508,0.211692,0.217053,0.222834,0.227277,0.228409,0.225982,0.219103,0.205783,0.180523,0.141609,0.11393,
0.0951719,0.0810197,0.0701267,0.0610864,0.0546535,0.0474916,0.0403554,0.0334165,0.0270008,0.0216144,0.017403,
0.0140322,0.0117078,0.00988086,0.00855998,0.00747926,0.0065272,0.00569522,0.00514628,0.00453731,0.00407414,
0.00380825,0.00359382,0.00357667,0.00374821,0.00386829,0.00407414,0.00430572,0.00464023,0.00503478,0.00547221,
0.00606404,0.00695606,0.00807109,0.00928046,0.0108072,0.0124454,0.0141694,0.0160049,0.0175488,0.0188697,
0.0201649,0.021297,0.0223606,0.023407,0.0244277,0.0255856,0.026409,0.0272667,0.0283131,0.0292566,0.0301572,
0.0313923,0.0327475,0.0344201,0.0365472,0.0393262,0.0423882,0.0455703,0.0495844,0.0537358,0.0576469,0.0622014,
0.0677765,0.0736605,0.0796559,0.0856513,0.0916381,0.0961068,0.0997864,0.103483,0.108183,0.114007,0.121135,
0.130896,0.139524,0.146823,0.153008,0.158454,0.165762,0.176123,0.184314,0.188234,0.187522,0.174013,0.164878,
0.154792,0.144851,0.136085,0.1293,0.124857,0.123382,0.125724,0.132139,0.141883,0.153008,0.164244,0.176106,
0.184048,0.18838,0.189212,0.186381,0.178705,0.163678,0.147432,0.13129,0.116203,0.10374,0.0921442,0.0814571,
0.0721166,0.0635051,0.0564719,0.0500562,0.0431859,0.0369417,0.0314095,0.0263318,0.0219317,0.018235,0.0151043,
0.0125569,0.0106271,0.00920327,0.00814828,0.00727341,0.00649289,0.00572095,0.00526636,0.00470885,0.00421995,
0.00381683,0.00331935,0.00306204,0.00290765,0.00282188,0.00277042,0.00277899,0.00284761,0.00295054,0.00312208,
0.0034137,0.00386829,0.00427141,0.00473458,0.00525779,0.00569522,0.00651005,0.00753073,0.00886018,0.0107729,
0.0133718,0.0173172,0.0220175,0.0280129,0.0349947,0.043529,0.0524063,0.0604345,0.0702382,0.0801962,0.0908319,
0.102042,0.112832,0.121778,0.130312,0.13696,0.143676,0.150795,0.159603,0.171809,0.184469,0.19326,0.196193,
0.193818,0.183191,0.157708,0.132268,0.111031,0.0939111,0.0801276,0.0688401,0.0599199,0.0535642,0.0467883,
0.0405098,0.0341542,0.0283646,0.0228066,0.0182007,0.0142895,0.0116821,0.0098294,0.00838844,0.00726484,
0.00626131,0.00553225,0.00493185,0.00427141,0.00378252,0.00328504,0.00307919,0.00303631,0.00303631,0.00308777,
0.00321643,0.00340512,0.00374821,0.00399695,0.00429715,0.0048032,0.00536929,0.00608119,0.00703325,0.00815686,
0.00952062,0.0109444,0.0124883,0.0140065,0.0156361,0.0170428,0.0183036,0.0195301,0.0206023,0.0216144,
0.0226951,0.0236129,0.0245649,0.025517,0.0262117,0.026795,0.0277299,0.0289564,0.0300972,0.0317869,0.0337425,
0.0360326,0.0387772,0.0419422,0.0452273,0.0496359,0.0540617,0.0581015,0.0629734,0.0685828,0.0746554,0.0801276,
0.0852396,0.0896911,0.0934908,0.0972047,0.10133,0.106785,0.113527,0.120414,0.129155,0.136745,0.143513,
0.149251,0.155598,0.164552,0.17379,0.178044,0.178001,0.167546,0.162751,0.155581,0.147741,0.140322,0.134181,
0.130853,0.13033,0.13316,0.138967,0.146309,0.154611,0.162177,0.170899,0.178199,0.182659,0.184417,0.181244,
0.171723,0.155649,0.140116,0.123897,0.111288,0.0994519,0.0885504,0.0789954,0.070324,0.0620728,0.0552368,
0.0485123,0.0417449,0.0350977,0.0295311,0.0243848,0.0199676,0.0163823,0.0133203,0.0112189,0.00965786,
0.00841417,0.00754788,0.00680167,0.00596111,0.00546364,0.00500905,0.00452015,0.00409987,0.0038254,0.0034137,
0.00321643,0.00307062,0.003002,0.00299342,0.00306204,0.0031907,0.0034137,0.0038254,0.0040913,0.00446869,
0.00482035,0.00524921,0.00558372,0.00608977,0.00684456,0.00777089,0.00895453,0.0106614,0.0130544,0.0165968,
0.0209883,0.0265977,0.0333908,0.041033,0.0491727,0.0565405,0.0639426,0.0726312,0.0807023,0.0886361,0.0965957,
0.103029,0.108115,0.111194,0.114265,0.117996,0.123476,0.130647,0.138221,0.145151,0.149011,0.146472,0.136437,
0.120852,0.106219,0.0916381,0.0785237,0.067099,0.0580844,0.0514371,0.0448756,0.0392747,0.0339054,0.0287677,
0.0236043,0.0190069,0.0149585,0.0119308,0.00985513,0.00837986,0.00716191,0.0061155,0.00536929,0.00470885,
0.00404841,0.00336224,0.00299342,0.00283046,0.00268464,0.00261603,0.00264176,0.00271895,0.00283903,0.0029248,
0.00306204,0.00321643,0.00354236,0.00404841,0.00464023,0.00530067,0.00609835,0.00711902,0.00829409,0.00954636,
0.0108158,0.0121023,0.0135176,0.0148642,0.0162623,0.0174716,0.0185524,0.0197103,0.0207052,0.021623,0.0225665,
0.0233984,0.0241189,0.0249166,0.0258686,0.0266577,0.0280472,0.0296254,0.0314609,0.0335195,0.0358782,0.0387172,
0.0421223,0.0458705,0.050485,0.0548422,0.0592852,0.0641484,0.0700838,0.075719,0.080445,0.0847764,0.088679,
0.0928733,0.0970846,0.102402,0.108955,0.115543,0.122284,0.130072,0.136471,0.142543,0.148376,0.154869,
0.160753,0.165041,0.167812,0.163875,0.163703,0.159878,0.153548,0.146738,0.141703,0.139584,0.141283,0.145545,
0.15167,0.156687,0.160521,0.16336,0.166748,0.171174,0.174691,0.175677,0.171208,0.1595,0.145528,0.130218,
0.116066,0.104727,0.0942971,0.0847078,0.0762936,0.0680767,0.0603573,0.054096,0.0466082,0.0398751,0.033408,
0.027524,0.0224292,0.0181321,0.0144696,0.0118879,0.00997521,0.00867149,0.00773658,0.00689602,0.00614123,
0.00557514,0.00514628,0.00470885,0.00430572,0.00403126,0.0037911,0.00350805,0.00335366,0.00326789,0.003225,
0.00331935,0.00347374,0.00381683,0.00407414,0.00439149,0.00469169,0.00504336,0.00530067,0.00560945,0.00599542,
0.00653578,0.00711045,0.00800247,0.00905746,0.0105756,0.0127456,0.0159535,0.0199676,0.0251396,0.0313409,
0.038194,0.045536,0.0530067,0.0591908,0.0658467,0.0726055,0.0787467,0.0842532,0.0890736,0.0929076,0.0953778,
0.0977279,0.100584,0.104435,0.109136,0.113347,0.116572,0.117961,0.116032,0.109916,0.0997435,0.0880186,
0.0766625,0.065212,0.056206,0.0488811,0.0423882,0.0371905,0.0326017,0.028133,0.0237072,0.019573,0.0157905,
0.0124369,0.0101039,0.00852568,0.00728199,0.00613265,0.00530067,0.00457161,0.00386829,0.00315639,0.00283903,
0.00255599,0.00235871,0.00229867,0.00228152,0.0022901,0.00231583,0.00238444,0.00249595,0.00261603,0.00277042,
0.00291623,0.0031907,0.00385971,0.00453731,0.00530067,0.0061155,0.00711902,0.00818259,0.00931477,0.0104727,
0.0116306,0.01284,0.0139979,0.0152502,0.0164338,0.0176089,0.0185524,0.0196931,0.0205508,0.0213742,0.0221033,
0.0228924,0.0238187,0.025071,0.0263147,0.0277985,0.0295997,0.0315553,0.033751,0.036247,0.0393691,0.0431687,
0.0473201,0.0520804,0.0562317,0.0607862,0.0659067,0.0713275,0.0764823,0.0808224,0.0849566,0.0893824,0.0941255,
0.099632,0.105979,0.112523,0.118708,0.125484,0.131711,0.136728,0.141977,0.146206,0.150829,0.155504,0.160538,
0.16258,0.166165,0.165324,0.160761,0.155401,0.15209,0.152527,0.157073,0.165685,0.174313,0.176869,0.174802,
0.17162,0.169218,0.168112,0.168223,0.166671,0.160332,0.149337,0.135407,0.120183,0.108801,0.0978995,0.0885761,
0.0803421,0.0727084,0.0650319,0.0583074,0.0519946,0.044421,0.0374992,0.0312551,0.0256285,0.0204222,0.0163223,
0.0129,0.0105928,0.00898884,0.00788239,0.00695606,0.00623558,0.0056266,0.00524921,0.00476031,0.00440007,
0.00408272,0.00386829,0.00374821,0.00355094,0.00347374,0.00347374,0.00354236,0.00377394,0.00395406,0.00423711,
0.00454588,0.00488897,0.0052149,0.00547221,0.00569522,0.00606404,0.00649289,0.00693891,0.00749642,0.00815686,
0.00914323,0.0104984,0.0123682,0.0150271,0.0187153,0.0234585,0.029188,0.0352006,0.0420537,0.048761,0.0547908,
0.0600142,0.065212,0.0704955,0.0752129,0.0786095,0.0814828,0.0834727,0.0854798,0.0876584,0.0907375,0.0938082,
0.0968102,0.0985856,0.0987829,0.0967072,0.0913379,0.0831639,0.0741065,0.0635051,0.0548079,0.0462651,0.0396006,
0.0345058,0.0304488,0.0266492,0.0229953,0.0194272,0.0160478,0.0128571,0.0104727,0.00872295,0.00746211,
0.00629562,0.0054036,0.00460592,0.0038254,0.00306204,0.00266749,0.00235871,0.00216144,0.00204994,0.00198132,
0.00194701,0.00197274,0.0019899,0.00205851,0.00209282,0.00218717,0.00229867,0.00244448,0.00266749,0.00299342,
0.00365386,0.00448584,0.00530067,0.00608977,0.00704183,0.00807966,0.009006,0.00994948,0.0109959,0.0119651,
0.0130458,0.0141609,0.0153617,0.0165024,0.0176003,0.0184752,0.0194101,0.0202678,0.0210569,0.022129,0.0233984,
0.024848,0.0263575,0.0280472,0.0299342,0.0321385,0.0344544,0.037362,0.041033,0.0449185,0.0494987,0.0539845,
0.058093,0.0626303,0.0678623,0.0727084,0.0775888,0.0819974,0.0865862,0.0918869,0.0974534,0.103861,0.110637,
0.116778,0.122447,0.127928,0.132165,0.136033,0.139816,0.144293,0.150229,0.156636,0.163206,0.170359,0.172915,
0.171774,0.169596,0.169519,0.174639,0.183414,0.191699,0.196279,0.196245,0.191528,0.184443,0.177693,0.172778,
0.169038,0.163575,0.155083,0.142758,0.127628,0.113639,0.101673,0.0917325,0.083061,0.0759248,0.0685313,
0.0616868,0.0554169,0.0488125,0.0415134,0.0346431,0.0287677,0.0231926,0.0184408,0.0144267,0.0115191,0.00946916,
0.00811397,0.00703325,0.00628704,0.00563518,0.00524921,0.00471743,0.00430572,0.00404841,0.00384256,0.00365386,
0.00355094,0.00353378,0.00356809,0.00366244,0.0038254,0.0040141,0.00427141,0.00460592,0.00496616,0.00528352,
0.00553225,0.00577241,0.0061155,0.00651005,0.00688744,0.00728199,0.00783093,0.00841417,0.00928046,0.010447,
0.0119908,0.0143152,0.0177204,0.0217859,0.0267521,0.0324645,0.0382197,0.044258,0.0500905,0.0548251,0.0588563,
0.0626303,0.0662241,0.0695692,0.0720051,0.0743038,0.0761478,0.0780348,0.0799904,0.0821175,0.0837986,0.0847679,
0.0839959,0.0814828,0.0767911,0.0700152,0.061601,0.0537701,0.0448584,0.0374992,0.0322329,0.0283474,0.0250109,
0.0217173,0.0185952,0.0157905,0.0128743,0.0106271,0.0089288,0.0076165,0.00649289,0.00553225,0.00474316,
0.00388544,0.00306204,0.00261603,0.00228152,0.00201563,0.00187839,0.00178404,0.00173258,0.00169827,0.00173258,
0.00174116,0.00177547,0.00183551,0.00187839,0.00193843,0.00201563,0.00217859,0.00247879,0.00289907,0.0035252,
0.00443438,0.00528352,0.00599542,0.00693033,0.00784808,0.0086286,0.00950347,0.0103355,0.0112532,0.0121281,
0.0132002,0.0142724,0.0154903,0.016511,0.0175574,0.0184408,0.0194444,0.0205508,0.0218717,0.0234156,0.0251139,
0.0267178,0.0288449,0.0307748,0.0331678,0.0357066,0.0390346,0.0428342,0.0467711,0.0514714,0.0556313,0.0599027,
0.0644829,0.0696121,0.074664,0.0793385,0.0841417,0.0894338,0.0954292,0.102119,0.109178,0.115345,0.120131,
0.125063,0.128777,0.132028,0.135965,0.141111,0.147287,0.155366,0.16577,0.175746,0.18169,0.184563,0.186733,
0.189984,0.195799,0.203861,0.210389,0.213133,0.211324,0.205011,0.19597,0.188165,0.181312,0.175737,0.167014,
0.154732,0.139704,0.122876,0.109101,0.0965357,0.0861488,0.0782321,0.0709415,0.0638825,0.0579643,0.0520804,
0.0448155,0.0377994,0.0316153,0.0260917,0.020851,0.0165367,0.0128743,0.0103097,0.00855998,0.00733345,
0.00637281,0.00566091,0.00523205,0.00464881,0.00419422,0.00386829,0.0036024,0.0034137,0.00335366,0.00336224,
0.0034137,0.00356809,0.00377394,0.00394548,0.00419422,0.00451157,0.00488897,0.00525779,0.00553225,0.00573811,
0.00610692,0.00647574,0.0068274,0.00711045,0.00754788,0.00805393,0.00862002,0.00940054,0.0104298,0.011845,
0.0138521,0.0167168,0.0203707,0.0248222,0.0296597,0.0346688,0.0400038,0.0447555,0.0494644,0.0532469,0.0561888,
0.058985,0.0614466,0.063548,0.065658,0.0677165,0.0695692,0.0713018,0.0727599,0.0737548,0.0736948,0.0722538,
0.0693719,0.0643457,0.0586076,0.0521747,0.0439407,0.0363242,0.0305003,0.0263575,0.0231154,0.0202849,0.0176689,
0.0148642,0.0125312,0.0105241,0.00893738,0.00770227,0.00656151,0.00560945,0.00488897,0.00404841,0.00313923,
0.0026246,0.00223863,0.00193843,0.00176689,0.00159535,0.00146669,0.00137234,0.00133803,0.00134661,0.00140665,
0.00144954,0.00149242,0.00154388,0.00162108,0.00173258,0.00184408,0.00201563,0.00233298,0.00283046,0.0034137,
0.00435719,0.00519775,0.00582388,0.00675879,0.00749642,0.00823405,0.00896311,0.00976078,0.0104984,0.0114162,
0.0124111,0.0133975,0.0144868,0.0157047,0.0168112,0.0179176,0.0191013,0.0205937,0.0222405,0.0239903,0.0259973,
0.0277042,0.0297712,0.0320528,0.0344201,0.0373449,0.0408014,0.0444467,0.0488125,0.0531354,0.0571066,0.0614209,
0.0660869,0.0711902,0.0764823,0.0815,0.0871952,0.093405,0.100224,0.107317,0.113561,0.118347,0.122696,
0.126376,0.129712,0.133846,0.13949,0.146738,0.155581,0.169476,0.181458,0.189984,0.195173,0.199727,0.20532,
0.212541,0.219309,0.224687,0.225656,0.221753,0.214566,0.205036,0.195936,0.189649,0.183774,0.174811,0.158694,
0.140828,0.121332,0.106374,0.0930877,0.0823148,0.0739692,0.0662412,0.0598942,0.0543533,0.047646,0.0409215,
0.0341799,0.0285104,0.0233727,0.0186982,0.014624,0.0115191,0.0093405,0.00788239,0.0067159,0.00577241,
0.00526636,0.00464881,0.0040913,0.00368817,0.00331935,0.00316496,0.00312208,0.00313923,0.0031907,0.00331935,
0.00347374,0.00377394,0.0040141,0.00429715,0.00464881,0.00504336,0.00536071,0.00563518,0.00593538,0.00629562,
0.00663871,0.00693891,0.00729057,0.00773658,0.00813113,0.00869722,0.00942628,0.0104298,0.0117164,0.0135433,
0.0161336,0.0192299,0.022901,0.0270609,0.0315724,0.0358267,0.0401839,0.0437949,0.0469856,0.0503221,0.0531182,
0.0553054,0.0572953,0.0591565,0.0607176,0.0622786,0.0634537,0.0642256,0.06438,0.0635652,0.0620299,0.0589421,
0.0548937,0.0494901,0.0425683,0.035415,0.0295654,0.0250452,0.0215629,0.018844,0.0163995,0.0139722,0.0119222,
0.0101725,0.00872295,0.00759077,0.00653578,0.00560945,0.00494043,0.00409987,0.00321643,0.00269322,0.00223863,
0.00190412,0.00168112,0.00143238,0.0012008,0.00110645,0.00104641,0.00104641,0.00104641,0.00106357,0.00109787,
0.00112361,0.00114934,0.00119222,0.00132946,0.00147527,0.00168112,0.00190412,0.00226436,0.00276184,0.00331935,
0.00423711,0.00504336,0.00564376,0.00642428,0.00709329,0.0078395,0.00841417,0.00910892,0.00986371,0.0108072,
0.0117593,0.0128228,0.0139207,0.015173,0.0165024,0.0179691,0.0195559,0.0213142,0.0231583,0.0251825,0.0269665,
0.0291108,0.0311607,0.0333822,0.0357752,0.0387772,0.042311,0.0459134,0.0503135,0.0545763,0.0584532,0.0626646,
0.0677079,0.072777,0.0783693,0.0841675,0.0910892,0.0978652,0.104761,0.111288,0.116435,0.120603,0.12496,
0.128734,0.132886,0.138864,0.146506,0.156593,0.173335,0.187573,0.196837,0.204556,0.211238,0.217679,0.224995,
0.2316,0.235683,0.234799,0.229027,0.220287,0.210526,0.20128,0.195044,0.19073,0.182873,0.165367,0.143899,
0.122473,0.105756,0.0915095,0.0799389,0.0706327,0.062596,0.056206,0.0502363,0.0434604,0.0367102,0.0307748,
0.0256028,0.0207824,0.0167769,0.0130458,0.010447,0.00855998,0.00717049,0.00609835,0.00536929,0.00473458,
0.0040913,0.00353378,0.00312208,0.00296769,0.00289907,0.00289907,0.00293338,0.00302773,0.00313923,0.00333651,
0.00366244,0.00400552,0.0043143,0.00471743,0.00508624,0.00542933,0.00569522,0.00603831,0.00636424,0.0067159,
0.00696464,0.00733345,0.00776231,0.00814828,0.00869722,0.0094177,0.0103955,0.0116134,0.0133203,0.0156962,
0.0184151,0.0216144,0.0252768,0.0289736,0.0325931,0.0358782,0.0390517,0.0419079,0.0443781,0.0470113,0.0499018,
0.0521576,0.0541389,0.0554255,0.0564719,0.0572267,0.0575783,0.0570637,0.0559229,0.0541046,0.0505708,0.0455618,
0.0399952,0.033974,0.0285361,0.0237415,0.0202678,0.0175831,0.0151644,0.0129343,0.011176,0.00970074,0.00839702,
0.00733345,0.0063042,0.00553225,0.00482035,0.00407414,0.00321643,0.00269322,0.00223863,0.00188697,0.00162108,
0.00133803,0.00110645,0.00100353,0.000952062,0.000917754,0.000917754,0.000917754,0.000934908,0.000943485,
0.000943485,0.000969217,0.000994948,0.00102926,0.00108072,0.00125226,0.00154388,0.00185266,0.00216144,
0.00266749,0.00321643,0.0040913,0.00485466,0.00548079,0.00606404,0.00679309,0.00735061,0.00801962,0.00866291,
0.00945201,0.0103526,0.0113819,0.0124454,0.0137063,0.0151987,0.0168712,0.0185609,0.0205508,0.0225407,
0.0244963,0.0264004,0.0283989,0.0302087,0.0323701,0.0345316,0.0371219,0.040201,0.0435547,0.0473715,0.0519603,
0.0556227,0.059654,0.0638225,0.0691317,0.0747926,0.0806165,0.0872552,0.094237,0.101313,0.108252,0.113913,
0.118673,0.123494,0.128048,0.132422,0.138366,0.14642,0.157639,0.177392,0.192411,0.203089,0.211967,0.219309,
0.22726,0.235056,0.240958,0.242947,0.240735,0.233839,0.224472,0.214171,0.205182,0.198955,0.195053,0.188182,
0.170668,0.145991,0.123262,0.10567,0.0904888,0.0782921,0.0679738,0.0595253,0.0530239,0.0459735,0.0393691,
0.0332879,0.0276012,0.0227637,0.0185352,0.0148384,0.0117678,0.00956351,0.00795101,0.00668159,0.00560945,
0.00496616,0.00423711,0.00357667,0.00306204,0.00284761,0.00266749,0.00261603,0.0026246,0.00274468,0.00286476,
0.00299342,0.00317354,0.0034909,0.00389402,0.00427141,0.00469169,0.00506909,0.0054036,0.00566091,0.00595253,
0.00629562,0.00659582,0.00689602,0.00719622,0.00762508,0.00807966,0.00862002,0.0093405,0.0102668,0.0115191,
0.0131488,0.0153273,0.0179176,0.0206623,0.0236729,0.0266835,0.0298141,0.0327561,0.0350977,0.0374221,0.0396006,
0.0420537,0.0443095,0.0464795,0.0486667,0.050262,0.0512141,0.0515743,0.0513084,0.050365,0.048478,0.0454674,
0.041642,0.0366673,0.0318726,0.0267607,0.0225236,0.018844,0.0161164,0.0137234,0.0118708,0.0103011,0.00898884,
0.00789954,0.00689602,0.00593538,0.00528352,0.00456304,0.00386829,0.00309635,0.00261603,0.00217859,0.00187839,
0.00158677,0.00128657,0.00104641,0.000952062,0.000849137,0.00078052,0.000771942,0.000763365,0.000763365,
0.000771942,0.000771942,0.00078052,0.00078052,0.000806251,0.00084056,0.000917754,0.000994948,0.00110645,
0.00143238,0.00179262,0.00209282,0.00256456,0.00307919,0.00388544,0.00458877,0.00524921,0.00566091,0.00628704,
0.00693033,0.00762508,0.00830267,0.00913465,0.0100696,0.0112017,0.0124454,0.0139722,0.0159192,0.0178233,
0.0198303,0.0217945,0.0237673,0.0258686,0.0274726,0.0294367,0.0313323,0.033408,0.0356037,0.0382626,0.0415562,
0.0450643,0.0494129,0.0532898,0.0567292,0.0606232,0.0651348,0.0707014,0.0767654,0.0829924,0.0900342,0.0970503,
0.103981,0.110516,0.116032,0.12086,0.126101,0.131565,0.137749,0.146506,0.159054,0.18096,0.196579,0.208802,
0.217885,0.226299,0.234696,0.24227,0.247382,0.248257,0.245092,0.238127,0.228152,0.217885,0.209394,0.203072,
0.197857,0.189958,0.171388,0.145297,0.122138,0.104538,0.0890135,0.0764309,0.0650319,0.056592,0.0496445,
0.0424225,0.0356981,0.0298656,0.0248737,0.0203879,0.0165968,0.0132688,0.0106785,0.00875726,0.00737634,
0.0061155,0.00528352,0.00452015,0.0038254,0.00310492,0.0028133,0.00253026,0.00236729,0.00234156,0.00236729,
0.00247879,0.00261603,0.00284761,0.00303631,0.00331935,0.00381683,0.00417707,0.00457161,0.00499189,0.00530067,
0.00556656,0.00578957,0.00609835,0.00637281,0.0067159,0.00698179,0.00739349,0.00789954,0.00841417,0.0091175,
0.010061,0.0113561,0.0129086,0.0149156,0.0173944,0.0198904,0.0224635,0.0251482,0.0276012,0.0299599,0.0321042,
0.0338969,0.0355008,0.0374907,0.0395406,0.0416077,0.0431687,0.0442923,0.0449185,0.0448842,0.0442752,0.0429028,
0.0406642,0.0374735,0.0336481,0.0294796,0.0251567,0.0209368,0.0175917,0.0144868,0.0122567,0.0106271,0.00928904,
0.00815686,0.00717049,0.00628704,0.00554941,0.00493185,0.00418564,0.0034137,0.00290765,0.00247879,0.00208424,
0.00183551,0.00150958,0.00114934,0.00102068,0.000917754,0.00078052,0.000746211,0.000703325,0.00066044,
0.000643285,0.000643285,0.000643285,0.000643285,0.000651863,0.00066044,0.000686171,0.00072048,0.000754788,
0.000789097,0.000917754,0.00104641,0.00132946,0.00173258,0.00204994,0.00246164,0.0029248,0.00353378,0.00423711,
0.00487181,0.0054036,0.00591823,0.00663013,0.00734203,0.00813113,0.009006,0.010061,0.0113561,0.0128657,
0.0146669,0.0168369,0.0189297,0.0208939,0.0229181,0.0249681,0.0266063,0.028519,0.0301744,0.0322586,0.0343686,
0.0367702,0.0398494,0.0432116,0.0468998,0.0509911,0.0545163,0.0577842,0.0617811,0.0666272,0.0725111,0.0788067,
0.0853082,0.092513,0.0997092,0.106614,0.112746,0.117884,0.123193,0.129206,0.136351,0.146386,0.160753,
0.184743,0.20098,0.213888,0.223889,0.232629,0.241215,0.247896,0.252228,0.2533,0.250924,0.244886,0.235751,
0.225021,0.215681,0.20827,0.200594,0.189984,0.167674,0.14172,0.118913,0.102197,0.0868092,0.0739778,0.0624073,
0.054096,0.0459134,0.0387772,0.032576,0.0269665,0.0223434,0.0183465,0.0147098,0.0119136,0.00981225,0.00813113,
0.00687029,0.00569522,0.00494043,0.00409987,0.00331078,0.00286476,0.00248737,0.0022901,0.00216144,0.00210998,
0.00216144,0.0022901,0.0024016,0.0026246,0.00289907,0.00312208,0.00354236,0.00402268,0.00443438,0.00481177,
0.00513771,0.0054036,0.00560945,0.0058153,0.00608977,0.00637281,0.00675879,0.00703325,0.007505,0.00812255,
0.00879157,0.00982082,0.0110216,0.0125912,0.0144439,0.0168198,0.0190584,0.0214,0.0236729,0.0259887,0.0276784,
0.029471,0.0308091,0.0322758,0.0336738,0.0349947,0.0365386,0.0377909,0.0386915,0.0390774,0.0387772,0.0377308,
0.0359039,0.0335538,0.0304317,0.0268379,0.0231583,0.0194615,0.016125,0.0130544,0.0109702,0.0094177,0.00827694,
0.00728199,0.00639855,0.00560945,0.00504336,0.00439149,0.00373963,0.00303631,0.00261603,0.0022901,0.00198132,
0.00173258,0.00140665,0.00109787,0.000977794,0.00084056,0.000763365,0.000711902,0.000643285,0.000574668,
0.000557514,0.00054036,0.00054036,0.00054036,0.00054036,0.00054036,0.00054036,0.000548937,0.000557514,
0.000608977,0.00066044,0.000746211,0.000806251,0.000994948,0.00118365,0.00162108,0.00194701,0.00229867,
0.00279615,0.0031907,0.00389402,0.00454588,0.00524921,0.0057038,0.00645001,0.00718764,0.00811397,0.00910034,
0.0103526,0.0118536,0.0136205,0.0158506,0.0179005,0.0199676,0.0219317,0.0238016,0.0257829,0.0273096,0.0292566,
0.0312122,0.0333565,0.0356809,0.0384084,0.0418221,0.0450557,0.0489755,0.0523291,0.0554169,0.0587706,0.0630334,
0.0684799,0.0751186,0.0813284,0.0881644,0.0957466,0.102977,0.109787,0.115465,0.120492,0.127096,0.135442,
0.146763,0.162828,0.190301,0.205766,0.21828,0.228752,0.238196,0.246215,0.252785,0.257503,0.259707,0.258987,
0.254304,0.246636,0.236009,0.225176,0.215303,0.20417,0.188954,0.161173,0.135176,0.114282,0.0978995,0.0832754,
0.0707099,0.0596368,0.0509053,0.0426026,0.0354064,0.0296254,0.0244963,0.0201477,0.0164338,0.0131745,0.0107643,
0.0089288,0.007505,0.00629562,0.00536929,0.00453731,0.00375679,0.00299342,0.00256456,0.0022901,0.00208424,
0.00198132,0.00193843,0.00198132,0.00208424,0.00225579,0.00245306,0.0027018,0.00297627,0.0033022,0.00381683,
0.00417707,0.00454588,0.0049147,0.00518917,0.0054036,0.00557514,0.00572953,0.00602115,0.0063042,0.00672448,
0.00706756,0.00773658,0.00839702,0.0093405,0.010567,0.0119994,0.0138692,0.0160564,0.0182093,0.0202678,
0.0222577,0.0241189,0.0258343,0.0269322,0.0281673,0.0292223,0.0300886,0.0311865,0.0321643,0.0330134,0.0334851,
0.0335109,0.0331163,0.0319413,0.0299599,0.0273782,0.0244534,0.0210569,0.0178319,0.0144267,0.0117335,0.00977794,
0.00827694,0.00711902,0.00623558,0.00554941,0.00499189,0.00430572,0.00365386,0.00305346,0.00266749,0.00229867,
0.00201563,0.00181835,0.00156104,0.00123511,0.00102926,0.000917754,0.00078052,0.000737634,0.000643285,
0.000574668,0.00054036,0.000506051,0.000471743,0.000454588,0.000454588,0.000446011,0.000411703,0.000411703,
0.000446011,0.000454588,0.000463165,0.000497474,0.00054036,0.000574668,0.00066044,0.000771942,0.000943485,
0.00113218,0.00152673,0.00186982,0.00216144,0.00256456,0.00299342,0.00368817,0.00440865,0.00506909,0.00563518,
0.00638139,0.00728199,0.00829409,0.00946916,0.010893,0.0125741,0.0144439,0.0165968,0.0185952,0.0206452,
0.0225493,0.0242733,0.0261517,0.0280129,0.0300114,0.0323444,0.0346688,0.0374649,0.0404412,0.0436147,0.0468054,
0.0504679,0.0536071,0.0564204,0.0601686,0.0653235,0.0717049,0.0785752,0.0856342,0.093405,0.10091,0.107995,
0.114265,0.119951,0.127954,0.13732,0.14998,0.168987,0.197214,0.212516,0.224395,0.234482,0.243239,0.251259,
0.258138,0.263567,0.267204,0.267933,0.264999,0.258078,0.247931,0.235683,0.222011,0.206761,0.186055,0.153745,
0.127336,0.108475,0.092513,0.0789097,0.0666015,0.0563346,0.04714,0.0391203,0.0325674,0.0268464,0.0221633,
0.0181492,0.0145211,0.0118279,0.00981225,0.00815686,0.00691317,0.00573811,0.00501763,0.00410845,0.00326789,
0.00279615,0.00234156,0.00208424,0.0019127,0.00184408,0.00180978,0.00184408,0.00192128,0.00208424,0.0022901,
0.00253026,0.00283046,0.00307919,0.00344801,0.00394548,0.00427141,0.00462308,0.00490612,0.00512913,0.00530067,
0.0055151,0.00566091,0.00589249,0.00623558,0.00669017,0.00719622,0.00793385,0.00879157,0.00991517,0.0113819,
0.0129858,0.0148899,0.0169827,0.018844,0.0206537,0.0222148,0.0235271,0.0245907,0.0255256,0.0261174,0.0265977,
0.0271724,0.0276956,0.0282788,0.0285276,0.0283903,0.0275412,0.0262804,0.0243677,0.021906,0.0190584,0.0161336,
0.0130115,0.010567,0.00862002,0.00718764,0.00605546,0.00528352,0.00464881,0.00404841,0.00335366,0.00291623,
0.00255599,0.00226436,0.0019899,0.00180978,0.00159535,0.00133803,0.00108072,0.000977794,0.000814828,0.000754788,
0.00066044,0.0006004,0.00054036,0.000506051,0.000463165,0.000411703,0.000377394,0.00036024,0.000334508,
0.000334508,0.000317354,0.000317354,0.000317354,0.000334508,0.000343086,0.000368817,0.000411703,0.000471743,
0.00054036,0.000626131,0.000746211,0.000909177,0.00106357,0.00144954,0.0018012,0.00208424,0.00247879,
0.00293338,0.00359382,0.00438292,0.00506909,0.00569522,0.00656151,0.00755646,0.00864576,0.00988086,0.0115019,
0.0132688,0.0152502,0.0173172,0.0191013,0.0208768,0.022738,0.0246078,0.0265377,0.0288449,0.0312465,0.0337425,
0.0363413,0.0392147,0.0422253,0.0451329,0.0485294,0.0518745,0.054868,0.0585819,0.0633851,0.0701353,0.0774344,
0.0851195,0.093405,0.101442,0.109256,0.116066,0.123528,0.132954,0.144002,0.157802,0.179159,0.208999,0.222174,
0.233839,0.243128,0.250804,0.258395,0.264853,0.270643,0.274546,0.275849,0.273671,0.267281,0.257391,0.244466,
0.228315,0.209265,0.182642,0.14582,0.119454,0.101691,0.0864404,0.0739692,0.0622271,0.0530153,0.0437949,
0.0360154,0.0298742,0.0247279,0.0201649,0.0163652,0.0129858,0.0106271,0.00886018,0.00747926,0.00629562,
0.0054036,0.00455446,0.00378252,0.00299342,0.00255599,0.00217859,0.00194701,0.00180978,0.00173258,0.0016897,
0.00173258,0.00181835,0.00193843,0.0021014,0.00234156,0.00261603,0.00290765,0.0031907,0.00365386,0.00402268,
0.00430572,0.00458877,0.00481177,0.00504336,0.00524921,0.00539502,0.00557514,0.00579815,0.00619269,0.00679309,
0.00741065,0.00823405,0.00928046,0.0105756,0.0119737,0.0136462,0.0154989,0.0172915,0.0186553,0.0200448,
0.021014,0.0218202,0.0224035,0.0228066,0.0230811,0.023407,0.02357,0.0236815,0.0236557,0.0232869,0.0224121,
0.0208939,0.0190927,0.0168712,0.0142037,0.0116735,0.00949489,0.00777089,0.00623558,0.00526636,0.0043143,
0.00354236,0.003002,0.00266749,0.00234156,0.00208424,0.00187839,0.00173258,0.001501,0.00130373,0.00108072,
0.000994948,0.000857714,0.000771942,0.000711902,0.000626131,0.000548937,0.000506051,0.000463165,0.000403126,
0.000368817,0.000334508,0.000308777,0.000291623,0.000248737,0.00024016,0.00024016,0.00024016,0.00024016,
0.00024016,0.00024016,0.000291623,0.000317354,0.000368817,0.000454588,0.000523205,0.000617554,0.000746211,
0.000892022,0.00104641,0.00140665,0.00177547,0.00208424,0.00247879,0.00296769,0.00373963,0.00446869,0.00524921,
0.00584103,0.00687029,0.0079167,0.00908319,0.0104813,0.0119994,0.0138006,0.0158162,0.0175917,0.0192643,
0.0209368,0.0228581,0.0249938,0.0271724,0.0297455,0.0325159,0.0350548,0.0378166,0.0407929,0.0436834,0.0467025,
0.0503907,0.054036,0.057707,0.0627246,0.0697321,0.0775888,0.0860973,0.0954464,0.104504,0.11345,0.121521,
0.132062,0.143375,0.156636,0.1759,0.193577,0.224224,0.237321,0.248454,0.256302,0.263001,0.268396,0.273722,
0.278054,0.281116,0.28121,0.278054,0.271964,0.262726,0.249766,0.232252,0.210989,0.179099,0.138795,0.113458,
0.0953692,0.0809939,0.0687629,0.0582302,0.0494043,0.0407929,0.0334937,0.027524,0.0225922,0.0183808,0.0145983,
0.0117335,0.00967501,0.00813113,0.00687029,0.00572953,0.00501763,0.00413418,0.0033022,0.0028133,0.00235871,
0.00207567,0.00186982,0.00173258,0.00162108,0.00156104,0.0016125,0.00173258,0.00184408,0.0019899,0.00218717,
0.00245306,0.00277042,0.00299342,0.0033022,0.00375679,0.00404841,0.00427141,0.00451157,0.00470885,0.00493185,
0.00508624,0.00528352,0.00553225,0.00572953,0.00623558,0.00689602,0.00771085,0.00857714,0.00975221,0.0109444,
0.0122138,0.0136377,0.0151644,0.0165024,0.0176346,0.018398,0.0189297,0.0191956,0.0193758,0.0195216,0.0195473,
0.0194958,0.0193071,0.0190327,0.018458,0.0175831,0.0161851,0.014238,0.0122138,0.0102497,0.00842275,0.00689602,
0.00553225,0.00446011,0.00335366,0.0028133,0.00235871,0.00208424,0.00189555,0.00173258,0.00152673,0.00132088,
0.00113218,0.00102926,0.000952062,0.000849137,0.000771942,0.00072048,0.000634708,0.000557514,0.000514628,
0.000463165,0.000403126,0.000368817,0.000334508,0.000308777,0.000274468,0.00024016,0.000214428,0.000205851,
0.000197274,0.000162966,0.000162966,0.000162966,0.000162966,0.000197274,0.000205851,0.00024016,0.000291623,
0.000343086,0.000454588,0.00054036,0.000634708,0.000763365,0.000934908,0.00109787,0.00147527,0.00183551,
0.00212713,0.00256456,0.00306204,0.00386829,0.00463165,0.00536071,0.0061155,0.00714476,0.00827694,0.00954636,
0.0109444,0.0124454,0.0140751,0.0159706,0.0176174,0.0192557,0.0210226,0.0231497,0.02568,0.0281845,0.0308777,
0.0337167,0.0364185,0.0392404,0.042311,0.0454846,0.04937,0.0532726,0.0574154,0.0629476,0.0704269,0.0787381,
0.0881129,0.0984827,0.109419,0.119385,0.13165,0.144156,0.158471,0.177881,0.194778,0.210311,0.242664,0.255796,
0.266071,0.273345,0.278199,0.281347,0.283689,0.28567,0.286451,0.283938,0.279126,0.272779,0.263387,0.250847,
0.233461,0.210929,0.174828,0.132894,0.108312,0.0900428,0.0763365,0.064097,0.0548594,0.0458191,0.0378166,
0.0313066,0.02568,0.0207738,0.0168369,0.0133203,0.0107643,0.00886876,0.00747926,0.00628704,0.0054036,
0.00459735,0.00381683,0.00304488,0.00260745,0.00226436,0.00198132,0.00180978,0.00164681,0.00152673,0.00147527,
0.00150958,0.0016125,0.00174974,0.00188697,0.00208424,0.00229867,0.00256456,0.00285619,0.00306204,0.00335366,
0.00377394,0.00402268,0.00422853,0.00443438,0.0046145,0.00481177,0.00503478,0.00525779,0.00548079,0.00578957,
0.00636424,0.00703325,0.00790812,0.00879157,0.00983798,0.0108672,0.0118879,0.0129086,0.0139121,0.0147098,
0.0154989,0.0159535,0.0160307,0.0160307,0.0159706,0.0158506,0.0155589,0.0152244,0.014624,0.0139722,0.0129515,
0.0117507,0.0103698,0.00889449,0.00747926,0.00608977,0.00499189,0.00381683,0.00284761,0.00229867,0.00193843,
0.00173258,0.00151815,0.0013123,0.00110645,0.0010121,0.000943485,0.000857714,0.00078052,0.000754788,0.000694748,
0.000626131,0.000557514,0.000514628,0.000463165,0.000403126,0.000368817,0.000334508,0.000308777,0.000274468,
0.00024016,0.000214428,0.000205851,0.000162966,0.000154388,0.000137234,0.00012008,0.00012008,0.00012008,
0.00012008,0.000128657,0.000154388,0.000197274,0.000223006,0.000291623,0.000368817,0.000463165,0.000557514,
0.00066044,0.000789097,0.000986371,0.00114934,0.00159535,0.00189555,0.00226436,0.00269322,0.00320785,
0.00404841,0.00481177,0.00553225,0.00645001,0.00747069,0.00854283,0.00982082,0.0111074,0.0125741,0.0140665,
0.0158763,0.0174888,0.0192471,0.0213142,0.0236643,0.0263318,0.0292566,0.0322072,0.0349261,0.0378766,0.0411703,
0.044584,0.0486753,0.0531182,0.0577756,0.0636338,0.0717135,0.0807109,0.0911578,0.102497,0.11441,0.127216,
0.142157,0.157674,0.17843,0.195619,0.212224,0.227491,0.26174,0.275215,0.284521,0.290362,0.293364,0.294513,
0.29423,0.292652,0.290636,0.286056,0.27874,0.270883,0.261431,0.249372,0.232235,0.209334,0.170342,0.128365,
0.103715,0.0856685,0.0721595,0.060709,0.0520718,0.0431173,0.0354665,0.0292995,0.0237673,0.0192643,0.0155504,
0.0124025,0.0100438,0.00831125,0.00698179,0.00584103,0.00507767,0.00426284,0.00340512,0.00289907,0.00247022,
0.00216144,0.0019127,0.00175831,0.00159535,0.00146669,0.00140665,0.0014238,0.00150958,0.00164681,0.00181835,
0.00198132,0.00217859,0.0024016,0.00267607,0.00291623,0.00312208,0.00339655,0.00378252,0.00400552,0.00415134,
0.00435719,0.00453731,0.004726,0.00495759,0.00524921,0.00553225,0.00586676,0.0065272,0.00719622,0.00801105,
0.00872295,0.00955493,0.0102239,0.0109444,0.0115363,0.0120337,0.0125398,0.0127799,0.0128228,0.0127027,
0.012514,0.0122138,0.011948,0.0115534,0.0110474,0.0104041,0.0096064,0.00862002,0.0076165,0.00649289,0.0054036,
0.0043143,0.00315639,0.00247879,0.0019899,0.00168112,0.00134661,0.00111503,0.0010121,0.000943485,0.000814828,
0.000771942,0.000746211,0.000677594,0.000643285,0.000574668,0.00054036,0.000506051,0.000463165,0.000403126,
0.000368817,0.000334508,0.000308777,0.000274468,0.00024016,0.000214428,0.000205851,0.000162966,0.000154388,
0.000128657,0.00012008,0.00012008,0.000111503,0.000111503,0.000111503,0.000111503,0.00012008,0.00012008,
0.000154388,0.000205851,0.00024016,0.000325931,0.000403126,0.000531783,0.000626131,0.000754788,0.0009006,
0.00104641,0.00136377,0.00173258,0.0019899,0.00235871,0.00285619,0.00335366,0.00419422,0.00501763,0.00568664,
0.00663013,0.00764223,0.00866291,0.00983798,0.0110474,0.0124111,0.0138607,0.0155761,0.0174202,0.0194272,
0.021743,0.0244963,0.0273868,0.0305518,0.0337853,0.0369675,0.0405184,0.0442752,0.048641,0.0535814,0.0586333,
0.0652634,0.0740036,0.0831982,0.094237,0.106519,0.119128,0.134996,0.151781,0.172838,0.193157,0.210715,
0.227895,0.24528,0.280695,0.292832,0.301495,0.305981,0.307422,0.307285,0.305483,0.301615,0.29622,0.28899,
0.279589,0.269648,0.259098,0.247202,0.230596,0.20749,0.165033,0.124386,0.100438,0.0826322,0.0692089,0.0581873,
0.0493957,0.0408358,0.0335967,0.0274726,0.0223434,0.0180635,0.0144096,0.0116306,0.00956351,0.00801105,
0.00675879,0.00560945,0.00486324,0.00405699,0.00321643,0.00277899,0.00235871,0.00208424,0.00188697,0.00173258,
0.00154388,0.00140665,0.00133803,0.00133803,0.0014238,0.00156104,0.00174116,0.00188697,0.00208424,0.00229867,
0.00253883,0.0028133,0.00298484,0.0031907,0.00342228,0.00378252,0.00396264,0.00409987,0.00428857,0.004503,
0.00469169,0.00494043,0.00525779,0.00554083,0.00594396,0.00656151,0.00716191,0.00784808,0.00831982,0.00879157,
0.00918612,0.00956351,0.00984655,0.0100438,0.0101382,0.0101039,0.00997521,0.0098294,0.00956351,0.00918612,
0.00883445,0.00837129,0.00787381,0.00707614,0.00629562,0.00553225,0.00464881,0.00365386,0.0028133,0.00218717,
0.00183551,0.00144954,0.00110645,0.000977794,0.000857714,0.00078052,0.000737634,0.00066044,0.000626131,
0.000557514,0.00054036,0.000506051,0.000471743,0.000454588,0.000377394,0.000368817,0.000334508,0.000308777,
0.000274468,0.00024016,0.000223006,0.000205851,0.00018012,0.000154388,0.000137234,0.00012008,0.00012008,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.00012008,0.000137234,
0.00018012,0.00024016,0.000308777,0.000377394,0.000497474,0.000574668,0.00072048,0.000806251,0.000994948,
0.00114934,0.00156104,0.00186124,0.00212713,0.00250452,0.00293338,0.00354236,0.0043143,0.0051034,0.00575526,
0.00674163,0.00765938,0.00858572,0.00967501,0.0108072,0.0120251,0.0136119,0.0154989,0.0176003,0.0199676,
0.0227123,0.0259802,0.0292566,0.0327304,0.0362899,0.0403211,0.0444467,0.0492928,0.0545249,0.0599885,0.0672705,
0.0762593,0.0857542,0.0973848,0.110431,0.124274,0.142329,0.162271,0.186896,0.205731,0.224738,0.244294,
0.263644,0.29785,0.308949,0.316702,0.31979,0.32033,0.319353,0.316428,0.310389,0.303528,0.29393,0.282428,
0.27048,0.258669,0.245692,0.228606,0.205139,0.160272,0.120637,0.0975821,0.0800933,0.0663956,0.0559916,
0.0467711,0.0385199,0.0317869,0.0260488,0.0208939,0.0169913,0.0135948,0.0110645,0.00914323,0.00776231,
0.0065272,0.00553225,0.00471743,0.00391118,0.00310492,0.00267607,0.00229867,0.00205851,0.00186124,0.00168112,
0.00150958,0.00134661,0.0013123,0.00130373,0.00133803,0.00148384,0.00164681,0.00184408,0.0019899,0.00217859,
0.00239302,0.00263318,0.00288192,0.00304488,0.003225,0.00347374,0.00377394,0.0039026,0.00408272,0.00425426,
0.00444296,0.00464881,0.00494043,0.00526636,0.00555799,0.0059268,0.00648432,0.00693033,0.00733345,0.00763365,
0.00786524,0.00797674,0.00807109,0.00809682,0.00807966,0.00803678,0.00789954,0.00767654,0.00740207,0.00705041,
0.00679309,0.00623558,0.0057038,0.00526636,0.00457161,0.00384256,0.00298484,0.0024016,0.00198132,0.00162108,
0.00121795,0.00100353,0.000857714,0.000771942,0.000711902,0.000634708,0.000574668,0.00054036,0.000497474,
0.000463165,0.000454588,0.000377394,0.000368817,0.000343086,0.000317354,0.000308777,0.000274468,0.000248737,
0.00024016,0.000205851,0.000205851,0.000162966,0.000154388,0.000128657,0.00012008,0.00012008,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.00012008,0.000137234,
0.000171543,0.00024016,0.000308777,0.000377394,0.000497474,0.000574668,0.000703325,0.00078052,0.000952062,
0.00110645,0.0014238,0.00173258,0.00198132,0.00228152,0.00261603,0.00303631,0.00374821,0.00443438,0.00518917,
0.00578957,0.00669017,0.007505,0.0084056,0.00940054,0.0105241,0.0119136,0.0135776,0.0158248,0.018235,
0.0210054,0.0243848,0.0280129,0.0319327,0.0358524,0.0404069,0.0449442,0.0502963,0.0556313,0.0617039,0.0693204,
0.0782407,0.0880443,0.100087,0.113578,0.129626,0.14998,0.176921,0.199127,0.218794,0.239722,0.261303,0.281768,
0.313692,0.324971,0.331712,0.333608,0.33257,0.330563,0.326798,0.320588,0.312002,0.301058,0.287497,0.273053,
0.259227,0.244774,0.22672,0.201383,0.154534,0.117087,0.0944343,0.0777432,0.0638911,0.0542332,0.044481,
0.0363242,0.0298399,0.0243505,0.019796,0.0160478,0.0128657,0.0106013,0.00889449,0.00757361,0.00638139,
0.00548079,0.00468312,0.00386829,0.00306204,0.0026246,0.0022901,0.00199847,0.00184408,0.00163823,0.00146669,
0.00132946,0.00121795,0.0012008,0.00130373,0.00140665,0.00156104,0.00175831,0.00190412,0.00208424,0.00229867,
0.0025131,0.00275326,0.00291623,0.00307919,0.00325074,0.00343943,0.00374821,0.00386829,0.00404841,0.00419422,
0.00439149,0.0046145,0.0049147,0.00524921,0.00549795,0.00573811,0.00610692,0.00637281,0.00657009,0.00667301,
0.00665586,0.00656151,0.00649289,0.00631277,0.00616696,0.00596969,0.00577241,0.00557514,0.00535213,0.00504336,
0.00460592,0.0040913,0.00342228,0.0029248,0.00247879,0.00208424,0.00176689,0.00140665,0.00107214,0.000943485,
0.00078052,0.00072048,0.000626131,0.000557514,0.00054036,0.00048032,0.000454588,0.000394548,0.000368817,
0.000343086,0.000325931,0.000308777,0.000291623,0.000274468,0.00024016,0.00024016,0.000214428,0.000205851,
0.000197274,0.000162966,0.000154388,0.000137234,0.00012008,0.00012008,0.00012008,0.000111503,0.000111503,
0.000111503,0.000111503,0.000111503,0.000111503,0.000111503,0.00012008,0.00012008,0.000154388,0.000197274,
0.00024016,0.000308777,0.000377394,0.000497474,0.000574668,0.000694748,0.00078052,0.000943485,0.00104641,
0.00132946,0.00162108,0.00186124,0.00208424,0.00235871,0.00274468,0.00309635,0.0038254,0.00451157,0.00524921,
0.00577241,0.00657867,0.00741065,0.00827694,0.00925473,0.0104984,0.0119737,0.0140494,0.0166482,0.0196931,
0.0230811,0.0269494,0.0313151,0.0356209,0.0405527,0.045699,0.0516601,0.057038,0.0633507,0.0711216,0.0799046,
0.0902229,0.102445,0.116392,0.135382,0.160255,0.190936,0.21267,0.232672,0.255659,0.278517,0.298433,0.331189,
0.341036,0.346062,0.346208,0.343875,0.340847,0.337013,0.330451,0.320931,0.308168,0.292944,0.276681,0.260067,
0.243273,0.223735,0.195619,0.146772,0.113132,0.0913379,0.0753244,0.0617554,0.0519689,0.0422853,0.0341799,
0.0280301,0.0228066,0.0185266,0.0151043,0.0123253,0.0102668,0.0087058,0.00747926,0.00636424,0.00548079,
0.00464881,0.00385971,0.00304488,0.00261603,0.00226436,0.00198132,0.00180978,0.00160392,0.0014238,0.00130373,
0.00114934,0.00114934,0.00119222,0.00132946,0.00149242,0.00165539,0.00184408,0.0019899,0.00216144,0.00235871,
0.00257314,0.0028133,0.0029248,0.00307062,0.00321643,0.00336224,0.00357667,0.0037911,0.00392833,0.0040913,
0.00427141,0.00452015,0.00479462,0.00505193,0.00528352,0.00548079,0.00560945,0.00563518,0.00563518,0.00556656,
0.00544648,0.00528352,0.00505193,0.00482035,0.00460592,0.00434861,0.00407414,0.00378252,0.0033022,0.00296769,
0.00265034,0.00233298,0.00204994,0.00180978,0.00150958,0.00114934,0.000994948,0.00084056,0.000746211,
0.000643285,0.000574668,0.00054036,0.00048032,0.000454588,0.000377394,0.000368817,0.000334508,0.000308777,
0.0003002,0.000274468,0.000248737,0.00024016,0.00024016,0.000214428,0.000205851,0.000205851,0.00018012,
0.000162966,0.000154388,0.000137234,0.000128657,0.00012008,0.00012008,0.00012008,0.00012008,0.000111503,
0.000111503,0.000111503,0.000111503,0.00012008,0.00012008,0.000128657,0.000154388,0.000162966,0.000205851,
0.000248737,0.000334508,0.000394548,0.000506051,0.000574668,0.000703325,0.00078052,0.000943485,0.00104641,
0.00124369,0.00153531,0.00176689,0.00195559,0.00217859,0.00247879,0.00283903,0.00318212,0.00388544,0.00454588,
0.00526636,0.00578957,0.0066044,0.00746211,0.00836271,0.00951205,0.0109444,0.0128657,0.0154646,0.0185095,
0.0221547,0.0262889,0.0306633,0.0354064,0.0408272,0.0463594,0.0527408,0.0585304,0.0649289,0.0727084,0.0813542,
0.0920327,0.104607,0.119462,0.142115,0.175025,0.204024,0.225665,0.248703,0.27422,0.297009,0.31605,0.349415,
0.357504,0.360197,0.358293,0.354965,0.35174,0.34746,0.340349,0.330306,0.316445,0.299677,0.280644,0.260694,
0.241249,0.218829,0.187959,0.138735,0.108647,0.0878299,0.0724168,0.0595168,0.0495759,0.0399266,0.0322672,
0.0262546,0.0214085,0.0176174,0.0143324,0.0119222,0.010061,0.00862002,0.00747069,0.00636424,0.00548079,
0.00464881,0.0038254,0.003002,0.00256456,0.00220432,0.00194701,0.00176689,0.00156104,0.00136377,0.00121795,
0.00114076,0.00114076,0.00114934,0.00121795,0.00137234,0.00156104,0.00174116,0.00188697,0.00205851,0.00226436,
0.0024016,0.00260745,0.00279615,0.00290765,0.00302773,0.00313923,0.00326789,0.00337939,0.00359382,0.00381683,
0.00395406,0.00409987,0.0043143,0.00453731,0.00474316,0.0049147,0.00499189,0.00500047,0.0049147,0.00470885,
0.00446869,0.00410845,0.00384256,0.00337939,0.00310492,0.0029248,0.00275326,0.00250452,0.00229867,0.00208424,
0.00188697,0.00173258,0.00148384,0.00114934,0.00102926,0.000909177,0.000771942,0.000694748,0.000608977,
0.00054036,0.000497474,0.000454588,0.000377394,0.000368817,0.000334508,0.000308777,0.0003002,0.000274468,
0.000248737,0.00024016,0.000231583,0.000214428,0.000205851,0.000205851,0.000197274,0.000162966,0.000162966,
0.000154388,0.000154388,0.000145811,0.000137234,0.000137234,0.000128657,0.00012008,0.00012008,0.00012008,
0.00012008,0.00012008,0.00012008,0.000137234,0.000145811,0.000154388,0.000162966,0.000205851,0.00024016,
0.000291623,0.000343086,0.000446011,0.000514628,0.000591823,0.00072048,0.00078052,0.000934908,0.00103783,
0.00118365,0.00147527,0.00169827,0.00187839,0.00205851,0.00229867,0.00256456,0.00289907,0.00331078,0.00403983,
0.00470885,0.00536071,0.00596111,0.00688744,0.00783093,0.00886018,0.0102411,0.0119994,0.0144439,0.017849,
0.0215029,0.0258858,0.0302945,0.035355,0.0411445,0.0471828,0.0538387,0.0596712,0.0663356,0.0744753,0.0827865,
0.0937824,0.107549,0.124506,0.15179,0.191056,0.21822,0.242227,0.268344,0.29441,0.316762,0.335263,0.367367,
0.375541,0.376905,0.373929,0.369597,0.365103,0.358447,0.350882,0.340332,0.325485,0.306564,0.284847,0.260925,
0.237587,0.212902,0.176715,0.131136,0.104126,0.0851109,0.0702382,0.0576469,0.0470799,0.0377051,0.0303802,
0.0248308,0.0202935,0.0167769,0.0138263,0.0116478,0.00987229,0.00855998,0.00746211,0.00632993,0.00547221,
0.00463165,0.00377394,0.00297627,0.0025131,0.00216144,0.00190412,0.00173258,0.00150958,0.00132946,0.00114934,
0.00110645,0.00109787,0.00110645,0.00114934,0.00130373,0.00143238,0.00162108,0.00178404,0.0019127,0.00208424,
0.00226436,0.00239302,0.00256456,0.00271895,0.00284761,0.0029248,0.00301915,0.00310492,0.00321643,0.00333651,
0.00348232,0.00368817,0.00385971,0.0040141,0.00409987,0.00421995,0.00423711,0.00417707,0.00404841,0.0038254,
0.00339655,0.00307919,0.00284761,0.00256456,0.00234156,0.00216144,0.00198132,0.00184408,0.0016897,0.00150958,
0.00132088,0.00112361,0.0010121,0.000917754,0.00078052,0.000737634,0.000643285,0.000557514,0.000506051,
0.000454588,0.000394548,0.000368817,0.000334508,0.000317354,0.0003002,0.000274468,0.00024016,0.00024016,
0.000223006,0.000205851,0.000205851,0.000205851,0.000197274,0.000197274,0.000162966,0.000162966,0.000162966,
0.000162966,0.000154388,0.000154388,0.000154388,0.000154388,0.000154388,0.000154388,0.000154388,0.000154388,
0.000154388,0.000154388,0.000154388,0.000162966,0.000162966,0.000197274,0.000205851,0.000231583,0.000248737,
0.000308777,0.000368817,0.000454588,0.00054036,0.000608977,0.00072048,0.00078052,0.000917754,0.00102926,
0.00114934,0.00140665,0.00162108,0.00180978,0.00197274,0.00216144,0.00236729,0.00267607,0.00299342,0.00354236,
0.00426284,0.00501763,0.00561803,0.00651863,0.00747926,0.00855998,0.00986371,0.0116906,0.0140494,0.0174116,
0.0210655,0.0255256,0.0301143,0.035355,0.0415734,0.0480406,0.0546621,0.060709,0.0681368,0.0763451,0.0848879,
0.0964928,0.111306,0.132337,0.168901,0.208476,0.236583,0.263807,0.290799,0.315484,0.337279,0.354682,0.385122,
0.392112,0.393862,0.391503,0.386735,0.380353,0.371845,0.362513,0.351345,0.3354,0.314335,0.289736,0.261723,
0.233727,0.205371,0.162254,0.123965,0.100773,0.0828552,0.0684198,0.0563518,0.0456304,0.0362127,0.0291537,
0.0236129,0.0194787,0.0161851,0.0133975,0.0114419,0.00983798,0.00849137,0.00740207,0.00629562,0.0054036,
0.00453731,0.00362813,0.00290765,0.00245306,0.00208424,0.00186124,0.00164681,0.00144954,0.00124369,0.00113218,
0.00105499,0.00104641,0.00104641,0.00108072,0.00114076,0.0013123,0.00146669,0.00162966,0.00180978,0.0019127,
0.00207567,0.00219575,0.00234156,0.00247879,0.00260745,0.00269322,0.0028133,0.00289907,0.00293338,0.003002,
0.00307919,0.00316496,0.00325074,0.00334508,0.00340512,0.00342228,0.0034137,0.00331935,0.00315639,0.00298484,
0.00279615,0.00250452,0.00227294,0.00201563,0.00186982,0.00170685,0.00150958,0.0013123,0.00111503,0.00102926,
0.000952062,0.000857714,0.00078052,0.000746211,0.00066044,0.000574668,0.00054036,0.000471743,0.000446011,
0.000377394,0.000343086,0.000317354,0.000308777,0.000274468,0.000248737,0.00024016,0.000223006,0.000214428,
0.000205851,0.000205851,0.000197274,0.000197274,0.00018012,0.00018012,0.000171543,0.000162966,0.000162966,
0.00018012,0.00018012,0.000188697,0.000197274,0.000197274,0.000197274,0.000197274,0.000197274,0.000197274,
0.000205851,0.000205851,0.000205851,0.000205851,0.000214428,0.000223006,0.00024016,0.000248737,0.0003002,
0.000334508,0.000377394,0.000463165,0.00054036,0.000626131,0.00072048,0.00078052,0.000917754,0.00102926,
0.00114076,0.00134661,0.00156104,0.00174974,0.00188697,0.00205851,0.00228152,0.0025131,0.00286476,0.00321643,
0.00399695,0.00471743,0.00548079,0.0063042,0.00737634,0.00848279,0.00985513,0.0116821,0.0140065,0.0173516,
0.0208939,0.0253111,0.0300286,0.0355008,0.0420022,0.0489497,0.0555455,0.0622271,0.070324,0.0787467,0.0883102,
0.100773,0.117327,0.146009,0.193646,0.227474,0.257872,0.286965,0.311899,0.335821,0.356329,0.372754,0.398562,
0.406659,0.409807,0.408246,0.402714,0.39448,0.384796,0.374315,0.361638,0.343815,0.320313,0.293047,0.261457,
0.229224,0.196622,0.150692,0.118287,0.0978823,0.0813284,0.0675107,0.055597,0.0446354,0.035192,0.0282874,
0.0228581,0.0187582,0.0156704,0.0130544,0.0112189,0.00973505,0.00841417,0.00729057,0.00620127,0.00530067,
0.00443438,0.00342228,0.00284761,0.00235871,0.00201563,0.00180978,0.00159535,0.00136377,0.00114934,0.00107214,
0.00103783,0.00102926,0.00102068,0.00102926,0.00104641,0.00114076,0.00130373,0.00145811,0.00162108,0.00176689,
0.00188697,0.0019899,0.00212713,0.00226436,0.00234156,0.00244448,0.00253026,0.00260745,0.00266749,0.00275326,
0.0028133,0.00286476,0.00289907,0.00291623,0.0029248,0.00291623,0.00289907,0.0028133,0.00265034,0.00247879,
0.0022901,0.00208424,0.00188697,0.00173258,0.00149242,0.00123511,0.00104641,0.000986371,0.0009006,0.000789097,
0.000763365,0.00072048,0.000643285,0.000574668,0.00054036,0.000497474,0.000454588,0.000394548,0.000368817,
0.000334508,0.000308777,0.0003002,0.000274468,0.00024016,0.00024016,0.000214428,0.000205851,0.000205851,
0.000205851,0.000197274,0.000197274,0.00018012,0.000188697,0.000197274,0.000197274,0.000205851,0.000205851,
0.000205851,0.000205851,0.000205851,0.000214428,0.000223006,0.000223006,0.000231583,0.00024016,0.00024016,
0.00024016,0.00024016,0.00024016,0.00024016,0.000248737,0.000265891,0.000274468,0.000308777,0.000325931,
0.000368817,0.000411703,0.000497474,0.000548937,0.000634708,0.000729057,0.00078052,0.000917754,0.00100353,
0.00111503,0.00132088,0.00151815,0.0016897,0.00184408,0.0019899,0.00216144,0.00239302,0.00275326,0.00308777,
0.00384256,0.00460592,0.0054036,0.00628704,0.00737634,0.00855998,0.0100181,0.0118965,0.0142724,0.0174888,
0.0209883,0.025354,0.0300629,0.0357238,0.0424568,0.0497646,0.056652,0.0639511,0.0730086,0.0824177,0.0937138,
0.108475,0.130081,0.172589,0.215758,0.248917,0.28037,0.307113,0.331515,0.353189,0.371965,0.387189,0.41003,
0.41859,0.423153,0.422613,0.416909,0.406608,0.395269,0.382772,0.367873,0.348558,0.32256,0.292618,0.258163,
0.223194,0.185892,0.140013,0.113278,0.0947602,0.0796559,0.0661812,0.0549023,0.0439921,0.0346431,0.0276355,
0.0223606,0.0183036,0.0151386,0.0127113,0.0109444,0.00946916,0.00824263,0.00709329,0.00603831,0.00523205,
0.00425426,0.00327647,0.00271895,0.0022901,0.00194701,0.00174116,0.00151815,0.0013123,0.00114076,0.00104641,
0.000994948,0.000986371,0.000977794,0.000986371,0.000994948,0.00104641,0.00110645,0.00121795,0.00140665,
0.00156104,0.00173258,0.00183551,0.0019127,0.0019899,0.00208424,0.00216144,0.00227294,0.00229867,0.00235871,
0.0024016,0.00247022,0.00250452,0.00253883,0.00255599,0.00253883,0.00249595,0.00241875,0.00233298,0.00220432,
0.00208424,0.00192128,0.00178404,0.00160392,0.00134661,0.00112361,0.000994948,0.0009006,0.00078052,0.000746211,
0.00066044,0.000626131,0.000557514,0.00054036,0.000497474,0.000463165,0.000403126,0.000377394,0.000343086,
0.000334508,0.000308777,0.000291623,0.000257314,0.00024016,0.00024016,0.000214428,0.000205851,0.000205851,
0.000205851,0.000197274,0.000197274,0.000197274,0.000197274,0.000205851,0.000205851,0.000205851,0.000214428,
0.000223006,0.00024016,0.00024016,0.000248737,0.000248737,0.000274468,0.000274468,0.000274468,0.000291623,
0.000291623,0.000291623,0.0003002,0.0003002,0.000308777,0.000308777,0.000308777,0.000317354,0.000334508,
0.000343086,0.000377394,0.000454588,0.000506051,0.000557514,0.000643285,0.000737634,0.00078052,0.000909177,
0.000994948,0.00109787,0.00130373,0.00147527,0.00164681,0.00180978,0.00194701,0.00212713,0.00235871,0.00269322,
0.00307062,0.00381683,0.00458877,0.0054036,0.0063042,0.00747069,0.00868006,0.0102239,0.0121281,0.014624,
0.0178404,0.0213142,0.0256199,0.0302687,0.036084,0.0431173,0.0508453,0.0581444,0.0665929,0.0766625,0.0874353,
0.101167,0.118656,0.15082,0.200533,0.236618,0.270377,0.300354,0.326,0.348832,0.367273,0.384316,0.397902,
0.419937,0.429826,0.435401,0.434895,0.427948,0.416,0.40141,0.385894,0.368011,0.346559,0.319172,0.2879,
0.25065,0.214111,0.167649,0.128623,0.107214,0.0910978,0.0773658,0.0644829,0.0540789,0.0431687,0.0340598,
0.0270523,0.0218031,0.0177976,0.0144439,0.0121795,0.010507,0.00913465,0.00806251,0.00692175,0.00579815,
0.0050262,0.00405699,0.00312208,0.00259887,0.00216144,0.00188697,0.00167254,0.00144954,0.00120938,0.00107214,
0.0010121,0.000969217,0.000943485,0.000917754,0.000917754,0.000943485,0.000969217,0.00100353,0.00105499,
0.00114934,0.00132088,0.00146669,0.00160392,0.00173258,0.00180978,0.00187839,0.00193843,0.0019899,0.00204994,
0.00208424,0.00210998,0.00216144,0.00217859,0.00219575,0.00219575,0.00216144,0.00216144,0.00208424,0.0019899,
0.00188697,0.0018012,0.00164681,0.00147527,0.00124369,0.00105499,0.000977794,0.000831982,0.000763365,
0.00066044,0.000617554,0.000557514,0.000523205,0.00048032,0.000454588,0.000403126,0.000377394,0.000368817,
0.000334508,0.000317354,0.000308777,0.000291623,0.000265891,0.00024016,0.00024016,0.000214428,0.000205851,
0.000205851,0.000205851,0.000205851,0.000205851,0.000205851,0.000205851,0.000205851,0.000214428,0.000223006,
0.00024016,0.000248737,0.000274468,0.000291623,0.0003002,0.000308777,0.000317354,0.000317354,0.000334508,
0.000334508,0.000334508,0.000334508,0.000334508,0.000343086,0.000343086,0.000343086,0.000343086,0.000343086,
0.00036024,0.000368817,0.000377394,0.00042028,0.000463165,0.000531783,0.000557514,0.000643285,0.000737634,
0.00078052,0.000874868,0.000994948,0.00105499,0.00121795,0.00143238,0.00162108,0.0018012,0.00193843,0.00212713,
0.00235871,0.00275326,0.00312208,0.00388544,0.00469169,0.00553225,0.00649289,0.00762508,0.00886018,0.0104727,
0.012514,0.0151043,0.0181492,0.0215543,0.0259973,0.0308177,0.0368388,0.044258,0.0523806,0.0599971,0.0698179,
0.0807366,0.093851,0.110671,0.136025,0.184571,0.22292,0.256619,0.289959,0.318443,0.34306,0.36331,0.380439,
0.394986,0.407937,0.431387,0.442049,0.448155,0.446329,0.436782,0.421249,0.401882,0.381726,0.359888,0.336541,
0.308768,0.276235,0.238144,0.198544,0.147029,0.117404,0.100387,0.086226,0.0741665,0.0622443,0.0522691,
0.0418221,0.0330048,0.0262546,0.0209111,0.0170256,0.0138092,0.0116392,0.0100524,0.00876584,0.00776231,
0.00666444,0.00560945,0.00478604,0.00385971,0.00299342,0.00247879,0.00208424,0.00185266,0.00162108,0.00138092,
0.00114934,0.00104641,0.000994948,0.000934908,0.000857714,0.00084056,0.000814828,0.00084056,0.000874868,
0.000934908,0.000977794,0.00102926,0.00107214,0.00114934,0.00132088,0.00144954,0.00156104,0.00163823,
0.00173258,0.00177547,0.00183551,0.00185266,0.00187839,0.00188697,0.00190412,0.0019127,0.0019127,0.00188697,
0.00186124,0.00180978,0.00173258,0.00162108,0.00148384,0.00132088,0.00114076,0.00102926,0.000943485,0.000806251,
0.000746211,0.000643285,0.000574668,0.00054036,0.00048032,0.000454588,0.000394548,0.000377394,0.00036024,
0.000334508,0.000325931,0.000308777,0.0003002,0.000291623,0.000274468,0.00024016,0.00024016,0.000223006,
0.000214428,0.000205851,0.000205851,0.000205851,0.000205851,0.000205851,0.000205851,0.000214428,0.00024016,
0.00024016,0.000274468,0.0003002,0.000308777,0.000334508,0.000343086,0.000351663,0.000368817,0.000368817,
0.000377394,0.000377394,0.000377394,0.000394548,0.000394548,0.000394548,0.000394548,0.000394548,0.000394548,
0.000394548,0.000394548,0.000394548,0.000394548,0.000446011,0.000454588,0.000497474,0.00054036,0.000574668,
0.000643285,0.000737634,0.00078052,0.000857714,0.000977794,0.00104641,0.00115791,0.00140665,0.00162108,
0.00179262,0.00194701,0.00216144,0.00244448,0.00284761,0.0033022,0.00408272,0.00488897,0.00561803,0.00668159,
0.00785666,0.00910034,0.0107643,0.0128228,0.015516,0.018458,0.0220089,0.0264176,0.0317869,0.0381768,0.0459563,
0.0544391,0.062493,0.0732402,0.0855055,0.10109,0.121392,0.159595,0.209316,0.243042,0.276707,0.307182,
0.335023,0.358379,0.377797,0.392473,0.405827,0.419122,0.447186,0.456844,0.460189,0.454931,0.441474,0.421575,
0.397216,0.371682,0.346027,0.320348,0.292326,0.257906,0.219798,0.173404,0.129506,0.108535,0.0936967,0.0814828,
0.0702296,0.0592938,0.0496531,0.0394548,0.0313151,0.0249595,0.019959,0.016125,0.0130287,0.0110474,0.00958924,
0.00837986,0.00737634,0.0063042,0.00542075,0.00453731,0.00359382,0.00289907,0.00237587,0.00204994,0.00180978,
0.00157819,0.00133803,0.00112361,0.00102926,0.000943485,0.000874868,0.000806251,0.00078052,0.00078052,
0.00078052,0.00078052,0.000806251,0.000857714,0.000917754,0.000977794,0.0010121,0.00104641,0.00114076,
0.00121795,0.00133803,0.0014238,0.00149242,0.00154388,0.00159535,0.00162108,0.00162966,0.00164681,0.00164681,
0.00164681,0.00162108,0.00156104,0.00149242,0.00138092,0.00126942,0.00114076,0.00104641,0.000977794,0.000874868,
0.00078052,0.00072048,0.000626131,0.000548937,0.000506051,0.000454588,0.000394548,0.000368817,0.000343086,
0.000334508,0.000317354,0.000308777,0.000308777,0.0003002,0.000274468,0.000265891,0.000248737,0.00024016,
0.00024016,0.000223006,0.000214428,0.000205851,0.000205851,0.000214428,0.000214428,0.00024016,0.00024016,
0.000248737,0.000291623,0.000308777,0.000334508,0.000343086,0.000368817,0.000385971,0.000411703,0.000454588,
0.000454588,0.000463165,0.000463165,0.000471743,0.000471743,0.000471743,0.000471743,0.000471743,0.000471743,
0.000471743,0.000463165,0.000463165,0.000463165,0.000463165,0.000463165,0.000463165,0.00048032,0.000506051,
0.00054036,0.000574668,0.000643285,0.000737634,0.00078052,0.000857714,0.000969217,0.00104641,0.00114934,
0.00140665,0.0016125,0.00180978,0.00198132,0.00219575,0.00253883,0.00293338,0.00356809,0.00433145,0.00513771,
0.00584103,0.00692175,0.00807966,0.00940054,0.0110474,0.0131659,0.0159792,0.0190069,0.0227637,0.0273268,
0.0331678,0.0402354,0.048538,0.0566263,0.0656065,0.0773143,0.0910892,0.109136,0.136359,0.18814,0.226479,
0.260393,0.293175,0.323161,0.35023,0.373123,0.391109,0.405107,0.419534,0.434038,0.465704,0.471786,0.470516,
0.459846,0.442151,0.418333,0.389522,0.358988,0.329963,0.302233,0.271775,0.236583,0.19772,0.145082,0.116049,
0.0996406,0.0872123,0.0765338,0.0654521,0.0557686,0.0459134,0.03647,0.0291708,0.0232526,0.0185609,0.0149242,
0.0122825,0.0104727,0.00908319,0.00803678,0.00698179,0.00598684,0.00524921,0.00429715,0.00335366,0.00279615,
0.00229867,0.0019899,0.00177547,0.00153531,0.0013123,0.0010893,0.000994948,0.000934908,0.000823405,0.00078052,
0.000763365,0.000746211,0.000746211,0.000746211,0.000763365,0.000771942,0.000789097,0.000831982,0.0009006,
0.000943485,0.000994948,0.00102926,0.00105499,0.00111503,0.00114934,0.00119222,0.00126942,0.0013123,0.00132088,
0.00132088,0.00132088,0.0013123,0.00123511,0.00114934,0.00112361,0.00104641,0.00102926,0.000969217,0.0009006,
0.000797674,0.000754788,0.00066044,0.0006004,0.00054036,0.00048032,0.000446011,0.000377394,0.000343086,
0.000334508,0.000317354,0.000308777,0.0003002,0.000291623,0.000274468,0.000274468,0.000265891,0.000248737,
0.00024016,0.00024016,0.00024016,0.000223006,0.000223006,0.000223006,0.000231583,0.00024016,0.00024016,
0.000274468,0.0003002,0.000317354,0.000343086,0.000368817,0.000394548,0.000454588,0.000463165,0.000497474,
0.000514628,0.00054036,0.00054036,0.00054036,0.00054036,0.00054036,0.000548937,0.000548937,0.00054036,
0.00054036,0.00054036,0.00054036,0.00054036,0.000531783,0.000514628,0.000506051,0.000506051,0.000506051,
0.000514628,0.00054036,0.000548937,0.000591823,0.000651863,0.000737634,0.00078052,0.000857714,0.00096064,
0.00104641,0.00114934,0.00140665,0.00162108,0.00181835,0.0019899,0.0022901,0.00265034,0.00308777,0.00388544,
0.00464023,0.00539502,0.00615839,0.00719622,0.00831982,0.00977794,0.0114591,0.0136462,0.0165196,0.0198561,
0.0238101,0.0289564,0.0349947,0.04298,0.0518488,0.0597912,0.0697922,0.0816372,0.0968445,0.117129,0.152707,
0.204488,0.239397,0.274065,0.306375,0.336687,0.363696,0.386906,0.404335,0.420983,0.437597,0.452933,0.481486,
0.482884,0.475079,0.459675,0.438849,0.412089,0.380559,0.347691,0.315416,0.284564,0.251456,0.21689,0.171912,
0.128263,0.106648,0.0923672,0.0810625,0.0708043,0.0606918,0.051926,0.0420194,0.0334165,0.0266492,0.0214428,
0.0173773,0.0139636,0.0115534,0.00986371,0.00867149,0.00765938,0.00667301,0.00569522,0.00496616,0.00407414,
0.00316496,0.00266749,0.00226436,0.00194701,0.00174116,0.00150958,0.00124369,0.00105499,0.000994948,0.0009006,
0.000806251,0.000763365,0.000737634,0.000711902,0.00066044,0.000669017,0.000703325,0.00072048,0.000746211,
0.000763365,0.00078052,0.000806251,0.00084056,0.000909177,0.000943485,0.000977794,0.000994948,0.00102068,
0.00102926,0.00104641,0.00104641,0.00104641,0.00102926,0.00102926,0.00100353,0.000994948,0.000943485,
0.000917754,0.00084056,0.00078052,0.000763365,0.000711902,0.000634708,0.000557514,0.000514628,0.000463165,
0.000377394,0.00036024,0.000334508,0.000308777,0.0003002,0.000291623,0.000274468,0.000274468,0.000274468,
0.000274468,0.000248737,0.000248737,0.00024016,0.00024016,0.00024016,0.00024016,0.00024016,0.00024016,
0.00024016,0.00024016,0.000274468,0.0003002,0.000317354,0.000343086,0.000377394,0.000454588,0.000471743,
0.000506051,0.00054036,0.000557514,0.000574668,0.0006004,0.000626131,0.000634708,0.000643285,0.000643285,
0.000643285,0.000643285,0.000643285,0.000643285,0.000626131,0.000626131,0.000608977,0.000574668,0.000574668,
0.000557514,0.000548937,0.00054036,0.00054036,0.00054036,0.000548937,0.000566091,0.000617554,0.00066044,
0.000737634,0.00078052,0.000857714,0.00096064,0.00104641,0.00114934,0.00140665,0.00162966,0.00184408,
0.00205851,0.00235871,0.0028133,0.0033022,0.00411703,0.00494043,0.00560945,0.00653578,0.00756504,0.00868006,
0.0100696,0.0118965,0.0142724,0.0173944,0.0208682,0.0255513,0.0310407,0.0380825,0.0464967,0.0553054,0.0636424,
0.0747069,0.0867663,0.103234,0.126264,0.170651,0.215518,0.249183,0.284469,0.317045,0.348386,0.37706,0.40135,
0.421644,0.439364,0.456004,0.471828,0.489849,0.483399,0.470216,0.452633,0.430238,0.401745,0.36964,0.336644,
0.303356,0.269571,0.235949,0.200422,0.150066,0.117241,0.0987057,0.0853768,0.0752215,0.0647831,0.0559573,
0.0467454,0.0376708,0.030243,0.0244963,0.0198561,0.0162194,0.0130887,0.0109702,0.00945201,0.00829409,
0.00726484,0.00628704,0.00547221,0.00469169,0.00385971,0.00303631,0.00255599,0.00216144,0.00190412,0.00173258,
0.00147527,0.0012008,0.00104641,0.000977794,0.000866291,0.00078052,0.000746211,0.000711902,0.000651863,
0.000634708,0.000626131,0.000634708,0.000643285,0.00066044,0.000677594,0.00072048,0.000746211,0.000763365,
0.000771942,0.00078052,0.000806251,0.00084056,0.000857714,0.000892022,0.000909177,0.000909177,0.0009006,
0.000874868,0.000849137,0.000814828,0.000797674,0.00078052,0.000763365,0.000746211,0.000677594,0.000634708,
0.000574668,0.00054036,0.00048032,0.000446011,0.000368817,0.000334508,0.000308777,0.0003002,0.000274468,
0.000274468,0.000248737,0.000248737,0.000248737,0.000248737,0.000248737,0.000248737,0.000248737,0.000248737,
0.00024016,0.00024016,0.00024016,0.00024016,0.000248737,0.000274468,0.0003002,0.000317354,0.000343086,
0.000377394,0.000454588,0.000497474,0.00054036,0.000557514,0.000608977,0.000643285,0.00066044,0.000711902,
0.00072048,0.000746211,0.000746211,0.000763365,0.000763365,0.000763365,0.000763365,0.000754788,0.000746211,
0.000746211,0.00072048,0.000694748,0.00066044,0.000643285,0.000626131,0.000626131,0.000591823,0.000574668,
0.000574668,0.000574668,0.000591823,0.000634708,0.00066044,0.000746211,0.00078052,0.000857714,0.000969217,
0.00104641,0.00117507,0.00143238,0.00165539,0.00187839,0.00208424,0.00246164,0.00290765,0.00356809,0.00443438,
0.00524921,0.00589249,0.00689602,0.0079167,0.00905746,0.0104984,0.0124369,0.0151644,0.0184065,0.0224978,
0.027524,0.0339826,0.0422081,0.0514543,0.0596712,0.0691918,0.0797331,0.0926588,0.110122,0.136891,0.186733,
0.224824,0.258532,0.293432,0.326403,0.358799,0.389891,0.417158,0.43921,0.456741,0.472763,0.486238,};
  const double linear_table_cis_pro[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000547345,0.000547345,0.000547345,0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,
0.000821018,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00109469,0.000821018,
0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000547345,0.000821018,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,
0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.000821018,0.000547345,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000547345,0.00109469,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,
0.00136836,0.00136836,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,
0.00136836,0.00136836,0.00136836,0.00136836,0.00109469,0.000821018,0.000821018,0.000821018,0.000821018,
0.000821018,0.00109469,0.00109469,0.000821018,0.000821018,0.000547345,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000547345,0.000821018,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,
0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,
0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,
0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,
0.000821018,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.000547345,0.000821018,0.000821018,
0.000821018,0.000821018,0.000821018,0.000821018,0.000547345,0.000273673,0.000273673,0.000821018,0.000547345,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.00136836,0.00136836,0.00136836,0.00136836,
0.00164204,0.00164204,0.00164204,0.00164204,0.00218938,0.00246305,0.00246305,0.00246305,0.00246305,0.00246305,
0.00246305,0.00218938,0.00191571,0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,
0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,
0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.000547345,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.000821018,0.00136836,0.00136836,
0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,
0.00136836,0.00136836,0.00136836,0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000821018,0.00136836,
0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00191571,0.00246305,0.00273673,0.00273673,0.00328407,
0.00328407,0.00328407,0.00328407,0.00328407,0.00328407,0.0030104,0.00273673,0.00246305,0.00246305,0.00218938,
0.00191571,0.00164204,0.00164204,0.00164204,0.00191571,0.00218938,0.00246305,0.00246305,0.00246305,0.00246305,
0.00246305,0.00246305,0.00246305,0.00246305,0.00246305,0.00191571,0.00164204,0.00164204,0.00136836,0.00136836,
0.00136836,0.00109469,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.000821018,0.00136836,0.00136836,
0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,
0.00164204,0.00136836,0.00136836,0.00164204,0.00136836,0.00136836,0.00136836,0.00109469,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000821018,0.00136836,0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00246305,
0.00273673,0.00328407,0.00355774,0.00383142,0.00437876,0.00492611,0.00547345,0.00547345,0.00465244,0.00437876,
0.00383142,0.00383142,0.00328407,0.00328407,0.0030104,0.00273673,0.00273673,0.00273673,0.00273673,0.00273673,
0.0030104,0.00328407,0.00328407,0.00355774,0.00355774,0.00355774,0.00355774,0.00328407,0.00328407,0.00328407,
0.00273673,0.00246305,0.00218938,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.000547345,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.000821018,0.00136836,
0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00164204,0.00164204,
0.00191571,0.00218938,0.00218938,0.00218938,0.00191571,0.00164204,0.00164204,0.00218938,0.00164204,0.00164204,
0.00136836,0.00136836,0.00136836,0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000821018,0.00136836,
0.00136836,0.00136836,0.00164204,0.00164204,0.00218938,0.00273673,0.00328407,0.00383142,0.00465244,0.00574713,
0.00629447,0.00684182,0.00766284,0.00821018,0.00766284,0.00738916,0.00629447,0.0060208,0.00574713,0.00547345,
0.00465244,0.00437876,0.00383142,0.00383142,0.00383142,0.00383142,0.00383142,0.00437876,0.00465244,0.00519978,
0.00547345,0.00547345,0.00547345,0.00547345,0.00492611,0.00437876,0.00383142,0.00355774,0.00328407,0.00273673,
0.00246305,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.000821018,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.000547345,
0.000821018,0.000821018,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,
0.00136836,0.00164204,0.00164204,0.00164204,0.00164204,0.00218938,0.00246305,0.00273673,0.00273673,0.0030104,
0.00328407,0.00328407,0.00273673,0.00273673,0.00246305,0.00328407,0.00246305,0.00218938,0.00164204,0.00164204,
0.00136836,0.00136836,0.000821018,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000821018,0.00136836,0.00136836,
0.00136836,0.00164204,0.00164204,0.00246305,0.0030104,0.00355774,0.00519978,0.0060208,0.00848385,0.0090312,
0.00985222,0.0109469,0.0112206,0.0112206,0.0112206,0.0106732,0.00985222,0.00957854,0.00848385,0.00848385,
0.00766284,0.00711549,0.00629447,0.00629447,0.00629447,0.00629447,0.00629447,0.00656814,0.00656814,0.00684182,
0.00738916,0.00738916,0.00711549,0.00656814,0.00629447,0.0060208,0.00574713,0.00465244,0.00383142,0.00328407,
0.00273673,0.00246305,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.000547345,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000547345,0.000821018,0.00109469,0.00136836,0.00136836,0.00136836,0.00136836,
0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00164204,
0.00164204,0.00191571,0.00246305,0.00273673,0.0030104,0.00328407,0.00383142,0.00383142,0.00437876,0.00465244,
0.00437876,0.00383142,0.00383142,0.00328407,0.00383142,0.00355774,0.00273673,0.00246305,0.00164204,0.00164204,
0.00136836,0.00136836,0.00136836,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.00136836,0.00136836,0.00136836,
0.00164204,0.00164204,0.00218938,0.00273673,0.00328407,0.00437876,0.0060208,0.00848385,0.00985222,0.0123153,
0.014231,0.0164204,0.0177887,0.0180624,0.0183361,0.0180624,0.0177887,0.0155993,0.014231,0.0128626,0.0125889,
0.0123153,0.0114943,0.0112206,0.0112206,0.0109469,0.0106732,0.0101259,0.00985222,0.00985222,0.00985222,
0.00957854,0.00957854,0.00930487,0.00875753,0.00848385,0.00848385,0.00656814,0.0060208,0.00547345,0.00410509,
0.00355774,0.00273673,0.00246305,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.000547345,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.000821018,
0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,
0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,0.00191571,0.00218938,0.00246305,0.00273673,
0.00328407,0.00355774,0.00437876,0.00547345,0.0060208,0.00629447,0.00711549,0.00738916,0.00684182,0.00629447,
0.00574713,0.00547345,0.0060208,0.00547345,0.00383142,0.00328407,0.00246305,0.00191571,0.00164204,0.00136836,
0.00136836,0.00136836,0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.00136836,0.00136836,0.00136836,
0.00164204,0.00164204,0.00246305,0.00328407,0.00383142,0.00574713,0.00848385,0.00985222,0.0128626,0.0177887,
0.0210728,0.0243569,0.0262726,0.0273673,0.0279146,0.0279146,0.0276409,0.0273673,0.0259989,0.0251779,0.0240832,
0.0224412,0.0221675,0.0218938,0.0210728,0.0202518,0.0186097,0.0180624,0.0172414,0.0155993,0.014231,0.0128626,
0.0125889,0.0120416,0.0112206,0.0109469,0.00985222,0.00957854,0.00848385,0.00766284,0.0060208,0.00547345,
0.00383142,0.00328407,0.00273673,0.00246305,0.00164204,0.00164204,0.00136836,0.00136836,0.00109469,0.000547345,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.000821018,0.00136836,0.00136836,0.00136836,
0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,
0.00164204,0.00191571,0.00218938,0.00246305,0.00246305,0.00246305,0.00273673,0.0030104,0.00328407,0.00383142,
0.00437876,0.00574713,0.00629447,0.00848385,0.00957854,0.00985222,0.0106732,0.0109469,0.0103996,0.00985222,
0.00875753,0.00848385,0.0090312,0.00738916,0.00574713,0.00383142,0.00328407,0.00246305,0.00191571,0.00164204,
0.00136836,0.00136836,0.00136836,0.000821018,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000821018,0.00136836,
0.00136836,0.00164204,0.00164204,0.00218938,0.00273673,0.00328407,0.00465244,0.00629447,0.00957854,0.0125889,
0.0177887,0.0240832,0.0279146,0.0306513,0.0333881,0.0363985,0.0380405,0.0385878,0.0385878,0.0383142,0.0374932,
0.0369458,0.0358511,0.0347564,0.0342091,0.0336617,0.0333881,0.032567,0.0314724,0.0303777,0.0279146,0.0268199,
0.0240832,0.0210728,0.0186097,0.0177887,0.0155993,0.0139573,0.0125889,0.0120416,0.0109469,0.00985222,
0.00875753,0.00766284,0.0060208,0.00547345,0.00383142,0.00328407,0.00246305,0.00191571,0.00164204,0.00136836,
0.00136836,0.00136836,0.000821018,0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.000547345,0.000821018,0.00136836,0.00136836,
0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00164204,0.00164204,0.00218938,0.00218938,0.00246305,
0.00246305,0.00246305,0.00246305,0.00273673,0.00273673,0.00273673,0.00328407,0.00328407,0.00328407,0.00355774,
0.00383142,0.00465244,0.00574713,0.00656814,0.00848385,0.00985222,0.0117679,0.01341,0.0155993,0.016694,
0.0172414,0.0161467,0.0145047,0.0125889,0.0112206,0.0125889,0.00985222,0.00848385,0.00574713,0.00383142,
0.00328407,0.00246305,0.00218938,0.00164204,0.00164204,0.00136836,0.00136836,0.000821018,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.00109469,0.00136836,0.00136836,0.00164204,0.00164204,0.00246305,0.00273673,
0.00383142,0.00547345,0.00821018,0.0106732,0.0155993,0.0218938,0.0279146,0.0331144,0.0407772,0.0473454,
0.0511768,0.0539135,0.0552819,0.0555556,0.0555556,0.0544609,0.0544609,0.0544609,0.0544609,0.0552819,0.0555556,
0.0555556,0.0544609,0.0528188,0.0500821,0.0462507,0.0410509,0.0353038,0.0314724,0.0279146,0.0257252,0.0218938,
0.0191571,0.0177887,0.0155993,0.0136836,0.0125889,0.0112206,0.00985222,0.00848385,0.00656814,0.00574713,
0.00437876,0.00355774,0.00273673,0.00246305,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.000821018,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.000547345,
0.000821018,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00191571,0.00246305,
0.00246305,0.00273673,0.00273673,0.00328407,0.00328407,0.00328407,0.00328407,0.00355774,0.00355774,0.00383142,
0.00383142,0.00437876,0.00465244,0.00547345,0.00574713,0.0060208,0.00738916,0.00848385,0.00985222,0.0125889,
0.0155993,0.0180624,0.0213465,0.0240832,0.0249042,0.0254516,0.0246305,0.0221675,0.0199781,0.0164204,0.0186097,
0.0139573,0.0106732,0.00848385,0.00574713,0.00383142,0.00328407,0.00246305,0.00218938,0.00164204,0.00164204,
0.00136836,0.00136836,0.00136836,0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.00136836,0.00136836,0.00136836,
0.00164204,0.00191571,0.00246305,0.00328407,0.00383142,0.00574713,0.00848385,0.0117679,0.0177887,0.0257252,
0.031746,0.0410509,0.0511768,0.0596606,0.0645868,0.0706076,0.0749863,0.076902,0.077723,0.076902,0.0758073,
0.076081,0.0771757,0.0788177,0.0799124,0.0801861,0.0801861,0.0796388,0.0758073,0.0697865,0.0634921,0.0574713,
0.0503558,0.0432403,0.0344828,0.0303777,0.0273673,0.0240832,0.0207991,0.0180624,0.0155993,0.0136836,0.0123153,
0.0106732,0.0090312,0.00848385,0.0060208,0.00492611,0.00383142,0.0030104,0.00246305,0.00164204,0.00164204,
0.00136836,0.00136836,0.00136836,0.000821018,0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,
0.000547345,0.000547345,0.000821018,0.00109469,0.00136836,0.00136836,0.00136836,0.00136836,0.00164204,
0.00164204,0.00191571,0.00246305,0.00273673,0.00328407,0.00355774,0.00383142,0.00383142,0.00437876,0.00465244,
0.00547345,0.00547345,0.00547345,0.00574713,0.00574713,0.0060208,0.00629447,0.00738916,0.00848385,0.00848385,
0.00957854,0.0109469,0.0125889,0.015873,0.0199781,0.0240832,0.0276409,0.0295567,0.0311987,0.032567,0.032567,
0.0314724,0.0303777,0.0276409,0.0240832,0.0259989,0.0202518,0.014231,0.0103996,0.00848385,0.00574713,
0.00383142,0.00328407,0.00273673,0.00218938,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.000821018,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000547345,0.00136836,0.00136836,0.00136836,0.00164204,0.00218938,0.00273673,0.00328407,
0.00437876,0.0060208,0.00875753,0.0125889,0.0188834,0.0276409,0.0344828,0.0481664,0.0599343,0.0703339,
0.0815545,0.0900383,0.0960591,0.101806,0.103448,0.103448,0.102627,0.102354,0.102627,0.104269,0.106732,
0.11029,0.112479,0.111111,0.106459,0.100712,0.0914067,0.0831965,0.0733443,0.0634921,0.0539135,0.045977,
0.0366721,0.0306513,0.0273673,0.0240832,0.0202518,0.0177887,0.015052,0.0125889,0.0112206,0.00957854,0.00848385,
0.00629447,0.00547345,0.00383142,0.00328407,0.00246305,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,
0.00136836,0.000821018,0.000547345,0.000547345,0.000547345,0.000547345,0.000821018,0.000821018,0.00136836,
0.00136836,0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00246305,0.00273673,0.00328407,0.00383142,
0.00437876,0.00547345,0.00574713,0.0060208,0.00629447,0.00738916,0.00766284,0.00848385,0.00848385,0.00848385,
0.00875753,0.00957854,0.00985222,0.0109469,0.0120416,0.0125889,0.015052,0.0177887,0.0218938,0.0257252,
0.0290093,0.032567,0.0372195,0.0410509,0.0437876,0.045977,0.045977,0.0437876,0.0394089,0.0336617,0.0303777,
0.031746,0.0273673,0.0205255,0.0139573,0.00985222,0.00766284,0.00547345,0.00383142,0.00328407,0.00273673,
0.00246305,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.000821018,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000821018,
0.00136836,0.00136836,0.00164204,0.00164204,0.00218938,0.00273673,0.00328407,0.00437876,0.0060208,0.00875753,
0.0125889,0.0205255,0.0281883,0.0385878,0.0522715,0.0645868,0.0807334,0.0938697,0.109469,0.124521,0.135742,
0.143952,0.148331,0.148878,0.147236,0.14532,0.146141,0.149699,0.152983,0.157362,0.157362,0.152162,0.144499,
0.132731,0.118227,0.103448,0.0897646,0.0779967,0.0643131,0.0528188,0.0437876,0.0336617,0.0290093,0.0257252,
0.0218938,0.0186097,0.0155993,0.0128626,0.0112206,0.00985222,0.00848385,0.00629447,0.00547345,0.00383142,
0.00328407,0.00246305,0.00191571,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.000821018,0.000821018,
0.000547345,0.000821018,0.000821018,0.000821018,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,
0.00164204,0.00164204,0.00246305,0.00273673,0.00355774,0.00437876,0.00547345,0.0060208,0.00738916,0.00848385,
0.0090312,0.00985222,0.0101259,0.0109469,0.0112206,0.0117679,0.0125889,0.0125889,0.014231,0.0161467,0.0180624,
0.0202518,0.0221675,0.0257252,0.0279146,0.0314724,0.0363985,0.0424193,0.0489874,0.0528188,0.0580186,0.0607553,
0.0613027,0.0599343,0.0566502,0.0522715,0.0462507,0.0388615,0.0410509,0.0322934,0.0273673,0.0199781,0.0128626,
0.00985222,0.00738916,0.00574713,0.00383142,0.00328407,0.00273673,0.00246305,0.00164204,0.00164204,0.00136836,
0.00136836,0.00136836,0.00136836,0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.00109469,0.00136836,0.00136836,0.00164204,0.00164204,0.00218938,
0.00273673,0.00328407,0.00465244,0.0060208,0.00875753,0.0125889,0.0207991,0.030104,0.0410509,0.0555556,
0.0714286,0.0878489,0.107006,0.129721,0.152709,0.172961,0.186097,0.197044,0.20416,0.205528,0.20416,0.203065,
0.203339,0.205528,0.207991,0.207718,0.203339,0.193487,0.18035,0.167214,0.14751,0.125889,0.104817,0.0870279,
0.0730706,0.0607553,0.0495348,0.0385878,0.0306513,0.0273673,0.0224412,0.0186097,0.015873,0.0128626,0.0112206,
0.00985222,0.00848385,0.00629447,0.00547345,0.00383142,0.00328407,0.00246305,0.00164204,0.00164204,0.00136836,
0.00136836,0.00136836,0.00136836,0.00109469,0.000821018,0.000821018,0.000821018,0.000821018,0.00136836,
0.00136836,0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00246305,0.00273673,0.00355774,0.00465244,
0.0060208,0.00738916,0.00848385,0.00985222,0.0112206,0.0125889,0.0136836,0.0155993,0.0169677,0.0177887,
0.0186097,0.0199781,0.0218938,0.0238095,0.0259989,0.0279146,0.0303777,0.032567,0.0372195,0.0432403,0.0489874,
0.0544609,0.0615764,0.0665025,0.0730706,0.0782704,0.0799124,0.0799124,0.0779967,0.0719759,0.0645868,0.0591133,
0.0503558,0.0522715,0.0410509,0.031746,0.0259989,0.0186097,0.0125889,0.00985222,0.00766284,0.00574713,
0.00437876,0.00355774,0.00328407,0.00246305,0.00218938,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,
0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,
0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00246305,0.00273673,0.00328407,0.00465244,0.0060208,
0.00875753,0.0125889,0.0207991,0.0303777,0.0437876,0.059387,0.076902,0.0938697,0.118774,0.148878,0.175424,
0.203612,0.234264,0.255063,0.273946,0.283799,0.288177,0.287904,0.286262,0.284072,0.281609,0.277778,0.271757,
0.257252,0.239464,0.220307,0.193487,0.171593,0.14532,0.119048,0.0971538,0.0799124,0.0645868,0.0522715,
0.0410509,0.0320197,0.0276409,0.0224412,0.0186097,0.0155993,0.0125889,0.0112206,0.00957854,0.00848385,
0.0060208,0.00492611,0.00355774,0.0030104,0.00246305,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,
0.00136836,0.00109469,0.000821018,0.000821018,0.000821018,0.00136836,0.00136836,0.00136836,0.00136836,
0.00136836,0.00164204,0.00164204,0.00246305,0.00273673,0.00355774,0.00519978,0.0060208,0.00848385,0.00985222,
0.0117679,0.0136836,0.016694,0.0186097,0.0210728,0.0229885,0.0249042,0.0262726,0.0276409,0.028462,0.0303777,
0.032567,0.0347564,0.0405036,0.045977,0.0511768,0.0561029,0.0629447,0.0692392,0.0779967,0.0840175,0.0908593,
0.0960591,0.101259,0.102354,0.101533,0.0960591,0.0900383,0.0821018,0.0719759,0.06185,0.0632184,0.0522715,
0.0405036,0.0306513,0.0249042,0.0177887,0.0125889,0.00985222,0.00848385,0.0060208,0.00519978,0.00383142,
0.00328407,0.00273673,0.00218938,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.000547345,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.00136836,0.00136836,
0.00136836,0.00164204,0.00164204,0.00246305,0.00273673,0.00355774,0.00465244,0.00629447,0.00875753,0.0123153,
0.0199781,0.030104,0.0437876,0.0613027,0.0799124,0.101259,0.129174,0.162288,0.193213,0.234537,0.272852,
0.304324,0.337438,0.366721,0.383963,0.390257,0.392173,0.387794,0.382594,0.369732,0.351396,0.332786,0.307061,
0.282704,0.251779,0.220307,0.185276,0.159004,0.129174,0.102627,0.0829228,0.0651341,0.0528188,0.0410509,
0.031746,0.0273673,0.0218938,0.0177887,0.014231,0.0123153,0.0101259,0.00848385,0.00711549,0.00574713,
0.00437876,0.00328407,0.00273673,0.00246305,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,
0.00109469,0.000821018,0.000821018,0.00109469,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,
0.00164204,0.00218938,0.00273673,0.00355774,0.00465244,0.00629447,0.00848385,0.0106732,0.0125889,0.0172414,
0.0202518,0.0240832,0.0270936,0.0281883,0.0303777,0.0322934,0.0336617,0.0372195,0.0405036,0.0437876,0.0489874,
0.0528188,0.0582923,0.0640394,0.0703339,0.0793651,0.0856596,0.0938697,0.104817,0.116311,0.124521,0.131637,
0.135468,0.135468,0.131637,0.124521,0.114669,0.10208,0.0873016,0.076902,0.0782704,0.0632184,0.0514505,
0.0394089,0.0303777,0.0240832,0.0177887,0.0125889,0.00985222,0.00848385,0.00629447,0.00547345,0.00383142,
0.00328407,0.00273673,0.00218938,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.00136836,0.00136836,0.00136836,0.00164204,
0.00164204,0.00246305,0.00273673,0.00355774,0.00465244,0.00629447,0.00875753,0.0123153,0.0186097,0.0281883,
0.0424193,0.0613027,0.0807334,0.104269,0.135194,0.171866,0.209633,0.253968,0.299124,0.350027,0.395731,
0.432677,0.463328,0.485769,0.496442,0.496169,0.487137,0.466612,0.444444,0.420088,0.388342,0.351943,0.313629,
0.274494,0.234811,0.194581,0.16393,0.131089,0.103448,0.0826492,0.0645868,0.0522715,0.0394089,0.0306513,
0.0257252,0.0205255,0.0164204,0.0125889,0.0109469,0.00957854,0.00848385,0.0060208,0.00547345,0.00383142,
0.00328407,0.00246305,0.00191571,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.000821018,
0.000821018,0.000821018,0.00109469,0.00136836,0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,
0.00246305,0.00328407,0.00437876,0.0060208,0.00848385,0.0109469,0.0136836,0.0180624,0.0227148,0.0273673,
0.0303777,0.032567,0.0372195,0.0415982,0.045977,0.0495348,0.0528188,0.0571976,0.0613027,0.0645868,0.0711549,
0.0796388,0.0859332,0.0946907,0.105638,0.118227,0.133279,0.148331,0.161467,0.170772,0.176245,0.178708,
0.176245,0.171866,0.161741,0.145594,0.128352,0.108648,0.091133,0.0916804,0.0779967,0.0629447,0.0503558,
0.0372195,0.0290093,0.0229885,0.0177887,0.0125889,0.0101259,0.00848385,0.00629447,0.00547345,0.00383142,
0.00328407,0.00273673,0.00218938,0.00164204,0.00164204,0.00136836,0.00136836,0.000821018,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000821018,0.00136836,
0.00136836,0.00164204,0.00164204,0.00246305,0.00273673,0.00355774,0.00465244,0.0060208,0.00848385,0.0117679,
0.0177887,0.0273673,0.0385878,0.0580186,0.0799124,0.104269,0.137384,0.175424,0.219759,0.269841,0.318555,
0.3815,0.431582,0.477559,0.525725,0.562945,0.589765,0.600985,0.59688,0.579912,0.548987,0.506021,0.465791,
0.425835,0.382594,0.328407,0.281609,0.235906,0.192666,0.160372,0.126437,0.0987958,0.0796388,0.06185,0.0484401,
0.0350301,0.0281883,0.0224412,0.0177887,0.0136836,0.0112206,0.00985222,0.00848385,0.00629447,0.00547345,
0.00383142,0.00328407,0.00273673,0.00246305,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,
0.00109469,0.000821018,0.000821018,0.000821018,0.00109469,0.00136836,0.00136836,0.00136836,0.00136836,
0.00164204,0.00218938,0.00273673,0.00383142,0.00547345,0.00766284,0.00985222,0.01341,0.0186097,0.0246305,
0.0281883,0.032567,0.0383142,0.0437876,0.0503558,0.0544609,0.0607553,0.0645868,0.0700602,0.076081,0.0807334,
0.0864806,0.0935961,0.104817,0.117679,0.13191,0.149152,0.167214,0.180624,0.197592,0.213738,0.227148,0.234264,
0.234811,0.229611,0.217296,0.199781,0.18035,0.161741,0.136015,0.113574,0.113848,0.091133,0.076081,0.0613027,
0.0489874,0.0350301,0.0279146,0.0221675,0.0177887,0.0125889,0.00985222,0.00848385,0.0060208,0.00547345,
0.00383142,0.00328407,0.00246305,0.00191571,0.00164204,0.00136836,0.00136836,0.00136836,0.000547345,0.000273673,
0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.00136836,0.00136836,0.00136836,0.00164204,
0.00218938,0.00273673,0.00328407,0.00437876,0.0060208,0.00848385,0.0112206,0.0169677,0.0254516,0.0336617,
0.0522715,0.074439,0.0993432,0.134647,0.174877,0.221401,0.273946,0.327313,0.388068,0.443076,0.498632,
0.556103,0.603722,0.645868,0.670224,0.677066,0.66913,0.64231,0.595238,0.547072,0.489874,0.436234,0.383689,
0.322934,0.272578,0.22277,0.179803,0.145868,0.115216,0.0900383,0.0703339,0.0544609,0.0415982,0.030925,
0.0257252,0.0188834,0.014231,0.0114943,0.00985222,0.00848385,0.00629447,0.00574713,0.00437876,0.00355774,
0.00273673,0.00246305,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.00109469,0.000821018,
0.000821018,0.000821018,0.000821018,0.00109469,0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,
0.00246305,0.00328407,0.00437876,0.00629447,0.0090312,0.0125889,0.0177887,0.0240832,0.0290093,0.0333881,
0.0410509,0.0489874,0.0555556,0.0629447,0.0697865,0.0782704,0.0840175,0.0908593,0.0987958,0.106732,0.118227,
0.131089,0.148331,0.165572,0.180624,0.203339,0.228517,0.249589,0.272304,0.287904,0.297209,0.302135,0.298851,
0.290914,0.275315,0.251779,0.226054,0.195676,0.169403,0.139847,0.138478,0.110016,0.08867,0.0730706,0.0591133,
0.0457033,0.032567,0.0273673,0.0207991,0.0155993,0.0120416,0.00957854,0.00821018,0.0060208,0.00465244,
0.00355774,0.00273673,0.00246305,0.00164204,0.00164204,0.00136836,0.00136836,0.00109469,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.00136836,0.00136836,0.00136836,0.00164204,
0.00164204,0.00246305,0.00328407,0.00383142,0.00574713,0.00848385,0.0109469,0.0155993,0.0224412,0.0306513,
0.046798,0.0645868,0.0908593,0.124521,0.167488,0.211549,0.267926,0.322386,0.384784,0.439245,0.494527,
0.554461,0.604543,0.652983,0.683087,0.700328,0.701149,0.688834,0.658183,0.60509,0.547072,0.480022,0.422824,
0.360427,0.297209,0.243842,0.19595,0.159551,0.124521,0.0971538,0.0785441,0.0607553,0.045977,0.032567,
0.0273673,0.0207991,0.015052,0.0114943,0.00957854,0.00848385,0.00629447,0.00547345,0.00437876,0.00355774,
0.00273673,0.00246305,0.00191571,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.000821018,
0.000547345,0.000547345,0.000547345,0.000821018,0.000821018,0.00136836,0.00136836,0.00136836,0.00164204,
0.00191571,0.00273673,0.00355774,0.00547345,0.00766284,0.0103996,0.0145047,0.0213465,0.0279146,0.032567,
0.0410509,0.0503558,0.0591133,0.0659551,0.0779967,0.0856596,0.0957854,0.106732,0.119869,0.134647,0.150794,
0.167488,0.183087,0.205802,0.233716,0.258073,0.287904,0.316366,0.341817,0.370553,0.386152,0.395731,0.395731,
0.387247,0.37329,0.341544,0.310071,0.276409,0.23919,0.203339,0.171593,0.167214,0.133279,0.104817,0.0845649,
0.0675972,0.0539135,0.0405036,0.0306513,0.0249042,0.0186097,0.0139573,0.0109469,0.00848385,0.00656814,
0.00547345,0.00383142,0.00328407,0.00246305,0.00191571,0.00164204,0.00136836,0.00136836,0.00136836,0.000547345,
0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000821018,0.00136836,0.00136836,0.00136836,
0.00164204,0.00218938,0.00273673,0.00383142,0.00547345,0.00738916,0.00985222,0.0136836,0.0207991,0.0281883,
0.0405036,0.0582923,0.0801861,0.108648,0.151341,0.193487,0.247126,0.303777,0.366995,0.422824,0.470443,
0.524904,0.574986,0.620142,0.656541,0.678708,0.690476,0.687739,0.668856,0.629995,0.572797,0.505473,0.442255,
0.382868,0.316092,0.256158,0.204707,0.165298,0.128352,0.100164,0.0799124,0.0623974,0.0478927,0.0336617,
0.0276409,0.0207991,0.0145047,0.0112206,0.0090312,0.00766284,0.0060208,0.00547345,0.00383142,0.00328407,
0.00273673,0.00246305,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.000821018,
0.000547345,0.000547345,0.000547345,0.000547345,0.000547345,0.000821018,0.00136836,0.00136836,0.00136836,
0.00164204,0.00218938,0.00273673,0.00383142,0.00574713,0.00848385,0.0117679,0.0177887,0.0249042,0.0303777,
0.0383142,0.0489874,0.0580186,0.0673235,0.0796388,0.090312,0.104817,0.120142,0.139573,0.161467,0.179803,
0.203339,0.233169,0.259989,0.293651,0.328955,0.371921,0.404762,0.437055,0.464149,0.487958,0.501916,0.506021,
0.498358,0.480843,0.455118,0.423645,0.383689,0.334428,0.288725,0.243569,0.201697,0.189929,0.155172,0.122058,
0.0963328,0.0790914,0.0615764,0.0478927,0.0339354,0.0279146,0.0218938,0.0164204,0.0123153,0.00985222,
0.00848385,0.0060208,0.00437876,0.00355774,0.00273673,0.00246305,0.00164204,0.00164204,0.00136836,0.00136836,
0.000821018,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.00136836,0.00136836,
0.00136836,0.00164204,0.00164204,0.00246305,0.00328407,0.00437876,0.0060208,0.00875753,0.0123153,0.0180624,
0.0259989,0.0336617,0.0503558,0.0684182,0.091954,0.126984,0.171593,0.220033,0.275315,0.33087,0.388342,
0.437603,0.479201,0.522989,0.559934,0.589491,0.614943,0.63191,0.637384,0.628079,0.595512,0.555829,0.497537,
0.440066,0.381773,0.313082,0.253968,0.202244,0.162288,0.125342,0.0963328,0.0779967,0.0604817,0.0462507,
0.032567,0.0270936,0.0197044,0.0136836,0.0106732,0.00848385,0.00629447,0.00574713,0.00437876,0.00355774,
0.00328407,0.00246305,0.00218938,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.00109469,
0.000547345,0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.000821018,0.00136836,
0.00136836,0.00136836,0.00164204,0.00246305,0.00328407,0.00437876,0.0060208,0.00930487,0.0125889,0.0191571,
0.0273673,0.032567,0.043514,0.0539135,0.0645868,0.0779967,0.0900383,0.105638,0.125889,0.150246,0.175151,
0.203339,0.237274,0.276136,0.316639,0.364806,0.409962,0.455118,0.5,0.548714,0.586754,0.623426,0.646689,
0.657088,0.654078,0.635194,0.597154,0.556103,0.504379,0.454297,0.402299,0.341544,0.287904,0.237274,0.218117,
0.174877,0.138205,0.107006,0.0853859,0.0673235,0.0528188,0.0391352,0.0303777,0.0240832,0.0177887,0.0125889,
0.0101259,0.00848385,0.00629447,0.00547345,0.00383142,0.0030104,0.00246305,0.00164204,0.00164204,0.00136836,
0.00136836,0.000821018,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.00136836,
0.00136836,0.00136836,0.00164204,0.00218938,0.00273673,0.00355774,0.00547345,0.00766284,0.0103996,0.015052,
0.0221675,0.0303777,0.0418719,0.0591133,0.0790914,0.103722,0.14012,0.180624,0.234537,0.287904,0.339354,
0.391626,0.432403,0.464149,0.491516,0.514231,0.532293,0.542967,0.546798,0.542146,0.523536,0.492885,0.455391,
0.409141,0.351669,0.293103,0.238095,0.187739,0.151067,0.116585,0.0892173,0.0697865,0.0539135,0.0405036,
0.0303777,0.0240832,0.0177887,0.0125889,0.00957854,0.00766284,0.00574713,0.00465244,0.00383142,0.00328407,
0.00273673,0.00246305,0.00164204,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.000821018,
0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,
0.00136836,0.00136836,0.00136836,0.00164204,0.00246305,0.00328407,0.00465244,0.00629447,0.00985222,0.0136836,
0.0207991,0.0279146,0.0342091,0.0473454,0.0588396,0.0700602,0.0840175,0.0990695,0.119869,0.148057,0.175972,
0.209907,0.253968,0.301587,0.35988,0.418446,0.474001,0.542967,0.599891,0.663109,0.703886,0.730432,0.743569,
0.753968,0.756158,0.749042,0.734811,0.709633,0.66913,0.600985,0.536946,0.464149,0.399288,0.329228,0.272304,
0.23919,0.188287,0.151615,0.117132,0.0908593,0.0719759,0.0558292,0.0418719,0.030925,0.0254516,0.0186097,
0.0136836,0.0109469,0.00848385,0.00629447,0.00547345,0.00383142,0.00328407,0.00246305,0.00164204,0.00164204,
0.00136836,0.00136836,0.00136836,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000821018,
0.00136836,0.00136836,0.00136836,0.00164204,0.00246305,0.00328407,0.00383142,0.0060208,0.00848385,0.0123153,
0.0180624,0.0262726,0.0336617,0.0489874,0.0645868,0.0845649,0.112206,0.148878,0.186371,0.235906,0.284893,
0.330323,0.379037,0.406951,0.430213,0.44116,0.445539,0.446086,0.443076,0.438424,0.430213,0.410509,0.384784,
0.345649,0.301314,0.256431,0.209907,0.170498,0.132184,0.10208,0.0799124,0.0613027,0.045977,0.032567,0.0262726,
0.0194308,0.0139573,0.0103996,0.00848385,0.0060208,0.00519978,0.00383142,0.00328407,0.00273673,0.00246305,
0.00191571,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.000821018,0.000547345,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.00109469,0.00136836,0.00136836,0.00164204,0.00246305,0.00328407,0.00492611,0.00656814,0.00985222,
0.0136836,0.0210728,0.0281883,0.0363985,0.0489874,0.0613027,0.0749863,0.0878489,0.106732,0.133279,0.164751,
0.197592,0.24439,0.301587,0.376574,0.44116,0.518336,0.597154,0.677887,0.727969,0.757526,0.794198,0.81746,
0.833607,0.841817,0.840175,0.827313,0.807882,0.767652,0.736727,0.693487,0.612206,0.528736,0.444718,0.3763,
0.297482,0.253968,0.197592,0.158456,0.120416,0.092775,0.0749863,0.0574713,0.0432403,0.031746,0.0257252,
0.0186097,0.0136836,0.0109469,0.00848385,0.00629447,0.00547345,0.00383142,0.00328407,0.00246305,0.00191571,
0.00164204,0.00136836,0.00136836,0.00136836,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00246305,0.00328407,0.00437876,0.00629447,
0.00957854,0.0136836,0.0207991,0.0281883,0.0385878,0.0528188,0.0697865,0.0878489,0.115764,0.149152,0.183087,
0.226054,0.269294,0.30405,0.336617,0.363437,0.378763,0.379858,0.374384,0.359332,0.343733,0.328955,0.316366,
0.293651,0.27121,0.23919,0.206623,0.174877,0.14231,0.11029,0.0859332,0.0673235,0.0519978,0.0363985,0.0276409,
0.0199781,0.014231,0.0112206,0.00848385,0.00629447,0.00547345,0.00383142,0.00328407,0.00273673,0.00246305,
0.00164204,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.000821018,0.000547345,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000821018,0.00136836,0.00136836,0.00164204,0.00246305,0.00328407,
0.00465244,0.00629447,0.00957854,0.0131363,0.0207991,0.0279146,0.0363985,0.0492611,0.0615764,0.076902,
0.0908593,0.112479,0.139847,0.174877,0.218117,0.275588,0.345375,0.428571,0.514231,0.610564,0.701423,0.748768,
0.796114,0.83607,0.871374,0.895183,0.914067,0.918719,0.913246,0.892994,0.863711,0.826765,0.778051,0.734537,
0.675151,0.578818,0.481664,0.401478,0.318829,0.258347,0.19896,0.158456,0.120142,0.0925014,0.0733443,0.0561029,
0.0418719,0.030925,0.0254516,0.0183361,0.0131363,0.0103996,0.00848385,0.00629447,0.00547345,0.00383142,
0.00328407,0.00246305,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.000273673,0.000273673,
0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000547345,0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00246305,
0.00328407,0.00465244,0.00684182,0.00985222,0.0153257,0.0224412,0.0303777,0.0418719,0.0555556,0.0714286,
0.0900383,0.113848,0.142583,0.173782,0.205802,0.23919,0.270936,0.290914,0.302135,0.304324,0.297209,0.286262,
0.270389,0.250958,0.235632,0.217022,0.197044,0.177887,0.158456,0.134647,0.109469,0.0883963,0.0708812,
0.0552819,0.0407772,0.029283,0.0210728,0.0136836,0.0103996,0.00848385,0.00629447,0.00547345,0.00383142,
0.00328407,0.00273673,0.00246305,0.00191571,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,
0.000821018,0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.00136836,
0.00136836,0.00164204,0.00246305,0.00328407,0.00465244,0.00629447,0.0090312,0.0125889,0.0186097,0.0273673,
0.0336617,0.047619,0.0607553,0.0749863,0.0905857,0.112479,0.14231,0.177887,0.22879,0.292282,0.379584,
0.463602,0.570334,0.680077,0.743295,0.801314,0.851943,0.894636,0.934319,0.957033,0.974001,0.975369,0.963054,
0.942255,0.904488,0.860701,0.811713,0.75561,0.702518,0.604269,0.501916,0.415709,0.328955,0.251232,0.192392,
0.151341,0.11549,0.0878489,0.0695129,0.0528188,0.0385878,0.0295567,0.0235359,0.0177887,0.0125889,0.00985222,
0.00848385,0.0060208,0.00492611,0.00355774,0.0030104,0.00246305,0.00164204,0.00164204,0.00136836,0.00136836,
0.00136836,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.00136836,0.00136836,
0.00136836,0.00164204,0.00164204,0.00246305,0.00328407,0.00492611,0.00738916,0.0106732,0.0155993,0.0240832,
0.0306513,0.0432403,0.0561029,0.0706076,0.0870279,0.106732,0.13191,0.159004,0.180624,0.205528,0.227696,
0.238643,0.242748,0.238916,0.229611,0.209907,0.191297,0.175151,0.161467,0.144226,0.128352,0.112206,0.0957854,
0.0826492,0.0678708,0.0552819,0.0424193,0.0311987,0.0240832,0.0155993,0.0103996,0.00848385,0.0060208,
0.00519978,0.00383142,0.00328407,0.00273673,0.00246305,0.00191571,0.00164204,0.00164204,0.00136836,0.00136836,
0.00136836,0.00136836,0.000821018,0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.00136836,0.00136836,0.00164204,0.00246305,0.00328407,0.00437876,
0.0060208,0.00848385,0.0112206,0.0177887,0.0249042,0.031746,0.0437876,0.0566502,0.0703339,0.0864806,0.106732,
0.136015,0.174877,0.227696,0.294472,0.384784,0.47838,0.593049,0.704707,0.764368,0.827313,0.882047,0.931308,
0.963602,0.989327,1,0.998905,0.98659,0.957307,0.917351,0.8711,0.817734,0.757526,0.703339,0.601806,0.497811,
0.409962,0.322113,0.233169,0.17734,0.135468,0.102901,0.0807334,0.0629447,0.0478927,0.0336617,0.0276409,
0.0207991,0.015052,0.0112206,0.0090312,0.00738916,0.00574713,0.00437876,0.00328407,0.00273673,0.00246305,
0.00164204,0.00164204,0.00136836,0.00136836,0.000821018,0.000273673,0.000273673,0.000273673,0.000273673,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000547345,0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00246305,0.00328407,0.00492611,0.00738916,
0.0106732,0.0155993,0.0240832,0.0306513,0.0418719,0.0544609,0.0675972,0.0829228,0.0990695,0.118227,0.138205,
0.158456,0.173235,0.180898,0.186918,0.186097,0.179529,0.16913,0.151615,0.134647,0.118227,0.104269,0.091133,
0.0807334,0.0697865,0.0599343,0.0498084,0.0391352,0.0306513,0.0249042,0.0177887,0.0117679,0.00848385,
0.0060208,0.00437876,0.00355774,0.0030104,0.00246305,0.00218938,0.00164204,0.00164204,0.00164204,0.00136836,
0.00136836,0.00136836,0.00136836,0.000821018,0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000821018,0.00136836,0.00164204,
0.00218938,0.00273673,0.00383142,0.00574713,0.00848385,0.00985222,0.014231,0.0218938,0.0290093,0.0383142,
0.0511768,0.0645868,0.0801861,0.0987958,0.125889,0.165298,0.214012,0.284346,0.377668,0.470443,0.588396,
0.70416,0.764641,0.828134,0.8867,0.935413,0.965517,0.9896,0.997811,0.993706,0.979201,0.947729,0.904488,
0.853585,0.799398,0.741927,0.677887,0.572523,0.469622,0.386152,0.297756,0.199234,0.154351,0.116585,0.0883963,
0.0700602,0.0539135,0.0396825,0.0303777,0.0240832,0.0177887,0.0125889,0.00985222,0.00848385,0.0060208,
0.00547345,0.00383142,0.00328407,0.00246305,0.00191571,0.00164204,0.00136836,0.00136836,0.00136836,0.000547345,
0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.00136836,0.00136836,0.00136836,0.00164204,
0.00164204,0.00246305,0.00328407,0.00465244,0.00711549,0.0101259,0.0153257,0.0221675,0.0295567,0.0391352,
0.0514505,0.0632184,0.0774494,0.0883963,0.102627,0.117406,0.130268,0.14012,0.146415,0.147783,0.14231,
0.132458,0.118227,0.104817,0.091133,0.0804598,0.0700602,0.0607553,0.0511768,0.0418719,0.0331144,0.0279146,
0.0224412,0.0177887,0.0123153,0.00930487,0.00629447,0.00465244,0.00355774,0.00273673,0.00246305,0.00218938,
0.00164204,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.000547345,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000547345,0.00136836,0.00136836,0.00164204,0.00273673,0.00355774,0.00519978,
0.00629447,0.00875753,0.0123153,0.0177887,0.0257252,0.0322934,0.0437876,0.0566502,0.0706076,0.0870279,
0.112206,0.148878,0.192939,0.258347,0.342091,0.442529,0.555829,0.67734,0.747947,0.810619,0.86289,0.908046,
0.942802,0.958949,0.968528,0.958949,0.942802,0.907499,0.863437,0.813903,0.757526,0.705528,0.612479,0.509305,
0.42474,0.337712,0.264368,0.167488,0.124521,0.092775,0.074439,0.0580186,0.0437876,0.031746,0.0257252,
0.0186097,0.01341,0.0106732,0.00848385,0.00629447,0.00547345,0.00383142,0.00328407,0.00273673,0.00246305,
0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.000273673,0.000273673,0.000273673,0.000273673,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000547345,0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00246305,0.00328407,
0.00437876,0.00629447,0.00957854,0.0136836,0.0207991,0.0279146,0.0336617,0.0462507,0.0571976,0.0665025,
0.0793651,0.0870279,0.0971538,0.104817,0.109469,0.112479,0.108648,0.102627,0.0930487,0.0845649,0.0749863,
0.0640394,0.0541872,0.045977,0.0366721,0.0303777,0.0259989,0.0207991,0.0155993,0.0117679,0.00957854,0.00738916,
0.00547345,0.00383142,0.0030104,0.00246305,0.00218938,0.00164204,0.00164204,0.00164204,0.00136836,0.00136836,
0.00136836,0.00136836,0.00136836,0.000821018,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.00136836,0.00136836,0.00164204,0.00246305,0.00328407,0.00383142,0.00574713,0.00821018,0.00985222,
0.0136836,0.0202518,0.0276409,0.0336617,0.0473454,0.0607553,0.076902,0.0946907,0.12671,0.171593,0.227969,
0.30104,0.399288,0.498358,0.615216,0.713191,0.764641,0.821839,0.860974,0.890531,0.909414,0.913793,0.904488,
0.880405,0.848385,0.808976,0.75561,0.706623,0.6237,0.523536,0.435687,0.357417,0.282704,0.217296,0.127258,
0.0941434,0.074439,0.0580186,0.0437876,0.0322934,0.0259989,0.0186097,0.0136836,0.0109469,0.00848385,0.00656814,
0.00574713,0.00437876,0.00355774,0.00273673,0.00246305,0.00191571,0.00164204,0.00136836,0.00136836,0.00136836,
0.000821018,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.00136836,0.00136836,
0.00136836,0.00164204,0.00164204,0.00218938,0.00273673,0.00383142,0.0060208,0.00848385,0.0123153,0.0177887,
0.0249042,0.0306513,0.0391352,0.0492611,0.0582923,0.0645868,0.074439,0.0801861,0.0845649,0.0856596,0.0853859,
0.0826492,0.0774494,0.0675972,0.0599343,0.0511768,0.0418719,0.0333881,0.0287356,0.0246305,0.0186097,0.0145047,
0.0114943,0.00957854,0.00766284,0.00574713,0.00437876,0.00328407,0.00273673,0.00218938,0.00164204,0.00164204,
0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.000821018,0.000547345,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000821018,0.00136836,0.00164204,0.00164204,0.00273673,0.00355774,0.00465244,
0.0060208,0.00848385,0.0109469,0.0145047,0.0213465,0.0279146,0.0353038,0.0489874,0.0629447,0.0801861,
0.104817,0.143404,0.191024,0.257252,0.340175,0.437055,0.539135,0.643678,0.72058,0.76081,0.803503,0.827586,
0.842365,0.845649,0.834154,0.811713,0.772852,0.737274,0.689655,0.598796,0.506568,0.430213,0.350848,0.281609,
0.221401,0.170772,0.0914067,0.0703339,0.0539135,0.0410509,0.0306513,0.0249042,0.0180624,0.0125889,0.00985222,
0.00848385,0.00629447,0.00547345,0.00383142,0.00355774,0.00273673,0.00246305,0.00191571,0.00164204,0.00164204,
0.00136836,0.00136836,0.00136836,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.00109469,0.00136836,0.00136836,0.00136836,0.00164204,0.00191571,0.00273673,0.00355774,0.00547345,0.00766284,
0.0101259,0.014231,0.0207991,0.0273673,0.031746,0.0394089,0.0478927,0.0539135,0.0599343,0.0634921,0.0645868,
0.0648604,0.0643131,0.061029,0.0539135,0.0478927,0.0391352,0.031746,0.0276409,0.0221675,0.0177887,0.0136836,
0.0112206,0.00930487,0.00766284,0.0060208,0.00465244,0.00355774,0.0030104,0.00246305,0.00164204,0.00164204,
0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.000821018,0.000547345,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,
0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.00136836,0.00136836,0.00164204,0.00218938,0.00273673,0.00383142,0.00547345,0.00629447,0.00848385,0.0112206,
0.0155993,0.0213465,0.0279146,0.0353038,0.0495348,0.0645868,0.0853859,0.116585,0.161193,0.212917,0.285441,
0.37329,0.454023,0.546798,0.634647,0.702791,0.736727,0.757526,0.767378,0.767652,0.7578,0.737001,0.704707,
0.643678,0.560208,0.475096,0.403667,0.328681,0.264915,0.207991,0.16393,0.122332,0.0645868,0.0492611,0.0347564,
0.0279146,0.0218938,0.0155993,0.0117679,0.00957854,0.00766284,0.0060208,0.00492611,0.00383142,0.00328407,
0.00273673,0.00246305,0.00191571,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.000547345,0.000273673,
0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000821018,0.00136836,0.00136836,0.00136836,0.00164204,
0.00164204,0.00246305,0.00328407,0.00437876,0.0060208,0.00875753,0.0117679,0.015873,0.0218938,0.0273673,
0.0306513,0.0353038,0.0410509,0.045977,0.0489874,0.0495348,0.0489874,0.0462507,0.0410509,0.0342091,0.0303777,
0.0259989,0.0207991,0.0164204,0.0125889,0.0103996,0.00875753,0.00738916,0.0060208,0.00492611,0.00383142,
0.00328407,0.00273673,0.00218938,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.00109469,
0.000821018,0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000547345,0.00136836,0.00136836,0.00164204,0.00246305,0.00328407,0.00383142,
0.00547345,0.00629447,0.00848385,0.0109469,0.014231,0.0202518,0.0276409,0.0353038,0.0511768,0.0678708,
0.0916804,0.127258,0.173782,0.233169,0.297482,0.380952,0.446634,0.519978,0.586481,0.643678,0.680077,0.697865,
0.696771,0.674603,0.6341,0.574713,0.502737,0.435687,0.370553,0.297209,0.23919,0.187466,0.149152,0.112479,
0.0851122,0.0410509,0.0303777,0.0240832,0.0177887,0.0125889,0.00985222,0.00848385,0.0060208,0.00547345,
0.00383142,0.00328407,0.0030104,0.00246305,0.00218938,0.00164204,0.00164204,0.00164204,0.00136836,0.00136836,
0.00136836,0.000821018,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,
0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00218938,0.00273673,0.00355774,0.00547345,0.00684182,
0.00957854,0.0123153,0.0155993,0.0207991,0.0249042,0.0279146,0.0303777,0.0322934,0.032567,0.032567,0.0322934,
0.0303777,0.0279146,0.0240832,0.0191571,0.015052,0.0117679,0.00985222,0.00848385,0.00629447,0.00574713,
0.00465244,0.00383142,0.00328407,0.00273673,0.00246305,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,
0.00136836,0.000821018,0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.00109469,0.00136836,0.00164204,0.00164204,0.00246305,
0.00328407,0.00383142,0.00519978,0.0060208,0.00848385,0.00985222,0.0125889,0.0186097,0.0276409,0.0369458,
0.0528188,0.074439,0.100164,0.138205,0.182266,0.238095,0.296935,0.360701,0.418446,0.465791,0.506021,0.541872,
0.554461,0.55145,0.527094,0.487685,0.440066,0.386152,0.321292,0.264641,0.211549,0.169677,0.129721,0.0979748,
0.076081,0.0571976,0.0262726,0.0183361,0.0125889,0.00985222,0.00848385,0.0060208,0.00547345,0.00383142,
0.00328407,0.00273673,0.00246305,0.00246305,0.00164204,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,
0.00136836,0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.00109469,0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00246305,0.00328407,0.00383142,
0.00574713,0.00738916,0.00957854,0.0114943,0.014231,0.0177887,0.0207991,0.0224412,0.0246305,0.0249042,
0.0246305,0.0224412,0.0205255,0.0177887,0.0136836,0.0112206,0.00957854,0.00848385,0.0060208,0.00547345,
0.00383142,0.00355774,0.00328407,0.00273673,0.00246305,0.00191571,0.00164204,0.00164204,0.00136836,0.00136836,
0.00136836,0.000821018,0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.00136836,0.00136836,0.00164204,0.00164204,
0.00246305,0.00273673,0.00355774,0.00437876,0.00574713,0.00738916,0.00957854,0.0125889,0.0186097,0.0279146,
0.0396825,0.0582923,0.0799124,0.106732,0.144773,0.183908,0.232895,0.276683,0.318555,0.362069,0.391626,
0.411056,0.419267,0.414888,0.395731,0.365353,0.318829,0.275315,0.22879,0.181992,0.148057,0.112753,0.0856596,
0.0645868,0.0489874,0.0331144,0.014231,0.0103996,0.00848385,0.0060208,0.00492611,0.00383142,0.00328407,
0.00273673,0.00246305,0.00218938,0.00164204,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,
0.00109469,0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000547345,0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00191571,0.00246305,0.00328407,0.00383142,
0.00574713,0.00656814,0.00848385,0.00985222,0.0117679,0.0128626,0.0145047,0.0155993,0.0155993,0.0145047,
0.01341,0.0123153,0.0101259,0.00875753,0.00738916,0.0060208,0.00465244,0.00383142,0.00328407,0.00273673,
0.00246305,0.00218938,0.00164204,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.000547345,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000547345,0.00136836,0.00136836,0.00164204,0.00164204,0.00218938,
0.00273673,0.00328407,0.00383142,0.00547345,0.00629447,0.00848385,0.0123153,0.0199781,0.0295567,0.0437876,
0.0629447,0.0845649,0.11029,0.143131,0.175972,0.207718,0.238643,0.265736,0.286262,0.295567,0.297209,0.292282,
0.276409,0.251779,0.221949,0.186097,0.157909,0.125068,0.0971538,0.076902,0.0571976,0.0405036,0.0290093,
0.0218938,0.00875753,0.00629447,0.00547345,0.00383142,0.00328407,0.00273673,0.00246305,0.00164204,0.00164204,
0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00109469,0.000547345,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000821018,
0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00218938,0.00273673,0.00328407,0.00383142,0.00547345,
0.0060208,0.00738916,0.00848385,0.00930487,0.00985222,0.00985222,0.00985222,0.00957854,0.00875753,0.00848385,
0.00629447,0.00574713,0.00437876,0.00355774,0.00328407,0.00246305,0.00246305,0.00164204,0.00164204,0.00164204,
0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.000821018,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000547345,0.00136836,0.00136836,0.00136836,0.00164204,0.00191571,0.00246305,
0.0030104,0.00355774,0.00437876,0.0060208,0.00848385,0.0125889,0.0218938,0.0311987,0.047619,0.0645868,
0.0848385,0.105638,0.131089,0.155172,0.174877,0.189655,0.201697,0.206623,0.205528,0.197044,0.184182,0.170498,
0.151067,0.12671,0.104543,0.0845649,0.0656814,0.0503558,0.0336617,0.0259989,0.0177887,0.0123153,0.00574713,
0.00383142,0.00328407,0.00273673,0.00246305,0.00164204,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,
0.00136836,0.00109469,0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.00136836,0.00136836,0.00136836,0.00136836,
0.00164204,0.00164204,0.00218938,0.00246305,0.00328407,0.00355774,0.00383142,0.00547345,0.00574713,0.0060208,
0.00629447,0.00629447,0.00629447,0.0060208,0.00574713,0.00492611,0.00383142,0.00328407,0.0030104,0.00246305,
0.00218938,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.000821018,
0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.00136836,0.00136836,0.00136836,
0.00164204,0.00164204,0.00246305,0.00273673,0.00328407,0.00383142,0.0060208,0.0090312,0.0139573,0.0235359,
0.032567,0.0489874,0.0640394,0.0801861,0.0952381,0.110837,0.124521,0.135194,0.14231,0.143404,0.14012,
0.1341,0.123153,0.112206,0.0979748,0.0848385,0.0711549,0.0580186,0.0437876,0.0306513,0.0224412,0.0155993,
0.0103996,0.00848385,0.00383142,0.0030104,0.00246305,0.00164204,0.00164204,0.00164204,0.00136836,0.00136836,
0.00136836,0.00109469,0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.00136836,
0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00191571,0.00246305,0.00273673,0.00328407,0.00328407,
0.00383142,0.00383142,0.00383142,0.00383142,0.00383142,0.00383142,0.00355774,0.00328407,0.00273673,0.00246305,
0.00191571,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.000821018,
0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.00136836,0.00136836,
0.00136836,0.00164204,0.00164204,0.00191571,0.00246305,0.00328407,0.00383142,0.0060208,0.00957854,0.0145047,
0.0240832,0.032567,0.0462507,0.059387,0.0703339,0.0807334,0.0873016,0.0925014,0.0957854,0.0957854,0.0925014,
0.0878489,0.0826492,0.076081,0.0656814,0.0574713,0.0470717,0.0339354,0.0276409,0.0194308,0.0125889,0.00957854,
0.00629447,0.00547345,0.00273673,0.00218938,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.000821018,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.00136836,0.00136836,
0.00136836,0.00136836,0.00164204,0.00164204,0.00164204,0.00218938,0.00246305,0.00246305,0.00273673,0.00273673,
0.00273673,0.00273673,0.00273673,0.00273673,0.00246305,0.00218938,0.00164204,0.00164204,0.00164204,0.00136836,
0.00136836,0.00136836,0.00136836,0.00109469,0.000821018,0.000547345,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.00136836,0.00136836,0.00136836,0.00136836,
0.00164204,0.00164204,0.00246305,0.00328407,0.00437876,0.00629447,0.00985222,0.0145047,0.0224412,0.0303777,
0.0394089,0.0495348,0.0571976,0.0629447,0.0645868,0.0656814,0.0645868,0.0634921,0.0607553,0.0555556,0.0503558,
0.0424193,0.0333881,0.0279146,0.0218938,0.0153257,0.0109469,0.00848385,0.00574713,0.00383142,0.00328407,
0.00191571,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.000547345,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.00109469,0.00136836,0.00136836,0.00136836,
0.00136836,0.00164204,0.00164204,0.00164204,0.00164204,0.00191571,0.00218938,0.00218938,0.00191571,0.00191571,
0.00164204,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.000821018,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000547345,0.000821018,0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00246305,0.00328407,
0.00437876,0.00629447,0.00957854,0.0128626,0.0199781,0.0262726,0.0306513,0.0355774,0.0405036,0.0437876,
0.0437876,0.0437876,0.0410509,0.0374932,0.0331144,0.0303777,0.0259989,0.0205255,0.015052,0.0112206,0.00848385,
0.0060208,0.00465244,0.00355774,0.00273673,0.00246305,0.00164204,0.00136836,0.00136836,0.00136836,0.000821018,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000821018,0.00136836,0.00136836,
0.00136836,0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,
0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.000547345,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000821018,
0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00246305,0.00328407,0.00437876,0.0060208,0.00848385,
0.0112206,0.0145047,0.0191571,0.0240832,0.0262726,0.0279146,0.0279146,0.0279146,0.0268199,0.0246305,0.0210728,
0.0177887,0.0128626,0.0106732,0.00848385,0.00629447,0.00547345,0.00355774,0.0030104,0.00246305,0.00191571,
0.00164204,0.00136836,0.00136836,0.00136836,0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000547345,0.000821018,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,
0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.000821018,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000547345,0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,
0.00246305,0.0030104,0.00383142,0.00547345,0.00629447,0.00848385,0.0101259,0.0123153,0.0136836,0.0155993,
0.0155993,0.0155993,0.014231,0.0125889,0.0109469,0.0090312,0.00766284,0.0060208,0.00465244,0.00355774,
0.0030104,0.00246305,0.00191571,0.00164204,0.00164204,0.00136836,0.00136836,0.000821018,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.000821018,0.00136836,
0.00136836,0.00136836,0.00136836,0.00136836,0.00109469,0.000821018,0.000547345,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000821018,0.00136836,0.00136836,0.00136836,0.00164204,0.00218938,0.00273673,0.00328407,
0.00383142,0.00492611,0.00574713,0.00629447,0.00848385,0.00848385,0.00848385,0.00848385,0.00848385,0.00629447,
0.00574713,0.00519978,0.00383142,0.00328407,0.00273673,0.00246305,0.00164204,0.00164204,0.00164204,0.00136836,
0.00136836,0.00136836,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.00109469,0.00136836,0.00136836,0.00164204,0.00164204,0.00218938,
0.00246305,0.0030104,0.00328407,0.00383142,0.00383142,0.00437876,0.00437876,0.00383142,0.00383142,0.00355774,
0.00328407,0.00273673,0.00246305,0.00218938,0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,
0.00136836,0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000547345,0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00164204,0.00218938,0.00246305,0.00246305,
0.00246305,0.00246305,0.00246305,0.00246305,0.00218938,0.00164204,0.00164204,0.00164204,0.00136836,0.00136836,
0.00136836,0.00136836,0.00109469,0.000547345,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000547345,0.00136836,0.00136836,0.00136836,0.00136836,0.00164204,0.00164204,0.00164204,0.00164204,0.00164204,
0.00164204,0.00164204,0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.00109469,0.000547345,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000547345,0.00136836,0.00136836,0.00136836,0.00136836,
0.00136836,0.00136836,0.00136836,0.00136836,0.00136836,0.000821018,0.000547345,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,
0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0.000273673,0.000273673,0.000273673,0.000273673,0.000273673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,};
  const double linear_table_trans_pro[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,
1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,4.52052e-05,4.52052e-05,
4.52052e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,0.000105479,0.000120547,0.000105479,9.04105e-05,
9.04105e-05,9.04105e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,4.52052e-05,4.52052e-05,6.02736e-05,9.04105e-05,9.04105e-05,
9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,
9.04105e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,9.04105e-05,9.04105e-05,9.04105e-05,6.02736e-05,
4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,
6.02736e-05,9.04105e-05,9.04105e-05,9.04105e-05,0.000120547,0.000120547,0.000120547,0.000120547,0.000135616,
0.000135616,0.000135616,0.000135616,0.000135616,0.000135616,0.000135616,0.000135616,0.000120547,0.000120547,
0.000120547,9.04105e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,4.52052e-05,
7.53421e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,0.000120547,0.000120547,0.000120547,0.000120547,
0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,
0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,9.04105e-05,0.000120547,0.000120547,0.000120547,
0.000120547,9.04105e-05,9.04105e-05,6.02736e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,
4.52052e-05,9.04105e-05,9.04105e-05,0.000120547,0.000120547,0.000120547,0.000120547,0.000135616,0.000150684,
0.000150684,0.000165753,0.000165753,0.000165753,0.000180821,0.000180821,0.000180821,0.000180821,0.000165753,
0.000165753,0.000165753,0.000150684,0.000150684,0.000135616,0.000120547,0.000120547,9.04105e-05,4.52052e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,6.02736e-05,
9.04105e-05,9.04105e-05,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000135616,0.000135616,
0.000135616,0.000135616,0.000135616,0.000135616,0.000135616,0.000150684,0.000150684,0.000150684,0.000150684,
0.000150684,0.000150684,0.000150684,0.000150684,0.000150684,0.000135616,0.000135616,0.000135616,0.000135616,
0.000150684,0.000150684,0.000135616,0.000135616,0.000120547,0.000120547,0.000120547,9.04105e-05,6.02736e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,
1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,9.04105e-05,0.000120547,0.000120547,0.000120547,
0.000135616,0.000135616,0.000150684,0.000165753,0.000165753,0.000180821,0.000180821,0.000180821,0.000210958,
0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,0.000195889,0.000180821,0.000180821,
0.000180821,0.000165753,0.000150684,0.000135616,0.000120547,0.000120547,9.04105e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,4.52052e-05,4.52052e-05,9.04105e-05,9.04105e-05,0.000120547,0.000120547,0.000135616,0.000135616,
0.000150684,0.000150684,0.000150684,0.000150684,0.000150684,0.000165753,0.000165753,0.000165753,0.000165753,
0.000165753,0.000165753,0.000180821,0.000180821,0.000180821,0.000180821,0.000180821,0.000180821,0.000180821,
0.000180821,0.000180821,0.000180821,0.000165753,0.000165753,0.000165753,0.000180821,0.000180821,0.000180821,
0.000165753,0.000150684,0.000150684,0.000135616,0.000120547,0.000120547,9.04105e-05,4.52052e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,7.53421e-05,9.04105e-05,0.000120547,0.000120547,
0.000135616,0.000150684,0.000150684,0.000165753,0.000180821,0.000180821,0.000210958,0.000210958,0.000210958,
0.000241095,0.000256163,0.0002863,0.0002863,0.0002863,0.000271231,0.000256163,0.000241095,0.000226026,
0.000210958,0.000210958,0.000210958,0.000195889,0.000180821,0.000180821,0.000150684,0.000135616,0.000120547,
0.000120547,6.02736e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,4.52052e-05,4.52052e-05,6.02736e-05,
9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,0.000120547,0.000120547,0.000135616,0.000135616,0.000150684,
0.000165753,0.000165753,0.000180821,0.000180821,0.000180821,0.000180821,0.000180821,0.000180821,0.000180821,
0.000180821,0.000180821,0.000180821,0.000195889,0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,
0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,0.000195889,0.000180821,0.000180821,0.000210958,
0.000210958,0.000195889,0.000180821,0.000180821,0.000180821,0.000165753,0.000150684,0.000135616,0.000120547,
9.04105e-05,9.04105e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,9.04105e-05,0.000120547,0.000120547,0.000135616,0.000150684,0.000165753,0.000180821,0.000180821,
0.000210958,0.000210958,0.000241095,0.0002863,0.000301368,0.000316437,0.000316437,0.000346573,0.000346573,
0.000346573,0.000346573,0.000331505,0.000316437,0.000316437,0.000301368,0.0002863,0.0002863,0.000256163,
0.000226026,0.000210958,0.000210958,0.000180821,0.000180821,0.000150684,0.000135616,0.000120547,9.04105e-05,
4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,4.52052e-05,7.53421e-05,9.04105e-05,
9.04105e-05,9.04105e-05,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,
0.000120547,0.000135616,0.000150684,0.000150684,0.000180821,0.000180821,0.000180821,0.000210958,0.000210958,
0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,
0.000226026,0.000226026,0.000241095,0.000256163,0.000256163,0.000271231,0.0002863,0.0002863,0.000271231,
0.000256163,0.000256163,0.000241095,0.000226026,0.000210958,0.0002863,0.000271231,0.000226026,0.000210958,
0.000210958,0.000195889,0.000180821,0.000180821,0.000165753,0.000135616,0.000120547,0.000120547,9.04105e-05,
4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,9.04105e-05,
0.000120547,0.000120547,0.000135616,0.000150684,0.000180821,0.000180821,0.000210958,0.000226026,0.0002863,
0.000301368,0.000346573,0.000361642,0.000391779,0.000421915,0.000421915,0.000421915,0.000421915,0.000421915,
0.000421915,0.000421915,0.000421915,0.000391779,0.00037671,0.000346573,0.000331505,0.000316437,0.000301368,
0.0002863,0.000256163,0.000210958,0.000210958,0.000180821,0.000165753,0.000150684,0.000120547,0.000105479,
6.02736e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
4.52052e-05,4.52052e-05,9.04105e-05,9.04105e-05,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,
0.000135616,0.000135616,0.000135616,0.000135616,0.000135616,0.000135616,0.000135616,0.000150684,0.000150684,
0.000165753,0.000180821,0.000180821,0.000210958,0.000210958,0.000210958,0.000226026,0.000256163,0.000271231,
0.0002863,0.0002863,0.0002863,0.0002863,0.0002863,0.0002863,0.000301368,0.000301368,0.000301368,0.000316437,
0.000316437,0.000316437,0.000346573,0.000346573,0.000346573,0.000346573,0.000346573,0.000331505,0.000316437,
0.000316437,0.000301368,0.000301368,0.000346573,0.000316437,0.000301368,0.0002863,0.000271231,0.000226026,
0.000210958,0.000210958,0.000180821,0.000165753,0.000150684,0.000135616,0.000120547,0.000120547,9.04105e-05,
4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,
9.04105e-05,0.000120547,0.000135616,0.000150684,0.000165753,0.000180821,0.000210958,0.000241095,0.0002863,
0.000316437,0.00037671,0.000421915,0.000421915,0.000436984,0.000467121,0.000512326,0.000557531,0.0005726,
0.0005726,0.0005726,0.000557531,0.000512326,0.000482189,0.000452052,0.000421915,0.000421915,0.000421915,
0.000391779,0.000361642,0.000331505,0.000301368,0.0002863,0.000241095,0.000210958,0.000180821,0.000180821,
0.000150684,0.000135616,0.000120547,9.04105e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,4.52052e-05,4.52052e-05,7.53421e-05,9.04105e-05,
9.04105e-05,9.04105e-05,9.04105e-05,0.000120547,0.000120547,0.000120547,0.000135616,0.000135616,0.000135616,
0.000150684,0.000150684,0.000150684,0.000165753,0.000165753,0.000165753,0.000165753,0.000165753,0.000165753,
0.000165753,0.000180821,0.000180821,0.000210958,0.000210958,0.000226026,0.000271231,0.0002863,0.000301368,
0.000316437,0.000316437,0.000316437,0.000331505,0.000346573,0.000346573,0.000346573,0.000361642,0.00037671,
0.000391779,0.000391779,0.000421915,0.000421915,0.000421915,0.000421915,0.000421915,0.000421915,0.000421915,
0.000421915,0.000421915,0.000421915,0.000421915,0.000391779,0.00037671,0.000421915,0.000421915,0.00037671,
0.000346573,0.000316437,0.000301368,0.0002863,0.000226026,0.000210958,0.000195889,0.000180821,0.000165753,
0.000150684,0.000120547,0.000120547,9.04105e-05,9.04105e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,
1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,7.53421e-05,9.04105e-05,0.000120547,0.000135616,0.000150684,0.000180821,
0.000210958,0.000210958,0.0002863,0.000316437,0.00037671,0.000421915,0.000436984,0.000497258,0.000587668,
0.000632873,0.000738352,0.000783557,0.000798626,0.000843831,0.000843831,0.000843831,0.000798626,0.000768489,
0.000693147,0.000602736,0.0005726,0.000512326,0.000467121,0.000421915,0.000421915,0.000421915,0.00037671,
0.000331505,0.000301368,0.0002863,0.000210958,0.000210958,0.000180821,0.000165753,0.000135616,0.000120547,
9.04105e-05,9.04105e-05,9.04105e-05,6.02736e-05,6.02736e-05,6.02736e-05,7.53421e-05,9.04105e-05,9.04105e-05,
9.04105e-05,9.04105e-05,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000135616,
0.000135616,0.000150684,0.000150684,0.000165753,0.000165753,0.000180821,0.000180821,0.000180821,0.000180821,
0.000180821,0.000180821,0.000180821,0.000180821,0.000180821,0.000195889,0.000210958,0.000210958,0.000241095,
0.0002863,0.000301368,0.000316437,0.000346573,0.000361642,0.00037671,0.000391779,0.000406847,0.000421915,
0.000421915,0.000421915,0.000421915,0.000421915,0.000436984,0.000467121,0.000482189,0.000512326,0.000542463,
0.0005726,0.000587668,0.000587668,0.000587668,0.000587668,0.000587668,0.0005726,0.000527394,0.000497258,
0.000452052,0.000421915,0.000497258,0.000436984,0.000421915,0.000421915,0.000391779,0.000346573,0.000316437,
0.0002863,0.000256163,0.000210958,0.000210958,0.000180821,0.000165753,0.000150684,0.000135616,0.000120547,
0.000120547,9.04105e-05,9.04105e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
4.52052e-05,7.53421e-05,9.04105e-05,0.000120547,0.000135616,0.000150684,0.000165753,0.000180821,0.000210958,
0.000256163,0.000301368,0.000361642,0.000421915,0.000436984,0.000512326,0.000602736,0.000768489,0.000843831,
0.000919173,0.00102465,0.00105479,0.00111506,0.00113013,0.0011452,0.00111506,0.00111506,0.00105479,0.000964378,
0.000873968,0.000798626,0.000723284,0.000602736,0.000557531,0.000497258,0.000436984,0.000421915,0.000406847,
0.000361642,0.000316437,0.0002863,0.000226026,0.000210958,0.000180821,0.000165753,0.000150684,0.000135616,
0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,
0.000135616,0.000135616,0.000135616,0.000135616,0.000150684,0.000150684,0.000150684,0.000165753,0.000165753,
0.000180821,0.000180821,0.000180821,0.000195889,0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,
0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,0.000271231,0.0002863,0.000316437,0.000346573,
0.00037671,0.000421915,0.000421915,0.000421915,0.000421915,0.000436984,0.000436984,0.000467121,0.000482189,
0.000512326,0.0005726,0.000602736,0.000602736,0.000678078,0.000768489,0.000768489,0.000798626,0.000843831,
0.000858899,0.000858899,0.000858899,0.000858899,0.000843831,0.000813694,0.000768489,0.000693147,0.000602736,
0.0005726,0.000678078,0.000587668,0.000512326,0.000467121,0.000421915,0.000421915,0.00037671,0.000346573,
0.000301368,0.0002863,0.000226026,0.000210958,0.000180821,0.000180821,0.000150684,0.000135616,0.000135616,
0.000120547,0.000120547,9.04105e-05,7.53421e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,4.52052e-05,4.52052e-05,7.53421e-05,9.04105e-05,9.04105e-05,0.000120547,0.000120547,0.000135616,
0.000150684,0.000180821,0.000195889,0.000210958,0.0002863,0.000316437,0.000391779,0.000421915,0.000497258,
0.000602736,0.000768489,0.000858899,0.00102465,0.00111506,0.00125068,0.00138629,0.00155205,0.00159725,
0.00165753,0.00167259,0.00164246,0.00156711,0.0014767,0.00134109,0.0011452,0.00105479,0.000919173,0.000843831,
0.000768489,0.000602736,0.0005726,0.000497258,0.000436984,0.000421915,0.000391779,0.000346573,0.000301368,
0.000256163,0.000210958,0.000195889,0.000180821,0.000165753,0.000150684,0.000135616,0.000135616,0.000135616,
0.000135616,0.000150684,0.000150684,0.000150684,0.000165753,0.000165753,0.000180821,0.000180821,0.000180821,
0.000180821,0.000180821,0.000180821,0.000180821,0.000180821,0.000210958,0.000210958,0.000210958,0.000210958,
0.000226026,0.000241095,0.000256163,0.000256163,0.000256163,0.000256163,0.000256163,0.000271231,0.0002863,
0.000301368,0.000316437,0.000361642,0.000421915,0.000421915,0.000421915,0.000467121,0.000497258,0.000527394,
0.0005726,0.000587668,0.000602736,0.000678078,0.000768489,0.000798626,0.000843831,0.000873968,0.000934241,
0.00100958,0.00103972,0.00108493,0.00111506,0.0011452,0.00116027,0.0011904,0.00117534,0.0011452,0.00111506,
0.00109999,0.00102465,0.000934241,0.000858899,0.000798626,0.000919173,0.000798626,0.000693147,0.000602736,
0.000512326,0.000436984,0.000421915,0.000406847,0.000346573,0.000316437,0.0002863,0.000241095,0.000210958,
0.000180821,0.000180821,0.000165753,0.000150684,0.000135616,0.000120547,0.000120547,9.04105e-05,9.04105e-05,
4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,4.52052e-05,4.52052e-05,7.53421e-05,9.04105e-05,9.04105e-05,0.000120547,0.000120547,0.000120547,
0.000135616,0.000150684,0.000165753,0.000180821,0.000210958,0.000226026,0.0002863,0.000346573,0.000421915,
0.000436984,0.0005726,0.000693147,0.000843831,0.00102465,0.0011452,0.00138629,0.00159725,0.00179314,0.00210958,
0.00232054,0.00253149,0.00265204,0.00265204,0.00251642,0.00232054,0.00210958,0.00180821,0.00159725,0.00138629,
0.00117534,0.00105479,0.000919173,0.000843831,0.000768489,0.000602736,0.000557531,0.000467121,0.000421915,
0.000421915,0.000361642,0.000316437,0.0002863,0.000241095,0.000210958,0.000195889,0.000180821,0.000180821,
0.000180821,0.000180821,0.000180821,0.000180821,0.000180821,0.000195889,0.000210958,0.000210958,0.000210958,
0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,0.000226026,0.000241095,0.000271231,
0.0002863,0.0002863,0.000301368,0.000301368,0.000301368,0.000301368,0.000301368,0.000316437,0.000316437,
0.000316437,0.000346573,0.000391779,0.000421915,0.000421915,0.000467121,0.000527394,0.000587668,0.000632873,
0.000693147,0.000768489,0.000798626,0.000843831,0.000873968,0.000934241,0.00102465,0.00109999,0.0011452,
0.00123561,0.00137123,0.0014767,0.00155205,0.00159725,0.00165753,0.00170273,0.00170273,0.0017178,0.00170273,
0.00165753,0.00156711,0.00153698,0.00138629,0.00125068,0.00113013,0.00102465,0.0011904,0.00105479,0.000919173,
0.000828763,0.000693147,0.000587668,0.000497258,0.000421915,0.000421915,0.00037671,0.000316437,0.0002863,
0.000241095,0.000210958,0.000195889,0.000180821,0.000165753,0.000150684,0.000135616,0.000135616,0.000120547,
0.000120547,9.04105e-05,6.02736e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,9.04105e-05,9.04105e-05,0.000105479,
0.000120547,0.000120547,0.000120547,0.000135616,0.000150684,0.000150684,0.000180821,0.000180821,0.000210958,
0.000241095,0.000301368,0.000361642,0.000421915,0.000497258,0.000602736,0.000798626,0.000964378,0.0011452,
0.0014315,0.00170273,0.0020493,0.00251642,0.00296848,0.00339039,0.00363149,0.00390272,0.00394792,0.00390272,
0.00370683,0.00349587,0.0031945,0.00274245,0.00230547,0.00189862,0.00156711,0.00134109,0.00113013,0.00102465,
0.000873968,0.000798626,0.000693147,0.000602736,0.000512326,0.000467121,0.000421915,0.000421915,0.000361642,
0.000316437,0.000301368,0.0002863,0.000256163,0.000226026,0.000226026,0.000226026,0.000226026,0.000256163,
0.0002863,0.0002863,0.0002863,0.0002863,0.0002863,0.000301368,0.000301368,0.000301368,0.000301368,0.000301368,
0.000301368,0.000301368,0.000316437,0.000316437,0.000346573,0.000361642,0.000361642,0.00037671,0.000391779,
0.000391779,0.000391779,0.000391779,0.000391779,0.000421915,0.000421915,0.000436984,0.000497258,0.0005726,
0.000647942,0.000768489,0.000843831,0.000873968,0.000934241,0.00102465,0.00108493,0.00113013,0.00120547,
0.00135616,0.00152191,0.00159725,0.00174794,0.00192876,0.00210958,0.00232054,0.00248629,0.00265204,0.00269725,
0.00269725,0.00269725,0.00266711,0.0026219,0.00248629,0.00232054,0.00219999,0.00203424,0.00177807,0.00159725,
0.00138629,0.00170273,0.0014767,0.00120547,0.00105479,0.000919173,0.000798626,0.000647942,0.000557531,
0.000436984,0.000421915,0.000391779,0.000316437,0.000301368,0.000256163,0.000210958,0.000210958,0.000180821,
0.000180821,0.000150684,0.000150684,0.000135616,0.000120547,0.000120547,9.04105e-05,9.04105e-05,4.52052e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,6.02736e-05,
9.04105e-05,9.04105e-05,0.000120547,0.000120547,0.000135616,0.000135616,0.000150684,0.000150684,0.000165753,
0.000180821,0.000210958,0.000210958,0.0002863,0.000316437,0.000391779,0.000436984,0.0005726,0.000768489,
0.000904105,0.00111506,0.00137123,0.00170273,0.00218492,0.00278766,0.00340546,0.0040534,0.00464107,0.00554518,
0.00613284,0.0063438,0.0062986,0.00607257,0.00557531,0.00503285,0.00444518,0.00388765,0.00328491,0.00271231,
0.00216985,0.0017178,0.00150684,0.00122054,0.00109999,0.000964378,0.000858899,0.000798626,0.000693147,
0.000602736,0.0005726,0.000497258,0.000452052,0.000421915,0.000421915,0.000421915,0.000391779,0.000361642,
0.000361642,0.000361642,0.000391779,0.000406847,0.000421915,0.000421915,0.000421915,0.000421915,0.000421915,
0.000406847,0.000391779,0.000391779,0.000406847,0.000406847,0.000406847,0.000421915,0.000421915,0.000421915,
0.000421915,0.000421915,0.000421915,0.000421915,0.000421915,0.000436984,0.000436984,0.000452052,0.000467121,
0.000512326,0.0005726,0.000602736,0.000768489,0.000813694,0.000904105,0.00102465,0.00109999,0.0011452,
0.00129588,0.00140136,0.00155205,0.00165753,0.00177807,0.0020493,0.00232054,0.00269725,0.00296848,0.00326985,
0.00349587,0.00369176,0.00390272,0.00403833,0.0040534,0.0040534,0.00397806,0.00390272,0.00375203,0.00363149,
0.00352601,0.00337532,0.00308902,0.00278766,0.00239588,0.0020493,0.00263697,0.0020493,0.00167259,0.00138629,
0.0011452,0.00102465,0.000843831,0.000693147,0.0005726,0.000467121,0.000421915,0.000391779,0.000316437,
0.000301368,0.000256163,0.000210958,0.000210958,0.000180821,0.000180821,0.000150684,0.000150684,0.000135616,
0.000120547,0.000120547,9.04105e-05,9.04105e-05,4.52052e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,4.52052e-05,9.04105e-05,9.04105e-05,0.000120547,0.000120547,0.000135616,0.000135616,0.000150684,
0.000165753,0.000165753,0.000180821,0.000180821,0.000210958,0.000226026,0.0002863,0.000346573,0.000421915,
0.000482189,0.000632873,0.000843831,0.00105479,0.00134109,0.00165753,0.00216985,0.00289313,0.00361642,
0.00444518,0.00568079,0.00699174,0.00852872,0.00961365,0.0104424,0.0106534,0.0102465,0.00940269,0.00857393,
0.007489,0.00655476,0.00556024,0.00446025,0.00363149,0.00299861,0.00236574,0.00189862,0.00159725,0.00137123,
0.00116027,0.00108493,0.000964378,0.000889036,0.000843831,0.000798626,0.000768489,0.000768489,0.000693147,
0.000678078,0.000602736,0.000587668,0.0005726,0.000557531,0.0005726,0.000587668,0.000602736,0.000632873,
0.000678078,0.00066301,0.000602736,0.000602736,0.0005726,0.000527394,0.000497258,0.000497258,0.000497258,
0.000497258,0.000497258,0.000497258,0.000512326,0.000542463,0.000557531,0.0005726,0.0005726,0.000587668,
0.000587668,0.000602736,0.000632873,0.000693147,0.000768489,0.000843831,0.000889036,0.00102465,0.00111506,
0.00122054,0.00138629,0.00155205,0.00170273,0.00189862,0.00210958,0.00232054,0.00268218,0.00299861,0.00342053,
0.00382738,0.00418902,0.00464107,0.00531915,0.00568079,0.00614791,0.00635887,0.00640407,0.00641914,0.00640407,
0.0063438,0.00616298,0.00587668,0.00568079,0.0054849,0.00510819,0.00455066,0.00412874,0.00361642,0.00311916,
0.00375203,0.00304382,0.00241095,0.00189862,0.00155205,0.00123561,0.00105479,0.000873968,0.000768489,
0.0005726,0.000467121,0.000421915,0.00037671,0.000316437,0.0002863,0.000241095,0.000210958,0.000210958,
0.000180821,0.000180821,0.000150684,0.000135616,0.000120547,0.000120547,0.000120547,9.04105e-05,9.04105e-05,
4.52052e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,9.04105e-05,9.04105e-05,0.000120547,0.000120547,
0.000135616,0.000150684,0.000165753,0.000165753,0.000180821,0.000180821,0.000210958,0.000210958,0.000271231,
0.000301368,0.000361642,0.000421915,0.000557531,0.000768489,0.00094931,0.0011904,0.00156711,0.0020493,
0.00277259,0.00358628,0.00455066,0.00616298,0.00786571,0.0104273,0.0132451,0.0151438,0.0166205,0.0173437,
0.0172081,0.0161985,0.0149027,0.0135314,0.0119191,0.00962871,0.00789585,0.00640407,0.00498764,0.00403833,
0.00328491,0.00265204,0.00210958,0.001763,0.00156711,0.00137123,0.00120547,0.00113013,0.00111506,0.00109999,
0.00109999,0.00111506,0.00111506,0.00111506,0.00111506,0.00109999,0.00105479,0.00105479,0.00105479,0.00105479,
0.00111506,0.00111506,0.0011452,0.0011452,0.00111506,0.00105479,0.000964378,0.000873968,0.000843831,0.000798626,
0.000798626,0.000783557,0.000768489,0.000768489,0.000768489,0.000783557,0.000798626,0.000798626,0.000798626,
0.000798626,0.000843831,0.000858899,0.000889036,0.000964378,0.00103972,0.00111506,0.00120547,0.00138629,
0.00159725,0.00177807,0.00207944,0.0023356,0.00271231,0.00299861,0.00337532,0.00367669,0.00408354,0.00459587,
0.00556024,0.00640407,0.00738352,0.00827256,0.00898077,0.00961365,0.0102465,0.0106835,0.011015,0.011015,
0.0106835,0.0104273,0.0101561,0.0097794,0.00947803,0.00902598,0.00852872,0.00753421,0.00669037,0.00565065,
0.00453559,0.00566572,0.0042945,0.0034356,0.00269725,0.0020493,0.00159725,0.00129588,0.00105479,0.000858899,
0.000693147,0.000557531,0.000436984,0.000421915,0.000361642,0.000316437,0.0002863,0.000226026,0.000210958,
0.000195889,0.000180821,0.000165753,0.000150684,0.000135616,0.000120547,0.000120547,0.000120547,9.04105e-05,
9.04105e-05,6.02736e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,9.04105e-05,0.000120547,0.000120547,0.000135616,0.000150684,
0.000150684,0.000165753,0.000180821,0.000180821,0.000210958,0.000210958,0.000226026,0.0002863,0.000316437,
0.000391779,0.000421915,0.000587668,0.000798626,0.00105479,0.00138629,0.00186848,0.00265204,0.0034356,
0.00441504,0.0060123,0.00786571,0.0108191,0.0145259,0.0177807,0.0212917,0.0239738,0.0256916,0.0262793,
0.0255711,0.0239738,0.0216232,0.0188807,0.0161985,0.0141794,0.0117835,0.00883009,0.0069164,0.00536435,
0.00415888,0.0034356,0.0029082,0.00239588,0.0020493,0.00177807,0.00161232,0.00156711,0.00155205,0.00156711,
0.00167259,0.00177807,0.00194382,0.0020493,0.00210958,0.00218492,0.00218492,0.00218492,0.00216985,0.00218492,
0.00227533,0.00232054,0.00241095,0.00239588,0.00226026,0.00198903,0.00170273,0.00155205,0.00135616,0.00122054,
0.0011452,0.00111506,0.00111506,0.00109999,0.00108493,0.00105479,0.00105479,0.00108493,0.00108493,0.00109999,
0.00111506,0.0011452,0.00120547,0.00134109,0.0014767,0.00156711,0.00177807,0.00210958,0.00248629,0.00292327,
0.00333012,0.00370683,0.00412874,0.00455066,0.00528901,0.00584654,0.00670544,0.00786571,0.00944789,0.0117383,
0.0132753,0.0146917,0.0157164,0.0163342,0.016967,0.0173287,0.0175547,0.0175095,0.0172383,0.0169972,0.0166958,
0.01653,0.0161081,0.015415,0.0146164,0.0130492,0.0111808,0.0089657,0.00718763,0.00870954,0.00656983,0.00485203,
0.00370683,0.00289313,0.00210958,0.00159725,0.00125068,0.00102465,0.000843831,0.000647942,0.000497258,
0.000421915,0.000391779,0.000346573,0.000301368,0.0002863,0.000210958,0.000210958,0.000180821,0.000180821,
0.000165753,0.000150684,0.000135616,0.000120547,0.000120547,0.000120547,9.04105e-05,9.04105e-05,7.53421e-05,
4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,
9.04105e-05,0.000120547,0.000120547,0.000135616,0.000150684,0.000165753,0.000180821,0.000180821,0.000210958,
0.000210958,0.000210958,0.000271231,0.000301368,0.000346573,0.000406847,0.000436984,0.000602736,0.000843831,
0.00111506,0.00156711,0.00227533,0.00325478,0.00417395,0.00568079,0.00744379,0.0102767,0.0140739,0.0177958,
0.0222259,0.0272889,0.0313724,0.0343108,0.0362245,0.0363299,0.0350943,0.0322163,0.0294587,0.0252999,0.021578,
0.0182931,0.0150081,0.012326,0.00905611,0.00694654,0.0054849,0.00426436,0.00361642,0.00317943,0.00274245,
0.00241095,0.00219999,0.00216985,0.00226026,0.00250136,0.00283286,0.00325478,0.00361642,0.00397806,0.00417395,
0.00446025,0.00455066,0.004626,0.00470134,0.00492737,0.00513833,0.00536435,0.00537942,0.00524381,0.00464107,
0.00415888,0.00361642,0.00311916,0.00268218,0.00230547,0.00203424,0.00186848,0.00174794,0.00165753,0.00159725,
0.00156711,0.00155205,0.00155205,0.00155205,0.00156711,0.00161232,0.00170273,0.00177807,0.00197396,0.00218492,
0.00248629,0.00289313,0.00334519,0.00378217,0.0042945,0.00504792,0.00595202,0.00675065,0.00754927,0.00860406,
0.00962871,0.0118136,0.0139383,0.0160931,0.0188054,0.0213971,0.0233862,0.0247574,0.0257067,0.0262642,
0.0264451,0.0267766,0.0268519,0.0267163,0.0263999,0.0261738,0.0257218,0.0250136,0.0238684,0.0220752,0.0199054,
0.0172081,0.0146314,0.0119342,0.0140739,0.0101862,0.00721777,0.00530408,0.00382738,0.00289313,0.0020493,
0.00155205,0.0011452,0.000934241,0.000768489,0.000587668,0.000436984,0.000421915,0.000361642,0.000316437,
0.0002863,0.000241095,0.000210958,0.000210958,0.000180821,0.000165753,0.000150684,0.000135616,0.000120547,
0.000120547,0.000120547,0.000120547,9.04105e-05,9.04105e-05,6.02736e-05,4.52052e-05,4.52052e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,9.04105e-05,0.000120547,0.000120547,0.000135616,0.000150684,
0.000165753,0.000180821,0.000195889,0.000210958,0.000210958,0.000241095,0.0002863,0.000316437,0.000361642,
0.000421915,0.000467121,0.000602736,0.000843831,0.00111506,0.00165753,0.00263697,0.00378217,0.00542463,
0.00738352,0.00976433,0.0132602,0.0168917,0.0215026,0.0269725,0.0324574,0.0385149,0.0435025,0.0477819,
0.049349,0.0487614,0.0458682,0.0414833,0.036571,0.0316135,0.0267766,0.0222259,0.0185944,0.0149027,0.0119191,
0.00861913,0.00667531,0.00537942,0.00443011,0.00382738,0.00342053,0.00313423,0.00299861,0.00301368,0.00329998,
0.00370683,0.0042945,0.00530408,0.0063438,0.00724791,0.00833283,0.00923694,0.0102616,0.0111205,0.0119492,
0.0125821,0.0131246,0.0135314,0.0132753,0.0125972,0.0111356,0.00923694,0.00754927,0.0063438,0.00509312,
0.00415888,0.00367669,0.00334519,0.00299861,0.00278766,0.00263697,0.00242601,0.00232054,0.00232054,0.00232054,
0.00242601,0.00260684,0.00272738,0.00296848,0.00320957,0.00345067,0.00385751,0.00432463,0.00509312,0.0060123,
0.00694654,0.00813694,0.00961365,0.0117232,0.0131095,0.0145712,0.0158218,0.0181574,0.021156,0.0246821,
0.0291272,0.0321108,0.0353505,0.0371738,0.0382436,0.0387409,0.0389217,0.0391025,0.0393135,0.0393436,0.0391929,
0.0388916,0.0383792,0.0373546,0.0356519,0.0325026,0.029519,0.0254053,0.0214423,0.0174643,0.0199355,0.0149931,
0.0108191,0.00738352,0.0051534,0.00363149,0.00268218,0.00179314,0.00137123,0.00105479,0.000843831,0.000602736,
0.000497258,0.000421915,0.000391779,0.000346573,0.000301368,0.0002863,0.000210958,0.000210958,0.000180821,
0.000180821,0.000150684,0.000135616,0.000135616,0.000120547,0.000120547,0.000120547,9.04105e-05,9.04105e-05,
9.04105e-05,6.02736e-05,4.52052e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,9.04105e-05,0.000120547,
0.000120547,0.000135616,0.000150684,0.000180821,0.000180821,0.000210958,0.000210958,0.000241095,0.0002863,
0.000301368,0.000346573,0.000391779,0.000421915,0.000512326,0.000678078,0.000873968,0.00113013,0.00165753,
0.00275752,0.00417395,0.00653969,0.00952324,0.0134712,0.0167711,0.0210506,0.0262492,0.0319149,0.0388916,
0.0466217,0.0541257,0.0598065,0.0626092,0.0632873,0.0615394,0.0578175,0.0516244,0.0439998,0.0370984,0.0312067,
0.0257971,0.0212766,0.0171328,0.013667,0.0101862,0.00771503,0.00640407,0.00530408,0.00446025,0.0040534,
0.00375203,0.00370683,0.00393286,0.00441504,0.00533422,0.00652462,0.00819722,0.0104273,0.0129136,0.0150533,
0.0174342,0.0196191,0.0214423,0.0232054,0.0247725,0.0263094,0.0268519,0.0263547,0.0246519,0.02203,0.0189259,
0.0157766,0.0129136,0.0100657,0.00788078,0.00641914,0.00554518,0.00461093,0.00415888,0.00390272,0.00361642,
0.00349587,0.00349587,0.00355614,0.00363149,0.00387258,0.00408354,0.00438491,0.00465614,0.00537942,0.00616298,
0.00696161,0.0080616,0.00940269,0.0114821,0.0135314,0.0153547,0.0175396,0.0197547,0.0216382,0.0238382,
0.0268368,0.0309505,0.0358477,0.0415587,0.0477217,0.0525285,0.0555572,0.0570038,0.0578476,0.0580586,0.0581942,
0.0582545,0.0587367,0.0591284,0.0590531,0.0583147,0.0566572,0.0536887,0.0485504,0.0420258,0.0362245,0.0307848,
0.0250889,0.0271834,0.0206889,0.0148575,0.0102315,0.00682599,0.00455066,0.00328491,0.00224519,0.00156711,
0.00113013,0.000889036,0.000693147,0.000512326,0.000421915,0.000406847,0.000346573,0.000316437,0.0002863,
0.000226026,0.000210958,0.000180821,0.000180821,0.000150684,0.000150684,0.000135616,0.000120547,0.000120547,
0.000120547,0.000120547,9.04105e-05,9.04105e-05,9.04105e-05,6.02736e-05,4.52052e-05,4.52052e-05,4.52052e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,
9.04105e-05,0.000120547,0.000120547,0.000135616,0.000165753,0.000180821,0.000180821,0.000210958,0.000210958,
0.000271231,0.000301368,0.000316437,0.00037671,0.000421915,0.000452052,0.0005726,0.000768489,0.000934241,
0.0011452,0.00165753,0.00271231,0.00441504,0.00736845,0.0120547,0.0166054,0.0216382,0.0267314,0.0320656,
0.0391025,0.0473148,0.0561298,0.0647188,0.0731873,0.0787626,0.0807817,0.0796215,0.0751914,0.0679284,0.0597462,
0.0505093,0.0412724,0.0338286,0.0282231,0.0228588,0.0183383,0.0146314,0.0112561,0.00860406,0.00694654,
0.00589175,0.00509312,0.00453559,0.0042945,0.00443011,0.00479175,0.00574106,0.00709722,0.00911639,0.012326,
0.0152643,0.0188657,0.0228588,0.0267314,0.0305437,0.0336327,0.037234,0.0407148,0.0429148,0.0440902,0.0430806,
0.040534,0.0361642,0.0314176,0.0263547,0.0214725,0.0172383,0.0141342,0.0111657,0.00876981,0.00732325,
0.00640407,0.00563559,0.00513833,0.00483696,0.00471641,0.00495751,0.00533422,0.00571093,0.0063438,0.00688626,
0.00751914,0.00852872,0.00961365,0.0114369,0.0130492,0.0147369,0.0168163,0.019393,0.0220903,0.0250286,
0.0282834,0.0309505,0.0335875,0.0377464,0.0435778,0.0518353,0.0597312,0.0668133,0.0739407,0.0791544,0.0818667,
0.0833132,0.0838406,0.0845489,0.0855132,0.0867639,0.0877886,0.0882557,0.0868694,0.0825598,0.0774064,0.0696763,
0.0606353,0.0517148,0.0417094,0.0338135,0.034145,0.026204,0.0188506,0.0133657,0.00860406,0.00568079,0.00381231,
0.00266711,0.0017178,0.00122054,0.000934241,0.000768489,0.000557531,0.000421915,0.000421915,0.000361642,
0.000316437,0.0002863,0.000241095,0.000210958,0.000180821,0.000180821,0.000165753,0.000150684,0.000135616,
0.000120547,0.000120547,0.000120547,0.000120547,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,4.52052e-05,
4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,7.53421e-05,9.04105e-05,0.000120547,0.000135616,0.000165753,0.000180821,0.000180821,0.000210958,
0.000226026,0.0002863,0.000301368,0.000346573,0.000391779,0.000421915,0.000497258,0.000602736,0.000798626,
0.00102465,0.00125068,0.00170273,0.00269725,0.00427943,0.00747393,0.0131397,0.0192876,0.0262492,0.0328793,
0.0405943,0.0492436,0.0583901,0.0679284,0.0785818,0.0888886,0.0941022,0.0970104,0.0967844,0.0934241,0.0873666,
0.0765475,0.0648243,0.0541709,0.0432614,0.0351998,0.0290218,0.0231752,0.0184588,0.0146616,0.0115424,0.00873968,
0.00721777,0.00623832,0.00553011,0.00498764,0.00477669,0.00510819,0.00580134,0.00696161,0.00881502,0.012115,
0.015415,0.0197848,0.0246369,0.0301368,0.0354108,0.0410011,0.0472696,0.0534326,0.0585257,0.061886,0.063212,
0.0622024,0.0585257,0.0526189,0.0444819,0.0369628,0.0306944,0.024667,0.0199656,0.0159876,0.0131999,0.0106534,
0.00872461,0.00753421,0.00694654,0.0065849,0.00649448,0.00685613,0.00738352,0.0081068,0.00911639,0.0104575,
0.012115,0.0135917,0.0149479,0.0166958,0.01873,0.0208848,0.023356,0.0265656,0.0304081,0.0340094,0.0383642,
0.0422518,0.0475258,0.0537038,0.0611325,0.0706106,0.081068,0.0908625,0.0980351,0.10358,0.107408,0.109819,
0.111356,0.112667,0.114399,0.116117,0.117262,0.117232,0.115183,0.111356,0.104138,0.0952926,0.0835242,
0.0691188,0.0561901,0.0441052,0.0413176,0.0311464,0.0221807,0.0153848,0.0102013,0.00647942,0.00417395,
0.00296848,0.00189862,0.00134109,0.000964378,0.000768489,0.000557531,0.000436984,0.000421915,0.000361642,
0.000316437,0.0002863,0.000241095,0.000210958,0.000180821,0.000180821,0.000165753,0.000150684,0.000135616,
0.000120547,0.000120547,0.000120547,0.000120547,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,7.53421e-05,
6.02736e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,
4.52052e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
4.52052e-05,9.04105e-05,0.000120547,0.000135616,0.000150684,0.000180821,0.000180821,0.000210958,0.000241095,
0.0002863,0.000316437,0.00037671,0.000421915,0.000436984,0.000542463,0.000678078,0.000843831,0.00105479,
0.00138629,0.00192876,0.00296848,0.00446025,0.00757941,0.0137123,0.0210807,0.0298505,0.0388916,0.0493038,
0.0599421,0.0708969,0.0832078,0.0936954,0.101441,0.108613,0.112877,0.11336,0.110045,0.102676,0.0937255,
0.0813845,0.0670092,0.0546833,0.0427792,0.0340395,0.0276656,0.0218944,0.0172533,0.0139383,0.0106986,0.00852872,
0.00702188,0.00622325,0.00557531,0.00525888,0.0051986,0.00557531,0.00640407,0.0077753,0.0102465,0.0139081,
0.0178109,0.0229793,0.0291875,0.0352902,0.0419505,0.0502682,0.0581942,0.0654722,0.0730667,0.0782352,0.0801338,
0.0785215,0.0733229,0.0649901,0.0562353,0.0467723,0.0377614,0.0309957,0.0249081,0.0203273,0.0163342,0.0138931,
0.011678,0.00962871,0.00869447,0.00827256,0.00827256,0.00872461,0.00973419,0.0114369,0.0130492,0.0147068,
0.0164848,0.0187451,0.0209752,0.0231451,0.025119,0.0276957,0.0309505,0.0346423,0.0399162,0.0456874,0.0523778,
0.0582545,0.0644325,0.0731421,0.0834187,0.0939063,0.103158,0.113134,0.122612,0.130447,0.136203,0.140543,
0.144822,0.149132,0.15299,0.15644,0.157736,0.157073,0.152869,0.144898,0.133416,0.119568,0.104514,0.089657,
0.0704298,0.0551504,0.047586,0.0342957,0.0245615,0.0166807,0.011241,0.00700681,0.00450545,0.00308902,
0.00203424,0.00137123,0.00100958,0.000768489,0.000557531,0.000421915,0.000421915,0.000361642,0.000316437,
0.0002863,0.000226026,0.000210958,0.000180821,0.000180821,0.000150684,0.000135616,0.000135616,0.000120547,
0.000120547,0.000120547,0.000120547,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,7.53421e-05,
6.02736e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,
4.52052e-05,4.52052e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,9.04105e-05,
0.000120547,0.000135616,0.000150684,0.000180821,0.000180821,0.000210958,0.000256163,0.000301368,0.000346573,
0.000391779,0.000421915,0.000467121,0.000587668,0.000768489,0.000889036,0.00111506,0.00155205,0.00221506,
0.00339039,0.00512326,0.00852872,0.0146314,0.022256,0.0320204,0.0434121,0.0570038,0.070701,0.0856338,
0.0966488,0.106941,0.116931,0.124977,0.130854,0.132301,0.128955,0.120879,0.109638,0.0964529,0.0816256,
0.0651709,0.0519107,0.0400669,0.0315231,0.0247273,0.0194232,0.0151136,0.012115,0.00923694,0.00754927,
0.00649448,0.00581641,0.00536435,0.00509312,0.00516846,0.00565065,0.00649448,0.0080616,0.0106684,0.0145259,
0.0187752,0.0242752,0.0309053,0.0376409,0.045823,0.05506,0.0632572,0.0729462,0.0809776,0.0873214,0.0896269,
0.0878639,0.081505,0.0729462,0.0622627,0.0526942,0.0421915,0.0343258,0.0284944,0.0230547,0.0187602,0.0154451,
0.0132753,0.0117383,0.0102465,0.00962871,0.0097794,0.0107588,0.0123862,0.0142095,0.0160177,0.0185341,
0.0212917,0.0239889,0.0268218,0.0295793,0.0317341,0.0346121,0.0388916,0.044271,0.0517148,0.0593545,0.0673709,
0.0768338,0.0876981,0.0964529,0.106714,0.117579,0.128925,0.140844,0.153276,0.164396,0.174326,0.18272,
0.190148,0.197336,0.204192,0.208245,0.208833,0.205533,0.197562,0.184995,0.16735,0.146375,0.123938,0.103158,
0.0837954,0.0631366,0.05066,0.035893,0.0252245,0.0169821,0.011241,0.00700681,0.00450545,0.00308902,0.00198903,
0.00134109,0.000964378,0.000723284,0.000512326,0.000421915,0.000406847,0.000346573,0.000301368,0.0002863,
0.000210958,0.000210958,0.000180821,0.000180821,0.000150684,0.000135616,0.000120547,0.000120547,0.000120547,
0.000120547,0.000120547,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,7.53421e-05,
7.53421e-05,7.53421e-05,7.53421e-05,7.53421e-05,7.53421e-05,6.02736e-05,4.52052e-05,4.52052e-05,4.52052e-05,
4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,9.04105e-05,0.000105479,0.000120547,
0.000135616,0.000165753,0.000180821,0.000210958,0.000241095,0.000301368,0.000346573,0.000406847,0.000421915,
0.000512326,0.000647942,0.000813694,0.000964378,0.0011904,0.00161232,0.00242601,0.00375203,0.00614791,
0.0101862,0.016289,0.0246519,0.0351094,0.0487764,0.0639805,0.0822132,0.0978392,0.110949,0.122446,0.132979,
0.143466,0.151618,0.155566,0.15299,0.14327,0.12876,0.11238,0.0954132,0.0779338,0.060349,0.0458682,0.0349286,
0.0271834,0.0208848,0.0158369,0.0124616,0.00938762,0.00757941,0.00643421,0.005726,0.00528901,0.00477669,
0.00459587,0.00468628,0.00536435,0.00637394,0.00757941,0.0100657,0.013878,0.0180218,0.0234766,0.0300615,
0.0367519,0.0450244,0.0542463,0.0626092,0.072027,0.0802393,0.086568,0.0889639,0.0871708,0.081053,0.0725544,
0.0622627,0.0529052,0.0426285,0.0351847,0.0292327,0.023567,0.0193177,0.0160177,0.0140287,0.0122808,0.0111205,
0.0106082,0.011015,0.0122506,0.0139986,0.015867,0.018715,0.0216382,0.0248779,0.0287656,0.0317039,0.0347176,
0.0379875,0.0417696,0.0479326,0.0552559,0.0632421,0.0743174,0.0870653,0.0972817,0.108462,0.120984,0.134591,
0.149253,0.163221,0.177009,0.192348,0.207748,0.222982,0.236921,0.249638,0.260186,0.268775,0.272482,0.269227,
0.25993,0.245751,0.225604,0.199521,0.170906,0.140829,0.114279,0.0920529,0.0688325,0.0499819,0.0349135,
0.0241697,0.0159273,0.0102465,0.00647942,0.00418902,0.00295341,0.00183835,0.00123561,0.000904105,0.000647942,
0.000482189,0.000421915,0.000391779,0.000331505,0.000301368,0.000256163,0.000210958,0.000210958,0.000180821,
0.000165753,0.000150684,0.000135616,0.000120547,0.000120547,0.000120547,0.000120547,9.04105e-05,9.04105e-05,
9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,
9.04105e-05,9.04105e-05,9.04105e-05,7.53421e-05,6.02736e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,
4.52052e-05,4.52052e-05,7.53421e-05,9.04105e-05,0.000120547,0.000135616,0.000150684,0.000180821,0.000210958,
0.000226026,0.0002863,0.000346573,0.000421915,0.000436984,0.0005726,0.000768489,0.000919173,0.00109999,
0.00137123,0.00177807,0.00269725,0.00403833,0.00666024,0.0121903,0.0196643,0.0293533,0.0402779,0.0552408,
0.0727654,0.0928515,0.109894,0.125957,0.141718,0.156184,0.167109,0.175562,0.180459,0.179691,0.171479,
0.155174,0.132783,0.111461,0.0913296,0.0699024,0.0529203,0.0383792,0.029082,0.0214423,0.0158068,0.0120698,
0.00878488,0.00702188,0.00611777,0.00530408,0.00461093,0.00441504,0.00415888,0.00415888,0.00423422,0.004626,
0.00557531,0.00681092,0.00864927,0.0119945,0.0157314,0.0208848,0.0265807,0.0327587,0.0400669,0.0481888,
0.056175,0.0634079,0.0705955,0.0758393,0.0781598,0.0765023,0.0718763,0.0641462,0.056175,0.047586,0.0392683,
0.032382,0.0271382,0.0220903,0.0183383,0.0153396,0.0134712,0.0119945,0.0108493,0.010578,0.0111958,0.0126123,
0.0146013,0.0168314,0.0199807,0.0235218,0.0275601,0.0314478,0.0353806,0.0392532,0.0432614,0.0492586,0.0562805,
0.0650202,0.076864,0.090757,0.102782,0.116961,0.132707,0.150925,0.170047,0.188988,0.206678,0.225469,0.244575,
0.262838,0.283663,0.303945,0.321846,0.336794,0.344253,0.342836,0.332545,0.314719,0.290052,0.258755,0.224338,
0.187421,0.151754,0.119432,0.094283,0.0694955,0.0456121,0.0316437,0.0214122,0.0141191,0.0086342,0.00568079,
0.00379724,0.0025767,0.00165753,0.00111506,0.000843831,0.000587668,0.000436984,0.000421915,0.000361642,
0.000316437,0.0002863,0.000226026,0.000210958,0.000180821,0.000180821,0.000150684,0.000135616,0.000120547,
0.000120547,0.000120547,0.000120547,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,
9.04105e-05,7.53421e-05,7.53421e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,
9.04105e-05,7.53421e-05,6.02736e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,9.04105e-05,
0.000120547,0.000120547,0.000135616,0.000165753,0.000180821,0.000210958,0.0002863,0.000316437,0.000406847,
0.000436984,0.000587668,0.000798626,0.00102465,0.00122054,0.00156711,0.00210958,0.00299861,0.00423422,
0.00721777,0.0133657,0.0221807,0.033919,0.0490929,0.0656229,0.0868845,0.103821,0.122732,0.142186,0.16307,
0.182644,0.198978,0.209752,0.215297,0.214589,0.205804,0.187692,0.162392,0.132798,0.106519,0.0822585,0.0600476,
0.0424025,0.0306039,0.0216382,0.0153848,0.0108945,0.00766982,0.00616298,0.00503285,0.00441504,0.0040534,
0.00378217,0.00363149,0.00358628,0.00358628,0.00369176,0.0040534,0.00455066,0.00559038,0.00696161,0.00901091,
0.0126424,0.0163794,0.0213971,0.0267464,0.0320505,0.0381231,0.044271,0.0507655,0.0558737,0.059701,0.060801,
0.0600476,0.0566572,0.051534,0.0446176,0.0382738,0.0323217,0.0276656,0.0230396,0.0188807,0.0157314,0.0136218,
0.0119342,0.0104273,0.00959858,0.00958351,0.0104273,0.0120849,0.0141794,0.0165753,0.0199807,0.0238382,
0.0284793,0.0322464,0.0369327,0.0415587,0.0475559,0.0546682,0.0630312,0.0755982,0.0904255,0.103309,0.119327,
0.137936,0.160554,0.18495,0.211395,0.237659,0.26103,0.28532,0.309068,0.333193,0.360436,0.389714,0.414502,
0.428907,0.430203,0.418857,0.394883,0.362094,0.322419,0.280197,0.235926,0.191836,0.152688,0.118197,0.0917516,
0.0651709,0.0388916,0.0264903,0.0172684,0.0110451,0.00693147,0.00452052,0.00323971,0.00210958,0.00138629,
0.00100958,0.000738352,0.000497258,0.000421915,0.000391779,0.000316437,0.000301368,0.000256163,0.000210958,
0.000195889,0.000180821,0.000165753,0.000150684,0.000135616,0.000120547,0.000120547,0.000120547,9.04105e-05,
9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,7.53421e-05,6.02736e-05,6.02736e-05,6.02736e-05,6.02736e-05,
7.53421e-05,7.53421e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,7.53421e-05,6.02736e-05,
4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,9.04105e-05,9.04105e-05,0.000120547,0.000135616,0.000150684,
0.000180821,0.000210958,0.000241095,0.000301368,0.000391779,0.000421915,0.000587668,0.000798626,0.00105479,
0.00138629,0.00179314,0.00251642,0.0034356,0.00494244,0.00831776,0.0149328,0.0247273,0.038319,0.0575915,
0.0809776,0.102993,0.123998,0.145696,0.167365,0.189139,0.212645,0.236318,0.254174,0.262642,0.262492,0.252125,
0.231029,0.200033,0.164291,0.128564,0.0984871,0.0701736,0.0485504,0.0325628,0.0221506,0.0148424,0.00961365,
0.0065849,0.0048671,0.0040534,0.00357121,0.00328491,0.00301368,0.00296848,0.00295341,0.0029082,0.00296848,
0.00304382,0.00334519,0.00375203,0.00423422,0.00530408,0.00653969,0.00854379,0.0119191,0.0151438,0.0191519,
0.023341,0.0276656,0.0315533,0.0352902,0.0383792,0.0407601,0.0414683,0.0409861,0.0388916,0.0356519,0.0318094,
0.0283135,0.0243355,0.0208396,0.0172985,0.0146616,0.0124013,0.0104273,0.00902598,0.00833283,0.00795612,
0.00813694,0.00883009,0.0104273,0.0127479,0.015189,0.018715,0.0226026,0.0272588,0.0317039,0.036571,0.0419203,
0.0492888,0.0580586,0.0694202,0.0856941,0.10013,0.117097,0.136776,0.162,0.19057,0.224082,0.258453,0.292674,
0.323278,0.355735,0.390724,0.425969,0.460687,0.496278,0.522301,0.53083,0.5176,0.488473,0.446372,0.39541,
0.340064,0.285124,0.232641,0.184302,0.143255,0.110617,0.083042,0.0578928,0.0311765,0.0204177,0.0129136,
0.00780544,0.00521367,0.00358628,0.00248629,0.00165753,0.00111506,0.000843831,0.000587668,0.000436984,
0.000421915,0.000346573,0.000301368,0.000271231,0.000210958,0.000210958,0.000180821,0.000165753,0.000150684,
0.000135616,0.000120547,0.000120547,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,6.02736e-05,
4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,6.02736e-05,7.53421e-05,
7.53421e-05,9.04105e-05,7.53421e-05,7.53421e-05,7.53421e-05,6.02736e-05,4.52052e-05,4.52052e-05,4.52052e-05,
6.02736e-05,9.04105e-05,0.000120547,0.000120547,0.000135616,0.000165753,0.000180821,0.000210958,0.0002863,
0.000346573,0.000421915,0.000527394,0.000768489,0.00105479,0.0014767,0.00210958,0.00301368,0.00408354,
0.00599723,0.010126,0.0179615,0.0295642,0.0446025,0.0669339,0.0964378,0.125218,0.157118,0.185839,0.211108,
0.233545,0.256449,0.283,0.307531,0.32275,0.325026,0.312896,0.286345,0.248433,0.204704,0.160027,0.119447,
0.0881502,0.057049,0.0364656,0.0236574,0.0147821,0.00878488,0.00566572,0.00399313,0.00320957,0.00269725,
0.00232054,0.00218492,0.00210958,0.00210958,0.00210958,0.00212465,0.00219999,0.00232054,0.00260684,0.0029082,
0.00329998,0.0037671,0.00444518,0.00557531,0.00702188,0.00911639,0.0121903,0.0147369,0.0172985,0.0199807,
0.0220752,0.0238533,0.0249985,0.0254204,0.0248629,0.0236725,0.0218944,0.0199807,0.0178109,0.015641,0.0137273,
0.0117835,0.00947803,0.00816708,0.00724791,0.0066301,0.00637394,0.0062986,0.00641914,0.00717256,0.0083931,
0.0102465,0.0130492,0.0160177,0.0199807,0.0243958,0.029519,0.0343258,0.0408354,0.0492586,0.0599421,0.0745585,
0.0930625,0.110693,0.130462,0.156154,0.186728,0.223856,0.26531,0.30958,0.350205,0.391944,0.437481,0.488653,
0.539494,0.582484,0.616057,0.634064,0.626047,0.591284,0.53853,0.47586,0.407872,0.337969,0.27316,0.215584,
0.166913,0.127343,0.0974173,0.0691941,0.0471943,0.0229191,0.0144355,0.00842324,0.00545476,0.00370683,
0.00265204,0.001763,0.00123561,0.000904105,0.000647942,0.000467121,0.000421915,0.000361642,0.000301368,
0.000271231,0.000210958,0.000210958,0.000180821,0.000165753,0.000150684,0.000135616,0.000120547,0.000120547,
9.04105e-05,9.04105e-05,7.53421e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,
4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,6.02736e-05,6.02736e-05,
6.02736e-05,6.02736e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,9.04105e-05,9.04105e-05,
0.000120547,0.000120547,0.000150684,0.000165753,0.000195889,0.000226026,0.000316437,0.000406847,0.000467121,
0.000693147,0.000964378,0.00138629,0.00218492,0.00342053,0.00479175,0.0072027,0.012778,0.02203,0.0359834,
0.0569737,0.0859804,0.116554,0.157827,0.205021,0.248553,0.282307,0.306145,0.325297,0.347462,0.37665,0.403291,
0.412136,0.395651,0.357468,0.307365,0.251522,0.196191,0.14645,0.106293,0.0706106,0.0429299,0.0264451,
0.0155807,0.00860406,0.00498764,0.00337532,0.00241095,0.00189862,0.00164246,0.00155205,0.0014767,0.0014767,
0.00152191,0.00155205,0.00156711,0.00162739,0.00170273,0.00186848,0.0020493,0.00232054,0.00269725,0.00304382,
0.00358628,0.00415888,0.00528901,0.00641914,0.00783557,0.009252,0.011015,0.0122808,0.0130492,0.0135314,
0.0135465,0.0131095,0.0124013,0.0115575,0.0103972,0.00914653,0.00816708,0.00726297,0.00641914,0.005726,
0.00516846,0.00461093,0.00444518,0.00436984,0.00446025,0.00471641,0.00549997,0.00640407,0.00757941,0.00962871,
0.0128835,0.0161533,0.0205985,0.0253149,0.031056,0.0376861,0.047586,0.0603038,0.078416,0.0989543,0.119809,
0.14529,0.175803,0.213293,0.258107,0.31065,0.365484,0.416822,0.47033,0.529429,0.600778,0.667787,0.712495,
0.73463,0.731511,0.698059,0.635812,0.557471,0.476388,0.393632,0.31612,0.247107,0.18941,0.143858,0.109246,
0.0803598,0.0547134,0.0356519,0.0151438,0.00861913,0.00536435,0.00361642,0.00253149,0.0017178,0.00126575,
0.000934241,0.000693147,0.000497258,0.000421915,0.000361642,0.000301368,0.000271231,0.000210958,0.000210958,
0.000180821,0.000165753,0.000150684,0.000135616,0.000120547,9.04105e-05,9.04105e-05,4.52052e-05,4.52052e-05,
4.52052e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,
4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,6.02736e-05,9.04105e-05,9.04105e-05,0.000120547,0.000135616,
0.000150684,0.000180821,0.000210958,0.0002863,0.000361642,0.000421915,0.000587668,0.000858899,0.00125068,
0.00203424,0.0034356,0.00551504,0.00881502,0.015415,0.0267766,0.0443614,0.0720119,0.106579,0.14752,0.204162,
0.272934,0.336478,0.382979,0.411714,0.430083,0.447592,0.471747,0.50229,0.522557,0.510051,0.457341,0.38319,
0.305602,0.23448,0.173468,0.124646,0.0888886,0.0538093,0.0313724,0.0175547,0.00902598,0.00479175,0.00299861,
0.00198903,0.00153698,0.00120547,0.00111506,0.00105479,0.00102465,0.00105479,0.00108493,0.00111506,0.0011452,
0.00120547,0.00129588,0.00138629,0.00152191,0.00159725,0.00174794,0.00197396,0.00224519,0.00265204,0.00308902,
0.00358628,0.00409861,0.00459587,0.00533422,0.00574106,0.00607257,0.00611777,0.00596709,0.00571093,0.0054849,
0.00510819,0.004626,0.00443011,0.00412874,0.00387258,0.00357121,0.00334519,0.00317943,0.00299861,0.00299861,
0.00304382,0.00328491,0.00349587,0.00390272,0.00446025,0.00551504,0.00688626,0.00898077,0.0124616,0.0160177,
0.0208848,0.0265053,0.0338437,0.0444819,0.0599873,0.0812187,0.104032,0.129468,0.16081,0.19711,0.242134,
0.296622,0.36119,0.431017,0.496971,0.564297,0.640935,0.722937,0.793081,0.827632,0.828054,0.793246,0.728181,
0.638629,0.540579,0.445724,0.355871,0.27747,0.209752,0.158248,0.118724,0.0898831,0.0602134,0.039208,0.0250889,
0.00869447,0.00509312,0.00340546,0.00230547,0.00159725,0.00116027,0.000919173,0.000678078,0.000497258,
0.000421915,0.000346573,0.000301368,0.000256163,0.000210958,0.000195889,0.000180821,0.000165753,0.000150684,
0.000135616,0.000120547,9.04105e-05,4.52052e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,
4.52052e-05,4.52052e-05,7.53421e-05,9.04105e-05,0.000120547,0.000120547,0.000150684,0.000165753,0.000180821,
0.000226026,0.000316437,0.000421915,0.000497258,0.000768489,0.00111506,0.00170273,0.00311916,0.00540956,
0.00970406,0.0179615,0.0309505,0.0525435,0.0868393,0.126123,0.183729,0.260081,0.353671,0.452233,0.52857,
0.564734,0.574574,0.581354,0.594916,0.61886,0.641251,0.636972,0.581927,0.483982,0.373395,0.276882,0.198647,
0.13982,0.0992556,0.0631065,0.0372642,0.0212766,0.0106835,0.00531915,0.00296848,0.00174794,0.00125068,
0.00102465,0.000858899,0.000798626,0.000768489,0.000768489,0.000768489,0.000798626,0.000843831,0.000873968,
0.000934241,0.00100958,0.00105479,0.00109999,0.00113013,0.00120547,0.00134109,0.0014767,0.00156711,0.001763,
0.00201917,0.00230547,0.0025767,0.00278766,0.00296848,0.00299861,0.00299861,0.00296848,0.00283286,0.00269725,
0.00251642,0.00232054,0.00224519,0.00210958,0.00198903,0.00186848,0.00177807,0.00177807,0.00177807,0.00183835,
0.00197396,0.00210958,0.00236574,0.00272738,0.00322464,0.00375203,0.00455066,0.00623832,0.00843831,0.0121301,
0.0161232,0.0219396,0.0303478,0.0414833,0.0593394,0.0835393,0.109562,0.138855,0.175351,0.219441,0.273462,
0.340064,0.421042,0.508122,0.595112,0.684844,0.773868,0.844087,0.887665,0.899961,0.87344,0.804623,0.706287,
0.594795,0.486032,0.387514,0.301459,0.228422,0.169158,0.125972,0.0948556,0.064101,0.0413929,0.0264451,
0.0158821,0.00459587,0.00299861,0.00197396,0.00138629,0.00105479,0.000843831,0.000602736,0.000467121,
0.000421915,0.000346573,0.0002863,0.000226026,0.000210958,0.000180821,0.000180821,0.000150684,0.000135616,
0.000120547,9.04105e-05,7.53421e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,4.52052e-05,4.52052e-05,
4.52052e-05,4.52052e-05,4.52052e-05,9.04105e-05,9.04105e-05,0.000120547,0.000135616,0.000150684,0.000180821,
0.000210958,0.0002863,0.000361642,0.000436984,0.000602736,0.000934241,0.0014767,0.00254656,0.00453559,
0.00879995,0.0177054,0.0316738,0.0551353,0.0922187,0.137575,0.210656,0.309174,0.428048,0.562248,0.686547,
0.758303,0.76986,0.751673,0.74004,0.738804,0.741004,0.729854,0.68064,0.580013,0.450108,0.324453,0.225695,
0.152718,0.105494,0.0690133,0.0415587,0.0244108,0.0129136,0.0060123,0.00317943,0.00170273,0.00111506,
0.000873968,0.000693147,0.000587668,0.000527394,0.000497258,0.000497258,0.000512326,0.0005726,0.000587668,
0.000632873,0.000693147,0.000768489,0.000798626,0.000843831,0.000858899,0.000919173,0.000964378,0.00102465,
0.00109999,0.00113013,0.00122054,0.00134109,0.00146164,0.00153698,0.00155205,0.00156711,0.00155205,0.00152191,
0.0014315,0.00137123,0.00129588,0.00120547,0.0011452,0.00111506,0.00111506,0.00111506,0.00111506,0.00113013,
0.00117534,0.00122054,0.00134109,0.0014767,0.00156711,0.001763,0.00210958,0.00260684,0.00328491,0.00415888,
0.00580134,0.00831776,0.0127177,0.0182478,0.0267916,0.0391779,0.0589326,0.0871255,0.11464,0.149675,0.191866,
0.244621,0.309128,0.391523,0.489964,0.597041,0.710626,0.821454,0.901362,0.941022,0.950078,0.928952,0.86996,
0.764918,0.633973,0.51216,0.404557,0.313137,0.238126,0.176059,0.129965,0.0968899,0.0664969,0.0423272,
0.0267766,0.0158068,0.00852872,0.00263697,0.00164246,0.00116027,0.000919173,0.000693147,0.000527394,0.000421915,
0.00037671,0.000301368,0.000256163,0.000210958,0.000180821,0.000180821,0.000150684,0.000135616,0.000120547,
0.000120547,9.04105e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,4.52052e-05,4.52052e-05,4.52052e-05,9.04105e-05,0.000105479,0.000120547,0.000135616,0.000165753,
0.000180821,0.000210958,0.000316437,0.000421915,0.000512326,0.000798626,0.00113013,0.00189862,0.00361642,
0.00699174,0.0148424,0.0287807,0.0514737,0.090305,0.137213,0.214936,0.326683,0.475002,0.641447,0.799605,
0.898258,0.928907,0.909077,0.871165,0.841315,0.808164,0.765505,0.700982,0.610693,0.490974,0.362275,0.250332,
0.164653,0.109186,0.070038,0.0420409,0.0253149,0.0141794,0.0065849,0.00340546,0.00170273,0.00109999,0.000798626,
0.000587668,0.000467121,0.000421915,0.000421915,0.000421915,0.000421915,0.000421915,0.000421915,0.000421915,
0.000452052,0.000497258,0.000527394,0.0005726,0.000602736,0.000602736,0.000678078,0.000693147,0.000768489,
0.000783557,0.000843831,0.000858899,0.000919173,0.000934241,0.00094931,0.000964378,0.00094931,0.000919173,
0.000873968,0.000858899,0.000843831,0.000798626,0.000783557,0.000768489,0.000768489,0.000768489,0.000768489,
0.000798626,0.000843831,0.000858899,0.000889036,0.000934241,0.00102465,0.00111506,0.00120547,0.0014767,
0.00170273,0.00218492,0.00299861,0.00408354,0.00619312,0.00940269,0.0153396,0.0241697,0.0373094,0.0592038,
0.0901091,0.120472,0.160177,0.209556,0.270855,0.348487,0.448135,0.563091,0.691203,0.823353,0.930926,0.99227,
0.997122,0.970255,0.911639,0.813664,0.671509,0.527681,0.410403,0.313965,0.236469,0.174809,0.129573,0.096031,
0.0647188,0.0414381,0.0257971,0.0149177,0.00773009,0.00415888,0.00138629,0.00103972,0.000798626,0.000587668,
0.000436984,0.000391779,0.000316437,0.0002863,0.000210958,0.000180821,0.000180821,0.000150684,0.000135616,
0.000120547,0.000105479,6.02736e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,4.52052e-05,9.04105e-05,0.000120547,
0.000135616,0.000150684,0.000180821,0.000210958,0.0002863,0.000346573,0.000421915,0.000602736,0.000919173,
0.0014767,0.00269725,0.00509312,0.0108643,0.0218944,0.0410765,0.0756585,0.122853,0.194865,0.30732,0.462917,
0.658731,0.848186,0.957658,0.993747,0.986258,0.949174,0.894928,0.837804,0.760623,0.664457,0.563107,0.460265,
0.353641,0.254053,0.170183,0.111883,0.0694202,0.040534,0.0238081,0.0135465,0.00661503,0.0034356,0.00174794,
0.00105479,0.000768489,0.000512326,0.000421915,0.000391779,0.000346573,0.000346573,0.000316437,0.000316437,
0.000346573,0.000346573,0.00037671,0.000391779,0.000421915,0.000421915,0.000421915,0.000436984,0.000452052,
0.000467121,0.000497258,0.000497258,0.000527394,0.0005726,0.000587668,0.000602736,0.000602736,0.000602736,
0.000602736,0.000587668,0.0005726,0.000557531,0.000512326,0.000497258,0.000482189,0.000467121,0.000467121,
0.000467121,0.000467121,0.000497258,0.000512326,0.000557531,0.000587668,0.000602736,0.000678078,0.000768489,
0.000813694,0.000919173,0.00105479,0.00122054,0.00156711,0.00210958,0.0031945,0.00459587,0.00760955,0.013878,
0.022467,0.036571,0.0598065,0.0921584,0.125384,0.169158,0.2269,0.298761,0.391598,0.505997,0.636294,0.771894,
0.889277,0.978859,1,0.991155,0.922488,0.824302,0.691248,0.544602,0.412377,0.309264,0.23017,0.16732,0.123049,
0.0922789,0.0609819,0.0385902,0.023778,0.0139081,0.00696161,0.00381231,0.00219999,0.000889036,0.000678078,
0.000467121,0.000421915,0.000316437,0.000271231,0.000210958,0.000180821,0.000165753,0.000150684,0.000135616,
0.000120547,9.04105e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,7.53421e-05,
9.04105e-05,0.000120547,0.000135616,0.000165753,0.000180821,0.000210958,0.000301368,0.000391779,0.000482189,
0.000768489,0.00109999,0.001763,0.00349587,0.00699174,0.0149931,0.0295642,0.0552559,0.0979447,0.156274,
0.251175,0.391447,0.581746,0.799048,0.946793,0.99566,0.987538,0.947682,0.887213,0.811615,0.714182,0.606127,
0.495841,0.394114,0.305587,0.226448,0.158218,0.106956,0.0657284,0.0371436,0.0208848,0.0110602,0.00565065,
0.0031493,0.00165753,0.00102465,0.000678078,0.000452052,0.000391779,0.000316437,0.000301368,0.0002863,
0.000271231,0.000271231,0.0002863,0.0002863,0.0002863,0.000301368,0.000301368,0.000316437,0.000331505,
0.000346573,0.000361642,0.000391779,0.000391779,0.000421915,0.000421915,0.000421915,0.000421915,0.000421915,
0.000421915,0.000421915,0.000421915,0.000421915,0.000421915,0.000421915,0.000421915,0.000406847,0.000391779,
0.00037671,0.000361642,0.000361642,0.000361642,0.00037671,0.000391779,0.000421915,0.000421915,0.000421915,
0.000421915,0.000467121,0.000497258,0.000587668,0.000678078,0.000798626,0.00094931,0.0011452,0.00159725,
0.00248629,0.00393286,0.00670544,0.0127479,0.0217889,0.0361039,0.0596408,0.0930474,0.128142,0.175818,
0.240236,0.321846,0.427777,0.551022,0.682418,0.80069,0.887786,0.940329,0.940028,0.879136,0.773883,0.648333,
0.524411,0.405385,0.300976,0.217769,0.157254,0.113631,0.0822735,0.0553011,0.0344012,0.0213369,0.0122657,
0.00623832,0.00345067,0.00194382,0.00120547,0.000557531,0.000421915,0.000331505,0.000256163,0.000210958,
0.000180821,0.000150684,0.000135616,0.000120547,9.04105e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,9.04105e-05,0.000120547,0.000120547,0.000150684,
0.000180821,0.000210958,0.000241095,0.000316437,0.000421915,0.0005726,0.000843831,0.00122054,0.00219999,
0.0042945,0.00914653,0.0191972,0.035682,0.0664969,0.112998,0.181092,0.289675,0.442755,0.637349,0.831219,
0.931092,0.939998,0.890106,0.815065,0.72467,0.626062,0.523266,0.423603,0.330164,0.251055,0.18382,0.131351,
0.0929269,0.0564161,0.0316738,0.0166958,0.00786571,0.00415888,0.00242601,0.00138629,0.000904105,0.000587668,
0.000421915,0.000346573,0.0002863,0.000226026,0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,
0.000210958,0.000210958,0.000210958,0.000226026,0.000241095,0.000256163,0.0002863,0.0002863,0.000301368,
0.000301368,0.000316437,0.000316437,0.000316437,0.000316437,0.000346573,0.000346573,0.000331505,0.000316437,
0.000316437,0.000316437,0.000316437,0.000301368,0.000301368,0.0002863,0.0002863,0.0002863,0.0002863,0.0002863,
0.0002863,0.000301368,0.000301368,0.000316437,0.000346573,0.000361642,0.000391779,0.000421915,0.000436984,
0.000497258,0.000587668,0.000768489,0.000934241,0.00129588,0.00198903,0.0034356,0.00614791,0.0119794,
0.0212615,0.0352902,0.0578326,0.0910433,0.127087,0.177009,0.244771,0.329637,0.43822,0.556687,0.668525,
0.75339,0.796622,0.79962,0.752049,0.657088,0.548249,0.44937,0.357347,0.27322,0.198496,0.141417,0.102601,
0.0702489,0.0459134,0.0298807,0.018067,0.00983967,0.00531915,0.00304382,0.00170273,0.00109999,0.000783557,
0.000346573,0.000271231,0.000195889,0.000165753,0.000135616,0.000120547,7.53421e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,4.52052e-05,9.04105e-05,0.000120547,0.000135616,0.000150684,0.000180821,0.000210958,
0.0002863,0.000361642,0.000436984,0.000602736,0.000934241,0.0014767,0.00269725,0.00531915,0.0117835,0.0227533,
0.0411518,0.075327,0.121014,0.191369,0.299349,0.442183,0.605404,0.746549,0.807531,0.781041,0.699566,0.605916,
0.513456,0.424191,0.34035,0.266515,0.201133,0.146917,0.10569,0.0699476,0.0417395,0.0238081,0.0122808,
0.00557531,0.00299861,0.00170273,0.00109999,0.000768489,0.000482189,0.000391779,0.000301368,0.000241095,
0.000210958,0.000180821,0.000180821,0.000180821,0.000180821,0.000180821,0.000180821,0.000180821,0.000180821,
0.000180821,0.000195889,0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,0.000226026,
0.000241095,0.000256163,0.000256163,0.000271231,0.000256163,0.000256163,0.000241095,0.000226026,0.000226026,
0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,
0.000210958,0.000210958,0.000241095,0.0002863,0.000301368,0.000316437,0.000346573,0.000391779,0.000421915,
0.000436984,0.0005726,0.000768489,0.00109999,0.00165753,0.00299861,0.0054397,0.0106684,0.01983,0.0329245,
0.0538545,0.0857995,0.12109,0.169113,0.232626,0.311765,0.406335,0.502441,0.578265,0.619945,0.619719,0.58256,
0.51656,0.432976,0.349436,0.280724,0.219185,0.165105,0.120035,0.0880899,0.0575161,0.0362245,0.0230396,
0.0139081,0.00739859,0.00415888,0.00256163,0.00155205,0.000964378,0.000632873,0.000436984,0.000210958,
0.000150684,0.000120547,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,
1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,9.04105e-05,0.000120547,0.000135616,0.000165753,
0.000180821,0.000210958,0.000301368,0.000391779,0.000467121,0.000768489,0.00105479,0.00161232,0.00308902,
0.00616298,0.0132602,0.025104,0.0449943,0.0790941,0.121316,0.184091,0.276882,0.389579,0.503074,0.582695,
0.602073,0.558887,0.487418,0.407028,0.328898,0.25996,0.19931,0.151362,0.113194,0.0803598,0.0502833,0.0296546,
0.0157917,0.00739859,0.00363149,0.00189862,0.0011452,0.000798626,0.000557531,0.000421915,0.000346573,
0.0002863,0.000210958,0.000180821,0.000165753,0.000150684,0.000150684,0.000150684,0.000150684,0.000150684,
0.000165753,0.000165753,0.000165753,0.000165753,0.000165753,0.000165753,0.000180821,0.000180821,0.000180821,
0.000180821,0.000180821,0.000195889,0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,
0.000195889,0.000180821,0.000180821,0.000180821,0.000180821,0.000180821,0.000180821,0.000165753,0.000165753,
0.000165753,0.000165753,0.000180821,0.000180821,0.000180821,0.000210958,0.000210958,0.000226026,0.000271231,
0.000301368,0.000316437,0.000361642,0.000421915,0.000436984,0.000602736,0.000919173,0.0014767,0.00265204,
0.00459587,0.00905611,0.0175698,0.0299108,0.0474956,0.0745585,0.109095,0.150232,0.202655,0.266409,0.334971,
0.397475,0.437813,0.447261,0.427174,0.383265,0.324634,0.261347,0.203182,0.157811,0.122943,0.0945995,0.0646887,
0.0424477,0.0274998,0.0163191,0.00890543,0.00509312,0.0031945,0.00191369,0.00123561,0.000843831,0.000527394,
0.000391779,0.0002863,0.000120547,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,4.52052e-05,9.04105e-05,0.000120547,0.000150684,0.000180821,0.000210958,0.000241095,0.000316437,
0.000421915,0.000512326,0.000798626,0.00113013,0.00177807,0.00340546,0.00653969,0.0141342,0.0263547,0.0457477,
0.0768338,0.113797,0.163055,0.231119,0.307185,0.373199,0.408987,0.403894,0.364113,0.309098,0.249578,0.192589,
0.145501,0.110572,0.0817311,0.0552709,0.0342957,0.0202369,0.0100808,0.00471641,0.00248629,0.00134109,
0.000858899,0.0005726,0.000421915,0.000361642,0.000301368,0.000210958,0.000180821,0.000165753,0.000135616,
0.000135616,0.000120547,0.000120547,0.000135616,0.000135616,0.000135616,0.000135616,0.000135616,0.000135616,
0.000135616,0.000150684,0.000150684,0.000150684,0.000150684,0.000150684,0.000150684,0.000165753,0.000165753,
0.000180821,0.000180821,0.000180821,0.000180821,0.000180821,0.000180821,0.000165753,0.000165753,0.000165753,
0.000150684,0.000150684,0.000150684,0.000150684,0.000135616,0.000135616,0.000135616,0.000135616,0.000150684,
0.000150684,0.000165753,0.000180821,0.000180821,0.000210958,0.000210958,0.000241095,0.0002863,0.000316437,
0.00037671,0.000421915,0.000527394,0.000843831,0.00122054,0.00219999,0.0040534,0.00742873,0.0147068,0.0248629,
0.0391176,0.0608764,0.0920831,0.123335,0.162031,0.205171,0.248795,0.281855,0.296426,0.290308,0.266274,
0.231029,0.1873,0.144732,0.111461,0.0862365,0.0612079,0.0421915,0.0292026,0.0185492,0.0106684,0.00574106,
0.00340546,0.0020493,0.00138629,0.00102465,0.000693147,0.000436984,0.000316437,0.000210958,0.000150684,
3.01368e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,9.04105e-05,0.000120547,0.000150684,0.000180821,0.000210958,0.0002863,0.000346573,
0.000421915,0.0005726,0.000843831,0.00120547,0.00203424,0.00361642,0.00673558,0.0140739,0.0255862,0.0425984,
0.0686969,0.100024,0.133144,0.175713,0.220376,0.253345,0.262462,0.248132,0.216473,0.177385,0.138479,0.106579,
0.0789283,0.0543367,0.035893,0.0232807,0.0136369,0.00664517,0.00346573,0.001763,0.00105479,0.000647942,
0.000421915,0.000361642,0.000301368,0.000226026,0.000195889,0.000165753,0.000135616,0.000120547,9.04105e-05,
9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,
0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000135616,0.000135616,0.000135616,0.000150684,
0.000150684,0.000150684,0.000150684,0.000150684,0.000150684,0.000150684,0.000135616,0.000135616,0.000135616,
0.000135616,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,
0.000135616,0.000150684,0.000150684,0.000165753,0.000180821,0.000195889,0.000210958,0.000241095,0.000301368,
0.000346573,0.000421915,0.000467121,0.000768489,0.00109999,0.00177807,0.00334519,0.00580134,0.0111657,
0.0193328,0.0307546,0.0462751,0.0684709,0.0951269,0.119221,0.144596,0.16735,0.180926,0.182915,0.172473,
0.152688,0.127931,0.103173,0.0771051,0.0537038,0.0360888,0.0244711,0.0157616,0.00962871,0.0060123,0.00367669,
0.00219999,0.00137123,0.000964378,0.000768489,0.000527394,0.000421915,0.0002863,0.000180821,0.000120547,
3.01368e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,9.04105e-05,
0.000135616,0.000165753,0.000180821,0.000210958,0.0002863,0.000361642,0.000421915,0.000587668,0.000873968,
0.00131095,0.00210958,0.00363149,0.00653969,0.0129136,0.0230999,0.0371135,0.056823,0.0808722,0.103294,
0.125535,0.145742,0.157872,0.156742,0.141387,0.119764,0.0967693,0.0709722,0.0501778,0.0345368,0.0233108,
0.0146917,0.00807667,0.00446025,0.00254656,0.00138629,0.000873968,0.000527394,0.000421915,0.000316437,
0.000241095,0.000210958,0.000180821,0.000135616,0.000120547,9.04105e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,4.52052e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,
0.000105479,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,
0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,
9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,0.000120547,
0.000120547,0.000135616,0.000150684,0.000165753,0.000180821,0.000195889,0.000210958,0.0002863,0.000316437,
0.000391779,0.000436984,0.000602736,0.000934241,0.00152191,0.00265204,0.00418902,0.00742873,0.013878,
0.0218944,0.0324272,0.0469682,0.0633476,0.0818968,0.0967693,0.106579,0.110919,0.107739,0.098683,0.085016,
0.0661654,0.0490025,0.0330902,0.0217588,0.013426,0.00751914,0.00464107,0.00334519,0.00224519,0.00150684,
0.00100958,0.000693147,0.000497258,0.000421915,0.000331505,0.000210958,0.000165753,9.04105e-05,3.01368e-05,
3.01368e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,
1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,9.04105e-05,0.000135616,0.000165753,
0.000195889,0.000210958,0.000301368,0.00037671,0.000421915,0.000602736,0.000889036,0.00134109,0.00210958,
0.00358628,0.00614791,0.0111054,0.0191519,0.0303478,0.0430504,0.0584052,0.072901,0.0866434,0.0936652,
0.0947954,0.0897927,0.075779,0.0591284,0.0419052,0.0298204,0.0208396,0.0139835,0.00804653,0.00479175,
0.0031493,0.00186848,0.0011452,0.000798626,0.000512326,0.000391779,0.000301368,0.000210958,0.000180821,
0.000150684,0.000120547,9.04105e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,4.52052e-05,7.53421e-05,
9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,0.000105479,0.000120547,0.000120547,
0.000105479,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,4.52052e-05,4.52052e-05,4.52052e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,4.52052e-05,7.53421e-05,9.04105e-05,0.000120547,
0.000120547,0.000135616,0.000150684,0.000165753,0.000180821,0.000210958,0.000241095,0.000301368,0.000361642,
0.000421915,0.000557531,0.000798626,0.0011452,0.00186848,0.00317943,0.00489723,0.00813694,0.0141643,0.0212013,
0.0298656,0.0388313,0.0479326,0.055286,0.0593243,0.0593394,0.05506,0.0469682,0.0373546,0.0289916,0.0199807,
0.0128684,0.00730818,0.00423422,0.00283286,0.00177807,0.00131095,0.000964378,0.000678078,0.000467121,
0.000421915,0.000346573,0.0002863,0.000210958,0.000150684,9.04105e-05,3.01368e-05,1.50684e-05,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,9.04105e-05,0.000135616,0.000165753,0.000195889,0.000226026,0.000301368,
0.000391779,0.000436984,0.000602736,0.000873968,0.00126575,0.00203424,0.00334519,0.00531915,0.00864927,
0.0147369,0.0224369,0.031282,0.0395847,0.0463504,0.0503586,0.0509915,0.0473148,0.0400669,0.0316437,0.0233108,
0.0157314,0.0103219,0.00664517,0.00415888,0.00289313,0.00188355,0.00135616,0.000964378,0.000693147,0.000482189,
0.000391779,0.000301368,0.000210958,0.000180821,0.000135616,0.000120547,9.04105e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,
4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,9.04105e-05,0.000120547,0.000120547,0.000135616,0.000150684,
0.000180821,0.000210958,0.000210958,0.0002863,0.000346573,0.000421915,0.000482189,0.000678078,0.000934241,
0.00137123,0.00210958,0.00328491,0.00471641,0.00742873,0.0119945,0.0166205,0.0218492,0.0262492,0.0290218,
0.0295642,0.0280423,0.0244259,0.0199656,0.0151136,0.0104876,0.00681092,0.00444518,0.00299861,0.00186848,
0.0011904,0.000858899,0.000602736,0.000436984,0.000391779,0.000316437,0.000271231,0.000210958,0.000180821,
0.000135616,4.52052e-05,3.01368e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,9.04105e-05,
0.000135616,0.000165753,0.000195889,0.000226026,0.000301368,0.000391779,0.000436984,0.000602736,0.000858899,
0.00117534,0.00177807,0.00295341,0.0042945,0.00670544,0.0104273,0.0153396,0.020915,0.0253601,0.0284944,
0.0287204,0.0260684,0.0218944,0.0169218,0.0122808,0.00754927,0.00492737,0.00340546,0.00230547,0.00156711,
0.0011452,0.000934241,0.000768489,0.000542463,0.000421915,0.00037671,0.000301368,0.000210958,0.000180821,
0.000135616,9.04105e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,0,0,0,1.50684e-05,
1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,
9.04105e-05,0.000120547,0.000120547,0.000150684,0.000165753,0.000180821,0.000210958,0.0002863,0.000316437,
0.000391779,0.000421915,0.0005726,0.000798626,0.00105479,0.0014767,0.0020493,0.00296848,0.00408354,0.00571093,
0.00763968,0.0102465,0.0125972,0.0135314,0.0130492,0.0115725,0.0089205,0.00688626,0.00510819,0.00382738,
0.00289313,0.00203424,0.00138629,0.000934241,0.000602736,0.000421915,0.000361642,0.000301368,0.000241095,
0.000210958,0.000180821,0.000165753,0.000135616,9.04105e-05,3.01368e-05,3.01368e-05,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,3.01368e-05,
3.01368e-05,3.01368e-05,9.04105e-05,0.000135616,0.000165753,0.000195889,0.000226026,0.000301368,0.000391779,
0.000421915,0.0005726,0.000798626,0.00109999,0.00156711,0.00238081,0.00352601,0.00494244,0.00696161,0.00947803,
0.0127479,0.0147369,0.0154451,0.0146917,0.0124013,0.0089205,0.00640407,0.00421915,0.00299861,0.00198903,
0.00138629,0.00105479,0.000843831,0.000647942,0.000512326,0.000421915,0.000421915,0.000346573,0.0002863,
0.000210958,0.000180821,0.000135616,9.04105e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,0,0,0,
0,0,0,0,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
4.52052e-05,9.04105e-05,0.000120547,0.000135616,0.000150684,0.000180821,0.000210958,0.000241095,0.000301368,
0.000361642,0.000421915,0.000482189,0.000602736,0.000843831,0.00105479,0.00135616,0.00170273,0.00230547,
0.00299861,0.00375203,0.00438491,0.00494244,0.00525888,0.00477669,0.00415888,0.00349587,0.00278766,0.00210958,
0.00162739,0.00134109,0.00105479,0.000798626,0.000527394,0.000421915,0.000301368,0.000241095,0.000210958,
0.000180821,0.000165753,0.000150684,0.000120547,9.04105e-05,3.01368e-05,3.01368e-05,1.50684e-05,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,
3.01368e-05,3.01368e-05,4.52052e-05,0.000120547,0.000165753,0.000180821,0.000210958,0.000301368,0.00037671,
0.000421915,0.000527394,0.000768489,0.000964378,0.00134109,0.00186848,0.00271231,0.00361642,0.0045808,
0.00589175,0.00694654,0.00744379,0.00739859,0.00643421,0.00513833,0.00375203,0.00268218,0.00177807,0.00134109,
0.00102465,0.000798626,0.000602736,0.000467121,0.000421915,0.00037671,0.000316437,0.0002863,0.000226026,
0.000195889,0.000165753,0.000120547,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,
0,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,7.53421e-05,
0.000120547,0.000120547,0.000150684,0.000180821,0.000195889,0.000210958,0.0002863,0.000316437,0.000391779,
0.000421915,0.000497258,0.000647942,0.000843831,0.000979447,0.00113013,0.00138629,0.00159725,0.00186848,
0.00210958,0.00232054,0.00232054,0.00210958,0.00186848,0.00156711,0.00125068,0.00105479,0.000873968,0.000768489,
0.000587668,0.000421915,0.000361642,0.0002863,0.000210958,0.000195889,0.000180821,0.000150684,0.000135616,
0.000120547,4.52052e-05,3.01368e-05,3.01368e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,0.000120547,
0.000150684,0.000180821,0.000210958,0.0002863,0.000346573,0.000421915,0.000482189,0.000602736,0.000843831,
0.00109999,0.0014767,0.00191369,0.00263697,0.00328491,0.00375203,0.00408354,0.00408354,0.00384244,0.00328491,
0.00250136,0.00174794,0.00125068,0.000964378,0.000768489,0.000587668,0.000452052,0.000421915,0.000316437,
0.0002863,0.000241095,0.000210958,0.000180821,0.000165753,0.000135616,9.04105e-05,3.01368e-05,3.01368e-05,
1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
4.52052e-05,9.04105e-05,0.000120547,0.000135616,0.000165753,0.000180821,0.000210958,0.000241095,0.000301368,
0.000346573,0.000391779,0.000421915,0.000497258,0.000602736,0.000768489,0.000858899,0.00094931,0.00105479,
0.00111506,0.0011452,0.0011452,0.0011452,0.00109999,0.000964378,0.000843831,0.000693147,0.000587668,0.000467121,
0.000421915,0.00037671,0.000301368,0.000226026,0.000210958,0.000180821,0.000165753,0.000150684,0.000120547,
9.04105e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,3.01368e-05,3.01368e-05,9.04105e-05,
0.000135616,0.000180821,0.000210958,0.000256163,0.000316437,0.000391779,0.000436984,0.000557531,0.000753421,
0.000889036,0.00111506,0.00140136,0.00170273,0.00209451,0.00235067,0.00251642,0.00242601,0.00218492,0.001763,
0.00138629,0.00109999,0.000843831,0.000602736,0.000467121,0.000421915,0.000316437,0.000256163,0.000210958,
0.000180821,0.000165753,0.000135616,0.000120547,9.04105e-05,3.01368e-05,3.01368e-05,1.50684e-05,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,7.53421e-05,
0.000120547,0.000135616,0.000150684,0.000180821,0.000180821,0.000210958,0.000271231,0.000301368,0.000346573,
0.000391779,0.000421915,0.000436984,0.000512326,0.000602736,0.000678078,0.000768489,0.000768489,0.000783557,
0.000768489,0.000723284,0.000602736,0.000557531,0.000467121,0.000421915,0.000391779,0.000346573,0.000301368,
0.000256163,0.000210958,0.000180821,0.000180821,0.000150684,0.000135616,0.000120547,7.53421e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,3.01368e-05,3.01368e-05,6.02736e-05,0.000120547,
0.000165753,0.000180821,0.000210958,0.000301368,0.000361642,0.000421915,0.000467121,0.000587668,0.000768489,
0.000873968,0.00105479,0.00120547,0.00138629,0.00155205,0.00155205,0.00152191,0.00135616,0.00113013,0.00094931,
0.000768489,0.0005726,0.000421915,0.00037671,0.000301368,0.000210958,0.000180821,0.000150684,0.000120547,
9.04105e-05,3.01368e-05,3.01368e-05,3.01368e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,4.52052e-05,9.04105e-05,0.000120547,0.000135616,0.000165753,0.000180821,0.000210958,0.000210958,
0.000256163,0.000301368,0.000316437,0.000361642,0.000391779,0.000421915,0.000421915,0.000436984,0.000467121,
0.000467121,0.000467121,0.000452052,0.000421915,0.000421915,0.000391779,0.000346573,0.000301368,0.0002863,
0.000210958,0.000210958,0.000180821,0.000180821,0.000150684,0.000135616,0.000120547,9.04105e-05,4.52052e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,3.01368e-05,3.01368e-05,0.000120547,
0.000150684,0.000180821,0.000210958,0.000256163,0.000316437,0.000391779,0.000421915,0.000467121,0.0005726,
0.000693147,0.000798626,0.000889036,0.000994515,0.00105479,0.00105479,0.00102465,0.000919173,0.000798626,
0.000632873,0.000497258,0.000421915,0.000346573,0.0002863,0.000210958,0.000180821,0.000150684,0.000120547,
3.01368e-05,3.01368e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,9.04105e-05,0.000120547,0.000120547,0.000150684,
0.000165753,0.000180821,0.000210958,0.000210958,0.000241095,0.0002863,0.000301368,0.000316437,0.000346573,
0.000346573,0.000361642,0.00037671,0.000361642,0.000361642,0.000346573,0.000316437,0.000301368,0.0002863,
0.000226026,0.000210958,0.000195889,0.000180821,0.000165753,0.000150684,0.000135616,0.000120547,0.000120547,
9.04105e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3.01368e-05,3.01368e-05,
6.02736e-05,0.000120547,0.000150684,0.000180821,0.000210958,0.0002863,0.000316437,0.000391779,0.000421915,
0.000436984,0.000512326,0.000587668,0.000632873,0.000693147,0.000768489,0.000768489,0.000678078,0.000602736,
0.000497258,0.000421915,0.000391779,0.000301368,0.000226026,0.000195889,0.000165753,0.000120547,6.02736e-05,
3.01368e-05,3.01368e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,9.04105e-05,0.000120547,0.000135616,0.000150684,
0.000165753,0.000180821,0.000195889,0.000210958,0.000210958,0.000226026,0.000271231,0.0002863,0.0002863,
0.0002863,0.0002863,0.0002863,0.0002863,0.000256163,0.000210958,0.000210958,0.000210958,0.000180821,0.000180821,
0.000165753,0.000150684,0.000135616,0.000120547,0.000120547,9.04105e-05,4.52052e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,3.01368e-05,3.01368e-05,9.04105e-05,
0.000135616,0.000165753,0.000180821,0.000210958,0.0002863,0.000316437,0.000361642,0.000421915,0.000421915,
0.000436984,0.000467121,0.000467121,0.000467121,0.000467121,0.000421915,0.000421915,0.000391779,0.000316437,
0.000271231,0.000210958,0.000180821,0.000135616,0.000120547,3.01368e-05,3.01368e-05,1.50684e-05,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,6.02736e-05,9.04105e-05,0.000120547,0.000135616,0.000150684,0.000165753,0.000180821,
0.000180821,0.000195889,0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,
0.000210958,0.000210958,0.000180821,0.000180821,0.000165753,0.000150684,0.000150684,0.000135616,0.000120547,
0.000120547,9.04105e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,3.01368e-05,3.01368e-05,0.000120547,0.000135616,0.000165753,0.000180821,
0.000210958,0.000241095,0.0002863,0.000316437,0.000346573,0.00037671,0.000391779,0.000391779,0.000391779,
0.00037671,0.000346573,0.000301368,0.000271231,0.000210958,0.000180821,0.000150684,0.000120547,4.52052e-05,
3.01368e-05,3.01368e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,9.04105e-05,0.000120547,0.000120547,0.000135616,
0.000150684,0.000150684,0.000165753,0.000180821,0.000180821,0.000180821,0.000180821,0.000180821,0.000180821,
0.000180821,0.000180821,0.000180821,0.000165753,0.000165753,0.000150684,0.000135616,0.000120547,0.000120547,
9.04105e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,3.01368e-05,3.01368e-05,9.04105e-05,0.000135616,0.000150684,
0.000180821,0.000195889,0.000210958,0.000241095,0.0002863,0.0002863,0.000301368,0.000301368,0.0002863,
0.0002863,0.000241095,0.000210958,0.000180821,0.000165753,0.000135616,9.04105e-05,3.01368e-05,3.01368e-05,
1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,9.04105e-05,0.000120547,0.000120547,0.000135616,
0.000135616,0.000150684,0.000150684,0.000165753,0.000165753,0.000165753,0.000165753,0.000165753,0.000150684,
0.000150684,0.000150684,0.000135616,0.000135616,0.000120547,0.000120547,9.04105e-05,4.52052e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1.50684e-05,3.01368e-05,3.01368e-05,9.04105e-05,0.000120547,0.000135616,0.000165753,0.000180821,
0.000180821,0.000210958,0.000210958,0.000210958,0.000210958,0.000210958,0.000195889,0.000180821,0.000165753,
0.000150684,0.000120547,4.52052e-05,3.01368e-05,3.01368e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
4.52052e-05,9.04105e-05,9.04105e-05,0.000120547,0.000120547,0.000135616,0.000135616,0.000135616,0.000135616,
0.000135616,0.000135616,0.000135616,0.000135616,0.000120547,0.000120547,0.000120547,9.04105e-05,9.04105e-05,
4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,9.04105e-05,0.000120547,0.000135616,
0.000150684,0.000150684,0.000165753,0.000165753,0.000165753,0.000150684,0.000150684,0.000135616,0.000120547,
4.52052e-05,3.01368e-05,3.01368e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
4.52052e-05,7.53421e-05,9.04105e-05,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,0.000120547,
0.000120547,0.000120547,0.000120547,0.000105479,9.04105e-05,6.02736e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,9.04105e-05,9.04105e-05,0.000120547,0.000120547,
0.000105479,9.04105e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,7.53421e-05,9.04105e-05,9.04105e-05,
9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,9.04105e-05,4.52052e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,4.52052e-05,
4.52052e-05,4.52052e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,
3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,3.01368e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,1.50684e-05,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.50684e-05,1.50684e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,};
  const double linear_table_pre_pro[] = {0.00258251,0.0021927,0.00181913,0.00121817,0.000893321,0.000535993,0.000422297,0.000341086,0.000243633,
0.000113695,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,
3.24844e-05,3.24844e-05,8.1211e-05,0.000162422,0.000194906,0.000276117,0.000308602,0.000341086,0.000389813,
0.000422297,0.000503508,0.000568477,0.000747141,0.000942048,0.00112071,0.00121817,0.00138059,0.0016567,
0.0017704,0.0018841,0.00196531,0.00204652,0.00204652,0.002079,0.00211149,0.00212773,0.00212773,0.00212773,
0.00212773,0.00212773,0.00212773,0.00212773,0.00209524,0.00204652,0.00204652,0.00201403,0.00196531,0.00196531,
0.00201403,0.00204652,0.00209524,0.00214397,0.00220894,0.00232264,0.00233888,0.00233888,0.00237136,0.00245257,
0.00253378,0.00259875,0.00269621,0.00279366,0.00290735,0.00319971,0.00344335,0.00368698,0.00404431,0.0043854,
0.00497011,0.00568477,0.00649688,0.00726027,0.00808862,0.00898194,0.00976156,0.0101839,0.0102326,0.0100214,
0.00930678,0.0081211,0.00695166,0.00586344,0.00471024,0.0039631,0.00318347,0.00306978,0.00248506,0.00212773,
0.00168919,0.00113695,0.000747141,0.000471024,0.000389813,0.000276117,0.000162422,3.24844e-05,3.24844e-05,
1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,
1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,
8.1211e-05,0.000162422,0.000211149,0.000276117,0.000324844,0.000341086,0.000389813,0.00043854,0.000503508,
0.000617204,0.000828352,0.0010395,0.00121817,0.00155925,0.00180288,0.00201403,0.00209524,0.0021927,0.00229015,
0.00233888,0.00235512,0.00242009,0.00246881,0.00251754,0.00253378,0.00253378,0.00253378,0.00253378,0.00251754,
0.00248506,0.00242009,0.00237136,0.00233888,0.00233888,0.00232264,0.00225767,0.00225767,0.00229015,0.00232264,
0.00233888,0.00242009,0.00253378,0.00263124,0.00267996,0.00269621,0.00279366,0.00289111,0.00306978,0.00331341,
0.00350832,0.00370322,0.00394686,0.004158,0.0043854,0.00474272,0.00532744,0.00605834,0.00690294,0.00786123,
0.00924181,0.01046,0.0118568,0.013075,0.0144718,0.0152677,0.0153651,0.0147642,0.0133511,0.0116944,0.00979405,
0.00773129,0.00626949,0.00480769,0.00394686,0.00376819,0.00282614,0.00233888,0.00203028,0.00139683,0.000974532,
0.000552235,0.000406055,0.000324844,0.000178664,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
0.000113695,0.000162422,0.000211149,0.000276117,0.000324844,0.000341086,0.000389813,0.000422297,0.000503508,
0.000617204,0.000877079,0.00113695,0.00136435,0.00180288,0.00204652,0.00220894,0.00233888,0.00251754,
0.00264748,0.00274493,0.00284239,0.00290735,0.00306978,0.00316723,0.00319971,0.00321596,0.00319971,0.00318347,
0.00315099,0.00308602,0.00298857,0.00290735,0.0028099,0.00277742,0.00269621,0.00264748,0.00264748,0.00259875,
0.00264748,0.00267996,0.00269621,0.0028099,0.00290735,0.0031185,0.00328093,0.0034271,0.00358953,0.00370322,
0.0039631,0.004158,0.0043854,0.00472648,0.00508381,0.00553859,0.0060421,0.00667555,0.0073902,0.00860837,
0.0100052,0.0115969,0.0133024,0.0154951,0.0178827,0.0206438,0.0224467,0.0236649,0.0236649,0.0221869,0.0199129,
0.016632,0.0134648,0.0107199,0.0081211,0.00628573,0.00471024,0.0043854,0.00349207,0.00264748,0.00220894,
0.00180288,0.00116944,0.000747141,0.000454782,0.000341086,0.000227391,8.1211e-05,3.24844e-05,3.24844e-05,
1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,
1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,
1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,0.000113695,0.000162422,0.000211149,0.000276117,0.000324844,0.000341086,
0.000389813,0.000422297,0.000503508,0.000617204,0.000860837,0.0011532,0.00152677,0.00193282,0.00214397,
0.00233888,0.00264748,0.00287487,0.00331341,0.00358953,0.00376819,0.00393061,0.00404431,0.00412552,0.00414176,
0.004158,0.00414176,0.00412552,0.00409304,0.00399558,0.00391437,0.00383316,0.00370322,0.00360577,0.00350832,
0.00339462,0.00332965,0.00319971,0.00318347,0.0032322,0.00334589,0.00344335,0.00355704,0.00367074,0.00383316,
0.00399558,0.004158,0.00433667,0.0045803,0.00498636,0.00539241,0.00594465,0.00648064,0.00704912,0.00761759,
0.00855964,0.00948545,0.0107199,0.0123116,0.0146667,0.017168,0.0206763,0.0243146,0.0283102,0.031721,0.0349045,
0.036545,0.0360739,0.0334589,0.0294471,0.0244445,0.0191658,0.0145205,0.0108011,0.00786123,0.0059284,0.00527872,
0.00402807,0.00302105,0.00240385,0.00204652,0.00141307,0.000942048,0.000503508,0.000389813,0.000276117,
0.000113695,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
0.000113695,0.000162422,0.000194906,0.000276117,0.000324844,0.000341086,0.000389813,0.000406055,0.000471024,
0.000552235,0.00081211,0.00113695,0.00152677,0.00196531,0.00220894,0.00251754,0.0028099,0.0034271,0.00388189,
0.00425546,0.00461279,0.00497011,0.00522999,0.00539241,0.00544114,0.00544114,0.00535993,0.0053112,0.00516502,
0.00503508,0.00487266,0.00472648,0.0045803,0.00443412,0.00436915,0.00422297,0.004158,0.00410928,0.00402807,
0.00399558,0.00402807,0.00410928,0.004158,0.00425546,0.0043854,0.00449909,0.00472648,0.00506757,0.00548986,
0.0060421,0.00656185,0.00724402,0.00807238,0.00898194,0.00997271,0.010996,0.0121654,0.0135622,0.0156737,
0.0184836,0.0220569,0.0261499,0.0309901,0.0370485,0.0434966,0.0491814,0.0536805,0.0553697,0.0541028,0.0496199,
0.0429931,0.0347421,0.0267834,0.0198317,0.014147,0.0101839,0.00726027,0.00636694,0.00446661,0.00350832,
0.00264748,0.0021927,0.00172167,0.00113695,0.000617204,0.000422297,0.000324844,0.000178664,3.24844e-05,
3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,
1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,4.87266e-05,4.87266e-05,8.1211e-05,6.49688e-05,4.87266e-05,4.87266e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,
1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,0.000162422,0.000194906,
0.000259875,0.000308602,0.000341086,0.000389813,0.000406055,0.00043854,0.000503508,0.000747141,0.0010395,
0.00136435,0.00193282,0.00220894,0.00256627,0.00303729,0.00370322,0.00432043,0.00501884,0.00579847,0.00643191,
0.00693542,0.00727651,0.00748766,0.00752014,0.0073902,0.00726027,0.00704912,0.00678924,0.00652937,0.00633446,
0.00607458,0.00589592,0.00563604,0.00540865,0.00522999,0.00506757,0.00498636,0.00487266,0.00487266,0.0048889,
0.00498636,0.00506757,0.00524623,0.00544114,0.0057335,0.00605834,0.00648064,0.00704912,0.00766632,0.00870582,
0.0098915,0.0111584,0.0125065,0.0142119,0.016096,0.0182075,0.02092,0.0240547,0.0280503,0.0326468,0.0388351,
0.0464365,0.0545088,0.0633121,0.0716931,0.0781575,0.0804964,0.0777027,0.0704262,0.0600149,0.0483206,0.0363663,
0.0261662,0.0182725,0.0126364,0.00894945,0.00729275,0.00513254,0.00391437,0.00282614,0.00233888,0.00193282,
0.00121817,0.000779626,0.000454782,0.000341086,0.000211149,8.1211e-05,3.24844e-05,3.24844e-05,1.62422e-05,
1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,4.87266e-05,8.1211e-05,
8.1211e-05,9.74532e-05,0.000113695,0.000113695,8.1211e-05,8.1211e-05,8.1211e-05,4.87266e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,
1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,0.000113695,0.000178664,0.000243633,0.00029236,
0.000341086,0.000373571,0.000389813,0.000422297,0.000503508,0.000600962,0.000942048,0.00121817,0.00180288,
0.00214397,0.00253378,0.00310226,0.00391437,0.00466151,0.00579847,0.00687045,0.00784498,0.0089657,0.00979405,
0.0102651,0.0105412,0.0105412,0.0103138,0.00994023,0.00945296,0.00886824,0.00846219,0.00802365,0.00763384,
0.0073902,0.00717905,0.00688669,0.00672427,0.00649688,0.00641567,0.00633446,0.00631822,0.00636694,0.00641567,
0.00652937,0.00672427,0.00688669,0.0071953,0.00753638,0.00818607,0.00906315,0.0100864,0.0114508,0.013075,
0.0153976,0.0178339,0.02092,0.0240222,0.027563,0.0312987,0.0361064,0.0415638,0.047817,0.0554996,0.064579,
0.0764521,0.0890885,0.100296,0.108644,0.111438,0.106939,0.0961376,0.0808862,0.0632959,0.0473298,0.0331828,
0.0228365,0.0154463,0.0106549,0.00838098,0.00579847,0.00417425,0.00315099,0.00242009,0.00204652,0.00136435,
0.000877079,0.000503508,0.000389813,0.000276117,0.000113695,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,4.87266e-05,8.1211e-05,8.1211e-05,0.000113695,
0.000113695,0.000113695,0.000113695,0.000113695,0.000113695,0.000113695,0.000113695,8.1211e-05,8.1211e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,
1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,4.87266e-05,0.000113695,0.000162422,0.000211149,0.000276117,
0.000324844,0.000341086,0.000389813,0.000422297,0.000454782,0.000535993,0.000779626,0.00113695,0.0016567,
0.00204652,0.00240385,0.00290735,0.00391437,0.00477521,0.00625325,0.00761759,0.00945296,0.010996,0.0123278,
0.0135135,0.0142931,0.0146342,0.0144718,0.0139196,0.0131075,0.0123116,0.0116294,0.010931,0.0103625,0.0100052,
0.00961538,0.00924181,0.00886824,0.00855964,0.00821856,0.00805613,0.0079262,0.00790995,0.00802365,0.00808862,
0.0082348,0.00849467,0.00870582,0.00912812,0.00964787,0.0103138,0.0113695,0.0127339,0.0148291,0.0173954,
0.0211311,0.0248993,0.0293984,0.0341898,0.040102,0.0462091,0.0520725,0.0584882,0.066122,0.0761597,0.0883413,
0.102846,0.119673,0.13507,0.146488,0.149201,0.141729,0.12487,0.102764,0.0798467,0.0579197,0.040703,0.0273194,
0.0181101,0.0121654,0.00917685,0.00628573,0.0043854,0.00339462,0.00255003,0.00211149,0.00155925,0.000974532,
0.000535993,0.000406055,0.000308602,0.000162422,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,0.000113695,0.000113695,0.000113695,
0.000113695,0.000129938,0.00014618,0.00014618,0.000129938,0.000113695,0.000113695,0.000113695,9.74532e-05,
8.1211e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,
1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,
1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,0.000113695,0.000162422,0.000194906,
0.000259875,0.000308602,0.000341086,0.000389813,0.000406055,0.00043854,0.000503508,0.000617204,0.000942048,
0.00125065,0.00191658,0.00232264,0.00274493,0.00368698,0.004694,0.00631822,0.00808862,0.0103138,0.012604,
0.015089,0.0171518,0.0189059,0.0199292,0.0200916,0.0196693,0.0185486,0.0173629,0.0161935,0.0150728,0.0141145,
0.0133024,0.0127339,0.0121979,0.0118081,0.0112883,0.0107523,0.01046,0.0102001,0.0101839,0.0101839,0.0102001,
0.0102488,0.0103463,0.0105249,0.0107686,0.0112558,0.011938,0.0127339,0.0141307,0.0160473,0.0187922,0.0227716,
0.0273519,0.0326956,0.039566,0.0471349,0.0548662,0.0628086,0.0706049,0.0792132,0.0884875,0.0997596,0.115498,
0.133706,0.154723,0.175205,0.187484,0.189157,0.178502,0.154723,0.12487,0.0948057,0.0679574,0.0470537,
0.0309739,0.0206114,0.0133673,0.00964787,0.00654561,0.00453157,0.00347583,0.00258251,0.00212773,0.0016567,
0.0010395,0.000584719,0.000422297,0.000324844,0.000178664,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,9.74532e-05,0.000113695,0.000113695,0.00014618,
0.000162422,0.000162422,0.000162422,0.000162422,0.000162422,0.000162422,0.000162422,0.000113695,0.000113695,
0.000113695,8.1211e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,
1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,
1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,0.000113695,0.000178664,
0.000243633,0.000276117,0.000341086,0.000357328,0.000389813,0.000422297,0.000471024,0.000535993,0.000795868,
0.00113695,0.00167295,0.00212773,0.00256627,0.0034271,0.0043854,0.00602586,0.00797492,0.0106224,0.0135298,
0.0168756,0.02079,0.0237623,0.0257277,0.0269296,0.0269296,0.0260038,0.0246232,0.0228365,0.0212286,0.0196368,
0.0182562,0.0171518,0.0163884,0.0156737,0.0149591,0.0142119,0.013546,0.0130425,0.0127501,0.0127014,0.012604,
0.0126527,0.0127176,0.0127339,0.0128801,0.0131562,0.0136759,0.0146342,0.0156737,0.0171843,0.0198805,0.023535,
0.0282614,0.0340761,0.0419211,0.0506107,0.0605834,0.0710272,0.0819419,0.0913462,0.100783,0.112201,0.126202,
0.144279,0.166531,0.189514,0.220277,0.248473,0.248035,0.214852,0.179801,0.142996,0.106468,0.0754938,0.0514228,
0.0336863,0.0219919,0.0142931,0.00990774,0.00672427,0.00466151,0.00355704,0.00259875,0.00212773,0.00167295,
0.00108823,0.000617204,0.00043854,0.000341086,0.000194906,4.87266e-05,3.24844e-05,1.62422e-05,1.62422e-05,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,4.87266e-05,8.1211e-05,0.000113695,0.000113695,0.000162422,0.000162422,
0.000162422,0.000162422,0.000162422,0.000162422,0.000162422,0.000162422,0.000162422,0.000162422,0.000113695,
0.000113695,9.74532e-05,8.1211e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,
1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,4.87266e-05,0.000113695,0.000162422,
0.000194906,0.000276117,0.000308602,0.000341086,0.000389813,0.000406055,0.000454782,0.000503508,0.000714657,
0.000974532,0.00136435,0.00199779,0.00233888,0.00290735,0.00404431,0.00535993,0.0073902,0.0101676,0.0134323,
0.0176228,0.0226416,0.0273031,0.0311201,0.03393,0.0355704,0.0355379,0.0339462,0.0315748,0.0294146,0.0269621,
0.025013,0.0236162,0.0221544,0.0211473,0.0199942,0.018841,0.0178015,0.0168756,0.0163072,0.0159823,0.0157062,
0.0156412,0.0156737,0.0157062,0.0157387,0.0159174,0.0161935,0.016632,0.0176065,0.0190196,0.0210661,0.0238436,
0.0281153,0.0337188,0.04158,0.0508868,0.0619965,0.0743243,0.0876754,0.0997109,0.111389,0.122499,0.135899,
0.152238,0.172622,0.195589,0.234879,0.277482,0.294617,0.289225,0.253963,0.19338,0.152807,0.112916,0.0799116,
0.0540378,0.0351806,0.0227716,0.0147479,0.00994023,0.00675676,0.00466151,0.00352456,0.00258251,0.00212773,
0.0016567,0.00108823,0.000682173,0.00043854,0.000341086,0.000227391,8.1211e-05,3.24844e-05,1.62422e-05,
1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,0.000113695,0.000113695,0.00014618,0.000162422,
0.000162422,0.000178664,0.000178664,0.000178664,0.000178664,0.000178664,0.000178664,0.000162422,0.000162422,
0.000162422,0.000113695,0.000113695,8.1211e-05,4.87266e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,1.62422e-05,
1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,0.000113695,0.000162422,0.000194906,0.000243633,0.00029236,0.000341086,0.000373571,0.000406055,
0.00043854,0.000503508,0.000584719,0.000844595,0.00116944,0.00172167,0.0021927,0.00264748,0.00358953,
0.00466151,0.00656185,0.00924181,0.0124578,0.0169081,0.0228203,0.029106,0.0352131,0.040703,0.0444062,
0.0464527,0.0461766,0.0439676,0.0408654,0.0372109,0.0338812,0.0312662,0.0294146,0.0276605,0.0260687,0.0246719,
0.0234537,0.0219919,0.0209524,0.0200429,0.0194906,0.0191658,0.0191171,0.0191983,0.0192795,0.0193282,0.0194582,
0.0198155,0.0204977,0.0213585,0.0227716,0.0247856,0.0281315,0.0329392,0.0399071,0.0486454,0.0593815,0.0724402,
0.0871394,0.101806,0.116668,0.129142,0.141973,0.156364,0.174912,0.195199,0.230379,0.276556,0.304574,0.314985,
0.303583,0.265771,0.197846,0.154285,0.113484,0.0802202,0.0540541,0.0350344,0.0226904,0.0147154,0.00976156,
0.00667555,0.00456406,0.00345959,0.00256627,0.00211149,0.0016567,0.00108823,0.000682173,0.000454782,0.000341086,
0.000243633,9.74532e-05,3.24844e-05,3.24844e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,8.1211e-05,0.000113695,0.000113695,0.000162422,0.000162422,0.000178664,0.000178664,0.000178664,
0.000178664,0.000194906,0.000178664,0.000178664,0.000178664,0.000162422,0.000162422,0.000162422,0.000113695,
0.000113695,8.1211e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,
1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,4.87266e-05,0.000113695,0.00014618,
0.000178664,0.000243633,0.000276117,0.000324844,0.000341086,0.000389813,0.000422297,0.000471024,0.000535993,
0.000779626,0.00108823,0.0014618,0.00204652,0.00237136,0.00306978,0.00414176,0.00558732,0.00779626,0.0110934,
0.0153976,0.021456,0.0286188,0.0366749,0.0447798,0.0512279,0.0558407,0.0577898,0.0575786,0.0552235,0.0512604,
0.0471186,0.0426683,0.0391437,0.0360739,0.0335564,0.0313799,0.029642,0.0278391,0.0261987,0.0248343,0.0237786,
0.0231289,0.0227716,0.0227716,0.0229015,0.022999,0.0230802,0.0232588,0.0236486,0.0241684,0.0250617,0.0265722,
0.0288949,0.0324357,0.0382666,0.0462091,0.0554996,0.067129,0.0818932,0.0970959,0.113078,0.128638,0.14285,
0.156656,0.172768,0.190099,0.220797,0.266275,0.297687,0.318298,0.322002,0.304054,0.259713,0.191398,0.149266,
0.109537,0.0774428,0.0523486,0.0337351,0.0219107,0.0143256,0.0094692,0.00648064,0.00445036,0.00339462,
0.00253378,0.002079,0.00159174,0.0010395,0.000617204,0.00043854,0.000341086,0.000243633,0.000113695,3.24844e-05,
3.24844e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,0.000113695,0.000129938,0.000162422,
0.000162422,0.000178664,0.000178664,0.000194906,0.000194906,0.000194906,0.000194906,0.000194906,0.000178664,
0.000178664,0.000162422,0.000162422,0.00014618,0.000113695,0.000113695,6.49688e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,
0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,6.49688e-05,0.000113695,0.00014618,0.000178664,0.000211149,
0.000276117,0.000324844,0.000341086,0.000389813,0.000406055,0.000454782,0.000503508,0.000714657,0.000974532,
0.00123441,0.00185161,0.00220894,0.00269621,0.00360577,0.00466151,0.00656185,0.00938799,0.01301,0.0185486,
0.026085,0.0349532,0.0454294,0.054785,0.0628086,0.0686071,0.0712058,0.0710434,0.0684446,0.063507,0.0580659,
0.0529496,0.0478008,0.0437078,0.0405243,0.0375195,0.0347908,0.032322,0.0303404,0.0286512,0.0275143,0.0266535,
0.0264261,0.0264098,0.0265398,0.0266535,0.0267509,0.0269783,0.027563,0.0283102,0.0293984,0.0309252,0.0335726,
0.0380555,0.0440813,0.0521212,0.0621102,0.0738858,0.0884875,0.104242,0.120582,0.136646,0.152076,0.167928,
0.184804,0.208842,0.253947,0.291759,0.317438,0.331081,0.327963,0.3023,0.248896,0.185486,0.142428,0.103723,
0.072895,0.0495874,0.0321433,0.0210661,0.0137571,0.00917685,0.00628573,0.0043854,0.00337838,0.00251754,
0.002079,0.00147804,0.000990774,0.000600962,0.00043854,0.000341086,0.000243633,0.000113695,3.24844e-05,
3.24844e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,4.87266e-05,8.1211e-05,0.000113695,0.00014618,0.000162422,
0.000162422,0.000178664,0.000194906,0.000194906,0.000194906,0.000194906,0.000194906,0.000194906,0.000194906,
0.000178664,0.000178664,0.000162422,0.000162422,0.000113695,0.000113695,8.1211e-05,4.87266e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,
1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,4.87266e-05,8.1211e-05,0.000113695,0.000162422,0.000178664,
0.000211149,0.000276117,0.000308602,0.000341086,0.000373571,0.000406055,0.000454782,0.000503508,0.000617204,
0.000844595,0.00116944,0.00167295,0.002079,0.00243633,0.00313475,0.00412552,0.00544114,0.00753638,0.0107686,
0.0154463,0.0223493,0.0312987,0.0426195,0.054655,0.0656835,0.0756399,0.0829489,0.086376,0.086506,0.0834524,
0.0778489,0.0709622,0.063978,0.0575786,0.0520725,0.047476,0.0437727,0.0405081,0.0373246,0.0344822,0.0323707,
0.0310064,0.0302917,0.0299669,0.0299994,0.0301618,0.0304054,0.0308115,0.0310064,0.0315748,0.0326956,0.0341736,
0.0364962,0.0396959,0.0441788,0.0502371,0.058342,0.0685746,0.0804964,0.093685,0.109472,0.125487,0.142509,
0.158556,0.176748,0.197879,0.2398,0.289257,0.325104,0.348834,0.356159,0.344676,0.311282,0.251722,0.183001,
0.13814,0.0993211,0.0692405,0.0471674,0.0308439,0.0201566,0.0132699,0.00883576,0.00609083,0.00433667,
0.00337838,0.00251754,0.00204652,0.00144556,0.000974532,0.000584719,0.000422297,0.000341086,0.000243633,
0.000113695,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,4.87266e-05,
8.1211e-05,0.000113695,0.00014618,0.000162422,0.000178664,0.000178664,0.000194906,0.000194906,0.000194906,
0.000194906,0.000194906,0.000194906,0.000194906,0.000194906,0.000178664,0.000178664,0.000162422,0.000162422,
0.000113695,0.000113695,8.1211e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,4.87266e-05,9.74532e-05,0.000113695,
0.000162422,0.000162422,0.000194906,0.000227391,0.000276117,0.000308602,0.000341086,0.000373571,0.000406055,
0.00043854,0.000503508,0.000584719,0.00081211,0.00108823,0.00144556,0.00199779,0.00232264,0.00271245,
0.00363825,0.00456406,0.00641567,0.00890073,0.012474,0.018305,0.0268484,0.0380717,0.0512766,0.0648876,
0.0790021,0.090063,0.097843,0.102423,0.103024,0.0996134,0.0936688,0.0861974,0.0775403,0.0688182,0.0610707,
0.0550611,0.0499773,0.0464527,0.0424734,0.0394036,0.0367236,0.0349857,0.0339949,0.0336376,0.0337513,0.0341249,
0.0346284,0.0352293,0.035944,0.0369023,0.0382666,0.0404756,0.0430743,0.0468588,0.0512766,0.0577573,0.0656835,
0.0756075,0.0867659,0.0991587,0.114573,0.130604,0.147625,0.16567,0.186883,0.225572,0.289436,0.336587,
0.377209,0.403408,0.405698,0.383348,0.33839,0.273405,0.187841,0.139439,0.0982004,0.0677137,0.0456081,
0.0298044,0.0195394,0.0127664,0.00864085,0.00599337,0.00432043,0.00337838,0.00251754,0.00204652,0.00138059,
0.000942048,0.000552235,0.000422297,0.000341086,0.000243633,0.000113695,3.24844e-05,3.24844e-05,1.62422e-05,
1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,0.000113695,0.00014618,0.000162422,0.000178664,
0.000178664,0.000194906,0.000194906,0.000194906,0.000194906,0.000194906,0.000194906,0.000194906,0.000194906,
0.000178664,0.000178664,0.000162422,0.000162422,0.00014618,0.000113695,0.000113695,8.1211e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,4.87266e-05,8.1211e-05,
0.000113695,0.000113695,0.000162422,0.000162422,0.000178664,0.000211149,0.000243633,0.000276117,0.000308602,
0.000341086,0.000373571,0.000389813,0.000422297,0.000503508,0.000568477,0.000779626,0.000990774,0.00123441,
0.00181913,0.0021927,0.00258251,0.0032322,0.004158,0.00535993,0.00737396,0.010395,0.0149266,0.0221219,
0.0323382,0.0465502,0.0617204,0.078596,0.0941236,0.107442,0.117659,0.122336,0.122629,0.119169,0.111795,
0.102017,0.0920121,0.081747,0.0714332,0.0633446,0.0572538,0.0526085,0.0483693,0.0450559,0.042116,0.040102,
0.0389001,0.0383803,0.0386564,0.0393224,0.0399071,0.0407679,0.0417912,0.0429931,0.0449584,0.0474597,0.0505782,
0.0548499,0.0602423,0.0671615,0.0752989,0.0845082,0.0946108,0.106273,0.120615,0.136857,0.154772,0.17639,
0.207202,0.279155,0.342564,0.40448,0.450136,0.474483,0.471544,0.441593,0.38637,0.308456,0.204506,0.146229,
0.101091,0.0685746,0.0454457,0.0293821,0.0190846,0.0125227,0.00859213,0.00597713,0.00433667,0.00337838,
0.00253378,0.00204652,0.00136435,0.000942048,0.000535993,0.000422297,0.000341086,0.000243633,0.000113695,
3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,
1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,0.000113695,
0.00014618,0.000162422,0.000178664,0.000178664,0.000194906,0.000194906,0.000194906,0.000194906,0.000194906,
0.000194906,0.000194906,0.000194906,0.000194906,0.000178664,0.000178664,0.000162422,0.000162422,0.000129938,
0.000113695,9.74532e-05,6.49688e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,
0.000113695,0.000113695,0.000162422,0.000162422,0.000178664,0.000194906,0.000211149,0.000243633,0.000276117,
0.000276117,0.000308602,0.000341086,0.000357328,0.000389813,0.000422297,0.000487266,0.000535993,0.000747141,
0.00095829,0.00118568,0.00167295,0.002079,0.00240385,0.00289111,0.00376819,0.004694,0.00641567,0.008852,
0.0123278,0.0182075,0.0274493,0.0406055,0.0569452,0.0763546,0.0967873,0.116749,0.132163,0.142883,0.148064,
0.148064,0.143143,0.133836,0.1218,0.108904,0.0960077,0.0843458,0.0740969,0.0662682,0.0605347,0.0561493,
0.0524461,0.049019,0.046875,0.0451858,0.0443412,0.0445036,0.045397,0.0466151,0.047476,0.0486616,0.0502371,
0.0528196,0.0558894,0.0598525,0.0648714,0.0715794,0.0797492,0.0876104,0.0961701,0.105623,0.11709,0.130457,
0.147171,0.167441,0.191934,0.256708,0.330951,0.407858,0.477342,0.529723,0.554639,0.549295,0.513514,0.445394,
0.353349,0.240044,0.157371,0.106874,0.0711084,0.0468912,0.0299019,0.0192145,0.0125227,0.00865709,0.0060421,
0.00436915,0.00339462,0.00253378,0.00204652,0.00136435,0.000893321,0.000535993,0.000406055,0.000341086,
0.000243633,0.000129938,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,8.1211e-05,0.000113695,0.000113695,0.000162422,0.000162422,0.000178664,0.000194906,0.000194906,
0.000194906,0.000194906,0.000194906,0.000194906,0.000194906,0.000194906,0.000194906,0.000194906,0.000178664,
0.000178664,0.000162422,0.000162422,0.000113695,0.000113695,8.1211e-05,4.87266e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,4.87266e-05,8.1211e-05,
0.000113695,0.000113695,0.000162422,0.000162422,0.000178664,0.000194906,0.000211149,0.000243633,0.000243633,
0.000276117,0.000276117,0.000308602,0.000324844,0.000341086,0.000373571,0.000389813,0.000422297,0.000471024,
0.000535993,0.000714657,0.000877079,0.00113695,0.0014618,0.00196531,0.00232264,0.00269621,0.00345959,
0.00430418,0.00563604,0.00760135,0.0108173,0.0157387,0.024006,0.0360415,0.0529658,0.0737558,0.0987851,
0.126299,0.151978,0.171501,0.182871,0.186396,0.184544,0.176813,0.164436,0.148632,0.131643,0.115628,0.10088,
0.089527,0.0803989,0.0726514,0.0670478,0.0625487,0.0583745,0.0554509,0.0534044,0.0521375,0.0521375,0.0530308,
0.0543302,0.0558407,0.0575299,0.0593165,0.0622564,0.0659921,0.0712058,0.0785311,0.0863273,0.0949357,0.103398,
0.11186,0.120517,0.131253,0.145189,0.163153,0.186201,0.23254,0.313085,0.395075,0.476384,0.549263,0.599419,
0.625,0.617382,0.578564,0.507812,0.405649,0.28609,0.172297,0.115238,0.0760785,0.0494738,0.0312987,0.0199292,
0.0127664,0.00891697,0.00613955,0.0043854,0.00339462,0.00253378,0.00206276,0.00136435,0.000877079,0.000503508,
0.000406055,0.000341086,0.000243633,0.000162422,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,0.000113695,0.000113695,0.000162422,0.000162422,0.000178664,
0.000178664,0.000194906,0.000194906,0.000194906,0.000194906,0.000194906,0.000194906,0.000194906,0.000194906,
0.000194906,0.000194906,0.000178664,0.000178664,0.000162422,0.000162422,0.000113695,0.000113695,8.1211e-05,
8.1211e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,8.1211e-05,0.000113695,
0.000113695,0.000162422,0.000162422,0.000178664,0.000194906,0.000227391,0.000243633,0.000259875,0.000276117,
0.000276117,0.000308602,0.000324844,0.000341086,0.000341086,0.000341086,0.000373571,0.000389813,0.000422297,
0.000454782,0.000503508,0.000617204,0.00081211,0.0010395,0.00123441,0.00178664,0.00212773,0.00251754,
0.00308602,0.00399558,0.00503508,0.00687045,0.00968035,0.0141145,0.0217321,0.0331828,0.0498148,0.0716444,
0.100588,0.13624,0.176407,0.217857,0.267785,0.287471,0.288202,0.274477,0.248278,0.212578,0.186558,0.165362,
0.14402,0.125617,0.111389,0.0998408,0.0913137,0.0836473,0.0770368,0.071287,0.0671778,0.0638319,0.0621589,
0.0616392,0.0625162,0.0638806,0.0659758,0.0687045,0.0709622,0.0743568,0.0796355,0.0855314,0.0933927,0.103219,
0.113874,0.122905,0.131237,0.139732,0.149851,0.165199,0.185762,0.22385,0.297687,0.3731,0.460109,0.54426,
0.611113,0.667685,0.689449,0.681896,0.635622,0.56073,0.452589,0.323366,0.188004,0.124513,0.0822505,0.0532095,
0.0334914,0.0212286,0.0133673,0.00929054,0.00626949,0.0043854,0.00339462,0.00253378,0.00204652,0.00136435,
0.000844595,0.000503508,0.000406055,0.000341086,0.000243633,0.000162422,4.87266e-05,3.24844e-05,3.24844e-05,
1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,4.87266e-05,0.000113695,0.000113695,0.000162422,0.000162422,
0.000162422,0.000178664,0.000178664,0.000194906,0.000194906,0.000194906,0.000194906,0.000211149,0.000211149,
0.000194906,0.000194906,0.000194906,0.000194906,0.000178664,0.000178664,0.000162422,0.000162422,0.000162422,
0.000113695,0.000113695,0.000113695,0.000113695,0.000113695,0.000113695,0.000113695,0.00014618,0.000162422,
0.000178664,0.000194906,0.000194906,0.000243633,0.000243633,0.000276117,0.000276117,0.00029236,0.000308602,
0.000324844,0.000341086,0.000341086,0.000341086,0.000357328,0.000373571,0.000389813,0.000389813,0.000422297,
0.000454782,0.000503508,0.000584719,0.000779626,0.000974532,0.00116944,0.00155925,0.00201403,0.00233888,
0.00271245,0.00357328,0.00443412,0.00607458,0.00860837,0.0123441,0.0193607,0.0304054,0.0470374,0.0693705,
0.0998571,0.141957,0.193282,0.290947,0.359651,0.40638,0.424214,0.418302,0.395936,0.360382,0.324373,0.281364,
0.224191,0.187078,0.164257,0.144864,0.129434,0.11735,0.106127,0.0968847,0.0892509,0.0831114,0.0781575,
0.074503,0.0732848,0.0740644,0.0761922,0.0791483,0.0823155,0.0854665,0.089527,0.094887,0.101936,0.111941,
0.123035,0.135298,0.146066,0.154203,0.161594,0.17181,0.187386,0.220569,0.286399,0.352667,0.434755,0.520936,
0.599272,0.671826,0.712919,0.730656,0.722404,0.687029,0.604113,0.493227,0.354064,0.207916,0.135151,0.0882601,
0.0564579,0.0358303,0.0225117,0.0141145,0.00951793,0.00633446,0.0043854,0.00337838,0.00251754,0.00204652,
0.00136435,0.000844595,0.000503508,0.000389813,0.000341086,0.000259875,0.000162422,8.1211e-05,3.24844e-05,
3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,
1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,0.000113695,
0.000129938,0.000162422,0.000162422,0.000178664,0.000178664,0.000194906,0.000194906,0.000194906,0.000211149,
0.000211149,0.000227391,0.000227391,0.000227391,0.000211149,0.000211149,0.000194906,0.000194906,0.000194906,
0.000178664,0.000178664,0.000162422,0.000162422,0.000162422,0.000162422,0.000162422,0.000162422,0.000178664,
0.000194906,0.000211149,0.000243633,0.000259875,0.000276117,0.000276117,0.000308602,0.000308602,0.000324844,
0.000341086,0.000341086,0.000341086,0.000357328,0.000373571,0.000389813,0.000389813,0.000389813,0.000406055,
0.000422297,0.000454782,0.000503508,0.000552235,0.000747141,0.000860837,0.00108823,0.00123441,0.00172167,
0.00212773,0.00246881,0.00305353,0.0039631,0.00511629,0.00721154,0.0106224,0.0161935,0.0260038,0.0414826,
0.0632959,0.094887,0.138773,0.199682,0.322408,0.427186,0.509534,0.558326,0.575786,0.564985,0.532858,0.490677,
0.443916,0.395384,0.341379,0.293107,0.236373,0.193834,0.17246,0.15318,0.137068,0.122629,0.111746,0.102017,
0.0951468,0.0903391,0.0878378,0.0881464,0.0902742,0.0930029,0.0965924,0.100848,0.106127,0.1129,0.121557,
0.132942,0.145904,0.158199,0.169357,0.177527,0.184252,0.193006,0.218019,0.273454,0.33126,0.404902,0.486811,
0.571644,0.65128,0.712854,0.749951,0.764585,0.754808,0.717516,0.639569,0.525143,0.382569,0.229145,0.144279,
0.0934576,0.05995,0.0380717,0.0237623,0.0147317,0.00959914,0.00636694,0.0043854,0.00332965,0.00246881,
0.00204652,0.00123441,0.00081211,0.000503508,0.000406055,0.000341086,0.000276117,0.000178664,0.000113695,
3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,
0.000113695,0.000113695,0.000162422,0.000162422,0.000178664,0.000178664,0.000194906,0.000194906,0.000211149,
0.000227391,0.000243633,0.000243633,0.000243633,0.000243633,0.000243633,0.000243633,0.000243633,0.000243633,
0.000243633,0.000227391,0.000211149,0.000194906,0.000194906,0.000194906,0.000194906,0.000211149,0.000243633,
0.000243633,0.000276117,0.000276117,0.00029236,0.000308602,0.000324844,0.000341086,0.000341086,0.000341086,
0.000341086,0.000357328,0.000373571,0.000389813,0.000389813,0.000389813,0.000406055,0.000406055,0.000422297,
0.000422297,0.000454782,0.000503508,0.000535993,0.000682173,0.00081211,0.000974532,0.00116944,0.00142931,
0.0018841,0.00220894,0.00264748,0.00339462,0.00430418,0.00586344,0.00846219,0.0127014,0.0205301,0.0329392,
0.0530308,0.0821043,0.123311,0.18443,0.312906,0.442421,0.558033,0.642152,0.695118,0.709849,0.699129,0.66939,
0.619413,0.573139,0.52334,0.467418,0.41239,0.357199,0.306929,0.253525,0.202605,0.177397,0.15586,0.139748,
0.125991,0.116099,0.108303,0.1046,0.104291,0.10624,0.109765,0.114329,0.119348,0.12526,0.13343,0.143792,
0.155568,0.169146,0.180256,0.188832,0.196856,0.205772,0.221787,0.261126,0.30779,0.366343,0.442421,0.526946,
0.608871,0.692015,0.746735,0.782468,0.795137,0.779528,0.737217,0.662991,0.54361,0.399737,0.249643,0.149721,
0.0974532,0.0628086,0.0396959,0.024477,0.0149591,0.00950169,0.00628573,0.00432043,0.00321596,0.00242009,
0.00199779,0.00121817,0.000795868,0.000503508,0.000406055,0.000341086,0.000276117,0.000194906,0.000113695,
3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,4.87266e-05,
9.74532e-05,0.000113695,0.00014618,0.000162422,0.000162422,0.000178664,0.000194906,0.000194906,0.000227391,
0.000243633,0.000243633,0.000243633,0.000259875,0.000276117,0.000276117,0.000276117,0.000276117,0.000276117,
0.000276117,0.000276117,0.000276117,0.000276117,0.000276117,0.000276117,0.000276117,0.000276117,0.00029236,
0.000308602,0.000324844,0.000341086,0.000341086,0.000341086,0.000341086,0.000357328,0.000373571,0.000389813,
0.000389813,0.000389813,0.000389813,0.000406055,0.000406055,0.000422297,0.000422297,0.00043854,0.00043854,
0.000454782,0.000503508,0.000535993,0.000600962,0.000747141,0.000877079,0.00107199,0.00121817,0.00164046,
0.00199779,0.00232264,0.00269621,0.00358953,0.00446661,0.00641567,0.0094692,0.014618,0.0237786,0.0390138,
0.0626624,0.0972096,0.149769,0.248197,0.395465,0.535424,0.653099,0.730217,0.773308,0.790492,0.783881,
0.760915,0.729519,0.691804,0.64134,0.587643,0.533199,0.472128,0.412373,0.352732,0.299831,0.240677,0.193542,
0.171469,0.15318,0.140073,0.130457,0.125374,0.125,0.127599,0.130993,0.135249,0.140511,0.147057,0.155162,
0.166125,0.177982,0.188621,0.199519,0.208875,0.216833,0.226806,0.251088,0.285976,0.330902,0.393662,0.467207,
0.551926,0.636435,0.716476,0.771716,0.807903,0.815976,0.794764,0.744283,0.664452,0.542035,0.399688,0.251527,
0.151312,0.0993536,0.0640105,0.0405405,0.0246881,0.0149591,0.00924181,0.00605834,0.00420673,0.00308602,
0.00233888,0.00191658,0.00118568,0.000779626,0.000503508,0.000406055,0.000341086,0.000276117,0.000194906,
0.000113695,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,8.1211e-05,0.000113695,0.000113695,0.000162422,0.000162422,0.000178664,0.000194906,
0.000211149,0.000243633,0.000243633,0.000259875,0.000276117,0.000276117,0.000276117,0.00029236,0.000308602,
0.000308602,0.000308602,0.000308602,0.000308602,0.000308602,0.000308602,0.000308602,0.000324844,0.000324844,
0.000341086,0.000341086,0.000341086,0.000357328,0.000373571,0.000389813,0.000389813,0.000389813,0.000389813,
0.000406055,0.000406055,0.000406055,0.000422297,0.000422297,0.000422297,0.00043854,0.00043854,0.000454782,
0.000471024,0.000487266,0.000503508,0.000503508,0.000568477,0.000714657,0.00081211,0.000974532,0.00113695,
0.00123441,0.00167295,0.00204652,0.00233888,0.00279366,0.00367074,0.00466151,0.00662682,0.00994023,0.0154788,
0.0252566,0.0420998,0.0678599,0.105769,0.163949,0.285733,0.43188,0.571742,0.688994,0.757894,0.80407,0.825591,
0.826696,0.815294,0.792473,0.760476,0.723671,0.681978,0.62271,0.563296,0.501007,0.438426,0.376933,0.32015,
0.265674,0.20868,0.183326,0.168123,0.157127,0.151491,0.15063,0.153245,0.156624,0.160359,0.164842,0.169942,
0.177219,0.185941,0.196238,0.209719,0.219383,0.224565,0.229405,0.242301,0.266356,0.297703,0.342483,0.404057,
0.47627,0.558846,0.64592,0.725214,0.782127,0.816674,0.821888,0.793432,0.735203,0.64246,0.521602,0.382455,
0.234521,0.148259,0.0983628,0.0638319,0.0402969,0.0244445,0.0146667,0.008852,0.00579847,0.00412552,0.00290735,
0.00232264,0.00180288,0.0011532,0.000747141,0.000503508,0.000406055,0.000341086,0.000308602,0.000227391,
0.000162422,8.1211e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,8.1211e-05,0.000113695,0.000113695,0.000162422,0.000162422,0.000178664,0.000194906,
0.000227391,0.000243633,0.000259875,0.000276117,0.000276117,0.000308602,0.000308602,0.000324844,0.000324844,
0.000341086,0.000341086,0.000341086,0.000341086,0.000341086,0.000341086,0.000341086,0.000357328,0.000373571,
0.000389813,0.000389813,0.000389813,0.000406055,0.000406055,0.000406055,0.000422297,0.000422297,0.000422297,
0.00043854,0.00043854,0.00043854,0.000454782,0.000454782,0.000471024,0.000471024,0.000487266,0.000503508,
0.000503508,0.000503508,0.000535993,0.000552235,0.000617204,0.000763384,0.000860837,0.00100702,0.0011532,
0.0013481,0.00168919,0.00204652,0.00233888,0.00279366,0.00367074,0.00466151,0.00657809,0.00985902,0.0153326,
0.0249155,0.0411902,0.0659921,0.102927,0.158297,0.269588,0.410522,0.544455,0.653408,0.728008,0.776361,
0.80649,0.8195,0.820134,0.808699,0.78635,0.754369,0.71797,0.675773,0.613192,0.557855,0.500227,0.439514,
0.380084,0.325835,0.276004,0.225978,0.199795,0.187191,0.18227,0.18037,0.181994,0.184203,0.186201,0.188393,
0.190683,0.196498,0.205383,0.21607,0.226969,0.233514,0.234034,0.234521,0.247255,0.269507,0.300627,0.344156,
0.402677,0.470683,0.548093,0.62997,0.713228,0.768792,0.802186,0.804379,0.771862,0.709833,0.60689,0.486454,
0.351644,0.211782,0.140641,0.0945946,0.0616879,0.0389488,0.0236649,0.0140982,0.00838098,0.00540865,0.00391437,
0.00277742,0.00220894,0.00168919,0.00113695,0.000714657,0.000503508,0.000406055,0.000341086,0.000308602,
0.000243633,0.000162422,8.1211e-05,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,0.000113695,0.000113695,0.000162422,0.000178664,0.000194906,
0.000211149,0.000243633,0.000259875,0.000276117,0.00029236,0.000308602,0.000324844,0.000341086,0.000341086,
0.000341086,0.000341086,0.000341086,0.000357328,0.000373571,0.000373571,0.000389813,0.000389813,0.000389813,
0.000406055,0.000406055,0.000422297,0.000422297,0.00043854,0.00043854,0.000454782,0.000454782,0.000471024,
0.000471024,0.000487266,0.000503508,0.000503508,0.000503508,0.000503508,0.000503508,0.000503508,0.000503508,
0.000503508,0.000535993,0.000535993,0.000552235,0.000584719,0.000714657,0.000795868,0.000909563,0.0010395,
0.00116944,0.00136435,0.00168919,0.00204652,0.00233888,0.00274493,0.00358953,0.00445036,0.00630198,0.00922557,
0.0139521,0.0223818,0.0362364,0.0579197,0.0899168,0.13481,0.199519,0.332039,0.449714,0.549165,0.625179,
0.690748,0.727878,0.75294,0.766405,0.767542,0.756952,0.735821,0.706682,0.670917,0.620745,0.576761,0.531672,
0.480314,0.429606,0.379905,0.332007,0.294292,0.265479,0.238598,0.225003,0.220439,0.218506,0.218165,0.218718,
0.219903,0.220179,0.222063,0.227277,0.23405,0.241197,0.244526,0.240774,0.236649,0.245728,0.267314,0.296826,
0.338699,0.393337,0.453758,0.523389,0.597388,0.680711,0.735057,0.764472,0.76491,0.733774,0.670446,0.564043,
0.443428,0.316772,0.189254,0.130279,0.0881302,0.0575949,0.0363825,0.0221219,0.0131724,0.00761759,0.00503508,
0.00367074,0.00264748,0.00212773,0.0016567,0.00105574,0.000682173,0.000487266,0.000406055,0.000357328,
0.000324844,0.000243633,0.000162422,0.000113695,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,
1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,0.000113695,0.000113695,0.000162422,
0.000178664,0.000194906,0.000227391,0.000243633,0.000276117,0.00029236,0.000308602,0.000324844,0.000341086,
0.000341086,0.000357328,0.000373571,0.000373571,0.000389813,0.000389813,0.000389813,0.000406055,0.000406055,
0.000422297,0.000422297,0.00043854,0.000454782,0.000471024,0.000503508,0.000503508,0.000503508,0.000503508,
0.000503508,0.000503508,0.000535993,0.000535993,0.000535993,0.000535993,0.000535993,0.000535993,0.000535993,
0.000535993,0.000535993,0.000552235,0.000552235,0.000568477,0.000584719,0.000617204,0.000747141,0.00081211,
0.000942048,0.0010395,0.00116944,0.00136435,0.00168919,0.00201403,0.00229015,0.00264748,0.00341086,0.00425546,
0.00574974,0.00807238,0.0120842,0.0184024,0.029171,0.0461279,0.0697115,0.101952,0.145774,0.202881,0.307692,
0.390268,0.460044,0.522999,0.575136,0.615921,0.650419,0.670121,0.670965,0.658004,0.632325,0.607572,0.583875,
0.560015,0.533589,0.501462,0.465956,0.42868,0.389309,0.352245,0.327069,0.307692,0.293951,0.284531,0.277271,
0.27118,0.267054,0.263595,0.259014,0.254532,0.25419,0.254889,0.254012,0.251917,0.247028,0.240108,0.244267,
0.262149,0.288429,0.3259,0.37193,0.427381,0.487883,0.554022,0.618925,0.68292,0.711961,0.713341,0.684154,
0.610431,0.518013,0.402823,0.281234,0.173467,0.118958,0.0806101,0.0527709,0.0330691,0.0203515,0.0121979,
0.00713033,0.004694,0.00345959,0.00253378,0.00204652,0.0014618,0.0010395,0.000617204,0.000471024,0.000406055,
0.000357328,0.000324844,0.000259875,0.000178664,0.000113695,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,
1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,
1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,0.000113695,0.00014618,
0.000162422,0.000178664,0.000211149,0.000243633,0.000276117,0.000276117,0.000308602,0.000341086,0.000341086,
0.000341086,0.000373571,0.000389813,0.000389813,0.000389813,0.000406055,0.000406055,0.000422297,0.00043854,
0.00043854,0.000471024,0.000503508,0.000503508,0.000503508,0.000535993,0.000535993,0.000535993,0.000552235,
0.000568477,0.000584719,0.000584719,0.000584719,0.000600962,0.000600962,0.000600962,0.000600962,0.000600962,
0.000600962,0.000600962,0.000600962,0.000600962,0.000600962,0.000617204,0.000617204,0.000714657,0.000747141,
0.000828352,0.000942048,0.0010395,0.0011532,0.00123441,0.0016567,0.00193282,0.0021927,0.00253378,0.00308602,
0.0039631,0.00503508,0.00695166,0.0100052,0.0144718,0.0216671,0.0324194,0.0486941,0.0696791,0.0960889,
0.127989,0.163949,0.200266,0.261467,0.314953,0.366781,0.419163,0.460986,0.491034,0.506286,0.510281,0.508251,
0.506562,0.508072,0.509697,0.508413,0.501608,0.487948,0.466882,0.442048,0.416077,0.393614,0.370127,0.350767,
0.334573,0.321141,0.309658,0.300773,0.293042,0.286041,0.279593,0.273389,0.268695,0.264147,0.258511,0.251397,
0.243877,0.242382,0.254126,0.274786,0.306068,0.34578,0.395465,0.445767,0.50229,0.557579,0.606094,0.64017,
0.647041,0.617041,0.558846,0.469984,0.360723,0.238533,0.15638,0.107166,0.0720017,0.0472323,0.0294958,
0.0180288,0.0111584,0.00652937,0.0043854,0.00319971,0.00242009,0.00203028,0.00136435,0.000974532,0.000617204,
0.000471024,0.000406055,0.000373571,0.000324844,0.000259875,0.000178664,0.000113695,3.24844e-05,3.24844e-05,
3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,
1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,
0.000113695,0.000162422,0.000178664,0.000194906,0.000227391,0.000259875,0.000276117,0.000308602,0.000324844,
0.000341086,0.000357328,0.000373571,0.000389813,0.000389813,0.000406055,0.000422297,0.000422297,0.00043854,
0.000454782,0.000503508,0.000503508,0.000535993,0.000535993,0.000568477,0.000584719,0.000617204,0.000617204,
0.000682173,0.000714657,0.000730899,0.000730899,0.000747141,0.000747141,0.000747141,0.000747141,0.000747141,
0.000730899,0.000730899,0.000714657,0.000698415,0.000682173,0.000682173,0.000682173,0.000682173,0.000698415,
0.000747141,0.000779626,0.000828352,0.000942048,0.0010395,0.00113695,0.00121817,0.00151052,0.00180288,
0.002079,0.00233888,0.00274493,0.00355704,0.0043854,0.00586344,0.00784498,0.0110447,0.0153651,0.0218133,
0.0309252,0.0434154,0.0579197,0.0752176,0.0931328,0.111535,0.129662,0.149201,0.173515,0.200867,0.244916,
0.283605,0.308033,0.329587,0.349272,0.371167,0.400338,0.429038,0.456032,0.47627,0.488143,0.490433,0.483888,
0.471024,0.454587,0.433131,0.407858,0.38265,0.359343,0.343458,0.330724,0.319841,0.310421,0.3004,0.290053,
0.280519,0.271846,0.264212,0.254921,0.246021,0.240498,0.244867,0.260525,0.285148,0.318428,0.358498,0.40612,
0.453417,0.501624,0.544422,0.572976,0.581812,0.562532,0.510298,0.426601,0.323187,0.202134,0.140739,0.0962188,
0.0640917,0.0419211,0.026085,0.0160473,0.0101189,0.00605834,0.00417425,0.00297232,0.00233888,0.00196531,
0.00131562,0.00095829,0.000600962,0.000471024,0.000406055,0.000373571,0.000324844,0.000259875,0.000178664,
0.000113695,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,8.1211e-05,0.000113695,0.000162422,0.000178664,0.000194906,0.000243633,0.000276117,
0.000308602,0.000324844,0.000341086,0.000357328,0.000389813,0.000389813,0.000406055,0.000422297,0.000422297,
0.000454782,0.000471024,0.000503508,0.000503508,0.000535993,0.000584719,0.000617204,0.000714657,0.000747141,
0.000747141,0.000795868,0.000795868,0.000795868,0.00081211,0.00081211,0.00081211,0.00081211,0.00081211,
0.00081211,0.00081211,0.000795868,0.000795868,0.000795868,0.000779626,0.000747141,0.000747141,0.000747141,
0.000747141,0.000730899,0.000747141,0.000747141,0.000779626,0.00081211,0.000877079,0.000974532,0.00108823,
0.00118568,0.00136435,0.00167295,0.00196531,0.0021927,0.00251754,0.00297232,0.00383316,0.004694,0.00628573,
0.0082348,0.0108985,0.0142119,0.0189059,0.0251592,0.0323382,0.0414663,0.0506107,0.0596576,0.069273,0.0800091,
0.0921258,0.106127,0.121427,0.136402,0.151946,0.170413,0.189563,0.22333,0.280064,0.329457,0.379402,0.42527,
0.461993,0.490076,0.506302,0.511581,0.504938,0.485626,0.457397,0.426033,0.398519,0.374951,0.359343,0.349337,
0.338796,0.325396,0.30766,0.292067,0.279203,0.267607,0.256432,0.245257,0.237169,0.235902,0.246118,0.267282,
0.294617,0.329798,0.369786,0.415849,0.459232,0.498067,0.526101,0.534141,0.516729,0.465307,0.386337,0.286253,
0.181555,0.12716,0.086912,0.0576761,0.0374383,0.023535,0.0145205,0.00929054,0.00574974,0.00410928,0.00290735,
0.00233888,0.00194906,0.00128313,0.000942048,0.000600962,0.000471024,0.000406055,0.000373571,0.000324844,
0.000259875,0.000178664,0.000113695,4.87266e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,4.87266e-05,0.000113695,0.000113695,0.000162422,0.000194906,0.000227391,
0.000259875,0.000276117,0.000324844,0.000341086,0.000357328,0.000389813,0.000389813,0.000406055,0.000422297,
0.00043854,0.000471024,0.000503508,0.000535993,0.000552235,0.000617204,0.000714657,0.000763384,0.00081211,
0.000844595,0.000860837,0.000909563,0.000942048,0.000942048,0.000942048,0.000942048,0.000942048,0.000942048,
0.000942048,0.000909563,0.000893321,0.000877079,0.000860837,0.000844595,0.000844595,0.00081211,0.000795868,
0.000795868,0.000779626,0.000747141,0.000747141,0.000747141,0.000747141,0.000779626,0.000795868,0.000844595,
0.000942048,0.000990774,0.00113695,0.00121817,0.00142931,0.00175416,0.00204652,0.00227391,0.00259875,
0.00315099,0.00391437,0.00472648,0.00609083,0.00760135,0.00959914,0.0117594,0.0144231,0.0173954,0.0213585,
0.025484,0.0302917,0.0353755,0.0407354,0.0468588,0.0539404,0.0627436,0.072895,0.0854665,0.0997596,0.118893,
0.141453,0.170348,0.209427,0.284937,0.347697,0.408816,0.46123,0.502047,0.527547,0.536155,0.526264,0.500877,
0.46568,0.433082,0.410002,0.39769,0.388481,0.37513,0.356045,0.33139,0.306068,0.286171,0.270173,0.256399,
0.241993,0.231565,0.229307,0.234391,0.252696,0.276832,0.30753,0.346268,0.392217,0.434008,0.469432,0.494267,
0.498425,0.476286,0.426975,0.348135,0.247223,0.16507,0.115547,0.0788721,0.0526572,0.0337513,0.0215047,
0.0133186,0.00865709,0.00557108,0.00402807,0.00290735,0.00233888,0.00199779,0.0013481,0.000974532,0.000600962,
0.000471024,0.000406055,0.000357328,0.000324844,0.000259875,0.000178664,0.000113695,4.87266e-05,3.24844e-05,
3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,
1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,0.000113695,
0.000162422,0.000178664,0.000194906,0.000243633,0.000276117,0.000308602,0.000341086,0.000341086,0.000373571,
0.000389813,0.000406055,0.000422297,0.000454782,0.000503508,0.000503508,0.000552235,0.000617204,0.000747141,
0.000795868,0.000844595,0.000942048,0.000974532,0.0010395,0.0010395,0.00107199,0.00108823,0.00108823,
0.00107199,0.0010395,0.0010395,0.0010395,0.000990774,0.000990774,0.000974532,0.000974532,0.000942048,
0.000942048,0.000893321,0.000844595,0.000844595,0.00081211,0.000795868,0.000779626,0.000747141,0.000747141,
0.000747141,0.000747141,0.000779626,0.00081211,0.000844595,0.000942048,0.0010395,0.00113695,0.00121817,
0.0014618,0.0017704,0.00204652,0.00229015,0.00258251,0.00305353,0.00370322,0.0043854,0.00532744,0.00641567,
0.00735772,0.00855964,0.00979405,0.0111097,0.0127176,0.0149266,0.0170706,0.0198155,0.0224467,0.0258413,
0.0306815,0.037422,0.046875,0.0579197,0.0722128,0.0907452,0.113923,0.144263,0.182302,0.250292,0.331081,
0.405032,0.467938,0.516778,0.54426,0.550058,0.536269,0.50778,0.474971,0.453888,0.442405,0.435226,0.422216,
0.397788,0.359976,0.325283,0.294617,0.272187,0.254288,0.237364,0.227212,0.224191,0.226644,0.237315,0.262766,
0.293172,0.33113,0.373652,0.417701,0.451371,0.471056,0.470845,0.44489,0.393614,0.315554,0.210613,0.150338,
0.105282,0.0720179,0.0484505,0.0314449,0.0204977,0.0127664,0.00841346,0.00563604,0.00410928,0.00290735,
0.00233888,0.00201403,0.00136435,0.000974532,0.000600962,0.000471024,0.000406055,0.000341086,0.000308602,
0.000243633,0.000178664,0.000113695,4.87266e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,0.000113695,0.000162422,0.000178664,0.000211149,
0.000243633,0.000276117,0.000324844,0.000341086,0.000373571,0.000389813,0.000406055,0.000422297,0.000454782,
0.000503508,0.000535993,0.000584719,0.000714657,0.000795868,0.000860837,0.000974532,0.0010395,0.00112071,
0.00113695,0.00116944,0.00118568,0.00120192,0.00120192,0.00118568,0.00116944,0.0011532,0.00113695,0.00113695,
0.00112071,0.00108823,0.0010395,0.0010395,0.000990774,0.000974532,0.000942048,0.000909563,0.000860837,
0.000844595,0.00081211,0.000795868,0.000779626,0.000747141,0.000747141,0.000747141,0.000747141,0.000747141,
0.000795868,0.000828352,0.000893321,0.000990774,0.00112071,0.00120192,0.00136435,0.00168919,0.00201403,
0.00220894,0.00245257,0.00277742,0.00337838,0.00383316,0.00432043,0.00474272,0.00522999,0.0057335,0.00628573,
0.00688669,0.00773129,0.00894945,0.0100702,0.0112721,0.0127501,0.0152677,0.0187273,0.0245257,0.0323057,
0.0432043,0.0566853,0.0742269,0.0975507,0.128622,0.168903,0.228771,0.325851,0.407208,0.475019,0.527254,
0.555954,0.559739,0.547411,0.527206,0.510525,0.497629,0.485658,0.467272,0.435827,0.393435,0.345066,0.30485,
0.273616,0.249334,0.230006,0.220991,0.216833,0.217288,0.224419,0.248197,0.282761,0.321839,0.3629,0.406201,
0.437614,0.453921,0.448431,0.41939,0.362494,0.288202,0.190927,0.140706,0.0989475,0.0684609,0.0467288,
0.0308764,0.0201078,0.0127501,0.00846219,0.00586344,0.00417425,0.00308602,0.00242009,0.00204652,0.0014618,
0.000990774,0.000617204,0.000471024,0.000406055,0.000341086,0.000308602,0.000243633,0.000178664,0.000113695,
4.87266e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,4.87266e-05,0.000113695,0.000113695,0.000162422,0.000194906,0.000243633,0.000276117,0.000308602,
0.000341086,0.000373571,0.000389813,0.000406055,0.00043854,0.000471024,0.000503508,0.000552235,0.000682173,
0.000779626,0.000844595,0.000974532,0.00105574,0.00113695,0.00118568,0.00121817,0.00123441,0.00136435,
0.00136435,0.00136435,0.00136435,0.00136435,0.00125065,0.00121817,0.00121817,0.00118568,0.0011532,0.00113695,
0.00113695,0.00108823,0.0010395,0.0010395,0.000974532,0.000942048,0.000909563,0.000844595,0.00081211,
0.000795868,0.000779626,0.000747141,0.000730899,0.000714657,0.000698415,0.000714657,0.000747141,0.000747141,
0.000795868,0.000844595,0.000942048,0.0010395,0.00113695,0.00123441,0.00159174,0.00185161,0.002079,0.00229015,
0.00246881,0.00269621,0.00293984,0.00337838,0.00358953,0.00370322,0.00391437,0.00414176,0.0043854,0.00480769,
0.00548986,0.00626949,0.00711409,0.00844595,0.0103463,0.0132374,0.017704,0.0245907,0.0338812,0.0477034,
0.0650825,0.0894133,0.120225,0.161854,0.222989,0.325737,0.412146,0.488241,0.54249,0.569565,0.577816,0.574633,
0.56518,0.552121,0.535181,0.509924,0.469757,0.419569,0.364166,0.315115,0.275874,0.244218,0.223639,0.213926,
0.208631,0.207657,0.21326,0.232929,0.27412,0.31531,0.356354,0.398129,0.427202,0.440196,0.431929,0.399461,
0.342158,0.268175,0.183618,0.135346,0.0967223,0.0675351,0.0467938,0.0310389,0.0206114,0.0130262,0.00867334,
0.00612331,0.00432043,0.0032322,0.00248506,0.002079,0.00155925,0.0010395,0.000617204,0.000471024,0.000389813,
0.000341086,0.00029236,0.000243633,0.000162422,0.000113695,4.87266e-05,3.24844e-05,3.24844e-05,1.62422e-05,
1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,0.000113695,0.000162422,0.000178664,
0.000211149,0.000259875,0.000308602,0.000341086,0.000357328,0.000389813,0.000406055,0.00043854,0.000503508,
0.000535993,0.000600962,0.000747141,0.000828352,0.000942048,0.0010395,0.00113695,0.00120192,0.00123441,
0.00136435,0.00151052,0.00164046,0.0016567,0.00167295,0.00167295,0.0016567,0.0016567,0.00152677,0.00142931,
0.00136435,0.00123441,0.00121817,0.00118568,0.0011532,0.00113695,0.00108823,0.0010395,0.000990774,0.000974532,
0.000942048,0.000844595,0.00081211,0.000795868,0.000747141,0.000747141,0.000698415,0.000617204,0.000617204,
0.000600962,0.000617204,0.000617204,0.000682173,0.000730899,0.000763384,0.00081211,0.000909563,0.0010395,
0.00113695,0.00121817,0.00160798,0.00183537,0.00204652,0.00214397,0.00232264,0.00233888,0.00246881,0.00255003,
0.00258251,0.00264748,0.00269621,0.00287487,0.00337838,0.00376819,0.00425546,0.00498636,0.00620452,0.00778002,
0.0103463,0.0141307,0.0200916,0.0292197,0.0425383,0.0607134,0.0848818,0.117074,0.160099,0.22437,0.332348,
0.428729,0.50968,0.565196,0.597258,0.609846,0.608092,0.597242,0.577037,0.547135,0.501218,0.442405,0.382065,
0.325575,0.28086,0.244137,0.220553,0.208534,0.201988,0.200088,0.205107,0.224435,0.267298,0.308017,0.350101,
0.390528,0.416726,0.427495,0.416288,0.381432,0.327215,0.253378,0.179639,0.134453,0.0976319,0.0693867,
0.0481581,0.0320134,0.0212123,0.0135298,0.00912812,0.00643191,0.00441788,0.00339462,0.00256627,0.00212773,
0.0016567,0.00107199,0.000633446,0.000471024,0.000389813,0.000341086,0.000276117,0.000211149,0.000162422,
0.000113695,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,8.1211e-05,0.000113695,0.000162422,0.000194906,0.000243633,0.000276117,0.000324844,
0.000341086,0.000389813,0.000422297,0.000454782,0.000503508,0.000552235,0.000698415,0.00081211,0.000942048,
0.0010395,0.00113695,0.00121817,0.00129938,0.0014618,0.0016567,0.00168919,0.0017704,0.00180288,0.00185161,
0.00185161,0.00185161,0.00180288,0.0017704,0.00168919,0.0016567,0.00152677,0.00136435,0.00123441,0.00121817,
0.00118568,0.00113695,0.00113695,0.00107199,0.0010395,0.000974532,0.000942048,0.000844595,0.00081211,
0.000779626,0.000747141,0.000698415,0.000617204,0.000600962,0.000584719,0.000552235,0.000552235,0.000535993,
0.000552235,0.000552235,0.000584719,0.000600962,0.000698415,0.000747141,0.000828352,0.000942048,0.00105574,
0.00116944,0.0013481,0.0016567,0.00172167,0.00185161,0.00193282,0.00194906,0.00196531,0.00198155,0.00201403,
0.002079,0.00220894,0.00237136,0.00269621,0.00328093,0.0039631,0.00477521,0.00631822,0.00855964,0.012003,
0.0174279,0.0267022,0.040638,0.0586993,0.0834524,0.116928,0.162195,0.237932,0.353966,0.458794,0.543188,
0.598298,0.628801,0.638497,0.6301,0.609018,0.576111,0.526475,0.462074,0.397755,0.336116,0.288429,0.25,
0.220358,0.204668,0.196238,0.193916,0.199812,0.219497,0.262165,0.302316,0.342824,0.380327,0.405129,0.411854,
0.399834,0.363712,0.31544,0.243097,0.178713,0.136321,0.100864,0.0724402,0.050562,0.0336538,0.0220569,
0.0142444,0.0095829,0.006773,0.00462903,0.00352456,0.00264748,0.00214397,0.00168919,0.00108823,0.000682173,
0.000471024,0.000389813,0.000341086,0.000276117,0.000194906,0.000162422,0.000113695,3.24844e-05,3.24844e-05,
3.24844e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,
1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,0.000113695,0.000162422,
0.000178664,0.000227391,0.000276117,0.000324844,0.000341086,0.000389813,0.000422297,0.000471024,0.000503508,
0.000600962,0.000779626,0.000893321,0.0010395,0.0011532,0.00121817,0.00136435,0.00152677,0.00167295,0.0017704,
0.00185161,0.00193282,0.00198155,0.00201403,0.00203028,0.00204652,0.00201403,0.00199779,0.00193282,0.0018841,
0.0017704,0.00168919,0.00160798,0.00136435,0.00123441,0.00121817,0.0011532,0.00113695,0.00108823,0.0010395,
0.000974532,0.000909563,0.000844595,0.000795868,0.000747141,0.000714657,0.000617204,0.000584719,0.000552235,
0.000535993,0.000535993,0.000503508,0.000503508,0.000503508,0.000503508,0.000503508,0.000503508,0.000503508,
0.000535993,0.000535993,0.000584719,0.000682173,0.000747141,0.000828352,0.000942048,0.0010395,0.00113695,
0.00113695,0.00113695,0.00113695,0.00113695,0.0011532,0.00121817,0.00138059,0.00172167,0.00204652,0.00225767,
0.00258251,0.00318347,0.00410928,0.0053112,0.00748766,0.0111584,0.0167944,0.0264423,0.0400208,0.0582445,
0.0841021,0.119348,0.170413,0.27308,0.392071,0.497547,0.577069,0.626705,0.652482,0.652319,0.631432,0.597486,
0.547037,0.480412,0.412487,0.348217,0.296047,0.255669,0.221706,0.203629,0.19351,0.190846,0.196677,0.216362,
0.258251,0.298775,0.337562,0.370761,0.393792,0.397349,0.382942,0.351806,0.30818,0.240677,0.180516,0.13991,
0.1046,0.0761435,0.0535018,0.0356841,0.0234375,0.0149916,0.0100377,0.0070816,0.00487266,0.0036545,0.00269621,
0.00220894,0.00168919,0.00113695,0.000682173,0.000471024,0.000389813,0.000341086,0.000276117,0.000194906,
0.000162422,8.1211e-05,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,0.000113695,0.000162422,0.000194906,0.000259875,0.000308602,
0.000341086,0.000389813,0.000422297,0.000471024,0.000535993,0.000698415,0.000844595,0.000990774,0.0011532,
0.00121817,0.00142931,0.0016567,0.00172167,0.00185161,0.00194906,0.00201403,0.00204652,0.002079,0.00211149,
0.00212773,0.00212773,0.00212773,0.00211149,0.002079,0.00204652,0.00201403,0.00191658,0.00180288,0.00168919,
0.00152677,0.00136435,0.00121817,0.00116944,0.00113695,0.00108823,0.000990774,0.000942048,0.000877079,
0.00081211,0.000779626,0.000730899,0.000617204,0.000584719,0.000535993,0.000535993,0.000503508,0.000503508,
0.000503508,0.000471024,0.000454782,0.000454782,0.00043854,0.00043854,0.00043854,0.00043854,0.00043854,
0.00043854,0.000454782,0.000471024,0.000503508,0.000503508,0.000535993,0.000535993,0.000568477,0.000584719,
0.000584719,0.000617204,0.000682173,0.000747141,0.000860837,0.0010395,0.00118568,0.00151052,0.00194906,
0.00227391,0.00269621,0.00373571,0.00506757,0.0073902,0.0111909,0.0169081,0.0265235,0.0403456,0.059414,
0.0868471,0.127079,0.186071,0.312646,0.433602,0.536155,0.605623,0.647366,0.662016,0.648438,0.615222,0.567746,
0.506026,0.435583,0.365612,0.308196,0.264748,0.225832,0.205902,0.194777,0.191398,0.19705,0.215761,0.257179,
0.297606,0.334654,0.364394,0.38356,0.38598,0.371427,0.345991,0.306409,0.244478,0.184008,0.144101,0.108725,
0.0798792,0.0558894,0.0376657,0.0245257,0.0157062,0.0104762,0.00734148,0.00511629,0.00383316,0.00274493,
0.00225767,0.0017704,0.00113695,0.000682173,0.000454782,0.000389813,0.000324844,0.000259875,0.000178664,
0.000113695,4.87266e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,8.1211e-05,0.000162422,0.000178664,0.000243633,0.000276117,0.000341086,0.000373571,
0.000406055,0.000471024,0.000535993,0.000747141,0.000909563,0.00112071,0.00121817,0.00142931,0.00167295,
0.00180288,0.00193282,0.00204652,0.002079,0.00212773,0.00217646,0.00220894,0.00224142,0.00225767,0.00227391,
0.00227391,0.00225767,0.00220894,0.0021927,0.00212773,0.002079,0.00203028,0.00191658,0.0017704,0.0016567,
0.00142931,0.00123441,0.00118568,0.00113695,0.00107199,0.000990774,0.000942048,0.000844595,0.000795868,
0.000747141,0.000617204,0.000584719,0.000535993,0.000503508,0.000503508,0.000503508,0.000471024,0.000454782,
0.00043854,0.000422297,0.000406055,0.000406055,0.000389813,0.000389813,0.000389813,0.000389813,0.000373571,
0.000373571,0.000373571,0.000357328,0.000357328,0.000373571,0.000389813,0.000389813,0.000389813,0.000406055,
0.000422297,0.000454782,0.000503508,0.000503508,0.000584719,0.000747141,0.000909563,0.00116944,0.00168919,
0.00214397,0.00269621,0.00381692,0.00524623,0.00761759,0.0114995,0.0172167,0.0269783,0.0419211,0.0628736,
0.094887,0.143386,0.222063,0.35983,0.478106,0.570183,0.627063,0.657972,0.658329,0.632894,0.593182,0.537861,
0.467451,0.397187,0.331438,0.281624,0.238598,0.21287,0.200559,0.19619,0.201485,0.217581,0.25739,0.296566,
0.331114,0.358595,0.375244,0.37984,0.368162,0.344725,0.307351,0.250845,0.188263,0.149916,0.114215,0.0836149,
0.0585207,0.0395498,0.0254678,0.0163721,0.0108823,0.00761759,0.00539241,0.00402807,0.00284239,0.00232264,
0.00181913,0.00113695,0.000682173,0.000454782,0.000389813,0.000324844,0.000243633,0.000162422,0.000113695,
3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,
1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,4.87266e-05,
0.000113695,0.000162422,0.000211149,0.000276117,0.000324844,0.000357328,0.000406055,0.000454782,0.000535993,
0.000747141,0.000942048,0.00113695,0.00128313,0.0016567,0.00180288,0.00196531,0.00204652,0.00212773,0.00220894,
0.00227391,0.00232264,0.00233888,0.00235512,0.00237136,0.00240385,0.00240385,0.00237136,0.00233888,0.00233888,
0.00232264,0.00220894,0.00214397,0.002079,0.00201403,0.00185161,0.00168919,0.00151052,0.00125065,0.00118568,
0.00113695,0.0010395,0.000974532,0.000877079,0.00081211,0.000747141,0.000682173,0.000584719,0.000535993,
0.000503508,0.000503508,0.000471024,0.000454782,0.00043854,0.000422297,0.000406055,0.000389813,0.000389813,
0.000373571,0.000357328,0.000341086,0.000341086,0.000324844,0.000308602,0.000276117,0.000276117,0.000243633,
0.000243633,0.000211149,0.000211149,0.000243633,0.000276117,0.000308602,0.000341086,0.000357328,0.000389813,
0.000406055,0.00043854,0.000503508,0.000535993,0.000763384,0.00112071,0.00168919,0.00220894,0.00279366,
0.00402807,0.00558732,0.00807238,0.0120192,0.0182075,0.0287974,0.0454132,0.0706373,0.110203,0.170771,
0.290492,0.415183,0.523892,0.597973,0.6422,0.660197,0.649445,0.618942,0.571596,0.507455,0.434138,0.362835,
0.305759,0.262393,0.225409,0.209882,0.204148,0.207056,0.221284,0.255815,0.292311,0.326371,0.353382,0.372044,
0.380035,0.370533,0.348655,0.313133,0.262994,0.195832,0.15729,0.120062,0.0879028,0.0615904,0.0414988,
0.0266859,0.0169731,0.0113208,0.00807238,0.00570101,0.004158,0.00298857,0.00233888,0.0018841,0.0011532,
0.000682173,0.000454782,0.000373571,0.000308602,0.000227391,0.000162422,8.1211e-05,3.24844e-05,3.24844e-05,
3.24844e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,
1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,0.00014618,0.000178664,
0.000243633,0.000308602,0.000341086,0.000389813,0.00043854,0.000535993,0.000747141,0.000942048,0.0011532,
0.00136435,0.00168919,0.00193282,0.00204652,0.00214397,0.00225767,0.00233888,0.00237136,0.00246881,0.00253378,
0.00258251,0.00263124,0.00264748,0.00264748,0.00264748,0.00258251,0.00255003,0.00246881,0.00235512,0.00233888,
0.00224142,0.00212773,0.00204652,0.00193282,0.00173792,0.00160798,0.00131562,0.00118568,0.00113695,0.00100702,
0.000942048,0.000828352,0.000779626,0.000698415,0.000584719,0.000535993,0.000503508,0.000503508,0.000454782,
0.00043854,0.000422297,0.000406055,0.000389813,0.000389813,0.000373571,0.000341086,0.000341086,0.000324844,
0.000308602,0.000276117,0.000243633,0.000211149,0.000178664,0.000162422,0.000113695,0.000113695,8.1211e-05,
4.87266e-05,8.1211e-05,0.000113695,0.000162422,0.000194906,0.000276117,0.000308602,0.000341086,0.000373571,
0.000389813,0.000422297,0.000503508,0.000714657,0.00113695,0.00181913,0.00233888,0.00310226,0.00423922,
0.00594465,0.00864085,0.0127339,0.0200104,0.0315911,0.05204,0.084427,0.134323,0.208842,0.349321,0.470585,
0.564953,0.622726,0.655828,0.66239,0.642883,0.60382,0.549165,0.477667,0.403797,0.334784,0.285619,0.247515,
0.222128,0.21287,0.212854,0.224094,0.253606,0.288348,0.322684,0.352115,0.374594,0.386711,0.380149,0.357345,
0.324373,0.277872,0.209719,0.166824,0.127712,0.0932302,0.0650825,0.0441301,0.0283914,0.0181101,0.0119705,
0.00867334,0.0060421,0.00430418,0.00318347,0.00235512,0.00193282,0.00116944,0.000714657,0.000454782,0.000373571,
0.000276117,0.000194906,0.000113695,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,0.000113695,0.000162422,0.000211149,0.000276117,0.000324844,0.000373571,
0.000422297,0.000503508,0.000617204,0.000877079,0.00113695,0.00136435,0.00172167,0.00199779,0.00212773,
0.00224142,0.00233888,0.00246881,0.00258251,0.00267996,0.00272869,0.00279366,0.00284239,0.00285863,0.00285863,
0.00282614,0.00279366,0.00274493,0.00269621,0.00264748,0.00255003,0.00242009,0.00233888,0.00220894,0.00209524,
0.00199779,0.00180288,0.0016567,0.0013481,0.00118568,0.00112071,0.000974532,0.000860837,0.000795868,0.000714657,
0.000600962,0.000535993,0.000503508,0.000487266,0.000454782,0.000422297,0.000406055,0.000389813,0.000389813,
0.000373571,0.000341086,0.000341086,0.000324844,0.000276117,0.000276117,0.000243633,0.000194906,0.000162422,
0.000113695,8.1211e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,8.1211e-05,0.000129938,0.000178664,0.000243633,0.000276117,0.000308602,0.000341086,0.000389813,
0.000454782,0.000747141,0.00121817,0.00201403,0.00246881,0.00339462,0.00440164,0.00633446,0.00925806,
0.0138871,0.0223005,0.0371459,0.0628573,0.104031,0.165735,0.28726,0.418968,0.530438,0.60343,0.649607,
0.669098,0.665362,0.635492,0.58826,0.524639,0.445475,0.369429,0.311152,0.270092,0.238809,0.22333,0.21927,
0.226595,0.253703,0.287471,0.323285,0.356094,0.385606,0.399315,0.395433,0.372921,0.340112,0.297541,0.231224,
0.178973,0.137734,0.100864,0.0709622,0.0480607,0.0308764,0.0198155,0.0127176,0.00945296,0.00641567,0.00443412,
0.00337838,0.00245257,0.00199779,0.00120192,0.000730899,0.00043854,0.000341086,0.000276117,0.000178664,
0.000113695,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
6.49688e-05,0.000113695,0.000178664,0.000243633,0.000308602,0.000341086,0.000389813,0.000454782,0.000552235,
0.000795868,0.00108823,0.00125065,0.00168919,0.00201403,0.00212773,0.00232264,0.00242009,0.00259875,0.00269621,
0.00285863,0.00306978,0.0032322,0.00337838,0.0034271,0.0034271,0.00339462,0.00334589,0.00319971,0.00306978,
0.00289111,0.00277742,0.00267996,0.00256627,0.00237136,0.00232264,0.00212773,0.00204652,0.00185161,0.0016567,
0.0013481,0.00116944,0.00107199,0.000942048,0.00081211,0.000747141,0.000600962,0.000535993,0.000503508,
0.000471024,0.00043854,0.000422297,0.000406055,0.000389813,0.000373571,0.000341086,0.000341086,0.000324844,
0.000276117,0.000259875,0.000227391,0.000178664,0.000162422,0.000113695,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,4.87266e-05,0.000113695,0.000162422,0.000162422,0.000194906,0.000276117,0.000373571,0.000487266,
0.000877079,0.0014618,0.00211149,0.00264748,0.00355704,0.00466151,0.00672427,0.0100052,0.0154788,0.0261499,
0.0464527,0.080139,0.132666,0.215144,0.366457,0.495452,0.586002,0.642672,0.673824,0.680337,0.666726,0.624367,
0.566528,0.49157,0.411253,0.34297,0.295559,0.264244,0.239735,0.230087,0.235431,0.261093,0.292863,0.330431,
0.368243,0.402319,0.418659,0.4171,0.399103,0.365401,0.325737,0.270774,0.19541,0.151637,0.111389,0.0790508,
0.0535668,0.034466,0.0219919,0.0139845,0.0103138,0.00687045,0.004694,0.0035408,0.00255003,0.00204652,
0.00121817,0.000747141,0.00043854,0.000341086,0.000243633,0.000162422,4.87266e-05,3.24844e-05,3.24844e-05,
1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,
1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,0.000162422,0.000194906,0.000276117,
0.000324844,0.000373571,0.000422297,0.000503508,0.000698415,0.000974532,0.00120192,0.0016567,0.00194906,
0.00212773,0.00233888,0.00251754,0.00269621,0.00289111,0.00319971,0.00345959,0.0036545,0.00381692,0.00391437,
0.00391437,0.00391437,0.00383316,0.00370322,0.00358953,0.00344335,0.0032322,0.00295608,0.00279366,0.00264748,
0.00251754,0.00233888,0.00220894,0.00204652,0.0018841,0.0016567,0.0013481,0.0011532,0.0010395,0.000877079,
0.000779626,0.000617204,0.000535993,0.000503508,0.000471024,0.00043854,0.000406055,0.000389813,0.000389813,
0.000357328,0.000341086,0.000324844,0.000308602,0.000276117,0.000243633,0.000194906,0.000162422,0.000113695,
4.87266e-05,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,
1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,4.87266e-05,0.000113695,0.000243633,0.000373571,0.000503508,0.000990774,0.0016567,0.0021927,
0.00269621,0.00367074,0.0048889,0.00717905,0.010996,0.0183862,0.0335402,0.0618503,0.107556,0.177803,0.321125,
0.459947,0.566837,0.633982,0.676082,0.689482,0.685324,0.659044,0.602797,0.53458,0.455756,0.383771,0.328385,
0.291142,0.26824,0.257553,0.261467,0.27896,0.308569,0.347957,0.392866,0.428063,0.448545,0.452557,0.437711,
0.408962,0.365839,0.312256,0.231549,0.170559,0.124513,0.0880165,0.0593977,0.0392087,0.0247206,0.015625,
0.0113695,0.00742269,0.00503508,0.00367074,0.00264748,0.00204652,0.00121817,0.000747141,0.00043854,0.000341086,
0.000243633,0.000113695,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,
0.000113695,0.000162422,0.000243633,0.000308602,0.000341086,0.000389813,0.000454782,0.000552235,0.00081211,
0.00112071,0.00138059,0.00185161,0.00209524,0.00232264,0.00253378,0.00274493,0.00313475,0.00350832,0.00381692,
0.00410928,0.00423922,0.00436915,0.00441788,0.00441788,0.0043854,0.00430418,0.004158,0.0039631,0.00370322,
0.00355704,0.00331341,0.00295608,0.00274493,0.00258251,0.00237136,0.00224142,0.002079,0.00191658,0.00167295,
0.00128313,0.00113695,0.000974532,0.00081211,0.000714657,0.000568477,0.000503508,0.000471024,0.00043854,
0.000406055,0.000389813,0.000373571,0.000341086,0.000341086,0.000308602,0.000276117,0.000243633,0.000194906,
0.000178664,0.000113695,8.1211e-05,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,
1.62422e-05,1.62422e-05,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,0.000113695,0.000276117,0.000389813,0.000584719,
0.00112071,0.00172167,0.00222518,0.00274493,0.00383316,0.00524623,0.0078125,0.0129938,0.0244932,0.0477196,
0.087513,0.149932,0.273567,0.421713,0.543399,0.624155,0.678356,0.697684,0.700055,0.684544,0.637815,0.573528,
0.498327,0.425107,0.362965,0.322651,0.298613,0.289079,0.291759,0.306653,0.335873,0.376689,0.424214,0.464413,
0.490628,0.49935,0.490027,0.463617,0.422086,0.362526,0.28994,0.192503,0.140511,0.097437,0.0657322,0.0435616,
0.0276605,0.0173954,0.0122791,0.00807238,0.00535993,0.00383316,0.00264748,0.002079,0.00123441,0.000730899,
0.000422297,0.000341086,0.000227391,0.000113695,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,
3.24844e-05,4.87266e-05,0.000113695,0.000194906,0.000276117,0.000324844,0.000373571,0.000406055,0.000503508,
0.000617204,0.000942048,0.00121817,0.00168919,0.00204652,0.00225767,0.00251754,0.00277742,0.00328093,
0.00367074,0.00412552,0.0043854,0.00472648,0.00506757,0.0053112,0.00535993,0.00532744,0.00516502,0.00492139,
0.00461279,0.00433667,0.00412552,0.00383316,0.00355704,0.0032322,0.00285863,0.00267996,0.00246881,0.00232264,
0.00211149,0.00193282,0.00167295,0.00125065,0.00113695,0.000942048,0.000779626,0.000600962,0.000535993,
0.000471024,0.00043854,0.000406055,0.000389813,0.000357328,0.000341086,0.000308602,0.000276117,0.000259875,
0.000211149,0.000178664,0.000162422,0.000113695,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,
1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,
1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,0.000162422,0.000324844,0.000422297,0.000682173,
0.00116944,0.00185161,0.00232264,0.00290735,0.00414176,0.00594465,0.00976156,0.0176715,0.035944,0.0697115,
0.124204,0.211327,0.375244,0.514082,0.610723,0.680191,0.70842,0.717857,0.709427,0.679005,0.611665,0.537373,
0.461441,0.401296,0.356728,0.33381,0.325526,0.328953,0.343539,0.373701,0.418285,0.466752,0.512149,0.542246,
0.554817,0.547687,0.523551,0.482199,0.422817,0.341184,0.234635,0.158183,0.107637,0.071823,0.0473785,0.0303242,
0.019312,0.0129288,0.00864085,0.00565229,0.00391437,0.00269621,0.00209524,0.00123441,0.000714657,0.000422297,
0.000341086,0.000194906,8.1211e-05,3.24844e-05,3.24844e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,8.1211e-05,
0.000162422,0.000211149,0.000276117,0.000341086,0.000389813,0.00043854,0.000535993,0.000795868,0.00112071,
0.00142931,0.00191658,0.00217646,0.00242009,0.00277742,0.00337838,0.00383316,0.00430418,0.00479145,0.00540865,
0.00602586,0.00643191,0.00672427,0.00672427,0.00657809,0.00631822,0.00589592,0.00535993,0.00487266,0.00441788,
0.00414176,0.00381692,0.00345959,0.00306978,0.00272869,0.00253378,0.00233888,0.00212773,0.00194906,0.00167295,
0.00123441,0.00112071,0.000893321,0.000747141,0.000535993,0.000503508,0.00043854,0.000406055,0.000389813,
0.000341086,0.000324844,0.000308602,0.000276117,0.000227391,0.000178664,0.000162422,0.000113695,6.49688e-05,
3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,
1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,
0.000227391,0.000341086,0.000454782,0.000795868,0.00121817,0.00201403,0.00242009,0.00331341,0.00451533,
0.00730899,0.0131562,0.0271245,0.0548662,0.100767,0.174474,0.325754,0.474029,0.591671,0.678534,0.720975,
0.741976,0.741765,0.716866,0.663981,0.578953,0.501316,0.439871,0.401637,0.378232,0.368422,0.372953,0.392412,
0.424474,0.468961,0.521488,0.566902,0.597908,0.610853,0.60421,0.580675,0.540995,0.477553,0.393159,0.286577,
0.176455,0.118065,0.0772966,0.0499285,0.0318185,0.0206763,0.0131724,0.00872206,0.00576598,0.00394686,
0.00269621,0.002079,0.00121817,0.000682173,0.000422297,0.000324844,0.000178664,3.24844e-05,3.24844e-05,
1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,0.000113695,0.000162422,0.000243633,0.000308602,0.000341086,
0.000406055,0.000454782,0.000584719,0.000909563,0.00121817,0.00170543,0.002079,0.00233888,0.00269621,
0.00339462,0.00399558,0.00449909,0.0053112,0.0061558,0.00695166,0.00763384,0.00841346,0.00870582,0.00870582,
0.00841346,0.00773129,0.00711409,0.00641567,0.00566853,0.00501884,0.00443412,0.00412552,0.00370322,0.00336214,
0.00284239,0.00261499,0.00233888,0.00214397,0.00199779,0.00168919,0.00123441,0.00108823,0.000844595,0.000617204,
0.000503508,0.000454782,0.000406055,0.000389813,0.000341086,0.000324844,0.000276117,0.000243633,0.000194906,
0.000162422,0.000113695,8.1211e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,
1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,1.62422e-05,
1.62422e-05,3.24844e-05,0.000113695,0.000276117,0.000389813,0.000503508,0.000844595,0.00138059,0.002079,
0.00261499,0.00370322,0.00568477,0.0101839,0.0206763,0.0426683,0.0811623,0.143337,0.267639,0.427121,0.564888,
0.672216,0.734716,0.771017,0.780925,0.760655,0.711766,0.631172,0.55256,0.491262,0.454473,0.434836,0.426049,
0.431604,0.451355,0.485317,0.531721,0.582137,0.628411,0.665979,0.677267,0.66913,0.637766,0.592727,0.529804,
0.437711,0.323204,0.191463,0.126787,0.0818445,0.0520238,0.0328255,0.0210661,0.0129288,0.00851091,0.00555483,
0.00383316,0.00264748,0.00204652,0.00116944,0.000600962,0.000406055,0.000308602,0.000162422,3.24844e-05,
3.24844e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,
3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,0.000113695,0.000178664,0.000259875,0.000324844,0.000373571,
0.000406055,0.000503508,0.000747141,0.00107199,0.0014618,0.00196531,0.00229015,0.00264748,0.00337838,
0.00412552,0.00484018,0.0059284,0.00695166,0.0081211,0.00950169,0.0106549,0.0115644,0.0120517,0.011938,
0.0112883,0.0102163,0.00912812,0.00771505,0.00672427,0.00581471,0.00501884,0.0043854,0.00402807,0.00358953,
0.00308602,0.00269621,0.00242009,0.00220894,0.00201403,0.00168919,0.00123441,0.00108823,0.00081211,0.000584719,
0.000503508,0.000422297,0.000389813,0.000341086,0.000324844,0.000276117,0.000243633,0.000178664,0.000162422,
9.74532e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,0.000162422,0.000308602,
0.000406055,0.000535993,0.000974532,0.0016567,0.0021927,0.00285863,0.00443412,0.00779626,0.0155275,0.0325656,
0.0642542,0.117204,0.199747,0.372807,0.531299,0.662065,0.748067,0.803128,0.823999,0.809008,0.759843,0.692649,
0.609635,0.552901,0.518841,0.499919,0.49386,0.501608,0.524526,0.559381,0.60343,0.658329,0.698431,0.721982,
0.729015,0.71875,0.694419,0.647041,0.576143,0.478788,0.353577,0.210077,0.13356,0.0840047,0.0527709,0.0326468,
0.0208712,0.0121329,0.00773129,0.00511629,0.00360577,0.00251754,0.00194906,0.00112071,0.000535993,0.000389813,
0.000276117,0.000113695,3.24844e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,0.000113695,
0.000194906,0.000276117,0.000341086,0.000389813,0.000422297,0.000535993,0.000844595,0.00120192,0.00175416,
0.00212773,0.00255003,0.0032322,0.004158,0.00521375,0.00656185,0.00799116,0.00979405,0.0116294,0.013481,
0.0155275,0.0169081,0.0176878,0.0173954,0.016096,0.0141307,0.0120517,0.0100377,0.00821856,0.00685421,
0.00581471,0.00495387,0.00436915,0.00391437,0.00341086,0.0028099,0.00251754,0.00225767,0.00204652,0.00168919,
0.00125065,0.00108823,0.00081211,0.000568477,0.000471024,0.000406055,0.000373571,0.000341086,0.000276117,
0.000243633,0.000178664,0.000113695,8.1211e-05,3.24844e-05,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,
1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,3.24844e-05,3.24844e-05,0.000194906,
0.000341086,0.000422297,0.000568477,0.00107199,0.00178664,0.00237136,0.00370322,0.00631822,0.0121004,
0.0251917,0.0512766,0.094887,0.165654,0.319923,0.491051,0.64337,0.756676,0.828304,0.85166,0.845975,0.810941,
0.745452,0.680743,0.620436,0.590875,0.573756,0.568412,0.580984,0.606922,0.646082,0.692015,0.72882,0.757033,
0.77425,0.777563,0.766421,0.742301,0.701468,0.624675,0.520481,0.383219,0.225539,0.136792,0.0843458,0.0518126,
0.0314124,0.0195231,0.0108498,0.00695166,0.00453157,0.00328093,0.00233888,0.00175416,0.000974532,0.000503508,
0.000389813,0.000243633,8.1211e-05,3.24844e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,4.87266e-05,0.00014618,
0.000194906,0.000276117,0.000341086,0.000389813,0.00043854,0.000584719,0.000974532,0.00138059,0.00201403,
0.00233888,0.00293984,0.00412552,0.00548986,0.00732523,0.00959914,0.011938,0.0147642,0.0180126,0.0218458,
0.0251917,0.0278391,0.0287,0.0275955,0.0247206,0.0209037,0.016632,0.0131075,0.0104925,0.00841346,0.00685421,
0.00576598,0.00482393,0.00423922,0.00368698,0.00310226,0.00264748,0.00233888,0.002079,0.0017704,0.0013481,
0.00108823,0.000795868,0.000535993,0.000454782,0.000389813,0.000341086,0.000308602,0.000243633,0.000178664,
0.000113695,8.1211e-05,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,3.24844e-05,4.87266e-05,0.000211149,0.000341086,
0.000422297,0.000617204,0.00116944,0.002079,0.00302105,0.00506757,0.00963163,0.0198317,0.0409304,0.0770043,
0.136613,0.264147,0.447651,0.620939,0.756919,0.840177,0.873197,0.87435,0.847957,0.798889,0.739199,0.698496,
0.674555,0.657809,0.652254,0.671323,0.697976,0.730493,0.764147,0.795251,0.816658,0.826939,0.828986,0.82015,
0.794552,0.750487,0.679964,0.556393,0.404545,0.233871,0.135834,0.0822343,0.0491002,0.0290735,0.0172492,
0.00935551,0.0060421,0.00412552,0.00277742,0.00214397,0.00142931,0.00081211,0.000471024,0.000341086,0.000194906,
3.24844e-05,3.24844e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,
1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,4.87266e-05,0.000162422,0.000211149,0.000276117,0.000341086,
0.000389813,0.000471024,0.000714657,0.00113695,0.00168919,0.00217646,0.00269621,0.00391437,0.00544114,
0.00778002,0.010931,0.0145043,0.0188247,0.0243633,0.0305029,0.0373733,0.043659,0.0479145,0.0485967,0.0459817,
0.0393549,0.0313799,0.0244283,0.0182562,0.0136272,0.0105899,0.00841346,0.00678924,0.00563604,0.004694,
0.00410928,0.00345959,0.00277742,0.00237136,0.00212773,0.00185161,0.00136435,0.00108823,0.000795868,0.000535993,
0.00043854,0.000389813,0.000341086,0.000276117,0.000194906,0.000162422,8.1211e-05,3.24844e-05,3.24844e-05,
3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,1.62422e-05,1.62422e-05,3.24844e-05,8.1211e-05,0.000243633,0.000341086,0.00043854,0.000795868,0.00168919,
0.00258251,0.00430418,0.00773129,0.0156575,0.0324194,0.0630198,0.114735,0.204554,0.405146,0.594075,0.748165,
0.84323,0.886938,0.897966,0.875617,0.840502,0.796485,0.761418,0.741051,0.728349,0.72718,0.742594,0.769036,
0.803794,0.833176,0.849743,0.8616,0.866522,0.867155,0.85892,0.838439,0.793172,0.711327,0.576322,0.407809,
0.223395,0.128719,0.0759648,0.0443899,0.0252241,0.0148941,0.00753638,0.00495387,0.00350832,0.00246881,
0.00194906,0.0011532,0.000617204,0.000422297,0.000324844,0.000162422,3.24844e-05,1.62422e-05,1.62422e-05,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,
4.87266e-05,0.000162422,0.000211149,0.000276117,0.000341086,0.000389813,0.000503508,0.000779626,0.00118568,
0.00190034,0.00237136,0.00344335,0.00493763,0.00752014,0.0114345,0.0163884,0.0233725,0.0312825,0.0415638,
0.0529983,0.0643841,0.0761759,0.0835824,0.0838585,0.0763546,0.0635233,0.0494738,0.0363338,0.0261175,0.0186623,
0.0136272,0.0104762,0.0081211,0.00661058,0.00535993,0.0043854,0.00373571,0.00298857,0.00253378,0.00220894,
0.00193282,0.00138059,0.00108823,0.000795868,0.000535993,0.000422297,0.000373571,0.000308602,0.000243633,
0.000162422,0.000113695,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,1.62422e-05,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,0.000113695,
0.000276117,0.000389813,0.000568477,0.00121817,0.00232264,0.00370322,0.00648064,0.0125715,0.0264098,0.0525273,
0.0971933,0.176845,0.359716,0.561704,0.732296,0.839771,0.891015,0.91338,0.901361,0.870533,0.842061,0.821839,
0.805402,0.793627,0.793951,0.810697,0.835012,0.858108,0.880733,0.895969,0.904951,0.909125,0.907582,0.89233,
0.863387,0.815781,0.718246,0.566837,0.383219,0.194338,0.114037,0.0658784,0.0376819,0.0212286,0.0121817,
0.00620452,0.00414176,0.00279366,0.0021927,0.00159174,0.000909563,0.000503508,0.000389813,0.000276117,
8.1211e-05,3.24844e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,
1.62422e-05,3.24844e-05,3.24844e-05,3.24844e-05,4.87266e-05,0.000162422,0.000211149,0.000276117,0.000341086,
0.000389813,0.000503508,0.00081211,0.00123441,0.00206276,0.00269621,0.004158,0.00649688,0.0105087,0.0164371,
0.0252241,0.0371459,0.0519588,0.0688669,0.0892509,0.112169,0.134453,0.148502,0.147512,0.130571,0.104437,
0.0778976,0.0553697,0.0380717,0.0261499,0.0183374,0.0132049,0.0100377,0.0076988,0.00628573,0.00495387,
0.00412552,0.00336214,0.00264748,0.00229015,0.00199779,0.0014618,0.00112071,0.000795868,0.000535993,0.000422297,
0.000357328,0.000308602,0.000194906,0.000113695,3.24844e-05,3.24844e-05,3.24844e-05,1.62422e-05,1.62422e-05,
1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,
3.24844e-05,3.24844e-05,0.000194906,0.000357328,0.000503508,0.00113695,0.00211149,0.00319971,0.00532744,
0.0103138,0.0212935,0.0435616,0.0834687,0.153505,0.318428,0.522366,0.707234,0.828531,0.88585,0.919764,
0.921404,0.900127,0.875861,0.861941,0.852959,0.848314,0.850783,0.862412,0.88278,0.909677,0.936266,0.947733,
0.950331,0.948886,0.939384,0.913055,0.869591,0.806978,0.691138,0.517915,0.325315,0.163851,0.0935876,0.0538429,
0.0299669,0.0165346,0.00990774,0.00475897,0.00337838,0.00235512,0.0018841,0.00113695,0.000617204,0.00043854,
0.000341086,0.000178664,3.24844e-05,1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1.62422e-05,1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,4.87266e-05,0.00014618,0.000194906,
0.000276117,0.000341086,0.000389813,0.000503508,0.000844595,0.00138059,0.00220894,0.00318347,0.0048889,
0.00828352,0.0139845,0.0236486,0.0378119,0.0570426,0.0814871,0.11108,0.149899,0.194971,0.270124,0.308651,
0.303404,0.245663,0.173808,0.122076,0.0837123,0.0560843,0.0373896,0.0251917,0.0173954,0.0123116,0.00929054,
0.00711409,0.00555483,0.00436915,0.00357328,0.00272869,0.00233888,0.00203028,0.00147804,0.00108823,0.000779626,
0.000503508,0.000422297,0.000341086,0.000276117,0.000178664,8.1211e-05,3.24844e-05,3.24844e-05,3.24844e-05,
1.62422e-05,1.62422e-05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.62422e-05,1.62422e-05,
1.62422e-05,1.62422e-05,3.24844e-05,3.24844e-05,0.000162422,0.000341086,0.000503508,0.0010395,0.00201403,
0.00277742,0.00446661,0.00847843,0.0167295,0.035473,0.0707673,0.133251,0.271229,0.473948,0.669585,0.801228,
0.871881,0.915914,0.932611,0.925562,0.910554,0.900971,0.895969,0.895839,0.901978,0.915362,0.939449,0.963098,
0.977098,0.979437,0.974581,0.965778,0.944679,0.903797,0.849272,0.757894,0.608043,0.423662,0.22575,0.125975,
0.0714819,0.0406867,0.0226416,0.0127014,0.00760135,0.00383316,0.00264748,0.00204652,0.00125065,0.000795868,
0.000503508,0.000389813,0.000276117,9.