#
# Copyright (C) 2005 Jamie Wilkinson <jaq@spacepants.org>
# 
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os
import shutil
import tempfile

import config_manager.implementations


class SubversionVCS(object):
    """An Subversion VCS implementation."""

    def __init__(self):
        self.schemes = ["svn",
                        "svn+http",
                        "svn+ssh"]

    def checkout(self, url, to):
        if not url.startswith("svn"):
            return False

        if url.startswith("svn://") or url.startswith("svn+ssh://"):
            url = self.url
        else:
            url = self.url[4:]
        print "svn checkout %s %s" % (url, to)
        os.system("svn checkout %s %s" % (url, to))

	def update(self, location):
		print "svn update %s" % (location,)
        os.system("svn update %s" % (location,)

    def get_test_repo(self):
        return SubversionVCSRepo()

class SubversionVCSRepo(object):
    """A stub repo for the arch: scheme, tested implicitly by use."""

    def setUp(self):
        """Prepare the repo for use."""
        self.tempdir = tempfile.mkdtemp()
        self.oldhome = None
        if "HOME" in os.environ:
            self.oldhome = os.environ["HOME"]
        os.environ["HOME"] = self.tempdir
        pybaz.set_my_id("<demo@example.com>")
        archive = pybaz.make_archive('anarchive@example.com',
                                     os.path.join(self.tempdir, 'archive'))
        import_tree = os.path.join (self.tempdir, 'import')
        os.mkdir(import_tree)
        tree = pybaz.init_tree(import_tree,
                               'anarchive@example.com/foo--0')
        tree.import_()

    def tearDown(self):
        """Delete any disk resources used by the repo."""
        if self.oldhome is None:
            del os.environ["HOME"]
        else:
            os.environ["HOME"] = self.oldhome
        shutil.rmtree(self.tempdir, ignore_errors=True)

    def get_branch_url(self):
        return "arch://anarchive@example.com/foo--0"

    def get_not_branch_url(self):
        # we classify unregistered branches as 
        # not branches, and bad namespaces likewise.
        return "arch://illegal/foo--0"

    def get_bad_url(self):
        return "arch://anarchive@example.com/bar--0"
        

config_manager.implementations.register(SubversionVCS())
