/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1alpha3 "k8s.io/api/resource/v1alpha3"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	resourcev1alpha3 "k8s.io/client-go/applyconfigurations/resource/v1alpha3"
	testing "k8s.io/client-go/testing"
)

// FakeDeviceClasses implements DeviceClassInterface
type FakeDeviceClasses struct {
	Fake *FakeResourceV1alpha3
}

var deviceclassesResource = v1alpha3.SchemeGroupVersion.WithResource("deviceclasses")

var deviceclassesKind = v1alpha3.SchemeGroupVersion.WithKind("DeviceClass")

// Get takes name of the deviceClass, and returns the corresponding deviceClass object, and an error if there is any.
func (c *FakeDeviceClasses) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha3.DeviceClass, err error) {
	emptyResult := &v1alpha3.DeviceClass{}
	obj, err := c.Fake.
		Invokes(testing.NewRootGetActionWithOptions(deviceclassesResource, name, options), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha3.DeviceClass), err
}

// List takes label and field selectors, and returns the list of DeviceClasses that match those selectors.
func (c *FakeDeviceClasses) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha3.DeviceClassList, err error) {
	emptyResult := &v1alpha3.DeviceClassList{}
	obj, err := c.Fake.
		Invokes(testing.NewRootListActionWithOptions(deviceclassesResource, deviceclassesKind, opts), emptyResult)
	if obj == nil {
		return emptyResult, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha3.DeviceClassList{ListMeta: obj.(*v1alpha3.DeviceClassList).ListMeta}
	for _, item := range obj.(*v1alpha3.DeviceClassList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested deviceClasses.
func (c *FakeDeviceClasses) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchActionWithOptions(deviceclassesResource, opts))
}

// Create takes the representation of a deviceClass and creates it.  Returns the server's representation of the deviceClass, and an error, if there is any.
func (c *FakeDeviceClasses) Create(ctx context.Context, deviceClass *v1alpha3.DeviceClass, opts v1.CreateOptions) (result *v1alpha3.DeviceClass, err error) {
	emptyResult := &v1alpha3.DeviceClass{}
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateActionWithOptions(deviceclassesResource, deviceClass, opts), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha3.DeviceClass), err
}

// Update takes the representation of a deviceClass and updates it. Returns the server's representation of the deviceClass, and an error, if there is any.
func (c *FakeDeviceClasses) Update(ctx context.Context, deviceClass *v1alpha3.DeviceClass, opts v1.UpdateOptions) (result *v1alpha3.DeviceClass, err error) {
	emptyResult := &v1alpha3.DeviceClass{}
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateActionWithOptions(deviceclassesResource, deviceClass, opts), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha3.DeviceClass), err
}

// Delete takes name of the deviceClass and deletes it. Returns an error if one occurs.
func (c *FakeDeviceClasses) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteActionWithOptions(deviceclassesResource, name, opts), &v1alpha3.DeviceClass{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeDeviceClasses) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionActionWithOptions(deviceclassesResource, opts, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha3.DeviceClassList{})
	return err
}

// Patch applies the patch and returns the patched deviceClass.
func (c *FakeDeviceClasses) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha3.DeviceClass, err error) {
	emptyResult := &v1alpha3.DeviceClass{}
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceActionWithOptions(deviceclassesResource, name, pt, data, opts, subresources...), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha3.DeviceClass), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied deviceClass.
func (c *FakeDeviceClasses) Apply(ctx context.Context, deviceClass *resourcev1alpha3.DeviceClassApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha3.DeviceClass, err error) {
	if deviceClass == nil {
		return nil, fmt.Errorf("deviceClass provided to Apply must not be nil")
	}
	data, err := json.Marshal(deviceClass)
	if err != nil {
		return nil, err
	}
	name := deviceClass.Name
	if name == nil {
		return nil, fmt.Errorf("deviceClass.Name must be provided to Apply")
	}
	emptyResult := &v1alpha3.DeviceClass{}
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceActionWithOptions(deviceclassesResource, *name, types.ApplyPatchType, data, opts.ToPatchOptions()), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha3.DeviceClass), err
}
