# -*- coding: utf-8 -*-
#
# Groonga documentation build configuration file, created by
# sphinx-quickstart on Thu Oct 22 15:42:37 2009.
#
# This file is execfile()d with the current directory set to its containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import docutils.parsers.rst.directives.misc
import re
import sphinx
import sys, os
import gettext
from datetime import datetime

# Workaround to allow the include directive to contain content when using
# Markdown (MyST-Parser).
#
# This is necessary only when using Markdown through the MyST-Parser. If we
# stop using Markdown or switch to a different parser in the future, this
# workaround could be removed.
#
# Without this change, we encounter warnings during documentation generation
# when using include directives with content. For example:
#
# ```{include} filename.md
# plugin_register functions/language_model
# ```
#
# This results in the warning:
#   WARNING: include: Has content, but none permitted [myst.directive_parse]
#
# We considered the following approaches but chose this workaround for ease of
# maintenance:
# - Implementing a new directive in Python that allows content:
#   - This would be increasing maintenance costs since our team primarily uses
#     Ruby or C, not Python.
# - Modifying the Ruby script that updates execution examples:
#   - This could be hard to figure out how to do and increase maintenance costs
#     because it might be a complex approach.
#
# This workaround functions by setting `Include.has_content = True`, which
# modifies the default behavior of the include directive to accept content. This
# suppresses the warnings and allows us to embed Groonga execution commands
# within include blocks as needed.
docutils.parsers.rst.directives.misc.Include.has_content = True

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#sys.path.append(os.path.abspath('.'))

# -- General configuration -----------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be extensions
# coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = [
  'myst_parser'
]
# extensions.append("source.rdoc")
# extensions.append("source.textile")

# Add any paths that contain templates here, relative to this directory.
#templates_path = ['templates']

# The suffix of source filenames.
source_suffix = {
  '.rst': 'restructuredtext',
  '.md': 'markdown',
}

myst_enable_extensions = [
  "amsmath",
  "attrs_inline",
  # "colon_fence",
  "deflist",
  "dollarmath",
  "fieldlist",
  "html_admonition",
  "html_image",
  "linkify",
  # "replacements",
  # "smartquotes",
  "strikethrough",
  "substitution",
  "tasklist",
]

# The encoding of source files.
#source_encoding = 'utf-8'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = 'Groonga'
copyright = '2009-' + str(datetime.today().year) + ' Groonga Project'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#

# The short X.Y version.
version = os.environ["DOCUMENT_VERSION"]
# The full version, including alpha/beta/rc tags.
release = os.environ["DOCUMENT_VERSION_FULL"]

# The directories that has *.mo files.
locale_dirs = ["../locale"]

gettext_compact = False

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
language = os.environ['LOCALE']

locale_dir = os.path.dirname(__file__) + "/../locale"
try:
  catalog = gettext.Catalog("conf", localedir=locale_dir, languages=[language])
  _ = catalog.gettext
except:
  _ = lambda msgid: msgid

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#today = ''
# Else, today_fmt is used as the format for a strftime call.
#today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = [
  '**/.#*',
  'example/**/*.md',
  'install/server-use.md',
  'install/server-use.rst',
  'reference/commands/compress_filter.rst',
  'reference/scoring_note.rst',
]

# The reST default role (used for this markup: `text`) to use for all documents.
#default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
#add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
#add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
#show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
#pygments_style = 'sphinx'

# A list of ignored prefixes for module index sorting.
#modindex_common_prefix = []

# The myst-parser assigns header anchors for h1-h2.
myst_heading_anchors = 2

# -- Options for HTML output ---------------------------------------------------

# The theme to use for HTML and HTML Help pages.  Major themes that come with
# Sphinx are currently 'default' and 'sphinxdoc'.
html_theme = "pydata_sphinx_theme"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
if language == "en":
  language_prefix = "/"
  switcher_version = "english"
  use_edit_page_button = True
else:
  language_prefix = f"/{language}/"
  switcher_version = "japanese"
  use_edit_page_button = False

html_theme_options = {
  "logo": {
    "link": f"https://groonga.org{language_prefix}",
  },
  "github_url": "https://github.com/groonga/groonga",
  "twitter_url": "https://twitter.com/groonga",
  "icon_links": [
    {
      "name": "Blog",
      "url": f"{language_prefix}blog",
      "icon": "fas fa-blog",
    },
  ],
  "switcher": {
    # "json_url": "/_static/switcher.json",
    "json_url": "https://groonga.org/docs/_static/switcher.json",
    "version_match": switcher_version,
  },
  "navbar_center": [
  ],
  "navbar_end": [
    "theme-switcher.html",
    "navbar-icon-links.html",
    "version-switcher.html",
  ],
  "use_edit_page_button": use_edit_page_button,
  "analytics": {
    "google_analytics_id": "UA-7532323-1"
  },
  "show_nav_level": 2,
}

html_context = {
  "language": language,
  "github_user": "groonga",
  "github_repo": "groonga",
  "github_version": "main",
  "doc_path": "doc/source",
}

html_copy_source = False

# Add any paths that contain custom themes here, relative to this directory.
#html_theme_path = []

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
html_title_format = _("%(project)s v%(release)s documentation")
html_title = html_title_format % {"project": project,
                                  "release": release}

# A shorter title for the navigation bar.  Default is the same as html_title.
#html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
html_logo = "_static/groonga.png"

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = "_static/favicon.ico"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
#html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
html_use_smartypants = False

# Custom sidebar templates, maps document names to template names.
#html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
#html_additional_pages = {}

# If false, no module index is generated.
#html_use_modindex = True

# If false, no index is generated.
#html_use_index = True

# If true, the index is split into individual pages for each letter.
#html_split_index = False

# If true, links to the reST sources are added to the pages.
#html_show_sourcelink = True

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
html_show_sphinx = False

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
#html_use_opensearch = ''

# If nonempty, this is the file name suffix for HTML files (e.g. ".xhtml").
#html_file_suffix = ''
