/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.saxon.expr.sort.DoubleSortComparer;
import net.sf.saxon.functions.FormatNumber;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.FloatingPointConverter;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.PrecisionDecimalValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class DoubleValue
extends NumericValue {
    public static final DoubleValue ZERO = new DoubleValue(0.0);
    public static final DoubleValue NEGATIVE_ZERO = new DoubleValue(-0.0);
    public static final DoubleValue ONE = new DoubleValue(1.0);
    public static final DoubleValue NaN = new DoubleValue(Double.NaN);
    private double value;

    public DoubleValue(double value) {
        this.value = value;
        this.typeLabel = BuiltInAtomicType.DOUBLE;
    }

    public DoubleValue(double value, AtomicType type) {
        this.value = value;
        this.typeLabel = type;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        DoubleValue v = new DoubleValue(this.value);
        v.typeLabel = typeLabel;
        return v;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DOUBLE;
    }

    public double getDoubleValue() {
        return this.value;
    }

    public int hashCode() {
        if (this.value > -2.147483648E9 && this.value < 2.147483647E9) {
            return (int)this.value;
        }
        return new Double(this.value).hashCode();
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean effectiveBooleanValue() {
        return this.value != 0.0 && !Double.isNaN(this.value);
    }

    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, ConversionRules rules) {
        switch (requiredType.getFingerprint()) {
            case 514: {
                return BooleanValue.get(this.effectiveBooleanValue());
            }
            case 517: 
            case 632: 
            case 635: {
                return this;
            }
            case 533: {
                if (Double.isNaN(this.value)) {
                    ValidationFailure err = new ValidationFailure("Cannot convert double NaN to an integer");
                    err.setErrorCode("FOCA0002");
                    return err;
                }
                if (Double.isInfinite(this.value)) {
                    ValidationFailure err = new ValidationFailure("Cannot convert double INF to an integer");
                    err.setErrorCode("FOCA0002");
                    return err;
                }
                if (this.value > 9.223372036854776E18 || this.value < -9.223372036854776E18) {
                    if (this.isWholeNumber()) {
                        return new BigIntegerValue(FormatNumber.adjustToDecimal(this.value, 2).toBigInteger());
                    }
                    return new BigIntegerValue(new BigDecimal(this.value).toBigInteger());
                }
                return Int64Value.makeIntegerValue((long)this.value);
            }
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: {
                ConversionResult iv = this.convertPrimitive(BuiltInAtomicType.INTEGER, validate, rules);
                if (iv instanceof ValidationFailure) {
                    return iv;
                }
                return ((IntegerValue)iv).convertPrimitive(requiredType, validate, rules);
            }
            case 515: {
                try {
                    return new DecimalValue(this.value);
                }
                catch (ValidationException e) {
                    return new ValidationFailure(e);
                }
            }
            case 532: {
                return new PrecisionDecimalValue(this.value);
            }
            case 516: {
                return new FloatValue((float)this.value);
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationFailure err = new ValidationFailure("Cannot convert double to " + requiredType.getDisplayName());
        err.setErrorCode("XPTY0004");
        return err;
    }

    public CharSequence getPrimitiveStringValue() {
        return DoubleValue.doubleToString(this.value);
    }

    public CharSequence getCanonicalLexicalRepresentation() {
        FastStringBuffer fsb = new FastStringBuffer(16);
        return FloatingPointConverter.appendDoubleExponential(fsb, this.value);
    }

    public static CharSequence doubleToString(double value) {
        return FloatingPointConverter.appendDouble(new FastStringBuffer(16), value);
    }

    public NumericValue negate() {
        return new DoubleValue(-this.value);
    }

    public NumericValue floor() {
        return new DoubleValue(Math.floor(this.value));
    }

    public NumericValue ceiling() {
        return new DoubleValue(Math.ceil(this.value));
    }

    public NumericValue round(int scale) {
        if (Double.isNaN(this.value)) {
            return this;
        }
        if (Double.isInfinite(this.value)) {
            return this;
        }
        if (this.value == 0.0) {
            return this;
        }
        if (this.value == -0.0) {
            return this;
        }
        if (this.value >= -0.5 && this.value < 0.0) {
            return new DoubleValue(-0.0);
        }
        if (scale == 0 && this.value > -9.223372036854776E18 && this.value < 9.223372036854776E18) {
            return new DoubleValue(Math.round(this.value));
        }
        double factor = Math.pow(10.0, scale + 1);
        double d = Math.abs(this.value * factor);
        if (Double.isInfinite(d)) {
            BigDecimal dec = new BigDecimal(this.value);
            dec = dec.setScale(scale, 4);
            return new DoubleValue(dec.doubleValue());
        }
        double rem = d % 10.0;
        if (rem >= 5.0) {
            d += 10.0 - rem;
        } else if (rem < 5.0) {
            d -= rem;
        }
        d /= factor;
        if (this.value < 0.0) {
            d = -d;
        }
        return new DoubleValue(d);
    }

    public NumericValue roundHalfToEven(int scale) {
        if (Double.isNaN(this.value)) {
            return this;
        }
        if (Double.isInfinite(this.value)) {
            return this;
        }
        if (this.value == 0.0) {
            return this;
        }
        double factor = Math.pow(10.0, scale + 1);
        double d = Math.abs(this.value * factor);
        if (Double.isInfinite(d)) {
            BigDecimal dec = new BigDecimal(this.value);
            dec = dec.setScale(scale, 6);
            return new DoubleValue(dec.doubleValue());
        }
        double rem = d % 10.0;
        d = rem > 5.0 ? (d += 10.0 - rem) : (rem < 5.0 ? (d -= rem) : (d % 20.0 == 15.0 ? (d += 5.0) : (d -= 5.0)));
        d /= factor;
        if (this.value < 0.0) {
            d = -d;
        }
        return new DoubleValue(d);
    }

    public double signum() {
        if (Double.isNaN(this.value)) {
            return this.value;
        }
        if (this.value > 0.0) {
            return 1.0;
        }
        if (this.value == 0.0) {
            return 0.0;
        }
        return -1.0;
    }

    public boolean isWholeNumber() {
        return this.value == Math.floor(this.value) && !Double.isInfinite(this.value);
    }

    public NumericValue abs() {
        if (this.value > 0.0) {
            return this;
        }
        return new DoubleValue(Math.abs(this.value));
    }

    public int compareTo(long other) {
        double otherDouble = other;
        if (this.value == otherDouble) {
            return 0;
        }
        if (this.value < otherDouble) {
            return -1;
        }
        return 1;
    }

    public Comparable getSchemaComparable() {
        return new Double(this.value);
    }

    public boolean isIdentical(Value v) {
        return v instanceof DoubleValue && DoubleSortComparer.getInstance().comparesEqual(this, (DoubleValue)v);
    }

    public static void printInternalForm(double d) {
        System.err.println("==== Double " + d + " ====");
        long bits = Double.doubleToLongBits(d);
        System.err.println("Internal form: " + Long.toHexString(bits));
        if (bits == 0x7FF0000000000000L) {
            System.err.println("+Infinity");
        } else if (bits == -4503599627370496L) {
            System.err.println("-Infinity");
        } else if (bits == 9221120237041090560L) {
            System.err.println("NaN");
        } else {
            int s = bits >> 63 == 0L ? 1 : -1;
            int e = (int)(bits >> 52 & 0x7FFL);
            long m = e == 0 ? (bits & 0xFFFFFFFFFFFFFL) << 1 : bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            int exponent = e - 1075;
            System.err.println("Sign: " + s);
            System.err.println("Raw Exponent: " + e);
            System.err.println("Exponent: " + exponent);
            System.err.println("Significand: " + m);
            BigDecimal dec = BigDecimal.valueOf(m);
            dec = exponent > 0 ? dec.multiply(new BigDecimal(BigInteger.valueOf(2L).pow(exponent))) : dec.divide(new BigDecimal(BigInteger.valueOf(2L).pow(-exponent)), 6);
            System.err.println("Exact value: " + (s > 0 ? "" : "-") + dec);
        }
    }

    public static DoubleValue fromInternalForm(String hex) {
        return new DoubleValue(Double.longBitsToDouble(Long.parseLong(hex, 16)));
    }

    public static void main(String[] args) {
        System.err.println(DoubleValue.fromInternalForm("3fdeaee8744b05f1"));
    }
}

