/***********************************************************************************

    Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_WIDGETCHART_HEADER
#define LIFEOGRAPH_WIDGETCHART_HEADER


#include <gtkmm/drawingarea.h>
#include <gtkmm/builder.h>

#include "helpers.hpp"


namespace LIFEO
{

using namespace HELPERS;

class ChartPoints; // forward declaration

class WidgetChart : public Gtk::DrawingArea
{
    public:
        // CONSTANTS
        static constexpr float      border_curve = 30.0;
        static constexpr float      border_label = 10.0;
        static constexpr float      offset_label = 5.0;
        static constexpr float      label_height = 12.0;
        static constexpr float      bar_height = 20.0;
        static constexpr float      OVERVIEW_COEFFICIENT = 15;
        static constexpr float      COLUMN_WIDTH_MIN= 45.0;
        // CALCULATED CONSTANTS
        static constexpr float      label_y = offset_label + label_height;
        static constexpr float      s_x_min = border_curve + border_label;
        static constexpr float      s_y_min = border_curve;

                                    WidgetChart( BaseObjectType*,
                                                 const Glib::RefPtr< Gtk::Builder >& );
        void                        set_points( ChartPoints*, float = 1.0f );
        void                        set_zoom( float );
        bool                        is_zoom_possible();
        void                        update()
        {
            if( Glib::RefPtr< Gdk::Window > window = get_window() )
                window->invalidate( false );
        }

    protected:
        void                        on_size_allocate( Gtk::Allocation& );
        bool                        on_scroll_event( GdkEventScroll* );
        bool                        on_button_press_event( GdkEventButton* );
        bool                        on_button_release_event( GdkEventButton* );
        bool                        on_motion_notify_event( GdkEventMotion* );
        bool                        on_leave_notify_event( GdkEventCrossing* );
        bool                        on_draw( const Cairo::RefPtr< Cairo::Context >& );

        bool                        handle_query_tooltip( int, int, bool,
                                                          const Glib::RefPtr< Gtk::Tooltip >& );

        void                        update_col_geom( bool = false );

        // DATA
        ChartPoints*                m_points{ nullptr };

        // GEOMETRY
        int                         m_width{ -1 };
        int                         m_height{ -1 };
        unsigned int                m_span{ 0 };
        unsigned int                m_step_count{ 0 };
        unsigned int                m_step_start{ 0 };
        float                       m_zoom_level{ 1.0f };

        float                       m_x_max{ 0.0f }, m_y_max{ 0.0f }, m_y_mid{ 0.0f };
        float                       m_amplitude{ 0.0f }, m_length{ 0.0f };
        float                       m_step_x{ 0.0f }, m_coefficient{ 0.0f };
        float                       m_ov_height{ 0.0f };
        float                       m_step_x_ov{ 0.0f }, m_ampli_ov{ 0.0f }, m_coeff_ov{ 0.0f };

        Cairo::RefPtr< Cairo::ToyFontFace >
                                    m_font_main;

        bool                        m_flag_button_pressed{ false };
        bool                        m_flag_pointer_hovered{ false };
};

} // end of namespace LIFEO

#endif
