--------------------------------------------------------------------------
-- Fixme
-- @module pager

require("strict")
--------------------------------------------------------------------------
-- Lmod License
--------------------------------------------------------------------------
--
--  Lmod is licensed under the terms of the MIT license reproduced below.
--  This means that Lmod is free software and can be used for both academic
--  and commercial purposes at absolutely no cost.
--
--  ----------------------------------------------------------------------
--
--  Copyright (C) 2008-2014 Robert McLay
--
--  Permission is hereby granted, free of charge, to any person obtaining
--  a copy of this software and associated documentation files (the
--  "Software"), to deal in the Software without restriction, including
--  without limitation the rights to use, copy, modify, merge, publish,
--  distribute, sublicense, and/or sell copies of the Software, and to
--  permit persons to whom the Software is furnished to do so, subject
--  to the following conditions:
--
--  The above copyright notice and this permission notice shall be
--  included in all copies or substantial portions of the Software.
--
--  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
--  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
--  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
--  NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
--  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
--  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
--  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
--  THE SOFTWARE.
--
--------------------------------------------------------------------------

local dbg       = require("Dbg"):dbg()
local concatTbl = table.concat

local function argsPack(...)
   local  arg = { n = select ("#", ...), ...}
   return arg
end

local pack        = (_VERSION == "Lua 5.1") and argsPack or table.pack

--------------------------------------------------------------------------
-- Pager: This file provides two ways to use the pager.  If stderr is
--        connected to a term and it is configured for it, stderr will be
--        run through the pager.  If not bypassPager is used which just
--        writes all strings to the stream "f".

s_pager = false


--------------------------------------------------------------------------
-- bypassPager(): all input arguments to stream f

function bypassPager(f, ...)
   local arg = pack(...)
   for i = 1, arg.n do
      f:write(arg[i])
   end
end

--------------------------------------------------------------------------
-- usePager(): Use pager to present input arguments to user via whatever
--             pager has been chosen.

function usePager(f, ...)
   dbg.start{"usePager()"}
   local p = io.popen(s_pager .. " 1>&2" ,"w")
   local s = concatTbl({...},"")
   p:write(s)
   p:close()
   dbg.fini()
end

--------------------------------------------------------------------------
-- buildPager(): Return usePager if PAGER exists otherwise,  return bypassPager

function buildPager()
   local func  = bypassPager
   local pager = LMOD_PAGER or os.getenv("PAGER") or Pager
   s_pager     = findInPath(pager)
   if (s_pager and s_pager ~= "") then
      func     = usePager
   end
   return func
end
