TEMPLATE = lib
DESTDIR  = ./lib
TARGET  = guytools

include( ./libguytools_version.pro.inc )

# The following line allows the software to see its own version
# (just for logging purpose). Many slashes and quotes... look at
# result of it during compilation
DEFINES += "LIBGUYTOOLS_VERSION=\\\""$$VERSION"\\\""

# Use the standard Qt configuration but remove the GUI part, as we do not need it.
CONFIG  += qt
QT      -= gui

CONFIG  += warn_on thread release
DEFINES += TOCFG_COMPILE_FOR_USE_WITHOUT_TOOLBOX

DEPENDPATH  += ./include
INCLUDEPATH += ./include

QMAKE_CXXFLAGS_WARN_ON += -Wno-strict-aliasing   # Switch off warning "dereferencing type-punned pointer will break strict-aliasing rules"
QMAKE_CXXFLAGS_WARN_ON += -fmessage-length=0     # Tell g++ not to split messages into different lines
QMAKE_CXXFLAGS_RELEASE += -O3

SOURCES += toollog.cpp
SOURCES += toolerror.cpp
SOURCES += toolsysinfo.cpp
SOURCES += toolsignal.cpp
SOURCES += toolcfg.cpp


