
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Quantity_Period.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <Quantity_Array1OfColor.hxx>
#include <Quantity_Color.hxx>
#include <Quantity_ColorRGBA.hxx>
#include <Quantity_Date.hxx>
#include <Quantity_DateDefinitionError.hxx>
#include <Quantity_HArray1OfColor.hxx>
#include <Quantity_NameOfColor.hxx>
#include <Quantity_Period.hxx>
#include <Quantity_PeriodDefinitionError.hxx>
#include <Quantity_TypeOfColor.hxx>

// template related includes

// ./opencascade/Quantity_Array1OfColor.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_Quantity(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("Quantity"));
py::object klass;

//Python trampoline classes

// classes

    // Class Quantity_Color from ./opencascade/Quantity_Color.hxx
    klass = m.attr("Quantity_Color");


    // nested enums

    static_cast<py::class_<Quantity_Color , shared_ptr<Quantity_Color>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const Quantity_NameOfColor >()  , py::arg("theName") )
        .def(py::init< const Standard_Real,const Standard_Real,const Standard_Real,const Quantity_TypeOfColor >()  , py::arg("theC1"),  py::arg("theC2"),  py::arg("theC3"),  py::arg("theType") )
        .def(py::init< const NCollection_Vec3<float> & >()  , py::arg("theRgb") )
    // custom constructors
    // methods
        .def("Name",
             (Quantity_NameOfColor (Quantity_Color::*)() const) static_cast<Quantity_NameOfColor (Quantity_Color::*)() const>(&Quantity_Color::Name),
             R"#(Returns the name of the nearest color from the Quantity_NameOfColor enumeration.)#" 
          )
        .def("SetValues",
             (void (Quantity_Color::*)( const Quantity_NameOfColor  ) ) static_cast<void (Quantity_Color::*)( const Quantity_NameOfColor  ) >(&Quantity_Color::SetValues),
             R"#(Updates the color from specified named color.)#"  , py::arg("theName")
          )
        .def("SetValues",
             (void (Quantity_Color::*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Quantity_TypeOfColor  ) ) static_cast<void (Quantity_Color::*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Quantity_TypeOfColor  ) >(&Quantity_Color::SetValues),
             R"#(Updates a color according to the mode specified by theType. Throws exception if values are out of range.)#"  , py::arg("theC1"),  py::arg("theC2"),  py::arg("theC3"),  py::arg("theType")
          )
        .def("Red",
             (Standard_Real (Quantity_Color::*)() const) static_cast<Standard_Real (Quantity_Color::*)() const>(&Quantity_Color::Red),
             R"#(Returns the Red component (quantity of red) of the color within range [0.0; 1.0].)#" 
          )
        .def("Green",
             (Standard_Real (Quantity_Color::*)() const) static_cast<Standard_Real (Quantity_Color::*)() const>(&Quantity_Color::Green),
             R"#(Returns the Green component (quantity of green) of the color within range [0.0; 1.0].)#" 
          )
        .def("Blue",
             (Standard_Real (Quantity_Color::*)() const) static_cast<Standard_Real (Quantity_Color::*)() const>(&Quantity_Color::Blue),
             R"#(Returns the Blue component (quantity of blue) of the color within range [0.0; 1.0].)#" 
          )
        .def("Hue",
             (Standard_Real (Quantity_Color::*)() const) static_cast<Standard_Real (Quantity_Color::*)() const>(&Quantity_Color::Hue),
             R"#(Returns the Hue component (hue angle) of the color in degrees within range [0.0; 360.0], 0.0 being Red. -1.0 is a special value reserved for grayscale color (S should be 0.0))#" 
          )
        .def("Light",
             (Standard_Real (Quantity_Color::*)() const) static_cast<Standard_Real (Quantity_Color::*)() const>(&Quantity_Color::Light),
             R"#(Returns the Light component (value of the lightness) of the color within range [0.0; 1.0].)#" 
          )
        .def("ChangeIntensity",
             (void (Quantity_Color::*)( const Standard_Real  ) ) static_cast<void (Quantity_Color::*)( const Standard_Real  ) >(&Quantity_Color::ChangeIntensity),
             R"#(Increases or decreases the intensity (variation of the lightness). The delta is a percentage. Any value greater than zero will increase the intensity. The variation is expressed as a percentage of the current value.)#"  , py::arg("theDelta")
          )
        .def("Saturation",
             (Standard_Real (Quantity_Color::*)() const) static_cast<Standard_Real (Quantity_Color::*)() const>(&Quantity_Color::Saturation),
             R"#(Returns the Saturation component (value of the saturation) of the color within range [0.0; 1.0].)#" 
          )
        .def("ChangeContrast",
             (void (Quantity_Color::*)( const Standard_Real  ) ) static_cast<void (Quantity_Color::*)( const Standard_Real  ) >(&Quantity_Color::ChangeContrast),
             R"#(Increases or decreases the contrast (variation of the saturation). The delta is a percentage. Any value greater than zero will increase the contrast. The variation is expressed as a percentage of the current value.)#"  , py::arg("theDelta")
          )
        .def("IsDifferent",
             (Standard_Boolean (Quantity_Color::*)( const Quantity_Color &  ) const) static_cast<Standard_Boolean (Quantity_Color::*)( const Quantity_Color &  ) const>(&Quantity_Color::IsDifferent),
             R"#(Returns TRUE if the distance between two colors is greater than Epsilon().)#"  , py::arg("theOther")
          )
        .def("IsEqual",
             (Standard_Boolean (Quantity_Color::*)( const Quantity_Color &  ) const) static_cast<Standard_Boolean (Quantity_Color::*)( const Quantity_Color &  ) const>(&Quantity_Color::IsEqual),
             R"#(Returns TRUE if the distance between two colors is no greater than Epsilon().)#"  , py::arg("theOther")
          )
        .def("Distance",
             (Standard_Real (Quantity_Color::*)( const Quantity_Color &  ) const) static_cast<Standard_Real (Quantity_Color::*)( const Quantity_Color &  ) const>(&Quantity_Color::Distance),
             R"#(Returns the distance between two colors. It's a value between 0 and the square root of 3 (the black/white distance).)#"  , py::arg("theColor")
          )
        .def("SquareDistance",
             (Standard_Real (Quantity_Color::*)( const Quantity_Color &  ) const) static_cast<Standard_Real (Quantity_Color::*)( const Quantity_Color &  ) const>(&Quantity_Color::SquareDistance),
             R"#(Returns the square of distance between two colors.)#"  , py::arg("theColor")
          )
        .def("DeltaE2000",
             (Standard_Real (Quantity_Color::*)( const Quantity_Color &  ) const) static_cast<Standard_Real (Quantity_Color::*)( const Quantity_Color &  ) const>(&Quantity_Color::DeltaE2000),
             R"#(Returns the value of the perceptual difference between this color and theOther, computed using the CIEDE2000 formula. The difference is in range [0, 100.], with 1 approximately corresponding to the minimal percievable difference (usually difference 5 or greater is needed for the difference to be recognizable in practice).)#"  , py::arg("theOther")
          )
        .def("DumpJson",
             (void (Quantity_Color::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Quantity_Color::*)( std::ostream & ,  Standard_Integer  ) const>(&Quantity_Color::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("InitFromJson",
             (Standard_Boolean (Quantity_Color::*)(  const std::stringstream & ,  Standard_Integer &  ) ) static_cast<Standard_Boolean (Quantity_Color::*)(  const std::stringstream & ,  Standard_Integer &  ) >(&Quantity_Color::InitFromJson),
             R"#(Inits the content of me from the stream)#"  , py::arg("theSStream"),  py::arg("theStreamPos")
          )
    // methods using call by reference i.s.o. return
        .def("Values",
             []( Quantity_Color &self , const Quantity_TypeOfColor theType ){
                 Standard_Real  theC1;
                Standard_Real  theC2;
                Standard_Real  theC3;

                 self.Values(theC1,theC2,theC3,theType);
                 
                 return std::make_tuple(theC1,theC2,theC3); },
             R"#(Returns in theC1, theC2 and theC3 the components of this color according to the color system definition theType.)#"  , py::arg("theType")
          )
        .def("Delta",
             []( Quantity_Color &self , const Quantity_Color & theColor ){
                 Standard_Real  DC;
                Standard_Real  DI;

                 self.Delta(theColor,DC,DI);
                 
                 return std::make_tuple(DC,DI); },
             R"#(Returns the percentage change of contrast and intensity between this and another color. <DC> and <DI> are percentages, either positive or negative. The calculation is with respect to this color. If <DC> is positive then <me> is more contrasty. If <DI> is positive then <me> is more intense.)#"  , py::arg("theColor")
          )
    // static methods
        .def_static("Name_s",
                    (Quantity_NameOfColor (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) ) static_cast<Quantity_NameOfColor (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) >(&Quantity_Color::Name),
                    R"#(Returns the color from Quantity_NameOfColor enumeration nearest to specified RGB values.)#"  , py::arg("theR"),  py::arg("theG"),  py::arg("theB")
          )
        .def_static("StringName_s",
                    (Standard_CString (*)( const Quantity_NameOfColor  ) ) static_cast<Standard_CString (*)( const Quantity_NameOfColor  ) >(&Quantity_Color::StringName),
                    R"#(Returns the name of the color identified by the given Quantity_NameOfColor enumeration value.)#"  , py::arg("theColor")
          )
        .def_static("ColorFromName_s",
                    (Standard_Boolean (*)( const Standard_CString ,  Quantity_NameOfColor &  ) ) static_cast<Standard_Boolean (*)( const Standard_CString ,  Quantity_NameOfColor &  ) >(&Quantity_Color::ColorFromName),
                    R"#(Finds color from predefined names. For example, the name of the color which corresponds to "BLACK" is Quantity_NOC_BLACK. Returns FALSE if name is unknown.)#"  , py::arg("theName"),  py::arg("theColor")
          )
        .def_static("ColorFromName_s",
                    (Standard_Boolean (*)( const Standard_CString ,  Quantity_Color &  ) ) static_cast<Standard_Boolean (*)( const Standard_CString ,  Quantity_Color &  ) >(&Quantity_Color::ColorFromName),
                    R"#(Finds color from predefined names.)#"  , py::arg("theColorNameString"),  py::arg("theColor")
          )
        .def_static("ColorFromHex_s",
                    (bool (*)( const Standard_CString ,  Quantity_Color &  ) ) static_cast<bool (*)( const Standard_CString ,  Quantity_Color &  ) >(&Quantity_Color::ColorFromHex),
                    R"#(Parses the string as a hex color (like "#FF0" for short sRGB color, or "#FFFF00" for sRGB color))#"  , py::arg("theHexColorString"),  py::arg("theColor")
          )
        .def_static("ColorToHex_s",
                    (TCollection_AsciiString (*)( const Quantity_Color & ,  const bool  ) ) static_cast<TCollection_AsciiString (*)( const Quantity_Color & ,  const bool  ) >(&Quantity_Color::ColorToHex),
                    R"#(Returns hex sRGB string in format "#FFAAFF".)#"  , py::arg("theColor"),  py::arg("theToPrefixHash")=static_cast<const bool>(true)
          )
        .def_static("Convert_sRGB_To_HLS_s",
                    (NCollection_Vec3<float> (*)( const NCollection_Vec3<float> &  ) ) static_cast<NCollection_Vec3<float> (*)( const NCollection_Vec3<float> &  ) >(&Quantity_Color::Convert_sRGB_To_HLS),
                    R"#(Converts sRGB components into HLS ones.)#"  , py::arg("theRgb")
          )
        .def_static("Convert_HLS_To_sRGB_s",
                    (NCollection_Vec3<float> (*)( const NCollection_Vec3<float> &  ) ) static_cast<NCollection_Vec3<float> (*)( const NCollection_Vec3<float> &  ) >(&Quantity_Color::Convert_HLS_To_sRGB),
                    R"#(Converts HLS components into RGB ones.)#"  , py::arg("theHls")
          )
        .def_static("Convert_LinearRGB_To_HLS_s",
                    (NCollection_Vec3<float> (*)( const NCollection_Vec3<float> &  ) ) static_cast<NCollection_Vec3<float> (*)( const NCollection_Vec3<float> &  ) >(&Quantity_Color::Convert_LinearRGB_To_HLS),
                    R"#(Converts Linear RGB components into HLS ones.)#"  , py::arg("theRgb")
          )
        .def_static("Convert_HLS_To_LinearRGB_s",
                    (NCollection_Vec3<float> (*)( const NCollection_Vec3<float> &  ) ) static_cast<NCollection_Vec3<float> (*)( const NCollection_Vec3<float> &  ) >(&Quantity_Color::Convert_HLS_To_LinearRGB),
                    R"#(Converts HLS components into linear RGB ones.)#"  , py::arg("theHls")
          )
        .def_static("Convert_LinearRGB_To_Lab_s",
                    (NCollection_Vec3<float> (*)( const NCollection_Vec3<float> &  ) ) static_cast<NCollection_Vec3<float> (*)( const NCollection_Vec3<float> &  ) >(&Quantity_Color::Convert_LinearRGB_To_Lab),
                    R"#(Converts linear RGB components into CIE Lab ones.)#"  , py::arg("theRgb")
          )
        .def_static("Convert_Lab_To_Lch_s",
                    (NCollection_Vec3<float> (*)( const NCollection_Vec3<float> &  ) ) static_cast<NCollection_Vec3<float> (*)( const NCollection_Vec3<float> &  ) >(&Quantity_Color::Convert_Lab_To_Lch),
                    R"#(Converts CIE Lab components into CIE Lch ones.)#"  , py::arg("theLab")
          )
        .def_static("Convert_Lab_To_LinearRGB_s",
                    (NCollection_Vec3<float> (*)( const NCollection_Vec3<float> &  ) ) static_cast<NCollection_Vec3<float> (*)( const NCollection_Vec3<float> &  ) >(&Quantity_Color::Convert_Lab_To_LinearRGB),
                    R"#(Converts CIE Lab components into linear RGB ones. Note that the resulting values may be out of the valid range for RGB.)#"  , py::arg("theLab")
          )
        .def_static("Convert_Lch_To_Lab_s",
                    (NCollection_Vec3<float> (*)( const NCollection_Vec3<float> &  ) ) static_cast<NCollection_Vec3<float> (*)( const NCollection_Vec3<float> &  ) >(&Quantity_Color::Convert_Lch_To_Lab),
                    R"#(Converts CIE Lch components into CIE Lab ones.)#"  , py::arg("theLch")
          )
        .def_static("Argb2color_s",
                    (void (*)( const Standard_Integer ,  Quantity_Color &  ) ) static_cast<void (*)( const Standard_Integer ,  Quantity_Color &  ) >(&Quantity_Color::Argb2color),
                    R"#(Convert integer ARGB value to Color. Alpha bits are ignored. Note that this packing does NOT involve linear -> non-linear sRGB conversion, as would be usually expected to preserve higher (for human eye) color precision in 4 bytes.)#"  , py::arg("theARGB"),  py::arg("theColor")
          )
        .def_static("Convert_LinearRGB_To_sRGB_s",
                    (Standard_Real (*)( Standard_Real  ) ) static_cast<Standard_Real (*)( Standard_Real  ) >(&Quantity_Color::Convert_LinearRGB_To_sRGB),
                    R"#(Convert linear RGB component into sRGB using OpenGL specs formula (double precision), also known as gamma correction.)#"  , py::arg("theLinearValue")
          )
        .def_static("Convert_LinearRGB_To_sRGB_s",
                    (float (*)( float  ) ) static_cast<float (*)( float  ) >(&Quantity_Color::Convert_LinearRGB_To_sRGB),
                    R"#(Convert linear RGB component into sRGB using OpenGL specs formula (single precision), also known as gamma correction.)#"  , py::arg("theLinearValue")
          )
        .def_static("Convert_sRGB_To_LinearRGB_s",
                    (Standard_Real (*)( Standard_Real  ) ) static_cast<Standard_Real (*)( Standard_Real  ) >(&Quantity_Color::Convert_sRGB_To_LinearRGB),
                    R"#(Convert sRGB component into linear RGB using OpenGL specs formula (double precision), also known as gamma correction.)#"  , py::arg("thesRGBValue")
          )
        .def_static("Convert_sRGB_To_LinearRGB_s",
                    (float (*)( float  ) ) static_cast<float (*)( float  ) >(&Quantity_Color::Convert_sRGB_To_LinearRGB),
                    R"#(Convert sRGB component into linear RGB using OpenGL specs formula (single precision), also known as gamma correction.)#"  , py::arg("thesRGBValue")
          )
        .def_static("Convert_LinearRGB_To_sRGB_approx22_s",
                    (float (*)( float  ) ) static_cast<float (*)( float  ) >(&Quantity_Color::Convert_LinearRGB_To_sRGB_approx22),
                    R"#(Convert linear RGB component into sRGB using approximated uniform gamma coefficient 2.2.)#"  , py::arg("theLinearValue")
          )
        .def_static("Convert_sRGB_To_LinearRGB_approx22_s",
                    (float (*)( float  ) ) static_cast<float (*)( float  ) >(&Quantity_Color::Convert_sRGB_To_LinearRGB_approx22),
                    R"#(Convert sRGB component into linear RGB using approximated uniform gamma coefficient 2.2)#"  , py::arg("thesRGBValue")
          )
        .def_static("Convert_LinearRGB_To_sRGB_approx22_s",
                    (NCollection_Vec3<float> (*)( const NCollection_Vec3<float> &  ) ) static_cast<NCollection_Vec3<float> (*)( const NCollection_Vec3<float> &  ) >(&Quantity_Color::Convert_LinearRGB_To_sRGB_approx22),
                    R"#(Convert linear RGB components into sRGB using approximated uniform gamma coefficient 2.2)#"  , py::arg("theRGB")
          )
        .def_static("Convert_sRGB_To_LinearRGB_approx22_s",
                    (NCollection_Vec3<float> (*)( const NCollection_Vec3<float> &  ) ) static_cast<NCollection_Vec3<float> (*)( const NCollection_Vec3<float> &  ) >(&Quantity_Color::Convert_sRGB_To_LinearRGB_approx22),
                    R"#(Convert sRGB components into linear RGB using approximated uniform gamma coefficient 2.2)#"  , py::arg("theRGB")
          )
        .def_static("Epsilon_s",
                    (Standard_Real (*)() ) static_cast<Standard_Real (*)() >(&Quantity_Color::Epsilon),
                    R"#(Returns the value used to compare two colors for equality; 0.0001 by default.)#" 
          )
        .def_static("SetEpsilon_s",
                    (void (*)( const Standard_Real  ) ) static_cast<void (*)( const Standard_Real  ) >(&Quantity_Color::SetEpsilon),
                    R"#(Set the value used to compare two colors for equality.)#"  , py::arg("theEpsilon")
          )
    // static methods using call by reference i.s.o. return
        .def_static("Color2argb_s",
            [](const Quantity_Color & theColor ){
                Standard_Integer  theARGB;

                Quantity_Color::Color2argb(theColor,theARGB);
                
return std::make_tuple(theARGB); },
            R"#(Convert the color value to ARGB integer value, with alpha equals to 0. So the output is formatted as 0x00RRGGBB. Note that this unpacking does NOT involve non-linear sRGB -> linear RGB conversion, as would be usually expected for RGB color packed into 4 bytes.)#"  , py::arg("theColor")
          )
        .def_static("HlsRgb_s",
            [](const Standard_Real theH,const Standard_Real theL,const Standard_Real theS ){
                Standard_Real  theR;
                Standard_Real  theG;
                Standard_Real  theB;

                Quantity_Color::HlsRgb(theH,theL,theS,theR,theG,theB);
                
return std::make_tuple(theR,theG,theB); },
            R"#(Converts HLS components into sRGB ones.)#"  , py::arg("theH"),  py::arg("theL"),  py::arg("theS")
          )
        .def_static("RgbHls_s",
            [](const Standard_Real theR,const Standard_Real theG,const Standard_Real theB ){
                Standard_Real  theH;
                Standard_Real  theL;
                Standard_Real  theS;

                Quantity_Color::RgbHls(theR,theG,theB,theH,theL,theS);
                
return std::make_tuple(theH,theL,theS); },
            R"#(Converts sRGB components into HLS ones.)#"  , py::arg("theR"),  py::arg("theG"),  py::arg("theB")
          )
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Rgb",
             (const NCollection_Vec3<float> & (Quantity_Color::*)() const) static_cast<const NCollection_Vec3<float> & (Quantity_Color::*)() const>(&Quantity_Color::Rgb),
             R"#(Return the color as vector of 3 float elements.)#"
             
         )
;

    // Class Quantity_ColorRGBA from ./opencascade/Quantity_ColorRGBA.hxx
    klass = m.attr("Quantity_ColorRGBA");


    // nested enums

    static_cast<py::class_<Quantity_ColorRGBA , shared_ptr<Quantity_ColorRGBA>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const Quantity_Color & >()  , py::arg("theRgb") )
        .def(py::init< const Quantity_Color &,float >()  , py::arg("theRgb"),  py::arg("theAlpha") )
        .def(py::init< const NCollection_Vec4<float> & >()  , py::arg("theRgba") )
        .def(py::init< float,float,float,float >()  , py::arg("theRed"),  py::arg("theGreen"),  py::arg("theBlue"),  py::arg("theAlpha") )
    // custom constructors
    // methods
        .def("SetValues",
             (void (Quantity_ColorRGBA::*)( float ,  float ,  float ,  float  ) ) static_cast<void (Quantity_ColorRGBA::*)( float ,  float ,  float ,  float  ) >(&Quantity_ColorRGBA::SetValues),
             R"#(Assign new values to the color.)#"  , py::arg("theRed"),  py::arg("theGreen"),  py::arg("theBlue"),  py::arg("theAlpha")
          )
        .def("SetRGB",
             (void (Quantity_ColorRGBA::*)( const Quantity_Color &  ) ) static_cast<void (Quantity_ColorRGBA::*)( const Quantity_Color &  ) >(&Quantity_ColorRGBA::SetRGB),
             R"#(Assign RGB color components without affecting alpha value.)#"  , py::arg("theRgb")
          )
        .def("Alpha",
             (Standard_ShortReal (Quantity_ColorRGBA::*)() const) static_cast<Standard_ShortReal (Quantity_ColorRGBA::*)() const>(&Quantity_ColorRGBA::Alpha),
             R"#(Return alpha value (1.0 means opaque, 0.0 means fully transparent).)#" 
          )
        .def("SetAlpha",
             (void (Quantity_ColorRGBA::*)( const Standard_ShortReal  ) ) static_cast<void (Quantity_ColorRGBA::*)( const Standard_ShortReal  ) >(&Quantity_ColorRGBA::SetAlpha),
             R"#(Assign the alpha value.)#"  , py::arg("theAlpha")
          )
        .def("IsDifferent",
             (bool (Quantity_ColorRGBA::*)( const Quantity_ColorRGBA &  ) const) static_cast<bool (Quantity_ColorRGBA::*)( const Quantity_ColorRGBA &  ) const>(&Quantity_ColorRGBA::IsDifferent),
             R"#(Returns true if the distance between colors is greater than Epsilon().)#"  , py::arg("theOther")
          )
        .def("IsEqual",
             (bool (Quantity_ColorRGBA::*)( const Quantity_ColorRGBA &  ) const) static_cast<bool (Quantity_ColorRGBA::*)( const Quantity_ColorRGBA &  ) const>(&Quantity_ColorRGBA::IsEqual),
             R"#(Two colors are considered to be equal if their distance is no greater than Epsilon().)#"  , py::arg("theOther")
          )
        .def("DumpJson",
             (void (Quantity_ColorRGBA::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Quantity_ColorRGBA::*)( std::ostream & ,  Standard_Integer  ) const>(&Quantity_ColorRGBA::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("InitFromJson",
             (Standard_Boolean (Quantity_ColorRGBA::*)(  const std::stringstream & ,  Standard_Integer &  ) ) static_cast<Standard_Boolean (Quantity_ColorRGBA::*)(  const std::stringstream & ,  Standard_Integer &  ) >(&Quantity_ColorRGBA::InitFromJson),
             R"#(Inits the content of me from the stream)#"  , py::arg("theSStream"),  py::arg("theStreamPos")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("ColorFromName_s",
                    (Standard_Boolean (*)( const Standard_CString ,  Quantity_ColorRGBA &  ) ) static_cast<Standard_Boolean (*)( const Standard_CString ,  Quantity_ColorRGBA &  ) >(&Quantity_ColorRGBA::ColorFromName),
                    R"#(Finds color from predefined names. For example, the name of the color which corresponds to "BLACK" is Quantity_NOC_BLACK. An alpha component is set to 1.0.)#"  , py::arg("theColorNameString"),  py::arg("theColor")
          )
        .def_static("ColorFromHex_s",
                    (bool (*)( const char *const ,  Quantity_ColorRGBA & ,  const bool  ) ) static_cast<bool (*)( const char *const ,  Quantity_ColorRGBA & ,  const bool  ) >(&Quantity_ColorRGBA::ColorFromHex),
                    R"#(Parses the string as a hex color (like "#FF0" for short sRGB color, "#FF0F" for short sRGBA color, "#FFFF00" for RGB color, or "#FFFF00FF" for RGBA color))#"  , py::arg("theHexColorString"),  py::arg("theColor"),  py::arg("theAlphaComponentIsOff")=static_cast<const bool>(false)
          )
        .def_static("ColorToHex_s",
                    (TCollection_AsciiString (*)( const Quantity_ColorRGBA & ,  const bool  ) ) static_cast<TCollection_AsciiString (*)( const Quantity_ColorRGBA & ,  const bool  ) >(&Quantity_ColorRGBA::ColorToHex),
                    R"#(Returns hex sRGBA string in format "#RRGGBBAA".)#"  , py::arg("theColor"),  py::arg("theToPrefixHash")=static_cast<const bool>(true)
          )
        .def_static("Convert_LinearRGB_To_sRGB_s",
                    (NCollection_Vec4<float> (*)( const NCollection_Vec4<float> &  ) ) static_cast<NCollection_Vec4<float> (*)( const NCollection_Vec4<float> &  ) >(&Quantity_ColorRGBA::Convert_LinearRGB_To_sRGB),
                    R"#(Convert linear RGB components into sRGB using OpenGL specs formula.)#"  , py::arg("theRGB")
          )
        .def_static("Convert_sRGB_To_LinearRGB_s",
                    (NCollection_Vec4<float> (*)( const NCollection_Vec4<float> &  ) ) static_cast<NCollection_Vec4<float> (*)( const NCollection_Vec4<float> &  ) >(&Quantity_ColorRGBA::Convert_sRGB_To_LinearRGB),
                    R"#(Convert sRGB components into linear RGB using OpenGL specs formula.)#"  , py::arg("theRGB")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetRGB",
             (const Quantity_Color & (Quantity_ColorRGBA::*)() const) static_cast<const Quantity_Color & (Quantity_ColorRGBA::*)() const>(&Quantity_ColorRGBA::GetRGB),
             R"#(Return RGB color value.)#"
             
         )
       .def("ChangeRGB",
             (Quantity_Color & (Quantity_ColorRGBA::*)() ) static_cast<Quantity_Color & (Quantity_ColorRGBA::*)() >(&Quantity_ColorRGBA::ChangeRGB),
             R"#(Modify RGB color components without affecting alpha value.)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class Quantity_Date from ./opencascade/Quantity_Date.hxx
    klass = m.attr("Quantity_Date");


    // nested enums

    static_cast<py::class_<Quantity_Date , shared_ptr<Quantity_Date>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const Standard_Integer,const Standard_Integer,const Standard_Integer,const Standard_Integer,const Standard_Integer,const Standard_Integer,const Standard_Integer,const Standard_Integer >()  , py::arg("mm"),  py::arg("dd"),  py::arg("yyyy"),  py::arg("hh"),  py::arg("mn"),  py::arg("ss"),  py::arg("mis")=static_cast<const Standard_Integer>(0),  py::arg("mics")=static_cast<const Standard_Integer>(0) )
    // custom constructors
    // methods
        .def("SetValues",
             (void (Quantity_Date::*)( const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer  ) ) static_cast<void (Quantity_Date::*)( const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer  ) >(&Quantity_Date::SetValues),
             R"#(Assigns to this date the year yyyy, the month mm, the day dd, the hour hh, the minute mn, the second ss, the millisecond mis (defaulted to 0) and the microsecond mics (defaulted to 0). Exceptions Quantity_DateDefinitionError if mm, dd, hh, mn, ss, mis and mics are not components of a valid date.)#"  , py::arg("mm"),  py::arg("dd"),  py::arg("yy"),  py::arg("hh"),  py::arg("mn"),  py::arg("ss"),  py::arg("mis")=static_cast<const Standard_Integer>(0),  py::arg("mics")=static_cast<const Standard_Integer>(0)
          )
        .def("Difference",
             (Quantity_Period (Quantity_Date::*)( const Quantity_Date &  ) ) static_cast<Quantity_Period (Quantity_Date::*)( const Quantity_Date &  ) >(&Quantity_Date::Difference),
             R"#(Subtracts one Date from another one to find the period between and returns the value. The result is the absolute value between the difference of two dates.)#"  , py::arg("anOther")
          )
        .def("Subtract",
             (Quantity_Date (Quantity_Date::*)( const Quantity_Period &  ) ) static_cast<Quantity_Date (Quantity_Date::*)( const Quantity_Period &  ) >(&Quantity_Date::Subtract),
             R"#(Subtracts a period from a Date and returns the new Date. Raises an exception if the result date is anterior to Jan 1, 1979.)#"  , py::arg("aPeriod")
          )
        .def("Add",
             (Quantity_Date (Quantity_Date::*)( const Quantity_Period &  ) ) static_cast<Quantity_Date (Quantity_Date::*)( const Quantity_Period &  ) >(&Quantity_Date::Add),
             R"#(Adds a Period to a Date and returns the new Date.)#"  , py::arg("aPeriod")
          )
        .def("Year",
             (Standard_Integer (Quantity_Date::*)() ) static_cast<Standard_Integer (Quantity_Date::*)() >(&Quantity_Date::Year),
             R"#(Returns year of a Date.)#" 
          )
        .def("Month",
             (Standard_Integer (Quantity_Date::*)() ) static_cast<Standard_Integer (Quantity_Date::*)() >(&Quantity_Date::Month),
             R"#(Returns month of a Date.)#" 
          )
        .def("Day",
             (Standard_Integer (Quantity_Date::*)() ) static_cast<Standard_Integer (Quantity_Date::*)() >(&Quantity_Date::Day),
             R"#(Returns Day of a Date.)#" 
          )
        .def("Hour",
             (Standard_Integer (Quantity_Date::*)() ) static_cast<Standard_Integer (Quantity_Date::*)() >(&Quantity_Date::Hour),
             R"#(Returns Hour of a Date.)#" 
          )
        .def("Minute",
             (Standard_Integer (Quantity_Date::*)() ) static_cast<Standard_Integer (Quantity_Date::*)() >(&Quantity_Date::Minute),
             R"#(Returns minute of a Date.)#" 
          )
        .def("Second",
             (Standard_Integer (Quantity_Date::*)() ) static_cast<Standard_Integer (Quantity_Date::*)() >(&Quantity_Date::Second),
             R"#(Returns seconde of a Date.)#" 
          )
        .def("MilliSecond",
             (Standard_Integer (Quantity_Date::*)() ) static_cast<Standard_Integer (Quantity_Date::*)() >(&Quantity_Date::MilliSecond),
             R"#(Returns millisecond of a Date.)#" 
          )
        .def("MicroSecond",
             (Standard_Integer (Quantity_Date::*)() ) static_cast<Standard_Integer (Quantity_Date::*)() >(&Quantity_Date::MicroSecond),
             R"#(Returns microsecond of a Date.)#" 
          )
        .def("IsEqual",
             (Standard_Boolean (Quantity_Date::*)( const Quantity_Date &  ) const) static_cast<Standard_Boolean (Quantity_Date::*)( const Quantity_Date &  ) const>(&Quantity_Date::IsEqual),
             R"#(Returns TRUE if both <me> and <other> are equal. This method is an alias of operator ==.)#"  , py::arg("anOther")
          )
        .def("IsEarlier",
             (Standard_Boolean (Quantity_Date::*)( const Quantity_Date &  ) const) static_cast<Standard_Boolean (Quantity_Date::*)( const Quantity_Date &  ) const>(&Quantity_Date::IsEarlier),
             R"#(Returns TRUE if <me> is earlier than <other>.)#"  , py::arg("anOther")
          )
        .def("IsLater",
             (Standard_Boolean (Quantity_Date::*)( const Quantity_Date &  ) const) static_cast<Standard_Boolean (Quantity_Date::*)( const Quantity_Date &  ) const>(&Quantity_Date::IsLater),
             R"#(Returns TRUE if <me> is later then <other>.)#"  , py::arg("anOther")
          )
    // methods using call by reference i.s.o. return
        .def("Values",
             []( Quantity_Date &self   ){
                 Standard_Integer  mm;
                Standard_Integer  dd;
                Standard_Integer  yy;
                Standard_Integer  hh;
                Standard_Integer  mn;
                Standard_Integer  ss;
                Standard_Integer  mis;
                Standard_Integer  mics;

                 self.Values(mm,dd,yy,hh,mn,ss,mis,mics);
                 
                 return std::make_tuple(mm,dd,yy,hh,mn,ss,mis,mics); },
             R"#(Gets a complete Date. - in mm - the month, - in dd - the day, - in yyyy - the year, - in hh - the hour, - in mn - the minute, - in ss - the second, - in mis - the millisecond, and - in mics - the microsecond)#" 
          )
    // static methods
        .def_static("IsValid_s",
                    (Standard_Boolean (*)( const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer  ) ) static_cast<Standard_Boolean (*)( const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer  ) >(&Quantity_Date::IsValid),
                    R"#(Checks the validity of a date - returns true if a date defined from the year yyyy, the month mm, the day dd, the hour hh, the minute mn, the second ss, the millisecond mis (defaulted to 0) and the microsecond mics (defaulted to 0) is valid. A date must satisfy the conditions above: - yyyy is greater than or equal to 1979, - mm lies within the range [1, 12] (with 1 corresponding to January and 12 to December), - dd lies within a valid range for the month mm (from 1 to 28, 29, 30 or 31 depending on mm and whether yyyy is a leap year or not), - hh lies within the range [0, 23], - mn lies within the range [0, 59], - ss lies within the range [0, 59], - mis lies within the range [0, 999], - mics lies within the range [0, 999].C)#"  , py::arg("mm"),  py::arg("dd"),  py::arg("yy"),  py::arg("hh"),  py::arg("mn"),  py::arg("ss"),  py::arg("mis")=static_cast<const Standard_Integer>(0),  py::arg("mics")=static_cast<const Standard_Integer>(0)
          )
        .def_static("IsLeap_s",
                    (Standard_Boolean (*)( const Standard_Integer  ) ) static_cast<Standard_Boolean (*)( const Standard_Integer  ) >(&Quantity_Date::IsLeap),
                    R"#(Returns true if a year is a leap year. The leap years are divisible by 4 and not by 100 except the years divisible by 400.)#"  , py::arg("yy")
          )
    // static methods using call by reference i.s.o. return
    // operators
        .def("__sub__",
             (Quantity_Date (Quantity_Date::*)( const Quantity_Period &  ) ) static_cast<Quantity_Date (Quantity_Date::*)( const Quantity_Period &  ) >(&Quantity_Date::operator-),
             py::is_operator(),
             R"#(None)#"  , py::arg("aPeriod")
          )
        .def("__add__",
             (Quantity_Date (Quantity_Date::*)( const Quantity_Period &  ) ) static_cast<Quantity_Date (Quantity_Date::*)( const Quantity_Period &  ) >(&Quantity_Date::operator+),
             py::is_operator(),
             R"#(None)#"  , py::arg("aPeriod")
          )
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Quantity_HArray1OfColor from ./opencascade/Quantity_HArray1OfColor.hxx
    klass = m.attr("Quantity_HArray1OfColor");


    // nested enums

    static_cast<py::class_<Quantity_HArray1OfColor ,opencascade::handle<Quantity_HArray1OfColor>  , Quantity_Array1OfColor , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const Standard_Integer,const Standard_Integer >()  , py::arg("theLower"),  py::arg("theUpper") )
        .def(py::init< const Standard_Integer,const Standard_Integer, const Quantity_Color & >()  , py::arg("theLower"),  py::arg("theUpper"),  py::arg("theValue") )
        .def(py::init<  const Quantity_Color &,const Standard_Integer,const Standard_Integer,const bool >()  , py::arg("theBegin"),  py::arg("theLower"),  py::arg("theUpper"),  py::arg("arg") )
        .def(py::init<  const NCollection_Array1<Quantity_Color> & >()  , py::arg("theOther") )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Quantity_HArray1OfColor::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Quantity_HArray1OfColor::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Array1",
             (const Quantity_Array1OfColor & (Quantity_HArray1OfColor::*)() const) static_cast<const Quantity_Array1OfColor & (Quantity_HArray1OfColor::*)() const>(&Quantity_HArray1OfColor::Array1),
             R"#(None)#"
             
         )
       .def("ChangeArray1",
             (Quantity_Array1OfColor & (Quantity_HArray1OfColor::*)() ) static_cast<Quantity_Array1OfColor & (Quantity_HArray1OfColor::*)() >(&Quantity_HArray1OfColor::ChangeArray1),
             R"#(None)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Quantity_HArray1OfColor::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Quantity_HArray1OfColor::*)() const>(&Quantity_HArray1OfColor::DynamicType),
             R"#(None)#"
             
         )
;

    // Class Quantity_Period from ./opencascade/Quantity_Period.hxx
    klass = m.attr("Quantity_Period");


    // nested enums

    static_cast<py::class_<Quantity_Period , shared_ptr<Quantity_Period>  >>(klass)
    // constructors
        .def(py::init< const Standard_Integer,const Standard_Integer,const Standard_Integer,const Standard_Integer,const Standard_Integer,const Standard_Integer >()  , py::arg("dd"),  py::arg("hh"),  py::arg("mn"),  py::arg("ss"),  py::arg("mis")=static_cast<const Standard_Integer>(0),  py::arg("mics")=static_cast<const Standard_Integer>(0) )
        .def(py::init< const Standard_Integer,const Standard_Integer >()  , py::arg("ss"),  py::arg("mics")=static_cast<const Standard_Integer>(0) )
    // custom constructors
    // methods
        .def("SetValues",
             (void (Quantity_Period::*)( const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer  ) ) static_cast<void (Quantity_Period::*)( const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer  ) >(&Quantity_Period::SetValues),
             R"#(Assigns to this period the time interval defined - with dd days, hh hours, mn minutes, ss seconds, mis (defaulted to 0) milliseconds and mics (defaulted to 0) microseconds; or)#"  , py::arg("dd"),  py::arg("hh"),  py::arg("mn"),  py::arg("ss"),  py::arg("mis")=static_cast<const Standard_Integer>(0),  py::arg("mics")=static_cast<const Standard_Integer>(0)
          )
        .def("SetValues",
             (void (Quantity_Period::*)( const Standard_Integer ,  const Standard_Integer  ) ) static_cast<void (Quantity_Period::*)( const Standard_Integer ,  const Standard_Integer  ) >(&Quantity_Period::SetValues),
             R"#(Assigns to this period the time interval defined - with Ss seconds and Mics (defaulted to 0) microseconds. Exceptions Quantity_PeriodDefinitionError: - if the number of seconds expressed either by: - dd days, hh hours, mn minutes and ss seconds, or - Ss is less than 0. - if the number of microseconds expressed either by: - mis milliseconds and mics microseconds, or - Mics is less than 0.)#"  , py::arg("ss"),  py::arg("mics")=static_cast<const Standard_Integer>(0)
          )
        .def("Subtract",
             (Quantity_Period (Quantity_Period::*)( const Quantity_Period &  ) const) static_cast<Quantity_Period (Quantity_Period::*)( const Quantity_Period &  ) const>(&Quantity_Period::Subtract),
             R"#(Subtracts one Period from another and returns the difference.)#"  , py::arg("anOther")
          )
        .def("Add",
             (Quantity_Period (Quantity_Period::*)( const Quantity_Period &  ) const) static_cast<Quantity_Period (Quantity_Period::*)( const Quantity_Period &  ) const>(&Quantity_Period::Add),
             R"#(Adds one Period to another one.)#"  , py::arg("anOther")
          )
        .def("IsEqual",
             (Standard_Boolean (Quantity_Period::*)( const Quantity_Period &  ) const) static_cast<Standard_Boolean (Quantity_Period::*)( const Quantity_Period &  ) const>(&Quantity_Period::IsEqual),
             R"#(Returns TRUE if both <me> and <other> are equal.)#"  , py::arg("anOther")
          )
        .def("IsShorter",
             (Standard_Boolean (Quantity_Period::*)( const Quantity_Period &  ) const) static_cast<Standard_Boolean (Quantity_Period::*)( const Quantity_Period &  ) const>(&Quantity_Period::IsShorter),
             R"#(Returns TRUE if <me> is shorter than <other>.)#"  , py::arg("anOther")
          )
        .def("IsLonger",
             (Standard_Boolean (Quantity_Period::*)( const Quantity_Period &  ) const) static_cast<Standard_Boolean (Quantity_Period::*)( const Quantity_Period &  ) const>(&Quantity_Period::IsLonger),
             R"#(Returns TRUE if <me> is longer then <other>.)#"  , py::arg("anOther")
          )
    // methods using call by reference i.s.o. return
        .def("Values",
             []( Quantity_Period &self   ){
                 Standard_Integer  dd;
                Standard_Integer  hh;
                Standard_Integer  mn;
                Standard_Integer  ss;
                Standard_Integer  mis;
                Standard_Integer  mics;

                 self.Values(dd,hh,mn,ss,mis,mics);
                 
                 return std::make_tuple(dd,hh,mn,ss,mis,mics); },
             R"#(Decomposes this period into a number of days,hours, minutes,seconds,milliseconds and microseconds Example of return values: 2 days, 15 hours, 0 minute , 0 second 0 millisecond and 0 microsecond)#" 
          )
        .def("Values",
             []( Quantity_Period &self   ){
                 Standard_Integer  ss;
                Standard_Integer  mics;

                 self.Values(ss,mics);
                 
                 return std::make_tuple(ss,mics); },
             R"#(Returns the number of seconds in Ss and the number of remainding microseconds in Mics of this period. Example of return values: 3600 seconds and 0 microseconds)#" 
          )
    // static methods
        .def_static("IsValid_s",
                    (Standard_Boolean (*)( const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer  ) ) static_cast<Standard_Boolean (*)( const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer  ) >(&Quantity_Period::IsValid),
                    R"#(Checks the validity of a Period in form (dd,hh,mn,ss,mil,mic) With: 0 <= dd 0 <= hh 0 <= mn 0 <= ss 0 <= mis 0 <= mics)#"  , py::arg("dd"),  py::arg("hh"),  py::arg("mn"),  py::arg("ss"),  py::arg("mis")=static_cast<const Standard_Integer>(0),  py::arg("mics")=static_cast<const Standard_Integer>(0)
          )
        .def_static("IsValid_s",
                    (Standard_Boolean (*)( const Standard_Integer ,  const Standard_Integer  ) ) static_cast<Standard_Boolean (*)( const Standard_Integer ,  const Standard_Integer  ) >(&Quantity_Period::IsValid),
                    R"#(Checks the validity of a Period in form (ss,mic) With: 0 <= ss 0 <= mics)#"  , py::arg("ss"),  py::arg("mics")=static_cast<const Standard_Integer>(0)
          )
    // static methods using call by reference i.s.o. return
    // operators
        .def("__sub__",
             (Quantity_Period (Quantity_Period::*)( const Quantity_Period &  ) const) static_cast<Quantity_Period (Quantity_Period::*)( const Quantity_Period &  ) const>(&Quantity_Period::operator-),
             py::is_operator(),
             R"#(None)#"  , py::arg("anOther")
          )
        .def("__add__",
             (Quantity_Period (Quantity_Period::*)( const Quantity_Period &  ) const) static_cast<Quantity_Period (Quantity_Period::*)( const Quantity_Period &  ) const>(&Quantity_Period::operator+),
             py::is_operator(),
             R"#(None)#"  , py::arg("anOther")
          )
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

// functions
// ./opencascade/Quantity_Array1OfColor.hxx
// ./opencascade/Quantity_Color.hxx
// ./opencascade/Quantity_ColorRGBA.hxx
// ./opencascade/Quantity_Date.hxx
// ./opencascade/Quantity_DateDefinitionError.hxx
// ./opencascade/Quantity_HArray1OfColor.hxx
// ./opencascade/Quantity_NameOfColor.hxx
// ./opencascade/Quantity_Period.hxx
// ./opencascade/Quantity_PeriodDefinitionError.hxx
// ./opencascade/Quantity_TypeOfColor.hxx

// Additional functions

// operators

// register typdefs
    register_template_NCollection_Array1<Quantity_Color>(m,"Quantity_Array1OfColor");


// exceptions
register_occ_exception<Quantity_DateDefinitionError>(m, "Quantity_DateDefinitionError");
register_occ_exception<Quantity_PeriodDefinitionError>(m, "Quantity_PeriodDefinitionError");

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
