% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveLatex.R
\name{saveLatex}
\alias{saveLatex}
\title{Insert animations into a LaTeX document and compile it}
\usage{
saveLatex(expr, nmax, img.name = "Rplot", ani.opts, centering = TRUE, 
    caption = NULL, label = NULL, pkg.opts = NULL, documentclass = "article", 
    latex.filename = "animation.tex", pdflatex = "pdflatex", install.animate = TRUE, 
    overwrite = TRUE, full.path = FALSE, ...)
}
\arguments{
\item{expr}{an expression to generate animations; use either the animation
functions (e.g. \code{brownian.motion()}) in this package or a custom
expression (e.g. \code{for(i in 1:10) plot(runif(10), ylim = 0:1)}).}

\item{nmax}{maximum number of animation frames (if missing and the graphics
device is a bitmap device, this number will be automatically calculated);
note that we do not have to specify \code{nmax} when using PDF devices.}

\item{img.name}{basename of file names of animation frames; see the Note
section for a possible adjustment on \code{img.name}}

\item{ani.opts}{options to control the behavior of the animation (passed to
the LaTeX macro \code{'\\animategraphics'}; default to be
\code{'controls,width=\\linewidth'})}

\item{centering}{logical: whether to center the graph using the LaTeX
environment \verb{\begin{center}} and \verb{\end{center}}}

\item{caption, label}{caption and label for the graphics in the figure
environment}

\item{pkg.opts}{global options for the \code{animate} package}

\item{documentclass}{LaTeX document class; if \code{NULL}, the output will
not be a complete LaTeX document (only the code to generate the PDF
animation will be printed in the console); default to be \code{article},
but we can also provide a complete statement like
\verb{\\documentclass[a5paper]{article}}}

\item{latex.filename}{file name of the LaTeX document; if an empty string
\code{''}, the LaTeX code will be printed in the console and hence not
compiled}

\item{pdflatex}{the command for pdfLaTeX (set to \code{NULL} to ignore the
compiling)}

\item{install.animate}{copy the LaTeX style files \file{animate.sty} and
\file{animfp.sty}? If you have not installed the LaTeX package
\code{animate}, it suffices just to copy these to files.}

\item{overwrite}{whether to overwrite the existing image frames}

\item{full.path}{whether to use the full path (\code{TRUE}) or relative path
(\code{FALSE}) for the animation frames; usually the relative path
suffices, but sometimes the images and the LaTeX document might not be in
the same directory, so \code{full.path = TRUE} could be useful; in the
latter case, remember that you should never use spaces in the filenames or
paths!}

\item{...}{other arguments passed to the graphics device
\code{ani.options('ani.dev')}, e.g. \code{ani.height} and \code{ani.width}}
}
\value{
Invisible \code{NULL}
}
\description{
Record animation frames and insert them into a LaTeX document with the
\code{animate} package. Compile the document if an appropriate LaTeX command
is provided.
}
\details{
This is actually a wrapper to generate a LaTeX document using R. The document
uses the LaTeX package called \code{animate} to insert animations into PDF's.
When we pass an R expression to this function, the expression will be
evaluated and recorded by a grahpics device (typically \code{\link{png}} and
\code{\link{pdf}}). At last, a LaTeX document will be created and compiled if
an appropriate LaTeX command is provided. And the final PDF output will be
opened with the PDF viewer set in \code{getOption('pdfviewer')} if
\code{ani.options('autobrowse') == TRUE}.
}
\note{
This function will detect if it was called in a Sweave environment --
  if so, \code{img.name} will be automatically adjusted to
  \code{prefix.string-label}, and the LaTeX output will not be a complete
  document, but rather a single line like
  \preformatted{\animategraphics[ani.opts]{1/interval}{img.name}{}{}}

  This automatic feature can be useful to Sweave users (but remember to set
  the Sweave option \code{results=tex}). See \code{demo('Sweave_animation')}
  for a complete example.

  PDF devices are recommended because of their high quality and usually they
  are more friendly to LaTeX, but the size of PDF files is often much larger;
  in this case, we may set the option \code{'qpdf'} or \code{'pdftk'} to
  compress the PDF graphics output. To set the PDF device, use
  \code{ani.options(ani.dev = 'pdf', ani.type = 'pdf')}

  So far animations created by the LaTeX package \pkg{animate} can only be
  viewed with Acrobat Reader (Windows) or \command{acroread} (Linux).  Other
  PDF viewers may not support JavaScript (in fact the PDF animation is driven
  by JavaScript). Linux users may need to install \command{acroread} and set
  \code{options(pdfviewer = 'acroread')}.
}
\references{
To know more about the \code{animate} package, please refer to
  \url{http://www.ctan.org/tex-archive/macros/latex/contrib/animate/}. There
  are a lot of options can be set in \code{ani.opts} and \code{pkg.opts}.
}
\seealso{
Other utilities: \code{\link{im.convert}},
  \code{\link{saveGIF}}, \code{\link{saveHTML}},
  \code{\link{saveSWF}}, \code{\link{saveVideo}}
}
\author{
Yihui Xie
}
