% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sNN.R
\name{sNN}
\alias{sNN}
\alias{snn}
\alias{sort.sNN}
\alias{print.sNN}
\title{Find Shared Nearest Neighbors}
\usage{
sNN(
  x,
  k,
  kt = NULL,
  jp = FALSE,
  sort = TRUE,
  search = "kdtree",
  bucketSize = 10,
  splitRule = "suggest",
  approx = 0
)

\method{sort}{sNN}(x, decreasing = TRUE, ...)

\method{print}{sNN}(x, ...)
}
\arguments{
\item{x}{a data matrix, a \link{dist} object or a \link{kNN} object.}

\item{k}{number of neighbors to consider to calculate the shared nearest
neighbors.}

\item{kt}{minimum threshold on the number of shared nearest neighbors to
build the shared nearest neighbor graph. Edges are only preserved if
\code{kt} or more neighbors are shared.}

\item{jp}{In regular sNN graphs, two points that are not neighbors
can have shared neighbors.
Javis and Patrick (1973) requires the two points to be neighbors, otherwise
the count is zeroed out. \code{TRUE} uses this behavior.}

\item{sort}{sort by the number of shared nearest neighbors? Note that this
is expensive and \code{sort = FALSE} is much faster. sNN objects can be
sorted using \code{sort()}.}

\item{search}{nearest neighbor search strategy (one of \code{"kdtree"}, \code{"linear"} or
\code{"dist"}).}

\item{bucketSize}{max size of the kd-tree leafs.}

\item{splitRule}{rule to split the kd-tree. One of \code{"STD"}, \code{"MIDPT"}, \code{"FAIR"},
\code{"SL_MIDPT"}, \code{"SL_FAIR"} or \code{"SUGGEST"} (SL stands for sliding). \code{"SUGGEST"} uses
ANNs best guess.}

\item{approx}{use approximate nearest neighbors. All NN up to a distance of
a factor of \verb{(1 + approx) eps} may be used. Some actual NN may be omitted
leading to spurious clusters and noise points.  However, the algorithm will
enjoy a significant speedup.}

\item{decreasing}{logical; sort in decreasing order?}

\item{...}{additional parameters are passed on.}
}
\value{
An object of class \code{sNN} (subclass of \link{kNN} and \link{NN}) containing a list
with the following components:
\item{id }{a matrix with ids. }
\item{dist}{a matrix with the distances. }
\item{shared }{a matrix with the number of shared nearest neighbors. }
\item{k }{number of \code{k} used. }
\item{metric }{the used distance metric. }
}
\description{
Calculates the number of shared nearest neighbors
and creates a shared nearest neighbors graph.
}
\details{
The number of shared nearest neighbors of two points p and q is the
intersection of the kNN neighborhood of two points.
Note: that each point is considered to be part
of its own kNN neighborhood.
The range for the shared nearest neighbors is
\eqn{[0, k]}. The result is a n-by-k matrix called \code{shared}.
Each row is a point and the columns are the point's k nearest neighbors.
The value is the count of the shared neighbors.

The shared nearest neighbor graph connects a point with all its nearest neighbors
if they have at least one shared neighbor. The number of shared neighbors can be used
as an edge weight.
Javis and Patrick (1973) use a slightly
modified (see parameter \code{jp}) shared nearest neighbor graph for
clustering.
}
\examples{
data(iris)
x <- iris[, -5]

# finding kNN and add the number of shared nearest neighbors.
k <- 5
nn <- sNN(x, k = k)
nn

# shared nearest neighbor distribution
table(as.vector(nn$shared))

# explore number of shared points for the k-neighborhood of point 10
i <- 10
nn$shared[i,]

plot(nn, x)

# apply a threshold to create a sNN graph with edges
# if more than 3 neighbors are shared.
nn_3 <- sNN(nn, kt = 3)
plot(nn_3, x)

# get an adjacency list for the shared nearest neighbor graph
adjacencylist(nn_3)
}
\references{
R. A. Jarvis and E. A. Patrick. 1973. Clustering Using a
Similarity Measure Based on Shared Near Neighbors. \emph{IEEE Trans. Comput.}
22, 11 (November 1973), 1025-1034.
\doi{10.1109/T-C.1973.223640}
}
\seealso{
Other NN functions: 
\code{\link{NN}},
\code{\link{comps}()},
\code{\link{frNN}()},
\code{\link{kNN}()},
\code{\link{kNNdist}()}
}
\author{
Michael Hahsler
}
\concept{NN functions}
\keyword{model}
