% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_graph_directed.R
\name{set_graph_directed}
\alias{set_graph_directed}
\title{Convert an undirected graph to a directed graph}
\usage{
set_graph_directed(graph)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Take a graph which is undirected and convert it to a directed graph.
}
\examples{
# Create a graph with a
# undirected tree
graph <-
  create_graph(
    directed = FALSE) \%>\%
  add_balanced_tree(
    k = 2, h = 2)

# Convert this graph from
# undirected to directed
graph <-
  graph \%>\%
  set_graph_directed()

# Perform a check on whether
# graph is directed
graph \%>\% is_graph_directed()

}
