% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.eco.R
\name{print.summary.eco}
\alias{print.summary.eco}
\title{Print the Summary of the Results for the Bayesian Parametric Model for Ecological
Inference in 2x2 Tables}
\usage{
\method{print}{summary.eco}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{An object of class \code{summary.eco}.}

\item{digits}{the number of significant digits to use when printing.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\code{summary.eco} yields an object of class \code{summary.eco}
containing the following elements: 
\item{call}{The call from \code{eco}.}
\item{n.obs}{The number of units.} 
\item{n.draws}{The number of Monte Carlo samples.} 
\item{agg.table}{Aggregate posterior estimates of the marginal
means of \eqn{W_1} and \eqn{W_2} using \eqn{X} and \eqn{N} as weights.} If
\code{param = TRUE}, the following elements are also included:
\item{param.table}{Posterior estimates of model parameters: population mean
estimates of \eqn{W_1} and \eqn{W_2} and their logit transformations.} If
\code{units = TRUE}, the following elements are also included:
\item{W1.table}{Unit-level posterior estimates for \eqn{W_1}.}
\item{W2.table}{Unit-level posterior estimates for \eqn{W_2}.}

This object can be printed by \code{print.summary.eco}
}
\description{
\code{summary} method for class \code{eco}.
}
\seealso{
\code{eco}, \code{predict.eco}
}
\author{
Kosuke Imai, Department of Politics, Princeton University,
\email{kimai@Princeton.Edu}, \url{http://imai.princeton.edu}; Ying Lu,
Center for Promoting Research Involving Innovative Statistical Methodology
(PRIISM), New York University \email{ying.lu@nyu.Edu}
}
\keyword{methods}
