% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credentials_service_account.R
\name{credentials_service_account}
\alias{credentials_service_account}
\title{Load a service account token}
\usage{
credentials_service_account(scopes = NULL, path = "", ..., subject = NULL)
}
\arguments{
\item{scopes}{A character vector of scopes to request. Pick from those listed
at \url{https://developers.google.com/identity/protocols/oauth2/scopes}.

For certain token flows, the
\code{"https://www.googleapis.com/auth/userinfo.email"} scope is unconditionally
included. This grants permission to retrieve the email address associated
with a token; gargle uses this to index cached OAuth tokens. This grants no
permission to view or send email and is generally considered a low-value
scope.}

\item{path}{JSON identifying the service account, in one of the forms
supported for the \code{txt} argument of \code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} (typically, a
file path or JSON string).}

\item{...}{Additional arguments passed to all credential functions.}

\item{subject}{An optional subject claim. Specify this if you wish to use the
service account represented by \code{path} to impersonate the \code{subject}, who is
a normal user. Before this can work, an administrator must grant the service
account domain-wide authority. Identify the user to impersonate via their
email, e.g. \code{subject = "user@example.com"}. Note that gargle automatically
adds the non-sensitive \code{"https://www.googleapis.com/auth/userinfo.email"}
scope, so this scope must be enabled for the service account, along with
any other \code{scopes} being requested.}
}
\value{
An \code{\link[httr:Token-class]{httr::TokenServiceAccount}} or \code{NULL}.
}
\description{
Load a service account token
}
\details{
Note that fetching a token for a service account requires a
reasonably accurate system clock. For more information, see the
\code{vignette("how-gargle-gets-tokens")}.
}
\examples{
\dontrun{
token <- credentials_service_account(
  scopes = "https://www.googleapis.com/auth/userinfo.email",
  path = "/path/to/your/service-account.json"
)
}
}
\seealso{
Additional reading on delegation of domain-wide authority:
\itemize{
\item \url{https://developers.google.com/identity/protocols/oauth2/service-account#delegatingauthority}
}

Other credential functions: 
\code{\link{credentials_app_default}()},
\code{\link{credentials_byo_oauth2}()},
\code{\link{credentials_external_account}()},
\code{\link{credentials_gce}()},
\code{\link{credentials_user_oauth2}()},
\code{\link{token_fetch}()}
}
\concept{credential functions}
