% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/url.R
\name{url_parse}
\alias{url_parse}
\alias{url_build}
\title{Parse and build URLs}
\usage{
url_parse(url)

url_build(url)
}
\arguments{
\item{url}{For \code{url_parse()} a string to parse into a URL;
for \code{url_build()} a URL to turn back into a string.}
}
\value{
\itemize{
\item \code{url_build()} returns a string.
\item \code{url_parse()} returns a URL: a S3 list with class \code{httr2_url}
and elements \code{scheme}, \code{hostname}, \code{port}, \code{path}, \code{fragment}, \code{query},
\code{username}, \code{password}.
}
}
\description{
\code{url_parse()} parses a URL into its component pieces; \code{url_build()} does
the reverse, converting a list of pieces into a string URL. See \href{https://datatracker.ietf.org/doc/html/rfc3986}{RFC 3986}
for the details of the parsing algorithm.
}
\examples{
url_parse("http://google.com/")
url_parse("http://google.com:80/")
url_parse("http://google.com:80/?a=1&b=2")
url_parse("http://username@google.com:80/path;test?a=1&b=2#40")

url <- url_parse("http://google.com/")
url$port <- 80
url$hostname <- "example.com"
url$query <- list(a = 1, b = 2, c = 3)
url_build(url)
}
