% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{make_}
\alias{make_}
\title{Make a new graph}
\usage{
make_(...)
}
\arguments{
\item{...}{Parameters, see details below.}
}
\description{
This is is generic function for creating graphs.
}
\details{
\code{make_} is a generic function for creating graphs.
For every graph constructor in igraph that has a \code{make_} prefix,
there is a corresponding function without the prefix: e.g.
for \code{\link{make_ring}} there is also \code{\link{ring}}, etc.

The same is true for the random graph samplers, i.e. for each
constructor with a \code{sample_} prefix, there is a corresponding
function without that prefix.

These shorter forms can be used together with \code{make_}.
The advantage of this form is that the user can specify constructor
modifiers which work with all constructors. E.g. the
\code{\link{with_vertex_}} modifier adds vertex attributes
to the newly created graphs.

See the examples and the various constructor modifiers below.
}
\examples{
r <- make_(ring(10))
l <- make_(lattice(c(3, 3, 3)))

r2 <- make_(ring(10), with_vertex_(color = "red", name = LETTERS[1:10]))
l2 <- make_(lattice(c(3, 3, 3)), with_edge_(weight = 2))

ran <- sample_(degseq(c(3,3,3,3,3,3), method = "simple"), simplified())
degree(ran)
is_simple(ran)
}
\seealso{
simplified with_edge_ with_graph_ with_vertex_
  without_loops without_multiples
}
