% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sCorrect-residuals2.R
\name{residuals2}
\alias{residuals2}
\alias{residuals2.lvmfit}
\title{Residuals With Small Sample Correction.}
\usage{
residuals2(object, type, format, ssc, ...)

\method{residuals2}{lvmfit}(
  object,
  type = "response",
  format = "wide",
  ssc = lava.options()$ssc,
  ...
)
}
\arguments{
\item{object}{a \code{lvmfit} or \code{lvmfit2} object (i.e. output of \code{lava::estimate} or \code{lavaSearch2::estimate2}).}

\item{type}{[character] the type of residual to extract:
\code{"response"} for raw residuals,
\code{"studentized"} for studentized residuals,
\code{"normalized"} for normalized residuals.}

\item{format}{[character] Use \code{"wide"} to return the residuals in the wide format (one row relative to each sample).
Otherwise use \code{"long"} to return the residuals in the long format.}

\item{ssc}{[character] method used to correct the small sample bias of the variance coefficients: no correction (\code{"none"}/\code{FALSE}/\code{NA}),
correct the first order bias in the residual variance (\code{"residual"}), or correct the first order bias in the estimated coefficients \code{"cox"}).
Only relevant when using a \code{lvmfit} object.}

\item{...}{additional argument passed to \code{estimate2} when using a \code{lvmfit} object.}
}
\value{
a matrix containing the residuals relative to each sample (in rows)
and each endogenous variable (in column).
}
\description{
Extract residuals from a latent variable model.
Similar to \code{stats::residuals} but with small sample correction.
}
\details{
When argument object is a \code{lvmfit} object, the method first calls \code{estimate2} and then extract the residuals.

The raw residuals are defined by  observation minus the fitted value:
\deqn{
\varepsilon = (Y_1 - \mu_1, ..., Y_m - \mu_m)
}
The studentized residuals divided the raw residuals relative to each endogenous variable by the modeled variance of the endogenous variable.
\deqn{
\varepsilon_{stud} =(\frac{Y_1 - \mu_1}{\sigma_1}, ..., \frac{Y_m - \mu_m}{\sigma_m})
}
The normalized residuals multiply the raw residuals by the inverse of the square root of the modeled residual variance covariance matrix.
\deqn{
\varepsilon_{norm} = \varepsilon \Omega^{-1/2}
}
}
\examples{
#### simulate data ####
set.seed(10)
n <- 101

Y1 <- rnorm(n, mean = 0)
Y2 <- rnorm(n, mean = 0.3)
Id <- findInterval(runif(n), seq(0.1,1,0.1))
data.df <- rbind(data.frame(Y=Y1,G="1",Id = Id),
           data.frame(Y=Y2,G="2",Id = Id)
           )

#### latent variable models ####
library(lava)
e.lvm <- estimate(lvm(Y ~ G), data = data.df)
residuals(e.lvm)
residuals2(e.lvm)
residuals(e.lvm) - residuals2(e.lvm)

}
\seealso{
\code{\link{estimate2}} to obtain \code{lvmfit2} objects.
}
\concept{extractor}
\keyword{smallSampleCorrection}
