% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputs.R
\name{mwSelectize}
\alias{mwSelectize}
\title{Add a Select list input to a manipulateWidget gadget}
\usage{
mwSelectize(
  choices = value,
  value = NULL,
  label = NULL,
  ...,
  multiple = FALSE,
  options = NULL,
  .display = TRUE
)
}
\arguments{
\item{choices}{Vector or list of choices. If it is named, then the names rather than the
values are displayed to the user.}

\item{value}{Initial value of the input. If not specified, the first choice is used.}

\item{label}{Display label for the control. If \code{NULL}, the name of the corresponding
variable is used.}

\item{...}{Other arguments passed to function\code{\link[shiny]{selectInput}}.}

\item{multiple}{Is selection of multiple items allowed?}

\item{options}{A list of options. See the documentation of selectize.js for possible options}

\item{.display}{expression that evaluates to TRUE or FALSE, indicating when
the input control should be shown/hidden.}
}
\value{
A function that will generate the input control.
}
\description{
Add a Select list input to a manipulateWidget gadget
}
\examples{
if (require(plotly)) {
  mydata <- data.frame(x = 1:100, y = rnorm(100))

  # Select multiple values
  manipulateWidget(
    {
      if (length(species) == 0) mydata <- iris
      else mydata <- iris[iris$Species \%in\% species,]

      plot_ly(mydata, x = ~Sepal.Length, y = ~Sepal.Width,
              color = ~droplevels(Species), type = "scatter", mode = "markers")
    },
    species = mwSelectize(c("Select one or two species : " = "", levels(iris$Species)),
        multiple = TRUE, options = list(maxItems = 2))
  )
}

}
\seealso{
Other controls: 
\code{\link{mwCheckboxGroup}()},
\code{\link{mwCheckbox}()},
\code{\link{mwDateRange}()},
\code{\link{mwDate}()},
\code{\link{mwGroup}()},
\code{\link{mwNumeric}()},
\code{\link{mwPassword}()},
\code{\link{mwRadio}()},
\code{\link{mwSelect}()},
\code{\link{mwSharedValue}()},
\code{\link{mwSlider}()},
\code{\link{mwText}()}
}
\concept{controls}
