% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputs.R
\name{mwRadio}
\alias{mwRadio}
\title{Add radio buttons to a manipulateWidget gadget}
\usage{
mwRadio(choices, value = NULL, label = NULL, ..., .display = TRUE)
}
\arguments{
\item{choices}{Vector or list of choices. If it is named, then the names rather than the
values are displayed to the user.}

\item{value}{Initial value of the input. If not specified, the first choice is used.}

\item{label}{Display label for the control. If \code{NULL}, the name of the corresponding
variable is used.}

\item{...}{Other arguments passed to function\code{\link[shiny]{radioButtons}}}

\item{.display}{expression that evaluates to TRUE or FALSE, indicating when
the input control should be shown/hidden.}
}
\value{
A function that will generate the input control.
}
\description{
Add radio buttons to a manipulateWidget gadget
}
\examples{
if (require(plotly)) {
  mydata <- data.frame(x = 1:100, y = rnorm(100))

  manipulateWidget(
    {
      mode <- switch(type, points = "markers", lines = "lines", both = "markers+lines")
      plot_ly(mydata, x=~x, y=~y, type = "scatter", mode = mode)
    },
    type = mwRadio(c("points", "lines", "both"))
  )
}

}
\seealso{
Other controls: \code{\link{mwCheckboxGroup}},
  \code{\link{mwCheckbox}}, \code{\link{mwDateRange}},
  \code{\link{mwDate}}, \code{\link{mwGroup}},
  \code{\link{mwNumeric}}, \code{\link{mwPassword}},
  \code{\link{mwSelectize}}, \code{\link{mwSelect}},
  \code{\link{mwSharedValue}}, \code{\link{mwSlider}},
  \code{\link{mwText}}
}
