% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowRanges.R
\name{rowRanges}
\alias{rowRanges}
\alias{rowMins}
\alias{rowMaxs}
\alias{colRanges}
\alias{colMins}
\alias{colMaxs}
\title{Gets the range of values in each row (column) of a matrix}
\usage{
rowRanges(x, rows = NULL, cols = NULL, na.rm = FALSE, dim. = dim(x),
  ..., useNames = TRUE)

rowMins(x, rows = NULL, cols = NULL, na.rm = FALSE, dim. = dim(x), ...,
  useNames = TRUE)

rowMaxs(x, rows = NULL, cols = NULL, na.rm = FALSE, dim. = dim(x), ...,
  useNames = TRUE)

colRanges(x, rows = NULL, cols = NULL, na.rm = FALSE, dim. = dim(x),
  ..., useNames = TRUE)

colMins(x, rows = NULL, cols = NULL, na.rm = FALSE, dim. = dim(x), ...,
  useNames = TRUE)

colMaxs(x, rows = NULL, cols = NULL, na.rm = FALSE, dim. = dim(x), ...,
  useNames = TRUE)
}
\arguments{
\item{x}{An NxK \code{\link[base]{matrix}} or, if \code{dim.} is specified,
an N * K \code{\link[base]{vector}}.}

\item{rows}{A \code{\link[base]{vector}} indicating subset of rows to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}

\item{cols}{A \code{\link[base]{vector}} indicating subset of columns to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, missing values are
excluded.}

\item{dim.}{An \code{\link[base]{integer}} \code{\link[base]{vector}} of
length two specifying the dimension of \code{x}, also when not a
\code{\link[base]{matrix}}.  \emph{Comment:} The reason for this argument
being named with a period at the end is purely technical (we get a run-time
error if we try to name it \code{dim}).}

\item{...}{Not used.}

\item{useNames}{If \code{\link[base:logical]{TRUE}} (default), names
attributes of the result are set, otherwise not.}
}
\value{
\code{rowRanges()} (\code{colRanges()}) returns a
\code{\link[base]{numeric}} Nx2 (Kx2) \code{\link[base]{matrix}}, where N
(K) is the number of rows (columns) for which the ranges are calculated.

\code{rowMins()/rowMaxs()} (\code{colMins()/colMaxs()}) returns a
\code{\link[base]{numeric}} \code{\link[base]{vector}} of length N (K).
}
\description{
Gets the range of values in each row (column) of a matrix.
}
\seealso{
\code{\link{rowOrderStats}}() and \code{\link[base]{pmin.int}}().
}
\author{
Henrik Bengtsson
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
