% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mictools.R
\name{mictools}
\alias{mictools}
\title{Function that implements the \code{mictools} pipeline.
In particular it computes the null and observed distribution of the \code{tic_e} measure}
\usage{
mictools(x, alpha = 9, C = 5, seed = 0, nperm = 2e+05,
  p.adjust.method = "BH")
}
\arguments{
\item{x}{a numeric matrix with N samples on the rows and M variables on the columns (NxM).}

\item{alpha}{float (0, 1.0] or >=4 if alpha is in (0,1] then B will be max(n^alpha, 4) where n is the
number of samples. If alpha is >=4 then alpha defines directly the B
parameter. If alpha is higher than the number of samples (n) it will be
limited to be n, so B = min(alpha, n) Default value is 0.6 (see Details).}

\item{C}{a positive integer number, the \code{C} parameter of the \code{mine} statistic. 
See \code{\link[minerva]{mine}} function for further details.}

\item{seed}{seed for random number generation reproducibility}

\item{nperm}{integer, number of permutation to perform}

\item{p.adjust.method}{method for pvalue adjustment, see \code{\link[stats]{p.adjust}} for available methods.}
}
\value{
A list of 5 named elements containing the following information of the computed statistic:
\describe{
\item{tic}{This is a vector with the null distribution of tic_e values based on the permutation.}
\item{nulldist}{Null distribution of the \code{tic_e} measure. It is a \code{data.frame} of 4 columns
 containing the histogram of the distribution of \code{tic_e} for each bin delimited by \code{BinStart} 
 and \code{BinEnd}, the count for each bin \code{NullCount} and the cumulative distribution 
 of the right tail area \code{NullCumSum}}
\item{obstic}{\code{data.frame} with the observed \code{tic_e} values, the indexes of the variables between the tic is computed. 
If the input matrix has column names then the names are reported in the dataframe, otherwise "Var<i>" is added for each variable.}
\item{obsdists}{\code{data.frame} similar to \code{nulldist} but with observed values of \code{tic_e}}
\item{pval}{data.frame with the pvalue computed for each comparison. The adjusted pvalue is also reported based 
on the method chosen with the parameter \code{p.adjust.method}}
}
}
\description{
Function that implements the \code{mictools} pipeline.
In particular it computes the null and observed distribution of the \code{tic_e} measure
}
\details{
This is a function to implement the `mictools` pipeline.
Differently from the python pipeline available on github we consider a data matrix of NxM with N samples by rows 
and M variables by columns as standard for R.
}
\examples{
data(Spellman)
Spellman <- as.matrix(Spellman)
spellress <- mictools(Spellman[, 10:20], nperm=1000)

## Use a different pvalue correction method
spellressb <- mictools(Spellman[,10:20], nperm=1000, seed=1234, p.adjust.method="bonferroni")

## Distribution of tic_e null
hist(spellress$tic, breaks=100, main="Tic_e null distribution")
barplot(spellress$nulldist$NullCount)

## Distribution of the observed tic
hist(spellress$obstic$TIC)
barplot(spellress$obsdist$Count)

## Distribution of empirical pvalues
hist(spellress$pval$pval, breaks=50)

}
\references{
D. Albanese, S. Riccadonna, C. Donati, P. Franceschi (2018)
_A practical tool for Maximal Information Coefficient Analysis_
GigaScience, 7, 4, \url{https://doi.org/10.1093/gigascience/giy032}
}
\seealso{
\code{\link[stats]{p.adjust}}, \code{\link[graphics]{hist}}, \code{\link[minerva]{mine}}
}
