% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ancestral.R
\name{ancestral.pml}
\alias{ancestral.pml}
\alias{anc_pml}
\alias{as.phyDat.ancestral}
\alias{as.data.frame.ancestral}
\alias{ancestral.pars}
\alias{anc_pars}
\alias{pace}
\title{Ancestral character reconstruction.}
\usage{
ancestral.pml(object, type = "marginal", return = "prob", ...)

anc_pml(object, type = "marginal", ...)

\method{as.phyDat}{ancestral}(x, ...)

\method{as.data.frame}{ancestral}(x, ...)

ancestral.pars(tree, data, type = c("MPR", "ACCTRAN", "POSTORDER"),
  cost = NULL, return = "prob", ...)

anc_pars(tree, data, type = c("MPR", "ACCTRAN", "POSTORDER"), cost = NULL,
  ...)

pace(tree, data, type = c("MPR", "ACCTRAN", "POSTORDER"), cost = NULL,
  return = "prob", ...)
}
\arguments{
\item{object}{an object of class pml}

\item{type}{method used to assign characters to internal nodes, see details.}

\item{return}{return a \code{phyDat} object or matrix of probabilities.}

\item{\dots}{Further arguments passed to or from other methods.}

\item{x}{an object of class ancestral}

\item{tree}{a tree, i.e. an object of class pml}

\item{data}{an object of class phyDat}

\item{cost}{A cost matrix for the transitions between two states.}
}
\value{
An object of class ancestral. This is a list containing the tree with
node labels, the original alignment as an \code{phyDat} object, a
\code{data.frame} containing the probabilities belonging to a state for all
(internal nodes) and the most likely state.
}
\description{
Marginal reconstruction of the ancestral character states.
}
\details{
The argument "type" defines the criterion to assign the internal nodes. For
\code{ancestral.pml} so far "ml and marginal (empirical) "bayes" and for
\code{ancestral.pars} "MPR" and "ACCTRAN" are possible.

The function return a list containing the tree with node labels, the original
alignment as an \code{phyDat} object, a data.frame containing the
probabilities belonging to a state for all (internal nodes) and the most
likely state. For parsimony and nucleotide data the most likely state might
be ambiguous. For ML this is very unlikely to be the case.

If the input tree does not contain unique node labels the function
\code{ape::MakeNodeLabel} is used to create them.

With parsimony reconstruction one has to keep in mind that there will be
often no unique solution.

The functions use the node labels of the provided tree (also if part of the
\code{pml} object) if these are unique. Otherwise the function
\code{ape::MakeNodeLabel} is used to create them.

For further details see vignette("Ancestral").
}
\examples{

example(NJ)
# generate node labels to ensure plotting will work
tree <- makeNodeLabel(tree)
fit <- pml(tree, Laurasiatherian)
anc.ml <- anc_pml(fit)
anc.p <- anc_pars(tree, Laurasiatherian)
# plot ancestral sequences at the root
plotSeqLogo( anc.ml, 48, 1, 20)
plotSeqLogo( anc.p, 48, 1, 20)
# plot the first character
plotAnc(anc.ml)
# plot the third character
plotAnc(anc.ml, 3)

}
\references{
Felsenstein, J. (2004). \emph{Inferring Phylogenies}. Sinauer
Associates, Sunderland.

Swofford, D.L., Maddison, W.P. (1987) Reconstructing ancestral character
states under Wagner parsimony. \emph{Math. Biosci.} \bold{87}: 199--229

Yang, Z. (2006). \emph{Computational Molecular evolution}. Oxford University
Press, Oxford.
}
\seealso{
\code{\link{pml}}, \code{\link{parsimony}}, \code{\link[ape]{ace}},
\code{\link{plotAnc}}, \code{\link{latag2n.phyDat}}, \code{\link[ape]{latag2n}},
\code{\link{gap_as_state}}, \code{\link[ape]{root}},
\code{\link[ape]{makeNodeLabel}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
