% Generated by roxygen2 (4.0.2): do not edit by hand
\name{polyCub.SV}
\alias{polyCub.SV}
\title{Product Gauss Cubature over Polygonal Domains}
\usage{
polyCub.SV(polyregion, f, ..., nGQ = 20, alpha = NULL, rotation = FALSE,
  engine = "C", plot = FALSE)
}
\arguments{
\item{polyregion}{a polygonal domain.
The following classes are supported: \code{"\link[spatstat]{owin}"},
\code{"\link[rgeos:gpc.poly-class]{gpc.poly}"},
\code{"\linkS4class{SpatialPolygons}"}, \code{"\linkS4class{Polygons}"},
and \code{"\linkS4class{Polygon}"}
(for these we have an internal \code{\link{xylist}} method).}

\item{f}{a two-dimensional real function (or \code{NULL} to only compute
nodes and weights).
As its first argument it must take a coordinate matrix, i.e., a
numeric matrix with two columns, and it must return a numeric vector of
length the number of coordinates.}

\item{...}{further arguments for \code{f}.}

\item{nGQ}{degree of the one-dimensional Gauss-Legendre quadrature rule
(default: 20) as implemented in function \code{\link[statmod]{gauss.quad}}
of package \pkg{statmod}. Nodes and weights up to \code{nGQ=60} are cached
in \pkg{polyCub}, for larger degrees \pkg{statmod} is required.}

\item{alpha}{base-line of the (rotated) polygon at \eqn{x = \alpha} (see
Sommariva and Vianello (2007) for an explication). If \code{NULL} (default),
the midpoint of the x-range of each polygon is chosen if no \code{rotation}
is performed, and otherwise the \eqn{x}-coordinate of the rotated point
\code{"P"} (see \code{rotation}). If \code{f} has its maximum value at the
origin \eqn{(0,0)}, e.g., the bivariate Gaussian density with zero mean,
\code{alpha = 0} is a reasonable choice.}

\item{rotation}{logical (default: \code{FALSE}) or a list of points
\code{"P"} and \code{"Q"} describing the preferred direction. If
\code{TRUE}, the polygon is rotated according to the vertices \code{"P"} and
\code{"Q"}, which are farthest apart (see Sommariva and Vianello, 2007). For
convex polygons, this rotation guarantees that all nodes fall inside the
polygon.}

\item{engine}{character string specifying the implementation to use.
Up to \pkg{polyCub} version 0.4-3, the two-dimensional nodes and weights
were computed by \R functions and these are still available by setting
\code{engine = "R"}.
The new C-implementation is now the default (\code{engine = "C"}) and
requires approximately 30\% less computation time.\cr
The special setting \code{engine = "C+reduce"} will discard redundant nodes
at (0,0) with zero weight resulting from edges on the base-line
\eqn{x = \alpha} or orthogonal to it.
This extra cleaning is only worth its cost for computationally intensive
functions \code{f} over polygons which really have some edges on the
baseline or parallel to the x-axis.  Note that the old \R
implementation does not have such unset zero nodes and weights.}

\item{plot}{logical indicating if an illustrative plot of the numerical
integration should be produced.}
}
\value{
The approximated value of the integral of \code{f} over
\code{polyregion}.\cr
In the case \code{f = NULL}, only the computed nodes and weights are
returned in a list of length the number of polygons of \code{polyregion},
where each component is a list with \code{nodes} (a numeric matrix with
two columns), \code{weights} (a numeric vector of length
\code{nrow(nodes)}), the rotation \code{angle}, and \code{alpha}.
}
\description{
Product Gauss cubature over polygons as proposed by
Sommariva and Vianello (2007).
}
\examples{
# see example(polyCub)
}
\author{
Sebastian Meyer\cr
The product Gauss cubature is based on the
original \acronym{MATLAB} implementation \code{polygauss} by Sommariva and
Vianello (2007), which is available under the GNU GPL (>=2) license from
\url{http://www.math.unipd.it/~alvise/software.html}.
}
\references{
Sommariva, A. and Vianello, M. (2007).
Product Gauss cubature over polygons based on Green's integration formula.
\emph{Bit Numerical Mathematics}, \bold{47} (2), 441-453.
}
\seealso{
Other polyCub.methods: \code{\link{.polyCub.iso}},
  \code{\link{polyCub.iso}};
  \code{\link{polyCub.exact.Gauss}};
  \code{\link{polyCub.midpoint}}; \code{\link{polyCub}}
}
\keyword{math}
\keyword{spatial}

