% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_draws.R
\name{print.draws_summary}
\alias{print.draws_summary}
\title{Print summaries of \code{draws} objects}
\usage{
\method{print}{draws_summary}(x, ..., num_args = NULL)
}
\arguments{
\item{x}{(draws_summary) A \code{"draws_summary"} object as output by \code{\link[=summarise_draws]{summarise_draws()}}.}

\item{...}{Additional arguments passed to \code{\link[tibble:formatting]{tibble::print.tbl_df()}}}

\item{num_args}{(named list) Optional arguments passed to
\link[tibble:num]{num()} for pretty printing of summaries. If \code{NULL}
(the default), uses the arguments stored in the \code{"num_args"} attribute of
\code{x}, as set by the \code{.num_args} argument of \code{\link[=summarise_draws]{summarise_draws()}}, which
itself can be controlled globally via the \code{posterior.num_args}
\link[base:options]{option}.}
}
\value{
An invisible version of the input object.
}
\description{
Print output from \code{\link[=summarise_draws]{summarise_draws()}}.
}
\examples{
x <- example_draws("eight_schools")

# adjust how summaries are printed when calling summarise_draws()...
summarise_draws(x, .num_args = list(sigfig = 2, notation = "dec"))

# ... or when printing
s <- summarise_draws(x)
print(s, num_args = list(sigfig = 2, notation = "dec"))
print(s, num_args = list(digits = 3))
}
