% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window.R
\name{step_window}
\alias{step_window}
\title{Moving window functions}
\usage{
step_window(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  size = 3,
  na_rm = TRUE,
  statistic = "mean",
  columns = NULL,
  names = NULL,
  keep_original_cols = TRUE,
  skip = FALSE,
  id = rand_id("window")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{For model terms created by this step, what analysis
role should they be assigned? If \code{names} is left to be
\code{NULL}, the rolling statistics replace the original columns
and the roles are left unchanged. If \code{names} is set, those
new columns will have a role of \code{NULL} unless this argument
has a value.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{size}{An odd integer \verb{>= 3} for the window size.}

\item{na_rm}{A logical for whether missing values should be
removed from the calculations within each window.}

\item{statistic}{A character string for the type of statistic
that should be calculated for each moving window. Possible
values are: \code{'max'}, \code{'mean'}, \code{'median'},
\code{'min'}, \code{'prod'}, \code{'sd'}, \code{'sum'},
\code{'var'}}

\item{columns}{A character string of the selected variable names. This field
is a placeholder and will be populated once \code{\link[=prep]{prep()}} is used.}

\item{names}{An optional character string that is the same
length of the number of terms selected by \code{terms}. If you
are not sure what columns will be selected, use the
\code{summary} function (see the example below). These will be
the names of the new columns created by the step.}

\item{keep_original_cols}{A logical to keep the original variables in the
output. Defaults to \code{TRUE}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_window()} creates a \emph{specification} of a recipe step that will create
new columns that are the results of functions that compute statistics across
moving windows.
}
\details{
The calculations use a somewhat atypical method for
handling the beginning and end parts of the rolling statistics.
The process starts with the center justified window calculations
and the beginning and ending parts of the rolling values are
determined using the first and last rolling values,
respectively. For example, if a column \code{x} with 12 values is
smoothed with a 5-point moving median, the first three smoothed
values are estimated by \code{median(x[1:5])} and the fourth
uses \code{median(x[2:6])}.

\code{keep_original_cols} also applies to this step if \code{names} is specified.

step will stop with a note about installing the package.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms}, \code{statistic}, \code{size} , and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{statistic}{character, the summary function name}
\item{size}{integer, window size}
\item{id}{character, id of this step}
}
}

\section{Tuning Parameters}{
This step has 2 tuning parameters:
\itemize{
\item \code{statistic}: Rolling Summary Statistic (type: character, default: mean)
\item \code{size}: Window Size (type: integer, default: 3)
}
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed(c("RcppML", "ggplot2"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(recipes)
library(dplyr)
library(rlang)
library(ggplot2, quietly = TRUE)

set.seed(5522)
sim_dat <- data.frame(x1 = (20:100) / 10)
n <- nrow(sim_dat)
sim_dat$y1 <- sin(sim_dat$x1) + rnorm(n, sd = 0.1)
sim_dat$y2 <- cos(sim_dat$x1) + rnorm(n, sd = 0.1)
sim_dat$x2 <- runif(n)
sim_dat$x3 <- rnorm(n)

rec <- recipe(y1 + y2 ~ x1 + x2 + x3, data = sim_dat) \%>\%
  step_window(starts_with("y"),
    size = 7, statistic = "median",
    names = paste0("med_7pt_", 1:2),
    role = "outcome"
  ) \%>\%
  step_window(starts_with("y"),
    names = paste0("mean_3pt_", 1:2),
    role = "outcome"
  )
rec <- prep(rec, training = sim_dat)

smoothed_dat <- bake(rec, sim_dat)

ggplot(data = sim_dat, aes(x = x1, y = y1)) +
  geom_point() +
  geom_line(data = smoothed_dat, aes(y = med_7pt_1)) +
  geom_line(data = smoothed_dat, aes(y = mean_3pt_1), col = "red") +
  theme_bw()

tidy(rec, number = 1)
tidy(rec, number = 2)

# If you want to replace the selected variables with the rolling statistic
# don't set `names`
sim_dat$original <- sim_dat$y1
rec <- recipe(y1 + y2 + original ~ x1 + x2 + x3, data = sim_dat) \%>\%
  step_window(starts_with("y"))
rec <- prep(rec, training = sim_dat)
smoothed_dat <- bake(rec, sim_dat)
ggplot(smoothed_dat, aes(x = original, y = y1)) +
  geom_point() +
  theme_bw()
\dontshow{\}) # examplesIf}
}
