% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/years.R
\name{plot_years}
\alias{plot_years}
\title{Plot the years measure}
\usage{
plot_years(
  years,
  xlab = "Time interval",
  ylab = "Years",
  xbreak,
  ybreak,
  xlimits,
  ylimits,
  conf.int = TRUE,
  ymirror = FALSE,
  yminus = FALSE
)
}
\arguments{
\item{years}{the object obtained using function \code{years}.}

\item{xlab}{a title for the x axis.}

\item{ylab}{a title for the y axis.}

\item{xbreak}{the breaks on the x axis (this is supplied to \code{scale_x_continuous}).}

\item{ybreak}{the breaks on the y axis (this is supplied to \code{scale_y_continuous}).}

\item{xlimits}{define the limits on the x axis (this is supplied to \code{scale_x_continuous}).}

\item{ylimits}{define the limits on the y axis (this is supplied to \code{scale_y_continuous}).}

\item{conf.int}{if TRUE, the confidence interval is plotted.}

\item{ymirror}{mirror the y values (w.r.t. the x axis).}

\item{yminus}{use function y -> -y when plotting.}
}
\value{
A ggplot object
}
\description{
Plot the years measure obtained from the \code{years} function.
}
\details{
A ggplot2 implementation for plotting the years measure. The type of curve is
dependent upon the measure calculated using the \code{years} function (argument \code{measure}).
}
\seealso{
\code{years}, \code{plot_f}
}
