% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MutationProfiling.R
\name{consensusSequence}
\alias{consensusSequence}
\title{Construct a consensus sequence}
\usage{
consensusSequence(
  sequences,
  db = NULL,
  method = c("mostCommon", "thresholdedFreq", "catchAll", "mostMutated", "leastMutated"),
  minFreq = NULL,
  muFreqColumn = NULL,
  lenLimit = NULL,
  includeAmbiguous = FALSE,
  breakTiesStochastic = FALSE,
  breakTiesByColumns = NULL
)
}
\arguments{
\item{sequences}{character vector of sequences.}

\item{db}{\code{data.frame} containing sequence data for a single clone.
Applicable to and required for the \code{"mostMutated"} and
\code{"leastMutated"} methods. Default is \code{NULL}.}

\item{method}{method to calculate consensus sequence. One of
\code{"thresholdedFreq"}, \code{"mostCommon"}, \code{"catchAll"},
\code{"mostMutated"}, or \code{"leastMutated"}. See "Methods" under
\link{collapseClones} for details.}

\item{minFreq}{frequency threshold for calculating input consensus sequence.
Applicable to and required for the \code{"thresholdedFreq"} method.
A canonical choice is 0.6. Default is \code{NULL}.}

\item{muFreqColumn}{\code{character} name of the column in db containing mutation
frequency. Applicable to and required for the \code{"mostMutated"}
and \code{"leastMutated"} methods. Default is \code{NULL}.}

\item{lenLimit}{limit on consensus length. if \code{NULL} then no length limit is set.}

\item{includeAmbiguous}{whether to use ambiguous characters to represent positions at
which there are multiple characters with frequencies that are at least
\code{minimumFrequency} or that are maximal (i.e. ties). Applicable to
and required for the \code{"thresholdedFreq"} and \code{"mostCommon"}
methods. Default is \code{FALSE}. See "Choosing ambiguous characters"
under \link{collapseClones} for rules on choosing ambiguous characters.}

\item{breakTiesStochastic}{In case of ties, whether to randomly pick a sequence from sequences that
fulfill the criteria as consensus. Applicable to and required for all methods
except for \code{"catchAll"}. Default is \code{FALSE}. See "Methods"
under \link{collapseClones} for details.}

\item{breakTiesByColumns}{A list of the form \code{list(c(col_1, col_2, ...), c(fun_1, fun_2, ...))},
where \code{col_i} is a \code{character} name of a column in \code{db},
and \code{fun_i} is a function to be applied on that column. Currently,
only \code{max} and \code{min} are supported. Note that the two \code{c()}'s
in \code{list()} are essential (i.e. if there is only 1 column, the list
should be of the form \code{list(c(col_1), c(func_1))}. Applicable to and
optional for the \code{"mostMutated"} and \code{"leastMutated"} methods.
If supplied, \code{fun_i}'s are applied on \code{col_i}'s to help break
ties. Default is \code{NULL}. See "Methods" under \link{collapseClones}
for details.}
}
\value{
A list containing \code{cons}, which is a character string that is the consensus sequence
         for \code{sequences}; and \code{muFreq}, which is the maximal/minimal mutation frequency of
         the consensus sequence for the \code{"mostMutated"} and \code{"leastMutated"} methods, or
         \code{NULL} for all other methods.
}
\description{
Construct a consensus sequence
}
\details{
See \link{collapseClones} for detailed documentation on methods and additional parameters.
}
\examples{
# Subset example data
data(ExampleDb, package="alakazam")
db <- subset(ExampleDb, ISOTYPE \%in\% c("IgA", "IgG") & SAMPLE == "+7d")
clone <- subset(db, CLONE == "3192")

# First compute mutation frequency for most/leastMutated methods
clone <- observedMutations(clone, frequency=TRUE, combine=TRUE)

# Manually create a tie
clone <- rbind(clone, clone[which.max(clone$MU_FREQ), ])

# ThresholdedFreq method. 
# Resolve ties deterministically without using ambiguous characters
cons1 <- consensusSequence(clone$SEQUENCE_IMGT,
                           method="thresholdedFreq", minFreq=0.3,
                           includeAmbiguous=FALSE, 
                           breakTiesStochastic=FALSE)
cons1$cons
                                        
}
