% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{shinyApp}
\alias{shinyApp}
\alias{shinyAppDir}
\alias{shinyAppFile}
\title{Create a Shiny app object}
\usage{
shinyApp(ui, server, onStart = NULL, options = list(),
  uiPattern = "/", enableBookmarking = NULL)

shinyAppDir(appDir, options = list())

shinyAppFile(appFile, options = list())
}
\arguments{
\item{ui}{The UI definition of the app (for example, a call to
\code{fluidPage()} with nested controls)}

\item{server}{A function with three parameters: \code{input}, \code{output}, and
\code{session}. The function is called once for each session ensuring that each
app is independent.}

\item{onStart}{A function that will be called before the app is actually run.
This is only needed for \code{shinyAppObj}, since in the \code{shinyAppDir}
case, a \code{global.R} file can be used for this purpose.}

\item{options}{Named options that should be passed to the \code{runApp} call
(these can be any of the following: "port", "launch.browser", "host", "quiet",
"display.mode" and "test.mode"). You can also specify \code{width} and
\code{height} parameters which provide a hint to the embedding environment
about the ideal height/width for the app.}

\item{uiPattern}{A regular expression that will be applied to each \code{GET}
request to determine whether the \code{ui} should be used to handle the
request. Note that the entire request path must match the regular
expression in order for the match to be considered successful.}

\item{enableBookmarking}{Can be one of \code{"url"}, \code{"server"}, or
\code{"disable"}. This is equivalent to calling the
\code{\link[=enableBookmarking]{enableBookmarking()}} function just before calling
\code{shinyApp()}. With the default value (\code{NULL}), the app will
respect the setting from any previous calls to \code{enableBookmarking()}.
See \code{\link[=enableBookmarking]{enableBookmarking()}} for more information.}

\item{appDir}{Path to directory that contains a Shiny app (i.e. a server.R
file and either ui.R or www/index.html)}

\item{appFile}{Path to a .R file containing a Shiny application}
}
\value{
An object that represents the app. Printing the object or passing it
to \code{\link[=runApp]{runApp()}} will run the app.
}
\description{
These functions create Shiny app objects from either an explicit UI/server
pair (\code{shinyApp}), or by passing the path of a directory that contains a
Shiny app (\code{shinyAppDir}).
}
\details{
Normally when this function is used at the R console, the Shiny app object is
automatically passed to the \code{print()} function, which runs the app. If
this is called in the middle of a function, the value will not be passed to
\code{print()} and the app will not be run. To make the app run, pass the app
object to \code{print()} or \code{\link[=runApp]{runApp()}}.
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
  options(device.ask.default = FALSE)

  shinyApp(
    ui = fluidPage(
      numericInput("n", "n", 1),
      plotOutput("plot")
    ),
    server = function(input, output) {
      output$plot <- renderPlot( plot(head(cars, input$n)) )
    }
  )

  shinyAppDir(system.file("examples/01_hello", package="shiny"))


  # The object can be passed to runApp()
  app <- shinyApp(
    ui = fluidPage(
      numericInput("n", "n", 1),
      plotOutput("plot")
    ),
    server = function(input, output) {
      output$plot <- renderPlot( plot(head(cars, input$n)) )
    }
  )

  runApp(app)
}
}
