% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.tpm.R
\name{stat.tpm}
\alias{stat.tpm}
\title{Construct truncated product method statistic.}
\usage{
stat.tpm(p, tau1)
}
\arguments{
\item{p}{- input p-values.}

\item{tau1}{- truncation parameter. 0 < tau1 <= 1.}
}
\value{
Truncated product method statistic.
}
\description{
Construct truncated product method statistic.
}
\details{
Let \eqn{p_{i}}, \eqn{i = 1,...,n} be a sequence of p-values, the TPM statistic
\deqn{TPM = \sum_{i=1}^n -2\log(p_i)I(p_i\leq\tau_2)}. TPM is the special case of TFisher when tau2=1.
}
\examples{
pval <- runif(100)
stat.tpm(p=pval, tau1=0.05)
}
\references{
1. Hong Zhang and Zheyang Wu. "TFisher Tests: Optimal and Adaptive Thresholding for Combining p-Values", submitted.

2. Zaykin, D.V., Zhivotovsky, L. A., Westfall, P.H. and Weir, B.S. (2002), Truncated product method for combining P-values. Genet. Epidemiol., 22: 170–185. doi:10.1002/gepi.0042
}
