% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui-legacy.R
\name{ui-legacy-functions}
\alias{ui-legacy-functions}
\alias{ui_line}
\alias{ui_todo}
\alias{ui_done}
\alias{ui_oops}
\alias{ui_info}
\alias{ui_code_block}
\alias{ui_stop}
\alias{ui_warn}
\alias{ui_field}
\alias{ui_value}
\alias{ui_path}
\alias{ui_code}
\alias{ui_unset}
\title{Legacy functions related to user interface}
\usage{
ui_line(x = character(), .envir = parent.frame())

ui_todo(x, .envir = parent.frame())

ui_done(x, .envir = parent.frame())

ui_oops(x, .envir = parent.frame())

ui_info(x, .envir = parent.frame())

ui_code_block(x, copy = rlang::is_interactive(), .envir = parent.frame())

ui_stop(x, .envir = parent.frame())

ui_warn(x, .envir = parent.frame())

ui_field(x)

ui_value(x)

ui_path(x, base = NULL)

ui_code(x)

ui_unset(x = "unset")
}
\arguments{
\item{x}{A character vector.

For block styles, conditions, and questions, each element of the
vector becomes a line, and the result is processed by \code{\link[glue:glue]{glue::glue()}}.
For inline styles, each element of the vector becomes an entry in a
comma separated list.}

\item{.envir}{Used to ensure that \code{\link[glue:glue]{glue::glue()}} gets the correct
environment. For expert use only.}

\item{copy}{If \code{TRUE}, the session is interactive, and the clipr package
is installed, will copy the code block to the clipboard.}

\item{base}{If specified, paths will be displayed relative to this path.}
}
\value{
The block styles, conditions, and questions are called for their
side-effect. The inline styles return a string.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

These functions are now superseded. External users of the \verb{usethis::ui_*()}
functions are encouraged to use the \href{https://cli.r-lib.org/}{cli package}
instead. The cli package did not have the required functionality when the
\verb{usethis::ui_*()} functions were created, but it has had that for a while
now and it's the superior option. There is even a cli vignette about how to
make this transition: \code{vignette("usethis-ui", package = "cli")}.

usethis itself now uses cli internally for its UI, but these new functions
are not exported and presumably never will be. There is a developer-focused
article on the process of transitioning usethis's own UI to use cli:
\href{https://usethis.r-lib.org/articles/ui-cli-conversion.html}{Converting usethis's UI to use cli}.
}
\details{
The \code{ui_} functions can be broken down into four main categories:
\itemize{
\item block styles: \code{ui_line()}, \code{ui_done()}, \code{ui_todo()}, \code{ui_oops()},
\code{ui_info()}.
\item conditions: \code{ui_stop()}, \code{ui_warn()}.
\item questions: \code{\link[=ui_yeah]{ui_yeah()}}, \code{\link[=ui_nope]{ui_nope()}}.
\item inline styles: \code{ui_field()}, \code{ui_value()}, \code{ui_path()}, \code{ui_code()},
\code{ui_unset()}.
}

The question functions \code{\link[=ui_yeah]{ui_yeah()}} and \code{\link[=ui_nope]{ui_nope()}} have their own \link[=ui-questions]{help page}.

All UI output (apart from \code{ui_yeah()}/\code{ui_nope()} prompts) can be silenced
by setting \code{options(usethis.quiet = TRUE)}. Use \code{\link[=ui_silence]{ui_silence()}} to silence
selected actions.
}
\examples{
new_val <- "oxnard"
ui_done("{ui_field('name')} set to {ui_value(new_val)}")
ui_todo("Redocument with {ui_code('devtools::document()')}")

ui_code_block(c(
  "Line 1",
  "Line 2",
  "Line 3"
))
}
\keyword{internal}
