# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2020 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from testrpc.idl.

use strict;

package Raritan::RPC::test::AuxSerial;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "test.AuxSerial:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::test::AuxSerial::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant OK => 0;

use constant ERR_NO_TEST_MODE => 1;

use constant ERR_INVAL_PORT_NUM => 2;

use constant ERR_TEST_FAILED => 3;

sub getNumberOfPorts($$) {
    my ($self, $numPorts) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getNumberOfPorts', $args);
    $$numPorts = $rsp->{'numPorts'};
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub testLoop($$$) {
    my ($self, $portNum, $errstr) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'portNum'} = 1 * $portNum;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'testLoop', $args);
    $$errstr = $rsp->{'errstr'};
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('test.AuxSerial', 1, 0, 0, 'Raritan::RPC::test::AuxSerial');
1;
