# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2024 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from CascadeManager.idl.

use strict;

package Raritan::RPC::cascading::CascadeManager_2_0_2;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "cascading.CascadeManager:2.0.2";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::cascading::CascadeManager_2_0_2::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant NO_ERROR => 0;

use constant ERR_INVALID_PARAM => 1;

use constant ERR_UNSUPPORTED_ON_PRIMARY_UNIT => 2;

use constant ERR_UNSUPPORTED_ON_LINK_UNIT => 3;

use constant ERR_LINK_ID_IN_USE => 4;

use constant ERR_HOST_IN_USE => 5;

use constant ERR_LINK_UNIT_UNREACHABLE => 6;

use constant ERR_LINK_UNIT_ACCESS_DENIED => 7;

use constant ERR_LINK_UNIT_REFUSED => 8;

use constant ERR_UNIT_BUSY => 9;

use constant ERR_NOT_SUPPORTED => 10;

use constant ERR_PASSWORD_CHANGE_REQUIRED => 11;

use constant ERR_PASSWORD_POLICY => 12;

use constant ERR_LINK_UNIT_COMM_FAILED => 13;

use constant ERR_LINK_UNIT_NOT_SUPPORTED => 14;

use constant ERR_FIRMWARE_VERSION_MISMATCH => 15;

use Raritan::RPC::cascading::CascadeManager_2_0_2::PrimaryUnitSettings;

sub getPrimaryUnitSettings($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getPrimaryUnitSettings', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::cascading::CascadeManager_2_0_2::PrimaryUnitSettings::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::cascading::CascadeManager_2_0_2::PrimaryUnitSettings;

sub setPrimaryUnitSettings($$) {
    my ($self, $primaryUnitSettings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'primaryUnitSettings'} = Raritan::RPC::cascading::CascadeManager_2_0_2::PrimaryUnitSettings::encode($primaryUnitSettings);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setPrimaryUnitSettings', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::cascading::CascadeManager_2_0_2::Status;

sub getStatus($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getStatus', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::cascading::CascadeManager_2_0_2::Status::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::cascading::CascadeManager_2_0_2::LinkPortStatus;

sub getLinkPortStatus($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getLinkPortStatus', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::cascading::CascadeManager_2_0_2::LinkPortStatus::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

sub addLinkUnit($$$$$$) {
    my ($self, $linkId, $host, $login, $password, $newPassword) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'linkId'} = 1 * $linkId;
    $args->{'host'} = "$host";
    $args->{'login'} = "$login";
    $args->{'password'} = "$password";
    $args->{'newPassword'} = "$newPassword";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'addLinkUnit', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub addLinkUnit2($$$$$$$) {
    my ($self, $linkId, $host, $login, $password, $newPassword, $disableStrongPasswordReq) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'linkId'} = 1 * $linkId;
    $args->{'host'} = "$host";
    $args->{'login'} = "$login";
    $args->{'password'} = "$password";
    $args->{'newPassword'} = "$newPassword";
    $args->{'disableStrongPasswordReq'} = ($disableStrongPasswordReq) ? JSON::true : JSON::false;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'addLinkUnit2', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub releaseLinkUnit($$) {
    my ($self, $linkId) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'linkId'} = 1 * $linkId;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'releaseLinkUnit', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub requestLink($$) {
    my ($self, $token) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'token'} = "$token";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'requestLink', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub finalizeLink($$) {
    my ($self, $token) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'token'} = "$token";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'finalizeLink', $args);
}

sub unlink($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'unlink', $args);
}


sub getSupportedRoles($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getSupportedRoles', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = $rsp->{'_ret_'}->[$i0];
    }
    return $_ret_;
}


sub getSupportedLinkUnitTypes($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getSupportedLinkUnitTypes', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = $rsp->{'_ret_'}->[$i0];
    }
    return $_ret_;
}

sub addCascadeLinkUnit($$$$$$) {
    my ($self, $linkId, $nodeIndex, $login, $password, $positionDependent) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'linkId'} = 1 * $linkId;
    $args->{'nodeIndex'} = 1 * $nodeIndex;
    $args->{'login'} = "$login";
    $args->{'password'} = "$password";
    $args->{'positionDependent'} = ($positionDependent) ? JSON::true : JSON::false;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'addCascadeLinkUnit', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub addLinkPortLinkUnit($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'addLinkPortLinkUnit', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub addSecureSerialLinkUnit($$$) {
    my ($self, $linkId, $installKey) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'linkId'} = 1 * $linkId;
    $args->{'installKey'} = "$installKey";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'addSecureSerialLinkUnit', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('cascading.CascadeManager', 2, 0, 2, 'Raritan::RPC::cascading::CascadeManager_2_0_2');
1;
