/*
 *	recite - english text speech synthesizer
 *	Copyright (C) 1991, 1992, 1993 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: functions to report version
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <arglex.h>
#include <error.h>
#include <help.h>
#include <version.h>
#include <mem.h>


static void version_copyright _((void));

static void
version_copyright()
{
	static char *text[] =
	{
		"%C"
	};
	help(text, SIZEOF(text), (void (*)_((void)))0);
}


static void version_redistribution _((void));

static void
version_redistribution()
{
	static char *text[] =
	{
"		    GNU GENERAL PUBLIC LICENSE",
"   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION",
"",
"  0. This License Agreement applies to any program or other work which",
"contains a notice placed by the copyright holder saying it may be",
"distributed under the terms of this General Public License.  The",
"\"Program\", below, refers to any such program or work, and a \"work based",
"on the Program\" means either the Program or any work containing the",
"Program or a portion of it, either verbatim or with modifications.  Each",
"licensee is addressed as \"you\".",
"",
"  1. You may copy and distribute verbatim copies of the Program's source",
"code as you receive it, in any medium, provided that you conspicuously and",
"appropriately publish on each copy an appropriate copyright notice and",
"disclaimer of warranty; keep intact all the notices that refer to this",
"General Public License and to the absence of any warranty; and give any",
"other recipients of the Program a copy of this General Public License",
"along with the Program.  You may charge a fee for the physical act of",
"transferring a copy.",
"",
"  2. You may modify your copy or copies of the Program or any portion of",
"it, and copy and distribute such modifications under the terms of Paragraph",
"1 above, provided that you also do the following:",
"",
"    a) cause the modified files to carry prominent notices stating that",
"    you changed the files and the date of any change; and",
"",
"    b) cause the whole of any work that you distribute or publish, that",
"    in whole or in part contains the Program or any part thereof, either",
"    with or without modifications, to be licensed at no charge to all",
"    third parties under the terms of this General Public License (except",
"    that you may choose to grant warranty protection to some or all",
"    third parties, at your option).",
"",
"    c) If the modified program normally reads commands interactively when",
"    run, you must cause it, when started running for such interactive use",
"    in the simplest and most usual way, to print or display an",
"    announcement including an appropriate copyright notice and a notice",
"    that there is no warranty (or else, saying that you provide a",
"    warranty) and that users may redistribute the program under these",
"    conditions, and telling the user how to view a copy of this General",
"    Public License.",
"",
"    d) You may charge a fee for the physical act of transferring a",
"    copy, and you may at your option offer warranty protection in",
"    exchange for a fee.",
"",
"Mere aggregation of another independent work with the Program (or its",
"derivative) on a volume of a storage or distribution medium does not bring",
"the other work under the scope of these terms.",
"",
"  3. You may copy and distribute the Program (or a portion or derivative of",
"it, under Paragraph 2) in object code or executable form under the terms of",
"Paragraphs 1 and 2 above provided that you also do one of the following:",
"",
"    a) accompany it with the complete corresponding machine-readable",
"    source code, which must be distributed under the terms of",
"    Paragraphs 1 and 2 above; or,",
"",
"    b) accompany it with a written offer, valid for at least three",
"    years, to give any third party free (except for a nominal charge",
"    for the cost of distribution) a complete machine-readable copy of the",
"    corresponding source code, to be distributed under the terms of",
"    Paragraphs 1 and 2 above; or,",
"",
"    c) accompany it with the information you received as to where the",
"    corresponding source code may be obtained.  (This alternative is",
"    allowed only for noncommercial distribution and only if you",
"    received the program in object code or executable form alone.)",
"",
"Source code for a work means the preferred form of the work for making",
"modifications to it.  For an executable file, complete source code means",
"all the source code for all modules it contains; but, as a special",
"exception, it need not include source code for modules which are standard",
"libraries that accompany the operating system on which the executable",
"file runs, or for standard header files or definitions files that",
"accompany that operating system.",
"",
"  4. You may not copy, modify, sublicense, distribute or transfer the",
"Program except as expressly provided under this General Public License.",
"Any attempt otherwise to copy, modify, sublicense, distribute or transfer",
"the Program is void, and will automatically terminate your rights to use",
"the Program under this License.  However, parties who have received",
"copies, or rights to use copies, from you under this General Public",
"License will not have their licenses terminated so long as such parties",
"remain in full compliance.",
"",
"  5. By copying, distributing or modifying the Program (or any work based",
"on the Program) you indicate your acceptance of this license to do so,",
"and all its terms and conditions.",
"",
"  6. Each time you redistribute the Program (or any work based on the",
"Program), the recipient automatically receives a license from the original",
"licensor to copy, distribute or modify the Program subject to these",
"terms and conditions.  You may not impose any further restrictions on the",
"recipients' exercise of the rights granted herein.",
"",
"  7. The Free Software Foundation may publish revised and/or new versions",
"of the General Public License from time to time.  Such new versions will",
"be similar in spirit to the present version, but may differ in detail to",
"address new problems or concerns.",
"",
"Each version is given a distinguishing version number.  If the Program",
"specifies a version number of the license which applies to it and \"any",
"later version\", you have the option of following the terms and conditions",
"either of that version or of any later version published by the Free",
"Software Foundation.  If the Program does not specify a version number of",
"the license, you may choose any version ever published by the Free Software",
"Foundation.",
"",
"  8. If you wish to incorporate parts of the Program into other free",
"programs whose distribution conditions are different, write to the author",
"to ask for permission.  For software which is copyrighted by the Free",
"Software Foundation, write to the Free Software Foundation; we sometimes",
"make exceptions for this.  Our decision will be guided by the two goals",
"of preserving the free status of all derivatives of our free software and",
"of promoting the sharing and reuse of software generally.",
	};
	help(text, SIZEOF(text), (void (*)_((void)))0);
}


static void version_warranty _((void));

static void
version_warranty()
{
	static char *text[] =
	{
"			NO WARRANTY",
"",
"  9. BECAUSE THE %s PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY",
"FOR THE %s PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN",
"OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES",
"PROVIDE THE %s PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED",
"OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF",
"MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS",
"TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE",
"%s PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,",
"REPAIR OR CORRECTION.",
"",
"  10. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING",
"WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR",
"REDISTRIBUTE THE %s PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,",
"INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING",
"OUT OF THE USE OR INABILITY TO USE THE %s PROGRAM (INCLUDING BUT NOT LIMITED",
"TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY",
"YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER",
"PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE",
"POSSIBILITY OF SUCH DAMAGES.",
	};

	help(text, SIZEOF(text), (void (*)_((void)))0);
}


static void version_usage _((void));

static void
version_usage()
{
	fprintf(stderr, "usage: %s -VERSion [ <info-name> ]\n", progname);
	fprintf(stderr, "       %s -VERSion -Help\n", progname);
	exit(1);
}


typedef struct table_t table_t;
struct table_t
{
	char	*name;
	void	(*func)_((void));
};


static	table_t	table[] =
{
	{ "Copyright",		version_copyright,	},
	{ "Redistribution",	version_redistribution,	},
	{ "Warranty",		version_warranty,	},
};


static void version_main _((void));

static void
version_main()
{
	void	(*func)_((void));

	/* trace(("version_main()\n{\n"/ *}* /)); */
	if (arglex_token == arglex_token_string)
	{
		int		nhit;
		table_t		*tp;
		table_t		*hit[SIZEOF(table)];
		int		j;
		size_t		len;
		char		*buf;

		nhit = 0;
		for (tp = table; tp < ENDOF(table); ++tp)
		{
			if (arglex_compare(tp->name, arglex_value.alv_string))
				hit[nhit++] = tp;
		}
		switch (nhit)
		{
		case 0:
			fatal
			(
				"version information name \"%s\" unknown",
				arglex_value.alv_string
			);
	
		case 1:
			break;
	
		default:
			len = strlen(hit[0]->name) + 1;
			for (j = 1; j < nhit; ++j)
				len += strlen(hit[j]->name) + 2;
			buf = mem_alloc(len);
			strcpy(buf, hit[j]->name);
			for (j = 1; j < nhit; ++j)
			{
				strcat(buf, ", ");
				strcat(buf, hit[j]->name);
			}
			fatal
			(
			       "version information name \"%s\" ambiguous (%s)",
				arglex_value.alv_string,
				buf
			);
		}
		arglex();
		func = hit[0]->func;
	}
	else
		func = version_copyright;
	if (arglex_token != arglex_token_eoln)
		version_usage();

	func();
	/* trace((/ *{* /"}\n")); */
}


static void version_help _((void));

static void
version_help()
{
	static char *text[] = 
	{
"NAME",
"	%s -VERSion - give version information",
"",
"SYNOPSIS",
"	%s -VERSion [ <info-name> ]",
"	%s -VERSion -Help",
"",
"DESCRIPTION",
"	The %s -VERSion command is used to give version",
"	information and conditions of use.",
"",
"	There are a number of possible info-names, as follow",
"	(abbreviations as for command line options):",
"",
"	Copyright",
"		The copyright notice for the %s program.  Version",
"		information will also be printed.",
"		This is the default.",
"",
"	Redistribution",
"		Print the conditions of use and redistribution.",
"",
"	Warranty",
"		Print the limited warranty.",
"",
"OPTIONS",
"	The following options are understood:",
"",
"	-Help",
"		This option may be used to obtain more",
"		information about how to use the %s program.",
"",
"	All options are case insensitive.  Options may be",
"	abbreviated; the abbreviation is the upper case letters.",
"	Options and other command line arguments may be mixed",
"	arbitrarily on the command line.",
"",
"ERRORS",
"	It is an error if the info-name given is unknown.",
"",
"EXIT STATUS",
"	The %s command will exit with a status of 1 on any",
"	error.	The %s command will only exit with a status of",
"	0 if there are no errors.",
"",
"COPYRIGHT",
"	%C",
"",
"AUTHOR",
"	%A",
	};

	help(text, SIZEOF(text), version_usage);
}


void
version()
{
	/* trace(("version()\n{\n"/ *}* /)); */
	switch (arglex())
	{
	default:
		version_main();
		break;

	case arglex_token_help:
		version_help();
		break;
	}
	/* trace((/ *{* /"}\n")); */
}
