#!/bin/sh -e

VERSION=$2
TAR=../redstone-xmlrpc_$VERSION.orig.tar.gz
DIR=redstone-xmlrpc-$VERSION
TAG_VERSION=$(echo $VERSION | sed -re's/\./_/')
TAG=$(echo "rel_$TAG_VERSION" | sed -re's/~(alpha|beta)/-\1-/')

svn export https://xmlrpc.svn.sourceforge.net/svnroot/xmlrpc/tags/$TAG/ $DIR
GZIP=--best tar -c -z -f $TAR --exclude 'lib' --exclude '*.jar' --exclude '*.class' $DIR
rm -rf $DIR ../$TAG

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir && echo "moved $TAR to $origDir"
fi
