#! /bin/bash

# Test update of a record.

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

BASENAME=$(basename $0 .pl)
TMP_TEST_DB=$(echo tmp${BASENAME}$$ | sed 's/[^-0-9a-zA-Z]//g').db

DB_DIR=db
DB_FILE=${DB_DIR}/test3.db
TMP_DB_FILE=${DB_DIR}/${TMP_TEST_DB}

cp ${DB_FILE} ${TMP_DB_FILE}

unset $(printenv | awk -F= '!/^PATH=/&&!/PERL5LIB/&&/=/{print $1}' | grep -v '()')

export REQUEST_URI="/~saulius/restful/website/test3.db/bibliography/10?filter=authors+STARTS+WITH+%22Saulius%22&offset=0&rows=100"
export HTTP_HOST=${TMP_TEST_DB}.domain.net
export REQUEST_METHOD=get
export REMOTE_USER=reader

${INPUT_SCRIPT} 'filter=authors+STARTS+WITH+%22Saulius%22&offset=0&rows=100'

rm -f ${TMP_DB_FILE}
