// file automatically generated by "../../../rheolef/nfem/pbasis/basis_symbolic_cxx.cc"
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "P1q.h"
namespace rheolef {
using namespace std;
template<class T>
class basis_P1q_q {
public:
  typedef basis_rep<T>              base;
  typedef typename base::size_type size_type;
  static void eval      (const point_basic<T>& hat_x, vector<T>& values);
  static void eval      (const point_basic<T>& hat_x, typename vector<T>::iterator values);
  static void grad_eval (const point_basic<T>& hat_x, vector<point_basic<T> >& values);
  static void grad_eval (const point_basic<T>& hat_x, typename vector<point_basic<T> >::iterator values);
  static void hat_node  (vector<point_basic<T> >& hat_node);
  static void hat_node  (typename vector<point_basic<T> >::iterator values);
};
template<class T>
class basis_P1q_H {
public:
  typedef basis_rep<T>              base;
  typedef typename base::size_type size_type;
  static void eval      (const point_basic<T>& hat_x, vector<T>& values);
  static void eval      (const point_basic<T>& hat_x, typename vector<T>::iterator values);
  static void grad_eval (const point_basic<T>& hat_x, vector<point_basic<T> >& values);
  static void grad_eval (const point_basic<T>& hat_x, typename vector<point_basic<T> >::iterator values);
  static void hat_node  (vector<point_basic<T> >& hat_node);
  static void hat_node  (typename vector<point_basic<T> >::iterator values);
};
template<class T>
void
basis_P1q_q<T>::eval(
  const point_basic<T>&        hat_x,
  typename vector<T>::iterator values)
{
  values[0] =  hat_x[1]+5.0000000000000000e-01;
  values[1] =  hat_x[0]-hat_x[1];
  values[2] = -hat_x[0]+5.0000000000000000e-01;
}
template<class T>
void
basis_P1q_q<T>::eval(
  const point_basic<T>& hat_x,
  vector<T>&            values)
{
  values.resize(3);
  eval (hat_x, values.begin());
}
template<class T>
void
basis_P1q_q<T>::grad_eval(
  const point_basic<T>&                      hat_x,
  typename vector<point_basic<T> >::iterator values)
{
  values[0][0] = 0.0;
  values[0][1] = 1.0;
  values[1][0] = 1.0;
  values[1][1] = -1.0000000000000000e+00;
  values[2][0] = -1.0000000000000000e+00;
  values[2][1] = 0.0;
}
template<class T>
void
basis_P1q_q<T>::grad_eval(
  const point_basic<T>&    hat_x,
  vector<point_basic<T> >& values)
{
  values.resize(3);
  grad_eval (hat_x, values.begin());
}
template<class T>
void
basis_P1q_q<T>::hat_node (typename vector<point_basic<T> >::iterator x)
{
  x[0] = point_basic<T>(5.0000000000000000e-01, 5.0000000000000000e-01);
  x[1] = point_basic<T>(5.0000000000000000e-01, -5.0000000000000000e-01);
  x[2] = point_basic<T>(-5.0000000000000000e-01, -5.0000000000000000e-01);
}
template<class T>
void
basis_P1q_q<T>::hat_node (vector<point_basic<T> >& x)
{
  x.resize(3);
  hat_node (x.begin());
}
template<class T>
void
basis_P1q_H<T>::eval(
  const point_basic<T>&        hat_x,
  typename vector<T>::iterator values)
{
  values[0] =  hat_x[2]+5.0000000000000000e-01;
  values[1] = -hat_x[2]+hat_x[1];
  values[2] =  hat_x[0]-hat_x[1];
  values[3] = -hat_x[0]+5.0000000000000000e-01;
}
template<class T>
void
basis_P1q_H<T>::eval(
  const point_basic<T>& hat_x,
  vector<T>&            values)
{
  values.resize(4);
  eval (hat_x, values.begin());
}
template<class T>
void
basis_P1q_H<T>::grad_eval(
  const point_basic<T>&                      hat_x,
  typename vector<point_basic<T> >::iterator values)
{
  values[0][0] = 0.0;
  values[0][1] = 0.0;
  values[0][2] = 1.0;
  values[1][0] = 0.0;
  values[1][1] = 1.0;
  values[1][2] = -1.0000000000000000e+00;
  values[2][0] = 1.0;
  values[2][1] = -1.0000000000000000e+00;
  values[2][2] = 0.0;
  values[3][0] = -1.0000000000000000e+00;
  values[3][1] = 0.0;
  values[3][2] = 0.0;
}
template<class T>
void
basis_P1q_H<T>::grad_eval(
  const point_basic<T>&    hat_x,
  vector<point_basic<T> >& values)
{
  values.resize(4);
  grad_eval (hat_x, values.begin());
}
template<class T>
void
basis_P1q_H<T>::hat_node (typename vector<point_basic<T> >::iterator x)
{
  x[0] = point_basic<T>(5.0000000000000000e-01, 5.0000000000000000e-01, 5.0000000000000000e-01);
  x[1] = point_basic<T>(5.0000000000000000e-01, 5.0000000000000000e-01, -5.0000000000000000e-01);
  x[2] = point_basic<T>(5.0000000000000000e-01, -5.0000000000000000e-01, -5.0000000000000000e-01);
  x[3] = point_basic<T>(-5.0000000000000000e-01, -5.0000000000000000e-01, -5.0000000000000000e-01);
}
template<class T>
void
basis_P1q_H<T>::hat_node (vector<point_basic<T> >& x)
{
  x.resize(4);
  hat_node (x.begin());
}
template<class T>
basis_P1q<T>::~basis_P1q()
{
}
template<class T>
typename basis_P1q<T>::size_type
basis_P1q<T>::degree () const
{
    return 1;
}
template<class T>
typename basis_P1q<T>::size_type
basis_P1q<T>::size (
    reference_element hat_K) const
{
    switch (hat_K.variant()) {
      case reference_element::q: {
        return 3;
      }
      case reference_element::H: {
        return 4;
      }
      default : {
        error_macro ("size: unsupported `" << hat_K.name() << "' element type");
        return 0;
      }
    }
}
template<class T>
void
basis_P1q<T>::eval(
    reference_element     hat_K,
    const point_basic<T>& hat_x,
    vector<T>&        values) const
{
    switch (hat_K.variant()) {
      case reference_element::q: {
        return basis_P1q_q<T>::eval (hat_x, values);
      }
      case reference_element::H: {
        return basis_P1q_H<T>::eval (hat_x, values);
      }
      default : {
        error_macro ("eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
template<class T>
void
basis_P1q<T>::eval(
    reference_element     hat_K,
    const point_basic<T>& hat_x,
    typename vector<T>::iterator        values) const
{
    switch (hat_K.variant()) {
      case reference_element::q: {
        return basis_P1q_q<T>::eval (hat_x, values);
      }
      case reference_element::H: {
        return basis_P1q_H<T>::eval (hat_x, values);
      }
      default : {
        error_macro ("eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
template<class T>
void
basis_P1q<T>::grad_eval(
    reference_element        hat_K,
    const point_basic<T>&    hat_x,
    vector<point_basic<T> >&            values) const
{
    switch (hat_K.variant()) {
      case reference_element::q: {
      return basis_P1q_q<T>::grad_eval (hat_x, values);
      }
      case reference_element::H: {
      return basis_P1q_H<T>::grad_eval (hat_x, values);
      }
      default : {
        error_macro ("grad_eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
template<class T>
void
basis_P1q<T>::grad_eval(
    reference_element        hat_K,
    const point_basic<T>&    hat_x,
    typename vector<point_basic<T> >::iterator            values) const
{
    switch (hat_K.variant()) {
      case reference_element::q: {
      return basis_P1q_q<T>::grad_eval (hat_x, values);
      }
      case reference_element::H: {
      return basis_P1q_H<T>::grad_eval (hat_x, values);
      }
      default : {
        error_macro ("grad_eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
template<class T>
void
basis_P1q<T>::hat_node(
    reference_element hat_K,
    vector<point_basic<T> >&     hat_node) const
{
    switch (hat_K.variant()) {
      case reference_element::q: {
        return basis_P1q_q<T>::hat_node (hat_node);
      }
      case reference_element::H: {
        return basis_P1q_H<T>::hat_node (hat_node);
      }
      default : {
        error_macro ("hat_node: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
template<class T>
void
basis_P1q<T>::hat_node(
    reference_element hat_K,
    typename vector<point_basic<T> >::iterator     hat_node) const
{
    switch (hat_K.variant()) {
      case reference_element::q: {
        return basis_P1q_q<T>::hat_node (hat_node);
      }
      case reference_element::H: {
        return basis_P1q_H<T>::hat_node (hat_node);
      }
      default : {
        error_macro ("hat_node: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
// instantiation in library:
template class basis_P1q<Float>;
} // namespace rheolef
