#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "stokes-assembly.h"
#include "cavity.h"
int main(int argc, char**argv) {
  geo  omega_h (argv[1]);
  space Vh = cavity_space (omega_h, "P2");
  space Qh (omega_h, "P1");
  field uh = cavity_field (Vh, 1);
  field ph (Qh, 0.);
  form mp (Qh, Qh, "mass");
  form a  (Vh, Vh, "2D_D");
  form b (Vh, Qh, "div"); b = -b;
  field c = mp*field(Qh,1.0);
  csr<Float> A = stokes_assembly (a.uu, b.uu, c.u);
  ssk<Float> fact_A = ldlt(A);
  size_t n = a.uu.nrow();
  size_t m = b.uu.nrow();
  vec<Float> lh1 = -(a.ub*uh.b);
  vec<Float> lh2 = -(b.ub*uh.b);
  vec<Float> L(n+m+1);
  for (size_t i = 0; i < n; i++) L.at(i) = lh1.at(i);
  for (size_t i = 0; i < m; i++) L.at(n+i) = lh2.at(i);
  L.at(n+m) = 0;
  vec<Float> U = fact_A.solve(L);
  for (size_t i = 0; i < n; i++) uh.u.at(i) = U.at(i);
  for (size_t i = 0; i < m; i++) ph.u.at(i) = U.at(n+i);
  Float lambda = U.at(U.size()-1);
  cout << catchmark("u")  << uh
       << catchmark("p")  << ph
       << catchmark("lambda")  << lambda << endl;
}
