
#line 1 "ragel/i18n/kn.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "ragel/i18n/kn.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_kn/gherkin_lexer_kn.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 12, 13, 21, 22, 23, 24, 
	25, 26, 27, 28, 29, 30, 31, 33, 
	35, 46, 47, 48, 50, 52, 57, 62, 
	67, 72, 76, 80, 82, 83, 84, 85, 
	86, 87, 88, 89, 90, 91, 92, 93, 
	94, 95, 96, 97, 102, 109, 114, 118, 
	124, 127, 129, 135, 146, 147, 148, 149, 
	150, 151, 152, 153, 154, 155, 156, 157, 
	158, 159, 160, 161, 162, 163, 164, 165, 
	166, 167, 168, 169, 170, 171, 172, 173, 
	174, 175, 176, 183, 185, 187, 189, 191, 
	193, 195, 197, 199, 201, 203, 205, 207, 
	209, 211, 213, 215, 217, 219, 230, 231, 
	232, 233, 234, 235, 236, 237, 238, 239, 
	240, 241, 242, 243, 244, 245, 246, 247, 
	248, 249, 250, 251, 252, 253, 254, 255, 
	256, 257, 266, 268, 276, 278, 280, 282, 
	284, 286, 288, 290, 292, 294, 296, 298, 
	300, 302, 304, 306, 308, 310, 312, 314, 
	316, 318, 320, 322, 324, 326, 328, 330, 
	332, 334, 336, 338, 340, 342, 344, 346, 
	348, 350, 353, 355, 357, 359, 361, 363, 
	365, 367, 369, 371, 373, 375, 377, 379, 
	381, 383, 385, 387, 389, 391, 393, 395, 
	397, 399, 401, 403, 405, 407, 409, 411, 
	413, 415, 417, 419, 421, 423, 425, 427, 
	429, 431, 433, 435, 437, 439, 441, 443, 
	445, 447, 449, 451, 453, 455, 457, 459, 
	461, 463, 465, 467, 469, 471, 473, 475, 
	477, 479, 481, 483, 485, 487, 489, 491, 
	493, 495, 497, 499, 502, 504, 506, 508, 
	510, 512, 514, 516, 518, 520, 522, 524, 
	526, 528, 530, 532, 534, 536, 538, 540, 
	542, 544, 546, 548, 550, 552, 554, 556, 
	558, 560, 562, 564, 566, 568, 570, 572, 
	574, 576, 578, 580, 582, 584, 586, 588, 
	589, 590, 592, 593, 594, 595, 596, 597, 
	598, 599, 600, 601, 602, 603, 604, 605, 
	606, 607, 608, 609, 610, 611, 612, 613, 
	614, 615, 616, 617, 618, 619, 620, 621, 
	622, 623, 624, 625, 626, 627, 628, 629, 
	630, 631, 632, 633, 634, 635, 636, 637, 
	638, 639, 640, 649, 651, 658, 660, 662, 
	664, 666, 668, 670, 672, 674, 676, 678, 
	680, 682, 684, 686, 688, 690, 692, 694, 
	696, 698, 700, 702, 704, 706, 708, 710, 
	712, 714, 716, 718, 720, 722, 724, 726, 
	728, 730, 732, 735, 737, 739, 741, 743, 
	745, 747, 749, 751, 753, 755, 757, 759, 
	761, 763, 765, 767, 769, 771, 773, 775, 
	777, 779, 781, 783, 785, 787, 789, 791, 
	793, 795, 797, 799, 801, 803, 805, 807, 
	809, 811, 813, 815, 817, 819, 821, 823, 
	825, 827, 829, 831, 833, 835, 837, 839, 
	841, 843, 845, 847, 849, 851, 853, 855, 
	857, 859, 861, 863, 865, 867, 869, 871, 
	873, 875, 877, 879, 881, 883, 885, 887, 
	889, 891, 893, 895, 897, 899, 901, 903, 
	905, 907, 908, 909, 910, 911, 912, 913, 
	914, 915, 916, 917, 918, 919, 920, 921, 
	922, 923, 924, 925, 926, 927, 928, 929, 
	930, 931, 932, 933, 934, 935, 937, 938, 
	939, 940, 941, 942, 943, 944, 945, 946, 
	947, 948, 949, 950, 951, 952, 953, 954, 
	955, 956, 957, 958, 959, 968, 970, 978, 
	980, 982, 984, 986, 988, 990, 992, 994, 
	996, 998, 1000, 1002, 1004, 1006, 1008, 1010, 
	1012, 1014, 1016, 1018, 1020, 1022, 1024, 1026, 
	1028, 1030, 1032, 1034, 1036, 1038, 1040, 1042, 
	1044, 1046, 1048, 1050, 1052, 1055, 1057, 1059, 
	1061, 1063, 1065, 1067, 1069, 1071, 1073, 1075, 
	1077, 1079, 1081, 1083, 1085, 1087, 1089, 1091, 
	1093, 1095, 1097, 1099, 1101, 1103, 1105, 1107, 
	1109, 1111, 1113, 1115, 1117, 1119, 1121, 1123, 
	1125, 1127, 1129, 1131, 1133, 1135, 1137, 1139, 
	1141, 1143, 1145, 1147, 1149, 1151, 1153, 1155, 
	1157, 1159, 1161, 1163, 1165, 1167, 1169, 1171, 
	1173, 1175, 1177, 1179, 1181, 1183, 1185, 1187, 
	1189, 1191, 1193, 1195, 1197, 1199, 1201, 1203, 
	1205, 1207, 1209, 1211, 1213, 1215, 1217, 1219, 
	1221, 1223, 1225, 1227, 1229, 1231, 1233, 1235, 
	1237, 1239, 1241, 1243, 1245, 1247, 1249, 1251, 
	1253, 1255, 1257, 1258, 1259, 1260, 1261, 1262, 
	1263, 1264, 1265, 1266, 1267, 1268, 1269, 1270, 
	1271, 1272, 1273, 1281, 1283, 1288, 1290, 1292, 
	1294, 1296, 1298, 1300, 1302, 1304, 1306, 1308, 
	1310, 1312, 1314, 1316, 1318, 1320, 1322, 1324, 
	1326, 1328, 1330, 1332, 1334, 1336, 1338, 1340, 
	1342, 1344, 1346, 1348, 1350, 1352, 1354, 1356, 
	1358, 1360, 1362, 1364, 1366, 1368, 1370, 1372, 
	1374, 1376, 1378, 1380, 1382, 1384, 1386, 1388, 
	1390, 1392, 1394, 1396, 1398, 1400, 1402, 1404, 
	1406, 1408, 1410, 1412, 1414, 1416, 1418, 1420, 
	1422, 1424, 1427, 1429, 1431, 1433, 1435, 1437, 
	1439, 1441, 1443, 1445, 1447, 1449, 1451, 1453, 
	1455, 1457, 1459, 1461, 1463, 1465, 1467, 1469, 
	1471, 1473, 1475, 1477, 1479, 1481, 1483, 1485, 
	1487, 1489, 1491, 1493, 1495, 1497, 1499, 1501, 
	1503, 1505, 1507, 1509, 1511, 1513, 1514, 1515
};

static const char _lexer_trans_keys[] = {
	-32, -17, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -78, -122, -119, -107, 
	-88, -82, -75, -72, -71, -32, -78, -90, 
	-32, -78, -80, -32, -77, -122, 32, 10, 
	13, 10, 13, -32, 10, 32, 34, 35, 
	37, 42, 64, 124, 9, 13, 34, 34, 
	10, 13, 10, 13, 10, 32, 34, 9, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	34, 9, 13, 10, 32, 34, 9, 13, 
	10, 32, 9, 13, 10, 32, 9, 13, 
	10, 13, 10, 95, 70, 69, 65, 84, 
	85, 82, 69, 95, 69, 78, 68, 95, 
	37, 13, 32, 64, 9, 10, 9, 10, 
	13, 32, 64, 11, 12, 10, 32, 64, 
	9, 13, 32, 124, 9, 13, 10, 32, 
	92, 124, 9, 13, 10, 92, 124, 10, 
	92, 10, 32, 92, 124, 9, 13, -32, 
	10, 32, 34, 35, 37, 42, 64, 124, 
	9, 13, -32, -78, -90, -32, -78, -66, 
	-32, -78, -71, -32, -78, -80, -32, -78, 
	-93, -32, -77, -122, -32, -78, -105, -32, 
	-78, -77, -32, -77, -127, 58, 10, 10, 
	-32, 10, 32, 35, 124, 9, 13, -78, 
	10, -71, 10, -32, 10, -77, 10, -122, 
	10, -32, 10, -78, 10, -102, 10, -32, 
	10, -77, 10, -115, 10, -32, 10, -78, 
	10, -102, 10, -32, 10, -78, 10, -77, 
	10, 10, 58, -32, 10, 32, 34, 35, 
	37, 42, 64, 124, 9, 13, -32, -78, 
	-91, -32, -78, -66, -32, -78, -72, -32, 
	-78, -66, -32, -78, -80, -32, -78, -66, 
	-32, -78, -126, -32, -78, -74, 58, 10, 
	10, -32, 10, 32, 35, 37, 42, 64, 
	9, 13, -78, 10, -122, -107, -88, -82, 
	-75, -72, -71, 10, -32, 10, -78, 10, 
	-90, 10, -32, 10, -78, 10, -80, 10, 
	-32, 10, -77, 10, -122, 10, 10, 32, 
	-32, 10, -78, 10, -91, 10, -32, 10, 
	-78, 10, -66, 10, -32, 10, -78, 10, 
	-72, 10, -32, 10, -78, 10, -66, 10, 
	-32, 10, -78, 10, -80, 10, -32, 10, 
	-78, 10, -66, 10, -32, 10, -78, 10, 
	-126, 10, -32, 10, -78, 10, -74, 10, 
	10, 58, -32, 10, -78, 10, -126, -65, 
	10, -32, 10, -78, 10, -92, 10, -32, 
	10, -78, 10, -80, 10, -32, 10, -77, 
	10, -107, 10, -32, 10, -78, 10, -95, 
	10, -32, 10, -78, 10, -65, 10, -32, 
	10, -78, 10, -90, 10, -32, 10, -78, 
	10, -92, 10, -32, 10, -77, 10, -115, 
	10, -32, 10, -78, 10, -92, 10, -32, 
	10, -77, 10, -127, 10, -32, 10, -78, 
	10, -65, 10, -32, 10, -78, 10, -75, 
	10, -32, 10, -78, 10, -80, 10, -32, 
	10, -78, 10, -93, 10, -32, 10, -77, 
	10, -122, 10, -32, 10, -77, 10, -115, 
	10, -32, 10, -78, 10, -91, 10, -32, 
	10, -78, 10, -65, 10, -32, 10, -78, 
	10, -92, 10, -32, 10, -78, 10, -65, 
	10, -32, 10, -78, 10, -81, 10, -32, 
	10, -78, 10, -88, 10, -32, 10, -77, 
	10, -115, 10, -32, 10, -78, 10, -88, 
	10, -32, 10, -78, -77, 10, -65, 10, 
	-32, 10, -78, 10, -88, 10, -32, 10, 
	-77, 10, -115, 10, -32, 10, -78, 10, 
	-88, 10, -32, 10, -77, 10, -122, 10, 
	-32, 10, -78, 10, -78, 10, -122, 10, 
	-32, 10, -78, 10, -102, 10, -32, 10, 
	-77, 10, -115, 10, -32, 10, -78, 10, 
	-102, 10, -32, 10, -78, 10, -77, 10, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, -32, -78, -126, -65, 
	-32, -78, -92, -32, -78, -80, -32, -77, 
	-107, -32, -78, -95, -32, -78, -65, -32, 
	-78, -90, -32, -78, -92, -32, -77, -115, 
	-32, -78, -92, -32, -77, -127, -32, -78, 
	-65, -32, -78, -75, -32, -78, -80, -32, 
	-78, -93, -32, -77, -122, 58, 10, 10, 
	-32, 10, 32, 35, 37, 42, 64, 9, 
	13, -78, 10, -122, -107, -88, -82, -72, 
	-71, 10, -32, 10, -78, 10, -90, 10, 
	-32, 10, -78, 10, -80, 10, -32, 10, 
	-77, 10, -122, 10, 10, 32, -32, 10, 
	-78, 10, -91, 10, -32, 10, -78, 10, 
	-66, 10, -32, 10, -78, 10, -72, 10, 
	-32, 10, -78, 10, -66, 10, -32, 10, 
	-78, 10, -80, 10, -32, 10, -78, 10, 
	-66, 10, -32, 10, -78, 10, -126, 10, 
	-32, 10, -78, 10, -74, 10, 10, 58, 
	-32, 10, -78, 10, -126, -65, 10, -32, 
	10, -78, 10, -92, 10, -32, 10, -78, 
	10, -80, 10, -32, 10, -77, 10, -107, 
	10, -32, 10, -78, 10, -95, 10, -32, 
	10, -78, 10, -65, 10, -32, 10, -78, 
	10, -90, 10, -32, 10, -78, 10, -92, 
	10, -32, 10, -77, 10, -115, 10, -32, 
	10, -78, 10, -92, 10, -32, 10, -77, 
	10, -127, 10, -32, 10, -77, 10, -115, 
	10, -32, 10, -78, 10, -91, 10, -32, 
	10, -78, 10, -65, 10, -32, 10, -78, 
	10, -92, 10, -32, 10, -78, 10, -65, 
	10, -32, 10, -78, 10, -81, 10, -32, 
	10, -78, 10, -88, 10, -32, 10, -77, 
	10, -115, 10, -32, 10, -78, 10, -88, 
	10, -32, 10, -77, 10, -122, 10, -32, 
	10, -78, 10, -102, 10, -32, 10, -77, 
	10, -115, 10, -32, 10, -78, 10, -102, 
	10, -32, 10, -78, 10, -77, 10, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, -32, -77, -115, -32, -78, 
	-91, -32, -78, -65, -32, -78, -92, -32, 
	-78, -65, -32, -78, -81, -32, -78, -88, 
	-32, -77, -115, -32, -78, -88, -32, -78, 
	-77, -65, -32, -78, -88, -32, -77, -115, 
	-32, -78, -88, -32, -77, -122, -32, -78, 
	-78, -32, -77, -122, 58, 10, 10, -32, 
	10, 32, 35, 37, 42, 64, 9, 13, 
	-78, 10, -122, -107, -88, -82, -75, -72, 
	-71, 10, -32, 10, -78, 10, -90, 10, 
	-32, 10, -78, 10, -80, 10, -32, 10, 
	-77, 10, -122, 10, 10, 32, -32, 10, 
	-78, 10, -91, 10, -32, 10, -78, 10, 
	-66, 10, -32, 10, -78, 10, -72, 10, 
	-32, 10, -78, 10, -66, 10, -32, 10, 
	-78, 10, -80, 10, -32, 10, -78, 10, 
	-66, 10, -32, 10, -78, 10, -126, 10, 
	-32, 10, -78, 10, -74, 10, 10, 58, 
	-32, 10, -78, 10, -126, -65, 10, -32, 
	10, -78, 10, -92, 10, -32, 10, -78, 
	10, -80, 10, -32, 10, -77, 10, -107, 
	10, -32, 10, -78, 10, -95, 10, -32, 
	10, -78, 10, -65, 10, -32, 10, -78, 
	10, -90, 10, -32, 10, -78, 10, -92, 
	10, -32, 10, -77, 10, -115, 10, -32, 
	10, -78, 10, -92, 10, -32, 10, -77, 
	10, -127, 10, -32, 10, -78, 10, -65, 
	10, -32, 10, -78, 10, -75, 10, -32, 
	10, -78, 10, -80, 10, -32, 10, -78, 
	10, -93, 10, -32, 10, -77, 10, -122, 
	10, -32, 10, -77, 10, -115, 10, -32, 
	10, -78, 10, -91, 10, -32, 10, -78, 
	10, -65, 10, -32, 10, -78, 10, -92, 
	10, -32, 10, -78, 10, -65, 10, -32, 
	10, -78, 10, -81, 10, -32, 10, -78, 
	10, -88, 10, -32, 10, -77, 10, -115, 
	10, -32, 10, -78, 10, -88, 10, -32, 
	10, -77, 10, -122, 10, -32, 10, -78, 
	10, -102, 10, -32, 10, -77, 10, -115, 
	10, -32, 10, -78, 10, -102, 10, -32, 
	10, -78, 10, -77, 10, 10, 95, 10, 
	70, 10, 69, 10, 65, 10, 84, 10, 
	85, 10, 82, 10, 69, 10, 95, 10, 
	69, 10, 78, 10, 68, 10, 95, 10, 
	37, -122, -32, -78, -102, -32, -77, -115, 
	-32, -78, -102, -32, -78, -77, 58, 10, 
	10, -32, 10, 32, 35, 37, 64, 9, 
	13, -78, 10, -119, -107, -75, -71, 10, 
	-32, 10, -78, 10, -90, 10, -32, 10, 
	-78, 10, -66, 10, -32, 10, -78, 10, 
	-71, 10, -32, 10, -78, 10, -80, 10, 
	-32, 10, -78, 10, -93, 10, -32, 10, 
	-77, 10, -122, 10, -32, 10, -78, 10, 
	-105, 10, -32, 10, -78, 10, -77, 10, 
	-32, 10, -77, 10, -127, 10, 10, 58, 
	-32, 10, -78, 10, -91, 10, -32, 10, 
	-78, 10, -66, 10, -32, 10, -78, 10, 
	-72, 10, -32, 10, -78, 10, -66, 10, 
	-32, 10, -78, 10, -80, 10, -32, 10, 
	-78, 10, -66, 10, -32, 10, -78, 10, 
	-126, 10, -32, 10, -78, 10, -74, 10, 
	-32, 10, -78, 10, -65, 10, -32, 10, 
	-78, 10, -75, 10, -32, 10, -78, 10, 
	-80, 10, -32, 10, -78, 10, -93, 10, 
	-32, 10, -77, 10, -122, 10, -32, 10, 
	-78, -77, 10, -65, 10, -32, 10, -78, 
	10, -88, 10, -32, 10, -77, 10, -115, 
	10, -32, 10, -78, 10, -88, 10, -32, 
	10, -77, 10, -122, 10, -32, 10, -78, 
	10, -78, 10, -122, 10, -32, 10, -78, 
	10, -102, 10, -32, 10, -77, 10, -115, 
	10, -32, 10, -78, 10, -102, 10, -32, 
	10, -78, 10, -77, 10, 10, 95, 10, 
	70, 10, 69, 10, 65, 10, 84, 10, 
	85, 10, 82, 10, 69, 10, 95, 10, 
	69, 10, 78, 10, 68, 10, 95, 10, 
	37, -69, -65, 0
};

static const char _lexer_single_lengths[] = {
	0, 10, 1, 8, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 2, 2, 
	9, 1, 1, 2, 2, 3, 3, 3, 
	3, 2, 2, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 3, 5, 3, 2, 4, 
	3, 2, 4, 9, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 5, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 9, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 7, 2, 8, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 7, 2, 7, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 7, 2, 8, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 6, 2, 5, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 1, 1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 1, 1, 1, 
	1, 1, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 1, 1, 1, 1, 
	0, 0, 1, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 12, 14, 23, 25, 27, 29, 
	31, 33, 35, 37, 39, 41, 43, 46, 
	49, 60, 62, 64, 67, 70, 75, 80, 
	85, 90, 94, 98, 101, 103, 105, 107, 
	109, 111, 113, 115, 117, 119, 121, 123, 
	125, 127, 129, 131, 136, 143, 148, 152, 
	158, 162, 165, 171, 182, 184, 186, 188, 
	190, 192, 194, 196, 198, 200, 202, 204, 
	206, 208, 210, 212, 214, 216, 218, 220, 
	222, 224, 226, 228, 230, 232, 234, 236, 
	238, 240, 242, 249, 252, 255, 258, 261, 
	264, 267, 270, 273, 276, 279, 282, 285, 
	288, 291, 294, 297, 300, 303, 314, 316, 
	318, 320, 322, 324, 326, 328, 330, 332, 
	334, 336, 338, 340, 342, 344, 346, 348, 
	350, 352, 354, 356, 358, 360, 362, 364, 
	366, 368, 377, 380, 389, 392, 395, 398, 
	401, 404, 407, 410, 413, 416, 419, 422, 
	425, 428, 431, 434, 437, 440, 443, 446, 
	449, 452, 455, 458, 461, 464, 467, 470, 
	473, 476, 479, 482, 485, 488, 491, 494, 
	497, 500, 504, 507, 510, 513, 516, 519, 
	522, 525, 528, 531, 534, 537, 540, 543, 
	546, 549, 552, 555, 558, 561, 564, 567, 
	570, 573, 576, 579, 582, 585, 588, 591, 
	594, 597, 600, 603, 606, 609, 612, 615, 
	618, 621, 624, 627, 630, 633, 636, 639, 
	642, 645, 648, 651, 654, 657, 660, 663, 
	666, 669, 672, 675, 678, 681, 684, 687, 
	690, 693, 696, 699, 702, 705, 708, 711, 
	714, 717, 720, 723, 727, 730, 733, 736, 
	739, 742, 745, 748, 751, 754, 757, 760, 
	763, 766, 769, 772, 775, 778, 781, 784, 
	787, 790, 793, 796, 799, 802, 805, 808, 
	811, 814, 817, 820, 823, 826, 829, 832, 
	835, 838, 841, 844, 847, 850, 853, 856, 
	858, 860, 863, 865, 867, 869, 871, 873, 
	875, 877, 879, 881, 883, 885, 887, 889, 
	891, 893, 895, 897, 899, 901, 903, 905, 
	907, 909, 911, 913, 915, 917, 919, 921, 
	923, 925, 927, 929, 931, 933, 935, 937, 
	939, 941, 943, 945, 947, 949, 951, 953, 
	955, 957, 959, 968, 971, 979, 982, 985, 
	988, 991, 994, 997, 1000, 1003, 1006, 1009, 
	1012, 1015, 1018, 1021, 1024, 1027, 1030, 1033, 
	1036, 1039, 1042, 1045, 1048, 1051, 1054, 1057, 
	1060, 1063, 1066, 1069, 1072, 1075, 1078, 1081, 
	1084, 1087, 1090, 1094, 1097, 1100, 1103, 1106, 
	1109, 1112, 1115, 1118, 1121, 1124, 1127, 1130, 
	1133, 1136, 1139, 1142, 1145, 1148, 1151, 1154, 
	1157, 1160, 1163, 1166, 1169, 1172, 1175, 1178, 
	1181, 1184, 1187, 1190, 1193, 1196, 1199, 1202, 
	1205, 1208, 1211, 1214, 1217, 1220, 1223, 1226, 
	1229, 1232, 1235, 1238, 1241, 1244, 1247, 1250, 
	1253, 1256, 1259, 1262, 1265, 1268, 1271, 1274, 
	1277, 1280, 1283, 1286, 1289, 1292, 1295, 1298, 
	1301, 1304, 1307, 1310, 1313, 1316, 1319, 1322, 
	1325, 1328, 1331, 1334, 1337, 1340, 1343, 1346, 
	1349, 1352, 1354, 1356, 1358, 1360, 1362, 1364, 
	1366, 1368, 1370, 1372, 1374, 1376, 1378, 1380, 
	1382, 1384, 1386, 1388, 1390, 1392, 1394, 1396, 
	1398, 1400, 1402, 1404, 1406, 1408, 1411, 1413, 
	1415, 1417, 1419, 1421, 1423, 1425, 1427, 1429, 
	1431, 1433, 1435, 1437, 1439, 1441, 1443, 1445, 
	1447, 1449, 1451, 1453, 1455, 1464, 1467, 1476, 
	1479, 1482, 1485, 1488, 1491, 1494, 1497, 1500, 
	1503, 1506, 1509, 1512, 1515, 1518, 1521, 1524, 
	1527, 1530, 1533, 1536, 1539, 1542, 1545, 1548, 
	1551, 1554, 1557, 1560, 1563, 1566, 1569, 1572, 
	1575, 1578, 1581, 1584, 1587, 1591, 1594, 1597, 
	1600, 1603, 1606, 1609, 1612, 1615, 1618, 1621, 
	1624, 1627, 1630, 1633, 1636, 1639, 1642, 1645, 
	1648, 1651, 1654, 1657, 1660, 1663, 1666, 1669, 
	1672, 1675, 1678, 1681, 1684, 1687, 1690, 1693, 
	1696, 1699, 1702, 1705, 1708, 1711, 1714, 1717, 
	1720, 1723, 1726, 1729, 1732, 1735, 1738, 1741, 
	1744, 1747, 1750, 1753, 1756, 1759, 1762, 1765, 
	1768, 1771, 1774, 1777, 1780, 1783, 1786, 1789, 
	1792, 1795, 1798, 1801, 1804, 1807, 1810, 1813, 
	1816, 1819, 1822, 1825, 1828, 1831, 1834, 1837, 
	1840, 1843, 1846, 1849, 1852, 1855, 1858, 1861, 
	1864, 1867, 1870, 1873, 1876, 1879, 1882, 1885, 
	1888, 1891, 1894, 1896, 1898, 1900, 1902, 1904, 
	1906, 1908, 1910, 1912, 1914, 1916, 1918, 1920, 
	1922, 1924, 1926, 1934, 1937, 1943, 1946, 1949, 
	1952, 1955, 1958, 1961, 1964, 1967, 1970, 1973, 
	1976, 1979, 1982, 1985, 1988, 1991, 1994, 1997, 
	2000, 2003, 2006, 2009, 2012, 2015, 2018, 2021, 
	2024, 2027, 2030, 2033, 2036, 2039, 2042, 2045, 
	2048, 2051, 2054, 2057, 2060, 2063, 2066, 2069, 
	2072, 2075, 2078, 2081, 2084, 2087, 2090, 2093, 
	2096, 2099, 2102, 2105, 2108, 2111, 2114, 2117, 
	2120, 2123, 2126, 2129, 2132, 2135, 2138, 2141, 
	2144, 2147, 2151, 2154, 2157, 2160, 2163, 2166, 
	2169, 2172, 2175, 2178, 2181, 2184, 2187, 2190, 
	2193, 2196, 2199, 2202, 2205, 2208, 2211, 2214, 
	2217, 2220, 2223, 2226, 2229, 2232, 2235, 2238, 
	2241, 2244, 2247, 2250, 2253, 2256, 2259, 2262, 
	2265, 2268, 2271, 2274, 2277, 2280, 2282, 2284
};

static const short _lexer_trans_targs[] = {
	2, 789, 16, 16, 17, 27, 29, 13, 
	43, 46, 16, 0, 3, 0, 4, 52, 
	102, 287, 308, 320, 465, 492, 0, 5, 
	0, 6, 0, 7, 0, 8, 0, 9, 
	0, 10, 0, 11, 0, 12, 0, 13, 
	0, 14, 0, 16, 28, 15, 16, 28, 
	15, 2, 16, 16, 17, 27, 29, 13, 
	43, 46, 16, 0, 18, 0, 19, 0, 
	21, 20, 20, 21, 20, 20, 22, 22, 
	23, 22, 22, 22, 22, 23, 22, 22, 
	22, 22, 24, 22, 22, 22, 22, 25, 
	22, 22, 16, 26, 26, 0, 16, 26, 
	26, 0, 16, 28, 27, 16, 0, 30, 
	0, 31, 0, 32, 0, 33, 0, 34, 
	0, 35, 0, 36, 0, 37, 0, 38, 
	0, 39, 0, 40, 0, 41, 0, 42, 
	0, 791, 0, 0, 0, 0, 0, 44, 
	45, 16, 45, 45, 43, 44, 44, 16, 
	45, 43, 45, 0, 46, 47, 46, 0, 
	51, 50, 49, 47, 50, 48, 0, 49, 
	47, 48, 0, 49, 48, 51, 50, 49, 
	47, 50, 48, 2, 51, 51, 17, 27, 
	29, 13, 43, 46, 51, 0, 53, 0, 
	54, 0, 55, 0, 56, 0, 57, 0, 
	58, 0, 59, 0, 60, 0, 61, 0, 
	62, 0, 63, 0, 64, 0, 65, 0, 
	66, 0, 67, 0, 68, 0, 69, 0, 
	70, 0, 71, 0, 72, 0, 73, 0, 
	74, 0, 75, 0, 76, 0, 77, 0, 
	78, 0, 79, 0, 80, 0, 82, 81, 
	82, 81, 83, 82, 82, 16, 16, 82, 
	81, 84, 82, 81, 85, 82, 81, 86, 
	82, 81, 87, 82, 81, 88, 82, 81, 
	89, 82, 81, 90, 82, 81, 91, 82, 
	81, 92, 82, 81, 93, 82, 81, 94, 
	82, 81, 95, 82, 81, 96, 82, 81, 
	97, 82, 81, 98, 82, 81, 99, 82, 
	81, 100, 82, 81, 82, 101, 81, 2, 
	16, 16, 17, 27, 29, 13, 43, 46, 
	16, 0, 103, 0, 104, 0, 105, 0, 
	106, 0, 107, 0, 108, 0, 109, 0, 
	110, 0, 111, 0, 112, 0, 113, 0, 
	114, 0, 115, 0, 116, 0, 117, 0, 
	118, 0, 119, 0, 120, 0, 121, 0, 
	122, 0, 123, 0, 124, 0, 125, 0, 
	126, 0, 127, 0, 129, 128, 129, 128, 
	130, 129, 129, 16, 273, 141, 16, 129, 
	128, 131, 129, 128, 132, 142, 167, 188, 
	200, 215, 242, 129, 128, 133, 129, 128, 
	134, 129, 128, 135, 129, 128, 136, 129, 
	128, 137, 129, 128, 138, 129, 128, 139, 
	129, 128, 140, 129, 128, 141, 129, 128, 
	129, 101, 128, 143, 129, 128, 144, 129, 
	128, 145, 129, 128, 146, 129, 128, 147, 
	129, 128, 148, 129, 128, 149, 129, 128, 
	150, 129, 128, 151, 129, 128, 152, 129, 
	128, 153, 129, 128, 154, 129, 128, 155, 
	129, 128, 156, 129, 128, 157, 129, 128, 
	158, 129, 128, 159, 129, 128, 160, 129, 
	128, 161, 129, 128, 162, 129, 128, 163, 
	129, 128, 164, 129, 128, 165, 129, 128, 
	166, 129, 128, 129, 101, 128, 168, 129, 
	128, 169, 129, 128, 170, 176, 129, 128, 
	171, 129, 128, 172, 129, 128, 173, 129, 
	128, 174, 129, 128, 175, 129, 128, 141, 
	129, 128, 177, 129, 128, 178, 129, 128, 
	179, 129, 128, 180, 129, 128, 181, 129, 
	128, 182, 129, 128, 183, 129, 128, 184, 
	129, 128, 185, 129, 128, 186, 129, 128, 
	187, 129, 128, 141, 129, 128, 189, 129, 
	128, 190, 129, 128, 191, 129, 128, 192, 
	129, 128, 193, 129, 128, 194, 129, 128, 
	195, 129, 128, 196, 129, 128, 197, 129, 
	128, 198, 129, 128, 199, 129, 128, 141, 
	129, 128, 201, 129, 128, 202, 129, 128, 
	203, 129, 128, 204, 129, 128, 205, 129, 
	128, 206, 129, 128, 207, 129, 128, 208, 
	129, 128, 209, 129, 128, 210, 129, 128, 
	211, 129, 128, 212, 129, 128, 213, 129, 
	128, 214, 129, 128, 166, 129, 128, 216, 
	129, 128, 217, 129, 128, 218, 129, 128, 
	219, 129, 128, 220, 129, 128, 221, 129, 
	128, 222, 129, 128, 223, 129, 128, 224, 
	129, 128, 225, 129, 128, 226, 129, 128, 
	227, 129, 128, 228, 129, 128, 229, 129, 
	128, 230, 129, 128, 231, 129, 128, 232, 
	129, 128, 233, 129, 128, 234, 129, 128, 
	235, 129, 128, 236, 129, 128, 237, 129, 
	128, 238, 129, 128, 239, 129, 128, 240, 
	129, 128, 241, 129, 128, 197, 129, 128, 
	243, 129, 128, 244, 260, 129, 128, 245, 
	129, 128, 246, 129, 128, 247, 129, 128, 
	248, 129, 128, 249, 129, 128, 250, 129, 
	128, 251, 129, 128, 252, 129, 128, 253, 
	129, 128, 254, 129, 128, 255, 129, 128, 
	256, 129, 128, 257, 129, 128, 258, 129, 
	128, 259, 129, 128, 212, 129, 128, 261, 
	129, 128, 262, 129, 128, 263, 129, 128, 
	264, 129, 128, 265, 129, 128, 266, 129, 
	128, 267, 129, 128, 268, 129, 128, 269, 
	129, 128, 270, 129, 128, 271, 129, 128, 
	272, 129, 128, 166, 129, 128, 129, 274, 
	128, 129, 275, 128, 129, 276, 128, 129, 
	277, 128, 129, 278, 128, 129, 279, 128, 
	129, 280, 128, 129, 281, 128, 129, 282, 
	128, 129, 283, 128, 129, 284, 128, 129, 
	285, 128, 129, 286, 128, 129, 16, 128, 
	288, 0, 289, 0, 290, 296, 0, 291, 
	0, 292, 0, 293, 0, 294, 0, 295, 
	0, 13, 0, 297, 0, 298, 0, 299, 
	0, 300, 0, 301, 0, 302, 0, 303, 
	0, 304, 0, 305, 0, 306, 0, 307, 
	0, 13, 0, 309, 0, 310, 0, 311, 
	0, 312, 0, 313, 0, 314, 0, 315, 
	0, 316, 0, 317, 0, 318, 0, 319, 
	0, 13, 0, 321, 0, 322, 0, 323, 
	0, 324, 0, 325, 0, 326, 0, 327, 
	0, 328, 0, 329, 0, 330, 0, 331, 
	0, 332, 0, 333, 0, 334, 0, 335, 
	0, 336, 0, 338, 337, 338, 337, 339, 
	338, 338, 16, 451, 350, 16, 338, 337, 
	340, 338, 337, 341, 351, 376, 397, 409, 
	436, 338, 337, 342, 338, 337, 343, 338, 
	337, 344, 338, 337, 345, 338, 337, 346, 
	338, 337, 347, 338, 337, 348, 338, 337, 
	349, 338, 337, 350, 338, 337, 338, 101, 
	337, 352, 338, 337, 353, 338, 337, 354, 
	338, 337, 355, 338, 337, 356, 338, 337, 
	357, 338, 337, 358, 338, 337, 359, 338, 
	337, 360, 338, 337, 361, 338, 337, 362, 
	338, 337, 363, 338, 337, 364, 338, 337, 
	365, 338, 337, 366, 338, 337, 367, 338, 
	337, 368, 338, 337, 369, 338, 337, 370, 
	338, 337, 371, 338, 337, 372, 338, 337, 
	373, 338, 337, 374, 338, 337, 375, 338, 
	337, 338, 101, 337, 377, 338, 337, 378, 
	338, 337, 379, 385, 338, 337, 380, 338, 
	337, 381, 338, 337, 382, 338, 337, 383, 
	338, 337, 384, 338, 337, 350, 338, 337, 
	386, 338, 337, 387, 338, 337, 388, 338, 
	337, 389, 338, 337, 390, 338, 337, 391, 
	338, 337, 392, 338, 337, 393, 338, 337, 
	394, 338, 337, 395, 338, 337, 396, 338, 
	337, 350, 338, 337, 398, 338, 337, 399, 
	338, 337, 400, 338, 337, 401, 338, 337, 
	402, 338, 337, 403, 338, 337, 404, 338, 
	337, 405, 338, 337, 406, 338, 337, 407, 
	338, 337, 408, 338, 337, 350, 338, 337, 
	410, 338, 337, 411, 338, 337, 412, 338, 
	337, 413, 338, 337, 414, 338, 337, 415, 
	338, 337, 416, 338, 337, 417, 338, 337, 
	418, 338, 337, 419, 338, 337, 420, 338, 
	337, 421, 338, 337, 422, 338, 337, 423, 
	338, 337, 424, 338, 337, 425, 338, 337, 
	426, 338, 337, 427, 338, 337, 428, 338, 
	337, 429, 338, 337, 430, 338, 337, 431, 
	338, 337, 432, 338, 337, 433, 338, 337, 
	434, 338, 337, 435, 338, 337, 406, 338, 
	337, 437, 338, 337, 438, 338, 337, 439, 
	338, 337, 440, 338, 337, 441, 338, 337, 
	442, 338, 337, 443, 338, 337, 444, 338, 
	337, 445, 338, 337, 446, 338, 337, 447, 
	338, 337, 448, 338, 337, 449, 338, 337, 
	450, 338, 337, 375, 338, 337, 338, 452, 
	337, 338, 453, 337, 338, 454, 337, 338, 
	455, 337, 338, 456, 337, 338, 457, 337, 
	338, 458, 337, 338, 459, 337, 338, 460, 
	337, 338, 461, 337, 338, 462, 337, 338, 
	463, 337, 338, 464, 337, 338, 16, 337, 
	466, 0, 467, 0, 468, 0, 469, 0, 
	470, 0, 471, 0, 472, 0, 473, 0, 
	474, 0, 475, 0, 476, 0, 477, 0, 
	478, 0, 479, 0, 480, 0, 481, 0, 
	482, 0, 483, 0, 484, 0, 485, 0, 
	486, 0, 487, 0, 488, 0, 489, 0, 
	490, 0, 491, 0, 317, 0, 493, 0, 
	494, 658, 0, 495, 0, 496, 0, 497, 
	0, 498, 0, 499, 0, 500, 0, 501, 
	0, 502, 0, 503, 0, 504, 0, 505, 
	0, 506, 0, 507, 0, 508, 0, 509, 
	0, 510, 0, 511, 0, 512, 0, 513, 
	0, 514, 0, 516, 515, 516, 515, 517, 
	516, 516, 16, 644, 528, 16, 516, 515, 
	518, 516, 515, 519, 529, 554, 575, 587, 
	602, 629, 516, 515, 520, 516, 515, 521, 
	516, 515, 522, 516, 515, 523, 516, 515, 
	524, 516, 515, 525, 516, 515, 526, 516, 
	515, 527, 516, 515, 528, 516, 515, 516, 
	101, 515, 530, 516, 515, 531, 516, 515, 
	532, 516, 515, 533, 516, 515, 534, 516, 
	515, 535, 516, 515, 536, 516, 515, 537, 
	516, 515, 538, 516, 515, 539, 516, 515, 
	540, 516, 515, 541, 516, 515, 542, 516, 
	515, 543, 516, 515, 544, 516, 515, 545, 
	516, 515, 546, 516, 515, 547, 516, 515, 
	548, 516, 515, 549, 516, 515, 550, 516, 
	515, 551, 516, 515, 552, 516, 515, 553, 
	516, 515, 516, 101, 515, 555, 516, 515, 
	556, 516, 515, 557, 563, 516, 515, 558, 
	516, 515, 559, 516, 515, 560, 516, 515, 
	561, 516, 515, 562, 516, 515, 528, 516, 
	515, 564, 516, 515, 565, 516, 515, 566, 
	516, 515, 567, 516, 515, 568, 516, 515, 
	569, 516, 515, 570, 516, 515, 571, 516, 
	515, 572, 516, 515, 573, 516, 515, 574, 
	516, 515, 528, 516, 515, 576, 516, 515, 
	577, 516, 515, 578, 516, 515, 579, 516, 
	515, 580, 516, 515, 581, 516, 515, 582, 
	516, 515, 583, 516, 515, 584, 516, 515, 
	585, 516, 515, 586, 516, 515, 528, 516, 
	515, 588, 516, 515, 589, 516, 515, 590, 
	516, 515, 591, 516, 515, 592, 516, 515, 
	593, 516, 515, 594, 516, 515, 595, 516, 
	515, 596, 516, 515, 597, 516, 515, 598, 
	516, 515, 599, 516, 515, 600, 516, 515, 
	601, 516, 515, 553, 516, 515, 603, 516, 
	515, 604, 516, 515, 605, 516, 515, 606, 
	516, 515, 607, 516, 515, 608, 516, 515, 
	609, 516, 515, 610, 516, 515, 611, 516, 
	515, 612, 516, 515, 613, 516, 515, 614, 
	516, 515, 615, 516, 515, 616, 516, 515, 
	617, 516, 515, 618, 516, 515, 619, 516, 
	515, 620, 516, 515, 621, 516, 515, 622, 
	516, 515, 623, 516, 515, 624, 516, 515, 
	625, 516, 515, 626, 516, 515, 627, 516, 
	515, 628, 516, 515, 584, 516, 515, 630, 
	516, 515, 631, 516, 515, 632, 516, 515, 
	633, 516, 515, 634, 516, 515, 635, 516, 
	515, 636, 516, 515, 637, 516, 515, 638, 
	516, 515, 639, 516, 515, 640, 516, 515, 
	641, 516, 515, 642, 516, 515, 643, 516, 
	515, 553, 516, 515, 516, 645, 515, 516, 
	646, 515, 516, 647, 515, 516, 648, 515, 
	516, 649, 515, 516, 650, 515, 516, 651, 
	515, 516, 652, 515, 516, 653, 515, 516, 
	654, 515, 516, 655, 515, 516, 656, 515, 
	516, 657, 515, 516, 16, 515, 659, 0, 
	660, 0, 661, 0, 662, 0, 663, 0, 
	664, 0, 665, 0, 666, 0, 667, 0, 
	668, 0, 669, 0, 670, 0, 671, 0, 
	672, 0, 674, 673, 674, 673, 675, 674, 
	674, 16, 775, 16, 674, 673, 676, 674, 
	673, 677, 705, 729, 744, 674, 673, 678, 
	674, 673, 679, 674, 673, 680, 674, 673, 
	681, 674, 673, 682, 674, 673, 683, 674, 
	673, 684, 674, 673, 685, 674, 673, 686, 
	674, 673, 687, 674, 673, 688, 674, 673, 
	689, 674, 673, 690, 674, 673, 691, 674, 
	673, 692, 674, 673, 693, 674, 673, 694, 
	674, 673, 695, 674, 673, 696, 674, 673, 
	697, 674, 673, 698, 674, 673, 699, 674, 
	673, 700, 674, 673, 701, 674, 673, 702, 
	674, 673, 703, 674, 673, 704, 674, 673, 
	674, 101, 673, 706, 674, 673, 707, 674, 
	673, 708, 674, 673, 709, 674, 673, 710, 
	674, 673, 711, 674, 673, 712, 674, 673, 
	713, 674, 673, 714, 674, 673, 715, 674, 
	673, 716, 674, 673, 717, 674, 673, 718, 
	674, 673, 719, 674, 673, 720, 674, 673, 
	721, 674, 673, 722, 674, 673, 723, 674, 
	673, 724, 674, 673, 725, 674, 673, 726, 
	674, 673, 727, 674, 673, 728, 674, 673, 
	704, 674, 673, 730, 674, 673, 731, 674, 
	673, 732, 674, 673, 733, 674, 673, 734, 
	674, 673, 735, 674, 673, 736, 674, 673, 
	737, 674, 673, 738, 674, 673, 739, 674, 
	673, 740, 674, 673, 741, 674, 673, 742, 
	674, 673, 743, 674, 673, 704, 674, 673, 
	745, 674, 673, 746, 762, 674, 673, 747, 
	674, 673, 748, 674, 673, 749, 674, 673, 
	750, 674, 673, 751, 674, 673, 752, 674, 
	673, 753, 674, 673, 754, 674, 673, 755, 
	674, 673, 756, 674, 673, 757, 674, 673, 
	758, 674, 673, 759, 674, 673, 760, 674, 
	673, 761, 674, 673, 741, 674, 673, 763, 
	674, 673, 764, 674, 673, 765, 674, 673, 
	766, 674, 673, 767, 674, 673, 768, 674, 
	673, 769, 674, 673, 770, 674, 673, 771, 
	674, 673, 772, 674, 673, 773, 674, 673, 
	774, 674, 673, 704, 674, 673, 674, 776, 
	673, 674, 777, 673, 674, 778, 673, 674, 
	779, 673, 674, 780, 673, 674, 781, 673, 
	674, 782, 673, 674, 783, 673, 674, 784, 
	673, 674, 785, 673, 674, 786, 673, 674, 
	787, 673, 674, 788, 673, 674, 16, 673, 
	790, 0, 16, 0, 0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	29, 0, 54, 0, 5, 1, 0, 29, 
	1, 35, 0, 43, 0, 43, 0, 0, 
	0, 0, 0, 0, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 149, 126, 57, 110, 23, 
	0, 29, 54, 0, 5, 1, 0, 29, 
	1, 35, 0, 43, 0, 43, 0, 43, 
	139, 48, 9, 106, 11, 0, 134, 45, 
	45, 45, 3, 122, 33, 33, 33, 0, 
	122, 33, 33, 33, 0, 122, 33, 0, 
	33, 0, 102, 7, 7, 43, 54, 0, 
	0, 43, 114, 25, 0, 54, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 43, 43, 43, 43, 0, 
	27, 118, 27, 27, 51, 27, 0, 54, 
	0, 1, 0, 43, 0, 0, 0, 43, 
	54, 37, 37, 87, 37, 37, 43, 0, 
	39, 0, 43, 0, 0, 54, 0, 0, 
	39, 0, 0, 96, 54, 0, 93, 90, 
	41, 96, 90, 99, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 144, 57, 
	54, 0, 84, 54, 0, 81, 81, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 21, 0, 63, 
	130, 31, 60, 57, 31, 63, 57, 66, 
	31, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 144, 57, 54, 0, 
	84, 54, 0, 75, 33, 84, 75, 0, 
	0, 0, 54, 0, 0, 0, 0, 0, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 17, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 17, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 17, 0, 
	0, 43, 0, 43, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 144, 57, 54, 0, 84, 
	54, 0, 78, 33, 84, 78, 0, 0, 
	0, 54, 0, 0, 0, 0, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 19, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 19, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 19, 0, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 144, 57, 54, 0, 84, 
	54, 0, 72, 33, 84, 72, 0, 0, 
	0, 54, 0, 0, 0, 0, 0, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	15, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 15, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 15, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 144, 57, 54, 0, 84, 54, 
	0, 69, 33, 69, 0, 0, 0, 54, 
	0, 0, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 13, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 13, 0, 
	0, 43, 0, 43, 0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 791;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "ragel/i18n/kn.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  /* Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters */
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1569 "ext/gherkin_lexer_kn/gherkin_lexer_kn.c"
	{
	cs = lexer_start;
	}

#line 425 "ragel/i18n/kn.c.rl"
    
#line 1576 "ext/gherkin_lexer_kn/gherkin_lexer_kn.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "ragel/i18n/kn.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "ragel/i18n/kn.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "ragel/i18n/kn.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "ragel/i18n/kn.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "ragel/i18n/kn.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "ragel/i18n/kn.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "ragel/i18n/kn.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "ragel/i18n/kn.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "ragel/i18n/kn.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "ragel/i18n/kn.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "ragel/i18n/kn.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "ragel/i18n/kn.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "ragel/i18n/kn.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "ragel/i18n/kn.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "ragel/i18n/kn.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "ragel/i18n/kn.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "ragel/i18n/kn.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "ragel/i18n/kn.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "ragel/i18n/kn.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "ragel/i18n/kn.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "ragel/i18n/kn.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "ragel/i18n/kn.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "ragel/i18n/kn.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "ragel/i18n/kn.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1866 "ext/gherkin_lexer_kn/gherkin_lexer_kn.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "ragel/i18n/kn.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1929 "ext/gherkin_lexer_kn/gherkin_lexer_kn.c"
		}
	}
	}

	_out: {}
	}

#line 426 "ragel/i18n/kn.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    /* Reset lexer by re-initializing the whole thing */
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_kn()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Kn", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

