/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file CProfileTab.h
    \author Romain BONDUE
    \date 05/08/2005 */
#ifndef __CPROFILETAB_H__
#define __CPROFILETAB_H__

#include "CSelectableRowList.h"



namespace nsUserData{class CProfile;}



namespace nsWireless {class CCell;}



namespace nsGUI
{
    class CProfileTab : protected CSelectableRowList
    {
      public :
        CProfileTab (CGtkGUI*) throw();
        operator ::GtkWidget* () throw();

        void AddProfile (const nsUserData::CProfile&) throw();
        int GetSelectedRow () const throw();
        void SetSelected (unsigned, bool) throw();
        using CSelectableRowList::Clear;


      protected :
        enum {ButtonPos, NamePos, SSIDPos, ModePos, ChannelPos, EncryptPos,
              AuthPos};
        void SetProfile (unsigned, const nsUserData::CProfile&) throw();
        void RowSelectedCallBack () throw();
        void RowUnselectedCallBack () throw();
        /** \return true if the profile has been modified. */
        bool Edit (nsUserData::CProfile&) const throw();


      private :
        ::GtkBox* const m_pHBox;
        ::GtkWidget* const m_pDeleteButton;
        ::GtkWidget* const m_pEditButton;
        ::GtkWidget* const m_pApplyButton;

        static const unsigned NbColumn = 7;
        static const char* ColumnTitle [NbColumn];
        static const ::GType TabType [NbColumn];

        static void DeleteButtonCallBack (::GtkButton*, CProfileTab*) throw();
        static void EditButtonCallBack (::GtkButton*, CProfileTab*) throw();
        static void ApplyButtonCallBack (::GtkButton*, CProfileTab*) throw();
        static void NewProfileButtonCallBack (::GtkButton*, CProfileTab*)
                                                                    throw();
    }; // CProfileTab

} // namespace nsGUI

#include "private/CProfileTab.hxx"

#endif // __CPROFILETAB_H__
