/* ThumbnailCache.c generated by valac 0.40.4, the Vala compiler
 * generated from ThumbnailCache.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_THUMBNAILS (thumbnails_get_type ())
#define THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAILS, Thumbnails))
#define THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAILS, ThumbnailsClass))
#define IS_THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAILS))
#define IS_THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAILS))
#define THUMBNAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAILS, ThumbnailsClass))

typedef struct _Thumbnails Thumbnails;
typedef struct _ThumbnailsClass ThumbnailsClass;
typedef struct _ThumbnailsPrivate ThumbnailsPrivate;

#define THUMBNAIL_CACHE_TYPE_SIZE (thumbnail_cache_size_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecThumbnails ParamSpecThumbnails;

#define TYPE_THUMBNAIL_CACHE (thumbnail_cache_get_type ())
#define THUMBNAIL_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_CACHE, ThumbnailCache))
#define THUMBNAIL_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_CACHE, ThumbnailCacheClass))
#define IS_THUMBNAIL_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_CACHE))
#define IS_THUMBNAIL_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_CACHE))
#define THUMBNAIL_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_CACHE, ThumbnailCacheClass))

typedef struct _ThumbnailCache ThumbnailCache;
typedef struct _ThumbnailCacheClass ThumbnailCacheClass;
typedef struct _ThumbnailCachePrivate ThumbnailCachePrivate;

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())

#define THUMBNAIL_CACHE_TYPE_IMAGE_DATA (thumbnail_cache_image_data_get_type ())
#define THUMBNAIL_CACHE_IMAGE_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), THUMBNAIL_CACHE_TYPE_IMAGE_DATA, ThumbnailCacheImageData))
#define THUMBNAIL_CACHE_IMAGE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), THUMBNAIL_CACHE_TYPE_IMAGE_DATA, ThumbnailCacheImageDataClass))
#define THUMBNAIL_CACHE_IS_IMAGE_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), THUMBNAIL_CACHE_TYPE_IMAGE_DATA))
#define THUMBNAIL_CACHE_IS_IMAGE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), THUMBNAIL_CACHE_TYPE_IMAGE_DATA))
#define THUMBNAIL_CACHE_IMAGE_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), THUMBNAIL_CACHE_TYPE_IMAGE_DATA, ThumbnailCacheImageDataClass))

typedef struct _ThumbnailCacheImageData ThumbnailCacheImageData;
typedef struct _ThumbnailCacheImageDataClass ThumbnailCacheImageDataClass;
enum  {
	THUMBNAIL_CACHE_0_PROPERTY,
	THUMBNAIL_CACHE_NUM_PROPERTIES
};
static GParamSpec* thumbnail_cache_properties[THUMBNAIL_CACHE_NUM_PROPERTIES];

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
typedef struct _Scaling Scaling;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;

#define TYPE_ONE_SHOT_SCHEDULER (one_shot_scheduler_get_type ())
#define ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotScheduler))
#define ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))
#define IS_ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ONE_SHOT_SCHEDULER))
#define IS_ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ONE_SHOT_SCHEDULER))
#define ONE_SHOT_SCHEDULER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))

typedef struct _OneShotScheduler OneShotScheduler;
typedef struct _OneShotSchedulerClass OneShotSchedulerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _one_shot_scheduler_unref0(var) ((var == NULL) ? NULL : (var = (one_shot_scheduler_unref (var), NULL)))
#define _workers_unref0(var) ((var == NULL) ? NULL : (var = (workers_unref (var), NULL)))

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_ROTATION (rotation_get_type ())

#define TYPE_PHOTO_FILE_ADAPTER (photo_file_adapter_get_type ())
#define PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter))
#define PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))
#define IS_PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_ADAPTER))
#define IS_PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_ADAPTER))
#define PHOTO_FILE_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))

typedef struct _PhotoFileAdapter PhotoFileAdapter;
typedef struct _PhotoFileAdapterClass PhotoFileAdapterClass;

#define TYPE_PHOTO_FILE_READER (photo_file_reader_get_type ())
#define PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReader))
#define PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))
#define IS_PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_READER))
#define IS_PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_READER))
#define PHOTO_FILE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))

typedef struct _PhotoFileReader PhotoFileReader;
typedef struct _PhotoFileReaderClass PhotoFileReaderClass;

#define TYPE_ORIENTATION (orientation_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_BACKGROUND_JOB (background_job_get_type ())
#define BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_JOB, BackgroundJob))
#define BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_JOB, BackgroundJobClass))
#define IS_BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_JOB))
#define IS_BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_JOB))
#define BACKGROUND_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_JOB, BackgroundJobClass))

typedef struct _BackgroundJob BackgroundJob;
typedef struct _BackgroundJobClass BackgroundJobClass;

#define THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB (thumbnail_cache_async_fetch_job_get_type ())
#define THUMBNAIL_CACHE_ASYNC_FETCH_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJob))
#define THUMBNAIL_CACHE_ASYNC_FETCH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJobClass))
#define THUMBNAIL_CACHE_IS_ASYNC_FETCH_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB))
#define THUMBNAIL_CACHE_IS_ASYNC_FETCH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB))
#define THUMBNAIL_CACHE_ASYNC_FETCH_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJobClass))

typedef struct _ThumbnailCacheAsyncFetchJob ThumbnailCacheAsyncFetchJob;
typedef struct _ThumbnailCacheAsyncFetchJobClass ThumbnailCacheAsyncFetchJobClass;
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))
typedef struct _BackgroundJobPrivate BackgroundJobPrivate;

#define BACKGROUND_JOB_TYPE_JOB_PRIORITY (background_job_job_priority_get_type ())
typedef struct _ThumbnailCacheAsyncFetchJobPrivate ThumbnailCacheAsyncFetchJobPrivate;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))
typedef struct _ThumbnailCacheImageDataPrivate ThumbnailCacheImageDataPrivate;
#define _thumbnail_cache_image_data_unref0(var) ((var == NULL) ? NULL : (var = (thumbnail_cache_image_data_unref (var), NULL)))

#define TYPE_PHOTO_FILE_WRITER (photo_file_writer_get_type ())
#define PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriter))
#define PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))
#define IS_PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_WRITER))
#define IS_PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_WRITER))
#define PHOTO_FILE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))

typedef struct _PhotoFileWriter PhotoFileWriter;
typedef struct _PhotoFileWriterClass PhotoFileWriterClass;
typedef struct _ThumbnailCacheParamSpecImageData ThumbnailCacheParamSpecImageData;

#define TYPE_ABSTRACT_SEMAPHORE (abstract_semaphore_get_type ())
#define ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore))
#define ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))
#define IS_ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_SEMAPHORE))
#define IS_ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_SEMAPHORE))
#define ABSTRACT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))

typedef struct _AbstractSemaphore AbstractSemaphore;
typedef struct _AbstractSemaphoreClass AbstractSemaphoreClass;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Thumbnails {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ThumbnailsPrivate * priv;
};

struct _ThumbnailsClass {
	GTypeClass parent_class;
	void (*finalize) (Thumbnails *self);
};

typedef enum  {
	THUMBNAIL_CACHE_SIZE_LARGEST = 360,
	THUMBNAIL_CACHE_SIZE_BIG = 360,
	THUMBNAIL_CACHE_SIZE_MEDIUM = 128,
	THUMBNAIL_CACHE_SIZE_SMALLEST = 128
} ThumbnailCacheSize;

struct _ThumbnailsPrivate {
	GeeHashMap* map;
};

struct _ParamSpecThumbnails {
	GParamSpec parent_instance;
};

struct _ThumbnailCache {
	GObject parent_instance;
	ThumbnailCachePrivate * priv;
};

struct _ThumbnailCacheClass {
	GObjectClass parent_class;
};

typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

struct _ThumbnailCachePrivate {
	GFile* cache_dir;
	ThumbnailCacheSize size;
	gulong max_cached_bytes;
	GdkInterpType interp;
	JpegQuality quality;
	GeeHashMap* cache_map;
	GeeArrayList* cache_lru;
	gulong cached_bytes;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Dimensions {
	gint width;
	gint height;
};

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

typedef void (*OneShotCallback) (void* user_data);
typedef void (*ThumbnailCacheAsyncFetchCallback) (GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err, void* user_data);
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

typedef enum  {
	ROTATION_CLOCKWISE,
	ROTATION_COUNTERCLOCKWISE,
	ROTATION_MIRROR,
	ROTATION_UPSIDE_DOWN
} Rotation;

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

typedef enum  {
	BACKGROUND_JOB_JOB_PRIORITY_HIGHEST = 100,
	BACKGROUND_JOB_JOB_PRIORITY_HIGH = 75,
	BACKGROUND_JOB_JOB_PRIORITY_NORMAL = 50,
	BACKGROUND_JOB_JOB_PRIORITY_LOW = 25,
	BACKGROUND_JOB_JOB_PRIORITY_LOWEST = 0
} BackgroundJobJobPriority;

struct _BackgroundJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackgroundJobPrivate * priv;
};

struct _BackgroundJobClass {
	GTypeClass parent_class;
	void (*finalize) (BackgroundJob *self);
	void (*execute) (BackgroundJob* self);
	BackgroundJobJobPriority (*get_priority) (BackgroundJob* self);
};

struct _ThumbnailCacheAsyncFetchJob {
	BackgroundJob parent_instance;
	ThumbnailCacheAsyncFetchJobPrivate * priv;
	ThumbnailCache* cache;
	gchar* thumbnail_name;
	ThumbnailSource* source;
	PhotoFileFormat source_format;
	Dimensions dim;
	GdkInterpType interp;
	ThumbnailCacheAsyncFetchCallback callback;
	gpointer callback_target;
	GdkPixbuf* unscaled;
	GdkPixbuf* scaled;
	GError* err;
	gboolean fetched;
	gboolean replace;
};

struct _ThumbnailCacheAsyncFetchJobClass {
	BackgroundJobClass parent_class;
};

struct _ThumbnailCacheImageData {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ThumbnailCacheImageDataPrivate * priv;
	GdkPixbuf* pixbuf;
	gulong bytes;
};

struct _ThumbnailCacheImageDataClass {
	GTypeClass parent_class;
	void (*finalize) (ThumbnailCacheImageData *self);
};

typedef enum  {
	PHOTO_FORMAT_ERROR_READ_ONLY
} PhotoFormatError;
#define PHOTO_FORMAT_ERROR photo_format_error_quark ()
struct _ThumbnailCacheParamSpecImageData {
	GParamSpec parent_instance;
};

typedef void (*CompletionCallback) (BackgroundJob* job, void* user_data);
typedef void (*CancellationCallback) (BackgroundJob* job, void* user_data);

static gpointer thumbnails_parent_class = NULL;
static gpointer thumbnail_cache_parent_class = NULL;
static ThumbnailCacheSize* thumbnail_cache_ALL_SIZES;
static gint thumbnail_cache_ALL_SIZES_length1;
static ThumbnailCacheSize* thumbnail_cache_ALL_SIZES = NULL;
static gint thumbnail_cache_ALL_SIZES_length1 = 0;
static gint _thumbnail_cache_ALL_SIZES_size_ = 0;
static Workers* thumbnail_cache_fetch_workers;
static Workers* thumbnail_cache_fetch_workers = NULL;
static ThumbnailCache* thumbnail_cache_big;
static ThumbnailCache* thumbnail_cache_big = NULL;
static ThumbnailCache* thumbnail_cache_medium;
static ThumbnailCache* thumbnail_cache_medium = NULL;
static OneShotScheduler* thumbnail_cache_debug_scheduler;
static OneShotScheduler* thumbnail_cache_debug_scheduler = NULL;
static gint thumbnail_cache_cycle_fetched_thumbnails;
static gint thumbnail_cache_cycle_fetched_thumbnails = 0;
static gint thumbnail_cache_cycle_async_fetched_thumbnails;
static gint thumbnail_cache_cycle_async_fetched_thumbnails = 0;
static gint thumbnail_cache_cycle_async_resized_thumbnails;
static gint thumbnail_cache_cycle_async_resized_thumbnails = 0;
static gint thumbnail_cache_cycle_overflow_thumbnails;
static gint thumbnail_cache_cycle_overflow_thumbnails = 0;
static gulong thumbnail_cache_cycle_dropped_bytes;
static gulong thumbnail_cache_cycle_dropped_bytes = (gulong) 0;
static gpointer thumbnail_cache_image_data_parent_class = NULL;
static gpointer thumbnail_cache_async_fetch_job_parent_class = NULL;

gpointer thumbnails_ref (gpointer instance);
void thumbnails_unref (gpointer instance);
GParamSpec* param_spec_thumbnails (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_thumbnails (GValue* value,
                           gpointer v_object);
void value_take_thumbnails (GValue* value,
                            gpointer v_object);
gpointer value_get_thumbnails (const GValue* value);
GType thumbnails_get_type (void) G_GNUC_CONST;
GType thumbnail_cache_size_get_type (void) G_GNUC_CONST;
#define THUMBNAILS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_THUMBNAILS, ThumbnailsPrivate))
Thumbnails* thumbnails_new (void);
Thumbnails* thumbnails_construct (GType object_type);
void thumbnails_set (Thumbnails* self,
                     ThumbnailCacheSize size,
                     GdkPixbuf* pixbuf);
void thumbnails_remove (Thumbnails* self,
                        ThumbnailCacheSize size);
GdkPixbuf* thumbnails_get (Thumbnails* self,
                           ThumbnailCacheSize size);
static void thumbnails_finalize (Thumbnails * obj);
GType thumbnail_cache_get_type (void) G_GNUC_CONST;
GType jpeg_quality_get_type (void) G_GNUC_CONST;
static gpointer thumbnail_cache_image_data_ref (gpointer instance);
static void thumbnail_cache_image_data_unref (gpointer instance);
static GParamSpec* thumbnail_cache_param_spec_image_data (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags) G_GNUC_UNUSED;
static void thumbnail_cache_value_set_image_data (GValue* value,
                                           gpointer v_object) G_GNUC_UNUSED;
static void thumbnail_cache_value_take_image_data (GValue* value,
                                            gpointer v_object) G_GNUC_UNUSED;
static gpointer thumbnail_cache_value_get_image_data (const GValue* value) G_GNUC_UNUSED;
static GType thumbnail_cache_image_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define THUMBNAIL_CACHE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_THUMBNAIL_CACHE, ThumbnailCachePrivate))
gint thumbnail_cache_size_get_scale (ThumbnailCacheSize self);
GType scaling_get_type (void) G_GNUC_CONST;
GType scale_constraint_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
void thumbnail_cache_size_get_scaling (ThumbnailCacheSize self,
                                       Scaling* result);
void scaling_for_best_fit (gint pixels,
                           gboolean scale_up,
                           Scaling* result);
ThumbnailCacheSize thumbnail_cache_size_get_best_size (gint scale);
gpointer workers_ref (gpointer instance);
void workers_unref (gpointer instance);
GParamSpec* param_spec_workers (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
void value_set_workers (GValue* value,
                        gpointer v_object);
void value_take_workers (GValue* value,
                         gpointer v_object);
gpointer value_get_workers (const GValue* value);
GType workers_get_type (void) G_GNUC_CONST;
gpointer one_shot_scheduler_ref (gpointer instance);
void one_shot_scheduler_unref (gpointer instance);
GParamSpec* param_spec_one_shot_scheduler (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_one_shot_scheduler (GValue* value,
                                   gpointer v_object);
void value_take_one_shot_scheduler (GValue* value,
                                    gpointer v_object);
gpointer value_get_one_shot_scheduler (const GValue* value);
GType one_shot_scheduler_get_type (void) G_GNUC_CONST;
#define THUMBNAIL_CACHE_DEFAULT_INTERP GDK_INTERP_HYPER
#define THUMBNAIL_CACHE_DEFAULT_QUALITY JPEG_QUALITY_HIGH
#define THUMBNAIL_CACHE_MAX_INMEMORY_DATA_SIZE (512 * 1024)
#define THUMBNAIL_CACHE_MAX_BIG_CACHED_BYTES ((gulong) ((40 * 1024) * 1024))
#define THUMBNAIL_CACHE_MAX_MEDIUM_CACHED_BYTES ((gulong) ((30 * 1024) * 1024))
static ThumbnailCache* thumbnail_cache_new (ThumbnailCacheSize size,
                                     gulong max_cached_bytes,
                                     GdkInterpType interp,
                                     JpegQuality quality);
static ThumbnailCache* thumbnail_cache_construct (GType object_type,
                                           ThumbnailCacheSize size,
                                           gulong max_cached_bytes,
                                           GdkInterpType interp,
                                           JpegQuality quality);
GFile* app_dirs_get_cache_subdir (const gchar* name,
                                  const gchar* subname);
void thumbnail_cache_init (void);
static void thumbnail_cache_report_cycle (void);
static void _thumbnail_cache_report_cycle_one_shot_callback (gpointer self);
OneShotScheduler* one_shot_scheduler_new (const gchar* name,
                                          OneShotCallback callback,
                                          void* callback_target);
OneShotScheduler* one_shot_scheduler_construct (GType object_type,
                                                const gchar* name,
                                                OneShotCallback callback,
                                                void* callback_target);
guint workers_threads_per_cpu (gint per,
                               gint max);
Workers* workers_new (guint max_threads,
                      gboolean exclusive);
Workers* workers_construct (GType object_type,
                            guint max_threads,
                            gboolean exclusive);
void thumbnail_cache_terminate (void);
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
void thumbnail_cache_import_from_source (ThumbnailSource* source,
                                         gboolean force,
                                         GError** error);
gchar* data_object_to_string (DataObject* self);
static void _thumbnail_cache_import_from_source (ThumbnailCache* self,
                                          ThumbnailSource* source,
                                          gboolean force,
                                          GError** error);
void thumbnail_cache_import_thumbnails (ThumbnailSource* source,
                                        Thumbnails* thumbnails,
                                        gboolean force,
                                        GError** error);
static void _thumbnail_cache_import_thumbnail (ThumbnailCache* self,
                                        ThumbnailSource* source,
                                        GdkPixbuf* scaled,
                                        gboolean force,
                                        GError** error);
void thumbnail_cache_duplicate (ThumbnailSource* src_source,
                                ThumbnailSource* dest_source);
static void _thumbnail_cache_duplicate (ThumbnailCache* self,
                                 ThumbnailSource* src_source,
                                 ThumbnailSource* dest_source);
void thumbnail_cache_remove (ThumbnailSource* source);
static void _thumbnail_cache_remove (ThumbnailCache* self,
                              ThumbnailSource* source);
static ThumbnailCache* thumbnail_cache_get_best_cache (gint scale);
static ThumbnailCache* thumbnail_cache_get_cache_for (ThumbnailCacheSize size);
GdkPixbuf* thumbnail_cache_fetch (ThumbnailSource* source,
                                  gint scale,
                                  GError** error);
static GdkPixbuf* _thumbnail_cache_fetch (ThumbnailCache* self,
                                   ThumbnailSource* source,
                                   GError** error);
void thumbnail_cache_fetch_async (ThumbnailSource* source,
                                  gint scale,
                                  ThumbnailCacheAsyncFetchCallback callback,
                                  void* callback_target,
                                  GCancellable* cancellable);
GType photo_file_format_get_type (void) G_GNUC_CONST;
static void _thumbnail_cache_fetch_async (ThumbnailCache* self,
                                   ThumbnailSource* source,
                                   PhotoFileFormat format,
                                   Dimensions* dim,
                                   GdkInterpType interp,
                                   ThumbnailCacheAsyncFetchCallback callback,
                                   void* callback_target,
                                   GCancellable* cancellable);
PhotoFileFormat thumbnail_source_get_preferred_thumbnail_format (ThumbnailSource* self);
void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
void thumbnail_cache_fetch_async_scaled (ThumbnailSource* source,
                                         gint scale,
                                         Dimensions* dim,
                                         GdkInterpType interp,
                                         ThumbnailCacheAsyncFetchCallback callback,
                                         void* callback_target,
                                         GCancellable* cancellable);
void thumbnail_cache_replace (ThumbnailSource* source,
                              ThumbnailCacheSize size,
                              GdkPixbuf* replacement,
                              GError** error);
static void _thumbnail_cache_replace (ThumbnailCache* self,
                               ThumbnailSource* source,
                               GdkPixbuf* original,
                               GError** error);
gboolean thumbnail_cache_exists (ThumbnailSource* source);
static gboolean _thumbnail_cache_exists (ThumbnailCache* self,
                                  ThumbnailSource* source);
GType rotation_get_type (void) G_GNUC_CONST;
void thumbnail_cache_rotate (ThumbnailSource* source,
                             Rotation rotation,
                             GError** error);
GdkPixbuf* rotation_perform (Rotation self,
                             GdkPixbuf* pixbuf);
gpointer photo_file_adapter_ref (gpointer instance);
void photo_file_adapter_unref (gpointer instance);
GParamSpec* param_spec_photo_file_adapter (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_photo_file_adapter (GValue* value,
                                   gpointer v_object);
void value_take_photo_file_adapter (GValue* value,
                                    gpointer v_object);
gpointer value_get_photo_file_adapter (const GValue* value);
GType photo_file_adapter_get_type (void) G_GNUC_CONST;
GType photo_file_reader_get_type (void) G_GNUC_CONST;
GType orientation_get_type (void) G_GNUC_CONST;
void thumbnail_cache_generate_for_photo (Thumbnails* thumbnails,
                                         PhotoFileReader* reader,
                                         Orientation orientation,
                                         Dimensions* original_dim,
                                         GError** error);
void scaling_get_scaled_dimensions (Scaling *self,
                                    Dimensions* original,
                                    Dimensions* result);
GdkPixbuf* photo_file_reader_scaled_read (PhotoFileReader* self,
                                          Dimensions* full,
                                          Dimensions* scaled,
                                          GError** error);
GdkPixbuf* photo_file_reader_unscaled_read (PhotoFileReader* self,
                                            GError** error);
GdkPixbuf* orientation_rotate_pixbuf (Orientation self,
                                      GdkPixbuf* pixbuf);
void dimensions_for_pixbuf (GdkPixbuf* pixbuf,
                            Dimensions* result);
void thumbnail_cache_generate_for_video_frame (Thumbnails* thumbnails,
                                               GdkPixbuf* preview_frame);
GdkPixbuf* scaling_perform_on_pixbuf (Scaling *self,
                                      GdkPixbuf* pixbuf,
                                      GdkInterpType interp,
                                      gboolean scale_up);
static void thumbnail_cache_schedule_debug (void);
static GdkPixbuf* thumbnail_cache_fetch_from_memory (ThumbnailCache* self,
                                              const gchar* thumbnail_name);
gchar* data_source_get_source_id (DataSource* self);
static GdkPixbuf* thumbnail_cache_read_pixbuf (ThumbnailCache* self,
                                        const gchar* thumbnail_name,
                                        PhotoFileFormat format,
                                        GError** error);
static void thumbnail_cache_store_in_memory (ThumbnailCache* self,
                                      const gchar* thumbnail_name,
                                      GdkPixbuf* thumbnail);
gboolean dimensions_has_area (Dimensions *self);
gboolean dimensions_equals (Dimensions *self,
                            Dimensions* dim);
gpointer background_job_ref (gpointer instance);
void background_job_unref (gpointer instance);
GParamSpec* param_spec_background_job (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_background_job (GValue* value,
                               gpointer v_object);
void value_take_background_job (GValue* value,
                                gpointer v_object);
gpointer value_get_background_job (const GValue* value);
GType background_job_get_type (void) G_GNUC_CONST;
void workers_enqueue (Workers* self,
                      BackgroundJob* job);
static ThumbnailCacheAsyncFetchJob* thumbnail_cache_async_fetch_job_new (ThumbnailCache* cache,
                                                                  const gchar* thumbnail_name,
                                                                  ThumbnailSource* source,
                                                                  GdkPixbuf* prefetched,
                                                                  Dimensions* dim,
                                                                  GdkInterpType interp,
                                                                  ThumbnailCacheAsyncFetchCallback callback,
                                                                  void* callback_target,
                                                                  GCancellable* cancellable);
static ThumbnailCacheAsyncFetchJob* thumbnail_cache_async_fetch_job_construct (GType object_type,
                                                                        ThumbnailCache* cache,
                                                                        const gchar* thumbnail_name,
                                                                        ThumbnailSource* source,
                                                                        GdkPixbuf* prefetched,
                                                                        Dimensions* dim,
                                                                        GdkInterpType interp,
                                                                        ThumbnailCacheAsyncFetchCallback callback,
                                                                        void* callback_target,
                                                                        GCancellable* cancellable);
static GType thumbnail_cache_async_fetch_job_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void thumbnail_cache_async_fetch_completion_callback (BackgroundJob* background_job);
GType background_job_job_priority_get_type (void) G_GNUC_CONST;
static GFile* thumbnail_cache_get_source_cached_file (ThumbnailCache* self,
                                               ThumbnailSource* source);
GType media_source_get_type (void) G_GNUC_CONST;
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType library_photo_get_type (void) G_GNUC_CONST;
GdkPixbuf* photo_source_get_pixbuf (PhotoSource* self,
                                    Scaling* scaling,
                                    GError** error);
static void thumbnail_cache_save_thumbnail (ThumbnailCache* self,
                                     GFile* file,
                                     GdkPixbuf* pixbuf,
                                     ThumbnailSource* source,
                                     GError** error);
gboolean dimensions_approx_scaled (Dimensions *self,
                                   gint scale,
                                   gint fudge);
static GFile* thumbnail_cache_get_cached_file (ThumbnailCache* self,
                                        const gchar* thumbnail_name,
                                        PhotoFileFormat thumbnail_format);
gchar* thumbnail_source_get_representative_id (ThumbnailSource* self);
void app_window_panic (const gchar* msg);
static gboolean thumbnail_cache_remove_from_memory (ThumbnailCache* self,
                                             const gchar* thumbnail_name);
GdkPixbuf* scale_pixbuf (GdkPixbuf* pixbuf,
                         gint scale,
                         GdkInterpType interp,
                         gboolean scale_up);
PhotoFileReader* photo_file_format_create_reader (PhotoFileFormat self,
                                                  const gchar* filepath);
gchar* photo_file_format_get_default_basename (PhotoFileFormat self,
                                               const gchar* name);
static ThumbnailCacheImageData* thumbnail_cache_image_data_new (GdkPixbuf* pixbuf);
static ThumbnailCacheImageData* thumbnail_cache_image_data_construct (GType object_type,
                                                               GdkPixbuf* pixbuf);
GType photo_file_writer_get_type (void) G_GNUC_CONST;
GQuark photo_format_error_quark (void);
PhotoFileWriter* photo_file_format_create_writer (PhotoFileFormat self,
                                                  const gchar* filepath,
                                                  GError** error);
void photo_file_writer_write (PhotoFileWriter* self,
                              GdkPixbuf* pixbuf,
                              JpegQuality quality,
                              GError** error);
static void thumbnail_cache_image_data_finalize (ThumbnailCacheImageData * obj);
static void _thumbnail_cache_async_fetch_completion_callback_completion_callback (BackgroundJob* job,
                                                                           gpointer self);
gpointer abstract_semaphore_ref (gpointer instance);
void abstract_semaphore_unref (gpointer instance);
GParamSpec* param_spec_abstract_semaphore (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_abstract_semaphore (GValue* value,
                                   gpointer v_object);
void value_take_abstract_semaphore (GValue* value,
                                    gpointer v_object);
gpointer value_get_abstract_semaphore (const GValue* value);
GType abstract_semaphore_get_type (void) G_GNUC_CONST;
BackgroundJob* background_job_construct (GType object_type,
                                         GObject* owner,
                                         CompletionCallback callback,
                                         void* callback_target,
                                         GCancellable* cancellable,
                                         CancellationCallback cancellation,
                                         void* cancellation_target,
                                         AbstractSemaphore* completion_semaphore);
static BackgroundJobJobPriority thumbnail_cache_async_fetch_job_real_get_priority (BackgroundJob* base);
static void thumbnail_cache_async_fetch_job_real_execute (BackgroundJob* base);
gboolean background_job_is_cancelled (BackgroundJob* self);
GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf,
                          Dimensions* resized,
                          GdkInterpType interp);
static void thumbnail_cache_async_fetch_job_generate_thumbnail (ThumbnailCacheAsyncFetchJob* self,
                                                         GError** error);
GType video_source_get_type (void) G_GNUC_CONST;
GType video_get_type (void) G_GNUC_CONST;
GdkPixbuf* thumbnail_source_create_thumbnail (ThumbnailSource* self,
                                              gint scale,
                                              GError** error);
static void thumbnail_cache_async_fetch_job_finalize (BackgroundJob * obj);
static void thumbnail_cache_finalize (GObject * obj);


Thumbnails*
thumbnails_construct (GType object_type)
{
	Thumbnails* self = NULL;
#line 11 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self = (Thumbnails*) g_type_create_instance (object_type);
#line 11 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return self;
#line 841 "ThumbnailCache.c"
}


Thumbnails*
thumbnails_new (void)
{
#line 11 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return thumbnails_construct (TYPE_THUMBNAILS);
#line 850 "ThumbnailCache.c"
}


void
thumbnails_set (Thumbnails* self,
                ThumbnailCacheSize size,
                GdkPixbuf* pixbuf)
{
	GeeHashMap* _tmp0_;
#line 14 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAILS (self));
#line 14 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 15 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = self->priv->map;
#line 15 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) size), pixbuf);
#line 868 "ThumbnailCache.c"
}


void
thumbnails_remove (Thumbnails* self,
                   ThumbnailCacheSize size)
{
	GeeHashMap* _tmp0_;
#line 18 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAILS (self));
#line 19 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = self->priv->map;
#line 19 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) size), NULL);
#line 883 "ThumbnailCache.c"
}


GdkPixbuf*
thumbnails_get (Thumbnails* self,
                ThumbnailCacheSize size)
{
	GdkPixbuf* result = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
#line 22 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAILS (self), NULL);
#line 23 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = self->priv->map;
#line 23 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) size));
#line 23 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = (GdkPixbuf*) _tmp1_;
#line 23 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 904 "ThumbnailCache.c"
}


static void
value_thumbnails_init (GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	value->data[0].v_pointer = NULL;
#line 913 "ThumbnailCache.c"
}


static void
value_thumbnails_free_value (GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		thumbnails_unref (value->data[0].v_pointer);
#line 924 "ThumbnailCache.c"
	}
}


static void
value_thumbnails_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (src_value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		dest_value->data[0].v_pointer = thumbnails_ref (src_value->data[0].v_pointer);
#line 937 "ThumbnailCache.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		dest_value->data[0].v_pointer = NULL;
#line 941 "ThumbnailCache.c"
	}
}


static gpointer
value_thumbnails_peek_pointer (const GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return value->data[0].v_pointer;
#line 951 "ThumbnailCache.c"
}


static gchar*
value_thumbnails_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (collect_values[0].v_pointer) {
#line 963 "ThumbnailCache.c"
		Thumbnails * object;
		object = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (object->parent_instance.g_class == NULL) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 970 "ThumbnailCache.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 974 "ThumbnailCache.c"
		}
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = thumbnails_ref (object);
#line 978 "ThumbnailCache.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = NULL;
#line 982 "ThumbnailCache.c"
	}
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return NULL;
#line 986 "ThumbnailCache.c"
}


static gchar*
value_thumbnails_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	Thumbnails ** object_p;
	object_p = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (!object_p) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1002 "ThumbnailCache.c"
	}
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (!value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		*object_p = NULL;
#line 1008 "ThumbnailCache.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		*object_p = value->data[0].v_pointer;
#line 1012 "ThumbnailCache.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		*object_p = thumbnails_ref (value->data[0].v_pointer);
#line 1016 "ThumbnailCache.c"
	}
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return NULL;
#line 1020 "ThumbnailCache.c"
}


GParamSpec*
param_spec_thumbnails (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	ParamSpecThumbnails* spec;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_THUMBNAILS), NULL);
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return G_PARAM_SPEC (spec);
#line 1040 "ThumbnailCache.c"
}


gpointer
value_get_thumbnails (const GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THUMBNAILS), NULL);
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return value->data[0].v_pointer;
#line 1051 "ThumbnailCache.c"
}


void
value_set_thumbnails (GValue* value,
                      gpointer v_object)
{
	Thumbnails * old;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THUMBNAILS));
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_THUMBNAILS));
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = v_object;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		thumbnails_ref (value->data[0].v_pointer);
#line 1074 "ThumbnailCache.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = NULL;
#line 1078 "ThumbnailCache.c"
	}
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		thumbnails_unref (old);
#line 1084 "ThumbnailCache.c"
	}
}


void
value_take_thumbnails (GValue* value,
                       gpointer v_object)
{
	Thumbnails * old;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THUMBNAILS));
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_THUMBNAILS));
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = v_object;
#line 1106 "ThumbnailCache.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = NULL;
#line 1110 "ThumbnailCache.c"
	}
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		thumbnails_unref (old);
#line 1116 "ThumbnailCache.c"
	}
}


static void
thumbnails_class_init (ThumbnailsClass * klass)
{
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnails_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	((ThumbnailsClass *) klass)->finalize = thumbnails_finalize;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_type_class_add_private (klass, sizeof (ThumbnailsPrivate));
#line 1130 "ThumbnailCache.c"
}


static void
thumbnails_instance_init (Thumbnails * self)
{
	GeeHashMap* _tmp0_;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv = THUMBNAILS_GET_PRIVATE (self);
#line 8 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = gee_hash_map_new (THUMBNAIL_CACHE_TYPE_SIZE, NULL, NULL, gdk_pixbuf_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 8 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv->map = _tmp0_;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->ref_count = 1;
#line 1146 "ThumbnailCache.c"
}


static void
thumbnails_finalize (Thumbnails * obj)
{
	Thumbnails * self;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THUMBNAILS, Thumbnails);
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_signal_handlers_destroy (self);
#line 8 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->priv->map);
#line 1160 "ThumbnailCache.c"
}


GType
thumbnails_get_type (void)
{
	static volatile gsize thumbnails_type_id__volatile = 0;
	if (g_once_init_enter (&thumbnails_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_thumbnails_init, value_thumbnails_free_value, value_thumbnails_copy_value, value_thumbnails_peek_pointer, "p", value_thumbnails_collect_value, "p", value_thumbnails_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ThumbnailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnails_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Thumbnails), 0, (GInstanceInitFunc) thumbnails_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType thumbnails_type_id;
		thumbnails_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Thumbnails", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&thumbnails_type_id__volatile, thumbnails_type_id);
	}
	return thumbnails_type_id__volatile;
}


gpointer
thumbnails_ref (gpointer instance)
{
	Thumbnails * self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_atomic_int_inc (&self->ref_count);
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return instance;
#line 1189 "ThumbnailCache.c"
}


void
thumbnails_unref (gpointer instance)
{
	Thumbnails * self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		THUMBNAILS_GET_CLASS (self)->finalize (self);
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1204 "ThumbnailCache.c"
	}
}


gint
thumbnail_cache_size_get_scale (ThumbnailCacheSize self)
{
	gint result = 0;
#line 42 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = (gint) self;
#line 42 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 1217 "ThumbnailCache.c"
}


void
thumbnail_cache_size_get_scaling (ThumbnailCacheSize self,
                                  Scaling* result)
{
	Scaling _tmp0_ = {0};
#line 46 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	scaling_for_best_fit (thumbnail_cache_size_get_scale (self), TRUE, &_tmp0_);
#line 46 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	*result = _tmp0_;
#line 46 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return;
#line 1232 "ThumbnailCache.c"
}


ThumbnailCacheSize
thumbnail_cache_size_get_best_size (gint scale)
{
	ThumbnailCacheSize result = 0;
	ThumbnailCacheSize _tmp0_ = 0;
#line 50 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (scale <= thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_MEDIUM)) {
#line 50 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp0_ = THUMBNAIL_CACHE_SIZE_MEDIUM;
#line 1245 "ThumbnailCache.c"
	} else {
#line 50 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp0_ = THUMBNAIL_CACHE_SIZE_BIG;
#line 1249 "ThumbnailCache.c"
	}
#line 50 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = _tmp0_;
#line 50 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 1255 "ThumbnailCache.c"
}


GType
thumbnail_cache_size_get_type (void)
{
	static volatile gsize thumbnail_cache_size_type_id__volatile = 0;
	if (g_once_init_enter (&thumbnail_cache_size_type_id__volatile)) {
		static const GEnumValue values[] = {{THUMBNAIL_CACHE_SIZE_LARGEST, "THUMBNAIL_CACHE_SIZE_LARGEST", "largest"}, {THUMBNAIL_CACHE_SIZE_BIG, "THUMBNAIL_CACHE_SIZE_BIG", "big"}, {THUMBNAIL_CACHE_SIZE_MEDIUM, "THUMBNAIL_CACHE_SIZE_MEDIUM", "medium"}, {THUMBNAIL_CACHE_SIZE_SMALLEST, "THUMBNAIL_CACHE_SIZE_SMALLEST", "smallest"}, {0, NULL, NULL}};
		GType thumbnail_cache_size_type_id;
		thumbnail_cache_size_type_id = g_enum_register_static ("ThumbnailCacheSize", values);
		g_once_init_leave (&thumbnail_cache_size_type_id__volatile, thumbnail_cache_size_type_id);
	}
	return thumbnail_cache_size_type_id__volatile;
}


static ThumbnailCache*
thumbnail_cache_construct (GType object_type,
                           ThumbnailCacheSize size,
                           gulong max_cached_bytes,
                           GdkInterpType interp,
                           JpegQuality quality)
{
	ThumbnailCache * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
#line 190 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self = (ThumbnailCache*) g_object_new (object_type, NULL);
#line 192 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = g_strdup_printf ("thumbs%d", thumbnail_cache_size_get_scale (size));
#line 192 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = _tmp0_;
#line 192 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = app_dirs_get_cache_subdir ("thumbs", _tmp1_);
#line 192 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->priv->cache_dir);
#line 192 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv->cache_dir = _tmp2_;
#line 192 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp1_);
#line 193 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv->size = size;
#line 194 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv->max_cached_bytes = max_cached_bytes;
#line 195 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv->interp = interp;
#line 196 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv->quality = quality;
#line 190 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return self;
#line 1308 "ThumbnailCache.c"
}


static ThumbnailCache*
thumbnail_cache_new (ThumbnailCacheSize size,
                     gulong max_cached_bytes,
                     GdkInterpType interp,
                     JpegQuality quality)
{
#line 190 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return thumbnail_cache_construct (TYPE_THUMBNAIL_CACHE, size, max_cached_bytes, interp, quality);
#line 1320 "ThumbnailCache.c"
}


static void
_thumbnail_cache_report_cycle_one_shot_callback (gpointer self)
{
#line 201 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_report_cycle ();
#line 1329 "ThumbnailCache.c"
}


void
thumbnail_cache_init (void)
{
	OneShotScheduler* _tmp0_;
	Workers* _tmp1_;
	ThumbnailCache* _tmp2_;
	ThumbnailCache* _tmp3_;
#line 201 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = one_shot_scheduler_new ("ThumbnailCache cycle reporter", _thumbnail_cache_report_cycle_one_shot_callback, NULL);
#line 201 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_one_shot_scheduler_unref0 (thumbnail_cache_debug_scheduler);
#line 201 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_debug_scheduler = _tmp0_;
#line 202 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = workers_new (workers_threads_per_cpu (1, -1), TRUE);
#line 202 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_workers_unref0 (thumbnail_cache_fetch_workers);
#line 202 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_fetch_workers = _tmp1_;
#line 204 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = thumbnail_cache_new (THUMBNAIL_CACHE_SIZE_BIG, THUMBNAIL_CACHE_MAX_BIG_CACHED_BYTES, THUMBNAIL_CACHE_DEFAULT_INTERP, THUMBNAIL_CACHE_DEFAULT_QUALITY);
#line 204 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (thumbnail_cache_big);
#line 204 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_big = _tmp2_;
#line 205 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = thumbnail_cache_new (THUMBNAIL_CACHE_SIZE_MEDIUM, THUMBNAIL_CACHE_MAX_MEDIUM_CACHED_BYTES, THUMBNAIL_CACHE_DEFAULT_INTERP, THUMBNAIL_CACHE_DEFAULT_QUALITY);
#line 205 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (thumbnail_cache_medium);
#line 205 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_medium = _tmp3_;
#line 1364 "ThumbnailCache.c"
}


void
thumbnail_cache_terminate (void)
{
}


void
thumbnail_cache_import_from_source (ThumbnailSource* source,
                                    gboolean force,
                                    GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ThumbnailCache* _tmp2_;
	ThumbnailCache* _tmp3_;
	GError * _inner_error_ = NULL;
#line 211 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 213 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_OBJECT, DataObject));
#line 213 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = _tmp0_;
#line 213 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_debug ("ThumbnailCache.vala:213: import from source: %s", _tmp1_);
#line 213 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp1_);
#line 214 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = thumbnail_cache_big;
#line 214 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_import_from_source (_tmp2_, source, force, &_inner_error_);
#line 214 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 214 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 214 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 1404 "ThumbnailCache.c"
	}
#line 215 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = thumbnail_cache_medium;
#line 215 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_import_from_source (_tmp3_, source, force, &_inner_error_);
#line 215 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 215 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 215 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 1416 "ThumbnailCache.c"
	}
}


void
thumbnail_cache_import_thumbnails (ThumbnailSource* source,
                                   Thumbnails* thumbnails,
                                   gboolean force,
                                   GError** error)
{
	ThumbnailCache* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	ThumbnailCache* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	GError * _inner_error_ = NULL;
#line 218 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 218 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAILS (thumbnails));
#line 220 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = thumbnail_cache_big;
#line 220 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnails_get (thumbnails, THUMBNAIL_CACHE_SIZE_BIG);
#line 220 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = _tmp1_;
#line 220 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_import_thumbnail (_tmp0_, source, _tmp2_, force, &_inner_error_);
#line 220 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp2_);
#line 220 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 220 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 220 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 1454 "ThumbnailCache.c"
	}
#line 221 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = thumbnail_cache_medium;
#line 221 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = thumbnails_get (thumbnails, THUMBNAIL_CACHE_SIZE_MEDIUM);
#line 221 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = _tmp4_;
#line 221 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_import_thumbnail (_tmp3_, source, _tmp5_, force, &_inner_error_);
#line 221 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp5_);
#line 221 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 221 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 221 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 1472 "ThumbnailCache.c"
	}
}


void
thumbnail_cache_duplicate (ThumbnailSource* src_source,
                           ThumbnailSource* dest_source)
{
	ThumbnailCache* _tmp0_;
	ThumbnailCache* _tmp1_;
#line 224 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (src_source));
#line 224 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (dest_source));
#line 225 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = thumbnail_cache_big;
#line 225 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_duplicate (_tmp0_, src_source, dest_source);
#line 226 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_cache_medium;
#line 226 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_duplicate (_tmp1_, src_source, dest_source);
#line 1495 "ThumbnailCache.c"
}


void
thumbnail_cache_remove (ThumbnailSource* source)
{
	ThumbnailCache* _tmp0_;
	ThumbnailCache* _tmp1_;
#line 229 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 230 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = thumbnail_cache_big;
#line 230 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_remove (_tmp0_, source);
#line 231 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_cache_medium;
#line 231 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_remove (_tmp1_, source);
#line 1514 "ThumbnailCache.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 237 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return self ? g_object_ref (self) : NULL;
#line 1523 "ThumbnailCache.c"
}


static ThumbnailCache*
thumbnail_cache_get_best_cache (gint scale)
{
	ThumbnailCache* result = NULL;
	ThumbnailCacheSize size = 0;
	ThumbnailCacheSize _tmp0_;
#line 235 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	size = thumbnail_cache_size_get_best_size (scale);
#line 236 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = size;
#line 236 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp0_ == THUMBNAIL_CACHE_SIZE_BIG) {
#line 1539 "ThumbnailCache.c"
		ThumbnailCache* _tmp1_;
		ThumbnailCache* _tmp2_;
#line 237 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp1_ = thumbnail_cache_big;
#line 237 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 237 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		result = _tmp2_;
#line 237 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return result;
#line 1550 "ThumbnailCache.c"
	} else {
		ThumbnailCacheSize _tmp3_;
		ThumbnailCache* _tmp4_;
		ThumbnailCache* _tmp5_;
#line 239 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp3_ = size;
#line 239 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_vala_assert (_tmp3_ == THUMBNAIL_CACHE_SIZE_MEDIUM, "size == Size.MEDIUM");
#line 241 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp4_ = thumbnail_cache_medium;
#line 241 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 241 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		result = _tmp5_;
#line 241 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return result;
#line 1567 "ThumbnailCache.c"
	}
}


static ThumbnailCache*
thumbnail_cache_get_cache_for (ThumbnailCacheSize size)
{
	ThumbnailCache* result = NULL;
#line 246 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	switch (size) {
#line 246 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		case THUMBNAIL_CACHE_SIZE_BIG:
#line 1580 "ThumbnailCache.c"
		{
			ThumbnailCache* _tmp0_;
			ThumbnailCache* _tmp1_;
#line 248 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp0_ = thumbnail_cache_big;
#line 248 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp1_ = _g_object_ref0 (_tmp0_);
#line 248 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			result = _tmp1_;
#line 248 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return result;
#line 1592 "ThumbnailCache.c"
		}
#line 246 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		case THUMBNAIL_CACHE_SIZE_MEDIUM:
#line 1596 "ThumbnailCache.c"
		{
			ThumbnailCache* _tmp2_;
			ThumbnailCache* _tmp3_;
#line 251 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp2_ = thumbnail_cache_medium;
#line 251 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp3_ = _g_object_ref0 (_tmp2_);
#line 251 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			result = _tmp3_;
#line 251 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return result;
#line 1608 "ThumbnailCache.c"
		}
		default:
		{
#line 254 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			g_error ("ThumbnailCache.vala:254: Unknown thumbnail size %d", thumbnail_cache_size_get_scale (size));
#line 1614 "ThumbnailCache.c"
		}
	}
}


GdkPixbuf*
thumbnail_cache_fetch (ThumbnailSource* source,
                       gint scale,
                       GError** error)
{
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	ThumbnailCache* _tmp1_;
	ThumbnailCache* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	GError * _inner_error_ = NULL;
#line 258 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), NULL);
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_cache_get_best_cache (scale);
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = _tmp1_;
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = _thumbnail_cache_fetch (_tmp2_, source, &_inner_error_);
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = _tmp3_;
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp2_);
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = _tmp4_;
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return NULL;
#line 1653 "ThumbnailCache.c"
	}
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = _tmp0_;
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = NULL;
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = _tmp5_;
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp0_);
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 1665 "ThumbnailCache.c"
}


void
thumbnail_cache_fetch_async (ThumbnailSource* source,
                             gint scale,
                             ThumbnailCacheAsyncFetchCallback callback,
                             void* callback_target,
                             GCancellable* cancellable)
{
	ThumbnailCache* _tmp0_;
	ThumbnailCache* _tmp1_;
	Dimensions _tmp2_ = {0};
#line 262 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 262 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail ((cancellable == NULL) || G_IS_CANCELLABLE (cancellable));
#line 264 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = thumbnail_cache_get_best_cache (scale);
#line 264 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = _tmp0_;
#line 264 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	dimensions_init (&_tmp2_, 0, 0);
#line 264 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_fetch_async (_tmp1_, source, thumbnail_source_get_preferred_thumbnail_format (source), &_tmp2_, THUMBNAIL_CACHE_DEFAULT_INTERP, callback, callback_target, cancellable);
#line 264 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp1_);
#line 1693 "ThumbnailCache.c"
}


void
thumbnail_cache_fetch_async_scaled (ThumbnailSource* source,
                                    gint scale,
                                    Dimensions* dim,
                                    GdkInterpType interp,
                                    ThumbnailCacheAsyncFetchCallback callback,
                                    void* callback_target,
                                    GCancellable* cancellable)
{
	ThumbnailCache* _tmp0_;
	ThumbnailCache* _tmp1_;
	Dimensions _tmp2_;
#line 268 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 268 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (dim != NULL);
#line 268 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail ((cancellable == NULL) || G_IS_CANCELLABLE (cancellable));
#line 270 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = thumbnail_cache_get_best_cache (scale);
#line 270 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = _tmp0_;
#line 270 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = *dim;
#line 270 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_fetch_async (_tmp1_, source, thumbnail_source_get_preferred_thumbnail_format (source), &_tmp2_, interp, callback, callback_target, cancellable);
#line 270 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp1_);
#line 1725 "ThumbnailCache.c"
}


void
thumbnail_cache_replace (ThumbnailSource* source,
                         ThumbnailCacheSize size,
                         GdkPixbuf* replacement,
                         GError** error)
{
	ThumbnailCache* _tmp0_;
	ThumbnailCache* _tmp1_;
	GError * _inner_error_ = NULL;
#line 274 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 274 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (GDK_IS_PIXBUF (replacement));
#line 276 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = thumbnail_cache_get_cache_for (size);
#line 276 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = _tmp0_;
#line 276 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_replace (_tmp1_, source, replacement, &_inner_error_);
#line 276 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp1_);
#line 276 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 276 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 276 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 1756 "ThumbnailCache.c"
	}
}


gboolean
thumbnail_cache_exists (ThumbnailSource* source)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ThumbnailCache* _tmp1_;
#line 279 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), FALSE);
#line 280 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_cache_big;
#line 280 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_thumbnail_cache_exists (_tmp1_, source)) {
#line 1773 "ThumbnailCache.c"
		ThumbnailCache* _tmp2_;
#line 280 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp2_ = thumbnail_cache_medium;
#line 280 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp0_ = _thumbnail_cache_exists (_tmp2_, source);
#line 1779 "ThumbnailCache.c"
	} else {
#line 280 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp0_ = FALSE;
#line 1783 "ThumbnailCache.c"
	}
#line 280 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = _tmp0_;
#line 280 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 1789 "ThumbnailCache.c"
}


void
thumbnail_cache_rotate (ThumbnailSource* source,
                        Rotation rotation,
                        GError** error)
{
	ThumbnailCacheSize* _tmp0_;
	gint _tmp0__length1;
	GError * _inner_error_ = NULL;
#line 283 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 284 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = thumbnail_cache_ALL_SIZES;
#line 284 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0__length1 = thumbnail_cache_ALL_SIZES_length1;
#line 1807 "ThumbnailCache.c"
	{
		ThumbnailCacheSize* size_collection = NULL;
		gint size_collection_length1 = 0;
		gint _size_collection_size_ = 0;
		gint size_it = 0;
#line 284 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		size_collection = _tmp0_;
#line 284 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		size_collection_length1 = _tmp0__length1;
#line 284 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		for (size_it = 0; size_it < _tmp0__length1; size_it = size_it + 1) {
#line 1819 "ThumbnailCache.c"
			ThumbnailCacheSize size = 0;
#line 284 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			size = size_collection[size_it];
#line 1823 "ThumbnailCache.c"
			{
				GdkPixbuf* thumbnail = NULL;
				ThumbnailCacheSize _tmp1_;
				GdkPixbuf* _tmp2_;
				GdkPixbuf* _tmp3_;
				GdkPixbuf* _tmp4_;
				ThumbnailCacheSize _tmp5_;
				GdkPixbuf* _tmp6_;
#line 285 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp1_ = size;
#line 285 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp2_ = thumbnail_cache_fetch (source, (gint) _tmp1_, &_inner_error_);
#line 285 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				thumbnail = _tmp2_;
#line 285 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 285 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
					g_propagate_error (error, _inner_error_);
#line 285 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
					return;
#line 1844 "ThumbnailCache.c"
				}
#line 286 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp3_ = thumbnail;
#line 286 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp4_ = rotation_perform (rotation, _tmp3_);
#line 286 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_g_object_unref0 (thumbnail);
#line 286 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				thumbnail = _tmp4_;
#line 287 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp5_ = size;
#line 287 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp6_ = thumbnail;
#line 287 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				thumbnail_cache_replace (source, _tmp5_, _tmp6_, &_inner_error_);
#line 287 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 287 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
					g_propagate_error (error, _inner_error_);
#line 287 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
					_g_object_unref0 (thumbnail);
#line 287 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
					return;
#line 1868 "ThumbnailCache.c"
				}
#line 284 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_g_object_unref0 (thumbnail);
#line 1872 "ThumbnailCache.c"
			}
		}
	}
}


void
thumbnail_cache_generate_for_photo (Thumbnails* thumbnails,
                                    PhotoFileReader* reader,
                                    Orientation orientation,
                                    Dimensions* original_dim,
                                    GError** error)
{
	ThumbnailCacheSize max_size = 0;
	Dimensions dim = {0};
	ThumbnailCacheSize _tmp0_;
	Scaling _tmp1_ = {0};
	Dimensions _tmp2_;
	Dimensions _tmp3_ = {0};
	GdkPixbuf* largest_thumbnail = NULL;
	GdkPixbuf* _tmp12_;
	GdkPixbuf* _tmp13_;
	Dimensions largest_thumb_dimensions = {0};
	GdkPixbuf* _tmp14_;
	Dimensions _tmp15_ = {0};
	ThumbnailCacheSize* _tmp16_;
	gint _tmp16__length1;
	GError * _inner_error_ = NULL;
#line 293 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAILS (thumbnails));
#line 293 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_PHOTO_FILE_READER (reader));
#line 293 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (original_dim != NULL);
#line 296 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	max_size = THUMBNAIL_CACHE_SIZE_BIG * 2;
#line 297 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = max_size;
#line 297 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_size_get_scaling (_tmp0_, &_tmp1_);
#line 297 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = *original_dim;
#line 297 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	scaling_get_scaled_dimensions (&_tmp1_, &_tmp2_, &_tmp3_);
#line 297 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	dim = _tmp3_;
#line 298 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	largest_thumbnail = NULL;
#line 1921 "ThumbnailCache.c"
	{
		GdkPixbuf* _tmp4_ = NULL;
		Dimensions _tmp5_;
		Dimensions _tmp6_;
		GdkPixbuf* _tmp7_;
		GdkPixbuf* _tmp8_;
#line 300 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp5_ = *original_dim;
#line 300 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp6_ = dim;
#line 300 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp7_ = photo_file_reader_scaled_read (reader, &_tmp5_, &_tmp6_, &_inner_error_);
#line 300 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp4_ = _tmp7_;
#line 300 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1938 "ThumbnailCache.c"
			goto __catch248_g_error;
		}
#line 300 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp8_ = _tmp4_;
#line 300 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp4_ = NULL;
#line 300 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (largest_thumbnail);
#line 300 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		largest_thumbnail = _tmp8_;
#line 299 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (_tmp4_);
#line 1951 "ThumbnailCache.c"
	}
	goto __finally248;
	__catch248_g_error:
	{
		GError* err = NULL;
		GdkPixbuf* _tmp9_ = NULL;
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
#line 299 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		err = _inner_error_;
#line 299 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_inner_error_ = NULL;
#line 305 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp10_ = photo_file_reader_unscaled_read (reader, &_inner_error_);
#line 305 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp9_ = _tmp10_;
#line 305 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 305 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_error_free0 (err);
#line 1972 "ThumbnailCache.c"
			goto __finally248;
		}
#line 305 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp11_ = _tmp9_;
#line 305 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp9_ = NULL;
#line 305 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (largest_thumbnail);
#line 305 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		largest_thumbnail = _tmp11_;
#line 299 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (_tmp9_);
#line 299 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_error_free0 (err);
#line 1987 "ThumbnailCache.c"
	}
	__finally248:
#line 299 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 299 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 299 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (largest_thumbnail);
#line 299 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 1998 "ThumbnailCache.c"
	}
#line 307 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp12_ = largest_thumbnail;
#line 307 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp13_ = orientation_rotate_pixbuf (orientation, _tmp12_);
#line 307 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (largest_thumbnail);
#line 307 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	largest_thumbnail = _tmp13_;
#line 308 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp14_ = largest_thumbnail;
#line 308 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	dimensions_for_pixbuf (_tmp14_, &_tmp15_);
#line 308 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	largest_thumb_dimensions = _tmp15_;
#line 310 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp16_ = thumbnail_cache_ALL_SIZES;
#line 310 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp16__length1 = thumbnail_cache_ALL_SIZES_length1;
#line 2018 "ThumbnailCache.c"
	{
		ThumbnailCacheSize* size_collection = NULL;
		gint size_collection_length1 = 0;
		gint _size_collection_size_ = 0;
		gint size_it = 0;
#line 310 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		size_collection = _tmp16_;
#line 310 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		size_collection_length1 = _tmp16__length1;
#line 310 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		for (size_it = 0; size_it < _tmp16__length1; size_it = size_it + 1) {
#line 2030 "ThumbnailCache.c"
			ThumbnailCacheSize size = 0;
#line 310 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			size = size_collection[size_it];
#line 2034 "ThumbnailCache.c"
			{
				ThumbnailCacheSize _tmp17_;
				Scaling _tmp18_ = {0};
				Dimensions _tmp19_;
				Dimensions _tmp20_ = {0};
				ThumbnailCacheSize _tmp21_;
				GdkPixbuf* _tmp22_;
				Dimensions _tmp23_;
				gint _tmp24_;
				Dimensions _tmp25_;
				gint _tmp26_;
				GdkPixbuf* _tmp27_;
				GdkPixbuf* _tmp28_;
#line 311 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp17_ = size;
#line 311 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				thumbnail_cache_size_get_scaling (_tmp17_, &_tmp18_);
#line 311 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp19_ = largest_thumb_dimensions;
#line 311 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				scaling_get_scaled_dimensions (&_tmp18_, &_tmp19_, &_tmp20_);
#line 311 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				dim = _tmp20_;
#line 312 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp21_ = size;
#line 312 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp22_ = largest_thumbnail;
#line 312 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp23_ = dim;
#line 312 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp24_ = _tmp23_.width;
#line 312 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp25_ = dim;
#line 312 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp26_ = _tmp25_.height;
#line 312 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp27_ = gdk_pixbuf_scale_simple (_tmp22_, _tmp24_, _tmp26_, GDK_INTERP_HYPER);
#line 312 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp28_ = _tmp27_;
#line 312 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				thumbnails_set (thumbnails, _tmp21_, _tmp28_);
#line 312 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_g_object_unref0 (_tmp28_);
#line 2078 "ThumbnailCache.c"
			}
		}
	}
#line 293 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (largest_thumbnail);
#line 2084 "ThumbnailCache.c"
}


void
thumbnail_cache_generate_for_video_frame (Thumbnails* thumbnails,
                                          GdkPixbuf* preview_frame)
{
	ThumbnailCacheSize* _tmp0_;
	gint _tmp0__length1;
#line 316 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAILS (thumbnails));
#line 316 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (GDK_IS_PIXBUF (preview_frame));
#line 317 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = thumbnail_cache_ALL_SIZES;
#line 317 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0__length1 = thumbnail_cache_ALL_SIZES_length1;
#line 2102 "ThumbnailCache.c"
	{
		ThumbnailCacheSize* size_collection = NULL;
		gint size_collection_length1 = 0;
		gint _size_collection_size_ = 0;
		gint size_it = 0;
#line 317 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		size_collection = _tmp0_;
#line 317 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		size_collection_length1 = _tmp0__length1;
#line 317 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		for (size_it = 0; size_it < _tmp0__length1; size_it = size_it + 1) {
#line 2114 "ThumbnailCache.c"
			ThumbnailCacheSize size = 0;
#line 317 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			size = size_collection[size_it];
#line 2118 "ThumbnailCache.c"
			{
				Scaling current_scaling = {0};
				ThumbnailCacheSize _tmp1_;
				Scaling _tmp2_ = {0};
				GdkPixbuf* current_thumbnail = NULL;
				GdkPixbuf* _tmp3_;
				ThumbnailCacheSize _tmp4_;
				GdkPixbuf* _tmp5_;
#line 318 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp1_ = size;
#line 318 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				thumbnail_cache_size_get_scaling (_tmp1_, &_tmp2_);
#line 318 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				current_scaling = _tmp2_;
#line 319 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp3_ = scaling_perform_on_pixbuf (&current_scaling, preview_frame, GDK_INTERP_HYPER, TRUE);
#line 319 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				current_thumbnail = _tmp3_;
#line 321 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp4_ = size;
#line 321 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp5_ = current_thumbnail;
#line 321 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				thumbnails_set (thumbnails, _tmp4_, _tmp5_);
#line 317 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_g_object_unref0 (current_thumbnail);
#line 2145 "ThumbnailCache.c"
			}
		}
	}
}


static void
thumbnail_cache_schedule_debug (void)
{
}


static void
thumbnail_cache_report_cycle (void)
{
}


static GdkPixbuf*
_thumbnail_cache_fetch (ThumbnailCache* self,
                        ThumbnailSource* source,
                        GError** error)
{
	GdkPixbuf* result = NULL;
	GdkPixbuf* pixbuf = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GdkPixbuf* _tmp14_;
	GError * _inner_error_ = NULL;
#line 371 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (self), NULL);
#line 371 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), NULL);
#line 373 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_SOURCE, DataSource));
#line 373 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = _tmp0_;
#line 373 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = thumbnail_cache_fetch_from_memory (self, _tmp1_);
#line 373 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = _tmp2_;
#line 373 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp1_);
#line 373 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	pixbuf = _tmp3_;
#line 374 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = pixbuf;
#line 374 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp4_ != NULL) {
#line 375 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		result = pixbuf;
#line 375 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return result;
#line 2211 "ThumbnailCache.c"
	}
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_SOURCE, DataSource));
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7_ = _tmp6_;
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp8_ = thumbnail_cache_read_pixbuf (self, _tmp7_, thumbnail_source_get_preferred_thumbnail_format (source), &_inner_error_);
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp9_ = _tmp8_;
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp7_);
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = _tmp9_;
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (pixbuf);
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return NULL;
#line 2233 "ThumbnailCache.c"
	}
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp10_ = _tmp5_;
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = NULL;
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (pixbuf);
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	pixbuf = _tmp10_;
#line 379 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp11_ = thumbnail_cache_cycle_fetched_thumbnails;
#line 379 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_cycle_fetched_thumbnails = _tmp11_ + 1;
#line 380 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_schedule_debug ();
#line 383 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp12_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_SOURCE, DataSource));
#line 383 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp13_ = _tmp12_;
#line 383 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp14_ = pixbuf;
#line 383 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_store_in_memory (self, _tmp13_, _tmp14_);
#line 383 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp13_);
#line 385 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = pixbuf;
#line 385 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp5_);
#line 385 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 2265 "ThumbnailCache.c"
}


static void
_thumbnail_cache_fetch_async (ThumbnailCache* self,
                              ThumbnailSource* source,
                              PhotoFileFormat format,
                              Dimensions* dim,
                              GdkInterpType interp,
                              ThumbnailCacheAsyncFetchCallback callback,
                              void* callback_target,
                              GCancellable* cancellable)
{
	gchar* thumbnail_name = NULL;
	gchar* _tmp0_;
	GdkPixbuf* pixbuf = NULL;
	const gchar* _tmp1_;
	GdkPixbuf* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GdkPixbuf* _tmp4_;
	Workers* _tmp12_;
	const gchar* _tmp13_;
	GdkPixbuf* _tmp14_;
	Dimensions _tmp15_;
	ThumbnailCacheAsyncFetchJob* _tmp16_;
	ThumbnailCacheAsyncFetchJob* _tmp17_;
#line 388 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
#line 388 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 388 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (dim != NULL);
#line 388 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail ((cancellable == NULL) || G_IS_CANCELLABLE (cancellable));
#line 391 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_SOURCE, DataSource));
#line 391 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_name = _tmp0_;
#line 392 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_name;
#line 392 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = thumbnail_cache_fetch_from_memory (self, _tmp1_);
#line 392 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	pixbuf = _tmp2_;
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = pixbuf;
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp4_ != NULL) {
#line 2314 "ThumbnailCache.c"
		gboolean _tmp5_ = FALSE;
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (!dimensions_has_area (dim)) {
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp5_ = TRUE;
#line 2320 "ThumbnailCache.c"
		} else {
			GdkPixbuf* _tmp6_;
			Dimensions _tmp7_ = {0};
			Dimensions _tmp8_;
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp6_ = pixbuf;
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			dimensions_for_pixbuf (_tmp6_, &_tmp7_);
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp8_ = *dim;
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp5_ = dimensions_equals (&_tmp7_, &_tmp8_);
#line 2333 "ThumbnailCache.c"
		}
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp3_ = _tmp5_;
#line 2337 "ThumbnailCache.c"
	} else {
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp3_ = FALSE;
#line 2341 "ThumbnailCache.c"
	}
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp3_) {
#line 2345 "ThumbnailCache.c"
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
		Dimensions _tmp11_;
#line 396 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp9_ = pixbuf;
#line 396 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp10_ = pixbuf;
#line 396 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp11_ = *dim;
#line 396 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		callback (_tmp9_, _tmp10_, &_tmp11_, interp, NULL, callback_target);
#line 398 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (pixbuf);
#line 398 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_free0 (thumbnail_name);
#line 398 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 2363 "ThumbnailCache.c"
	}
#line 411 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp12_ = thumbnail_cache_fetch_workers;
#line 411 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp13_ = thumbnail_name;
#line 411 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp14_ = pixbuf;
#line 411 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp15_ = *dim;
#line 411 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp16_ = thumbnail_cache_async_fetch_job_new (self, _tmp13_, source, _tmp14_, &_tmp15_, interp, callback, callback_target, cancellable);
#line 411 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp17_ = _tmp16_;
#line 411 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	workers_enqueue (_tmp12_, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 411 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_background_job_unref0 (_tmp17_);
#line 388 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (pixbuf);
#line 388 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (thumbnail_name);
#line 2385 "ThumbnailCache.c"
}


static gpointer
_background_job_ref0 (gpointer self)
{
#line 417 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return self ? background_job_ref (self) : NULL;
#line 2394 "ThumbnailCache.c"
}


static gpointer
_g_error_copy0 (gpointer self)
{
#line 425 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return self ? g_error_copy (self) : NULL;
#line 2403 "ThumbnailCache.c"
}


static void
thumbnail_cache_async_fetch_completion_callback (BackgroundJob* background_job)
{
	ThumbnailCacheAsyncFetchJob* job = NULL;
	ThumbnailCacheAsyncFetchJob* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ThumbnailCacheAsyncFetchJob* _tmp2_;
	gboolean _tmp3_;
	ThumbnailCacheAsyncFetchJob* _tmp16_;
	GdkPixbuf* _tmp17_;
	ThumbnailCacheAsyncFetchJob* _tmp28_;
	ThumbnailCacheAsyncFetchCallback _tmp29_;
	void* _tmp29__target;
	ThumbnailCacheAsyncFetchJob* _tmp30_;
	GdkPixbuf* _tmp31_;
	ThumbnailCacheAsyncFetchJob* _tmp32_;
	GdkPixbuf* _tmp33_;
	ThumbnailCacheAsyncFetchJob* _tmp34_;
	Dimensions _tmp35_;
	ThumbnailCacheAsyncFetchJob* _tmp36_;
	GdkInterpType _tmp37_;
	ThumbnailCacheAsyncFetchJob* _tmp38_;
	GError* _tmp39_;
	GError * _inner_error_ = NULL;
#line 416 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (background_job));
#line 417 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (background_job, THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJob));
#line 417 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	job = _tmp0_;
#line 421 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = job;
#line 421 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = _tmp2_->replace;
#line 421 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp3_) {
#line 2443 "ThumbnailCache.c"
		ThumbnailCacheAsyncFetchJob* _tmp4_;
		GdkPixbuf* _tmp5_;
#line 421 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp4_ = job;
#line 421 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp5_ = _tmp4_->unscaled;
#line 421 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp1_ = _tmp5_ != NULL;
#line 2452 "ThumbnailCache.c"
	} else {
#line 421 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp1_ = FALSE;
#line 2456 "ThumbnailCache.c"
	}
#line 421 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp1_) {
#line 2460 "ThumbnailCache.c"
		{
			ThumbnailCacheAsyncFetchJob* _tmp6_;
			ThumbnailSource* _tmp7_;
			ThumbnailCacheAsyncFetchJob* _tmp8_;
			ThumbnailCache* _tmp9_;
			ThumbnailCacheSize _tmp10_;
			ThumbnailCacheAsyncFetchJob* _tmp11_;
			GdkPixbuf* _tmp12_;
#line 423 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp6_ = job;
#line 423 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp7_ = _tmp6_->source;
#line 423 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp8_ = job;
#line 423 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp9_ = _tmp8_->cache;
#line 423 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp10_ = _tmp9_->priv->size;
#line 423 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp11_ = job;
#line 423 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp12_ = _tmp11_->unscaled;
#line 423 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			thumbnail_cache_replace (_tmp7_, _tmp10_, _tmp12_, &_inner_error_);
#line 423 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2487 "ThumbnailCache.c"
				goto __catch249_g_error;
			}
		}
		goto __finally249;
		__catch249_g_error:
		{
			GError* err = NULL;
			ThumbnailCacheAsyncFetchJob* _tmp13_;
			GError* _tmp14_;
			GError* _tmp15_;
#line 422 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			err = _inner_error_;
#line 422 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_inner_error_ = NULL;
#line 425 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp13_ = job;
#line 425 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp14_ = err;
#line 425 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp15_ = _g_error_copy0 (_tmp14_);
#line 425 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_error_free0 (_tmp13_->err);
#line 425 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp13_->err = _tmp15_;
#line 422 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_error_free0 (err);
#line 2514 "ThumbnailCache.c"
		}
		__finally249:
#line 422 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 422 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_background_job_unref0 (job);
#line 422 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 422 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			g_clear_error (&_inner_error_);
#line 422 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return;
#line 2527 "ThumbnailCache.c"
		}
	}
#line 429 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp16_ = job;
#line 429 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp17_ = _tmp16_->unscaled;
#line 429 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp17_ != NULL) {
#line 2536 "ThumbnailCache.c"
		ThumbnailCacheAsyncFetchJob* _tmp18_;
		gboolean _tmp19_;
#line 430 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp18_ = job;
#line 430 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp19_ = _tmp18_->fetched;
#line 430 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (_tmp19_) {
#line 2545 "ThumbnailCache.c"
			ThumbnailCacheAsyncFetchJob* _tmp20_;
			ThumbnailCache* _tmp21_;
			ThumbnailCacheAsyncFetchJob* _tmp22_;
			const gchar* _tmp23_;
			ThumbnailCacheAsyncFetchJob* _tmp24_;
			GdkPixbuf* _tmp25_;
			gint _tmp26_;
#line 432 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp20_ = job;
#line 432 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp21_ = _tmp20_->cache;
#line 432 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp22_ = job;
#line 432 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp23_ = _tmp22_->thumbnail_name;
#line 432 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp24_ = job;
#line 432 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp25_ = _tmp24_->unscaled;
#line 432 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			thumbnail_cache_store_in_memory (_tmp21_, _tmp23_, _tmp25_);
#line 434 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp26_ = thumbnail_cache_cycle_async_fetched_thumbnails;
#line 434 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			thumbnail_cache_cycle_async_fetched_thumbnails = _tmp26_ + 1;
#line 435 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			thumbnail_cache_schedule_debug ();
#line 2573 "ThumbnailCache.c"
		} else {
			gint _tmp27_;
#line 437 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp27_ = thumbnail_cache_cycle_async_resized_thumbnails;
#line 437 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			thumbnail_cache_cycle_async_resized_thumbnails = _tmp27_ + 1;
#line 438 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			thumbnail_cache_schedule_debug ();
#line 2582 "ThumbnailCache.c"
		}
	}
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp28_ = job;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp29_ = _tmp28_->callback;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp29__target = _tmp28_->callback_target;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp30_ = job;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp31_ = _tmp30_->scaled;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp32_ = job;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp33_ = _tmp32_->unscaled;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp34_ = job;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp35_ = _tmp34_->dim;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp36_ = job;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp37_ = _tmp36_->interp;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp38_ = job;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp39_ = _tmp38_->err;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp29_ (_tmp31_, _tmp33_, &_tmp35_, _tmp37_, _tmp39_, _tmp29__target);
#line 416 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_background_job_unref0 (job);
#line 2615 "ThumbnailCache.c"
}


static void
_thumbnail_cache_import_from_source (ThumbnailCache* self,
                                     ThumbnailSource* source,
                                     gboolean force,
                                     GError** error)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	LibraryPhoto* photo = NULL;
	LibraryPhoto* _tmp1_;
	GdkPixbuf* _tmp2_ = NULL;
	LibraryPhoto* _tmp3_;
	ThumbnailCacheSize _tmp4_;
	Scaling _tmp5_ = {0};
	GdkPixbuf* _tmp6_;
	GFile* _tmp7_;
	GError * _inner_error_ = NULL;
#line 445 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
#line 445 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 447 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = thumbnail_cache_get_source_cached_file (self, source);
#line 447 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	file = _tmp0_;
#line 451 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (!force) {
#line 452 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (_thumbnail_cache_exists (self, source)) {
#line 453 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_object_unref0 (file);
#line 453 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return;
#line 2652 "ThumbnailCache.c"
		}
	} else {
#line 456 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_thumbnail_cache_remove (self, source);
#line 2657 "ThumbnailCache.c"
	}
#line 459 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_LIBRARY_PHOTO, LibraryPhoto));
#line 459 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	photo = _tmp1_;
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = photo;
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = self->priv->size;
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	scaling_for_best_fit (thumbnail_cache_size_get_scale (_tmp4_), TRUE, &_tmp5_);
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp5_, &_inner_error_);
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = _tmp6_;
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (photo);
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (file);
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 2683 "ThumbnailCache.c"
	}
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7_ = file;
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_save_thumbnail (self, _tmp7_, _tmp2_, source, &_inner_error_);
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (_tmp2_);
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (photo);
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (file);
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 2701 "ThumbnailCache.c"
	}
#line 445 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp2_);
#line 445 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (photo);
#line 445 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (file);
#line 2709 "ThumbnailCache.c"
}


static void
_thumbnail_cache_import_thumbnail (ThumbnailCache* self,
                                   ThumbnailSource* source,
                                   GdkPixbuf* scaled,
                                   gboolean force,
                                   GError** error)
{
	Dimensions _tmp0_ = {0};
	ThumbnailCacheSize _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GError * _inner_error_ = NULL;
#line 466 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
#line 466 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 466 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail ((scaled == NULL) || GDK_IS_PIXBUF (scaled));
#line 468 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_vala_assert (scaled != NULL, "scaled != null");
#line 469 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	dimensions_for_pixbuf (scaled, &_tmp0_);
#line 469 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = self->priv->size;
#line 469 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_vala_assert (dimensions_approx_scaled (&_tmp0_, thumbnail_cache_size_get_scale (_tmp1_), 1), "Dimensions.for_pixbuf(scaled).approx_scaled(size.get_scale())");
#line 473 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (!force) {
#line 474 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (_thumbnail_cache_exists (self, source)) {
#line 475 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return;
#line 2745 "ThumbnailCache.c"
		}
	} else {
#line 478 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_thumbnail_cache_remove (self, source);
#line 2750 "ThumbnailCache.c"
	}
#line 481 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = thumbnail_cache_get_source_cached_file (self, source);
#line 481 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = _tmp2_;
#line 481 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_save_thumbnail (self, _tmp3_, scaled, source, &_inner_error_);
#line 481 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp3_);
#line 481 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 481 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 481 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 2766 "ThumbnailCache.c"
	}
}


static void
_thumbnail_cache_duplicate (ThumbnailCache* self,
                            ThumbnailSource* src_source,
                            ThumbnailSource* dest_source)
{
	GFile* src_file = NULL;
	GFile* _tmp0_;
	GFile* dest_file = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GError * _inner_error_ = NULL;
#line 488 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
#line 488 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (src_source));
#line 488 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (dest_source));
#line 489 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = thumbnail_cache_get_source_cached_file (self, src_source);
#line 489 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	src_file = _tmp0_;
#line 490 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_source_get_representative_id (dest_source);
#line 490 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = _tmp1_;
#line 490 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = thumbnail_cache_get_cached_file (self, _tmp2_, thumbnail_source_get_preferred_thumbnail_format (src_source));
#line 490 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = _tmp3_;
#line 490 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp2_);
#line 490 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	dest_file = _tmp4_;
#line 2806 "ThumbnailCache.c"
	{
#line 494 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_file_copy (src_file, dest_file, G_FILE_COPY_ALL_METADATA | G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
#line 494 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2812 "ThumbnailCache.c"
			goto __catch250_g_error;
		}
	}
	goto __finally250;
	__catch250_g_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
#line 493 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		err = _inner_error_;
#line 493 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_inner_error_ = NULL;
#line 496 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp5_ = err;
#line 496 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp6_ = _tmp5_->message;
#line 496 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp7_ = g_strdup_printf ("%s", _tmp6_);
#line 496 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp8_ = _tmp7_;
#line 496 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		app_window_panic (_tmp8_);
#line 496 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_free0 (_tmp8_);
#line 493 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_error_free0 (err);
#line 2842 "ThumbnailCache.c"
	}
	__finally250:
#line 493 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 493 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (dest_file);
#line 493 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (src_file);
#line 493 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 493 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_clear_error (&_inner_error_);
#line 493 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 2857 "ThumbnailCache.c"
	}
#line 488 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (dest_file);
#line 488 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (src_file);
#line 2863 "ThumbnailCache.c"
}


static void
_thumbnail_cache_replace (ThumbnailCache* self,
                          ThumbnailSource* source,
                          GdkPixbuf* original,
                          GError** error)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GdkPixbuf* scaled = NULL;
	ThumbnailCacheSize _tmp3_;
	GdkInterpType _tmp4_;
	GdkPixbuf* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError * _inner_error_ = NULL;
#line 502 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
#line 502 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 502 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (GDK_IS_PIXBUF (original));
#line 503 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = thumbnail_cache_get_source_cached_file (self, source);
#line 503 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	file = _tmp0_;
#line 506 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_SOURCE, DataSource));
#line 506 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = _tmp1_;
#line 506 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_remove_from_memory (self, _tmp2_);
#line 506 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp2_);
#line 509 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = self->priv->size;
#line 509 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = self->priv->interp;
#line 509 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = scale_pixbuf (original, thumbnail_cache_size_get_scale (_tmp3_), _tmp4_, TRUE);
#line 509 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	scaled = _tmp5_;
#line 512 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_save_thumbnail (self, file, scaled, source, &_inner_error_);
#line 512 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 512 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 512 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (scaled);
#line 512 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (file);
#line 512 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 2922 "ThumbnailCache.c"
	}
#line 518 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_SOURCE, DataSource));
#line 518 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7_ = _tmp6_;
#line 518 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_store_in_memory (self, _tmp7_, scaled);
#line 518 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp7_);
#line 502 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (scaled);
#line 502 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (file);
#line 2936 "ThumbnailCache.c"
}


static void
_thumbnail_cache_remove (ThumbnailCache* self,
                         ThumbnailSource* source)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
#line 521 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
#line 521 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 522 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = thumbnail_cache_get_source_cached_file (self, source);
#line 522 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	file = _tmp0_;
#line 525 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_SOURCE, DataSource));
#line 525 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = _tmp1_;
#line 525 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_remove_from_memory (self, _tmp2_);
#line 525 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp2_);
#line 2965 "ThumbnailCache.c"
	{
#line 529 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_file_delete (file, NULL, &_inner_error_);
#line 529 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2971 "ThumbnailCache.c"
			goto __catch251_g_error;
		}
	}
	goto __finally251;
	__catch251_g_error:
	{
		GError* err = NULL;
#line 528 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		err = _inner_error_;
#line 528 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_inner_error_ = NULL;
#line 528 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_error_free0 (err);
#line 2985 "ThumbnailCache.c"
	}
	__finally251:
#line 528 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 528 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (file);
#line 528 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 528 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_clear_error (&_inner_error_);
#line 528 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 2998 "ThumbnailCache.c"
	}
#line 521 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (file);
#line 3002 "ThumbnailCache.c"
}


static gboolean
_thumbnail_cache_exists (ThumbnailCache* self,
                         ThumbnailSource* source)
{
	gboolean result = FALSE;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_;
#line 535 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (self), FALSE);
#line 535 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), FALSE);
#line 536 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = thumbnail_cache_get_source_cached_file (self, source);
#line 536 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = _tmp0_;
#line 536 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = g_file_query_exists (_tmp1_, NULL);
#line 536 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp1_);
#line 536 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = _tmp2_;
#line 536 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 3030 "ThumbnailCache.c"
}


static GdkPixbuf*
thumbnail_cache_read_pixbuf (ThumbnailCache* self,
                             const gchar* thumbnail_name,
                             PhotoFileFormat format,
                             GError** error)
{
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	PhotoFileReader* _tmp5_;
	PhotoFileReader* _tmp6_;
	GdkPixbuf* _tmp7_;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* _tmp9_;
	GError * _inner_error_ = NULL;
#line 540 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (self), NULL);
#line 540 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (thumbnail_name != NULL, NULL);
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_cache_get_cached_file (self, thumbnail_name, format);
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = _tmp1_;
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = g_file_get_path (_tmp2_);
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = _tmp3_;
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = photo_file_format_create_reader (format, _tmp4_);
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = _tmp5_;
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7_ = photo_file_reader_unscaled_read (_tmp6_, &_inner_error_);
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp8_ = _tmp7_;
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_photo_file_adapter_unref0 (_tmp6_);
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp4_);
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp2_);
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = _tmp8_;
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return NULL;
#line 3086 "ThumbnailCache.c"
	}
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp9_ = _tmp0_;
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = NULL;
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = _tmp9_;
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp0_);
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 3098 "ThumbnailCache.c"
}


static GFile*
thumbnail_cache_get_source_cached_file (ThumbnailCache* self,
                                        ThumbnailSource* source)
{
	GFile* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
#line 545 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (self), NULL);
#line 545 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), NULL);
#line 546 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = thumbnail_source_get_representative_id (source);
#line 546 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = _tmp0_;
#line 546 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = thumbnail_cache_get_cached_file (self, _tmp1_, thumbnail_source_get_preferred_thumbnail_format (source));
#line 546 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = _tmp2_;
#line 546 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp1_);
#line 546 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = _tmp3_;
#line 546 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 3129 "ThumbnailCache.c"
}


static GFile*
thumbnail_cache_get_cached_file (ThumbnailCache* self,
                                 const gchar* thumbnail_name,
                                 PhotoFileFormat thumbnail_format)
{
	GFile* result = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
#line 550 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (self), NULL);
#line 550 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (thumbnail_name != NULL, NULL);
#line 551 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = self->priv->cache_dir;
#line 551 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = photo_file_format_get_default_basename (thumbnail_format, thumbnail_name);
#line 551 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = _tmp1_;
#line 551 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = g_file_get_child (_tmp0_, _tmp2_);
#line 551 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = _tmp3_;
#line 551 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp2_);
#line 551 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = _tmp4_;
#line 551 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 3164 "ThumbnailCache.c"
}


static GdkPixbuf*
thumbnail_cache_fetch_from_memory (ThumbnailCache* self,
                                   const gchar* thumbnail_name)
{
	GdkPixbuf* result = NULL;
	ThumbnailCacheImageData* data = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GdkPixbuf* _tmp2_ = NULL;
	ThumbnailCacheImageData* _tmp3_;
	GdkPixbuf* _tmp6_;
#line 554 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (self), NULL);
#line 554 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (thumbnail_name != NULL, NULL);
#line 555 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = self->priv->cache_map;
#line 555 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), thumbnail_name);
#line 555 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	data = (ThumbnailCacheImageData*) _tmp1_;
#line 557 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = data;
#line 557 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp3_ != NULL) {
#line 3193 "ThumbnailCache.c"
		ThumbnailCacheImageData* _tmp4_;
		GdkPixbuf* _tmp5_;
#line 557 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp4_ = data;
#line 557 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp5_ = _tmp4_->pixbuf;
#line 557 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp2_ = _tmp5_;
#line 3202 "ThumbnailCache.c"
	} else {
#line 557 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp2_ = NULL;
#line 3206 "ThumbnailCache.c"
	}
#line 557 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = _g_object_ref0 (_tmp2_);
#line 557 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = _tmp6_;
#line 557 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_image_data_unref0 (data);
#line 557 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 3216 "ThumbnailCache.c"
}


static void
thumbnail_cache_store_in_memory (ThumbnailCache* self,
                                 const gchar* thumbnail_name,
                                 GdkPixbuf* thumbnail)
{
	gulong _tmp0_;
	ThumbnailCacheImageData* data = NULL;
	ThumbnailCacheImageData* _tmp1_;
	ThumbnailCacheImageData* _tmp2_;
	gulong _tmp3_;
	GeeHashMap* _tmp4_;
	ThumbnailCacheImageData* _tmp5_;
	GeeArrayList* _tmp6_;
	gulong _tmp7_;
	ThumbnailCacheImageData* _tmp8_;
	gulong _tmp9_;
#line 560 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
#line 560 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (thumbnail_name != NULL);
#line 560 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (GDK_IS_PIXBUF (thumbnail));
#line 561 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = self->priv->max_cached_bytes;
#line 561 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp0_ <= ((gulong) 0)) {
#line 562 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 3248 "ThumbnailCache.c"
	}
#line 564 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_remove_from_memory (self, thumbnail_name);
#line 566 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_cache_image_data_new (thumbnail);
#line 566 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	data = _tmp1_;
#line 569 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = data;
#line 569 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = _tmp2_->bytes;
#line 569 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp3_ > ((gulong) THUMBNAIL_CACHE_MAX_INMEMORY_DATA_SIZE)) {
#line 570 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_debug ("ThumbnailCache.vala:570: Persistent thumbnail [%s] too large to cache " \
"in memory", thumbnail_name);
#line 572 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_thumbnail_cache_image_data_unref0 (data);
#line 572 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 3268 "ThumbnailCache.c"
	}
#line 575 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = self->priv->cache_map;
#line 575 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = data;
#line 575 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), thumbnail_name, _tmp5_);
#line 576 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = self->priv->cache_lru;
#line 576 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0, thumbnail_name);
#line 578 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7_ = self->priv->cached_bytes;
#line 578 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp8_ = data;
#line 578 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp9_ = _tmp8_->bytes;
#line 578 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv->cached_bytes = _tmp7_ + _tmp9_;
#line 581 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	while (TRUE) {
#line 3290 "ThumbnailCache.c"
		gulong _tmp10_;
		gulong _tmp11_;
		GeeArrayList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint index = 0;
		GeeArrayList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gchar* victim_name = NULL;
		GeeArrayList* _tmp18_;
		gint _tmp19_;
		gpointer _tmp20_;
		GeeArrayList* _tmp21_;
		gint _tmp22_;
		gpointer _tmp23_;
		gchar* _tmp24_;
		GeeHashMap* _tmp25_;
		const gchar* _tmp26_;
		gpointer _tmp27_;
		gint _tmp28_;
		gboolean removed = FALSE;
		GeeHashMap* _tmp29_;
		const gchar* _tmp30_;
		gboolean _tmp31_;
		gboolean _tmp32_;
		ThumbnailCacheImageData* _tmp33_;
		gulong _tmp34_;
		gulong _tmp35_;
		gulong _tmp36_;
		ThumbnailCacheImageData* _tmp37_;
		gulong _tmp38_;
#line 581 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp10_ = self->priv->cached_bytes;
#line 581 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp11_ = self->priv->max_cached_bytes;
#line 581 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (!(_tmp10_ > _tmp11_)) {
#line 581 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			break;
#line 3331 "ThumbnailCache.c"
		}
#line 582 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp12_ = self->priv->cache_lru;
#line 582 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp13_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 582 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp14_ = _tmp13_;
#line 582 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_vala_assert (_tmp14_ > 0, "cache_lru.size > 0");
#line 583 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp15_ = self->priv->cache_lru;
#line 583 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp16_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 583 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp17_ = _tmp16_;
#line 583 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		index = _tmp17_ - 1;
#line 585 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp18_ = self->priv->cache_lru;
#line 585 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp19_ = index;
#line 585 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp20_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp19_);
#line 585 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		victim_name = (gchar*) _tmp20_;
#line 586 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp21_ = self->priv->cache_lru;
#line 586 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp22_ = index;
#line 586 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp23_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp22_);
#line 586 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp24_ = (gchar*) _tmp23_;
#line 586 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_free0 (_tmp24_);
#line 588 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp25_ = self->priv->cache_map;
#line 588 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp26_ = victim_name;
#line 588 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp27_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp26_);
#line 588 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_thumbnail_cache_image_data_unref0 (data);
#line 588 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		data = (ThumbnailCacheImageData*) _tmp27_;
#line 590 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp28_ = thumbnail_cache_cycle_overflow_thumbnails;
#line 590 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		thumbnail_cache_cycle_overflow_thumbnails = _tmp28_ + 1;
#line 591 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		thumbnail_cache_schedule_debug ();
#line 593 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp29_ = self->priv->cache_map;
#line 593 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp30_ = victim_name;
#line 593 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp31_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp30_, NULL);
#line 593 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		removed = _tmp31_;
#line 594 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp32_ = removed;
#line 594 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_vala_assert (_tmp32_, "removed");
#line 596 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp33_ = data;
#line 596 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp34_ = _tmp33_->bytes;
#line 596 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp35_ = self->priv->cached_bytes;
#line 596 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_vala_assert (_tmp34_ <= _tmp35_, "data.bytes <= cached_bytes");
#line 597 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp36_ = self->priv->cached_bytes;
#line 597 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp37_ = data;
#line 597 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp38_ = _tmp37_->bytes;
#line 597 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		self->priv->cached_bytes = _tmp36_ - _tmp38_;
#line 581 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_free0 (victim_name);
#line 3413 "ThumbnailCache.c"
	}
#line 560 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_image_data_unref0 (data);
#line 3417 "ThumbnailCache.c"
}


static gboolean
thumbnail_cache_remove_from_memory (ThumbnailCache* self,
                                    const gchar* thumbnail_name)
{
	gboolean result = FALSE;
	ThumbnailCacheImageData* data = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	ThumbnailCacheImageData* _tmp2_;
	gulong _tmp3_;
	ThumbnailCacheImageData* _tmp4_;
	gulong _tmp5_;
	gulong _tmp6_;
	ThumbnailCacheImageData* _tmp7_;
	gulong _tmp8_;
	gboolean removed = FALSE;
	GeeHashMap* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GeeArrayList* _tmp12_;
	gboolean _tmp13_;
#line 601 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (self), FALSE);
#line 601 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (thumbnail_name != NULL, FALSE);
#line 602 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = self->priv->cache_map;
#line 602 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), thumbnail_name);
#line 602 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	data = (ThumbnailCacheImageData*) _tmp1_;
#line 603 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = data;
#line 603 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp2_ == NULL) {
#line 604 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		result = FALSE;
#line 604 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_thumbnail_cache_image_data_unref0 (data);
#line 604 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return result;
#line 3462 "ThumbnailCache.c"
	}
#line 606 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = self->priv->cached_bytes;
#line 606 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = data;
#line 606 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = _tmp4_->bytes;
#line 606 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_vala_assert (_tmp3_ >= _tmp5_, "cached_bytes >= data.bytes");
#line 607 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = self->priv->cached_bytes;
#line 607 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7_ = data;
#line 607 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp8_ = _tmp7_->bytes;
#line 607 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv->cached_bytes = _tmp6_ - _tmp8_;
#line 610 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp9_ = self->priv->cache_map;
#line 610 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp10_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), thumbnail_name, NULL);
#line 610 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	removed = _tmp10_;
#line 611 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp11_ = removed;
#line 611 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_vala_assert (_tmp11_, "removed");
#line 614 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp12_ = self->priv->cache_lru;
#line 614 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	removed = gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), thumbnail_name);
#line 615 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp13_ = removed;
#line 615 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_vala_assert (_tmp13_, "removed");
#line 617 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = TRUE;
#line 617 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_image_data_unref0 (data);
#line 617 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 3504 "ThumbnailCache.c"
}


static void
thumbnail_cache_save_thumbnail (ThumbnailCache* self,
                                GFile* file,
                                GdkPixbuf* pixbuf,
                                ThumbnailSource* source,
                                GError** error)
{
	PhotoFileWriter* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	PhotoFileWriter* _tmp3_;
	PhotoFileWriter* _tmp4_;
	GError * _inner_error_ = NULL;
#line 620 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
#line 620 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 620 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 620 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = g_file_get_path (file);
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = _tmp1_;
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = photo_file_format_create_writer (thumbnail_source_get_preferred_thumbnail_format (source), _tmp2_, &_inner_error_);
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = _tmp3_;
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp2_);
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = _tmp4_;
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 3547 "ThumbnailCache.c"
	}
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	photo_file_writer_write (_tmp0_, pixbuf, THUMBNAIL_CACHE_DEFAULT_QUALITY, &_inner_error_);
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_photo_file_adapter_unref0 (_tmp0_);
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 3559 "ThumbnailCache.c"
	}
#line 620 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_photo_file_adapter_unref0 (_tmp0_);
#line 3563 "ThumbnailCache.c"
}


static ThumbnailCacheImageData*
thumbnail_cache_image_data_construct (GType object_type,
                                      GdkPixbuf* pixbuf)
{
	ThumbnailCacheImageData* self = NULL;
	GdkPixbuf* _tmp0_;
#line 63 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (GDK_IS_PIXBUF (pixbuf), NULL);
#line 63 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self = (ThumbnailCacheImageData*) g_type_create_instance (object_type);
#line 64 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = _g_object_ref0 (pixbuf);
#line 64 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->pixbuf);
#line 64 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->pixbuf = _tmp0_;
#line 68 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->bytes = ((gulong) gdk_pixbuf_get_rowstride (pixbuf)) * ((gulong) gdk_pixbuf_get_height (pixbuf));
#line 63 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return self;
#line 3587 "ThumbnailCache.c"
}


static ThumbnailCacheImageData*
thumbnail_cache_image_data_new (GdkPixbuf* pixbuf)
{
#line 63 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return thumbnail_cache_image_data_construct (THUMBNAIL_CACHE_TYPE_IMAGE_DATA, pixbuf);
#line 3596 "ThumbnailCache.c"
}


static void
thumbnail_cache_value_image_data_init (GValue* value)
{
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	value->data[0].v_pointer = NULL;
#line 3605 "ThumbnailCache.c"
}


static void
thumbnail_cache_value_image_data_free_value (GValue* value)
{
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (value->data[0].v_pointer) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		thumbnail_cache_image_data_unref (value->data[0].v_pointer);
#line 3616 "ThumbnailCache.c"
	}
}


static void
thumbnail_cache_value_image_data_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (src_value->data[0].v_pointer) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		dest_value->data[0].v_pointer = thumbnail_cache_image_data_ref (src_value->data[0].v_pointer);
#line 3629 "ThumbnailCache.c"
	} else {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3633 "ThumbnailCache.c"
	}
}


static gpointer
thumbnail_cache_value_image_data_peek_pointer (const GValue* value)
{
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return value->data[0].v_pointer;
#line 3643 "ThumbnailCache.c"
}


static gchar*
thumbnail_cache_value_image_data_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (collect_values[0].v_pointer) {
#line 3655 "ThumbnailCache.c"
		ThumbnailCacheImageData * object;
		object = collect_values[0].v_pointer;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (object->parent_instance.g_class == NULL) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3662 "ThumbnailCache.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3666 "ThumbnailCache.c"
		}
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = thumbnail_cache_image_data_ref (object);
#line 3670 "ThumbnailCache.c"
	} else {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = NULL;
#line 3674 "ThumbnailCache.c"
	}
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return NULL;
#line 3678 "ThumbnailCache.c"
}


static gchar*
thumbnail_cache_value_image_data_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	ThumbnailCacheImageData ** object_p;
	object_p = collect_values[0].v_pointer;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (!object_p) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3694 "ThumbnailCache.c"
	}
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (!value->data[0].v_pointer) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		*object_p = NULL;
#line 3700 "ThumbnailCache.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		*object_p = value->data[0].v_pointer;
#line 3704 "ThumbnailCache.c"
	} else {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		*object_p = thumbnail_cache_image_data_ref (value->data[0].v_pointer);
#line 3708 "ThumbnailCache.c"
	}
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return NULL;
#line 3712 "ThumbnailCache.c"
}


static GParamSpec*
thumbnail_cache_param_spec_image_data (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	ThumbnailCacheParamSpecImageData* spec;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (g_type_is_a (object_type, THUMBNAIL_CACHE_TYPE_IMAGE_DATA), NULL);
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return G_PARAM_SPEC (spec);
#line 3732 "ThumbnailCache.c"
}


static gpointer
thumbnail_cache_value_get_image_data (const GValue* value)
{
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, THUMBNAIL_CACHE_TYPE_IMAGE_DATA), NULL);
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return value->data[0].v_pointer;
#line 3743 "ThumbnailCache.c"
}


static void
thumbnail_cache_value_set_image_data (GValue* value,
                                      gpointer v_object)
{
	ThumbnailCacheImageData * old;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, THUMBNAIL_CACHE_TYPE_IMAGE_DATA));
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	old = value->data[0].v_pointer;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (v_object) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, THUMBNAIL_CACHE_TYPE_IMAGE_DATA));
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = v_object;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		thumbnail_cache_image_data_ref (value->data[0].v_pointer);
#line 3766 "ThumbnailCache.c"
	} else {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = NULL;
#line 3770 "ThumbnailCache.c"
	}
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (old) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		thumbnail_cache_image_data_unref (old);
#line 3776 "ThumbnailCache.c"
	}
}


static void
thumbnail_cache_value_take_image_data (GValue* value,
                                       gpointer v_object)
{
	ThumbnailCacheImageData * old;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, THUMBNAIL_CACHE_TYPE_IMAGE_DATA));
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	old = value->data[0].v_pointer;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (v_object) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, THUMBNAIL_CACHE_TYPE_IMAGE_DATA));
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = v_object;
#line 3798 "ThumbnailCache.c"
	} else {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = NULL;
#line 3802 "ThumbnailCache.c"
	}
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (old) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		thumbnail_cache_image_data_unref (old);
#line 3808 "ThumbnailCache.c"
	}
}


static void
thumbnail_cache_image_data_class_init (ThumbnailCacheImageDataClass * klass)
{
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_image_data_parent_class = g_type_class_peek_parent (klass);
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	((ThumbnailCacheImageDataClass *) klass)->finalize = thumbnail_cache_image_data_finalize;
#line 3820 "ThumbnailCache.c"
}


static void
thumbnail_cache_image_data_instance_init (ThumbnailCacheImageData * self)
{
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->ref_count = 1;
#line 3829 "ThumbnailCache.c"
}


static void
thumbnail_cache_image_data_finalize (ThumbnailCacheImageData * obj)
{
	ThumbnailCacheImageData * self;
	gulong _tmp0_;
	gulong _tmp1_;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, THUMBNAIL_CACHE_TYPE_IMAGE_DATA, ThumbnailCacheImageData);
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_signal_handlers_destroy (self);
#line 72 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = thumbnail_cache_cycle_dropped_bytes;
#line 72 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = self->bytes;
#line 72 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_cycle_dropped_bytes = _tmp0_ + _tmp1_;
#line 73 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_schedule_debug ();
#line 60 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->pixbuf);
#line 3853 "ThumbnailCache.c"
}


static GType
thumbnail_cache_image_data_get_type (void)
{
	static volatile gsize thumbnail_cache_image_data_type_id__volatile = 0;
	if (g_once_init_enter (&thumbnail_cache_image_data_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { thumbnail_cache_value_image_data_init, thumbnail_cache_value_image_data_free_value, thumbnail_cache_value_image_data_copy_value, thumbnail_cache_value_image_data_peek_pointer, "p", thumbnail_cache_value_image_data_collect_value, "p", thumbnail_cache_value_image_data_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ThumbnailCacheImageDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnail_cache_image_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThumbnailCacheImageData), 0, (GInstanceInitFunc) thumbnail_cache_image_data_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType thumbnail_cache_image_data_type_id;
		thumbnail_cache_image_data_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ThumbnailCacheImageData", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&thumbnail_cache_image_data_type_id__volatile, thumbnail_cache_image_data_type_id);
	}
	return thumbnail_cache_image_data_type_id__volatile;
}


static gpointer
thumbnail_cache_image_data_ref (gpointer instance)
{
	ThumbnailCacheImageData * self;
	self = instance;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_atomic_int_inc (&self->ref_count);
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return instance;
#line 3882 "ThumbnailCache.c"
}


static void
thumbnail_cache_image_data_unref (gpointer instance)
{
	ThumbnailCacheImageData * self;
	self = instance;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		THUMBNAIL_CACHE_IMAGE_DATA_GET_CLASS (self)->finalize (self);
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3897 "ThumbnailCache.c"
	}
}


static void
_thumbnail_cache_async_fetch_completion_callback_completion_callback (BackgroundJob* job,
                                                                      gpointer self)
{
#line 94 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_async_fetch_completion_callback (job);
#line 3908 "ThumbnailCache.c"
}


static ThumbnailCacheAsyncFetchJob*
thumbnail_cache_async_fetch_job_construct (GType object_type,
                                           ThumbnailCache* cache,
                                           const gchar* thumbnail_name,
                                           ThumbnailSource* source,
                                           GdkPixbuf* prefetched,
                                           Dimensions* dim,
                                           GdkInterpType interp,
                                           ThumbnailCacheAsyncFetchCallback callback,
                                           void* callback_target,
                                           GCancellable* cancellable)
{
	ThumbnailCacheAsyncFetchJob* self = NULL;
	ThumbnailCache* _tmp0_;
	gchar* _tmp1_;
	ThumbnailSource* _tmp2_;
	GdkPixbuf* _tmp3_;
	Dimensions _tmp4_;
#line 91 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (cache), NULL);
#line 91 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (thumbnail_name != NULL, NULL);
#line 91 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), NULL);
#line 91 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail ((prefetched == NULL) || GDK_IS_PIXBUF (prefetched), NULL);
#line 91 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (dim != NULL, NULL);
#line 91 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail ((cancellable == NULL) || G_IS_CANCELLABLE (cancellable), NULL);
#line 94 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self = (ThumbnailCacheAsyncFetchJob*) background_job_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (cache, G_TYPE_OBJECT, GObject), _thumbnail_cache_async_fetch_completion_callback_completion_callback, NULL, cancellable, NULL, NULL, NULL);
#line 96 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = _g_object_ref0 (cache);
#line 96 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->cache);
#line 96 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->cache = _tmp0_;
#line 97 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = g_strdup (thumbnail_name);
#line 97 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (self->thumbnail_name);
#line 97 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->thumbnail_name = _tmp1_;
#line 98 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = _g_object_ref0 (source);
#line 98 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->source);
#line 98 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->source = _tmp2_;
#line 99 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->source_format = thumbnail_source_get_preferred_thumbnail_format (source);
#line 100 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = _g_object_ref0 (prefetched);
#line 100 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->unscaled);
#line 100 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->unscaled = _tmp3_;
#line 101 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = *dim;
#line 101 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->dim = _tmp4_;
#line 102 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->interp = interp;
#line 103 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->callback = callback;
#line 103 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->callback_target = callback_target;
#line 91 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return self;
#line 3982 "ThumbnailCache.c"
}


static ThumbnailCacheAsyncFetchJob*
thumbnail_cache_async_fetch_job_new (ThumbnailCache* cache,
                                     const gchar* thumbnail_name,
                                     ThumbnailSource* source,
                                     GdkPixbuf* prefetched,
                                     Dimensions* dim,
                                     GdkInterpType interp,
                                     ThumbnailCacheAsyncFetchCallback callback,
                                     void* callback_target,
                                     GCancellable* cancellable)
{
#line 91 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return thumbnail_cache_async_fetch_job_construct (THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, cache, thumbnail_name, source, prefetched, dim, interp, callback, callback_target, cancellable);
#line 3999 "ThumbnailCache.c"
}


static BackgroundJobJobPriority
thumbnail_cache_async_fetch_job_real_get_priority (BackgroundJob* base)
{
	ThumbnailCacheAsyncFetchJob * self;
	BackgroundJobJobPriority result = 0;
	GdkInterpType _tmp0_;
#line 106 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJob);
#line 109 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = self->interp;
#line 109 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	switch (_tmp0_) {
#line 109 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		case GDK_INTERP_NEAREST:
#line 109 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		case GDK_INTERP_TILES:
#line 4019 "ThumbnailCache.c"
		{
#line 112 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			result = BACKGROUND_JOB_JOB_PRIORITY_HIGH;
#line 112 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return result;
#line 4025 "ThumbnailCache.c"
		}
		default:
#line 109 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		case GDK_INTERP_BILINEAR:
#line 109 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		case GDK_INTERP_HYPER:
#line 4032 "ThumbnailCache.c"
		{
#line 117 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			result = BACKGROUND_JOB_JOB_PRIORITY_NORMAL;
#line 117 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return result;
#line 4038 "ThumbnailCache.c"
		}
	}
}


static void
thumbnail_cache_async_fetch_job_real_execute (BackgroundJob* base)
{
	ThumbnailCacheAsyncFetchJob * self;
	GError * _inner_error_ = NULL;
#line 121 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJob);
#line 4051 "ThumbnailCache.c"
	{
		GdkPixbuf* _tmp0_;
		GdkPixbuf* _tmp7_ = NULL;
		GdkPixbuf* _tmp14_;
#line 124 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp0_ = self->unscaled;
#line 124 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (_tmp0_ == NULL) {
#line 4060 "ThumbnailCache.c"
			GdkPixbuf* _tmp1_ = NULL;
			ThumbnailCache* _tmp2_;
			const gchar* _tmp3_;
			PhotoFileFormat _tmp4_;
			GdkPixbuf* _tmp5_;
			GdkPixbuf* _tmp6_;
#line 125 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp2_ = self->cache;
#line 125 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp3_ = self->thumbnail_name;
#line 125 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp4_ = self->source_format;
#line 125 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp5_ = thumbnail_cache_read_pixbuf (_tmp2_, _tmp3_, _tmp4_, &_inner_error_);
#line 125 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp1_ = _tmp5_;
#line 125 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4079 "ThumbnailCache.c"
				goto __catch252_g_error;
			}
#line 125 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp6_ = _tmp1_;
#line 125 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp1_ = NULL;
#line 125 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_object_unref0 (self->unscaled);
#line 125 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			self->unscaled = _tmp6_;
#line 126 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			self->fetched = TRUE;
#line 124 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_object_unref0 (_tmp1_);
#line 4094 "ThumbnailCache.c"
		}
#line 129 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (background_job_is_cancelled (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BACKGROUND_JOB, BackgroundJob))) {
#line 130 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return;
#line 4100 "ThumbnailCache.c"
		}
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (dimensions_has_area (&self->dim)) {
#line 4104 "ThumbnailCache.c"
			GdkPixbuf* _tmp8_;
			Dimensions _tmp9_;
			GdkInterpType _tmp10_;
			GdkPixbuf* _tmp11_;
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp8_ = self->unscaled;
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp9_ = self->dim;
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp10_ = self->interp;
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp11_ = resize_pixbuf (_tmp8_, &_tmp9_, _tmp10_);
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_object_unref0 (_tmp7_);
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp7_ = _tmp11_;
#line 4121 "ThumbnailCache.c"
		} else {
			GdkPixbuf* _tmp12_;
			GdkPixbuf* _tmp13_;
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp12_ = self->unscaled;
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp13_ = _g_object_ref0 (_tmp12_);
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_object_unref0 (_tmp7_);
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp7_ = _tmp13_;
#line 4133 "ThumbnailCache.c"
		}
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp14_ = _g_object_ref0 (_tmp7_);
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (self->scaled);
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		self->scaled = _tmp14_;
#line 122 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (_tmp7_);
#line 4143 "ThumbnailCache.c"
	}
	goto __finally252;
	__catch252_g_error:
	{
		GError* err = NULL;
		GError* _tmp15_;
#line 122 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		err = _inner_error_;
#line 122 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_inner_error_ = NULL;
#line 135 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp15_ = err;
#line 135 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (_tmp15_->domain == G_FILE_ERROR) {
#line 4158 "ThumbnailCache.c"
			{
#line 137 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				thumbnail_cache_async_fetch_job_generate_thumbnail (self, &_inner_error_);
#line 137 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4164 "ThumbnailCache.c"
					goto __catch253_g_error;
				}
			}
			goto __finally253;
			__catch253_g_error:
			{
				GError* generr = NULL;
				GError* _tmp16_;
				GError* _tmp17_;
#line 136 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				generr = _inner_error_;
#line 136 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_inner_error_ = NULL;
#line 140 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp16_ = generr;
#line 140 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp17_ = _g_error_copy0 (_tmp16_);
#line 140 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_g_error_free0 (err);
#line 140 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				err = _tmp17_;
#line 136 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_g_error_free0 (generr);
#line 4188 "ThumbnailCache.c"
			}
			__finally253:
#line 136 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 136 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_g_error_free0 (err);
#line 136 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_g_error_free0 (err);
#line 136 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 136 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				g_clear_error (&_inner_error_);
#line 136 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				return;
#line 4203 "ThumbnailCache.c"
			}
		} else {
			GError* _tmp18_;
			GError* _tmp19_;
#line 144 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp18_ = err;
#line 144 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp19_ = _g_error_copy0 (_tmp18_);
#line 144 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_error_free0 (self->err);
#line 144 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			self->err = _tmp19_;
#line 4216 "ThumbnailCache.c"
		}
#line 122 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_error_free0 (err);
#line 4220 "ThumbnailCache.c"
	}
	__finally252:
#line 122 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 122 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 122 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_clear_error (&_inner_error_);
#line 122 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 4231 "ThumbnailCache.c"
	}
}


static void
thumbnail_cache_async_fetch_job_generate_thumbnail (ThumbnailCacheAsyncFetchJob* self,
                                                    GError** error)
{
	Photo* photo = NULL;
	ThumbnailSource* _tmp0_;
	Photo* _tmp1_;
	Photo* _tmp2_;
	GdkPixbuf* _tmp19_;
	GError * _inner_error_ = NULL;
#line 149 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (THUMBNAIL_CACHE_IS_ASYNC_FETCH_JOB (self));
#line 150 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = self->source;
#line 150 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_PHOTO) ? ((Photo*) _tmp0_) : NULL);
#line 150 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	photo = _tmp1_;
#line 151 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = photo;
#line 151 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp2_ != NULL) {
#line 4258 "ThumbnailCache.c"
		GdkPixbuf* _tmp3_ = NULL;
		Photo* _tmp4_;
		Dimensions _tmp5_;
		gint _tmp6_;
		Scaling _tmp7_ = {0};
		GdkPixbuf* _tmp8_;
		GdkPixbuf* _tmp9_;
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp4_ = photo;
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp5_ = self->dim;
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp6_ = _tmp5_.width;
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		scaling_for_best_fit (_tmp6_, TRUE, &_tmp7_);
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp8_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp7_, &_inner_error_);
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp3_ = _tmp8_;
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			g_propagate_error (error, _inner_error_);
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_object_unref0 (photo);
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return;
#line 4286 "ThumbnailCache.c"
		}
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp9_ = _tmp3_;
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp3_ = NULL;
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (self->unscaled);
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		self->unscaled = _tmp9_;
#line 151 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (_tmp3_);
#line 4298 "ThumbnailCache.c"
	} else {
		Video* video = NULL;
		ThumbnailSource* _tmp10_;
		Video* _tmp11_;
		Video* _tmp12_;
#line 154 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp10_ = self->source;
#line 154 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, TYPE_VIDEO) ? ((Video*) _tmp10_) : NULL);
#line 154 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		video = _tmp11_;
#line 155 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp12_ = video;
#line 155 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (_tmp12_ != NULL) {
#line 4314 "ThumbnailCache.c"
			GdkPixbuf* _tmp13_ = NULL;
			Video* _tmp14_;
			Dimensions _tmp15_;
			gint _tmp16_;
			GdkPixbuf* _tmp17_;
			GdkPixbuf* _tmp18_;
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp14_ = video;
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp15_ = self->dim;
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp16_ = _tmp15_.width;
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp17_ = thumbnail_source_create_thumbnail (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), _tmp16_, &_inner_error_);
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp13_ = _tmp17_;
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				g_propagate_error (error, _inner_error_);
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_g_object_unref0 (video);
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_g_object_unref0 (photo);
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				return;
#line 4341 "ThumbnailCache.c"
			}
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp18_ = _tmp13_;
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp13_ = NULL;
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_object_unref0 (self->unscaled);
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			self->unscaled = _tmp18_;
#line 155 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_object_unref0 (_tmp13_);
#line 4353 "ThumbnailCache.c"
		}
#line 151 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (video);
#line 4357 "ThumbnailCache.c"
	}
#line 159 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp19_ = self->unscaled;
#line 159 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp19_ != NULL) {
#line 4363 "ThumbnailCache.c"
		GdkPixbuf* _tmp20_;
		Dimensions _tmp21_;
		GdkInterpType _tmp22_;
		GdkPixbuf* _tmp23_;
#line 160 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp20_ = self->unscaled;
#line 160 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp21_ = self->dim;
#line 160 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp22_ = self->interp;
#line 160 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp23_ = resize_pixbuf (_tmp20_, &_tmp21_, _tmp22_);
#line 160 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (self->scaled);
#line 160 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		self->scaled = _tmp23_;
#line 161 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		self->replace = TRUE;
#line 4382 "ThumbnailCache.c"
	}
#line 149 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (photo);
#line 4386 "ThumbnailCache.c"
}


static void
thumbnail_cache_async_fetch_job_class_init (ThumbnailCacheAsyncFetchJobClass * klass)
{
#line 77 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_async_fetch_job_parent_class = g_type_class_peek_parent (klass);
#line 77 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	((BackgroundJobClass *) klass)->finalize = thumbnail_cache_async_fetch_job_finalize;
#line 77 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	((BackgroundJobClass *) klass)->get_priority = (BackgroundJobJobPriority (*) (BackgroundJob *)) thumbnail_cache_async_fetch_job_real_get_priority;
#line 77 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob *)) thumbnail_cache_async_fetch_job_real_execute;
#line 4401 "ThumbnailCache.c"
}


static void
thumbnail_cache_async_fetch_job_instance_init (ThumbnailCacheAsyncFetchJob * self)
{
#line 86 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->scaled = NULL;
#line 87 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->err = NULL;
#line 88 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->fetched = FALSE;
#line 89 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->replace = FALSE;
#line 4416 "ThumbnailCache.c"
}


static void
thumbnail_cache_async_fetch_job_finalize (BackgroundJob * obj)
{
	ThumbnailCacheAsyncFetchJob * self;
#line 77 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJob);
#line 78 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->cache);
#line 79 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (self->thumbnail_name);
#line 80 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->source);
#line 85 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->unscaled);
#line 86 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->scaled);
#line 87 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_error_free0 (self->err);
#line 77 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	BACKGROUND_JOB_CLASS (thumbnail_cache_async_fetch_job_parent_class)->finalize (obj);
#line 4440 "ThumbnailCache.c"
}


static GType
thumbnail_cache_async_fetch_job_get_type (void)
{
	static volatile gsize thumbnail_cache_async_fetch_job_type_id__volatile = 0;
	if (g_once_init_enter (&thumbnail_cache_async_fetch_job_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ThumbnailCacheAsyncFetchJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnail_cache_async_fetch_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThumbnailCacheAsyncFetchJob), 0, (GInstanceInitFunc) thumbnail_cache_async_fetch_job_instance_init, NULL };
		GType thumbnail_cache_async_fetch_job_type_id;
		thumbnail_cache_async_fetch_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "ThumbnailCacheAsyncFetchJob", &g_define_type_info, 0);
		g_once_init_leave (&thumbnail_cache_async_fetch_job_type_id__volatile, thumbnail_cache_async_fetch_job_type_id);
	}
	return thumbnail_cache_async_fetch_job_type_id__volatile;
}


static void
thumbnail_cache_class_init (ThumbnailCacheClass * klass)
{
	ThumbnailCacheSize* _tmp0_;
#line 27 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_parent_class = g_type_class_peek_parent (klass);
#line 27 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_type_class_add_private (klass, sizeof (ThumbnailCachePrivate));
#line 27 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	G_OBJECT_CLASS (klass)->finalize = thumbnail_cache_finalize;
#line 54 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = g_new0 (ThumbnailCacheSize, 2);
#line 54 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_[0] = THUMBNAIL_CACHE_SIZE_BIG;
#line 54 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_[1] = THUMBNAIL_CACHE_SIZE_MEDIUM;
#line 54 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_ALL_SIZES = _tmp0_;
#line 54 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_ALL_SIZES_length1 = 2;
#line 4478 "ThumbnailCache.c"
}


static void
thumbnail_cache_instance_init (ThumbnailCache * self)
{
	GeeHashMap* _tmp0_;
	GeeArrayList* _tmp1_;
#line 27 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv = THUMBNAIL_CACHE_GET_PRIVATE (self);
#line 186 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, THUMBNAIL_CACHE_TYPE_IMAGE_DATA, (GBoxedCopyFunc) thumbnail_cache_image_data_ref, (GDestroyNotify) thumbnail_cache_image_data_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 186 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv->cache_map = _tmp0_;
#line 187 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 187 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv->cache_lru = _tmp1_;
#line 188 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv->cached_bytes = (gulong) 0;
#line 4499 "ThumbnailCache.c"
}


static void
thumbnail_cache_finalize (GObject * obj)
{
	ThumbnailCache * self;
#line 27 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THUMBNAIL_CACHE, ThumbnailCache);
#line 181 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->priv->cache_dir);
#line 186 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->priv->cache_map);
#line 187 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->priv->cache_lru);
#line 27 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	G_OBJECT_CLASS (thumbnail_cache_parent_class)->finalize (obj);
#line 4517 "ThumbnailCache.c"
}


GType
thumbnail_cache_get_type (void)
{
	static volatile gsize thumbnail_cache_type_id__volatile = 0;
	if (g_once_init_enter (&thumbnail_cache_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ThumbnailCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnail_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThumbnailCache), 0, (GInstanceInitFunc) thumbnail_cache_instance_init, NULL };
		GType thumbnail_cache_type_id;
		thumbnail_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "ThumbnailCache", &g_define_type_info, 0);
		g_once_init_leave (&thumbnail_cache_type_id__volatile, thumbnail_cache_type_id);
	}
	return thumbnail_cache_type_id__volatile;
}



